

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetAllUtilityClasses.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetAllUtilityClasses.sp,v $ $Id: WFGetAllUtilityClasses.sp,v 1.8.200.1 2018/03/27 08:06:22 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets schema definitions based on a namespace
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetAllUtilityClasses <<<'

IF EXISTS (select * from sysobjects where name='WFGetAllUtilityClasses')
	drop procedure WFGetAllUtilityClasses
IF EXISTS (select * from GxQscripts where name='WFGetAllUtilityClasses')
	delete from GxQscripts where name = 'WFGetAllUtilityClasses'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetAllUtilityClasses')
	delete from GXDBVersions where aliasname = 'WFGetAllUtilityClasses'
GO
print '... Creating Procedure: WFGetAllUtilityClasses'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetAllUtilityClasses
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
SET @o_xmlText = (
	SELECT	s.ImportType '@importType',
			s.UtilityId 'workflowUtility/@utilityId',
			s.ClassName 'workflowUtility/@className',
			(SELECT 	a.LocationId '@schemaLocationId',
						a.LocationUrl '@schemaLocationUrl'
				 FROM WF_SchemaLocation a
				 WHERE a.LocationId = s.LocationId
				 FOR XML PATH('location'), TYPE)
	FROM WF_Utility s
	FOR XML PATH('utilities'), ROOT('Workflow_GetAllWorkflowUtilitiesResponse'))
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_GetAllWorkflowUtilitiesResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetAllUtilityClasses')
	delete from GxQscripts where name = 'WFGetAllUtilityClasses'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetAllUtilityClasses')
	delete from GXDBVersions where aliasname = 'WFGetAllUtilityClasses'
GO

insert into GXDBVersions values(2, 'WFGetAllUtilityClasses',  '00010008020000010000', 'WFGetAllUtilityClasses', '00010008020000010000')
GO

