

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetAllActivitySets.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetAllActivitySets.sp,v $ $Id: WFGetAllActivitySets.sp,v 1.39.74.2 2018/03/27 08:11:04 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets all the workflow activity sets
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetAllActivitySets <<<'

IF EXISTS (select * from sysobjects where name='WFGetAllActivitySets')
	drop procedure WFGetAllActivitySets
IF EXISTS (select * from GxQscripts where name='WFGetAllActivitySets')
	delete from GxQscripts where name = 'WFGetAllActivitySets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetAllActivitySets')
	delete from GXDBVersions where aliasname = 'WFGetAllActivitySets'
GO
print '... Creating Procedure: WFGetAllActivitySets'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetAllActivitySets
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @userId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @populateActivities bit
SET @populateActivities = ISNULL((SELECT ref.value('@populateActivities', 'BIT') FROM @i_xmlText.nodes('Workflow_GetAllActivitySetsRequest') R ( ref ) ), 0)
IF ( @userId = 0 OR @userId IS null )
BEGIN
	SET @o_errorCode = -1
	SET	@o_errorString = 'User not provided'
	GOTO FINISH
END
DECLARE @activityList TABLE (
	[ActivityId] [int] NOT NULL,
	[ActivitySetId] [int] NOT NULL,
	[Name] [nvarchar](255) NOT NULL,
	[DisplayName] [nvarchar](255) NULL,
	[Description] [nvarchar](max) NULL,
	[Class] [nvarchar](255) NULL,
	[Operation] [nvarchar](255) NULL,
	[CellClass] [nvarchar](255) NULL,
	[InputEditor] [nvarchar](255) NULL,
	[Definition] [nvarchar](max) NULL,
	[Icon] [nvarchar](max) NULL,
	[ActivityImage] [nvarchar](max) NULL,
	[SchemaFile] [nvarchar](max) NULL,
	[SchemaId] [int] NOT NULL,
	[Inbound] [tinyint] NOT NULL,
	[Outbound] [tinyint] NOT NULL,
	[SchemaNamespace] [nvarchar](255) NOT NULL,
	[ActivityLocationId] [int] NOT NULL,
	[ActivityLocationUrl] [nvarchar](255) NOT NULL,
	[ActivityLocationType] [int] NOT NULL,
	[serviceUrl] [nvarchar](255) NULL
)
IF (@populateActivities = 1)
BEGIN
	IF object_id('tempdb.dbo.#WFGetAllActivitySets_UserObjects') is not null DROP TABLE #WFGetAllActivitySets_UserObjects
create table  #WFGetAllActivitySets_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 14033, 0, '#WFGetAllActivitySets_UserObjects'
	DECLARE @workflowActivities TABLE (t_workflowId int, t_activityId int)
	INSERT @workflowActivities
	SELECT d.WorkflowId, d.ActivityId
	FROM WF_Definition d
	INNER JOIN #WFGetAllActivitySets_UserObjects c ON d.WorkflowId = c.WorkflowId
IF EXISTS (SELECT * FROM #WFGetAllActivitySets_UserObjects WHERE CommCellId = 2 AND (Capabilities & power(2, 31-1) > 0))
	BEGIN
		INSERT @workflowActivities
		SELECT d.WorkflowId, d.ActivityId
		FROM WF_Definition d
		WHERE d.WorkflowId NOT IN (Select t_workflowId FROM @workflowActivities)
	END
	INSERT INTO @activityList
	SELECT	a.ActivityId,
			ISNULL(g.ActivitySetId, 0) As ActivitySetId,
			a.Name,
			a.DisplayName,
			a.Description,
			a.Class,
			a.Operation,
			a.CellClass,
			a.InputEditor,
			a.Definition,
			a.Icon,
			a.ActivityImage,
			a.SchemaFile,
			s.SchemaId,
			a.Inbound,
			a.Outbound,
			s.Namespace,
			l.LocationId,
			l.LocationUrl,
			l.LocationType,
			l.serviceUrl
	FROM WF_Activity a
	LEFT OUTER JOIN WF_Schema s ON a.SchemaId = s.SchemaId
	LEFT OUTER JOIN WF_SchemaLocation l ON s.LocationId = l.LocationId
	LEFT OUTER JOIN WF_ActivityGroup g ON a.ActivityId = g.ActivityId
	WHERE (a.ActivityId NOT IN (Select ActivityId FROM WF_Definition WHERE ActivityId IS NOT NULL))
		OR (a.ActivityId IN (SELECT t_activityId FROM @workflowActivities))
	DROP TABLE #WFGetAllActivitySets_UserObjects
END
SET @o_xmlText = (
		SELECT	[Description] '@description',
				Icon '@icon',
				ActivitySetId 'activitySet/@activitySetId',
				Name 'activitySet/@activitySetName',
				ParentId 'activitySet/parent/@activitySetId',
				(SELECT a.DisplayName '@displayName',
						a.[Description] '@description',
						a.Icon '@icon',
						a.ActivityImage '@activityImage',
						a.SchemaFile '@schema',
						a.Class '@className',
						a.Operation '@operation',
						a.serviceUrl '@serviceUrl',
						a.CellClass '@cellClass',
						a.InputEditor '@inputEditor',
						a.Inbound '@inbound',
						a.Outbound '@outbound',
						a.Definition '@definition',
						(SELECT x.ActivitySchema
						FROM WF_Activity x
						WHERE x.ActivityId = a.ActivityId),
						a.ActivityLocationType 'activityLocation/@locationType',
						a.ActivityLocationId 'activityLocation/location/@schemaLocationId',
						a.ActivityLocationUrl 'activityLocation/location/@schemaLocationUrl',
						a.ActivityId 'activity/@activityId',
						a.Name 'activity/@activityName',
						a.SchemaId 'activity/@schemaId',
						a.SchemaNamespace 'activity/@schemaNamespace'
				 FROM @activityList a
				 WHERE a.ActivitySetId = s.ActivitySetId
				 ORDER BY a.Name
				 FOR XML PATH('activities'), TYPE)
		FROM
		(
		SELECT ActivitySetId, ParentId, Name, Icon, Description
		FROM WF_ActivitySet
		UNION
		SELECT 0, NULL, 'Ungrouped', NULL, ''
		) s
		ORDER BY Name
		FOR XML PATH('activitySets'), ROOT('Workflow_GetAllActivitySetsResponse')
)
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_GetAllActivitySetsResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetAllActivitySets')
	delete from GxQscripts where name = 'WFGetAllActivitySets'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetAllActivitySets')
	delete from GXDBVersions where aliasname = 'WFGetAllActivitySets'
GO

insert into GXDBVersions values(2, 'WFGetAllActivitySets',  '00010039007400020000', 'WFGetAllActivitySets', '00010039007400020000')
GO

