

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetActivity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetActivity.sp,v $ $Id: WFGetActivity.sp,v 1.36.34.1 2018/03/27 07:58:48 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 02/26/2014
-- Description:	retrieves a single activity
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetActivity <<<'

IF EXISTS (select * from sysobjects where name='WFGetActivity')
	drop procedure WFGetActivity
IF EXISTS (select * from GxQscripts where name='WFGetActivity')
	delete from GxQscripts where name = 'WFGetActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetActivity')
	delete from GXDBVersions where aliasname = 'WFGetActivity'
GO
print '... Creating Procedure: WFGetActivity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetActivity
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @userId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @activityId int
DECLARE @activityName nvarchar(255)
SELECT	@activityId = ISNULL(ref.value('@activityId','INT'), 0),
		@activityName = ref.value('@activityName','nvarchar(255)')
FROM @i_xmlText.nodes('Workflow_GetActivityRequest/activity') R(ref)
SET @o_xmlText = (
	SELECT Top 1
			--s.ActivitySetId 'activitySet/@activitySetId',
			--s.Name 'activitySet/@activitySetName',
			a.DisplayName '@displayName',
			a.[Description] '@description',
			a.Icon '@icon',
			a.ActivityImage '@activityImage',
			a.SchemaFile '@schema',
			a.Class '@className',
			a.Operation '@operation',
			l.serviceUrl '@serviceUrl',
			a.CellClass '@cellClass',
			a.InputEditor '@inputEditor',
			a.Inbound '@inbound',
			a.Outbound '@outbound',
			a.Flags '@flags',
			a.Definition '@definition',
			(SELECT x.ActivitySchema
			FROM WF_Activity x
			WHERE x.ActivityId = a.ActivityId),
			ISNULL(s.ActivitySetId, 0) 'activitySet/@activitySetId',
			s.Name 'activitySet/@activitySetName',
			l.LocationType 'activityLocation/@locationType',
			l.LocationId 'activityLocation/location/@schemaLocationId',
			l.LocationUrl 'activityLocation/location/@schemaLocationUrl',
			a.ActivityId 'activity/@activityId',
			a.Name 'activity/@activityName',
			a.SchemaId 'activity/@schemaId',
			c.Namespace 'activity/@schemaNamespace'
	 FROM WF_Activity a
	 LEFT OUTER JOIN WF_ActivityGroup g ON a.ActivityId = g.ActivityId
	 LEFT OUTER JOIN WF_ActivitySet s ON g.ActivitySetId = s.ActivitySetId
	 LEFT OUTER JOIN WF_Schema c ON a.SchemaId = c.SchemaId
	 LEFT OUTER JOIN WF_SchemaLocation l ON c.LocationId = l.LocationId
	 WHERE a.ActivityId = @activityId
	 FOR XML PATH('activity'), ROOT('Workflow_GetActivityResponse'))
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_GetActivityResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetActivity')
	delete from GxQscripts where name = 'WFGetActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetActivity')
	delete from GXDBVersions where aliasname = 'WFGetActivity'
GO

insert into GXDBVersions values(2, 'WFGetActivity',  '00010036003400010000', 'WFGetActivity', '00010036003400010000')
GO

