

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFGetActivities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFGetActivities.sp,v $ $Id: WFGetActivities.sp,v 1.4.34.2 2018/03/27 08:09:47 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 02/26/2014
-- Description:	retrieves a single activity
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFGetActivities <<<'

IF EXISTS (select * from sysobjects where name='WFGetActivities')
	drop procedure WFGetActivities
IF EXISTS (select * from GxQscripts where name='WFGetActivities')
	delete from GxQscripts where name = 'WFGetActivities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetActivities')
	delete from GXDBVersions where aliasname = 'WFGetActivities'
GO
print '... Creating Procedure: WFGetActivities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFGetActivities
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @userId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
IF ( @userId = 0 OR @userId IS null )
BEGIN
	SET @o_errorCode = -1
	SET	@o_errorString = 'User not provided'
	GOTO FINISH
END
DECLARE @activityTable TABLE (activityId int);
INSERT INTO @activityTable
SELECT a.ActivityId
FROM WF_Activity a
WHERE (a.ActivityId NOT IN (Select ActivityId FROM WF_Definition WHERE ActivityId IS NOT NULL))
IF object_id('tempdb.dbo.#WFGetActivities_UserObjects') is not null DROP TABLE #WFGetActivities_UserObjects
create table  #WFGetActivities_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId, 14033, 0, '#WFGetActivities_UserObjects'
INSERT @activityTable
SELECT d.ActivityId
FROM WF_Definition d
INNER JOIN #WFGetActivities_UserObjects c ON d.WorkflowId = c.WorkflowId
WHERE d.ActivityId NOT IN (Select activityId FROM @activityTable)
IF EXISTS (SELECT * FROM #WFGetActivities_UserObjects WHERE CommCellId = 2 AND (Capabilities & power(2, 31-1) > 0))
BEGIN
	INSERT @activityTable
	SELECT d.ActivityId
	FROM WF_Definition d
	WHERE d.ActivityId NOT IN (Select activityId FROM @activityTable)
END
SET @o_xmlText = (
	SELECT 	a.DisplayName '@displayName',
			a.[Description] '@description',
			a.Icon '@icon',
			a.ActivityImage '@activityImage',
			a.SchemaFile '@schema',
			a.Class '@className',
			a.Operation '@operation',
			l.serviceUrl '@serviceUrl',
			a.CellClass '@cellClass',
			a.InputEditor '@inputEditor',
			a.Inbound '@inbound',
			a.Outbound '@outbound',
			a.Flags '@flags',
			a.Definition '@definition',
			(SELECT x.ActivitySchema
			FROM WF_Activity x
			WHERE x.ActivityId = a.ActivityId),
			ISNULL(s.ActivitySetId, 0) 'activitySet/@activitySetId',
			ISNULL(s.Name, 'Ungrouped') 'activitySet/@activitySetName',
			l.LocationType 'activityLocation/@locationType',
			l.LocationId 'activityLocation/location/@schemaLocationId',
			l.LocationUrl 'activityLocation/location/@schemaLocationUrl',
			a.ActivityId 'activity/@activityId',
			a.Name 'activity/@activityName',
			a.SchemaId 'activity/@schemaId',
			c.Namespace 'activity/@schemaNamespace'
	 FROM WF_Activity a
	 LEFT OUTER JOIN WF_ActivityGroup g ON a.ActivityId = g.ActivityId
	 LEFT OUTER JOIN WF_ActivitySet s ON g.ActivitySetId = s.ActivitySetId
	 LEFT OUTER JOIN WF_Schema c ON a.SchemaId = c.SchemaId
	 LEFT OUTER JOIN WF_SchemaLocation l ON c.LocationId = l.LocationId
	 WHERE a.ActivityId in (Select activityId FROM @activityTable)
	 Order By s.Name DESC, a.Name
	 FOR XML PATH('activities'), ROOT('Workflow_GetActivitiesResponse'))
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<Workflow_GetActivitiesResponse />'
END
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFGetActivities')
	delete from GxQscripts where name = 'WFGetActivities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFGetActivities')
	delete from GXDBVersions where aliasname = 'WFGetActivities'
GO

insert into GXDBVersions values(2, 'WFGetActivities',  '00010004003400020000', 'WFGetActivities', '00010004003400020000')
GO

