

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFDeleteWorkflow.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFDeleteWorkflow.sp,v $ $Id: WFDeleteWorkflow.sp,v 1.12.2.11 2020/05/05 17:57:22 csunderland Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	saves a workflow
-- =============================================
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='WFDeleteWorkflow')
BEGIN
	print '>>> Drop Stored Procedure: WFDeleteWorkflow <<<'
	drop procedure WFDeleteWorkflow
END
IF EXISTS (select * from GxQscripts where name='WFDeleteWorkflow')
	delete from GxQscripts where name = 'WFDeleteWorkflow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFDeleteWorkflow')
	delete from GXDBVersions where aliasname = 'WFDeleteWorkflow'
GO
print '... Creating Procedure: WFDeleteWorkflow'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFDeleteWorkflow
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId int,
  @i_localeId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @workflowId INT
DECLARE @name nvarchar(255)
SELECT	@workflowId = ISNULL(ref.value('@workflowId','INT'), 0),
		@name = ISNULL(ref.value('@workflowName','nvarchar(255)'), '')
FROM @i_xmlText.nodes('Workflow_DeleteWorkflow/workflow') R(ref)
IF (@workflowId = 0)
BEGIN
	IF LEN(@name) = 0
	BEGIN
		SET @o_ErrorCode = 1
		SET @o_ErrorString = 'workflow not specified'
		GOTO FINISH
	END
	ELSE
	BEGIN
		SELECT @workflowId=ISNULL(WorkflowId, 0)
		FROM WF_Definition
		WHERE Name = @name
	END
END
IF NOT EXISTS(SELECT * FROM WF_Definition Where WorkflowId = @workflowId)
BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorString = 'workflow not found'
	GOTO FINISH
END
DECLARE @two BIGINT
SET @two = 2
DECLARE @hasRights INT = 0
IF dbo.isNewSecurity() = 0
BEGIN
	-- make sure user has delete capabilities on workflow
	IF object_id('tempdb.dbo.#WFDeleteWorkflow_UserObjects') is not null DROP TABLE #WFDeleteWorkflow_UserObjects
create table  #WFDeleteWorkflow_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 14033, 0, '#WFDeleteWorkflow_UserObjects'
IF EXISTS(SELECT * FROM #WFDeleteWorkflow_UserObjects WHERE (workflowId = @workflowId OR workflowId = 0) AND (Capabilities & power(@two, 35-1) > 0))
	BEGIN
		SET @hasRights = 1
	END
	ELSE
	BEGIN
		SET @hasRIghts = 0
	END
END
ELSE
BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 114, @hasRights OUTPUT, 83, @workflowId
END
IF @hasRights = 0
BEGIN
	EXECUTE sec_isWorkflowAdmin @i_userId, @hasRights OUTPUT
END
IF @hasRights = 1
BEGIN
		exec WFProcessAuthorizations @workflowId, 'Delete', @i_userId, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT
		IF @o_ErrorCode != 0
		BEGIN
			GOTO FINISH
		END
		SELECT @name=Name
		FROM WF_Definition
		WHERE WorkflowId = @workflowId
		UPDATE [TM_Task] SET deleted = 1 WHERE taskId IN (
			SELECT taskId FROM TM_AssocEntity WHERE workflowId = @workflowId
		)
		DELETE FROM WF_Activity WHERE ActivityId IN (SELECT ActivityId FROM WF_Definition WHERE WorkflowId = @workflowId)
		DELETE FROM App_MessageHandler Where workflowname = @name
		DELETE FROM WF_Definition WHERE WorkflowId = @workflowId
		DELETE FROM UMUserandGroupEntityAssociation
		WHERE entityType = 14033
		AND objectId = @workflowId
EXEC sec_deleteSecurityAssociationsForEntity 83 , @workFlowId
		DECLARE @opMsgId INTEGER
		DECLARE @opEvMsgId INTEGER
		DECLARE @opId INTEGER
		DECLARE @paramMsgId INTEGER
SET @opMsgId = (655 | (CAST(POWER(2, 24) AS BIGINT) * 84))
		EXEC EvGuiAuditSetOperation @opMsgId, @i_userId, @opEvMsgId OUTPUT, @opId OUTPUT
		EXEC EvGuiAuditSetParamData @opId, @name, 0
SET @paramMsgId = (276 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @i_userId
		declare @tmMaintenanceResponse table
		(
			tmMaintResp xml
		)
		Insert into @tmMaintenanceResponse
		EXEC TM_maintenance
END
ELSE
BEGIN
SET @o_ErrorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_ErrorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @i_localeId)
		SET @o_ErrorString = REPLACE(@o_ErrorString, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @i_userId))
		IF dbo.isNewSecurity() = 0
SET @o_ErrorString = REPLACE(@o_ErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select tokenId from UMCapability WITH (NOLOCK) where id = 35), 0,2))
		ELSE
SET @o_ErrorString = REPLACE(@o_ErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@i_localeId, (Select messageId from UMPermissions WITH (NOLOCK) where id = 114), 0,2))
		SET @o_ErrorString = REPLACE(@o_ErrorString, '^3%s', @name)
		GOTO FINISH
END
FINISH:
SET @o_xmlText = (
	SELECT	1				as TAG,
			0				as Parent,
			@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
			@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT)
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFDeleteWorkflow')
	delete from GxQscripts where name = 'WFDeleteWorkflow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFDeleteWorkflow')
	delete from GXDBVersions where aliasname = 'WFDeleteWorkflow'
GO

insert into GXDBVersions values(2, 'WFDeleteWorkflow',  '00010012000200110000', 'WFDeleteWorkflow', '00010012000200110000')
GO

