

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFDeleteInteraction.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFDeleteInteraction.sp,v $ $Id: WFDeleteInteraction.sp,v 1.4.86.1 2018/03/27 08:15:32 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	deletes the individual interaction
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFDeleteInteraction <<<'

IF EXISTS (select * from sysobjects where name='WFDeleteInteraction')
	drop procedure WFDeleteInteraction
IF EXISTS (select * from GxQscripts where name='WFDeleteInteraction')
	delete from GxQscripts where name = 'WFDeleteInteraction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFDeleteInteraction')
	delete from GXDBVersions where aliasname = 'WFDeleteInteraction'
GO
print '... Creating Procedure: WFDeleteInteraction'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFDeleteInteraction
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML,
  @i_userId int
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
DECLARE @o_ErrorCode INT
SET @o_ErrorCode = 0
DECLARE @o_ErrorString NVARCHAR(MAX)
SET @o_ErrorString = N'Success'
DECLARE @interactionId int
DECLARE @xmlForm nvarchar(MAX)
SELECT	@interactionId = ISNULL(ref.value('@interactionId','int'), 0)
FROM @i_xmlText.nodes('Workflow_DeleteWebFormInteractionRequest') R(ref)
IF NOT EXISTS(SELECT InteractionId FROM WF_Interaction WHERE InteractionId = @interactionId)
BEGIN
	SET @o_ErrorCode = -1
	SET @o_ErrorString = 'interaction does not exist'
	GOTO FINISH
END
IF NOT EXISTS(SELECT * FROM dbo.GetUserInteractions(@i_userId, 1) WHERE InteractionId = @interactionId)
BEGIN
	SET @o_ErrorCode = -1
	SET @o_ErrorString = 'user is not authorized to delete interaction'
	GOTO FINISH
END
UPDATE WF_Interaction
SET completedBy=@i_userId,
	completed=dbo.GetUnixTime(GETUTCDATE()),
	[status] = 2
WHERE InteractionId = @interactionId
AND [status] = 0
FINISH:
SET @o_xmlText = (
	SELECT	1				as TAG,
			0				as Parent,
			@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
			@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT)
SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFDeleteInteraction')
	delete from GxQscripts where name = 'WFDeleteInteraction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFDeleteInteraction')
	delete from GXDBVersions where aliasname = 'WFDeleteInteraction'
GO

insert into GXDBVersions values(2, 'WFDeleteInteraction',  '00010004008600010000', 'WFDeleteInteraction', '00010004008600010000')
GO

