

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFDUpdateWorkFlowDefinition.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFDUpdateWorkFlowDefinition.sp,v $ $Id: WFDUpdateWorkFlowDefinition.sp,v 1.1.2.1 2018/09/26 09:21:54 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFDUpdateWorkFlowDefinition <<<'

IF EXISTS (select * from sysobjects where name='WFDUpdateWorkFlowDefinition')
	drop procedure WFDUpdateWorkFlowDefinition
IF EXISTS (select * from GxQscripts where name='WFDUpdateWorkFlowDefinition')
	delete from GxQscripts where name = 'WFDUpdateWorkFlowDefinition'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFDUpdateWorkFlowDefinition')
	delete from GXDBVersions where aliasname = 'WFDUpdateWorkFlowDefinition'
GO
print '... Creating Procedure: WFDUpdateWorkFlowDefinition'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFDUpdateWorkFlowDefinition
--  User Input arguments
  @guid VARCHAR(40),
  @inVersion INT,
  @inFlags INT,
  @revision NVARCHAR(255),
  @definition XML
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @errorCode		INT = 0		-- success
	DECLARE @nowTime		INT
	DECLARE @nowDt			DATETIME
	DECLARE @name			NVARCHAR(255)
	DECLARE @description	NVARCHAR(MAX)
	DECLARE @workflowId		INT
	DECLARE @version		INT = @inVersion
	DECLARE @flags			INT = @inFlags
	DECLARE @currentFlags	INT
	DECLARE @currentRevision NVARCHAR(255)
	BEGIN TRY
		SET @nowDt = GETUTCDATE()
		SET @nowTime = datediff(second, '01/01/1970', @nowDt)
		SELECT
			@name = d.value('@name', 'NVARCHAR(255)'),
			@description = d.value('@description', 'NVARCHAR(MAX)')
		FROM @definition.nodes('/workflow') w(d)
		SELECT
			@workflowId = WorkflowId,
			@version = Version,
			@currentFlags = flags,
			@currentRevision = revision
		FROM WF_Definition
		WHERE Name = @name
		IF (@workflowId IS NULL)
		BEGIN
			INSERT INTO WF_Definition(Name, Description, Definition, Version, Created, Modified, userId, flags, revision, uniqueGuid)
				VALUES (@name, @description, @definition, @version, @nowDt, @nowDt, 1, @flags, @revision, @guid)
			SET @workflowId = SCOPE_IDENTITY()
			INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)
				VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)
		END
		ELSE
		BEGIN
			IF ((@currentFlags & 4) > 0 OR (@flags & (8|16)) > 0) AND (@currentRevision <> @revision)
			BEGIN
				SET @version = @version + 1
				UPDATE WF_Definition
					SET Description = @description,
						Definition = @definition,
						Version = @version,
						Modified = @nowDt,
						revision = @revision,
						uniqueGuid = @guid,
						flags = CASE
									WHEN ((@flags & (8|16))) > 0 THEN @flags
									ELSE flags		-- no change
								END
				WHERE
					workFlowId = @workflowId
				INSERT INTO WF_DefinitionHistory(WorkflowId, Version, Name, Description, Definition, Created, userId)
					VALUES (@workflowId, @version, @name, @description, @definition, @nowTime, 1)
			END
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		;THROW;	-- Re-Throw the execption to the caller
	END CATCH
	RETURN @errorCode
END

IF EXISTS (select * from GxQscripts where name = 'WFDUpdateWorkFlowDefinition')
	delete from GxQscripts where name = 'WFDUpdateWorkFlowDefinition'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFDUpdateWorkFlowDefinition')
	delete from GXDBVersions where aliasname = 'WFDUpdateWorkFlowDefinition'
GO

insert into GXDBVersions values(2, 'WFDUpdateWorkFlowDefinition',  '00010001000200010000', 'WFDUpdateWorkFlowDefinition', '00010001000200010000')
GO

