

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/WFCleanHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/WFCleanHistory.sp,v $ $Id: WFCleanHistory.sp,v 1.2.88.3 2018/03/27 08:09:21 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 12/13/2012
-- Description:	cleans old workflow definitions
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: WFCleanHistory <<<'

IF EXISTS (select * from sysobjects where name='WFCleanHistory')
	drop procedure WFCleanHistory
IF EXISTS (select * from GxQscripts where name='WFCleanHistory')
	delete from GxQscripts where name = 'WFCleanHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFCleanHistory')
	delete from GXDBVersions where aliasname = 'WFCleanHistory'
GO
print '... Creating Procedure: WFCleanHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure WFCleanHistory
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @daysToKeep INT,
  @revisionsToKeep INT
AS
SET NOCOUNT ON
BEGIN
DECLARE @older90daysDate DATETIME = DATEADD(DAY, -90, GETUTCDATE())
DELETE d
from WF_Deploy d
WHERE dbo.GetDateTime(Deployed) < @older90daysDate
AND d.DeployId NOT IN (Select Max(DeployId) As LatestDeployId from WF_Deploy w WHERE d.WorkflowId = w.WorkflowId GROUP BY w.ClientId)
DECLARE @tempTable TABLE (t_id int)
IF (@daysToKeep > 0)
BEGIN
INSERT INTO @tempTable
SELECT HistoryId
FROM WF_DefinitionHistory
WHERE dbo.GetDateTime(Created) < DATEADD(DAY, -@daysToKeep, GETUTCDATE())
END
IF (@revisionsToKeep > 0)
BEGIN
INSERT INTO @tempTable
SELECT HistoryId
FROM WF_DefinitionHistory h
INNER JOIN
(
	SELECT WorkflowId, MAX(Version)-@revisionsToKeep As Revision
	FROM WF_DefinitionHistory
	GROUP BY WorkflowId
	HAVING (MAX(Version)-@revisionsToKeep) >= @revisionsToKeep
) t ON h.WorkflowId = t.WorkflowId AND h.Version < t.Revision
Where h.HistoryId NOT IN (SELECT t_id FROM @tempTable)
END
-- keep the latest version of the workflow
DELETE FROM @tempTable
WHERE t_id IN
(
	SELECT HistoryId
	FROM WF_DefinitionHistory h
	INNER JOIN
	(
		SELECT WorkflowId, MAX(Version) As LastVersion
		FROM WF_DefinitionHistory
		GROUP BY WorkflowId
	) v ON h.WorkflowId = v.WorkflowId AND h.Version = v.LastVersion
)
-- keep any deployed version
DELETE FROM @tempTable
WHERE t_id IN
(
	SELECT HistoryId
	FROM WF_DefinitionHistory h
	INNER JOIN WF_Deploy d ON h.WorkflowId = d.WorkflowId AND h.Version = d.Version
)
-- clean history table
UPDATE WF_DefinitionHistory
SET Definition = NULL, Description = NULL
WHERE HistoryId IN (SELECT t_id FROM @tempTable)
END
GO

IF EXISTS (select * from GxQscripts where name = 'WFCleanHistory')
	delete from GxQscripts where name = 'WFCleanHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='WFCleanHistory')
	delete from GXDBVersions where aliasname = 'WFCleanHistory'
GO

insert into GXDBVersions values(2, 'WFCleanHistory',  '00010002008800030000', 'WFCleanHistory', '00010002008800030000')
GO

