

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VsaCommitCatalogJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2019  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Paul Mazur
--	Date:   10/18/2019
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VsaCommitCatalogJob.sp,v $ $Id: VsaCommitCatalogJob.sp,v 1.1.4.8 2020/12/07 20:27:35 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='VsaCommitCatalogJob')
BEGIN
	print '>>> Drop Stored Procedure: VsaCommitCatalogJob <<<'
	drop procedure VsaCommitCatalogJob
END
IF EXISTS (select * from GxQscripts where name='VsaCommitCatalogJob')
	delete from GxQscripts where name = 'VsaCommitCatalogJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VsaCommitCatalogJob')
	delete from GXDBVersions where aliasname = 'VsaCommitCatalogJob'
GO
print '... Creating Procedure: VsaCommitCatalogJob'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure VsaCommitCatalogJob
  @xmlText XML OUTPUT
AS
DECLARE @catalogJobId INTEGER = ISNULL(@xmlText.value('(/Indexing_VsaCommitCatalogJobReq/@catalogJobId)[1]', 'INT'), 0)
DECLARE @vmJobId INTEGER = ISNULL(@xmlText.value('(/Indexing_VsaCommitCatalogJobReq/@vmJobId)[1]', 'INT'), 0)
DECLARE @vmCommCellId INTEGER = ISNULL(@xmlText.value('(/Indexing_VsaCommitCatalogJobReq/@vmCommCellId)[1]', 'INT'), 0)
DECLARE @success INTEGER = ISNULL(@xmlText.value('(/Indexing_VsaCommitCatalogJobReq/@success)[1]', 'INT'), 0)
DECLARE @snapJob INTEGER = ISNULL(@xmlText.value('(/Indexing_VsaCommitCatalogJobReq/@snapJob)[1]', 'INT'), 0)
DECLARE @retValue INTEGER = 0
DECLARE @errString VARCHAR(MAX)
DECLARE @magneticBytes BIGINT = 0
DECLARE @now INT = dbo.GetUnixTime(GetUTCDate())
if @catalogJobId=0 OR @vmJobId=0 OR @vmCommCellId=0
BEGIN
	SET @errString = 'Missing argument'
END
ELSE
BEGIN
	DECLARE @appId INTEGER = 0
	DECLARE @appTypeId INTEGER = 0
	DECLARE @backupLevel INTEGER = 0
	DECLARE @startDate INTEGER = 0
	DECLARE @fullCycleNum INTEGER = 0
	DECLARE @retryCount INTEGER = 0
	DECLARE @maxRetryCount INTEGER = 3
	SELECT TOP 1 @appId = appId, @appTypeId = appType, @backupLevel = bkpLevel, @startDate = servStartDate, @fullCycleNum = fullCycleNum
	FROM	JMBkpStats WITH (READUNCOMMITTED)
	WHERE	jobId = @vmJobId AND commcellid = @vmCommCellId
-- Add three retries
	WHILE (@retryCount < @maxRetryCount)
	BEGIN
		BEGIN TRY
			SAVE TRANSACTION VSA_COMMIT_CATALOG_JOB_TRAN
			if @success=0
			BEGIN
				--failed job
				--invalidate all aFiles for the catalog JobID and (AppId deduced from vmJobId)
				-- if SF then do NOT manipulate ArchFiles, just mark the job
				if @catalogJobId<>@vmJobId
					UPDATE archfile
					SET		isValid=-1
					WHERE	appid=@appId AND jobId=@catalogJobId
			END
			IF EXISTS (SELECT 1 FROM archFile WHERE appid=@appId and jobId=@catalogJobId)
			BEGIN
				DECLARE @jobState INT =  IIF((@success=0), 2 /*FAIL*/, 1 /*JMSUCCESS*/)
				DECLARE @origJobInfoXML XML =	( SELECT	@vmJobId '@jobId',
														@vmCommCellId '@commCellId',
														@jobState '@jobState',
														@snapJob '@isSnapJob'
												FOR XML PATH('OrigJobInfo'))
				IF OBJECT_ID('tempdb..#archJobDataStatsCreateResultTable') IS NOT NULL DROP TABLE #archJobDataStatsCreateResultTable
				CREATE TABLE #archJobDataStatsCreateResultTable (result INTEGER)
				EXEC archJobDataStatsCreate @catalogJobId, 2, @appTypeId, @jobState, @now, @origJobInfoXML
				IF EXISTS (SELECT 1 FROM #archJobDataStatsCreateResultTable WHERE result > 0)
				BEGIN
					ROLLBACK TRANSACTION VSA_COMMIT_CATALOG_JOB_TRAN
					SELECT	@errString = 'Failed to execute stored procedure [archJobDataStatsCreate]'
					GOTO PROC_EXIT
				END
				IF OBJECT_ID('tempdb..#tmpSelectedJobsResult') IS NOT NULL DROP TABLE #tmpSelectedJobsResult
				CREATE TABLE #tmpSelectedJobsResult (retVal INTEGER, jobId INTEGER, commcellId INTEGER, copyId INTEGER, dataType INTEGER, isSelectiveCopy INTEGER)
				EXEC SelectJobForAuxCopy @vmJobId, @appId, @appTypeId, @startDate, @backupLevel, @fullCycleNum, 0, @now, @now
				IF EXISTS (SELECT 1 FROM #tmpSelectedJobsResult WHERE retVal > 0)
				BEGIN
					ROLLBACK TRANSACTION VSA_COMMIT_CATALOG_JOB_TRAN
					SELECT	@errString = 'Failed to execute stored procedure [SelectJobForAuxCopy]'
					GOTO PROC_EXIT
				END
			END
			GOTO PROC_EXIT
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			IF (ERROR_NUMBER() IN (1205 /*DEADLOCK*/, 1222 /*LOCKED*/))
			BEGIN
				ROLLBACK TRANSACTION VSA_COMMIT_CATALOG_JOB_TRAN
				SET @retryCount = @retryCount + 1
				IF (@retryCount >= @maxRetryCount)
				BEGIN
					SET @errString = 'Failed to execute stored procedure' + ERROR_MESSAGE()
					-- Need to clean up the archFile table entries
					--;THROW;
				END
				WAITFOR DELAY '00:00:10'
				CONTINUE
			END
			ELSE
			BEGIN
				ROLLBACK TRANSACTION VSA_COMMIT_CATALOG_JOB_TRAN
				SET @errString = 'Failed to execute stored procedure' + ERROR_MESSAGE()
				GOTO PROC_EXIT
			END
		END CATCH
	END
END
PROC_EXIT:
-- Clean up the archive files that exist with current catalog job id - archDeleteArchiveFiles
IF EXISTS(SELECT 1 FROM archfile WITH (READUNCOMMITTED) WHERE appid=@appId AND jobId=@catalogJobId AND commCellId = 2)
BEGIN
	/*
	IF OBJECT_ID('tempdb..#tblResultarchDeleteArchiveFiles') IS NOT NULL  DROP TABLE #tblResultarchDeleteArchiveFiles
    CREATE TABLE #tblResultarchDeleteArchiveFiles(retCode int, retStr varchar(1024))
	SET @archiveFileXML = (
							SELECT DISTINCT AF.id AS archFileId, AF.commCellId AS commCelld, 0 AS copyId
							FROM	archfile AF WITH (READUNCOMMITTED)
							WHERE AF.appid=@appId AND AF.jobId=@catalogJobId AND AF.commCellId = 2
							FOR  XML AUTO, ROOT('GalaxyOperations_PruneArchiveFiles')
						  )
EXEC @retValue = archDeleteArchiveFiles @archiveFileXML, 1099511627776, 1
    IF  (@retValue != 0)
    BEGIN
        SET @errString = @errString + '\n' + 'Failed to prune archive files. ' + ISNULL((SELECT top 1 retStr FROM #tblResultarchDeleteArchiveFiles), '')
    END
	*/
	IF OBJECT_ID('tempdb.dbo.#ToBeAgedAFC') IS NOT NULL DROP TABLE #ToBeAgedAFC
	CREATE TABLE #ToBeAgedAFC (archFileId INT, commCellId INT, archCopyId INT, fileType INT,
			PRIMARY KEY (archFileId, commCellId, archCopyId))
	INSERT	INTO #ToBeAgedAFC
	SELECT DISTINCT AF.id AS archFileId, AF.commCellId AS commCelld, ISNULL(AFC.archCopyId, 0) AS copyId, AF.fileType
	FROM	archfile AF WITH (READUNCOMMITTED)
			LEFT OUTER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON AF.id = AFC.archFileId AND AF.commCellId = AFC.commCellId
	WHERE	AF.appid=@appId AND AF.jobId=@catalogJobId AND AF.commCellId = 2
	IF EXISTS (SELECT 1 FROM #ToBeAgedAFC)
	BEGIN
EXEC @retValue = archFileSetAgedViaTable 1099511627776, @now
		IF (@retValue = 0)
			EXEC @retValue = archFileDeleteViaTable 0, @magneticBytes OUTPUT
		IF (@retValue > 0)
		BEGIN
			SET @errString = @errString + '\n' + 'Failed to prune archive files.'
		END
	END
END
--Output XML generation
DECLARE @outxmlText XML = (
	SELECT @errString as '@errString'
	FOR XML PATH('Indexing_VsaCommitCatalogJobResp'), TYPE)
SET @xmlText =  @outxmlText
IF OBJECT_ID('tempdb..#archJobDataStatsCreateResultTable') IS NOT NULL DROP TABLE #archJobDataStatsCreateResultTable
IF OBJECT_ID('tempdb..#tmpSelectedJobsResult') IS NOT NULL DROP TABLE #tmpSelectedJobsResult
IF OBJECT_ID('tempdb..#tblResultarchDeleteArchiveFiles') IS NOT NULL  DROP TABLE #tblResultarchDeleteArchiveFiles
IF OBJECT_ID('tempdb.dbo.#ToBeAgedAFC') IS NOT NULL DROP TABLE #ToBeAgedAFC
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VsaCommitCatalogJob')
	delete from GxQscripts where name = 'VsaCommitCatalogJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VsaCommitCatalogJob')
	delete from GXDBVersions where aliasname = 'VsaCommitCatalogJob'
GO

insert into GXDBVersions values(2, 'VsaCommitCatalogJob',  '00010001000400080000', 'VsaCommitCatalogJob', '00010001000400080000')
GO

