

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ValidateAndUpdateSQLSubclientContents.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored Precedure: ValidateAndUpdateSQLSubclientContents
--  |
--  | Description:
--  |  To validate and update MSSQL subclient contents
--  |
--  |   Revisions  Author					Description
--  |   ---------  -------			---------------------------------------------
--  |   1.0        Mohammad Dilshad		 To validate and update MSSQL subclient contents
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: ValidateAndUpdateSQLSubclientContents <<<'

IF EXISTS (select * from sysobjects where name='ValidateAndUpdateSQLSubclientContents')
	drop procedure ValidateAndUpdateSQLSubclientContents
IF EXISTS (select * from GxQscripts where name='ValidateAndUpdateSQLSubclientContents')
	delete from GxQscripts where name = 'ValidateAndUpdateSQLSubclientContents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ValidateAndUpdateSQLSubclientContents')
	delete from GXDBVersions where aliasname = 'ValidateAndUpdateSQLSubclientContents'
GO
print '... Creating Procedure: ValidateAndUpdateSQLSubclientContents'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ValidateAndUpdateSQLSubclientContents
  @xmlText XML,
  @contentXML XML
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @clientId	INT
	DECLARE @instanceId INT
	DECLARE @nowTime		INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @isDBSubclient INT = 0
	DECLARE @isCMDRequest INT = 0
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(MAX)
	DECLARE @localeId INT = 0
	DECLARE @message NVARCHAR(MAX)
	IF object_id('tempdb.dbo.#subclientList') IS NOT NULL DROP TABLE #subclientList
	IF object_id('tempdb.dbo.#subclients') IS NOT NULL DROP TABLE #subclients
	IF object_id('tempdb.dbo.#contentRemoved') IS NOT NULL DROP TABLE #contentRemoved
	IF object_id('tempdb.dbo.#auditContent') IS NOT NULL DROP TABLE #auditContent
	IF object_id('tempdb.dbo.#currentAssociation') IS NOT NULL DROP TABLE #currentAssociation
	CREATE TABLE #subclientList(name NVARCHAR(256))
	CREATE TABLE #subclients(subclientId INT, subclientName NVARCHAR(256), hasContent INT)
	CREATE TABLE #contentRemoved(subclientId INT, contentName NVARCHAR(MAX))
	CREATE TABLE #auditContent(subclientId INT, subclientName NVARCHAR(256), contentAdded NVARCHAR(MAX), contentRemoved NVARCHAR(MAX), databaseRemoved NVARCHAR(MAX))
	CREATE TABLE #currentAssociation(subclientId INT, subclientName NVARCHAR(256), contentName NVARCHAR(MAX))
	DECLARE @instanceEntity XML = (SELECT  ref.query('.') AS instance
								  FROM    @xmlText.nodes('App_SetSQLSubclientContentAssociationReq/instance') R ( ref ))
	SET @clientId = ISNULL((SELECT  ref.value('@clientId', 'int') AS client
								  FROM    @instanceEntity.nodes('instance') R ( ref )),0)
	SET @instanceId = ISNULL((SELECT  ref.value('@instanceId', 'int') AS instance
								  FROM    @instanceEntity.nodes('instance') R ( ref )),0)
	SET @localeId = ISNULL((SELECT @xmlText.value('(/App_SetSQLSubclientContentAssociationReq/processinginstructioninfo/locale/@localeId)[1]','INT')),0)
	IF @xmlText.exist('/App_SetSQLSubclientContentAssociationReq/contentAssociation/sqlDatabaseAssociation') = 1
		SET @isDBSubclient = 1
	IF @isDBSubclient = 1
	BEGIN
		IF object_id('tempdb.dbo.#newDBAssociation') IS NOT NULL DROP TABLE #newDBAssociation
		IF object_id('tempdb.dbo.#database') IS NOT NULL DROP TABLE #database
		CREATE TABLE #newDBAssociation(subclientId INT, subclientName NVARCHAR(256), databaseID INT, databaseName NVARCHAR(MAX), discoverType INT)
		CREATE TABLE #database (databaseId INT, databaseName NVARCHAR(MAX))
		INSERT INTO #newDBAssociation(subclientName, databaseID, databaseName, discoverType)
		SELECT
		N.association.value('(associatedSubclient/@subclientName)[1]','NVARCHAR(MAX)') AS subclientName,
		N.association.value('@databaseId','INT') AS databaseID,
		N.association.value('@databaseName','NVARCHAR(MAX)') AS databaseName,
		N.association.value('@discoverType','INT') AS discoverType
		FROM   @xmlText.nodes('/App_SetSQLSubclientContentAssociationReq/contentAssociation/sqlDatabaseAssociation') AS N(association)
		-- In case of create subclient request, we need to get subclientId from DB, getting all IDs from App_Application.
		UPDATE AREQ SET AREQ.subclientId = APP.id
		FROM #newDBAssociation AREQ
			INNER JOIN APP_Application APP WITH (NOLOCK)
				ON AREQ.subclientName = APP.subclientName
				AND App.clientId = @clientId
				AND App.instance = @instanceId
				AND App.appTypeId = 81 --MSSQL App Type
				AND App.subclientStatus <> 4
		-- Setting all property to Do Not Backup subclient with default values, we will remove this code after SP10.
		DECLARE @subclientId INT = (SELECT id FROM APP_Application WITH (NOLOCK) WHERE
				subclientName = N'Do Not Backup' AND clientId = @clientId AND instance = @instanceId AND appTypeId = 81 AND subclientStatus <> 4)
		IF @subclientId IS NOT NULL AND EXISTS(SELECT 1 FROM #newDBAssociation WHERE subclientId = @subclientId)
			EXEC DBO.AppSetMSSQLSubclientProp @subclientId
		-- Populating current SQL Database association.
		INSERT INTO #currentAssociation
		SELECT APP.id, APP.subclientName, ASP1.attrName
		FROM APP_Application APP WITH (NOLOCK)
			INNER JOIN APP_SubClientProp ASP1 WITH (NOLOCK)
				ON App.id = ASP1.componentNameId
			INNER JOIN APP_SubClientProp ASP2 WITH (NOLOCK)
				ON App.id = ASP2.componentNameId
				AND App.clientId = @clientId
				AND App.instance = @instanceId
				AND App.appTypeId = 81 --MSSQL App Type
				AND App.subclientStatus <> 4
				AND ASP1.attrType = 118 -- MSSQL DB attrVal
				AND ASP1.modified = 0
				AND ASP2.attrName = N'mssql subclient type'
				AND ASP2.attrVal = N'1'
				AND ASP2.modified = 0
		-- Getting all subclients of given instance
		INSERT INTO #subclients
			SELECT APP.id, APP.subclientName, hasContent = 1
			FROM APP_Application APP WITH (NOLOCK)
				INNER JOIN APP_SubClientProp ASP WITH (NOLOCK)
					ON APP.id = ASP.componentNameId
					AND App.clientId = @clientId
					AND App.instance = @instanceId
					AND App.appTypeId = 81 --MSSQL App Type
					AND App.subclientStatus <> 4
					AND ASP.attrName = N'mssql subclient type'
					AND ASP.attrVal = N'1'
					AND ASP.modified = 0
		-- Adding all Databases to list which does not have association in request.
        INSERT INTO #contentRemoved
        SELECT CA.subclientId, CA.contentName
            FROM #newDBAssociation DBREQ
                INNER JOIN #currentAssociation CA
                    ON DBREQ.databaseName = CA.contentName
                    AND DBREQ.subclientName = N''
		IF @contentXML.exist('/Api_GetSQLDatabaseListResponse/databaseAssociation') = 1
			SET @isCMDRequest = 1
		IF @isCMDRequest <> 1 -- If request from GUI, then skipping validations
			GOTO SKIP_DB_VALIDATION
		-- If subclient doesn't exist, generate error.
		IF EXISTS(SELECT 1 FROM #newDBAssociation WHERE subclientId IS NULL)
		BEGIN
SET @errorCode = (3196 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SELECT @errorString = COALESCE(@errorString+',' ,'') + subclientName FROM  #newDBAssociation WHERE subclientId IS NULL
			GOTO EXIT_ERROR
		END
		-- If subclient is not part of given instance and DB type then generate error.
		INSERT INTO #subclientList
		SELECT DISTINCT AREQ.subclientName FROM #newDBAssociation AREQ
							LEFT OUTER JOIN #subclients SC
							ON AREQ.subclientId = SC.subclientId
							WHERE SC.subclientId IS NULL
		IF EXISTS(SELECT 1 FROM #subclientList)
		BEGIN
SET @errorCode = (3206 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SELECT @errorString = COALESCE(@errorString+',' ,'') + name FROM #subclientList
			GOTO EXIT_ERROR
		END
		-- Checking if request has multiple entry for single database
		INSERT INTO #database(databaseName)
		SELECT databaseName FROM #newDBAssociation
		GROUP BY databaseName HAVING COUNT(databaseName) > 1
		-- If exist, generate error.
		IF EXISTS(SELECT 1 FROM #database)
		BEGIN
SET @errorCode = (3191 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SELECT @errorString = COALESCE(@errorString+',' ,'') + databaseName FROM  #database WHERE databaseID IS NULL
			GOTO EXIT_ERROR
		END
		--in case databaseId not provided or wrong, than load from SQL instance
		INSERT INTO #database
			SELECT
			N.db.value('@databaseId','INT') AS databaseId,
			N.db.value('@databaseName','NVARCHAR(MAX)') AS databaseNAme
			FROM   @contentXML.nodes('/Api_GetSQLDatabaseListResponse/databaseAssociation') AS N(db)
			UPDATE #newDBAssociation SET databaseID = NULL
			UPDATE ASSOC SET ASSOC.databaseID = DB.databaseId
			FROM #newDBAssociation ASSOC
				INNER JOIN #database DB
					ON ASSOC.databaseName = DB.databaseName
		-- Generating error in case of database doesn't exist.
		IF EXISTS(SELECT 1 FROM #newDBAssociation WHERE databaseID IS NULL)
		BEGIN
SET @errorCode = (3190 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SELECT @errorString = COALESCE(@errorString+',' ,'') + databaseName FROM  #newDBAssociation WHERE databaseID IS NULL
			GOTO EXIT_ERROR
		END
		-- Removing special subclients from list
		DELETE SC
		FROM #subclients SC
			INNER JOIN APP_SubClientProp ASP1 WITH (NOLOCK)
				ON ASP1.componentNameId = SC.subclientId
			INNER JOIN APP_SubClientProp ASP2 WITH (NOLOCK)
				ON ASP2.componentNameId = SC.subclientId
				AND ASP1.attrName = N'SQL Special Subclient Type'
				AND ASP1.attrVal <> N'1'
				AND ASP1.modified = 0
				AND ASP2.attrName = N'MSSQL Disable AutoDiscovery'
				AND ASP2.attrVal = N'1'
				AND ASP2.modified = 0
		SKIP_DB_VALIDATION:
		-- Removing unsupported subclient association.
		DELETE FROM #newDBAssociation WHERE subclientId <= 0 OR subclientName = N'' OR subclientId IS NULL
		-- Setting default value to discoverType
		UPDATE #newDBAssociation SET discoverType = 0 WHERE discoverType IS NULL
		-- Removing all association from request which is already present
		DELETE AREQ
		FROM #currentAssociation AC
			INNER JOIN #newDBAssociation AREQ
				ON AC.contentName = AREQ.databaseName
				AND AC.subClientID = AREQ.subClientID
		-- Listing all the associations which are going to removed.
		INSERT INTO #contentRemoved
		SELECT AC.subClientID, AC.contentName
		FROM #currentAssociation AC
			INNER JOIN #newDBAssociation AREQ
				ON AC.contentName = AREQ.databaseName
		IF @isCMDRequest <> 1 -- Skip if request from GUI
			GOTO SKIP_DB_SC_VALIDATION
		-- Removing all associations, which are going to be removed from current association
		DELETE AC
		FROM #currentAssociation AC
			INNER JOIN #newDBAssociation AREQ
				ON AC.contentName = AREQ.databaseName
		-- Adding all new association to currect association table
		INSERT INTO #currentAssociation
		SELECT subclientId, subclientName, databaseName
		FROM #newDBAssociation
		-- Checking if all listed subclients has contents after new association
		UPDATE #subclients SET hasContent = 0
		FROM #subclients SC
			LEFT OUTER JOIN  #currentAssociation AREQ
				ON  SC.subclientId = AREQ.subclientId
				WHERE AREQ.subclientId IS NULL
		--If any subclient from list is without content then generate error.
		IF EXISTS(SELECT 1 FROM #subclients WHERE hasContent = 0)
		BEGIN
SET @errorCode = (3195 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SELECT @errorString = COALESCE(@errorString+',' ,'') + subclientName FROM  #subclients WHERE hasContent = 0
			GOTO EXIT_ERROR
		END
		SKIP_DB_SC_VALIDATION:
		---- Removing contents from subclient
		UPDATE APP_SubClientProp SET modified = @nowTime
		FROM APP_SubClientProp APP WITH (NOLOCK)
			INNER JOIN #contentRemoved REM
				ON APP.componentNameId = REM.subclientId
				AND APP.attrType = 118
				AND App.attrName = REM.contentName
				AND APP.modified = 0
		----Adding contents to subclient
		INSERT app_subClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
		SELECT subclientId, databaseName, 118, CAST(databaseID AS NVARCHAR(10)) + ' ' + CAST(discoverType AS NVARCHAR(10)), @nowTime, 0, 0
		FROM #newDBAssociation
		--Generating content table for audit.
		INSERT INTO #auditContent (subclientId, subclientName, contentAdded, contentRemoved)
		SELECT  subclientId, subclientName,
			STUFF((SELECT ', ' + databaseName [text()]
				FROM #newDBAssociation
				WHERE subclientId = SC.subclientId
				FOR XML PATH(''), TYPE)
			.value('.','NVARCHAR(MAX)'),1,2,' ') contentAdded,
			STUFF((SELECT ', ' + contentName [text()]
				FROM #contentRemoved
				WHERE subclientId = SC.subclientId
				FOR XML PATH(''), TYPE)
			.value('.','NVARCHAR(MAX)'),1,2,' ') contentRemoved
		FROM #subclients SC
		----------- Updating last content change ----------------
		MERGE APP_SubclientProp ASP
		USING  (SELECT subclientId FROM #auditContent) AS APP
			ON APP.subclientId = componentNameId AND ASP.attrName = N'last content change' AND ASP.modified = 0
		WHEN MATCHED THEN
		UPDATE SET attrVal = @nowTime
		WHEN NOT MATCHED THEN
		INSERT (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		VALUES(APP.subclientId,N'last content change', 10,@nowTime,@nowTime,0,0);
	END
	ELSE -- For FFG subclients
	BEGIN
		IF object_id('tempdb.dbo.#newFFGAssociation') IS NOT NULL DROP TABLE #newFFGAssociation
		IF object_id('tempdb.dbo.#ffg') IS NOT NULL DROP TABLE #ffg
		IF object_id('tempdb.dbo.#ffgList') IS NOT NULL DROP TABLE #ffgList
		IF object_id('tempdb.dbo.#subclientInRequest') IS NOT NULL DROP TABLE #subclientInRequest
		IF object_id('tempdb.dbo.#ffgSubclientList') IS NOT NULL DROP TABLE #ffgSubclientList
		DECLARE @databaseName NVARCHAR(MAX) = ISNULL((SELECT  ref.value('@name', 'NVARCHAR(MAX)') AS databaseName
								  FROM    @xmlText.nodes('/App_SetSQLSubclientContentAssociationReq/database') R ( ref )),'')
		DECLARE @databaseId INT = ISNULL((SELECT  ref.value('@id', 'INT') AS databaseId
								  FROM    @xmlText.nodes('/App_SetSQLSubclientContentAssociationReq/database') R ( ref )),0)
		CREATE TABLE #newFFGAssociation(subclientId INT, subclientName NVARCHAR(MAX), fileId INT, fileName NVARCHAR(MAX), fileGroupId INT,
			fileGroupName NVARCHAR(MAX), isFile INT, systemDbFlags INT, displayName NVARCHAR(MAX))
		CREATE TABLE #ffg (fileGroupId INT, fileGroupName NVARCHAR(MAX), fileId INT, fileName NVARCHAR(MAX), displayName NVARCHAR(MAX))
		CREATE TABLE #ffgList(ffgName NVARCHAR(MAX))
		CREATE TABLE #subclientInRequest(subclientId INT, subclientName NVARCHAR(256), oldDatabase NVARCHAR(MAX))
		CREATE TABLE #ffgSubclientList (subclientId INT, subclientName NVARCHAR(256))
		-- Inserting filegroups
		INSERT INTO #newFFGAssociation(subclientName, fileGroupId, fileGroupName, displayName)
		SELECT
		N.association.value('@subclientName','NVARCHAR(MAX)') AS subclientName,
		N.association.value('@fileGroupId','INT') AS fileGroupId,
		N.association.value('@groupName','NVARCHAR(MAX)') AS fileGroupName,
		N.association.value('@groupName','NVARCHAR(MAX)') AS displayName
		FROM   @xmlText.nodes('/App_SetSQLSubclientContentAssociationReq/contentAssociation/sqlFFGAssociation') AS N(association)
		--Removing unconfigured filegroups
		DELETE FROM #newFFGAssociation WHERE subclientName IS NULL
		-- Inserting Files
		INSERT INTO #newFFGAssociation(subclientName, fileId, fileName, isFile, systemDbFlags, fileGroupId, fileGroupName, displayName)
		SELECT
		N.association.value('@subclientName','NVARCHAR(MAX)') AS subclientName,
		N.association.value(('@fileId'),'INT') AS fileId,
		N.association.value('@fileName','NVARCHAR(MAX)') AS fileName,
		0 AS isFile,
		N.association.value('@systemDbFlags','INT') AS systemDbFlags,
		N.association.value('../@fileGroupId','INT') AS fileGroupId,
		N.association.value('../@groupName','NVARCHAR(MAX)') AS fileGroupName,
		N.association.value('../@groupName','NVARCHAR(MAX)') + ':' + N.association.value('@logicalFileName','NVARCHAR(MAX)') AS displayName
		FROM   @xmlText.nodes('/App_SetSQLSubclientContentAssociationReq/contentAssociation/sqlFFGAssociation/sqlFileInfo') AS N(association)
		-- Populating current File/FileGroup association.
		INSERT INTO #currentAssociation
		SELECT APP.id, APP.subclientName, ASP1.attrName
		FROM APP_Application APP WITH (NOLOCK)
			INNER JOIN APP_SubClientProp ASP1 WITH (NOLOCK)
				ON APP.id = ASP1.componentNameId
			INNER JOIN APP_SubClientProp ASP2 WITH (NOLOCK)
				ON APP.id = ASP2.componentNameId
			INNER JOIN APP_SubClientProp ASP3 WITH (NOLOCK)
				ON APP.id = ASP3.componentNameId
				AND APP.clientId = @clientId
				AND APP.instance = @instanceId
				AND App.appTypeId = 81 --MSSQL App Type
				AND App.subclientStatus <> 4
				AND ASP1.attrType = 119 -- MSSQL FFG attrVal
				AND ASP1.modified = 0
				AND ASP2.attrName = N'mssql subclient type'
				AND ASP2.attrVal = N'2'
				AND ASP2.modified = 0
				AND ASP3.attrType = 118
				AND ASP3.modified = 0
				AND ASP3.attrName = @databaseName
		-- Adding all FFG to list which does not have association in request.
		INSERT INTO #contentRemoved
		SELECT CA.subclientId, CA.contentName
			FROM #newFFGAssociation FFGREQ
				INNER JOIN #currentAssociation CA
					ON FFGREQ.displayName = CA.contentName
					AND (FFGREQ.subclientName = N''
						OR FFGREQ.subclientName IS NULL)
		-- Removing unsupported subclient association.
		DELETE FROM #newFFGAssociation WHERE subclientName = N'' OR subclientName IS NULL
		-- Removing all file association from request if filegroup has association
		DELETE FILEREQ
			FROM #newFFGAssociation FGREQ
			INNER JOIN #newFFGAssociation FILEREQ
				ON FGREQ.fileGroupId = FILEREQ.fileGroupId
				AND FGREQ.fileId IS NULL
				AND FILEREQ.fileId IS NOT NULL
		-- In case of create subclient request, we need to get subclientId from DB, getting all IDs from App_Application.
		UPDATE AREQ SET AREQ.subclientId = APP.id
		FROM #newFFGAssociation AREQ
			INNER JOIN APP_Application APP WITH (NOLOCK)
				ON AREQ.subclientName = APP.subclientName
				AND App.clientId = @clientId
				AND App.instance = @instanceId
				AND App.appTypeId = 81
				AND App.subclientStatus <> 4
		-- Getting all subclients of given instance and database.
		INSERT INTO #subclients
			SELECT APP.id, APP.subclientName, hasContent = 1
			FROM APP_Application APP WITH (NOLOCK)
				INNER JOIN APP_SubClientProp ASP1 WITH (NOLOCK)
					ON APP.id = ASP1.componentNameId
				INNER JOIN APP_SubClientProp ASP2 WITH (NOLOCK)
					ON App.id = ASP2.componentNameId
					AND App.clientId = @clientId
					AND App.instance = @instanceId
					AND App.appTypeId = 81
					AND App.subclientStatus <> 4
					AND ASP1.attrName = N'mssql subclient type'
					AND ASP1.attrVal = N'2'
					AND ASP1.modified = 0
					AND ASP2.attrType = 118
					AND ASP2.modified = 0
					AND ASP2.attrName = @databaseName
		--Getting all subclient from request.
		INSERT INTO #subclientInRequest(subclientId, subclientName)
		SELECT DISTINCT(subclientId), subclientName FROM #newFFGAssociation
		-- Removing subclient which are already associated with given database
		DELETE SCREQ
			FROM #subclientInRequest SCREQ
			LEFT OUTER JOIN #subclients SCDB
				ON SCREQ.subclientId = SCDB.subclientId
				WHERE SCDB.subclientId IS NOT NULL
		--Adding subclient(for which database will change) in main subclient list.
		INSERT INTO #subclients(subclientId, subclientName, hasContent)
		SELECT subclientId, subclientName, 1 FROM #subclientInRequest
		IF @contentXML.exist('/Api_GetSQLFFGListResponse/sqlFileGroupInfo') = 1
			SET @isCMDRequest = 1
		IF @isCMDRequest <> 1 -- If request from GUI, then skipping validations
			GOTO SKIP_FFG_VALIDATION
		-- If subclient doesn't exist, generate error.
		IF EXISTS(SELECT 1 FROM #newFFGAssociation WHERE subclientId IS NULL)
		BEGIN
SET @errorCode = (3196 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SELECT @errorString = COALESCE(@errorString+',' ,'') + subclientName FROM  #newFFGAssociation WHERE subclientId IS NULL
			GOTO EXIT_ERROR
		END
		-- Checking if request contains files but filegroup is already associated with another subclient
		INSERT INTO #ffgList(ffgName)
		SELECT REQFILE.displayName
			FROM #newFFGAssociation REQFILE
				INNER JOIN #currentAssociation CA
					ON REQFILE.displayName LIKE CA.contentName +':%'
		--If exist, generate error
		IF EXISTS(SELECT 1 FROM #ffgList)
		BEGIN
SET @errorCode = (3194 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SELECT @errorString = COALESCE(@errorString +',' ,'') + ffgName FROM  #ffgList
			GOTO EXIT_ERROR
		END
		--Getting all FFG subclient of given instance.
		INSERT INTO #ffgSubclientList
			SELECT APP.id, APP.subclientName
			FROM APP_Application APP WITH (NOLOCK)
				INNER JOIN APP_SubClientProp ASP WITH (NOLOCK)
					ON APP.id = ASP.componentNameId
					AND App.clientId = @clientId
					AND App.instance = @instanceId
					AND App.appTypeId = 81
					AND App.subclientStatus <> 4
					AND ASP.attrName = N'mssql subclient type'
					AND ASP.attrVal = N'2'
					AND ASP.modified = 0
		-- If subclient is not part of given instance and FFG type then generate error.
		INSERT INTO #subclientList
		SELECT DISTINCT AREQ.subclientName FROM #newFFGAssociation AREQ
							LEFT OUTER JOIN #ffgSubclientList SC
							ON AREQ.subclientId = SC.subclientId
							WHERE SC.subclientId IS NULL
		IF EXISTS(SELECT 1 FROM #subclientList)
		BEGIN
SET @errorCode = (3206 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SELECT @errorString = COALESCE(@errorString+',' ,'') + name FROM #subclientList
			GOTO EXIT_ERROR
		END
		-- Checking if request has multiple entry for single File or filegroup
		INSERT INTO #ffgList(ffgName)
		SELECT displayName FROM #newFFGAssociation
		GROUP BY displayName HAVING COUNT(displayName) > 1
		-- If exist, generate error.
		IF EXISTS(SELECT 1 FROM #ffgList)
		BEGIN
SET @errorCode = (3193 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SELECT @errorString = COALESCE(@errorString +',' ,'') + ffgName FROM  #ffgList
			GOTO EXIT_ERROR
		END
		-- In case file or fileGroup Id not provided or wrong, than load from SQL instance
		--Inserting filegroups
		INSERT INTO #ffg(fileGroupId, fileGroupName, displayName)
			SELECT
			N.ffg.value('@fileGroupId','INT') AS databaseId,
			N.ffg.value('@groupName','NVARCHAR(MAX)') AS databaseName,
			N.ffg.value('@groupName','NVARCHAR(MAX)') AS displayName
			FROM   @contentXML.nodes('/Api_GetSQLFFGListResponse/sqlFileGroupInfo') AS N(ffg)
		--Inserting files
		INSERT INTO #ffg(fileId, fileName, fileGroupId, fileGroupName, displayName)
			SELECT
			N.ffg.value('@fileId','INT') AS fileId,
			N.ffg.value('@logicalFileName','NVARCHAR(MAX)') AS fileName,
			N.ffg.value('../@fileGroupId','INT') AS fileGroupId,
			N.ffg.value('../@groupName','NVARCHAR(MAX)') AS groupName,
			N.ffg.value('../@groupName','NVARCHAR(MAX)') + ':' + N.ffg.value('@logicalFileName','NVARCHAR(MAX)') AS displayName
			FROM   @contentXML.nodes('/Api_GetSQLFFGListResponse/sqlFileGroupInfo/sqlFileInfo') AS N(ffg)
			UPDATE #newFFGAssociation SET fileId = NULL, fileGroupId = NULL
			UPDATE ASSOC SET ASSOC.fileGroupId = FFG.fileGroupId, ASSOC.fileId = FFG.fileId
			FROM #newFFGAssociation ASSOC
				INNER JOIN #ffg FFG
					ON ASSOC.displayName = FFG.displayName
		-- Generating error in case of file or filegroup doesn't exist.
		IF EXISTS(SELECT 1 FROM #newFFGAssociation WHERE fileGroupId IS NULL OR (fileName IS NOT NULL AND fileId IS NULL))
		BEGIN
SET @errorCode = (3192 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SELECT @errorString = COALESCE(@errorString+',' ,'') + displayName FROM  #newFFGAssociation
					WHERE fileGroupId IS NULL OR (fileName IS NOT NULL AND fileId IS NULL)
			GOTO EXIT_ERROR
		END
		SKIP_FFG_VALIDATION:
		-- Removing all association from request which are already present
		DELETE AREQ
		FROM #currentAssociation AC
			INNER JOIN #newFFGAssociation AREQ
				ON AC.contentName = AREQ.displayName
				AND AC.subClientID = AREQ.subClientID
		-- Listing all the associations which are going to removed.
		INSERT INTO #contentRemoved
		SELECT AC.subClientID, AC.contentName
			FROM #currentAssociation AC
				INNER JOIN #newFFGAssociation AREQ
					ON AC.contentName = AREQ.displayName
					OR (AC.contentName LIKE AREQ.fileGroupName+':%'
						AND AREQ.fileId IS NULL)-- If request contain filegroup then remove all files Association
		-- If changing database, then remove all content of subclient from existing database.
		IF EXISTS(SELECT 1 FROM #subclientInRequest)
		BEGIN
			INSERT INTO #contentRemoved
			SELECT SCP.componentNameId, SCP.attrName
				FROM APP_SubClientProp SCP
					INNER JOIN #subclientInRequest SCREQ
						ON SCP.componentNameId = SCREQ.subclientId
						AND SCP.attrType = 119
						AND SCP.modified = 0
		END
		-- Inserting default values in case of NULL.
		UPDATE #newFFGAssociation SET fileId = 0 WHERE fileId IS NULL
		UPDATE #newFFGAssociation SET isFile = 0 WHERE isFile IS NULL
		UPDATE #newFFGAssociation SET systemDbFlags = 0 WHERE systemDbFlags IS NULL
		IF @isCMDRequest <> 1 -- Skip if request from GUI
			GOTO SKIP_FFG_SC_VALIDATION
		-- Removing all associations, which are going to be removed from current association
		DELETE AC
		FROM #currentAssociation AC
			INNER JOIN #contentRemoved CR
				ON AC.contentName = CR.contentName
		-- Adding all new association to currect association table
		INSERT INTO #currentAssociation
		SELECT subclientId, subclientName, displayName
		FROM #newFFGAssociation
		-- Checking if all listed subclients has contents after new association
		UPDATE #subclients SET hasContent = 0
		FROM #subclients SC
		LEFT OUTER JOIN  #currentAssociation AREQ ON  SC.subclientId = AREQ.subclientId
		WHERE AREQ.subclientId IS NULL
		-- If any subclient from list is without content then generate error.
		IF EXISTS(SELECT 1 FROM #subclients WHERE hasContent = 0)
		BEGIN
SET @errorCode = (3195 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SELECT @errorString = COALESCE(@errorString+',' ,'') + subclientName FROM  #subclients WHERE hasContent = 0
			GOTO EXIT_ERROR
		END
		SKIP_FFG_SC_VALIDATION:
		---- Removing contents from subclient
		UPDATE APP SET modified = @nowTime
		FROM APP_SubClientProp APP
			INNER JOIN #contentRemoved REM
				ON APP.componentNameId = REM.subclientId
				AND APP.attrType = 119
				AND App.attrName = REM.contentName
				AND APP.modified = 0
		----Adding contents to subclient
		INSERT app_subClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
		SELECT subclientId, displayName, 119,
			CAST(fileId AS NVARCHAR(10))+ ' ' + CAST(fileGroupId AS NVARCHAR(10)) + ' ' + CAST(isFile AS NVARCHAR(10)) + ' '+ CAST(systemDbFlags AS NVARCHAR(10)),
			@nowTime, 0, 0
		FROM #newFFGAssociation
		IF EXISTS(SELECT 1 FROM #subclientInRequest)
		BEGIN
			--Writing old database name for audit.
			UPDATE SCREQ SET SCREQ.oldDatabase = SCP.attrName
			FROM #subclientInRequest SCREQ
				INNER JOIN APP_SubClientProp SCP WITH(NOLOCK)
					ON SCP.componentNameId = SCREQ.subclientId
					AND SCP.attrType = 118
					AND modified = 0
			-- Removing old database association for subclient if subclient belongs to other database.
			UPDATE APP SET modified = @nowTime
			FROM APP_SubClientProp APP
				INNER JOIN #subclientInRequest SCREQ
					ON APP.componentNameId = SCREQ.subclientId
					AND modified = 0
					AND (APP.attrType = 118
						OR attrName = N'mssql FFG db Id'
						OR attrName = N'mssql FFG db Name')
			-- Adding association with database
			INSERT app_subClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
			SELECT subclientId, @databaseName, 118, CAST(@databaseID AS NVARCHAR(10)) + ' 0' , @nowTime, 0, 0
			FROM #subclientInRequest
			INSERT app_subClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
			SELECT subclientId, N'mssql FFG db Id', 7, @databaseID , @nowTime, 0, 0
			FROM #subclientInRequest
			INSERT app_subClientProp (componentNameId, attrName, attrType,  attrVal, created, modified, ccpId)
			SELECT subclientId, N'mssql FFG db Name', 1, @databaseName , @nowTime, 0, 0
			FROM #subclientInRequest
		END
		--Generating content table for audit.
		INSERT INTO #auditContent (subclientId, subclientName, contentAdded, contentRemoved, databaseRemoved)
		SELECT  subclientId, subclientName,
			STUFF((SELECT ', ' + displayName [text()]
				FROM #newFFGAssociation
				WHERE subclientId = SC.subclientId
				FOR XML PATH(''), TYPE)
			.value('.','NVARCHAR(MAX)'),1,2,' ') contentAdded,
			STUFF((SELECT ', ' + contentName [text()]
				FROM #contentRemoved
				WHERE subclientId = SC.subclientId
				FOR XML PATH(''), TYPE)
			.value('.','NVARCHAR(MAX)'),1,2,' ') contentRemoved,
			(SELECT  oldDatabase FROM #subclientInRequest WHERE subclientId = SC.subclientId) databaseRemoved
		FROM #subclients SC
	END
		-- Generating audit XML
		SET @xmlText = (SELECT
							(SELECT @instanceEntity),
							(SELECT
								@databaseId AS '@id',
								@databaseName AS '@name'
								FOR XML PATH('database'), TYPE),
							(SELECT
								LTRIM(RTRIM(contentAdded)) AS '@contentAdded',
								LTRIM(RTRIM(contentRemoved)) AS '@contentRemoved',
								LTRIM(RTRIM(databaseRemoved)) AS '@databaseRemoved',
								(SELECT
									subclientId AS '@subclientId',
									subclientName AS '@subclientName'
								FOR XML PATH('subclient'),TYPE)
							FROM #auditContent WHERE contentAdded IS NOT NULL OR contentRemoved IS NOT NULL
							FOR XML PATH('subclientAndContents'),TYPE)
						FOR XML PATH('Api_MSSQLSubclientAuditForContentModification'))
	EXIT_ERROR:
	IF object_id('tempdb.dbo.#newDBAssociation') IS NOT NULL DROP TABLE #newDBAssociation
	IF object_id('tempdb.dbo.#database') IS NOT NULL DROP TABLE #database
	IF object_id('tempdb.dbo.#newFFGAssociation') IS NOT NULL DROP TABLE #newFFGAssociation
	IF object_id('tempdb.dbo.#ffg') IS NOT NULL DROP TABLE #ffg
	IF object_id('tempdb.dbo.#ffgList') IS NOT NULL DROP TABLE #ffgList
	IF object_id('tempdb.dbo.#subclientInRequest') IS NOT NULL DROP TABLE #subclientInRequest
	IF object_id('tempdb.dbo.#ffgSubclientList') IS NOT NULL DROP TABLE #ffgSubclientList
	IF object_id('tempdb.dbo.#subclientList') IS NOT NULL DROP TABLE #subclientList
	IF object_id('tempdb.dbo.#subclients') IS NOT NULL DROP TABLE #subclients
	IF object_id('tempdb.dbo.#contentRemoved') IS NOT NULL DROP TABLE #contentRemoved
	IF object_id('tempdb.dbo.#auditContent') IS NOT NULL DROP TABLE #auditContent
	IF object_id('tempdb.dbo.#currentAssociation') IS NOT NULL DROP TABLE #currentAssociation
		IF @errorCode <> 0
		BEGIN
			SET @message = (select message from EvLocaleMsgs WITH (NOLOCK) Where [messageId] = @errorCode AND [localeId] = @localeId)
			SET @message = REPLACE(@message, '^1%s',@errorString)
			SET @xmlText = (SELECT
							@errorCode AS '@errorCode',
							@message AS '@errorString'
							FOR XML PATH('App_GenericEntityResponse'))
		END
	SELECT @xmlText AS ReturnResult
GO

IF EXISTS (select * from GxQscripts where name = 'ValidateAndUpdateSQLSubclientContents')
	delete from GxQscripts where name = 'ValidateAndUpdateSQLSubclientContents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ValidateAndUpdateSQLSubclientContents')
	delete from GXDBVersions where aliasname = 'ValidateAndUpdateSQLSubclientContents'
GO

insert into GXDBVersions values(2, 'ValidateAndUpdateSQLSubclientContents',  '00000000000000000000', 'ValidateAndUpdateSQLSubclientContents', '00000000000000000000')
GO

