

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VTUpdateMediaInAction.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VTUpdateMediaInAction.sp,v $ $Id: VTUpdateMediaInAction.sp,v 1.23.178.5 2018/03/20 20:04:51 jiechen Exp $";
--  +========================================================================+
--  | Stored Precedure: VTUpdateMediaInAction()
--  | Description:  runs after updating lcp configure. This SP will scan the
--	|				whereabouts of the media that are in pending action and
--	|				has operatoin state of ready or running. update the state of the
--	|				pending action.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VTUpdateMediaInAction <<<'

IF EXISTS (select * from sysobjects where name='VTUpdateMediaInAction')
	drop procedure VTUpdateMediaInAction
IF EXISTS (select * from GxQscripts where name='VTUpdateMediaInAction')
	delete from GxQscripts where name = 'VTUpdateMediaInAction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTUpdateMediaInAction')
	delete from GXDBVersions where aliasname = 'VTUpdateMediaInAction'
GO
print '... Creating Procedure: VTUpdateMediaInAction'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure VTUpdateMediaInAction
  @i_jobId_h INTEGER,
  @i_jobId_l INTEGER
AS
  DECLARE @retVal INTEGER;
  DECLARE @errorString VARCHAR(1024);
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRANSACTION VTUpdateMediaTran
/****************************************************************************************/
/************ Initialize and DECLARE temparary variables ********************************/
/****************************************************************************************/
	DECLARE @mediaId				INTEGER
	DECLARE @startdt				datetime
	DECLARE @dt						datetime
DECLARE	@barCode				varchar(256)
	DECLARE @actionId				INTEGER
	DECLARE @policyId				INTEGER
DECLARE @policyName				nvarchar(128)
	DECLARE @jobId_h				INTEGER
	DECLARE @jobId_l				INTEGER
	DECLARE @jobType				INTEGER
	DECLARE @operationState			INTEGER
	DECLARE @operation				INTEGER
	DECLARE @sourceId				INTEGER
	DECLARE @sourceLocationType		INTEGER
	DECLARE @currentId				INTEGER
	DECLARE @destinationId			INTEGER
	DECLARE @destLocationType		INTEGER
	DECLARE @destValue				INTEGER
	DECLARE @inTransitId			INTEGER
	DECLARE @inTransitValue			INTEGER
	DECLARE	@libraryId				INTEGER
	DECLARE	@libConnectionType		INTEGER
	DECLARE	@mediaLocation			INTEGER
	DECLARE @slotId					INTEGER
	DECLARE	@vmsSlotId				INTEGER
	DECLARE	@vmsDirection			INTEGER
	DECLARE	@exportLocationId		INTEGER
	DECLARE	@rowCount				INTEGER
	DECLARE	@checkTransaction		INTEGER
	DECLARE	@availableSlots			INTEGER
	DECLARE	@actionFlag				INTEGER
	DECLARE @sourceValue			INTEGER
	DECLARE @startVMS				INTEGER
	DECLARE @bayId					INTEGER
DECLARE @userName				varchar(255)
	DECLARE @userId					INTEGER
	DECLARE @flag					INTEGER
	DECLARE @containerId			INTEGER
	DECLARE @emptyslots				INTEGER
	DECLARE @state					INTEGER
	DECLARE @actionState			INTEGER
	DECLARE @numMailSlot			INTEGER
	DECLARE	@initiator				NVARCHAR(255)
	DECLARE @numMediaInContainer	INTEGER
	DECLARE	@containerCapacity		INTEGER
	DECLARE	@LibraryTypeId			INTEGER
	DECLARE @SlotTypeId				INTEGER
	DECLARE @actionType				INTEGER
	DECLARE	@destLibraryType		INTEGER
	DECLARE @exportError			INTEGER
	DECLARE	@dueBackTime			BIGINT
	DECLARE @parentContainerId		INTEGER
	DECLARE @ContainerCounter		INTEGER
	DECLARE @l_Containerindex		INTEGER
	DECLARE @l_currentTime			INTEGER
	DECLARE	@l_ContainerCleanupDays	INTEGER
	DECLARE @l_retryOnErrorInterval	INTEGER
	DECLARE @mediaAtDest			INTEGER
	DECLARE @mediaAtVMS				INTEGER
	DECLARE @new_currentId			INTEGER
	DECLARE @new_operationState		INTEGER
	DECLARE @new_operation			INTEGER
	DECLARE @new_state				INTEGER
	DECLARE @curor_open INTEGER
	set @curor_open = 0
	SET @retVal = 0
	SET	@initiator = ''
	SET @errorString = 'Failed to update media movement: '
	SET @parentContainerId = 0
	SET @ContainerCounter = 0
	set @l_Containerindex = 2
	SET @l_currentTime = (select dbo.getUnixTime(getUTCDate()))
	DECLARE @ExportStandAloneTape integer = 0
	SET @ExportStandAloneTape		= (select value from MMConfigs where name = 'MMS2_CONFIG_STRING_VT_EXPORT_STANDALONE_TAPE')
	SET @l_ContainerCleanupDays		= (select value from MMConfigs where name = 'MMS2_CONFIG_STRING_VT_CONTAINER_CLEANUP_INTERVAL_DAYS')
	SET @l_retryOnErrorInterval		= (select Value from MMConfigs where name = 'MMS2_CONFIG_STRING_VAULTTRACKER_RETRY_INTERVAL_MIN')
	--Convert the retry interval into seconds
	SET @l_retryOnErrorInterval = @l_retryOnErrorInterval * 60
/****************************************************************************************/
	-- Add non existing exportlocation and library into VTLocation table
	-- "Any library" destination: type = TM_LOCATION_TYPE_SLOT and value = 0
	-- Shelf location: type = TM_LOCATION_TYPE_SLOT and value = LibraryId and LibraryTypeId = CV_LIB_SHELF
	INSERT	INTO VTLocation
SELECT	1, LibraryId
	FROM	MMLibrary WITH (NOLOCK)
WHERE	LibraryTypeId != 3
AND		LibraryId NOT IN (SELECT Value FROM VTLocation WITH (NOLOCK) WHERE Type = 1)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT	INTO VTLocation
SELECT	2, ExportLocationId
	FROM	MMExportLocation WITH (NOLOCK)
WHERE	ExportLocationId NOT IN (SELECT Value FROM VTLocation WITH (NOLOCK) WHERE Type = 2)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT	INTO VTLocation
SELECT	4, LibraryId
	FROM	MMLibrary WITH (NOLOCK)
	WHERE	LibraryId > 0
AND		LibraryTypeId != 3
AND		LibraryTypeId != 8
	AND		StartVMSElementAddress != 0
AND		LibraryId NOT IN (SELECT Value FROM VTLocation WITH (NOLOCK) WHERE Type = 4)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
/****************************************************************************************/
/********************** Create temparary tables *****************************************/
/****************************************************************************************/
	DECLARE @tblMediaToExport TABLE(
		MediaId int,
		LibraryId int
	)
	DECLARE @VTMediaToUpdateAlert TABLE(
		AlertAction int,
		Initiator NVARCHAR(1024),
		ActionId int,
		MediaId int,
		SourceId int,
		InTransitId int,
		DestinationId int
	)
	DECLARE @VTMediaToUpdateList TABLE(
			MediaId INT,
			ActionId INT,
			PolicyId INT,
PolicyName nvarchar(128),
			JobId_h INT,
			JobId_l INT,
			JobType INT,
			UserId INT,
UserName varchar(255),
			OperationState INT,
			Operation INT,
			SourceId INT,
			CurrentId INT,
			DestinationId INT,
			InTransitId INT,
			LibraryId INT,
			libConnectionType INT,
			MediaLocation INT,
			SlotId	INT,
			VMSSlotId INT,
			VMSDirection INT,
			ExportLocationId INT,
			DestLocationType INT,
			DestValue INT,
			StartTime datetime,
BarCode	varchar(256),
			ActionFlag INT,
			SourceLocationType INT,
			SourceValue INT,
			BayId INT,
			Flag INT,
			ContainerId INT,
			ExportError INT,
			DueBackTime	BIGINT,
			LibraryTypeId	INT,
			SlotTypeId	INT,
			ActionType	INT,
			State		INT,
			ActionState INT,
			NumMailSlot INT
	)
	DECLARE @tblActionCmdReturn table (cmdRetVal int, mediaProcessed int, mediaSkipped int, errString VARCHAR(1024))
/****************************************************************************************/
/******************** First cleanup some media that are still lying in ******************/
/******************** VTAlerts table but are not in the mail slots anymore.**************/
/****************************************************************************************/
	-- InTransitId is set to -2 in MMS2GetMediaListInCap
	-- It is to indicate that the Consolidated e-mail for these media is already being sent
	-- so that the next time we will not pick these media and will be deleted by RunTmUpdate
	delete from VTAlerts
where AlertAction = 41 AND InTransitId = -2
	AND EXISTS(select MM.MediaId from MMMedia AS MM WITH (NOLOCK)
	where MM.MediaId = VTAlerts.MediaId AND MM.MediaLocation in(2, 3))
	delete from VTAlerts
where AlertAction = 41 AND InTransitId = -2
	AND EXISTS(select MS.MediaId from MMSlot AS MS WITH (NOLOCK)
	where MS.MediaId = VTAlerts.MediaId AND MS.SlotType = 1)
	-- If an action was aborted or otherwise failed, remove the the entries from the VTAlerts table
	-- because otherwise in the summary of the next export action will have the list of the media
	-- exported in the aborted action also which might be confusing to the user.
	delete from VTAlerts
where AlertAction = 41
	AND NOT EXISTS(select ActionId from VTAction as TMA WITH (NOLOCK) where TMA.ActionId = VTAlerts.ActionId)
	AND EXISTS
	(
		select MediaId from VTHistory as TMH  WITH (NOLOCK)where TMH.ActionId = VTAlerts.ActionId
		AND TMH.MediaId = VTAlerts.MediaId
AND TMH.State <> 2
	)
/****************************************************************************************/
/**************** Update and Clean up the Containers ************************************/
/****************************************************************************************/
	-- get list of containers that are actually used
	DECLARE @lt_ContainerList TABLE (containerId INTEGER)
	insert into @lt_ContainerList
	select distinct ContainerId
	from MMMedia WITH (NOLOCK)
	where ContainerId > 0
	--1. Update the containers isEmptyFlag and set the lastEmpty time as now if they are empty now
	update MMContainer
	set IsEmpty = 1, ContainerEmptyTime = @l_currentTime
	where ContainerId not in (select containerId FROM @lt_ContainerList)
	AND IsEmpty = 0
	--2. Update the containers isEmptyFlag and reset the lastEmpty time if they are not empty now
	update MMContainer
	set IsEmpty = 0, ContainerEmptyTime = 0
	where ContainerId in (select containerId FROM @lt_ContainerList)
	AND IsEmpty = 1
	--3. Delete all the containers that are there for more than n days
	--And, not referenced in either of TMPolicy or TMAction.
	delete from MMContainer
	where ContainerId > 0 AND IsEmpty = 1 AND
	ContainerId not in
	(
		select containerId from VTPolicy WITH (NOLOCK) where ContainerId > 0
		union
		select ContainerId from VTAction WITH (NOLOCK) where ContainerId > 0
	)
	AND
	((@l_currentTime - ContainerEmptyTime)/(60*60*24) > @l_ContainerCleanupDays)
/****************************************************************************************/
/******************** Insert into temprary tables ***************************************/
/****************************************************************************************/
	INSERT	INTO @tblMediaToExport
	SELECT	MediaId, LibraryId
	FROM	MMMedia WITH (NOLOCK)
	WHERE	MediaLocation in (1,2)
AND		(Attributes & 1) > 0
	INSERT	INTO @VTMediaToUpdateList
	SELECT	a.MediaId, a.ActionId, b.PolicyId, 'N/A', b.JobId_h, b.JobId_l, b.JobType, b.UserId, 'Unknown',
			a.OperationState, a.Operation, b.SourceId, a.CurrentId, b.DestinationId,
			b.InTransitId, e.LibraryId, 0, e.MediaLocation, 0, 0, 0, e.ExportLocationId, d.Type, d.Value,
			b.StartTime, e.BarCode, b.Flag, 0, 0, 0, a.Flag, b.ContainerId, a.ExportError, a.DueBackTime, 0, 0,
			b.ActionType, a.State, b.ActionState, 0
	FROM	VTActionMedia a WITH (NOLOCK), VTAction b WITH (NOLOCK), VTLocation d WITH (NOLOCK), MMMedia e WITH (NOLOCK)
	WHERE	a.MediaId > 0
	AND		a.ActionId = b.ActionId
	AND		d.LocationId = b.DestinationId
	AND		a.MediaId = e.MediaId
	AND		( ( (@i_jobId_l != 0 OR @i_jobId_h != 0) AND b.JobId_l = @i_jobId_l AND b.JobId_h = @i_jobId_h)
	OR		  ( @i_jobId_l >= 0 AND @i_jobId_h >= 0 ) )
	SELECT	@retVal = @@ERROR, @rowCount = @@ROWCOUNT
	IF		@retVal != 0
	BEGIN
			SET @errorString = @errorString + 'fail to insert into @VTMediaToUpdateList'
			GOTO CX_ERROR_EXIT
	END
	IF		@rowCount = 0
	BEGIN
			/* not really an error */
			SET @errorString = 'No media needs update'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
	/* fill in LibraryId and SlotId */
	UPDATE	@VTMediaToUpdateList
	SET		SlotId = b.SlotId, SlotTypeId = b.SlotType
	FROM	@VTMediaToUpdateList a, MMSlot b WITH (NOLOCK)
	WHERE	a.MediaLocation = 1
	AND		a.MediaId = b.MediaId
	DECLARE @tblLibraryMailSlotCount table (libraryId int, numMailSlot int)
	DECLARE @tblLibraryMailSlot table (libraryId int, slotId int, mediaId int)
	INSERT	INTO @tblLibraryMailSlotCount
	SELECT	b.libraryId, COUNT(*)
	FROM	MMSlot a WITH (NOLOCK), MMLibrary b WITH (NOLOCK), MMBay c WITH (NOLOCK)
	WHERE	a.BayId = c.BayId
	AND		c.LibraryId = b.LibraryId
	AND		a.SlotType in (2, 3)
	GROUP	BY b.libraryId
	INSERT	INTO @tblLibraryMailSlot
	SELECT	b.libraryId, a.SlotId, a.MediaId
	FROM	MMSlot a WITH (NOLOCK), MMLibrary b WITH (NOLOCK), MMBay c WITH (NOLOCK)
	WHERE	a.BayId = c.BayId
	AND		c.LibraryId = b.LibraryId
	AND		a.SlotType in (2, 3)
	UPDATE	@tblLibraryMailSlot
	SET		MediaId = 0
	FROM	@tblLibraryMailSlot a, MMMedia b
	WHERE	a.MediaId = b.MediaId
	AND		( a.libraryId <> b.libraryId or b.MediaLocation = 3)
	/* fill in mailslot info */
	UPDATE	@VTMediaToUpdateList
	SET		NumMailSlot = b.numMailSlot
	FROM	@VTMediaToUpdateList a, @tblLibraryMailSlotCount b
	WHERE	a.LibraryId = b.LibraryId
	/* fill in virtual mailslot info */
	UPDATE	@VTMediaToUpdateList
	SET		VMSSlotId = a.SlotId, VMSDirection = c.VMSDirection, BayId = b.BayId
	FROM	MMBay b WITH (NOLOCK), MMSlot a WITH (NOLOCK), MMLibrary c WITH (NOLOCK), @VTMediaToUpdateList d
	WHERE	d.LibraryId > 0
	AND		d.MediaLocation in (1,2)
	AND		d.LibraryId = b.LibraryId
	AND		b.BayId = a.BayId
	AND		a.ElementAddress = c.StartVMSElementAddress
	AND		c.LibraryId = b.LibraryId
	AND		c.StartVMSElementAddress != 0
	AND		a.SlotType = 1
	SELECT @dt = GETUTCDATE()
	UPDATE	@VTMediaToUpdateList
	SET		PolicyName = a.PolicyName
	FROM	VTPolicy a WITH (NOLOCK), @VTMediaToUpdateList b
	WHERE	b.PolicyId > 0
	AND		b.PolicyId = a.PolicyId
	UPDATE	@VTMediaToUpdateList
	SET		UserName = a.login
	FROM	UMUsers a, @VTMediaToUpdateList b
	WHERE	b.UserId > 0
	AND		b.UserId = a.id
	UPDATE	@VTMediaToUpdateList
	SET		SourceLocationType = a.Type, SourceValue = a.Value
	FROM	VTLocation a WITH (NOLOCK), @VTMediaToUpdateList b
	WHERE	b.SourceId > 0
	AND		b.SourceId = a.LocationId
	UPDATE	@VTMediaToUpdateList
	SET		LibraryTypeId = a.LibraryTypeId
	FROM	MMLibrary as a WITH (NOLOCK), @VTMediaToUpdateList as b
	WHERE	b.LibraryId > 0
	AND		b.LibraryId = a.LibraryId
	UPDATE	@VTMediaToUpdateList
	SET		LibConnectionType = a.ConnectionType
	FROM	MMLibraryController as a WITH (NOLOCK), @VTMediaToUpdateList as b
	WHERE	b.LibraryId > 0
	AND		b.LibraryId = a.LibraryId
/****************************************************************************************/
/****************** For every MediaId, run command **************************************/
/****************************************************************************************/
	DECLARE VTMediaToUpdateCur CURSOR FOR
			SELECT	DISTINCT MediaId, ActionId, PolicyId, PolicyName, JobId_h, JobId_l, JobType, UserId, UserName,
					OperationState, Operation, SourceId, CurrentId, DestinationId, InTransitId, LibraryId, LibConnectionType, MediaLocation,
					SlotId, VMSSlotId, VMSDirection, ExportLocationId, DestLocationType, DestValue,
					StartTime, BarCode, ActionFlag, SourceLocationType, SourceValue, BayId, Flag, ContainerId,
					ExportError, DueBackTime, LibraryTypeId, SlotTypeId, ActionType, State, ActionState, NumMailSlot
			FROM	@VTMediaToUpdateList
	OPEN	VTMediaToUpdateCur
	set @curor_open = 1
	FETCH	NEXT FROM VTMediaToUpdateCur
	INTO	@mediaId, @actionId, @policyId, @policyName, @jobId_h, @jobId_l, @jobType, @userId, @userName,
			@operationState, @operation, @sourceId, @currentId, @destinationId, @inTransitId, @libraryId, @LibConnectionType, @mediaLocation,
			@slotId, @vmsSlotId, @vmsDirection, @exportLocationId, @destLocationType, @destValue,
			@startdt, @barCode, @actionFlag, @sourceLocationType, @sourceValue, @bayId, @flag, @containerId,
			@exportError, @dueBackTime, @LibraryTypeId, @SlotTypeId, @actionType, @state, @actionState, @numMailSlot
/****************************************************************************************/
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		SET @mediaAtDest = 0
		SET @mediaAtVMS = 0
		set @new_currentId = 0
		SET @new_state = 0
		SET @new_operation = 0
		SET @new_operationState = 0
IF @destLocationType = 1
		BEGIN
			SELECT @destLibraryType = libraryTypeId
			FROM	MMLibrary WITH (NOLOCK)
			WHERE	LibraryId = @destValue
		END
		IF	@inTransitId = 0
		BEGIN
			SELECT	@inTransitId = LocationId
			FROM	VTLocation WITH (NOLOCK)
WHERE	Type = 2
AND		Value = 0
		END
		SELECT @inTransitValue = (SELECT Value FROM VTLocation WHERE LocationId = @inTransitId)
		-- Set temp action flag value only in this stored procedure
		-- The actual action flag value is not changed
IF	@actionFlag & 4 > 0
			AND @vmsSlotId = 0
		BEGIN
			-- Cannot use VMS if it is not defined
SET @actionFlag = @actionFlag &~ 4
		END
ELSE IF @actionFlag & 4 = 0
			AND @vmsSlotId > 0 AND @numMailSlot = 0
		BEGIN
			-- Media in library without mail slot but with VMS will be exported through VMS
SET @actionFlag = @actionFlag | 4
		END
		IF @policyId > 0
			SET @initiator = 'Policy: ' + @policyName
		ELSE if @jobId_l > 0
			SET @initiator = 'Job: ' + CONVERT(varchar(10), @jobId_l)
		ELSE
			SET @initiator = 'User: ' + @userName
IF	(@actionFlag & 4) > 0
			AND @mediaLocation <> 3
			AND @SlotTypeId not in (2, 3)
		BEGIN
			-- Get the total number of empty virtual mail slot available
			SELECT	@emptyslots = COUNT(*)
			FROM	MMSlot WITH (NOLOCK)
WHERE	( (@vmsDirection = 1 AND SlotId >= @vmsSlotId)
OR		  (@vmsDirection = 2 AND SlotId <= @vmsSlotId) )
			AND (	IsOccupied = 0
					OR
					(	IsOccupied = 1
						AND
						(
							MediaId = 0
							OR
							(	MediaId > 0
								AND MediaId NOT IN (SELECT MediaId FROM @tblMediaToExport WHERE LibraryId = @libraryId)
							)
						)
					)
				)
			AND BayId = @bayId
			AND	SlotType = 1
			-- Get the number of empty virtual mail slot for current media
			SELECT	@availableSlots = COUNT(*)
			FROM	MMSlot WITH (NOLOCK)
WHERE	(	(@vmsDirection = 1 AND SlotId >= @vmsSlotId)
						AND	(SlotId < @slotId OR @vmsSlotId > @slotId)
OR	(@vmsDirection = 2 AND SlotId <= @vmsSlotId)
						AND (SlotId > @slotId OR @vmsSlotId < @slotId)
					)
			AND (	IsOccupied = 0
					OR
					(	IsOccupied = 1
						AND
						(
							MediaId = 0
							OR
							(	MediaId > 0
								AND MediaId NOT IN (SELECT MediaId FROM @tblMediaToExport WHERE LibraryId = @libraryId)
							)
						)
					)
				)
			AND BayId = @bayId
			AND	SlotType = 1
		END
IF	(@actionFlag & 4) = 0
			AND @numMailSlot > 0
			AND @mediaLocation <> 3
		BEGIN
			SELECT	@emptyslots = COUNT(*)
			FROM	@tblLibraryMailSlot
			WHERE	libraryId = @libraryId and MediaId = 0
		END
	/****************************************************************************************/
	/************** UPDATE MEDIA LOCATION  **************************************************/
	/****************************************************************************************/
		SET	@mediaAtVMS = 0
		-- Media at VMS may still need to be shuffled
IF	(@actionFlag & 4) > 0
				AND @mediaLocation = 1
				AND	@slotTypeId = 1
AND (  @vmsDirection = 1   AND @slotId >= @vmsSlotId
OR @vmsDirection = 2 AND @slotId <= @vmsSlotId )
		BEGIN
			SET	@mediaAtVMS = 1
		END
IF	@mediaAtVMS > 0 AND @state = 4
		BEGIN
			-- Media is at VMS
SET	@new_currentId = (SELECT ISNULL(MAX(LocationId), 0) FROM VTLocation WHERE Type = 4 AND Value = @libraryId)
		END
ELSE IF @mediaLocation <> 3 OR @mediaLocation = 3 AND @exportLocationId = 0 AND @LibraryTypeId IN (4, 5, 8)
		BEGIN
			-- Media is inside library or on shelf or belongs to stand alone library
SET	@new_currentId = (SELECT ISNULL(MAX(LocationId), 0) FROM VTLocation WHERE Type = 1 AND Value = @libraryId)
		END
		ELSE
		BEGIN
			-- Media is exported
SET	@new_currentId = (SELECT ISNULL(MAX(LocationId), 0) FROM VTLocation WHERE Type = 2 AND Value = @exportLocationId)
		END
		IF	@currentId <> @new_currentId
		BEGIN
			UPDATE	VTActionMedia
			SET		CurrentId = @new_currentId
			WHERE	MediaId = @mediaId
			AND		ActionId = @actionId
		END
	/****************************************************************************************/
	/************** DO NOT PROCESS MEDIA AT DESTINATION  ************************************/
	/****************************************************************************************/
IF	@state = 2
			GOTO CX_CONTINUE
	/****************************************************************************************/
	/************** PICK UP MEDIA OUTSIDE REGULAR LIBRARY ***********************************/
	/****************************************************************************************/
		-- Do not reach destination if pick-up is needed
		-- Pick up media automatically
		-- if auto-acknowledge is on and
		-- and transit location is defined and media is not at transit location
		-- and media is outside of regular library
		-- Note: destination can be anywhere
IF		(@actionFlag & 16) > 0
			AND @inTransitValue > 0
			AND @new_currentId <> @inTransitId
			AND (@mediaLocation = 3
				OR	@mediaLocation <> 3
AND @LibraryTypeId in (4, 5)
					AND NOT EXISTS (SELECT * FROM MMResource WHERE MediaId = @mediaId))
		BEGIN
			DELETE FROM @tblActionCmdReturn
			INSERT INTO @tblActionCmdReturn
EXEC VTRunActionCmd 8, @actionId, @mediaId, 0
			IF EXISTS (SELECT * FROM @tblActionCmdReturn WHERE cmdRetVal = 0)
				GOTO CX_CONTINUE
		END
	/****************************************************************************************/
	/************** REACH DESTINATION FOR MEDIA IMPORTED INTO LIBRARY ***********************/
	/****************************************************************************************/
		-- Reach destination automatically
		-- if destination is a regular library and media is in library
IF		@destLocationType = 1
AND	@destLibraryType NOT IN (4, 5, 8)
			AND	@mediaLocation in (1, 2) AND (@destValue = 0 OR @libraryId = @destValue)
		BEGIN
			DELETE FROM @tblActionCmdReturn
			INSERT INTO @tblActionCmdReturn
EXEC VTRunActionCmd 16, @actionId, @mediaId, 0
			IF EXISTS (SELECT * FROM @tblActionCmdReturn WHERE cmdRetVal = 0)
				GOTO CX_CONTINUE
		END
	/****************************************************************************************/
	/************** REACH DESTINATION FOR MEDIA EXPORTED ************************************/
	/****************************************************************************************/
		-- Reach destination automatically
		-- if auto-acknowledge is on
		-- and destination is export location
		-- and media is outside of regular library
IF		@destLocationType = 2
			AND @mediaLocation = 3
		BEGIN
			SET @mediaAtDest = 1
		END
		-- Reach destination automatically
		-- if auto-acknowledge is on
		-- and destination is export location
		-- and media is inside stand alone library and not loaded by resource manager
		IF @ExportStandAloneTape = 0
		BEGIN
IF		@destLocationType = 2
				AND @mediaLocation <> 3
AND @LibraryTypeId in (4, 5)
				AND NOT EXISTS (SELECT * FROM MMResource WHERE MediaId = @mediaId)
			BEGIN
				SET @mediaAtDest = 1
			END
		END
		-- Reach destination automatically
		-- if auto-acknowledge is on
		-- and destination is stand along library or shelf
		-- media is outside of regular library
IF		@destLocationType = 1
AND @destLibraryType IN (4, 5, 8)
			AND @mediaLocation = 3
		BEGIN
			SET @mediaAtDest = 1
		END
		-- Reach destination automatically
		-- if auto-acknowledge is on and
		-- and destination is stand along library or shelf
		-- and media is inside stand alone library and not loaded by resource manager
IF		@destLocationType = 1
AND @destLibraryType IN (4, 5, 8)
			AND @mediaLocation <> 3
AND @LibraryTypeId in (4, 5)
			AND NOT EXISTS (SELECT * FROM MMResource WHERE MediaId = @mediaId)
		BEGIN
			SET @mediaAtDest = 1
		END
	/****************************************************************************************/
	/************** REACH DESTINATION FOR MEDIA  ********************************************/
	/****************************************************************************************/
IF	@mediaAtDest = 1 AND (@actionFlag & 16) > 0
			 AND @inTransitValue = 0
		BEGIN
			DELETE FROM @tblActionCmdReturn
			INSERT INTO @tblActionCmdReturn
EXEC VTRunActionCmd 16, @actionId, @mediaId, 0
			IF EXISTS (SELECT * FROM @tblActionCmdReturn WHERE cmdRetVal = 0)
				GOTO CX_CONTINUE
		END
	/****************************************************************************************/
	/************** UPDATE MEDIA STATE  *****************************************************/
	/****************************************************************************************/
		-- Only remain media in transit state if it is still located at in transit location
IF		@state = 3
				AND @inTransitValue > 0
				AND @mediaLocation = 3
				AND @new_currentId = @inTransitId
		BEGIN
SET @new_state = 3
		END
		ELSE IF @new_currentId = @sourceId
		BEGIN
SET @new_state = 1
		END
ELSE IF @mediaLocation <> 3 OR @mediaLocation = 3 AND @exportLocationId = 0 AND @LibraryTypeId IN (4, 5, 8)
		BEGIN
SET @new_state = 6
		END
		ELSE
		BEGIN
SET @new_state = 7
		END
	/****************************************************************************************/
	/************** UPDATE MEDIA OPERATION STATUS *******************************************/
	/****************************************************************************************/
SET	@new_operation = 0
SET @new_operationState = 0
		-- Mark media to be relocated
		-- if media is in at shelf or stand along library or export location
		-- but destination is at shelf or stand along library or export location
IF		(@destLocationType = 2
OR @destLocationType = 1
AND  @destLibraryType IN (4, 5, 8))
			AND (@mediaLocation = 3
OR @ExportStandAloneTape = 0 AND @LibraryTypeId in (4, 5))
		BEGIN
SET @new_operation = 4
		END
		-- Mark media to be imported
		-- if it is exported or in stand along library or on shelf
		-- but destination is regular library
IF		@destLocationType = 1
AND	@destLibraryType NOT IN (4, 5, 8)
			AND (@mediaLocation = 3
OR   @LibraryTypeId in (4, 5))
		BEGIN
SET @new_operation = 1
			IF @new_operation <> @operation
			BEGIN
				INSERT  INTO @VTMediaToUpdateAlert (AlertAction, Initiator, ActionId, MediaId, SourceId, InTransitId, DestinationId)
values(2053, @initiator, @actionId, @mediaId, @sourceId, @inTransitId, @destinationId)
				IF @@ERROR > 0 GOTO CX_ERROR_EXIT
			END
		END
		-- Mark media to be exported
		-- if it is inside regular library or stand alone library
		-- but destination is export location or stand along library or shelf or a different library
		IF		@mediaLocation <> 3
AND ( @ExportStandAloneTape = 1 OR @ExportStandAloneTape = 0 AND @LibraryTypeId not in (4, 5) )
AND (	@destLocationType = 2
OR	@destLocationType = 1 AND @destValue <> 0 AND @libraryId <> @destValue )
		BEGIN
IF	@actionFlag & 4 = 0 AND @numMailSlot = 0 AND @libConnectionType <> 2
AND (@LibraryTypeId not in (4, 5))
			BEGIN
				-- Media is ready to be picked up directly from slot because there is no mail slot nor VMS defined
SET	@new_state = 8
				IF @new_state <> @state
				BEGIN
					INSERT  INTO @VTMediaToUpdateAlert (AlertAction, Initiator, ActionId, MediaId, SourceId, InTransitId, DestinationId)
values(41, @initiator, @actionId, @mediaId, @sourceId, @inTransitId, @destinationId)
					IF @@ERROR > 0 GOTO CX_ERROR_EXIT
				END
			END
			ELSE IF @mediaAtVMS > 0 AND @availableSlots = 0
			BEGIN
				-- Media is at VMS
SET	@new_state = 4
				IF @new_state <> @state
				BEGIN
SET	@new_currentId = (SELECT ISNULL(MAX(LocationId), 0) FROM VTLocation WHERE Type = 4 AND Value = @libraryId)
					INSERT  INTO @VTMediaToUpdateAlert (AlertAction, Initiator, ActionId, MediaId, SourceId, InTransitId, DestinationId)
values(2055, @initiator, @actionId, @mediaId, @sourceId, @inTransitId, @destinationId)
					IF @@ERROR > 0 GOTO CX_ERROR_EXIT
				END
			END
			ELSE IF @mediaLocation = 1 AND @SlotTypeId IN (2, 3)
			BEGIN
				-- Media is at Mail Slot
SET	@new_state = 5
				IF @new_state <> @state
				BEGIN
					INSERT  INTO @VTMediaToUpdateAlert (AlertAction, Initiator, ActionId, MediaId, SourceId, InTransitId, DestinationId)
values(41, @initiator, @actionId, @mediaId, @sourceId, @inTransitId, @destinationId)
					IF @@ERROR > 0 GOTO CX_ERROR_EXIT
				END
			END
ELSE IF @actionFlag & 4 > 0
			BEGIN
				-- Media is to be exported to virtual mail slot
SET @new_operation = 16
IF	@actionState = 1 AND @emptyslots > 0
SET @new_operationState = 1
				IF	@new_operationState <> @operationState AND @emptySlots = 0
					UPDATE	MMMediaExport SET ExportPhase = 0
					WHERE	MediaId = @mediaId AND ExportPhase <> 0
			END
			ELSE
			BEGIN
				-- Media is to be exported to regulare mail slot
SET @new_operation = 2
IF	@actionState = 1 AND (@emptyslots > 0 or @libConnectionType = 2 or @LibraryTypeId in (4, 5))
SET @new_operationState = 1
			END
		END
		UPDATE	VTActionMedia
		SET		State = @new_state,
				CurrentId = @new_currentId,
				Operation = @new_operation,
				OperationState = @new_operationState,
				ExportError = 0,
				TimeStamp = GETUTCDATE()
		WHERE	MediaId = @mediaId
		AND		ActionId = @actionId
		AND		(	State <> @new_state
					OR	CurrentId <> @new_currentId
					OR	Operation <> @new_operation
					OR	OperationState <> @new_operationState
				)
			/****************************************************************************/
			/****************************************************************************/
			/****************************************************************************/
CX_CONTINUE:
		FETCH	NEXT FROM VTMediaToUpdateCur
		INTO	@mediaId, @actionId, @policyId, @policyName, @jobId_h, @jobId_l, @jobType, @userId, @userName,
				@operationState, @operation, @sourceId, @currentId, @destinationId, @inTransitId,
				@libraryId, @LibConnectionType, @mediaLocation, @slotId, @vmsSlotId, @vmsDirection, @exportLocationId,
				@destLocationType, @destValue, @startdt, @barCode, @actionFlag,
				@sourceLocationType, @sourceValue, @bayId, @flag, @containerId, @exportError, @dueBackTime,
				@LibraryTypeId, @SlotTypeId, @actionType, @state, @actionState, @numMailSlot
		/****************************************************************************/
	END
	/* Honor the Retry interval */
	/* For those media that are still in the library at the regular mail slots and the retry interval is configured. */
	/* 1) Check if there was an export error */
	/* 2) Check if the retry inteaval has been passed. */
	/* 3) If so, then reset the export phase to INIT and reset the export error so that this media would get picked up in the next run */
	IF(@l_retryOnErrorInterval > 0)
	BEGIN
		UPDATE MMMediaExport
		SET ExportPhase = 0, ExportError = 0, LastUpdateTime = @l_currentTime
		FROM MMMediaExport AS MME, VTActionMedia as VTA, @VTMediaToUpdateList as tt
		WHERE MME.MediaId = tt.MediaId AND MME.VTActionId = tt.ActionId
		AND tt.MediaId = VTA.MediaId AND tt.ActionId = VTA.ActionId
		AND MME.ExportPhase IN(2, 3, 4, 5, 6, 7, 8, 12)
		AND (	(@l_currentTime - dbo.getUnixTime(VTA.TimeStamp)) >=  @l_retryOnErrorInterval
			 OR (@l_currentTime - MME.LastUpdateTime) >=  @l_retryOnErrorInterval
			)
	END
/****************************************************************************************/
/**************** Clean up the dangling action ******************************************/
/****************************************************************************************/
	-- Do not insert duplicate entries into this table for the media at mail slot alert
	DELETE	@VTMediaToUpdateAlert FROM @VTMediaToUpdateAlert a, VTAlerts b
WHERE	a.MediaId = b.MediaId AND b.AlertAction = 41
	INSERT  INTO @VTMediaToUpdateAlert
SELECT	2051, '', ActionId, 0, 0, 0, 0
	FROM	VTAction
	WHERE	ActionId NOT IN (SELECT ActionId FROM VTActionMedia)
	AND		ActionId NOT IN (SELECT ActionId FROM VTAlerts
WHERE ActionId > 0 AND AlertAction = 2052)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
--	INSERT  INTO @VTMediaToUpdateAlert
--	SELECT	AN_VTRK_PMM_FAILED_ACTION, '', ActionId, 0, 0, 0, 0
--	FROM	VTAction
--	WHERE	ActionId NOT IN (SELECT ActionId FROM VTActionMedia)
--	AND		ActionId IN (SELECT ActionId FROM VTAlerts
--				WHERE ActionId > 0 AND AlertAction = AN_VTRK_PMM_FAILED_ACTION)
--
--	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT  INTO VTAlerts
	SELECT	*
	FROM	@VTMediaToUpdateAlert
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
    DECLARE @tblVTAlerts table (Initiator NVARCHAR(255), ActionId int, SourceId int, InTransitId int, DestinationId int)
    insert into @tblVTAlerts
    select distinct Initiator, ActionId, SourceId, InTransitId, DestinationId
    from VTAlerts WITH (NOLOCK)
    where Initiator <> ''
    UPDATE VTAlerts
    set Initiator = B.Initiator, SourceId = B.SourceId, InTransitId = B.InTransitId, DestinationId = B.DestinationId
    from VTAlerts A, @tblVTAlerts B
    WHERE A.ActionId = B.ActionId
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	-- Delete containers created by system and with no media associated with
	DELETE	FROM MMContainer
WHERE	Flag & 1 = 1
	AND		ContainerId > 0 and isEmpty > 0
	IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
	DELETE	FROM VTAction
	WHERE	ActionId NOT IN (SELECT ActionId FROM VTActionMedia)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
/****************************************************************************************/
/****************************************************************************************/
--  +----------------------------+
--  |	NORMAL, "HAPPY" EXIT:    |
--  +----------------------------+
CX_NORMAL_EXIT:
	IF @curor_open = 1
	BEGIN
			CLOSE		VTMediaToUpdateCur
			DEALLOCATE	VTMediaToUpdateCur
	END
	COMMIT	TRANSACTION VTUpdateMediaTran
	SELECT	@retVal, 'Media movement updated successfully'
	RETURN
--  +----------------------------+
--  |   ABNORMAL, "ERROR" EXIT:  |
--  +----------------------------+
CX_ERROR_EXIT:
	IF @curor_open = 1
	BEGIN
			CLOSE		VTMediaToUpdateCur
			DEALLOCATE	VTMediaToUpdateCur
	END
	ROLLBACK	TRANSACTION VTUpdateMediaTran
	SELECT	@retVal, @errorString
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'VTUpdateMediaInAction')
	delete from GxQscripts where name = 'VTUpdateMediaInAction'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTUpdateMediaInAction')
	delete from GXDBVersions where aliasname = 'VTUpdateMediaInAction'
GO

insert into GXDBVersions values(2, 'VTUpdateMediaInAction',  '00010023017800050000', 'VTUpdateMediaInAction', '00010023017800050000')
GO

