

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VTRunActionCmd.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VTRunActionCmd.sp,v $ $Id: VTRunActionCmd.sp,v 1.32.178.5 2020/09/25 00:00:32 rsivadas Exp $";
--  +========================================================================+
--  | Stored Precedure: VTRunActionCmd
--  | Description:  Replace RunTmActionCommand.
--	|				Execute command from user through GUI or through system.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='VTRunActionCmd')
BEGIN
	print '>>> Drop Stored Procedure: VTRunActionCmd <<<'
	drop procedure VTRunActionCmd
END
IF EXISTS (select * from GxQscripts where name='VTRunActionCmd')
	delete from GxQscripts where name = 'VTRunActionCmd'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTRunActionCmd')
	delete from GXDBVersions where aliasname = 'VTRunActionCmd'
GO
print '... Creating Procedure: VTRunActionCmd'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure VTRunActionCmd
  @i_command INTEGER,
  @i_actionId INTEGER,
  @i_mediaId INTEGER,
  @i_containerId INTEGER
AS
  DECLARE @retVal INTEGER;
  DECLARE @mediaProcessed INTEGER;
  DECLARE @mediaSkipped INTEGER;
  DECLARE @errorString VARCHAR(1024);
-- This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRANSACTION VTCMDTRAN
/****************************************************************************************/
/************ Initialize and DECLARE temparary variables ********************************/
/****************************************************************************************/
	DECLARE @mediaId				INTEGER
	DECLARE	@LibraryId 				INTEGER
	DECLARE	@mediaLocation	 		INTEGER
	DECLARE	@exportLocationId		INTEGER
	DECLARE	@lastWriteLibraryId		INTEGER
	DECLARE	@mediaTypeId			INTEGER
	DECLARE	@SpareGroupId			INTEGER
	DECLARE	@SpareGroupType			INTEGER
	DECLARE	@libraryType			INTEGER
	DECLARE @actionId				INTEGER
	DECLARE @actionType				INTEGER
	DECLARE @actionState			INTEGER
	DECLARE	@actionCurrentId		INTEGER
	DECLARE	@actionMediaState		INTEGER
	DECLARE @actionSourceId			INTEGER
	DECLARE	@actionDestId			INTEGER
	DECLARE	@inTransitId			INTEGER
	DECLARE	@policyId				INTEGER
DECLARE	@policyName				NVARCHAR(128)
DECLARE	@userName				VARCHAR(255)
DECLARE	@barCode				VARCHAR(256)
	DECLARE	@jobId_h				INTEGER
	DECLARE	@jobId_l				INTEGER
	DECLARE	@jobType				INTEGER
	DECLARE	@actionSpareGroupId		INTEGER
	DECLARE	@userId					INTEGER
	DECLARE @actionStartTime		datetime
	DECLARE @currentDate			datetime
	DECLARE @exportError			INTEGER
	DECLARE	@dueBackTime			BIGINT
	DECLARE @numMediaInContainer	INTEGER
	DECLARE	@containerCapacity		INTEGER
	DECLARE	@numMediaToGo			INTEGER
	DECLARE @parentContainerId		INTEGER
	DECLARE @ContainerCounter		INTEGER
	DECLARE @containerIndex			INTEGER
	DECLARE @newContainerName		NVARCHAR(256)
	DECLARE	@initiator				NVARCHAR(255)
	DECLARE @policyQuitTime			INTEGER
	DECLARE @vtHistoryState			INTEGER
	DECLARE @newSpareGroupId		INTEGER
	DECLARE @mediaLibraryId			INTEGER
	DECLARE	@sourceLibraryType		INTEGER
	DECLARE	@sourceLocationType		INTEGER
	DECLARE	@sourceLocationValue	INTEGER
DECLARE	@sourceLocationName		NVARCHAR(128)
	DECLARE	@destLibraryType		INTEGER
	DECLARE	@destLocationType		INTEGER
	DECLARE	@destLocationValue		INTEGER
DECLARE	@destLocationName		NVARCHAR(128)
DECLARE	@inTransitLocation		NVARCHAR(128)
	SET @retVal = 0
	SET @mediaProcessed = 0
	SET	@mediaSkipped = 0
	SET @errorString = ''
	SET	@initiator = ''
	SET @newContainerName = ''
	SET @parentContainerId = 0
	SET @ContainerCounter = 0
	SET @containerIndex = 2
	DECLARE @curor_open INTEGER
	set @curor_open = 0
/****************************************************************************************/
/********************** Create temparary tables *****************************************/
/****************************************************************************************/
	IF	object_id('tempdb.dbo.#VTMediaForCmdList') is not null DROP TABLE #VTMediaForCmdList
	CREATE TABLE #VTMediaForCmdList (
			MediaId INT,
			LibraryId INT,
			MediaLocation INT,
			ExportLocationId INT,
BarCode	VARCHAR(256),
			LastWriteLibraryId INT,
			MediaTypeId INT,
			SpareGroupId INT,
			CurrentId INT,
			ActionId INT,
			ActionMediaState INT,
			ExportError	INT,
			DueBackTime	BIGINT
	)
/****************************************************************************************/
/****************************************************************************************/
/****************************************************************************************/
	IF	@i_command NOT IN (
2,
4,
8,
16,
256,
1024,
2048,
4096,
8192,
16384 )
	BEGIN
			SET @errorString = 'Invalid vault tracker command for action.'
SET @retVal = 1121
			GOTO CX_ERROR_EXIT
	END
	IF		@i_actionId = 0 AND @i_mediaId > 0
	BEGIN
			SET @i_actionId = ISNULL((
				SELECT top 1 b.ActionId
				FROM VTActionMedia a WITH (NOLOCK), VTAction b WITH (NOLOCK)
				WHERE a.ActionId = b.ActionId and a.mediaId = @i_mediaId
AND b.ActionType <> 2 ), 0)
	END
	IF		NOT EXISTS (SELECT ACTIONID FROM VTACTION WHERE ACTIONID = @i_actionId)
	BEGIN
			--If it is the abort command and the actionId is invalid which is the case for manual exports
			--Then, do not set the error code here so that the calling code can assume that we succeded here.
IF (@i_command != 2)
			BEGIN
				SET @errorString = 'Invalid action ID inputted.'
SET @retVal = 1120
			END
			GOTO CX_ERROR_EXIT
	END
	IF		@i_mediaId > 0 AND NOT EXISTS (SELECT MEDIAID FROM MMMEDIA WITH (NOLOCK) WHERE MEDIAID = @i_mediaId)
	BEGIN
			SET @errorString = 'Invalid media ID inputted.'
SET @retVal = 1120
			GOTO CX_ERROR_EXIT
	END
	SELECT	@actionType = ActionType,
			@actionState = ActionState,
			@actionSourceId = SourceId,
			@actionDestId = DestinationId,
			@policyId = PolicyId,
			@jobId_h = JobId_h,
			@jobId_l = JobId_l,
			@jobType = JobType,
			@userId = UserId,
			@actionStartTime = StartTime,
			@inTransitId = InTransitId,
			@actionSpareGroupId = SpareGroupId
	FROM	VTAction
	WHERE	ActionId = @i_actionId
	SET	@userName = ISNULL((SELECT login FROM UMUsers WHERE id = @userId), '')
	SET	@policyName = ISNULL((SELECT PolicyName FROM VTPolicy WHERE PolicyId = @policyId), '')
	SET @currentDate = GETUTCDATE()
/****************************************************************************************/
/****************************************************************************************/
/****************************************************************************************/
IF	@i_command in (1024, 16384)
	BEGIN
IF	@ActionState IN (2, 4)
			GOTO CX_EXIT
IF	@ActionState NOT IN (1, 16)
			GOTO CX_EXIT
		SET @numMediaToGo =	(SELECT Count(*) FROM MMMediaExport WITH (NOLOCK)
							WHERE VTActionId = @i_actionId
							AND ExportPhase NOT IN(9, 10, 11, 13, 14, 15, 16))
		-- Export started and no media export can be suspended. Action remain as is.
		IF	@numMediaToGo = 0
			AND EXISTS (SELECT * FROM MMMediaExport WITH (NOLOCK) WHERE VTActionId = @i_actionId)
		BEGIN
IF	@i_command = 16384
				GOTO CX_EXIT
			SET @errorString = 'Media export cannot be suspended at this point.'
SET @retVal = 1133
			GOTO CX_ERROR_EXIT
		END
		UPDATE	MMMediaExport
SET		Flags = (Flags &~ 2) | 1
		WHERE	VTActionId = @i_actionId
		AND		ExportPhase NOT IN(9, 10, 11, 13, 14, 15, 16)
		IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
		UPDATE	VTAction
		SET		ActionQuitTime = 0,
				ActionState =	CASE @i_command
WHEN 1024
THEN 2
ELSE 4 END
		WHERE	ActionId = @i_actionId
		IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
		SET @mediaProcessed = @numMediaToGo
		GOTO CX_EXIT
	END
/****************************************************************************************/
IF	@i_command = 2048
	BEGIN
IF	@ActionState NOT IN (2, 4)
			GOTO CX_EXIT
		-- Unset the suspended flag and SET the resumed flag
		UPDATE	MMMediaExport
SET		Flags = (Flags &~ 1) | 2
		WHERE	VTActionId = @i_actionId
AND		(Flags & 1) > 0
		IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
		UPDATE	VTAction
		SET		ActionQuitTime = 0,
ActionState = 1
		WHERE	ActionId = @i_actionId
AND		ActionState in (2, 4)
		IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
		SET @mediaProcessed = (SELECT COUNT(*) FROM MMMediaExport where VTActionId = @i_actionId
AND (Flags & 2) > 0)
		GOTO CX_EXIT
	END
/****************************************************************************************/
IF	@i_command = 4096
	BEGIN
		IF	@policyId = 0
			GOTO CX_EXIT
		SET @policyQuitTime = (	SELECT	QuitTimeInMinutes
								FROM	VTPolicy
								WHERE	PolicyId = @policyId )
		IF	@policyQuitTime = 0
			GOTO CX_EXIT
		UPDATE	VTAction
		SET		ActionQuitTime = (DBO.GetUnixTime(GETUTCDATE()) + @policyQuitTime * 60)
		WHERE	ActionId = @i_actionId
		IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
		SET @mediaProcessed = (SELECT COUNT(*) FROM VTActionMedia where ActionId = @i_actionId)
		GOTO CX_EXIT
	END
/****************************************************************************************/
/******************** Get list of media to process **************************************/
/****************************************************************************************/
	-- Get list of media
	INSERT	INTO #VTMediaForCmdList
	SELECT	b.MediaId, b.LibraryId,
			b.MediaLocation, b.ExportLocationId,
			b.BarCode, b.LastWriteLibraryId, b.MediaTypeId, b.SpareGroupId,
			a.CurrentId, a.ActionId, a.State,
			a.ExportError, b.retentionExpireTime
	FROM	VTActionMedia a	WITH (NOLOCK), MMMedia b WITH (NOLOCK)
	WHERE	a.MediaId = b.MediaId
	AND		a.ActionId = @i_actionId
	AND		(@i_mediaId = 0 OR a.MediaId = @i_mediaId)
	IF		@@ROWCOUNT = 0
			GOTO CX_NORMAL_EXIT
/****************************************************************************************/
/* Keep containerId if media can be marked reached destination
IF	@i_command = 2
	BEGIN
		-- Clear the containerId for media to be aborted
		UPDATE	MMMedia
		SET		ContainerId = 0
		WHERE	MediaId IN (SELECT MediaId FROM #VTMediaForCmdList)
		IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
		-- Do not exit the abort command. Media will be checked again in a cursor.
	END
*/
/****************************************************************************************/
	-- SET container needs only the media list
IF	@i_command = 256
	BEGIN
		IF	NOT EXISTS (SELECT * FROM MMContainer WHERE ContainerId = @i_containerId)
		BEGIN
			SET @errorString = 'Invalid container inputted for action.'
SET @retVal = 1122
			GOTO CX_ERROR_EXIT
		END
		-- Check if	the container capacity exceeds before setting it
		SET @numMediaInContainer	= (select count(*) from MMMedia where ContainerId = @i_containerId)
		SET @containerCapacity		= (select Capacity from MMContainer where ContainerId = @i_containerId)
		SET @numMediaToGo			= (select count(*) from #VTMediaForCmdList)
		IF	@numMediaToGo > (@containerCapacity - @numMediaInContainer)
		BEGIN
			SET @errorString = 'Failed to set container for media in action due to limited capacity.'
SET @retVal = 1123
			GOTO CX_ERROR_EXIT
		END
		UPDATE	MMMedia
		SET		ContainerId = @i_containerId
		WHERE	MediaId IN (SELECT MediaId FROM #VTMediaForCmdList)
		IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
		SET @mediaProcessed = @numMediaToGo
		GOTO CX_EXIT
	END
	/****************************************************************************************/
	/****************** For every MediaId, run command **************************************/
	/****************************************************************************************/
	DECLARE VTMediaForCmdCur CURSOR FOR
			SELECT	DISTINCT MediaId, LibraryId, MediaLocation, ExportLocationId,
					BarCode, LastWriteLibraryId, MediaTypeId, SpareGroupId,
					CurrentId, ActionId, ActionMediaState,
					ExportError, DueBackTime
			FROM	#VTMediaForCmdList
	/****************************************************************************************/
	/****************************************************************************************/
	OPEN	VTMediaForCmdCur
	set	@curor_open = 1
	/****************************************************************************************/
	FETCH	NEXT FROM VTMediaForCmdCur
	INTO	@mediaId, @LibraryId, @mediaLocation, @exportLocationId,
			@barCode, @lastWriteLibraryId, @mediaTypeId, @SpareGroupId,
			@actionCurrentId, @actionId, @actionMediaState,
			@exportError, @dueBackTime
	/****************************************************************************************/
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		SET	@sourceLocationType = 0
		SET	@sourceLocationValue = 0
		SET	@sourceLibraryType = 0
		SET	@sourceLocationName = ''
		SET	@destLocationType = 0
		SET	@destLocationValue = 0
		SET	@destLibraryType = 0
		SET	@destLocationName = ''
		SET	@inTransitLocation = ''
		SET	@libraryType = ISNULL((SELECT libraryTypeId FROM MMLibrary WHERE LibraryId = @LibraryId), 0)
		SELECT	@sourceLocationType = Type, @sourceLocationValue = Value
		FROM	VTLocation
		WHERE	LocationId = @actionSourceId
IF	@sourceLocationType = 1
		BEGIN
			SELECT @sourceLocationName = AliasName, @sourceLibraryType = LibraryTypeId
			FROM	MMLibrary
			WHERE	LibraryId = @sourceLocationValue
		END
IF	@sourceLocationType = 2
		BEGIN
			SELECT @sourceLocationName = ExportLocation
			FROM	MMExportLocation
			WHERE	ExportLocationId = @sourceLocationValue
		END
		SELECT	@destLocationType = Type, @destLocationValue = Value
		FROM	VTLocation
		WHERE	LocationId = @actionDestId
IF	@destLocationType = 1
		BEGIN
			SELECT @destLocationName = AliasName, @destLibraryType = LibraryTypeId
			FROM	MMLibrary
			WHERE	LibraryId = @destLocationValue
			IF @destLocationValue = 0
				SET @destLocationName = 'Any Library'
		END
IF	@destLocationType = 2
		BEGIN
			SELECT @destLocationName = ExportLocation
			FROM	MMExportLocation
			WHERE	ExportLocationId = @destLocationValue
		END
		IF	@inTransitId = 0
		BEGIN
			SELECT	@inTransitId = LocationId
			FROM	VTLocation
WHERE	Type = 2
AND		Value = 0
		END
		SELECT @inTransitLocation = ExportLocation
		FROM	MMExportLocation
		WHERE	ExportLocationId = (SELECT Value FROM VTLocation WHERE LocationId = @inTransitId)
		IF @policyId > 0
			SET @initiator = 'Policy: ' + @policyName
		ELSE if @jobId_l > 0
			SET @initiator = 'Job: ' + CONVERT(varchar(10), @jobId_l)
		ELSE
			SET @initiator = 'User: ' + @userName
	/****************************************************************************************/
	/***********************    Abort Action Command    *************************************/
	/****************************************************************************************/
IF	@i_command = 2
		BEGIN
SET @vtHistoryState = 1 | 8
			-- Assume destination reached once media is exported from source library
IF	@actionType <> 2
AND	@destLocationType = 2
AND	@sourceLocationType = 1
AND	@sourceLibraryType NOT IN (4, 5, 8)
AND	(@mediaLocation = 3 OR @actionMediaState = 5
					and @mediaLocation = 1 and exists (select * from mmslot where mediaId = @mediaId and slotType in (2, 3)))
			BEGIN
				--IF @mediaLocation = 3 OR @actionMediaState = TM_ACTION_MEDIA_STATE_AT_MAILSLOT
SET @vtHistoryState = 2
				-- Media might be relocated already if action remain active for a long time.
				-- We don't want to overwrite existing media export location in this case.
				-- So only update the media if it is in the inTransitLocation.
IF	@actionMediaState = 3
OR @actionMediaState = 5
OR (@actionMediaState = 7 AND @exportLocationId = 0)
				BEGIN
					-- Reach destination automatically for media exported
					UPDATE	MMMedia
					SET		exportLocationId = @destLocationValue
					WHERE	MediaId = @mediaId AND exportLocationId <> @destLocationValue
					IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
				END
			END
			DELETE	FROM VTActionMedia
			WHERE	MediaId = @mediaId AND ActionId = @actionId
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			-- Recall media may exists in multiple actions. Unset flag for the last action.
			IF	NOT EXISTS (SELECT * FROM VTActionMedia WHERE MediaId = @mediaId)
			BEGIN
				UPDATE	MMMedia
SET		Attributes = Attributes &~ (1 | 536870912)
				WHERE	MediaId = @mediaId
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			END
IF @vtHistoryState <> 2
			BEGIN
				UPDATE	MMMedia
				SET		ContainerId = 0
				WHERE	MediaId = @mediaId
			END
			INSERT INTO VTHistory(ActionId, PolicyId, PolicyName, JobId_h, JobId_l, JobType, UserId, UserName, MediaId, BarCode, SourceId, DestinationId, State, StartTime, EndTime, SourceLocation, DestinationLocation, InTransitId, InTransitLocation, ExportError, DueBackTime, ActionType)
			values(@actionId, @policyId, @policyName, @jobId_h, @jobId_l, @jobType, @userId, @userName, @mediaId, @barCode, @actionSourceId, @actionDestId, @vtHistoryState, @actionStartTime, @currentDate, @sourceLocationName, @destLocationName, @inTransitId, @inTransitLocation, @exportError, @dueBackTime, @actionType)
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
IF @vtHistoryState <> 2
			BEGIN
				INSERT  INTO VTAlerts (AlertAction, Initiator, ActionId, MediaId, SourceId, InTransitId, DestinationId)
values(2052, @initiator, @actionId, @mediaId, @actionSourceId, @inTransitId, @actionDestId)
			END
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			SET @mediaProcessed = @mediaProcessed + 1
		END
	/****************************************************************************************/
	/***********************  Return to Source Command    ***********************************/
	/****************************************************************************************/
IF	@i_command = 4
		BEGIN
			-- Command to return media in transit location to source export location
			-- Media is at source already
			IF	@actionCurrentId = @actionSourceId
AND @actionMediaState <> 5
				GOTO CX_CONTINUE
			-- Source is a regular library
			-- Do not need to continue with other media because all media in action belong to the same source
IF	@sourceLocationType = 1
AND	@sourceLibraryType NOT IN (4, 5, 8)
			BEGIN
				SET @errorString = 'Failed to return media to source library. Operation requires media import.'
SET @retVal = 1124
				GOTO CX_ERROR_EXIT
			END
			-- Media is in regular library.
			IF	@mediaLocation in (1, 2)
AND @libraryType NOT IN (4, 5)
			BEGIN
				SET @errorString = 'Failed to return one or more media to source location. Operation requires media export.'
SET @retVal = 1125
				SET	@mediaSkipped = @mediaSkipped + 1
				GOTO CX_CONTINUE
			END
			UPDATE	MMMedia
			SET		ExportLocationId =	CASE @sourceLocationType
WHEN 2
										THEN @sourceLocationValue ELSE 0 END
			WHERE	MediaId = @mediaId
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			-- Reset media to original state
			UPDATE	VTActionMedia
SET		State = 1,
Operation = 4,
OperationState = 0,
					CurrentId = @actionSourceId,
					TimeStamp = GETUTCDATE()
			WHERE	MediaId = @mediaId AND ActionId = @actionId
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			INSERT  INTO VTAlerts (AlertAction, Initiator, ActionId, MediaId, SourceId, InTransitId, DestinationId)
values(2058, @initiator, @actionId, @mediaId, @actionSourceId, @inTransitId, @actionDestId)
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			SET @mediaProcessed = @mediaProcessed + 1
		END
	/****************************************************************************************/
	/***********************     Pick Up Media Command    ***********************************/
	/****************************************************************************************/
IF	@i_command = 8
		BEGIN
			-- Command to move media from source export location to in transit location
			-- Media is in transit or destination already
IF	@actionMediaState IN (3, 2)
				GOTO CX_CONTINUE
			-- Media is in a regular library.
			IF	@mediaLocation in (1, 2)
AND @libraryType NOT IN (4, 5)
			BEGIN
				SET @errorString = 'Failed to pick up one or more media from media location. Operation requires media export.'
SET @retVal = 1126
				SET	@mediaSkipped = @mediaSkipped + 1
				GOTO CX_CONTINUE
			END
			IF EXISTS (SELECT * FROM VTLocation WHERE LocationId = @inTransitId AND Value = 0)
			BEGIN
				SET @errorString = 'Failed to pick up one or more media from media location. Transit location is not selected for action.'
SET @retVal = 1134
				SET	@mediaSkipped = @mediaSkipped + 1
				GOTO CX_CONTINUE
			END
IF	@libraryType IN (4, 5)
			BEGIN
				IF EXISTS (SELECT * FROM MMResource WHERE MediaId = @mediaId)
				BEGIN
					SET @errorString = 'Failed to pick up one media in stand along library which is cache mounted.'
SET @retVal = 1127
					SET	@mediaSkipped = @mediaSkipped + 1
					GOTO CX_CONTINUE
				END
				UPDATE	MMDrive
				SET		MediaId = 0
				WHERE	MediaId = @mediaId
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
				UPDATE	MMMedia
				SET		MediaLocation = 3
				WHERE	MediaId = @mediaId and MediaLocation = 2
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			END
			IF	@i_containerId > 0 AND NOT EXISTS (SELECT * FROM MMMedia WHERE MediaId = @MediaId and ContainerId = @i_containerId)
			BEGIN
				-- Check if the container capacity exceeds before setting it
				set @numMediaInContainer	= (select count(*) from MMMedia where ContainerId = @i_containerId)
				set @containerCapacity		= (select Capacity from MMContainer where ContainerId = @i_containerId)
				IF(@numMediaInContainer >= @containerCapacity)
				BEGIN
					SET @errorString = 'Failed to set container for media in action due to limited capacity.'
SET @retVal = 1123
					GOTO CX_ERROR_EXIT
				END
			END
			UPDATE	MMMedia
			SET		ExportLocationId = (SELECT Value FROM VTLocation WHERE LocationId = @inTransitId),
					ContainerId = CASE WHEN @i_containerId > 0 THEN @i_containerId ELSE ContainerId END
			WHERE	MediaId = @mediaId
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			UPDATE	VTActionMedia
SET		State = 3,
Operation = 4,
OperationState = 0,
					CurrentId = @InTransitId,
					TimeStamp = GETUTCDATE()
			WHERE	MediaId = @mediaId AND ActionId = @actionId
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			INSERT  INTO VTAlerts (AlertAction, Initiator, ActionId, MediaId, SourceId, InTransitId, DestinationId)
values(2056, @initiator, @actionId, @mediaId, @actionSourceId, @inTransitId, @actionDestId)
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			SET @mediaProcessed = @mediaProcessed + 1
		END
	/****************************************************************************************/
	/***********************   Reach Destination Command  ***********************************/
	/****************************************************************************************/
IF		@i_command = 16
		BEGIN
			-- Media is at destination already
IF	@actionMediaState = 2
				GOTO CX_CONTINUE
			-- Destination is a regular library and media is not in library
IF		@destLocationType = 1
AND	@destLibraryType NOT IN (4, 5, 8)
				AND @mediaLocation = 3
			BEGIN
				SET @errorString = 'Failed to reach destination for one or more media. Operation requires media import.'
SET @retVal = 1128
				SET	@mediaSkipped = @mediaSkipped + 1
				GOTO CX_CONTINUE
			END
			-- Destination is a regular library and media is in differentlibrary
IF		@destLocationType = 1
AND	@destLibraryType NOT IN (4, 5, 8)
				AND @destLocationValue > 0 AND @LibraryId <> @destLocationValue
			BEGIN
				SET @errorString = 'Failed to reach destination for one or more media. Media is not in destination library yet.'
SET @retVal = 1135
				SET	@mediaSkipped = @mediaSkipped + 1
				GOTO CX_CONTINUE
			END
			-- Destination is not a regular library but media is in regular library
			IF		@mediaLocation in (1, 2)
AND @libraryType NOT IN (4, 5)
AND	(@destLocationType = 2
					AND NOT EXISTS (SELECT value FROM MMConfigs WHERE name = 'MMS2_CONFIG_VT_REACH_DEST_MEDIA_IN_LIB' AND Value <> 0)
OR	(@destLocationType = 1
AND	@destLibraryType IN (4, 5, 8)) )
			BEGIN
				SET @errorString = 'Failed to reach destination for one or more media. Operation requires media export.'
SET @retVal = 1129
				SET	@mediaSkipped = @mediaSkipped + 1
				GOTO CX_CONTINUE
			END
IF	@libraryType IN (4, 5)
			BEGIN
				IF EXISTS (SELECT * FROM MMResource WHERE MediaId = @mediaId)
				BEGIN
					SET @errorString = 'Failed to reach destination for one media in stand along library which is cache mounted.'
SET @retVal = 1130
					SET	@mediaSkipped = @mediaSkipped + 1
					GOTO CX_CONTINUE
				END
				UPDATE	MMDrive
				SET		MediaId = 0
				WHERE	MediaId = @mediaId
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
				UPDATE	MMMedia
				SET		MediaLocation = 3
				WHERE	MediaId = @mediaId and MediaLocation = 2
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			END
			IF	@i_containerId > 0 AND NOT EXISTS (SELECT * FROM MMMedia WHERE MediaId = @MediaId and ContainerId = @i_containerId)
			BEGIN
				-- Check if the container capacity exceeds before setting it
				set @numMediaInContainer	= (select count(*) from MMMedia where ContainerId = @i_containerId)
				set @containerCapacity		= (select Capacity from MMContainer where ContainerId = @i_containerId)
				IF(@numMediaInContainer >= @containerCapacity)
				BEGIN
					SET @errorString = 'Failed to set container for media in action due to limited capacity.'
SET @retVal = 1123
					GOTO CX_ERROR_EXIT
				END
			END
			-- Get the default overwrite protected group id for recalled media
IF	@actionType = 2 AND @actionSpareGroupId = 0
			BEGIN
IF	@destLibraryType IN (8, 4, 5)
					SET @mediaLibraryId = @destLocationValue
				ELSE IF @libraryId > 0
					SET @mediaLibraryId = @libraryId
				ELSE
					SET @mediaLibraryId = @lastWriteLibraryId
				SET	@actionSpareGroupId = ISNULL((
						SELECT	TOP 1 SpareGroupId
						FROM	MMSpareGroup
WHERE	SpareGroupType = 64
						AND		MediaTypeId = @mediaTypeId
						AND		LibraryId = @mediaLibraryId
						), 0)
				IF	@actionSpareGroupId = 0
					SET	@actionSpareGroupId = ISNULL((
						SELECT	TOP 1 SpareGroupId
						FROM	MMSpareGroup
WHERE	SpareGroupType = 64
						AND		LibraryId = @mediaLibraryId
						), 0)
			END
IF	@destLibraryType = 8
				AND EXISTS (SELECT MediaId FROM MMMedia WHERE MediaId = @mediaid)
			BEGIN
				SET	@SpareGroupType = ISNULL((SELECT SpareGroupType FROM MMSpareGroup WHERE SpareGroupId = @SpareGroupId), 0)
				-- Try to put media in the same kind of spare group as before
				SET @newSpareGroupId = ISNULL((select top 1 SpareGroupId from MMSpareGroup
							where LibraryId = @destLocationValue
							and ((highwatermark = 0) or ((select count(*) from MMMedia where SpareGroupId = MMSpareGroup.SpareGroupId) - HighWaterMark < 0))
							and ((@SpareGroupType = 0) or (SpareGroupType = @SpareGroupType) or (SpareGroupType in (1,2) and @SpareGroupType in (1,2)))
							and (@SpareGroupType in (8) or (@SpareGroupType not in (8) and mediatypeid in (select mediatypeid from MMMedia
							where mediaid = @mediaid)))
order by (attributes & (7)) desc, SpareGroupType desc), 0)
				IF	@newSpareGroupId = 0
					SET @newSpareGroupId = ISNULL((select top 1 SpareGroupId from MMSpareGroup
							where LibraryId = @destLocationValue
							and ((@SpareGroupType = 0) or (SpareGroupType = @SpareGroupType) or (SpareGroupType in (1,2) and @SpareGroupType in (1,2)))
							and (@SpareGroupType in (8) or (@SpareGroupType not in (8) and mediatypeid in (select mediatypeid from MMMedia
							where mediaid = @mediaid)))
order by (attributes & (7)) desc, SpareGroupType desc), 0)
				IF	@newSpareGroupId = 0
				BEGIN
					SET @errorString = 'Failed to reach destination for one or more media. Media type has no matching scratch pool.'
SET	@retVal = 1131
					SET	@mediaSkipped = @mediaSkipped + 1
					GOTO CX_CONTINUE
				END
				UPDATE	MMMedia
				SET		SpareGroupId = @newSpareGroupId
				WHERE	MediaId = @mediaid
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			END
IF	@destLibraryType IN (8, 4, 5)
			BEGIN
				UPDATE	MMMedia
				SET		ExportLocationId = 0,
						LibraryId = @destLocationValue,
						ContainerId = CASE WHEN @i_containerId > 0 THEN @i_containerId ELSE ContainerId END
				WHERE	MediaId = @mediaid
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			END
ELSE IF @destLocationType = 2
			BEGIN
				UPDATE	MMMedia
				SET		ExportLocationId = @destLocationValue,
						ContainerId = CASE WHEN @i_containerId > 0 THEN @i_containerId ELSE ContainerId END
				WHERE	MediaId = @mediaId
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
				UPDATE	MMTapeStateHistory
				SET		ExportLocationId = @destLocationValue,
						ExportLocation = (SELECT ExportLocation FROM MMExportLocation WITH(READUNCOMMITTED) WHERE ExportLocationId = @destLocationValue),
						ContainerId = CASE WHEN @i_containerId > 0 THEN @i_containerId ELSE ContainerId END,
						ContainerName = CASE WHEN @i_containerId > 0 THEN (SELECT ContainerName FROM MMContainer WITH(READUNCOMMITTED)  WHERE ContainerId = @i_containerId) ELSE ContainerName END
				WHERE	HistoryId = (SELECT MAX(T.HistoryId) FROM MMMedia M WITH(READUNCOMMITTED)
															JOIN MMTapeStateHistory T WITH(READUNCOMMITTED)
															ON M.MediaId = @mediaId AND M.MediaId = T.MediaId AND M.LastExportTime = T.ExportTime)
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			END
			ELSE
			BEGIN
				UPDATE	MMMedia
				SET		ContainerId = CASE WHEN @i_containerId > 0 THEN @i_containerId ELSE ContainerId END
				WHERE	MediaId = @mediaId
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			END
			INSERT  INTO VTAlerts (AlertAction, Initiator, ActionId, MediaId, SourceId, InTransitId, DestinationId)
values(2057, @initiator, @actionId, @mediaId, @actionSourceId, @inTransitId, @actionDestId)
IF	@actionType = 2
			BEGIN
				-- Keep the current location if destination is any library
				-- So that action details will display the right location information
IF		@destLocationType = 1 AND @destLocationValue = 0
SET	@actionDestId = (SELECT ISNULL(MAX(LocationId), 0) FROM VTLocation WHERE Type = 1 AND Value = @libraryId)
				UPDATE	MMMedia
				SET		SpareGroupId = @actionSpareGroupId,
Attributes = Attributes | 536870912
				WHERE	MediaId = @mediaId
				AND		@actionSpareGroupId > 0
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
				UPDATE	VTActionMedia
SET		State = 2,
Flag = 4,
Operation = 0,
OperationState = 0,
						CurrentId = @actionDestId,
						TimeStamp = GETUTCDATE()
				WHERE	MediaId = @mediaId AND ActionId = @actionId
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
				SET @mediaProcessed = @mediaProcessed + 1
				GOTO CX_CONTINUE
			END
			UPDATE	MMMedia
SET		Attributes = Attributes &~ 1
			WHERE	MediaId = @mediaId
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			DELETE	FROM VTActionMedia
			WHERE	MediaId = @mediaId AND ActionId = @actionId
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			INSERT INTO VTHistory(ActionId, PolicyId, PolicyName, JobId_h, JobId_l, JobType, UserId, UserName, MediaId, BarCode, SourceId, DestinationId, State, StartTime, EndTime, SourceLocation, DestinationLocation, InTransitId, InTransitLocation, ExportError, DueBackTime, ActionType)
values(@actionId, @policyId, @policyName, @jobId_h, @jobId_l, @jobType, @userId, @userName, @mediaId, @barCode, @actionSourceId, @actionDestId, 2, @actionStartTime, @currentDate, @sourceLocationName, @destLocationName, @inTransitId, @inTransitLocation, @exportError, @dueBackTime, @actionType)
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			SET @mediaProcessed = @mediaProcessed + 1
		END
	/****************************************************************************************/
	/***********************      Recall Done Command     ***********************************/
	/****************************************************************************************/
IF		@i_command = 8192
		BEGIN
IF	@actionType <> 2
			BEGIN
				SET @errorString = 'Invalid vault tracker command for action.'
SET @retVal = 1121
				GOTO CX_ERROR_EXIT
			END
IF	@actionMediaState <> 2
			BEGIN
				SET @errorString = 'Failed to complete recall action for one or more media which are not yet at destination.'
SET @retVal = 1132
				SET	@mediaSkipped = @mediaSkipped + 1
				GOTO CX_CONTINUE
			END
			DELETE	FROM VTActionMedia
			WHERE	MediaId = @mediaId AND ActionId = @actionId
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			-- Recall media may exists in multiple actions. Unset flag for the last action.
			IF	NOT EXISTS (SELECT * FROM VTActionMedia WHERE MediaId = @mediaId)
			BEGIN
				UPDATE	MMMedia
SET		Attributes = Attributes &~ (1 | 536870912)
				WHERE	MediaId = @mediaId
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			END
			INSERT INTO VTHistory(ActionId, PolicyId, PolicyName, JobId_h, JobId_l, JobType, UserId, UserName, MediaId, BarCode, SourceId, DestinationId, State, StartTime, EndTime, SourceLocation, DestinationLocation, InTransitId, InTransitLocation, ExportError, DueBackTime, ActionType)
values(@actionId, @policyId, @policyName, @jobId_h, @jobId_l, @jobType, @userId, @userName, @mediaId, @barCode, @actionSourceId, @actionDestId, 2, @actionStartTime, @currentDate, @sourceLocationName, @destLocationName, @inTransitId, @inTransitLocation, @exportError, @dueBackTime, @actionType)
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			INSERT  INTO VTAlerts (AlertAction, Initiator, ActionId, MediaId, SourceId, InTransitId, DestinationId)
values(2051, @initiator, @actionId, @mediaId, @actionSourceId, @inTransitId, @actionDestId)
			IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
			SET @mediaProcessed = @mediaProcessed + 1
		END
	/****************************************************************************************/
	/****************************     GO TO NEXT MEDIA    ***********************************/
	/****************************************************************************************/
CX_CONTINUE:
			FETCH	NEXT FROM VTMediaForCmdCur
			INTO	@mediaId, @LibraryId, @mediaLocation, @exportLocationId,
					@barCode, @lastWriteLibraryId, @mediaTypeId, @SpareGroupId,
					@actionCurrentId, @actionId, @actionMediaState,
					@exportError, @dueBackTime
	END	-- END OF WHILE	@@FETCH_STATUS = 0
	/****************************************************************************************/
	/************************ Clean Up After Command ****************************************/
	/****************************************************************************************/
CX_NORMAL_EXIT:
IF		@actionType = 2
AND	@i_command = 16
AND	@actionState <> 8
		AND EXISTS     (SELECT * FROM VTActionMedia WHERE ActionId = @actionId
AND State = 2)
		AND NOT EXISTS (SELECT * FROM VTActionMedia WHERE ActionId = @actionId
AND State <> 2)
	BEGIN
		UPDATE	VTAction
SET		ActionState = 8
		WHERE	ActionId = @actionId
	END
	INSERT  INTO VTAlerts
SELECT	2051, '', ActionId, 0, 0, 0, 0
	FROM	VTAction
	WHERE	ActionId NOT IN (SELECT ActionId FROM VTActionMedia)
AND		ActionId NOT IN (SELECT ActionId FROM VTAlerts WHERE ActionId > 0 AND AlertAction = 2052)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
--	INSERT  INTO VTAlerts
--	SELECT	AN_VTRK_PMM_FAILED_ACTION, '', ActionId, 0, 0, 0, 0
--	FROM	VTAction
--	WHERE	ActionId NOT IN (SELECT ActionId FROM VTActionMedia)
--	AND		ActionId IN (SELECT ActionId FROM VTAlerts WHERE ActionId > 0 AND AlertAction = AN_VTRK_PMM_FAILED_ACTION)
--
--	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
    DECLARE @tblVTAlerts table (Initiator NVARCHAR(255), ActionId int, SourceId int, InTransitId int, DestinationId int)
    insert into @tblVTAlerts
    select distinct Initiator, ActionId, SourceId, InTransitId, DestinationId
    from VTAlerts WITH (NOLOCK)
    where Initiator <> ''
    UPDATE VTAlerts
    set Initiator = B.Initiator, SourceId = B.SourceId, InTransitId = B.InTransitId, DestinationId = B.DestinationId
    from VTAlerts A, @tblVTAlerts B
    WHERE A.ActionId = B.ActionId
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
--	-- Remove due to slow performance with large number of media in database
--	-- No need to do this because the cleanup is handled by VTUpdateMediaInAction already
--	DELETE	FROM MMContainer
--	WHERE	Flag = TM_CONTAINER_SYSTEM_CREATED
--	AND		ContainerId NOT IN (SELECT DISTINCT ContainerId FROM MMMedia)
	IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
	-- Remove media no longer part of Vault Tracker
	DELETE	MMMediaExport
	FROM	MMMediaExport MMME
	WHERE	MMME.VTActionId > 0
	AND		NOT EXISTS (
				SELECT * FROM VTActionMedia VTAM
				WHERE	VTAM.ActionId = MMME.VTActionId
				AND		VTAM.MediaId = MMME.MediaId
			)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
	DELETE	FROM VTAction
	WHERE	ActionId NOT IN (SELECT ActionId FROM VTActionMedia)
	IF	@@ERROR > 0 GOTO CX_ERROR_EXIT
/****************************************************************************************/
/****************************************************************************************/
--   +----------------------------+
--   |	NORMAL, "HAPPY" EXIT:    |
--   +----------------------------+
CX_EXIT:
	IF	object_id('tempdb.dbo.#VTMediaForCmdList') is not null DROP TABLE #VTMediaForCmdList
	IF @curor_open = 1
	BEGIN
			CLOSE		VTMediaForCmdCur
			DEALLOCATE	VTMediaForCmdCur
	END
	COMMIT TRANSACTION VTCMDTRAN
	SELECT	@retVal, @mediaProcessed, @mediaSkipped, @errorString
	RETURN
--   +----------------------------+
--   |   ABNORMAL, "ERROR" EXIT:  |
--   +----------------------------+
CX_ERROR_EXIT:
	IF	object_id('tempdb.dbo.#VTMediaForCmdList') is not null DROP TABLE #VTMediaForCmdList
	IF @curor_open = 1
	BEGIN
			CLOSE		VTMediaForCmdCur
			DEALLOCATE	VTMediaForCmdCur
	END
	ROLLBACK TRANSACTION VTCMDTRAN
	SELECT	@retVal, @mediaProcessed, @mediaSkipped, @errorString
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'VTRunActionCmd')
	delete from GxQscripts where name = 'VTRunActionCmd'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTRunActionCmd')
	delete from GXDBVersions where aliasname = 'VTRunActionCmd'
GO

insert into GXDBVersions values(2, 'VTRunActionCmd',  '00010032017800050000', 'VTRunActionCmd', '00010032017800050000')
GO

