

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VTPerformAdminFunctionality.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VTPerformAdminFunctionality.sp,v $ $Id: VTPerformAdminFunctionality.sp,v 1.26.86.2 2018/03/20 20:01:06 jiechen Exp $";
--  +========================================================================+
--  | Stored Precedure: VTPerformAdminFunctionality()
--  |
--  | Description:  1) Abort the media that are passed quit time.
--	|				2) Get the media that are not there in MMMediaExport table,
--	|					but are there in VTActionMediatable. Allow 15 minutes from
--	|					the start time to account for the timing issues
--	|				3) Get the list of media that are resumed and are ready to be exported
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VTPerformAdminFunctionality <<<'

IF EXISTS (select * from sysobjects where name='VTPerformAdminFunctionality')
	drop procedure VTPerformAdminFunctionality
IF EXISTS (select * from GxQscripts where name='VTPerformAdminFunctionality')
	delete from GxQscripts where name = 'VTPerformAdminFunctionality'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTPerformAdminFunctionality')
	delete from GXDBVersions where aliasname = 'VTPerformAdminFunctionality'
GO
print '... Creating Procedure: VTPerformAdminFunctionality'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure VTPerformAdminFunctionality
  @i_commcellId INTEGER
AS
  DECLARE @r_mediaId integer;
  DECLARE @r_actionId integer;
  DECLARE @r_policyId integer;
  DECLARE @r_inTransitId integer;
  DECLARE @r_inTransitValue integer;
  DECLARE @r_sourceId integer;
  DECLARE @r_destLocId integer;
  DECLARE @r_destLocType integer;
  DECLARE @r_destLocValue integer;
  DECLARE @r_containerId integer;
  DECLARE @r_actionType integer;
  DECLARE @r_operation integer;
  DECLARE @r_operationState integer;
SET NOCOUNT ON
	if object_id('tempdb.dbo.#tmpMedList') is not null DROP TABLE #tmpMedList
	create table #tmpMedList(
								mediaId				integer,
								barCode				char(256),
								actionId			integer,
								policyId			integer,
								inTransitId			integer,
								inTransitValue		integer,
								sourceId			integer,
								destLocId			integer,
								destLocType			integer,
								destLocValue		integer,
								containerId			integer,
								actionType			integer,
								operation			integer,
								operationState		integer)
	DECLARE @tblActionToPend table (ActionId integer)
	DECLARE @tblActionToPickup table (ActionId integer)
	DECLARE @tblMediaToAbort table (ActionId integer, MediaId integer)
	DECLARE @tblMediaRecallDone table (ActionId integer, MediaId integer)
	DECLARE @tblActionCmdReturn table (retVal int, mediaProcessed int, mediaSkipped int, errString VARCHAR(1024))
	DECLARE @tblMediaToUnpin table (MediaId integer)
	DECLARE	@l_utcDateTime			DATETIME
	DECLARE @l_currentTime			integer
	DECLARE @actionId				integer
	DECLARE @mediaId				integer
	DECLARE	@l_MediaCount			integer
	DECLARE	@retVal					integer
	DECLARE	@errorString			VARCHAR(1024)
	SET @l_utcDateTime				= getUTCDate()
	SET @l_currentTime				= (select dbo.getUnixTime(@l_utcDateTime))
	SET	@retVal = 0
	SET @errorString = ''
	DECLARE @open_VTMediaRecallDoneCur INTEGER
	set @open_VTMediaRecallDoneCur = 0
	DECLARE @open_VTMediaAbortCur INTEGER
	set @open_VTMediaAbortCur = 0
	DECLARE @open_VTActionPickupCur INTEGER
	set @open_VTActionPickupCur = 0
	DECLARE @open_VTActionToPendCur INTEGER
	set @open_VTActionToPendCur = 0
	-- Recall done for media at destination past recall expiration time.
	INSERT	INTO @tblMediaRecallDone
	SELECT	a.ActionId, a.MediaId
	FROM	VTActionMedia a, VTAction b
	WHERE	a.ActionId = b.ActionId
AND		a.Flag = 4
AND		a.State = 2
AND		b.ActionType = 2
	AND		b.RecallExpireTime > 0
	AND		b.RecallExpireTime < @l_currentTime
	IF EXISTS (SELECT * FROM @tblMediaRecallDone)
	BEGIN
		DECLARE	VTMediaRecallDoneCur CURSOR FOR SELECT * FROM @tblMediaRecallDone
		OPEN VTMediaRecallDoneCur
		set @open_VTMediaRecallDoneCur = 1
		FETCH NEXT FROM VTMediaRecallDoneCur INTO @actionId, @mediaId
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			DELETE FROM @tblActionCmdReturn
			INSERT INTO @tblActionCmdReturn
EXEC VTRunActionCmd 8192, @actionId, @mediaId, 0
			IF	@@ERROR <> 0 GOTO CX_EXIT
			FETCH NEXT FROM VTMediaRecallDoneCur INTO @actionId, @mediaId
		END
	END
	/* 7.0: Abort suspended media if action is paused or pending for more than the quit time.
	INSERT	INTO @tblMediaToAbort
	SELECT	DISTINCT a.ActionId, a.MediaId
	FROM	VTActionMedia a, VTAction b, MMMediaExport c
	WHERE	a.ActionId = b.ActionId
	AND		a.ActionId = c.VTActionId
	AND		a.MediaId = c.MediaId
AND		b.ActionState IN (2, 4)
	AND		b.ActionQuitTime > 0
	AND		b.ActionQuitTime < @l_currentTime
AND		c.Flags & 1 > 0
	*/
	DECLARE @ExportCleanupInterval integer
	SET @ExportCleanupInterval = (select Value from MMConfigs where name = 'MMS2_CONFIG_VT_CLEANUP_DANGLING_EXPORTS_INTERVAL_HOURS')
	SET @ExportCleanupInterval = (@ExportCleanupInterval* 60 * 60)
	-- 8.0: Abort action which is older than the action retention defined in MMConfigs
	INSERT	INTO @tblMediaToAbort
	SELECT	a.ActionId, a.MediaId
	FROM	VTActionMedia a, VTAction b
	WHERE	a.ActionId = b.ActionId
AND		b.ActionType <> 2
	AND		b.ActionStartTime + @ExportCleanupInterval < @l_currentTime
	IF	@@ERROR <> 0 GOTO CX_EXIT
	-- Abort recalled media if media is not at destination and pass recall expiration time.
	INSERT	INTO @tblMediaToAbort
	SELECT	DISTINCT a.ActionId, a.MediaId
	FROM	VTActionMedia a, VTAction b
	WHERE	a.ActionId = b.ActionId
AND		a.State <> 2
AND		b.ActionType = 2
	AND		b.RecallExpireTime > 0
	AND		b.RecallExpireTime < @l_currentTime
	-- Abort media with abort request
	INSERT	INTO @tblMediaToAbort
	SELECT	ActionId, MediaId
	FROM	VTActionMedia
WHERE	Flag = 64
	IF EXISTS (SELECT * FROM @tblMediaToAbort)
	BEGIN
		DECLARE	VTMediaAbortCur CURSOR FOR SELECT * FROM @tblMediaToAbort
		OPEN VTMediaAbortCur
		set @open_VTMediaAbortCur = 1
		FETCH NEXT FROM VTMediaAbortCur INTO @actionId, @mediaId
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			DELETE FROM @tblActionCmdReturn
			INSERT INTO @tblActionCmdReturn
EXEC VTRunActionCmd 2, @actionId, @mediaId, 0
			IF	@@ERROR <> 0 GOTO CX_EXIT
			FETCH NEXT FROM VTMediaAbortCur INTO @actionId, @mediaId
		END
	END
	-- Pickup media
	INSERT	INTO @tblActionToPickup
	SELECT	DISTINCT ActionId
	FROM	VTActionMedia
WHERE	Flag = 128
	IF @@ROWCOUNT > 0
	BEGIN
		DECLARE	VTActionPickupCur CURSOR FOR SELECT * FROM @tblActionToPickup
		OPEN VTActionPickupCur
		set @open_VTActionPickupCur = 1
		FETCH NEXT FROM VTActionPickupCur INTO @actionId
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			DELETE FROM @tblActionCmdReturn
			INSERT INTO @tblActionCmdReturn
EXEC VTRunActionCmd 8, @actionId, 0, 0
			IF	@@ERROR <> 0 GOTO CX_EXIT
			FETCH NEXT FROM VTActionPickupCur INTO @actionId
		END
	END
	-- Set action to pending state if quit time passed
	INSERT	INTO @tblActionToPend
	SELECT	ActionId
	FROM	VTAction
	WHERE	ActionQuitTime > 0 AND ActionQuitTime <= @l_currentTime
AND		ActionState = 1
	IF(@@ROWCOUNT > 0)
	BEGIN
		DECLARE	VTActionToPendCur CURSOR FOR SELECT * FROM @tblActionToPend
		OPEN VTActionToPendCur
		set @open_VTActionToPendCur = 1
		FETCH NEXT FROM VTActionToPendCur INTO @actionId
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			DELETE FROM @tblActionCmdReturn
			INSERT INTO @tblActionCmdReturn
EXEC VTRunActionCmd 16384, @actionId, 0, 0
			IF	@@ERROR <> 0 GOTO CX_EXIT
			FETCH NEXT FROM VTActionToPendCur INTO @actionId
		END
	END
	delete	from MMMediaExport
	where	VTActionId > 0
	and		MediaId IN (
			select mediaId from MMMedia WITH (NOLOCK)
where Attributes & 16777216 > 0
			)
	--Now take care of the media that are part of VTActionMedia table and don't have any entries in MMMediaExport table.
	INSERT	INTO #tmpMedList
	SELECT distinct VTM.MediaId, MM.BarCode, VTA.ActionId, VTA.PolicyId, VTA.InTransitId, 0,
			VTA.SourceId, VTA.DestinationId, 0, 0,
			VTA.ContainerId, VTA.ActionType, VTM.Operation, VTM.OperationState
	FROM VTAction AS VTA WITH (NOLOCK), VTActionMedia AS VTM WITH (NOLOCK), MMMedia as MM WITH (NOLOCK)
	WHERE VTA.ActionId = VTM.ActionId
AND	VTA.ActionState = 1
	AND VTM.MediaId = MM.MediaId
AND VTM.State in (1, 6)
AND VTM.Operation IN (2, 16)
AND	VTM.OperationState = 1
AND	(MM.Attributes & 16777216) = 0
	AND (	VTM.MediaId NOT IN(Select MediaId from MMMediaExport WITH (NOLOCK))
		OR	VTM.MediaId     IN(Select MediaId from MMMediaExport WITH (NOLOCK)
WHERE Flags & 2 > 0)
		)
	UPDATE	#tmpMedList
	SET		inTransitValue = b.Value
	FROM	#tmpMedList a, VTLocation b
	WHERE	a.inTransitId = b.LocationId
	UPDATE	#tmpMedList
	SET		destLocValue = b.Value, destLocType = b.Type
	FROM	#tmpMedList a, VTLocation b
	WHERE	a.destLocId = b.LocationId
	-- Remove media at virtual mail slot or mail slot or in library with no virtual and regular mail slot defined
	DELETE	#tmpMedList
	FROM	#tmpMedList a, VTActionMedia b WITH (NOLOCK)
	WHERE	a.mediaId = b.mediaId
AND		b.state in (4, 8, 5)
	SET @l_MediaCount = (select count(*) from #tmpMedList)
	IF(@l_MediaCount > 0)
	BEGIN
		delete from MMMediaExport where MediaId IN(select mediaId from #tmpMedList)
	END
	IF (cast (rand()*10 as integer) = 3)
	BEGIN
		INSERT	INTO @tblMediaToUnpin
		SELECT	MediaId
		FROM	MMMedia WITH (NOLOCK)
		WHERE	PinMediaExpireTime > 0
AND		(Attributes & 16777216) > 0
		AND		@l_currentTime > PinMediaExpireTime
		--Unpin the media since the PinMediaExpireTime is expired
		UPDATE MMMedia
Set Attributes = Attributes & ~16777216, PinMediaExpireTime = 0
		WHERE	MediaId IN (SELECT MediaId FROM @tblMediaToUnpin)
		IF	@@ERROR <> 0 GOTO CX_EXIT
	END
CX_EXIT:
	IF @open_VTActionPickupCur = 1
	BEGIN
		CLOSE VTActionPickupCur
		DEALLOCATE VTActionPickupCur
	END
	IF @open_VTMediaRecallDoneCur = 1
	BEGIN
		CLOSE VTMediaRecallDoneCur
		DEALLOCATE VTMediaRecallDoneCur
	END
	IF @open_VTMediaAbortCur = 1
	BEGIN
		CLOSE VTMediaAbortCur
		DEALLOCATE VTMediaAbortCur
	END
	IF @open_VTActionToPendCur = 1
	BEGIN
		CLOSE VTActionToPendCur
		DEALLOCATE VTActionToPendCur
	END
	select mediaId, actionId, policyId,
	inTransitId, inTransitValue, sourceId, destLocId, destLocType, destLocValue,
	containerId, actionType, operation, operationState
	from #tmpMedList
	ORDER BY actionId ASC, policyId ASC, barCode ASC
	drop table #tmpMedList
GO

IF EXISTS (select * from GxQscripts where name = 'VTPerformAdminFunctionality')
	delete from GxQscripts where name = 'VTPerformAdminFunctionality'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTPerformAdminFunctionality')
	delete from GXDBVersions where aliasname = 'VTPerformAdminFunctionality'
GO

insert into GXDBVersions values(2, 'VTPerformAdminFunctionality',  '00010026008600020000', 'VTPerformAdminFunctionality', '00010026008600020000')
GO

