

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VTMediaCalculation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VTMediaCalculation.sp,v $ $Id: VTMediaCalculation.sp,v 1.7.278.3 2018/03/20 19:55:19 jiechen Exp $";
--  +========================================================================+
--  | Stored Precedure: VTMediaCalculation
--	| Description: Calculation for vault tracker action media.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VTMediaCalculation <<<'

IF EXISTS (select * from sysobjects where name='VTMediaCalculation')
	drop procedure VTMediaCalculation
IF EXISTS (select * from GxQscripts where name='VTMediaCalculation')
	delete from GxQscripts where name = 'VTMediaCalculation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTMediaCalculation')
	delete from GXDBVersions where aliasname = 'VTMediaCalculation'
GO
print '... Creating Procedure: VTMediaCalculation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure VTMediaCalculation
  @i_mediaId INTEGER
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	-- Variable with input value
	DECLARE	@libraryId 				INTEGER
	DECLARE	@libraryTypeId			INTEGER
	DECLARE	@mediaLocation	 		INTEGER
	DECLARE	@exportLocationId		INTEGER
	DECLARE	@actionFlag				INTEGER
	DECLARE	@destLocationValue		INTEGER
	DECLARE	@destLocationType		INTEGER
	DECLARE	@destLibraryType		INTEGER
	-- Variable to be calculated and returned
	DECLARE	@actionSourceId			INTEGER
	DECLARE	@sourceLocationType		INTEGER
	DECLARE	@sourceLocationValue	INTEGER
	DECLARE	@vtMediaState			INTEGER
	DECLARE	@vtMediaFlag			INTEGER
	DECLARE @vtMediaOperation		INTEGER
	DECLARE @vtMediaOpState			INTEGER
	DECLARE @mediaAtDest			INTEGER
	DECLARE @alertType				INTEGER
	-- Temp variable
	DECLARE	@vmsSlotId				INTEGER
	DECLARE	@startVMS				INTEGER
	DECLARE	@numMailSlot			INTEGER
	DECLARE @ExportStandAloneTape integer = 0
	SET @ExportStandAloneTape = (select value from MMConfigs where name = 'MMS2_CONFIG_STRING_VT_EXPORT_STANDALONE_TAPE')
	/****************************************************************************************/
	SELECT	@libraryId = libraryId,
			@mediaLocation = mediaLocation,
			@exportLocationId = exportLocationId,
			@actionFlag = actionFlag,
			@destLocationValue = destLocationValue,
			@destLocationType = destLocationType,
			@destLibraryType = destLibraryType
	FROM	#vtMediaForAction
	WHERE	MediaId = @i_mediaId
	-- Initiate variable at media level
	SET	@sourceLocationValue = 0
	SET	@sourceLocationType = 0
	SET	@libraryTypeId = 0
	SET @actionSourceId = 0
SET	@vtMediaState = 1
SET	@vtMediaFlag = 0
SET @vtMediaOperation = 0
SET	@vtMediaOpState = 0
	SET	@mediaAtDest = 0
	SET	@alertType = 0
	SET	@startVMS = 0
	IF	@libraryId > 0
		SET	@libraryTypeId = ISNULL((SELECT LibraryTypeId FROM MMLibrary WHERE LibraryId = @libraryId), 0)
	-- Source is a regular library or shelf or stand alone library
IF	@mediaLocation <> 3 OR @mediaLocation = 3 AND @exportLocationId = 0 AND @LibraryTypeId IN (4, 5, 8)
	BEGIN
SET		@sourceLocationType = 1
		SET		@sourceLocationValue = @libraryId
		SELECT	@actionSourceId = LocationId
		FROM	VTLocation WITH (NOLOCK)
WHERE	Type = 1
		AND		Value = @libraryId
	END
	ELSE
	BEGIN
SET		@sourceLocationType = 2
		SET		@sourceLocationValue = @exportLocationId
		SELECT	@actionSourceId = LocationId
		FROM	VTLocation WITH (NOLOCK)
WHERE	Type = 2
		AND		Value = @exportLocationId
	END
	SELECT	@numMailSlot = COUNT(*)
	FROM	MMSlot a WITH (NOLOCK), MMLibrary b WITH (NOLOCK), MMBay c WITH (NOLOCK)
	WHERE	a.BayId = c.BayId
	AND		c.LibraryId = b.LibraryId
	AND		b.LibraryId = @libraryId
	AND		a.SlotType in (2, 3)
	SELECT	@startVMS = StartVMSElementAddress
	FROM	MMLibrary WITH (NOLOCK)
	WHERE	LibraryId = @libraryId
	-- Use VMS for media inside regular library with VMS slots defined
	-- and use VMS if library has no mail slot or action with VMS required
IF	@startVMS > 0 AND (@actionFlag & 4 > 0 OR @numMailSlot = 0)
		AND @mediaLocation IN (1, 2)
AND @libraryTypeId NOT IN (4, 5)
	BEGIN
		-- Figure out if vms is defined for library
		SELECT	@vmsSlotId = a.SlotId
		FROM	MMSlot a WITH (NOLOCK), MMLibrary b WITH (NOLOCK), MMBay c WITH (NOLOCK)
		WHERE	a.BayId = c.BayId
		AND		c.LibraryId = b.LibraryId
		AND		b.StartVMSElementAddress = a.ElementAddress
		AND		b.LibraryId = @libraryId
		AND		a.SlotType = 1
	END
	/****************************************************************************************/
	/***********************    MEDIA TO BE EXPORTED    *************************************/
	/****************************************************************************************/
	-- Media is in regular library.
	-- Destination is export location or TM_LOCATION_TYPE_SLOT with different libraryId.
IF		@mediaLocation in (1, 2) AND ( @ExportStandAloneTape > 0 OR @ExportStandAloneTape = 0 AND @libraryTypeId NOT IN (4, 5) )
AND (@destLocationType = 2
OR	 @destLocationType = 1 AND @destLocationValue > 0 AND @libraryId <> @destLocationValue)
	BEGIN
SET	@vtMediaOpState = 1
		-- Option to use virtual mail slot is selected and virtual mail slot is defined at library level
		IF	@vmsSlotId > 0
		BEGIN
SET @vtMediaOperation = 16
		END
		ELSE
		BEGIN
SET @vtMediaOperation = 2
		END
		GOTO CX_EXIT
	END
	/****************************************************************************************/
	/***********************  MEDIA NOT TO BE EXPORTED  *************************************/
	/****************************************************************************************/
	-- Destination is library or shelf, @destLocationValue is libraryId
IF	@destLocationType = 1
	BEGIN
		-- Media is in library and destination is ANY library.
		-- Media is at the same library as destination.
		-- Media is at the same shelf or stand alone library as destination.
		IF		@mediaLocation IN (1, 2) AND @destLocationValue = 0
			OR	@mediaLocation IN (1, 2) AND @destLocationValue > 0 AND @sourceLocationValue = @destLocationValue
			OR	@mediaLocation = 3  AND @exportLocationId = 0  AND @sourceLocationValue = @destLocationValue
		BEGIN
			SET	@mediaAtDest = 1
			GOTO CX_EXIT
		END
		-- Media is not in any library and destination is ANY library.
		-- Media is exported or on shelf or belongs to stand alone library, destination is a regular library.
		IF		@mediaAtDest = 0 AND @destLocationValue = 0
OR	@destLocationValue > 0 AND @destLibraryType NOT IN (4, 5, 8)
AND	(@mediaLocation = 3 OR @mediaLocation = 2 AND @libraryTypeId IN (4, 5))
		BEGIN
SET @vtMediaOperation = 1
SET	@alertType = 2053
			GOTO CX_EXIT
		END
	END
	-- Destination is export location, @destLocationValue is export location id.
IF	@destLocationType = 2
	BEGIN
		-- Media is at the same export location as destination.
		IF		@mediaLocation = 3 AND @exportLocationId > 0 AND @destLocationValue = @exportLocationId
		BEGIN
			SET	@mediaAtDest = 1
			GOTO CX_EXIT
		END
	END
	-- Media not at destination and not to be exported nor imported will needs to be relocated!
SET @vtMediaOperation = 4
	GOTO CX_EXIT
	/****************************************************************************/
CX_EXIT:
	UPDATE	#vtMediaForAction
	SET		actionSourceId = @actionSourceId,
			vtMediaState = @vtMediaState,
			vtMediaFlag = @vtMediaFlag,
			vtMediaOperation = @vtMediaOperation,
			vtMediaOpState = @vtMediaOpState,
			mediaAtDest = @mediaAtDest,
			alertType = @alertType
	WHERE	mediaId = @i_mediaId
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'VTMediaCalculation')
	delete from GxQscripts where name = 'VTMediaCalculation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTMediaCalculation')
	delete from GXDBVersions where aliasname = 'VTMediaCalculation'
GO

insert into GXDBVersions values(2, 'VTMediaCalculation',  '00010007027800030000', 'VTMediaCalculation', '00010007027800030000')
GO

