

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VTCreateNewContainer.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VTCreateNewContainer.sp,v $ $Id: VTCreateNewContainer.sp,v 1.6.274.4 2018/03/20 19:50:28 jiechen Exp $";
--  +========================================================================+
--  | Stored Precedure: VTCreateNewContainer
--	| Description: Create new container for vault tracker media.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VTCreateNewContainer <<<'

IF EXISTS (select * from sysobjects where name='VTCreateNewContainer')
	drop procedure VTCreateNewContainer
IF EXISTS (select * from GxQscripts where name='VTCreateNewContainer')
	delete from GxQscripts where name = 'VTCreateNewContainer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTCreateNewContainer')
	delete from GXDBVersions where aliasname = 'VTCreateNewContainer'
GO
print '... Creating Procedure: VTCreateNewContainer'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure VTCreateNewContainer
  @policyId INTEGER,
  @containerPattern NVARCHAR(MAX),
  @containerPatternNumber INTEGER,
  @containerCapacity INTEGER,
  @containerIdOriginal INTEGER,
  @destLocationType INTEGER,
  @destLocationValue INTEGER,
  @containerSidbStoreId INTEGER
AS
  DECLARE @o_containerId INTEGER
  DECLARE @o_containerPatternNumber INTEGER
  DECLARE @o_newContainerName NVARCHAR(256)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @retVal				INTEGER = 0
	DECLARE @containerId		INTEGER = 0
DECLARE @newContainerName	NVARCHAR(256) = ''
DECLARE @oldContainerName	NVARCHAR(256) = ''
	DECLARE @currentDate		datetime = GETUTCDATE()
	DECLARE @name_begin_str NVARCHAR(1024) = '<CONTAINER_NAME_BEGIN>'
	DECLARE @name_end_str NVARCHAR(1024) = '<CONTAINER_NAME_END>'
	DECLARE @delimiter NVARCHAR(1024) = ','
	DECLARE @name_begin_index int = 0
	DECLARE @name_end_index int = 0
	DECLARE @name_list NVARCHAR(max) = ''
	DECLARE @tblNameList table (id	integer IDENTITY (1,1), name NVARCHAR(1024), fullName NVARCHAR(1024), containerId int, flag int, capacity int, numMedia int)
	declare @tempContainerId integer
	declare @numMediaInContainer integer
	declare @tempCapacity integer
	declare @tempflag integer
	IF	@containerIdOriginal = 0 AND @containerPattern <> ''
	BEGIN
		DECLARE @commCellNumberStr		NVARCHAR(10)
		DECLARE @destinationName		NVARCHAR(256)
		DECLARE @numberStartStr			NVARCHAR(256)
		DECLARE @currNumberStartStr		NVARCHAR(256)
		DECLARE @numberStartNum			bigint
		DECLARE @index					INTEGER
		DECLARE @loopindex				INTEGER
		DECLARE	@oldlen					INTEGER
		SET	@newContainerName = @containerPattern
		SET	@destinationName = ''
		DECLARE @sidbStoreName			NVARCHAR(256) = ''
		DECLARE @dedupToken				INTEGER = 0
		DECLARE @nameToken				INTEGER = 0
		IF @containerSidbStoreId > 0
			SET @sidbStoreName = ISNULL((SELECT sidbStoreName
			from IdxSIDBStore
			where sidbStoreId = @containerSidbStoreId), '')
WHILE (SELECT charindex('<COMMCELLNUMBER>', @newContainerName)) > 0
		BEGIN
SET @index = charindex('<COMMCELLNUMBER>', @newContainerName)
			SET @commCellNumberStr = (select top 1 cast(number as VARCHAR(10)) from APP_CommCell where number > 0)
SET @newContainerName = stuff(@newContainerName, @index, len('<COMMCELLNUMBER>'), @commCellNumberStr)
		END
WHILE (SELECT charindex('<DATE>', @newContainerName)) > 0
		BEGIN
SET @index = charindex('<DATE>', @newContainerName)
SET @newContainerName = stuff(@newContainerName, @index, len('<DATE>'), convert(VARCHAR(12), @currentDate, 100))
		END
WHILE (SELECT charindex('<TIME>', @newContainerName)) > 0
		BEGIN
SET @index = charindex('<TIME>', @newContainerName)
SET @newContainerName = stuff(@newContainerName, @index, len('<TIME>'), convert(VARCHAR(10), @currentDate, 108))
		END
WHILE (SELECT charindex('<DAY>', @newContainerName)) > 0
		BEGIN
SET @index = charindex('<DAY>', @newContainerName)
SET @newContainerName = stuff(@newContainerName, @index, len('<DAY>'), datename(w, @currentDate))
		END
WHILE (SELECT charindex('<DESTINATION>', @newContainerName)) > 0
		BEGIN
SET @index = charindex('<DESTINATION>', @newContainerName)
			IF @destinationName = ''
			BEGIN
IF @destLocationType = 2
					SET @destinationName = (SELECT exportlocation from MMExportLocation where exportlocationid = @destLocationValue)
IF @destLocationType = 1
					IF @destLocationValue != 0
						SET @destinationName = (SELECT aliasname from MMLibrary where libraryid = @destLocationValue)
					ELSE
						SET @destinationName = 'Inside Library'
				IF @destinationName is null
					SET @destinationName = ''
			END
SET @newContainerName = stuff(@newContainerName, @index, len('<DESTINATION>'), @destinationName)
		END
		-- Only apply SILO store name token once
WHILE (SELECT charindex('<DEDUPSTORENAME>', @newContainerName)) > 0
		BEGIN
SET @index = charindex('<DEDUPSTORENAME>', @newContainerName)
			IF @dedupToken = 0 AND @containerSidbStoreId > 0 AND @sidbStoreName <> ''
SET @newContainerName = stuff(@newContainerName, @index, len('<DEDUPSTORENAME>'), @sidbStoreName)
			ELSE
SET @newContainerName = stuff(@newContainerName, @index, len('<DEDUPSTORENAME>'), '')
			SET @dedupToken = 1
		END
		-- Append sidb store name for silo container if it is not part of the pattern
		IF @dedupToken = 0 AND @containerSidbStoreId > 0 AND @sidbStoreName <> ''
		BEGIN
			SET @newContainerName = @newContainerName + '_' + @sidbStoreName
			SET @dedupToken = 1
		END
		SET @name_begin_index = charindex(@name_begin_str, @newContainerName)
		SET @name_end_index = charindex(@name_end_str, @newContainerName)
		IF	@name_begin_index > 0 and @name_end_index > 0 and @name_begin_index < @name_end_index
		BEGIN
			SET @name_list = SUBSTRING(@newContainerName, @name_begin_index + len(@name_begin_str), @name_end_index - @name_begin_index - len(@name_begin_str))
			SET @name_list = ltrim(rtrim(@name_list))
			if len(@name_list) > 0
				set @nameToken = 1
		END
		-- The STDALN_LABEL_START pattern should only be used once!
SET @index = charindex('<NUMBERSTART>', @newContainerName)
		IF	@index > 0
		BEGIN
			SET @loopindex = 1
WHILE		ISNUMERIC(SUBSTRING(@newContainerName, @index + len('<NUMBERSTART>'), @loopindex)) > 0
AND len(@newContainerName) >= (@index + len('<NUMBERSTART>') - 1 + @loopindex)
			BEGIN
				SET @loopindex = @loopindex + 1
			END
SET @numberStartStr = SUBSTRING(@newContainerName, @index + len('<NUMBERSTART>'), @loopindex - 1)
			SET @currNumberStartStr = @numberStartStr
			IF @ContainerPatternNumber > 0 and @ContainerPatternNumber > cast(@numberStartStr as bigint)
			BEGIN
				SET @currNumberStartStr = cast(@ContainerPatternNumber as VARCHAR(256))
			END
			IF	@dedupToken > 0 or @nameToken > 0
			BEGIN
				-- Do not apply this number token to SILO container or when name token list is provided
SET @newContainerName = stuff(@newContainerName, @index, len('<NUMBERSTART>') + len(@numberStartStr), '')
			END
			ELSE
			BEGIN
SET @newContainerName = stuff(@newContainerName, @index, len('<NUMBERSTART>') + len(@numberStartStr), @currNumberStartStr)
				SET @numberStartNum = cast(@currNumberStartStr as bigint)
				-- Check only containers for non-silo tapes
				WHILE exists (select * from MMContainer with (nolock)
								where ContainerName = @newContainerName
								AND SidbStoreId = 0)
				BEGIN
					select @tempContainerId = containerid, @tempCapacity = capacity, @tempflag = flag
					from MMContainer with (nolock)
					where ContainerName = @newContainerName
					and SidbStoreId = 0
					set @numMediaInContainer = (select count(*) from mmmedia with (nolock) where containerid = @tempContainerId)
					-- Use existing container if there is still space for more media
					-- Flag TM_CONTAINER_OFFSITE is set by qscript QS_ContainerSetup
if @numMediaInContainer < @tempCapacity and @tempflag & 2 <> 2
					begin
						set @containerId = @tempContainerId
						set @newContainerName = ''
						break
					end
					SET @oldlen = len(@currNumberStartStr)
					SET @numberStartNum = @numberStartNum + 1
					SET @ContainerPatternNumber = @numberStartNum
					SET @currNumberStartStr = cast(@numberStartNum as VARCHAR(64))
					WHILE len(@currNumberStartStr) < (@loopindex - 1)
					BEGIN
						-- fill in leading zero to form VARCHAR
						SET @currNumberStartStr = '0' + @currNumberStartStr
					END
					SET @newContainerName = stuff(@newContainerName, @index, @oldlen, @currNumberStartStr)
				END
			END
		END
		SET @newContainerName = ltrim(rtrim(@newContainerName))
		IF @nameToken > 0
		BEGIN
			declare @dIndex int
			declare @nLen int
			declare @tName NVARCHAR(1024)
			declare @fName NVARCHAR(1024)
			while len(@name_List) > 0
			begin
				set @dIndex = charindex(@delimiter, @name_list)
				if @dIndex = 0
				begin
					SET @tName = @name_List
					SET @name_List = ''
				end
				else
				begin
					set @tName = SUBSTRING(@name_list, 1, @dIndex-1)
					set @name_list = SUBSTRING(@name_list, @dIndex+1, len(@name_list)-@dIndex)
				end
				SET @fName = stuff(@newContainerName, @name_begin_index, @name_end_index + len(@name_end_str)-@name_begin_index, @tName)
				insert into @tblNameList
				select @tName, @fName, 0, 0, 0, 0
			end
			/*
			-- Do not support rollover with this container pattern
			-- insert the default container with policy name
			SET @tName = 'P_' + (select PolicyName from VTPolicy with (nolock) where PolicyId = @policyId)
			SET @fName = stuff(@newContainerName, @name_begin_index, @name_end_index + len(@name_end_str)-@name_begin_index, @tName)
			insert into @tblNameList
			select @tName, @fName, 0, 0, 0, 0
			-- insert existing rollover containers with policy name
			insert into @tblNameList
			select ContainerName, ContainerName, 0, 0, 0, 0
			from MMContainer with (nolock)
			where ContainerName like @fName + '_%'
			and ISNUMERIC(SUBSTRING(ContainerName, len(@fName)+2, len(ContainerName)-len(@fName))) = 1
			*/
			-- get container information
			update @tblNameList
			set containerId = b.containerid, capacity = b.capacity, flag = b.flag, numMedia = (select count(*) from mmmedia with (nolock) where containerid = b.containerid)
			from @tblNameList a, MMContainer b with (nolock)
			where b.ContainerName = a.fullName
			and sidbStoreId = 0
			-- existing container with capacity available
			DECLARE @nIndex int
			-- get the container with the most media and least id in list that is onsite
set @nIndex = (select top 1 id from @tblNameList where numMedia < capacity and flag & 2 <> 2 order by numMedia desc, id asc)
			if @nIndex is not null
			begin
				SET @containerId = (select containerId from @tblNameList where id = @nIndex)
				SET	@newContainerName = ''
			end
			else
			begin
				-- new container to create
				set @nIndex = (select min(id) from @tblNameList where containerId = 0)
				if @nIndex is not null
				begin
					SET @containerId = 0
					SET @newContainerName = (select fullName from @tblNameList where id = @nIndex)
				end
				else
				begin
					-- all contains defined are either full or set to offsite
					/*
					-- Use the one with policy name to rollover
					set @nIndex = (select max(id) from @tblNameList)
					SET @containerIdOriginal = (select containerId from @tblNameList where id = @nIndex)
					*/
					SET @containerId = -2
					SET	@newContainerName = ''
					-- Do not create or return any container.
					GOTO PROC_EXIT
				end
			end
		END
		-- New container named @newContainerName will be created when @containerId = 0 and @containerIdOriginal = 0
	END
	if @containerId = 0 and len(@newContainerName) > 0 or @containerIdOriginal > 0
	begin
		DECLARE @containerIndex	INTEGER = 2
		if @containerIdOriginal > 0
			SET	@oldContainerName = (SELECT ContainerName FROM MMContainer with (nolock) WHERE ContainerId = @containerIdOriginal)
		else
			SET @oldContainerName = @newContainerName
ROLLOVER_CONTAINER:
		if @containerIdOriginal > 0
		begin
			SET @newContainerName = @oldContainerName + '_' + CAST(@containerIndex AS VARCHAR(100))
			SET @containerIndex = @containerIndex + 1
		end
		set @tempContainerId = null
		select @tempContainerId = containerid, @tempCapacity = capacity, @tempflag = flag
		from MMContainer with (nolock)
		where ContainerName = @newContainerName
		and SidbStoreId = @containerSidbStoreId
		if @tempContainerId is not null
		begin
			set @numMediaInContainer = (select count(*) from mmmedia with (nolock) where containerid = @tempContainerId)
if @numMediaInContainer < @tempCapacity and @tempflag & 2 <> 2
			begin
				set @containerId = @tempContainerId
				SET @newContainerName = ''
			end
			else
			begin
				SET	@containerIdOriginal = @tempContainerId
				GOTO ROLLOVER_CONTAINER
			end
		end
	end
	IF	@newContainerName <> ''
	BEGIN
		-- Create a new container
		INSERT INTO MMContainer (
				ContainerName, Flag, Capacity, MediaType, Descript,
				CreationTime, IsEmpty, ContainerEmptyTime, TrackingId,	SidbStoreId)
values (@newContainerName, 1, @containerCapacity,
0, 'Auto generated based on pattern',
				dbo.GetUnixTime(GETUTCDATE()), 0, 0, '', @containerSidbStoreId)
		SELECT	@retVal = @@ERROR, @containerId = @@IDENTITY
		IF	@retVal != 0
			SET @containerId = -1
	END
PROC_EXIT:
	SELECT @containerId, @ContainerPatternNumber, @newContainerName
GO

IF EXISTS (select * from GxQscripts where name = 'VTCreateNewContainer')
	delete from GxQscripts where name = 'VTCreateNewContainer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTCreateNewContainer')
	delete from GXDBVersions where aliasname = 'VTCreateNewContainer'
GO

insert into GXDBVersions values(2, 'VTCreateNewContainer',  '00010006027400040000', 'VTCreateNewContainer', '00010006027400040000')
GO

