

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VTCreateActionForPolicy.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VTCreateActionForPolicy.sp,v $ $Id: VTCreateActionForPolicy.sp,v 1.38.86.11 2019/08/07 06:01:08 rsivadas Exp $";
--  +========================================================================+
--  | Stored Precedure: VTCreateActionForPolicy
--  | Description:  Replace RunTmPolicy.
--	|				Create vault tracker actions through vault tracker policy
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='VTCreateActionForPolicy')
BEGIN
	print '>>> Drop Stored Procedure: VTCreateActionForPolicy <<<'
	drop procedure VTCreateActionForPolicy
END
IF EXISTS (select * from GxQscripts where name='VTCreateActionForPolicy')
	delete from GxQscripts where name = 'VTCreateActionForPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTCreateActionForPolicy')
	delete from GXDBVersions where aliasname = 'VTCreateActionForPolicy'
GO
print '... Creating Procedure: VTCreateActionForPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure VTCreateActionForPolicy
  @i_VTFlags INTEGER,
  @i_policyId INTEGER,
  @i_jobId_h INTEGER,
  @i_jobId_l INTEGER,
  @i_userId INTEGER,
  @i_libraryId INTEGER = 0
AS
  DECLARE @retVal INTEGER;
  DECLARE @errorString VARCHAR(1024);
  DECLARE @numActions INTEGER;
  DECLARE @numMedia INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	DECLARE @ViewPolicyMedia INTEGER
SET @ViewPolicyMedia = @i_VTFlags & 1
-- Start Transaction only for vt policy command "run", but not for "view media" through MMS2GetTmMediaForPolicyRuleSP
	IF @ViewPolicyMedia = 0
		BEGIN TRANSACTION VTPOLICYTRAN
/****************************************************************************************/
/************ Initialize and DECLARE temparary variables ********************************/
/****************************************************************************************/
	DECLARE @ruleId				INTEGER
	DECLARE	@policyEnabled		INTEGER
	DECLARE @containerId		INTEGER
	DECLARE @containerPattern		NVARCHAR(MAX)
	DECLARE @containerPatternNumber	INTEGER
	DECLARE @containerCapacity		INTEGER
	DECLARE @vtContainerCapacity	INTEGER
	DECLARE @findContainer		INTEGER
	DECLARE @numMediaInContainer	INTEGER
	DECLARE @numMediaToContainer	INTEGER
	DECLARE	@actionId			INTEGER
	DECLARE	@actionSourceId		INTEGER
	DECLARE	@actionDestId		INTEGER
	DECLARE	@actionFlag			INTEGER
	DECLARE	@inTransitId		INTEGER
	DECLARE	@vtContainerId		INTEGER
	DECLARE	@vtMediaState		INTEGER
	DECLARE	@vtMediaFlag		INTEGER
	DECLARE @vtMediaOperation	INTEGER
	DECLARE @vtMediaOpState		INTEGER
	DECLARE @sidbStoreId		INTEGER
	DECLARE @preSidbStoreId		INTEGER
	DECLARE	@mediaId			INTEGER
	DECLARE	@libraryId			INTEGER
	DECLARE	@mediaLocation		INTEGER
	DECLARE	@exportLocationId	INTEGER
	DECLARE @currentDate		datetime
	DECLARE @currentTime		INTEGER
	DECLARE	@slotId				INTEGER
	DECLARE	@vmsSlotId			INTEGER
	DECLARE	@vmsDirection		INTEGER
	DECLARE	@availableSlots		INTEGER
	DECLARE	@startVMS			INTEGER
	DECLARE @bayId				INTEGER
	DECLARE @open_VTActionForPolicyCur INTEGER
	DECLARE @open_ContainerCur	INTEGER
	DECLARE @mediaAtDest		INTEGER
	DECLARE @mediaNoAction		INTEGER
	DECLARE @alertType			INTEGER
	DECLARE	@isDueBackPolicy	INTEGER
	DECLARE	@initiator			NVARCHAR(255)
	DECLARE	@destLibraryType		INTEGER
	DECLARE	@destLocationType		INTEGER
	DECLARE	@destLocationValue		INTEGER
	SET	@retVal = 0
	SET @errorString = 'WARNING: '
	SET	@numActions = 0
	SET	@numMedia = 0
	SET @open_VTActionForPolicyCur = 0
	SET	@vtContainerId = 0
	SET	@vtContainerCapacity = 0
	SET	@sidbStoreId = 0
	SET	@preSidbStoreId = 0
	SET	@initiator = 'Policy: ' + (SELECT PolicyName FROM VTPolicy WHERE PolicyId = @i_policyId)
	SET @open_ContainerCur = 0
	SET @actionDestId = 0
	SET	@destLibraryType = 0
	SET	@destLocationType = 0
	SET	@destLocationValue = 0
	SET @inTransitId = 0
	SET	@numMediaToContainer = 0
	IF object_id('tempdb.dbo.#securityRet') is not null DROP TABLE #securityRet
	IF object_id('tempdb.dbo.#vtContainer') is not null DROP TABLE #vtContainer
	IF object_id('tempdb.dbo.#vtMediaIdList') is not null DROP TABLE #vtMediaIdList
	IF object_id('tempdb.dbo.#vtMediaForAction') is not null DROP TABLE #vtMediaForAction
/****************************************************************************************/
/********************** Create temparary tables *****************************************/
/****************************************************************************************/
	CREATE TABLE #vtMediaIdList (
			MediaId INT,
			DueBackDate	BIGINT
	)
	CREATE TABLE #securityRet (
			spRetCode INT,
			retString	varchar(1024)
	)
	CREATE TABLE #vtContainer (
			ContainerId INT,
			ContainerPatternNumber INT,
NewContainerName NVARCHAR(256)
	)
	CREATE	TABLE #vtMediaForAction (
			ID                  INT IDENTITY(1, 1),
			mediaId				INT,
			libraryId			INT,
			mediaLocation		INT,
			exportLocationId	INT,
			returnDate			BIGINT,
			lastBackupTime		INT,
			sidbStoreId			INT,
			actionFlag			INT,
			destLocationValue	INT,
			destLocationType	INT,
			destLibraryType		INT,
			actionId			INT,
			actionSourceId		INT,
			alertType			INT,
			vtContainerId		INT,
			vtMediaState		INT,
			vtMediaFlag			INT,
			vtMediaOperation	INT,
			vtMediaOpState		INT,
			mediaAtDest			INT,
			mediaNoAction		INT,
			--Added for user permission check
			mediaGroupId		INT,
			archGroupId			INT
	)
/****************************************************************************************/
/******************** Insert into temprary tables ***************************************/
/****************************************************************************************/
	--Get rules
	SET		@ruleId = ISNULL((SELECT RuleId FROM VTPolicyToRule WHERE PolicyId = @i_policyId), 0)
	IF		@ruleId = 0
	BEGIN
			SET @errorString = @errorString + 'the policy does not exist or no rule for this policy.'
			GOTO CX_ERROR_EXIT
	END
/****************************************************************************************/
/******************** Check if the policy is enabled*************************************/
/****************************************************************************************/
SELECT	@policyEnabled = (Flag & 1),
			@actionFlag = Flag,
			@actionDestId = DestinationId,
			@inTransitId = InTransitId,
			@containerId = ContainerId,
			@containerPatternNumber = ContainerPatternNumber,
			@containerPattern = ContainerPattern,
			@containerCapacity = ContainerCapacity
	FROM	VTPolicy
	WHERE	PolicyId = @i_policyId
	IF		@policyEnabled = 0
	BEGIN
			SET @errorString = @errorString + 'the policy is not enabled'
			GOTO CX_ERROR_EXIT
	END
	SET @currentDate = GETUTCDATE()
	SET @currentTime = dbo.GetUnixTime(@currentDate)
	IF	@containerId > 0
	BEGIN
		set @containerCapacity = (select Capacity from MMContainer where ContainerId = @containerId)
		-- Assign security of @i_policyId to @containerId, it is just an add-on with input flag = 1
		INSERT	INTO #securityRet
		EXEC	sec_vt_Policy2Container @i_policyId, @containerId, 1
		IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
		IF	EXISTS (SELECT * FROM #securityRet WHERE spRetCode > 0)
			GOTO CX_ERROR_EXIT
	END
	IF EXISTS (SELECT * from VTRuleToSchema a, VTRuleSchema b, VTPolicyToRule c
				WHERE	a.SchemaId = b.SchemaId
AND		b.type = 32
				AND		a.param <> -1
				AND		a.RuleId = c.ruleId
				AND		c.PolicyId = @i_policyId)
		SET @isDueBackPolicy = 1
	ELSE
		SET @isDueBackPolicy = 0
/****************************************************************************************/
/************************************ Run the rule **************************************/
/****************************************************************************************/
	IF @i_libraryId > 0
	BEGIN
SET @i_VTFlags = @i_VTFlags | 2048
	END
	INSERT	INTO #vtMediaIdList
	EXEC	RunTMRule @i_VTFlags, @i_policyId, @ruleId
	IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
	IF @i_libraryId > 0
	BEGIN
		INSERT	INTO #vtMediaForAction
		SELECT	MediaId, LibraryId, MediaLocation,
				ExportLocationId, retentionExpireTime, lastBackupTime, 0,
				0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		FROM	MMMedia WITH (NOLOCK)
		WHERE	MediaId IN (SELECT DISTINCT MediaId FROM #vtMediaIdList)
		AND		LibraryId = @i_libraryId
		ORDER BY LibraryId, LastBackupTime, LastRestoreTime
		DECLARE @limitcount INT = 0
		SELECT @limitcount = RTS.param
		FROM VTRuleSchema(NOLOCK) RS
		JOIN VTRuleToSchema(NOLOCK) RTS ON RTS.SchemaId = RS.SchemaId
WHERE RS.Type = 16
			AND RTS.RuleId = @ruleId
		IF @limitcount > 0
			DELETE FROM #vtMediaForAction
			WHERE ID > @limitcount
	END
	ELSE
		INSERT	INTO #vtMediaForAction
		SELECT	MediaId, LibraryId, MediaLocation,
				ExportLocationId, retentionExpireTime, lastBackupTime, 0,
				0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
		FROM	MMMedia WITH (NOLOCK)
		WHERE	MediaId IN (SELECT DISTINCT MediaId FROM #vtMediaIdList)
	--Permission check
if @i_userId > 0 and exists (select 1 from GXGlobalParam where name = 'nEnforceVaultTrackerPermissionCheck' and value = 'true' and modified = 0)
	begin
		--Library permission check
		if object_id('tempdb.dbo.#libraryPermissions') is not null drop table #libraryPermissions
		create table #libraryPermissions(libraryId int)
exec sec_getNonIdaObjectsForThisUser @i_userId, 9, 8, '#libraryPermissions'
		delete 		vtm
		from		#vtMediaForAction vtm
		left join	#libraryPermissions lp on lp.libraryId = vtm.libraryId
		where		lp.libraryId is null and vtm.libraryId <> 0
		-- Storage Policy permission check
		update vtm
		set mediaGroupId = (select top 1 mediaGroupId from MMVolume(nolock) v where v.MediaId = vtm.mediaId)
		from #vtMediaForAction vtm
		update vtm
		set archGroupId = ag.id
		from #vtMediaForAction vtm
		join archStream(nolock) ast on ast.mediaGroupId = vtm.mediaGroupId
		join archGroup(nolock) ag on ag.id = ast.archGroupId
		if object_id('tempdb.dbo.#spPolicyPermissions') is not null drop table #spPolicyPermissions
		create table #spPolicyPermissions(archGroupId int)
exec sec_getNonIdaObjectsForThisUser @i_userId, 17, 4, '#spPolicyPermissions'
		delete 		vtm
		from		#vtMediaForAction vtm
		left join	#spPolicyPermissions sp on sp.archGroupId = vtm.archGroupId
		where		sp.archGroupId is null and vtm.archGroupId <> 0
	end
/****************************************************************************************/
	-- Add non existing exportlocation and library into VTLocation table
	-- "Any library" destination: type = TM_LOCATION_TYPE_SLOT and value = 0
	-- Shelf location: type = TM_LOCATION_TYPE_SLOT and value = LibraryId and LibraryTypeId = CV_LIB_SHELF
	INSERT	INTO VTLocation
SELECT	1, LibraryId
	FROM	MMLibrary WITH (NOLOCK)
WHERE	LibraryTypeId != 3
AND		LibraryId NOT IN (SELECT Value FROM VTLocation WITH (NOLOCK) WHERE Type = 1)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT	INTO VTLocation
SELECT	2, ExportLocationId
	FROM	MMExportLocation WITH (NOLOCK)
WHERE	ExportLocationId NOT IN (SELECT Value FROM VTLocation WITH (NOLOCK) WHERE Type = 2)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT	INTO VTLocation
SELECT	4, LibraryId
	FROM	MMLibrary WITH (NOLOCK)
	WHERE	LibraryId > 0
AND		LibraryTypeId != 3
AND		LibraryTypeId != 8
	AND		StartVMSElementAddress != 0
AND		LibraryId NOT IN (SELECT Value FROM VTLocation WITH (NOLOCK) WHERE Type = 4)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	IF	@inTransitId = 0
	BEGIN
		SELECT	@inTransitId = LocationId
		FROM	VTLocation WITH (NOLOCK)
WHERE	Type = 2
AND		Value = 0
	END
	-- @destLocationValue = 0 if any library is selected
	SELECT	@destLocationType = Type, @destLocationValue = Value
	FROM	VTLocation WITH (NOLOCK)
	WHERE	LocationId = @actionDestId
IF	@destLocationType = 1 AND @destLocationValue > 0
	BEGIN
		SELECT	@destLibraryType = LibraryTypeId
		FROM	MMLibrary WITH (NOLOCK)
		WHERE	LibraryId = @destLocationValue
	END
	UPDATE	#vtMediaForAction
	SET		actionFlag = @actionFlag,
			destLocationValue = @destLocationValue,
			destLocationType = @destLocationType,
			destLibraryType = @destLibraryType
	DECLARE	@tblMediaSiloStore TABLE
			(MediaId int, SidbStoreId int)
IF @actionFlag & 32 > 0
	BEGIN
		INSERT	INTO @tblMediaSiloStore
		SELECT	E.MediaId, Max(A.SIDBStoreId)
		FROM	MMVolume A, ArchChunk B, ArchChunkMapping C,
				archfilesilovolume D, #vtMediaForAction E,
				MMVolume F
		WHERE	A.VolumeId = D.siloVolumeId
		AND B.Id = C.ArchChunkId
		AND B.CommCellId = C.chunkCommCellId
		AND C.ArchFileId = D.ArchFileId
		AND C.CommCellId = D.CommCellId
		AND B.VolumeId = F.VolumeId
		AND F.MediaId = E.MediaId
		GROUP BY E.MediaId
		UPDATE	#vtMediaForAction
		SET		SidbStoreId = B.SidbStoreId
		FROM	#vtMediaForAction A, @tblMediaSiloStore B
		WHERE	A.MediaId = B.MediaId
	END
	DECLARE @tblLibEmptySlot table (libraryId int, slotId int, mediaId int)
	DECLARE @checkEmptySlots INTEGER
	SET @checkEmptySlots = 0
	DECLARE @numEmptySlots INTEGER
	SET @numEmptySlots = 0
	DECLARE @numReservedSlots INTEGER
	SET @numReservedSlots = 0
	IF EXISTS (SELECT value FROM MMConfigs WHERE name = 'VT_CONFIG_CHECK_LIBRARY_EMPTY_SLOTS' AND Value <> 0)
AND	(@destLocationType = 1 AND @destLocationValue = 0
OR   @destLocationType = 1 AND @destLocationValue > 0
AND @destLibraryType NOT IN (8, 4, 5))
	BEGIN
		SET @checkEmptySlots = 1
		INSERT	INTO @tblLibEmptySlot
		SELECT	b.libraryId, a.SlotId, a.MediaId
		FROM	MMSlot a WITH (NOLOCK), MMLibrary b WITH (NOLOCK), MMBay c WITH (NOLOCK)
		WHERE	a.BayId = c.BayId
		AND		c.LibraryId = b.LibraryId
		AND		a.SlotType = 1
AND		b.libraryTypeId NOT IN (8, 4, 5)
		UPDATE	@tblLibEmptySlot
		SET		MediaId = 0
		FROM	@tblLibEmptySlot a, MMMedia b
		WHERE	a.MediaId = b.MediaId
		AND		(a.libraryId <> b.libraryId or b.MediaLocation <> 1)
		SELECT	@numEmptySlots = COUNT(*)
		FROM	@tblLibEmptySlot
		WHERE	MediaId = 0
		AND		(@destLocationValue = 0 OR LibraryId = @destLocationValue)
		SELECT	@numReservedSlots = COUNT(*)
		FROM	VTAction A WITH (NOLOCK), VTActionMedia B WITH (NOLOCK)
		WHERE	A.ActionId = B.ActionId
		AND		A.ActionType <> 2
		AND		A.DestinationId = @actionDestId
		AND		B.CurrentId <> @actionDestId
	END
/****************************************************************************************/
/****************** For every MediaId, based on policy, create actions ******************/
/****************************************************************************************/
	DECLARE VTActionForPolicyCur CURSOR FOR
			SELECT MediaId FROM #vtMediaForAction
			ORDER BY sidbStoreId ASC, lastBackupTime ASC
	OPEN	VTActionForPolicyCur
	set	@open_VTActionForPolicyCur = 1
	FETCH	NEXT FROM VTActionForPolicyCur INTO @mediaId
/****************************************************************************************/
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		EXEC	VTMediaCalculation @mediaId
		SELECT	@actionSourceId = actionSourceId,
				@vtMediaState = vtMediaState,
				@vtMediaFlag = vtMediaFlag,
				@vtMediaOperation = vtMediaOperation,
				@vtMediaOpState = vtMediaOpState,
				@mediaAtDest = mediaAtDest,
				@sidbStoreId = sidbStoreId,
				@alertType = alertType,
				@mediaNoAction = mediaNoAction
		FROM	#vtMediaForAction
		WHERE	mediaId = @mediaId
		IF	(	@mediaAtDest > 0
			OR	EXISTS (SELECT * FROM VTActionMedia WITH (NOLOCK) WHERE MediaId = @mediaId)
			-- OR	EXISTS (SELECT * FROM MMResource WITH (NOLOCK) WHERE MediaId = @mediaId)
			)
		BEGIN
			--	Do not process media when media is at destination
			--	Do not process media when media is in other action
			--	Do not process media when media is reserved
			SET	@mediaNoAction = 1
			GOTO UPDATE_MEDIA_FOR_ACTION
		END
		IF @checkEmptySlots > 0
		BEGIN
			-- There is not enough empty slots for media import
			IF @numEmptySlots <= @numReservedSlots
			BEGIN
				SET	@mediaNoAction = 1
				GOTO UPDATE_MEDIA_FOR_ACTION
			END
			SET @numReservedSlots = @numReservedSlots + 1
		END
		-- Do not create action and consume container when view media from policy
		IF @ViewPolicyMedia > 0
		BEGIN
			GOTO UPDATE_MEDIA_FOR_ACTION
		END
		SET	@actionId = ISNULL( (SELECT	ActionId FROM VTAction WITH (NOLOCK)
			WHERE	PolicyId = @i_policyId
			AND		StartTime = @currentDate AND SourceId = @actionSourceId ), 0)
		IF	@actionId = 0
		BEGIN
			INSERT INTO VTAction(PolicyId, JobId_h, JobId_l, JobType, UserId, Flag, InTransitId, SourceId, DestinationId, StartTime, ContainerId, ActionType, ActionState, ActionQuitTime, SpareGroupId, RecallExpireTime, RecallReason, ContainerPattern, ContainerCapacity, ActionStartTime)
values(@i_policyId, @i_jobId_h, @i_jobId_l, 1, @i_userId, @actionFlag, @inTransitId, @actionSourceId, @actionDestId, @currentDate, @containerId, 1, 1, 0, 0, 0, '', @containerPattern, @containerCapacity, @currentTime)
			SELECT	@retVal = @@ERROR, @actionId = @@IDENTITY
			IF		@retVal != 0 GOTO CX_ERROR_EXIT
			INSERT  INTO VTAlerts (AlertAction, Initiator, ActionId, MediaId, SourceId, InTransitId, DestinationId)
values(2050, @initiator, @actionId, 0, @actionSourceId, @inTransitId, @actionDestId)
			IF	@@ERROR	> 0 GOTO CX_ERROR_EXIT
		END
		IF	@alertType > 0
		BEGIN
			INSERT  INTO VTAlerts (AlertAction, Initiator, ActionId, MediaId, SourceId, InTransitId, DestinationId)
			values(@alertType, @initiator, @actionId, @mediaId, @actionSourceId, @inTransitId, @actionDestId)
			IF	@@ERROR	> 0 GOTO CX_ERROR_EXIT
		END
		----------------------------------------------------------------------------------
		-- Get container for media
		SET	@findContainer = 0
		IF	@containerId > 0
		BEGIN
			IF	@sidbStoreId > 0
			BEGIN
				SET @errorString = @errorString + 'Must use container pattern for SILO tapes. '
				GOTO CX_ERROR_EXIT;
			END
			IF	@vtContainerId = 0
			BEGIN
				SET	@vtContainerId = @containerId
				SET @vtContainerCapacity = @containerCapacity
				SET @numMediaInContainer = (select count(*) from MMMedia where ContainerId = @containerId)
			END
			SET	@numMediaToContainer = @numMediaToContainer + 1
			IF	@numMediaToContainer + @numMediaInContainer > @vtContainerCapacity
			BEGIN
				SET @vtContainerId = 0
				SET @findContainer = 1
				SET @numMediaToContainer = 0
				SET @numMediaInContainer = 0
			END
		END
		ELSE
		IF	@containerPattern <> ''
		BEGIN
			IF	@vtContainerId = 0
			BEGIN
				SET @findContainer = 1
				SET @numMediaToContainer = 0
				SET @numMediaInContainer = 0
			END
			ELSE
			BEGIN
				-- A container is found for previous media processed
				SET	@numMediaToContainer = @numMediaToContainer + 1
				IF	@numMediaToContainer + @numMediaInContainer > @vtContainerCapacity
					OR	( @sidbStoreId > 0 AND @sidbStoreId <> @preSidbStoreId )
				BEGIN
					SET @vtContainerId = 0
					SET @findContainer = 1
					SET @numMediaToContainer = 0
					SET @numMediaInContainer = 0
					SET	@preSidbStoreId = @sidbStoreId
				END
			END
		END
		-- Create new container for media
		IF	@findContainer > 0
		BEGIN
			DELETE	FROM #vtContainer
			INSERT	INTO #vtContainer
			EXEC	VTCreateNewContainer @i_policyId, @containerPattern, @containerPatternNumber, @containerCapacity, @containerId, @destLocationType, @destLocationValue, @sidbStoreId
			SET		@vtContainerId = (SELECT containerId FROM #vtContainer)
			SET		@vtContainerCapacity = (select Capacity from MMContainer where ContainerId = @vtContainerId)
			SET		@numMediaInContainer = (SELECT count(*) FROM MMMedia with (nolock) WHERE ContainerId = @vtContainerId)
			SET		@numMediaToContainer = @numMediaToContainer + 1
			IF		@vtContainerId = -2
			BEGIN
				SET @errorString = @errorString + 'All containers defined in the name pattern are either full or offsite.'
				GOTO CX_ERROR_EXIT
			END
			ELSE
			IF		@vtContainerId <= 0
			BEGIN
				SET @errorString = @errorString + 'failed to create new container ['
									+ (SELECT newContainerName FROM #vtContainer) + ']'
				GOTO CX_ERROR_EXIT
			END
			-- exec sec_setCreatorForContainer @i_userId, @vtContainerId
			SET	@findContainer = 0
			IF	@containerPatternNumber <> (SELECT containerPatternNumber FROM #vtContainer)
			BEGIN
				UPDATE	VTPolicy
				SET		containerPatternNumber = (SELECT containerPatternNumber FROM #vtContainer)
				WHERE	PolicyId = @i_policyId
			END
			IF	@containerId > 0
			BEGIN
				-- Assign security of @containerId to @vtContainerId, it is complete overwrite with input flag = 2
				DELETE	FROM #securityRet
				INSERT	INTO #securityRet
				EXEC	sec_vt_Container2Container @containerId, @vtContainerId, 2
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
				IF	EXISTS (SELECT * FROM #securityRet WHERE spRetCode > 0)
					GOTO CX_ERROR_EXIT
			END
			ELSE
			BEGIN
				-- Assign security of @i_policyId to @vtContainerId, it is complete overwrite with input flag = 2
				DELETE	FROM #securityRet
				INSERT	INTO #securityRet
				EXEC	sec_vt_Policy2Container @i_policyId, @vtContainerId, 2
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
				IF	EXISTS (SELECT * FROM #securityRet WHERE spRetCode > 0)
					GOTO CX_ERROR_EXIT
			END
		END
		-- We can set the container always if it is specified
		-- regardless if whether it is an Export, Import or Recall action
		-- Since the user is allowed to specify a container at the policy level.
		IF(@vtContainerId > 0)
		BEGIN
			UPDATE	MMMedia
			SET		ContainerId = @vtContainerId
			FROM	MMMedia
			WHERE	MediaId = @MediaId
		END
		IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
		-- Set the exportable attribute only if the media is actually inside the library
		UPDATE	MMMedia
SET		Attributes = Attributes | 1
		FROM	MMMedia
		WHERE	MediaId = @MediaId AND MediaLocation <> 3
		IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
		----------------------------------------------------------------------------------
UPDATE_MEDIA_FOR_ACTION:
		UPDATE	#vtMediaForAction
		SET		actionId = @actionId,
				actionSourceId = @actionSourceId,
				vtContainerId = @vtContainerId,
				vtMediaState = @vtMediaState,
				vtMediaFlag = @vtMediaFlag,
				vtMediaOperation = @vtMediaOperation,
				vtMediaOpState = @vtMediaOpState,
				mediaAtDest = @mediaAtDest,
				mediaNoAction = @mediaNoAction
		WHERE	mediaId = @mediaId
		FETCH	NEXT FROM VTActionForPolicyCur INTO @mediaId
	END
/****************************************************************************************/
/******************* create media action for each media *********************************/
/****************************************************************************************/
	DELETE	FROM #vtMediaForAction
	WHERE	MediaNoAction > 0
	--When the dueback date is in the past and the media is not pruned yet,
	--we still need to show it Due Back as NOW, so change the value to 0
	UPDATE	#vtMediaForAction
	SET		ReturnDate = 0
	WHERE	ReturnDate < dbo.getUnixTime(getUTCDate())
	AND		ReturnDate <> -1
	-- Do not create action media when view media from policy
	IF @ViewPolicyMedia > 0
	BEGIN
			IF object_id('tempdb.dbo.#tmpViewMediaFromPolicy') IS NULL
			BEGIN
				SET @errorString = '#tmpViewMediaFromPolicy does not exist.'
				GOTO CX_ERROR_EXIT
			END
			INSERT INTO #tmpViewMediaFromPolicy
			SELECT mediaId, returnDate
			FROM #vtMediaForAction
			GOTO CX_EXIT
	END
	INSERT	INTO VTActionMedia
	SELECT	actionId, mediaId, vtMediaState, vtMediaFlag,
			vtMediaOperation, vtMediaOpState, actionSourceId, @currentDate, 0, returnDate
	FROM	#vtMediaForAction
	SELECT	@retVal = @@ERROR, @numMedia = @@ROWCOUNT
	IF		@retVal != 0 GOTO CX_ERROR_EXIT
	UPDATE	VTActionMedia
SET		Flag = 128
	WHERE	ActionId IN (SELECT DISTINCT ActionId FROM #vtMediaForAction)
	AND		@isDueBackPolicy = 1
AND		@actionFlag & 16 > 0
	IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
	SET @numActions = ISNULL((SELECT COUNT(DISTINCT ActionId) FROM #vtMediaForAction), 0)
	IF	@@ERROR	> 0 GOTO CX_ERROR_EXIT
/****************************************************************************************/
/**************** Drop temparary table **************************************************/
/****************************************************************************************/
CX_EXIT:
	IF object_id('tempdb.dbo.#securityRet') is not null DROP TABLE #securityRet
	IF object_id('tempdb.dbo.#vtContainer') is not null DROP TABLE #vtContainer
	IF object_id('tempdb.dbo.#vtMediaIdList') is not null DROP TABLE #vtMediaIdList
	IF object_id('tempdb.dbo.#vtMediaForAction') is not null DROP TABLE #vtMediaForAction
/****************************************************************************************/
/****************************************************************************************/
--  +----------------------------+
--  |	NORMAL, "HAPPY" EXIT:    |
--  +----------------------------+
	IF @open_VTActionForPolicyCur = 1
	BEGIN
			CLOSE		VTActionForPolicyCur
			DEALLOCATE	VTActionForPolicyCur
	END
	IF @open_ContainerCur = 1
	BEGIN
			CLOSE		ContainerCur
			DEALLOCATE	ContainerCur
	END
	IF @ViewPolicyMedia = 0
		COMMIT TRANSACTION VTPOLICYTRAN
	ELSE RETURN 0
	SELECT	0, 'Actions created successfully!', @numActions, @numMedia
	RETURN
--  +----------------------------+
--  |   ABNORMAL, "ERROR" EXIT:  |
--  +----------------------------+
CX_ERROR_EXIT:
	IF object_id('tempdb.dbo.#securityRet') is not null DROP TABLE #securityRet
	IF object_id('tempdb.dbo.#vtContainer') is not null DROP TABLE #vtContainer
	IF object_id('tempdb.dbo.#vtMediaIdList') is not null DROP TABLE #vtMediaIdList
	IF object_id('tempdb.dbo.#vtMediaForAction') is not null DROP TABLE #vtMediaForAction
	IF @open_VTActionForPolicyCur = 1
	BEGIN
			CLOSE		VTActionForPolicyCur
			DEALLOCATE	VTActionForPolicyCur
	END
	IF @open_ContainerCur = 1
	BEGIN
			CLOSE		ContainerCur
			DEALLOCATE	ContainerCur
	END
	IF @ViewPolicyMedia = 0
		ROLLBACK TRANSACTION VTPOLICYTRAN
	ELSE RETURN -1
	SELECT	-1, @errorString, @numActions, @numMedia
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'VTCreateActionForPolicy')
	delete from GxQscripts where name = 'VTCreateActionForPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTCreateActionForPolicy')
	delete from GXDBVersions where aliasname = 'VTCreateActionForPolicy'
GO

insert into GXDBVersions values(2, 'VTCreateActionForPolicy',  '00010038008600110000', 'VTCreateActionForPolicy', '00010038008600110000')
GO

