

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VTCreateActionForMedia.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VTCreateActionForMedia.sp,v $ $Id: VTCreateActionForMedia.sp,v 1.31.208.3 2018/03/20 19:42:50 jiechen Exp $";
--  +========================================================================+
--  | Stored Precedure: VTCreateActionForMedia()
--	| Description:  Replace RunTMForMedia.
--	|				It creates vault tracker actions from media level
--	|				or from backup or restore level.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VTCreateActionForMedia <<<'

IF EXISTS (select * from sysobjects where name='VTCreateActionForMedia')
	drop procedure VTCreateActionForMedia
IF EXISTS (select * from GxQscripts where name='VTCreateActionForMedia')
	delete from GxQscripts where name = 'VTCreateActionForMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTCreateActionForMedia')
	delete from GXDBVersions where aliasname = 'VTCreateActionForMedia'
GO
print '... Creating Procedure: VTCreateActionForMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure VTCreateActionForMedia
  @i_jobId_h INTEGER,
  @i_jobId_l INTEGER,
  @i_jobType INTEGER,
  @i_userId INTEGER,
  @i_mediaIdList VARCHAR(MAX),
  @i_inTransitExportLocationId INTEGER,
  @i_destExportlocationId INTEGER,
  @i_destLibraryId INTEGER,
  @i_isVirtualMailslotsSelected INTEGER,
  @i_isExtendedRuleSelected INTEGER,
  @i_containerId INTEGER,
  @i_containerPattern NVARCHAR(256),
  @i_containerCapacity INTEGER,
  @i_autoAck INTEGER,
  @i_actionType INTEGER,
  @i_spareGroupId INTEGER,
  @i_recallExpireTime INTEGER,
  @i_recallReason NVARCHAR(256)
AS
  DECLARE @retVal INTEGER;
  DECLARE @errorString VARCHAR(1024);
  DECLARE @numActions INTEGER;
  DECLARE @numMedia INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRANSACTION VTMEDCMD
	SET	@retVal = 0
	SET @errorString = 'WARNING: '
	SET	@numActions = 0
	SET	@numMedia = 0
/****************************************************************************************/
/************ Initialize and DECLARE temparary variables ********************************/
/****************************************************************************************/
	DECLARE	@actionId			INTEGER
	DECLARE	@actionSourceId		INTEGER
	DECLARE	@actionDestId		INTEGER
	DECLARE	@actionCurrentId	INTEGER
	DECLARE	@actionFlag			INTEGER
	DECLARE	@inTransitId		INTEGER
	DECLARE @containerId		INTEGER
	DECLARE @containerPattern		NVARCHAR(MAX)
	DECLARE @containerCapacity		INTEGER
	DECLARE @vtContainerCapacity	INTEGER
	DECLARE @createNewContainer		INTEGER
	DECLARE @numMediaInContainer	INTEGER
	DECLARE @numMediaToContainer	INTEGER
	DECLARE	@vtContainerId		INTEGER
	DECLARE	@vtMediaState		INTEGER
	DECLARE	@vtMediaFlag		INTEGER
	DECLARE @vtMediaOperation	INTEGER
	DECLARE @vtMediaOpState		INTEGER
	DECLARE	@mediaId			INTEGER
	DECLARE	@libraryId			INTEGER
	DECLARE	@mediaLocation		INTEGER
	DECLARE	@exportLocationId	INTEGER
	DECLARE @mediaAtDest		INTEGER
	DECLARE @mediaNoAction		INTEGER
	DECLARE @alertType			INTEGER
	DECLARE	@initiator			NVARCHAR(255)
	DECLARE	@destLibraryType		INTEGER
	DECLARE	@destLocationType		INTEGER
	DECLARE	@destLocationValue		INTEGER
	DECLARE @userName			VARCHAR(255)
	DECLARE @currentDate		datetime
	DECLARE @currentTime		INTEGER
	DECLARE	@slotId				INTEGER
	DECLARE	@vmsSlotId			INTEGER
	DECLARE	@vmsDirection		INTEGER
	DECLARE	@availableSlots		INTEGER
	DECLARE	@startVMS			INTEGER
	DECLARE @bayId				INTEGER
	if	@i_jobId_l > 0
		SET @initiator = 'Job: ' + CONVERT(VARCHAR(10), @i_jobId_l)
	else
		SET @initiator = 'User: ' + (SELECT top 1 login FROM UMUsers WHERE Id = @i_userId)
	SET @actionDestId = 0
	SET	@destLibraryType = 0
	SET	@destLocationType = 0
	SET	@destLocationValue = 0
	SET @inTransitId = 0
	SET	@vtContainerId = 0
	SET	@vtContainerCapacity = 0
	DECLARE @curor_open INTEGER
	set @curor_open = 0
/****************************************************************************************/
/********************** Create temparary tables *****************************************/
/****************************************************************************************/
	IF object_id('tempdb.dbo.#securityRet') is not null DROP TABLE #securityRet
	IF object_id('tempdb.dbo.#vtContainer') is not null DROP TABLE #vtContainer
	IF object_id('tempdb.dbo.#vtMediaIdList') is not null DROP TABLE #vtMediaIdList
	IF object_id('tempdb.dbo.#vtMediaForAction') is not null DROP TABLE #vtMediaForAction
	CREATE TABLE #vtMediaIdList (
			MediaId INT
	)
	CREATE TABLE #securityRet (
			spRetCode INT,
			retString	varchar(1024)
	)
	CREATE TABLE #vtContainer (
			ContainerId INT,
			ContainerPatternNumber INT,
NewContainerName NVARCHAR(256)
	)
	CREATE	TABLE #vtMediaForAction (
			mediaId				INT,
			libraryId			INT,
			mediaLocation		INT,
			exportLocationId	INT,
			returnDate			BIGINT,
			actionFlag			INT,
			destLocationValue	INT,
			destLocationType	INT,
			destLibraryType		INT,
			actionId			INT,
			actionSourceId		INT,
			actionCurrentId		INT,
			alertType			INT,
			vtContainerId		INT,
			vtMediaState		INT,
			vtMediaFlag			INT,
			vtMediaOperation	INT,
			vtMediaOpState		INT,
			mediaAtDest			INT,
			mediaNoAction		INT
	)
	SET	@numMediaToContainer = 0
	SET	@containerId = @i_containerId
	SET	@containerPattern = @i_containerPattern
	SET	@containerCapacity = @i_containerCapacity
	SET @currentDate = GETUTCDATE()
	SET @currentTime = dbo.GetUnixTime(@currentDate)
	IF	@containerId > 0
	BEGIN
		set @containerCapacity = (select Capacity from MMContainer where ContainerId = @containerId)
	END
/****************************************************************************************/
/******************** Insert into temprary tables ***************************************/
/****************************************************************************************/
	-- call stored procedure getMediaListByJobCopy for given job and copy, get media
	INSERT	INTO #vtMediaIdList
	EXEC	('SELECT distinct MediaId FROM MMMedia WHERE MediaId IN (' + @i_mediaIdList + ')')
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	IF @i_isExtendedRuleSelected != 0
	BEGIN
			DECLARE @tblVolList table (volumeId int, mediaId int)
			DECLARE @tblChunkList table (archChunkId bigint, commCellId int, mediaId int)
			DECLARE @tblArchFileCopyList table (archfileId int, commCellId int, copyId int, mediaId int)
			DECLARE @tblJobCopyList table (jobId int, copyId int, fileType int, commCellId int, mediaId int)
			insert into @tblVolList
			select a.VolumeId, a.MediaId
			from MMVolume a, #vtMediaIdList b
			where a.mediaId = b.mediaId
			insert into @tblChunkList
			select a.id, a.commCellId, b.mediaId
			from archChunk a, @tblVolList b
			where a.volumeId = b.volumeId
			insert into @tblArchFileCopyList
			select distinct a.archFileId, a.commCellId, a.archCopyId, b.mediaId
			from archChunkMapping a, @tblChunkList b
			where a.archChunkId = b.archChunkId
			and a.chunkCommCellId = b.commCellId
			insert into @tblJobCopyList
			select distinct a.jobId, b.copyId, a.fileType, a.commCellId, b.mediaId
			from archFile a, @tblArchFileCopyList b
			where a.id = b.archFileId
			and a.commCellId = b.commCellId
			delete from #vtMediaIdList
			where mediaId NOT in (
				select distinct b.mediaId
				from JMJobDataStats a, @tblJobCopyList b
				where a.jobId = b.jobId
				and a.archGrpCopyId = b.copyId
				and a.dataType = b.filetype
				and a.commCellId = b.commCellId
				and a.disabled & 256 = 0
				and a.status <> 1000
				and a.retentionFlags > 0
			)
	END
/****************************************************************************************/
/************************************ Run the rule **************************************/
/****************************************************************************************/
	INSERT	INTO #vtMediaForAction
	SELECT	MediaId, LibraryId, MediaLocation,
			ExportLocationId, retentionExpireTime,
			0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
	FROM	MMMedia
	WHERE	MediaId IN (SELECT DISTINCT MediaId FROM #vtMediaIdList)
/****************************************************************************************/
	-- Add non existing exportlocation and library into VTLocation table
	-- "Any library" destination: type = TM_LOCATION_TYPE_SLOT and value = 0
	-- Shelf location: type = TM_LOCATION_TYPE_SLOT and value = LibraryId and LibraryTypeId = CV_LIB_SHELF
	INSERT	INTO VTLocation
SELECT	1, LibraryId
	FROM	MMLibrary
WHERE	LibraryTypeId != 3
AND		LibraryId NOT IN (SELECT Value FROM VTLocation WHERE Type = 1)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT	INTO VTLocation
SELECT	2, ExportLocationId
	FROM	MMExportLocation
WHERE	ExportLocationId NOT IN (SELECT Value FROM VTLocation WHERE Type = 2)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
	INSERT	INTO VTLocation
SELECT	4, LibraryId
	FROM	MMLibrary
	WHERE	LibraryId > 0
AND		LibraryTypeId != 3
AND		LibraryTypeId != 8
	AND		StartVMSElementAddress != 0
AND		LibraryId NOT IN (SELECT Value FROM VTLocation WHERE Type = 4)
	IF @@ERROR > 0 GOTO CX_ERROR_EXIT
/****************************************************************************************/
SET @actionFlag = 1
	SELECT	@inTransitId = LocationId
	FROM	VTLocation
WHERE	Type = 2
	AND		Value = @i_inTransitExportLocationId
	IF @i_destExportlocationId > 0
	BEGIN
		-- Destination is an export location
		SELECT	@actionDestId = LocationId
		FROM	VTLocation
WHERE	Type = 2
		AND		Value = @i_destExportlocationId
	END
	ELSE IF @i_destLibraryId > 0
	BEGIN
		-- Destination is a shelf or library
		SELECT	@actionDestId = LocationId
		FROM	VTLocation
WHERE	Type = 1
		AND		Value = @i_destLibraryId
	END
	ELSE IF @i_destLibraryId = 0
	BEGIN
		-- Destination is any library
		SELECT	@actionDestId = LocationId
		FROM	VTLocation
WHERE	Type = 1
		AND		Value = 0
	END
	ELSE
	BEGIN
		SET @errorString = @errorString + 'No destination defined for action!'
		GOTO CX_ERROR_EXIT
	END
	IF @i_isVirtualMailslotsSelected != 0
	BEGIN
SET @actionFlag = @actionFlag | 4
	END
	-- 8.0: Ignore @i_autoAck
	-- Assume auto acknowledgement set for all actions not started by vt policy
SET @actionFlag = @actionFlag | 16
	-- @destLocationValue = 0 if any library is selected
	SELECT	@destLocationType = Type, @destLocationValue = Value
	FROM	VTLocation
	WHERE	LocationId = @actionDestId
IF	@destLocationType = 1 AND @destLocationValue > 0
	BEGIN
		SELECT	@destLibraryType = LibraryTypeId
		FROM	MMLibrary
		WHERE	LibraryId = @destLocationValue
	END
	SELECT	@currentDate = GETUTCDATE()
	UPDATE	#vtMediaForAction
	SET		actionFlag = @actionFlag,
			destLocationValue = @destLocationValue,
			destLocationType = @destLocationType,
			destLibraryType = @destLibraryType
/****************************************************************************************/
/****************** For every MediaId, create actions ***********************************/
/****************************************************************************************/
	DECLARE VTActionForMediaCur CURSOR FOR SELECT MediaId FROM #vtMediaForAction
	OPEN	VTActionForMediaCur
	set @curor_open = 1
	FETCH	NEXT FROM VTActionForMediaCur INTO @mediaId
/****************************************************************************************/
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		EXEC	VTMediaCalculation @mediaId
		SELECT	@actionSourceId = actionSourceId,
				@actionCurrentId = actionSourceId,
				@vtMediaState = vtMediaState,
				@vtMediaFlag = vtMediaFlag,
				@vtMediaOperation = vtMediaOperation,
				@vtMediaOpState = vtMediaOpState,
				@mediaAtDest = mediaAtDest,
				@alertType = alertType,
				@mediaNoAction = mediaNoAction
		FROM	#vtMediaForAction
		WHERE	mediaId = @mediaId
IF	@i_actionType = 2
		BEGIN
			IF	@mediaAtDest > 0
				SET	@actionCurrentId = @actionDestId
			-- Abort media from other existing non-recall action.
			UPDATE	VTActionMedia
SET		Flag = 64, TimeStamp = @CurrentDate
			FROM	VTActionMedia a, VTAction b
			WHERE	a.ActionId = b.ActionId AND a.MediaId = @mediaId
AND		b.ActionType <> 2
			DECLARE @tblActionList table (ActionId int, InTransitId int,
					DestinationId int, ContainerId int, SpareGroupId int)
			INSERT	INTO @tblActionList
			SELECT	a.ActionId, a.InTransitId, a.DestinationId, a.ContainerId, a.SpareGroupId
			FROM	VTAction a, VTActionMedia b
			WHERE	a.ActionId = b.ActionId AND b.MediaId = @mediaId
AND		a.ActionType = 2
			-- Fail recall request
			--  if media exists in other recall action with different action properties selected
			IF	EXISTS (SELECT * FROM @tblActionList
						WHERE InTransitId <> @InTransitId OR DestinationId <> @actionDestId
						OR	ContainerId <> @i_containerId OR SpareGroupId <> @i_spareGroupId)
			BEGIN
				SET @errorString = @errorString + 'Media exists in recall action with different properties. Please redo the recall with the same properties as existing recall action'
				GOTO CX_ERROR_EXIT
			END
		END
		ELSE
		IF	(	@mediaAtDest > 0
			OR	EXISTS (SELECT * FROM VTActionMedia WHERE MediaId = @mediaId)
			-- OR	EXISTS (SELECT * FROM MMResource WHERE MediaId = @mediaId)
			)
		BEGIN
			-- Non-recall action request
			--	Do not process media when media is at destination
			--	Do not process media when media is in other action
			--	Do not process media when media is reserved
			SET	@mediaNoAction = 1
		END
		SET	@actionId = ISNULL( (SELECT	ActionId FROM VTAction
			WHERE	jobId_h = @i_jobId_h AND jobId_l = @i_jobId_l
			AND		StartTime = @currentDate AND SourceId = @actionSourceId ), 0)
		IF	@actionId = 0
		BEGIN
			INSERT INTO VTAction(PolicyId, JobId_h, JobId_l, JobType, UserId, Flag, InTransitId, SourceId, DestinationId, StartTime, ContainerId, ActionType, ActionState, ActionQuitTime, SpareGroupId, RecallExpireTime, RecallReason, ContainerPattern, ContainerCapacity, ActionStartTime)
values(0, @i_jobId_h, @i_jobId_l, @i_jobType, @i_userId, @actionFlag, @inTransitId, @actionSourceId, @actionDestId, @currentDate, @containerId, @i_actionType, 1, 0, @i_spareGroupId, @i_recallExpireTime, @i_recallReason, @containerPattern, @containerCapacity, @currentTime)
			SELECT	@retVal = @@ERROR, @actionId = @@IDENTITY
			IF		@retVal != 0 GOTO CX_ERROR_EXIT
			INSERT  INTO VTAlerts (AlertAction, Initiator, ActionId, MediaId, SourceId, InTransitId, DestinationId)
values(2050, @initiator, @actionId, 0, @actionSourceId, @inTransitId, @actionDestId)
			IF	@@ERROR	> 0 GOTO CX_ERROR_EXIT
		END
		----------------------------------------------------------------------------------
		-- Get container for media
		SET	@createNewContainer = 0
		IF	@mediaNoAction = 0 AND @containerId > 0
		BEGIN
			IF	@vtContainerId = 0
			BEGIN
				SET	@vtContainerId = @containerId
				SET @vtContainerCapacity = @containerCapacity
				SET @numMediaInContainer = (select count(*) from MMMedia where ContainerId = @containerId)
			END
			SET	@numMediaToContainer = @numMediaToContainer + 1
			IF	@numMediaToContainer + @numMediaInContainer > @vtContainerCapacity
			BEGIN
				SET @vtContainerId = 0
				SET @createNewContainer = 1
				SET @numMediaToContainer = 0
				SET @numMediaInContainer = 0
			END
		END
		IF	@mediaNoAction = 0 AND @containerId = 0 AND @containerPattern <> ''
		BEGIN
			IF	@vtContainerId = 0
			BEGIN
				SET @createNewContainer = 1
				SET @numMediaToContainer = 0
				SET @numMediaInContainer = 0
			END
			ELSE
			BEGIN
				-- No input container, but container has been created for media in action
				SET	@numMediaToContainer = @numMediaToContainer + 1
				IF	@numMediaToContainer + @numMediaInContainer > @vtContainerCapacity
				BEGIN
					SET @vtContainerId = 0
					SET @createNewContainer = 1
					SET @numMediaToContainer = 0
					SET @numMediaInContainer = 0
				END
			END
		END
		-- Create new container for media
		IF	@createNewContainer > 0
		BEGIN
			DELETE	FROM #vtContainer
			INSERT	INTO #vtContainer
			EXEC	VTCreateNewContainer 0, @containerPattern, 0, @containerCapacity, @containerId, @destLocationType, @destLocationValue
			SET		@vtContainerId = (SELECT containerId FROM #vtContainer)
			SET		@vtContainerCapacity = (select Capacity from MMContainer where ContainerId = @vtContainerId)
			SET		@numMediaInContainer = (SELECT count(*) FROM MMMedia with (nolock) WHERE ContainerId = @vtContainerId)
			SET		@numMediaToContainer = @numMediaToContainer + 1
			IF		@vtContainerId <= 0
			BEGIN
				SET @errorString = @errorString + 'failed to create new container ['
									+ (SELECT newContainerName FROM #vtContainer) + ']'
				GOTO CX_ERROR_EXIT
			END
			SET	@createNewContainer = 0
			IF	@containerId > 0
			BEGIN
				-- Assign security of @containerId to @vtContainerId, it is complete overwrite with input flag = 2
				DELETE	FROM #securityRet
				INSERT	INTO #securityRet
				EXEC	sec_vt_Container2Container @containerId, @vtContainerId, 2
				IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
				IF	EXISTS (SELECT * FROM #securityRet WHERE spRetCode > 0)
					GOTO CX_ERROR_EXIT
			END
		END
		-- We can set the container always if it is specified
		-- regardless if whether it is an Export, Import or Recall action
		-- Since the user is allowed to specify a container at the policy level.
		IF	@vtContainerId > 0
		BEGIN
			UPDATE	MMMedia
			SET		ContainerId = @vtContainerId
			FROM	MMMedia
			WHERE	MediaId = @MediaId
		END
		IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
		-- Set the exportable attribute only if the media is actually inside the library
		UPDATE	MMMedia
SET		Attributes = Attributes | 1
		FROM	MMMedia
		WHERE	MediaId = @MediaId
		AND		MediaLocation <> 3
		IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
		UPDATE	MMMedia
SET		Attributes = Attributes | 536870912 | 1
		FROM	MMMedia
		WHERE	MediaId = @MediaId
AND		@i_actionType = 2
		IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
		----------------------------------------------------------------------------------
		UPDATE	#vtMediaForAction
		SET		actionId = @actionId,
				actionSourceId = @actionSourceId,
				actionCurrentId = @actionCurrentId,
				vtContainerId = @vtContainerId,
				vtMediaState = @vtMediaState,
				vtMediaFlag = @vtMediaFlag,
				vtMediaOperation = @vtMediaOperation,
				vtMediaOpState = @vtMediaOpState,
				mediaAtDest = @mediaAtDest,
				mediaNoAction = @mediaNoAction
		WHERE	mediaId = @mediaId
		IF	@alertType > 0 AND @MediaNoAction = 0
		BEGIN
			INSERT  INTO VTAlerts (AlertAction, Initiator, ActionId, MediaId, SourceId, InTransitId, DestinationId)
			values(@alertType, @initiator, @actionId, @mediaId, @actionSourceId, @inTransitId, @actionDestId)
			IF	@@ERROR	> 0 GOTO CX_ERROR_EXIT
		END
		FETCH	NEXT FROM VTActionForMediaCur INTO @mediaId
	END
/****************************************************************************************/
/******************* create media action for each media *********************************/
/****************************************************************************************/
	DELETE	FROM #vtMediaForAction
	WHERE	MediaNoAction > 0
	--When the dueback date is in the past and the media is not pruned yet,
	--we still need to show it Due Back as NOW, so change the value to 0
	UPDATE	#vtMediaForAction
	SET		ReturnDate = 0
	WHERE	ReturnDate < dbo.getUnixTime(getUTCDate())
	AND		ReturnDate <> -1
	INSERT	INTO VTActionMedia
	SELECT	actionId, mediaId, vtMediaState, vtMediaFlag,
			vtMediaOperation, vtMediaOpState, actionCurrentId, @currentDate, 0, returnDate
	FROM	#vtMediaForAction
	SELECT	@retVal = @@ERROR, @numMedia = @@ROWCOUNT
	IF		@retVal != 0 GOTO CX_ERROR_EXIT
	SET @numActions = ISNULL((SELECT COUNT(DISTINCT ActionId) FROM #vtMediaForAction), 0)
	-- Remove empty action
	DELETE	FROM VTAction
	WHERE	ActionId NOT IN (SELECT ActionId FROM VTActionMedia)
	IF	@@ERROR	> 0 GOTO CX_ERROR_EXIT
	-- Reach destination for media
	DECLARE @tblActionCmdReturn table (retVal int, mediaProcessed int, mediaSkipped int, errString VARCHAR(1024))
	DECLARE	VTReachDestCur CURSOR FOR
			SELECT DISTINCT actionId, mediaId FROM #vtMediaForAction
			WHERE actionCurrentId = @actionDestId
	OPEN VTReachDestCur
	FETCH NEXT FROM VTReachDestCur INTO @actionId, @mediaId
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		INSERT INTO @tblActionCmdReturn
EXEC VTRunActionCmd 16, @actionId, @mediaId, 0
		IF	@@ERROR <> 0 GOTO CX_ERROR_EXIT
		FETCH NEXT FROM VTReachDestCur INTO @actionId, @mediaId
	END
	CLOSE VTReachDestCur
	DEALLOCATE VTReachDestCur
/****************************************************************************************/
/****************************************************************************************/
--  +----------------------------+
--  |	NORMAL, "HAPPY" EXIT:    |
--  +----------------------------+
	IF object_id('tempdb.dbo.#securityRet') is not null DROP TABLE #securityRet
	IF object_id('tempdb.dbo.#vtContainer') is not null DROP TABLE #vtContainer
	IF object_id('tempdb.dbo.#vtMediaIdList') is not null DROP TABLE #vtMediaIdList
	IF object_id('tempdb.dbo.#vtMediaForAction') is not null DROP TABLE #vtMediaForAction
	IF @curor_open = 1
	BEGIN
			CLOSE		VTActionForMediaCur
			DEALLOCATE	VTActionForMediaCur
	END
	COMMIT TRANSACTION VTMEDCMD
	SELECT	0, 'Actions created successfully!', @numActions, @numMedia
	RETURN
--  +----------------------------+
--  |   ABNORMAL, "ERROR" EXIT:  |
--  +----------------------------+
CX_ERROR_EXIT:
	IF object_id('tempdb.dbo.#securityRet') is not null DROP TABLE #securityRet
	IF object_id('tempdb.dbo.#vtContainer') is not null DROP TABLE #vtContainer
	IF object_id('tempdb.dbo.#vtMediaIdList') is not null DROP TABLE #vtMediaIdList
	IF object_id('tempdb.dbo.#vtMediaForAction') is not null DROP TABLE #vtMediaForAction
	IF @curor_open = 1
	BEGIN
			CLOSE		VTActionForMediaCur
			DEALLOCATE	VTActionForMediaCur
	END
	ROLLBACK TRANSACTION VTMEDCMD
	SELECT	-1, @errorString, @numActions, @numMedia
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'VTCreateActionForMedia')
	delete from GxQscripts where name = 'VTCreateActionForMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTCreateActionForMedia')
	delete from GXDBVersions where aliasname = 'VTCreateActionForMedia'
GO

insert into GXDBVersions values(2, 'VTCreateActionForMedia',  '00010031020800030000', 'VTCreateActionForMedia', '00010031020800030000')
GO

