

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VTCheckPolicyLicenseUsed.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VTCheckPolicyLicenseUsed.sp,v $ $Id: VTCheckPolicyLicenseUsed.sp,v 1.1.302.2 2018/03/20 19:48:43 jiechen Exp $";
--  +========================================================================+
--  | Stored Precedure: VTCheckPolicyLicenseUsed
--  | Description:  Check if there is any feature of police uses
--	|				enterprise license.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VTCheckPolicyLicenseUsed <<<'

IF EXISTS (select * from sysobjects where name='VTCheckPolicyLicenseUsed')
	drop procedure VTCheckPolicyLicenseUsed
IF EXISTS (select * from GxQscripts where name='VTCheckPolicyLicenseUsed')
	delete from GxQscripts where name = 'VTCheckPolicyLicenseUsed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTCheckPolicyLicenseUsed')
	delete from GXDBVersions where aliasname = 'VTCheckPolicyLicenseUsed'
GO
print '... Creating Procedure: VTCheckPolicyLicenseUsed'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure VTCheckPolicyLicenseUsed
  @i_policyId INTEGER
AS
  DECLARE @enterpriseLicenseUsed INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	SET	@enterpriseLicenseUsed = 0
	DECLARE	@RuleId integer
	DECLARE @isDueBackPolicy integer
	DECLARE @filterByRetention integer
	DECLARE @sourceLocation integer
	DECLARE	@DestinationId integer
	DECLARE	@InTransitId integer
	DECLARE	@ContainerId integer
	DECLARE	@ContainerPattern varchar(1024)
	DECLARE	@ContainerPatternNumber integer
	DECLARE	@ContainerCapacity integer
	DECLARE	@DelayTimeInMinutes integer
	DECLARE	@QuitTimeInMinutes integer
	DECLARE @destLocationType integer
	DECLARE @destLocationValue integer
	DECLARE @transitLocationType integer
	DECLARE @transitLocationValue integer
	SELECT	@RuleId = RuleId
	FROM	VTPolicyToRule
	WHERE	PolicyId = @i_policyId
	SELECT	@isDueBackPolicy = Param
	FROM	VTRuleToSchema a, VTRuleSchema b
	WHERE	a.SchemaId = b.SchemaId
AND		b.type = 32
	AND		a.RuleId = @RuleId
	IF	@isDueBackPolicy IS NOT NULL
		GOTO ENTERPRISE_LICENSE_USED
	SELECT	@filterByRetention = Param
	FROM	VTRuleToSchema a, VTRuleSchema b
	WHERE	a.SchemaId = b.SchemaId
AND		b.type = 128
	AND		a.RuleId = @RuleId
	IF	@filterByRetention IS NOT NULL
		GOTO ENTERPRISE_LICENSE_USED
	-- Source location other than library is not supported without enterprise license.
	SELECT	@sourceLocation = Param
	FROM	VTRuleToSchema a, VTRuleSchema b
	WHERE	a.SchemaId = b.SchemaId
AND		b.type = 2
AND		a.flag & (2 | 4) > 0
	AND		a.RuleId = @RuleId
	IF	@sourceLocation IS NOT NULL
		GOTO ENTERPRISE_LICENSE_USED
	SELECT	@DestinationId = DestinationId,
			@InTransitId = InTransitId,
			@ContainerId = ContainerId,
			@ContainerPattern = ContainerPattern,
			@ContainerPatternNumber = ContainerPatternNumber,
			@ContainerCapacity = ContainerCapacity,
			@DelayTimeInMinutes = DelayTimeInMinutes,
			@QuitTimeInMinutes = QuitTimeInMinutes
	FROM	VTPolicy
	WHERE	PolicyId = @i_policyId
	IF	@ContainerId <> 0
			OR	@ContainerPattern <> ''
			OR	@ContainerPatternNumber <> 0
			OR	@ContainerCapacity <> 0
			OR	@DelayTimeInMinutes <> 0
			OR	@QuitTimeInMinutes <> 0
		GOTO ENTERPRISE_LICENSE_USED
	SELECT	@destLocationType = type, @destLocationValue = value
	FROM	VTLocation
	WHERE	locationid = @DestinationId
	SELECT	@transitLocationType = type, @transitLocationValue = value
	FROM	VTLocation
	WHERE	locationid = @InTransitId
IF	@destLocationType <> 2
		GOTO ENTERPRISE_LICENSE_USED
	IF	@InTransitId <> 0 AND @transitLocationValue <> 0
		GOTO ENTERPRISE_LICENSE_USED
CX_EXIT:
	SELECT 0
	RETURN
ENTERPRISE_LICENSE_USED:
	SELECT 1
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'VTCheckPolicyLicenseUsed')
	delete from GxQscripts where name = 'VTCheckPolicyLicenseUsed'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VTCheckPolicyLicenseUsed')
	delete from GXDBVersions where aliasname = 'VTCheckPolicyLicenseUsed'
GO

insert into GXDBVersions values(2, 'VTCheckPolicyLicenseUsed',  '00010001030200020000', 'VTCheckPolicyLicenseUsed', '00010001030200020000')
GO

