

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMProtectionCoverageProc.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMProtectionCoverageProc.sp,v $ $Id: VMProtectionCoverageProc.sp,v 1.2.32.29.8.1 2021/03/20 05:41:15 junlu Exp $";
--  +========================================================================+
--  | Stored Proc:  VMProtectionCoverageProc()
--  |
--  | Description:  VM protection status in last N days
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='VMProtectionCoverageProc')
BEGIN
	print '>>> Drop Stored Procedure: VMProtectionCoverageProc <<<'
	drop procedure VMProtectionCoverageProc
END
IF EXISTS (select * from GxQscripts where name='VMProtectionCoverageProc')
	delete from GxQscripts where name = 'VMProtectionCoverageProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMProtectionCoverageProc')
	delete from GXDBVersions where aliasname = 'VMProtectionCoverageProc'
GO
print '... Creating Procedure: VMProtectionCoverageProc'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure VMProtectionCoverageProc
  @nLastDays INTEGER,
  @BackupType NVARCHAR(32),
  @nUserId INTEGER = 0,
  @showClientComputerGroup INTEGER = 0
AS
 -----------------------------------------------------------------------------------
 -- InPut Param: @nLastDays >0, -1, or -3 @BackupType=Full,Synth,Incr
 -- IF @nLastDays = -1 or -3 THEN NEEDS TO COUNT ALL CURRENTLY PROTECTED VMS.
 -- USED FOR LICENSING...
 -----------------------------------------------------------------------------------
DECLARE	@Today		DATETIME = DATEDIFF(DAY, 0, GETDATE())
DECLARE	@StartTime	INT = 0
if @nLastDays >=0
 	SET	@StartTime = dbo.GetUnixTime(DATEADD(DAY, -@nLastDays, @Today))
DECLARE @bIsArchiveLicValid INT = 0
DECLARE @bIsDRVMLicValid INT = 0
DECLARE @bIsSocketLicValid INT = 0
DECLARE @licAppliedStatus INT = 0
DECLARE @isLicInherited INT = 0
EXEC LicAppliedStatus @licAppliedStatus OUTPUT, @isLicInherited OUTPUT
IF @isLicInherited > 0
BEGIN
SELECT @bIsArchiveLicValid = @licAppliedStatus&0x4
SELECT @bIsDRVMLicValid = @licAppliedStatus&0x20000
SELECT @bIsSocketLicValid = @licAppliedStatus&0x1
END
ELSE
BEGIN
	EXEC LicIsLicenseValid 100021, @bIsArchiveLicValid OUTPUT
	EXEC LicIsLicenseValid 100040, @bIsDRVMLicValid OUTPUT
	EXEC LicIsLicenseValid 100018, @bIsSocketLicValid OUTPUT
END
IF OBJECT_ID('tempdb..#VMInfo') IS NOT NULL
drop table #VMInfo
CREATE TABLE  #VMInfo (
	clientId			INT,
 	VMName				nvarchar(1024),
 	VMGuid				nvarchar(255),
	status				INT  --0 Discovered, 1 manually excluded
)
CREATE CLUSTERED INDEX tempclientId_idx ON #VMInfo (clientId)
DECLARE @tblBackupLevel TABLE (BackupLevel INT)
IF @BackupType = 'Full'
BEGIN
    INSERT INTO @tblBackupLevel VALUES (1),(1024),(32768)
END
ELSE IF @BackupType LIKE '%Synth%'
BEGIN
    INSERT INTO @tblBackupLevel VALUES (64),(16384)
END
ELSE IF @BackupType LIKE '%Incr%'
BEGIN
    INSERT INTO @tblBackupLevel VALUES (2),(4),(256)
END
ELSE IF @BackupType = '0' -- It is full or synth full job
BEGIN
	INSERT INTO @tblBackupLevel VALUES (1),(1024),(32768),(64),(128),(16384)
END
ELSE
    SET @BackupType = ''
DECLARE @gracePeriodDays INT = 30
SELECT	@gracePeriodDays = CAST(value AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'VirtualMachineDeletionGracePeriod' AND modified = 0
DECLARE	@beforeTime INT = dbo.GetUnixTime(DATEADD(DAY, -@gracePeriodDays,  GETUTCDATE()))
INSERT INTO #VMInfo  (clientId, VMName, VMGuid,status)
SELECT	DISTINCT C.id, C.name, '', 0
FROM	APP_Client C WITH (NOLOCK)
		INNER JOIN (
			SELECT	DISTINCT Q.clientId
			FROM	JMQinetixUpdateStatus Q WITH (NOLOCK)
					INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.jobId = Q.jobId AND B.commCellId = Q.commCellId
							 AND B.opType IN (4, 14, 18, 30, 43, 59, 65, 76, 87, 91, 94, 97, 98, 101)
							 AND B.bkpLevel IN (1, 2, 4, 256, 1024, 32768)
			) VM ON C.id = VM.clientId
		INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON C.id = CP.componentNameId
		AND	CP.attrName = 'Virtual Server Discovered Clients' AND CP.attrVal = '1' AND CP.modified =0
		LEFT OUTER JOIN (
		SELECT	DISTINCT componentNameId
		FROM	APP_ClientProp WITH (NOLOCK)
		WHERE	attrName = 'Virtual Machine Deletion Time' AND attrVal <> '0' AND modified = 0
		) T ON C.id = T.componentNameId
WHERE	T.componentNameId IS NULL
IF @nUserId > 1 AND object_id('tempdb.dbo.#LicCalUserObj') IS NOT NULL --SECURITY
BEGIN
	delete #VMInfo
	where clientId not in (select clientId from #LicCalUserObj where clientId > 0)
END
UPDATE #VMInfo
SET VMGuid = CP.attrVal FROM APP_ClientProp CP WITH (NOLOCK) INNER JOIN #VMInfo vmInfo ON
vmInfo.clientId = CP.componentNameId
AND CP.attrName='Virtual Machine GUID'
AND CP.modified = 0
IF OBJECT_ID('tempdb..#VMJobInfo') IS NOT NULL
drop table #VMJobInfo
CREATE TABLE #VMJobInfo (
	commcellid					INT,
	clientId					INT,
	appId						INT,
	BackupStatus			    INT, -- 0 - Backed Up, 1 -  Did Not Backup, 2 - manually exlcuded
	LastSuccessfulBackupJobId	BIGINT,
	LastBackupJobId				BIGINT,
	LastBackupType				INT,
	LastBackupTime				BIGINT,
	VMBackupStartTime			BIGINT,
	VMBackupEndTime				BIGINT,
	TotalTimeForLastBackup		BIGINT,
	BackupSetName				nvarchar(1024),
	InstanceName				nvarchar(1024),
	SubClientName				nvarchar(1024),
	VMSize						BIGINT,
	VMDataWrittenSize			BIGINT,
	VMBackedupSize				BIGINT,
	DataStatus					INT,
	IsVMArchived				INT,
	IsVMReplicationed			INT
)
CREATE CLUSTERED INDEX tempclientId_LastBackupJobId_idx ON #VMJobInfo (clientId,LastBackupJobId)
IF object_id('tempdb.dbo.#tempVMHosts') IS NOT null DROP TABLE #tempVMHosts
CREATE TABLE #tempVMHosts(t_host VARCHAR(256), t_sockets INT, t_clientid INT)
IF @nLastDays < 0
BEGIN
	IF object_id('tempdb.dbo.#tempSubClient') IS NOT null DROP TABLE #tempSubClient
	CREATE TABLE #tempSubClient(
	jobId				INT,
	appid				INT,
	commCellId			INT,
	appTypeId			INT,
	parentAppid			INT
	)
	CREATE CLUSTERED INDEX tempappid_jobId_commCellId_idx ON #tempSubClient (appid,jobId,commCellId)
	CREATE INDEX tempappId_parentAppid_idx ON #tempSubClient (appId,parentAppid)
	INSERT INTO #tempSubClient
	SELECT MAX(jobid), appid, commCellId, 106, 0 from JMBkpStats WITH (NOLOCK)
	WHERE appType = 106 AND  (@BackupType = '' OR bkpLevel IN (SELECT BackupLevel FROM @tblBackupLevel))
	AND status in (1, 3, 14, 16) AND dataStatus = 0
	GROUP BY appId , commCellId
	UPDATE S
	SET parentAppid = L.parentAppid
	FROM #tempSubClient S
	INNER JOIN JMJobDataLink L WITH (NOLOCK) ON S.appId = L.childAppid AND S.jobId = L.childJobId AND L.linkType = 7
	-- Remove Deleted and deconfigured subclients
	DELETE #tempSubClient
	FROM #tempSubClient J
	inner join APP_Application A with (nolock)
	on (A.subclientStatus &( 2|4)) > 0
        AND (A.id = J.appId OR A.id = J.parentAppid)
	-- Remove activity disabled subclients from the resultset
	DELETE #tempSubClient
	FROM #tempSubClient v
	INNER JOIN JMJobAction J WITH (NOLOCK)
    	ON J.opType = 4 AND J.action =1
	AND (J.appId = v.appId OR J.appId = v.parentAppid)
	-- Remove deconfigured agents
	DELETE #tempSubClient
	FROM #tempSubClient J
	INNER JOIN APP_Application A WITH(NOLOCK) ON A.id = J.appId OR A.id = J.parentAppid
	INNER JOIN APP_iDAName B WITH(NOLOCK) ON B.clientId = A.clientId AND B.appTypeId = 106 AND (B.Status & 6) > 0
	-- Remove VM which is partically deconfigured
	DELETE #tempSubClient
	FROM #tempSubClient J
	INNER JOIN APP_Application A WITH(NOLOCK) ON A.id = J.appId
	INNER JOIN APP_ClientProp P WITH (NOLOCK) ON A.clientId = P.componentNameId AND P.attrName = 'Marked For Deconfigure' AND ISNULL(P.attrVal, '0') <> '0' AND P.modified = 0
	INSERT	INTO #VMJobInfo
	SELECT	V.commCellId,
			V.VMclientId,
			0,
			1,
			MAX(B.jobId),
			MAX(B.jobId),
			0,
			0,
			0,
			0,
			0,
			NULL,
			NULL,
			NULL,
			0,
			0,
			0,
			0,
			0,
			0
	FROM #tempSubClient B
			INNER JOIN APP_VMProp V WITH (NOLOCK) ON
			B.jobId = V.ClientJobId AND
			B.commCellId = V.commCellId AND
			V.attrName = 'vmStatus' AND
			V.attrVal IN ('0', '3')
			INNER JOIN APP_Client C WITH (NOLOCK) ON C.id = V.VMclientId
	GROUP BY V.VMclientId, V.commCellId
	DELETE VJ
	FROM #VMJobInfo VJ
	INNER JOIN  APP_ClientProp WITH (NOLOCK)
	ON attrName = 'Virtual Machine Deletion Time' AND ISNULL(attrVal, '0') <> '0' AND modified = 0
	AND componentNameId = VJ.clientId
	UPDATE #VMJobInfo SET appId = A.appId
	FROM #VMJobInfo B INNER JOIN #tempSubClient A ON A.jobId = B.LastBackupJobId
	--Remove parent job
	DELETE #VMJobInfo
	FROM JMJobDataLink L WITH (NOLOCK)
	WHERE appId = L.parentAppid AND LastSuccessfulBackupJobId = L.parentJobId AND L.linkType = 7
	DROP TABLE #tempSubClient
END
ELSE
BEGIN
	IF object_id('tempdb.dbo.#tempjoblist') IS NOT null DROP TABLE #tempjoblist
	CREATE TABLE #tempjoblist(clientid int, jobid int, commcellid int, appid int, status int, status1 int)
	INSERT INTO  #tempjoblist
	SELECT Q.clientId,B.jobId,B.commCellId,B.appid, B.status,Q.status
	FROM JMBkpStats B WITH (NOLOCK)
	LEFT JOIN JMQinetixUpdateStatus Q WITH (NOLOCK) ON B.jobId = Q.jobId and B.commCellId = Q.commCellId
	WHERE B.appType = 106 AND (@BackupType = '' OR B.bkpLevel IN (SELECT BackupLevel FROM @tblBackupLevel))
	DELETE T
	FROM #tempjoblist T
	INNER JOIN JMJobDataLink L WITH (NOLOCK) ON T.jobid = L.parentJobId and L.linkType = 7
	UPDATE T
	SET T.clientid = appl.clientId, T.appid = appl.id
	FROM  #tempjoblist T
	INNER JOIN JMJobDataLink L WITH (NOLOCK) ON T.jobid =  L.childJobId and L.linkType=7
	INNER JOIN APP_Application appl WITH (NOLOCK) ON appl.id = L.childAppid
	WHERE T.clientid is NULL
	DELETE #tempjoblist
	WHERE clientid is NULL
	INSERT	INTO #VMJobInfo
	SELECT	T.commCellId,
			T.clientId,
			MAX(T.appId),
			1,
			MAX(CASE  WHEN T.status in ( 1,3,14,16)  THEN(
						CASE	WHEN V.attrVal IS NOT NULL AND V.attrVal IN ('0', '3')
							THEN T.jobid
						WHEN V.attrVal IS NULL AND T.status1 IN (1,3)
							THEN T.jobId
						ELSE 0
						END)
				END),
			MAX(T.jobId),
			0,
			0,
			0,
			0,
			0,
			NULL,
			NULL,
			NULL,
			0,
			0,
			0,
			0,
			0,
			0
	FROM #tempjoblist T
	LEFT OUTER JOIN APP_VMProp V WITH (NOLOCK) ON
		T.jobId = V.ClientJobId AND
		T.commCellId = V.commCellId AND
			T.clientId = V.VMclientId AND
		V.attrName = 'vmStatus'
	GROUP BY
		T.clientId, T.commCellId
	DROP TABLE #tempjoblist
END
--@nLastDays is passed -2 or -3 by License code. Remove data comming from commcell which id is greater than 2.
If @nLastDays = -2 or @nLastDays = -3
DELETE FROM #VMJobInfo WHERE commCellId > 2
IF @nUserId > 1 AND object_id('tempdb.dbo.#LicCalUserObj') IS NOT NULL --SECURITY
	delete #VMJobInfo
	where clientId not in (select clientId from #LicCalUserObj where clientId > 0)
UPDATE #VMJobInfo
SET IsVMArchived = (CASE WHEN CAST(V.attrVal AS INT) = 5 THEN 1 ELSE 0 END)
FROM APP_VMProp V WITH (NOLOCK) INNER JOIN #VMJobInfo vm ON
	V.ClientJobId = vm.LastBackupJobId AND V.commCellId = vm.commcellid
	AND V.VMclientId = vm.clientId
WHERE LEN(V.attrVal) > 0 AND V.attrName ='vmStubStatus'
IF @bIsDRVMLicValid > 0 OR @bIsSocketLicValid = 0
BEGIN
	UPDATE J
	SET IsVMReplicationed = 1
	FROM #VMJobInfo J
	INNER JOIN (
				SELECT JMB.jobId,APP.clientId FROM JMBkpStats JMB WITH(NOLOCK)
				INNER JOIN APP_Application APP WITH(NOLOCK) ON APP.id = JMB.appId
				INNER JOIN archGroupCopy AG WITH(NOLOCK) ON AG.archGroupId = JMB.dataArchGrpId
				INNER JOIN archAgingRule AGR WITH(NOLOCK) ON AG.id = AGR.copyId
				INNER JOIN APP_ClientProp CP WITH(NOLOCK) ON CP.componentNameId = APP.clientId AND CP.attrname ='Virtual Machine Instance UUID' AND CP.modified = 0
				INNER JOIN APP_VSAReplication R WITH(NOLOCK) ON R.sourceGuid = CP.attrVal AND ISNULL(R.status,0) <> 6
				INNER JOIN TM_Task T WITH (NOLOCK) ON R.taskId = T.taskId AND ISNULL(T.disabled,0) <> 1
				GROUP BY JMB.jobId,APP.clientId
HAVING max(AGR.retentionDays)<=14
			  ) S ON S.jobId = J.LastSuccessfulBackupJobId AND S.clientId = J.clientId
END
--@nLastDays is passed -2 by LicCalusage. If it exists, We can calculate socket
-- If archive VM license is present i.e. @bIsArchiveLicValid is > 0 then don't count the VM where IsVMArchived is true under socket
IF @nLastDays = -2
BEGIN
	INSERT INTO #tempVMHosts
	SELECT  ISNULL([vmHost], ''), ISNULL([vmNumHostCPUSockets], 0), VmClientId
	FROM
	(SELECT  VmClientId, attrName, attrVal
	FROM    APP_VMProp V WITH(NOLOCK) INNER JOIN #VMJobInfo vm ON
	V.ClientJobId = vm.LastBackupJobId  AND V.commCellId = vm.commcellid
	AND V.VMclientId = vm.clientId
	WHERE LEN(V.attrVal) > 0 AND ( @bIsArchiveLicValid = 0 OR vm.IsVMArchived = 0) AND vm.IsVMReplicationed = 0 AND attrName in ('vmHost','vmNumHostCPUSockets')) AS VMs
	PIVOT   ( MAX(attrVal) FOR attrName IN (  [vmHost], [vmNumHostCPUSockets]) ) AS P
END
IF object_id('tempdb.dbo.#VMPropAttrName')  IS NOT null DROP TABLE #VMPropAttrName
CREATE TABLE #VMPropAttrName (t_vmId INT, t_jobId INT, t_vmSize BIGINT, t_vmUsedSpace BIGINT, t_vmBackupStartTime BIGINT, t_vmBackupEndTime BIGINT)
INSERT INTO #VMPropAttrName
SELECT  VmClientId, jobId, ISNULL([vmSize], 0), ISNULL([vmUsedSpace], 0), ISNULL([vmBackupStartTime],0), ISNULL([vmBackupEndTime],0)
FROM
(SELECT  ClientJobId AS jobid, VmClientId, attrName, attrVal
FROM    APP_VMProp V WITH(NOLOCK) INNER JOIN #VMJobInfo vm ON
V.ClientJobId = vm.LastSuccessfulBackupJobId  AND V.commCellId = vm.commcellid
AND V.VMclientId = vm.clientId WHERE V.ClientJobId > 0 AND LEN(V.attrVal) > 0 AND V.attrName in ('vmSize','vmUsedSpace','vmBackupStartTime','vmBackupEndTime')) AS VMs
PIVOT   ( MAX(attrVal) FOR attrName IN (  [vmSize], [vmUsedSpace], [vmBackupStartTime], [vmBackupEndTime]) ) AS P
UPDATE #VMJobInfo
SET VMSize = t_vmSize, VMBackedupSize = t_vmUsedSpace,
VMBackupStartTime = t_vmBackupStartTime, VMBackupEndTime = t_vmBackupEndTime
FROM #VMPropAttrName
WHERE clientId = t_vmId AND LastSuccessfulBackupJobId = t_jobId
IF object_id('tempdb.dbo.#VMPropAttrName')  IS NOT null DROP TABLE #VMPropAttrName
IF object_id('tempdb.dbo.#VMTotalSize')  IS NOT null DROP TABLE #VMTotalSize
CREATE TABLE #VMTotalSize (
	vmJobId				INT,
	TotalVMBackupSize	BIGINT,
	DataWritten			BIGINT)
CREATE CLUSTERED INDEX tempVmJobId_idx ON #VMTotalSize (vmJobId)
IF @nLastDays >= 0
BEGIN
	INSERT INTO #VMTotalSize
	SELECT LastSuccessfulBackupJobId, SUM(VMBackedupSize),0 FROM #VMJobInfo where LastSuccessfulBackupJobId > 0 group by LastSuccessfulBackupJobId
	UPDATE  #VMTotalSize
	SET     DataWritten = ISNULL(
				(SELECT TOP 1 T.sizeOnMedia
					FROM    (SELECT S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
						FROM    JMJobDataStats S WITH (READUNCOMMITTED)
							WHERE   2 = S.commcellId and vmJobId =S.jobid and S.AuxCopyJobId = 0
							GROUP BY S.archGrpCopyId) AS T),0)
END
UPDATE	#VMJobInfo
SET		appId = B.appId,
		LastBackupType = B.bkpLevel,
		--TotalTimeForLastBackup = (B.servEndDate - B.servStartDate),
			LastBackupTime = B.servEndDate,
			DataStatus = B.DataStatus
	FROM	#VMJobInfo V INNER JOIN
			JMBkpStats B WITH (NOLOCK) ON
			B.jobId =  V.LastSuccessfulBackupJobId
			AND B.commCellId = V.commcellid
			AND B.status in (1,3,14,16)
IF @nLastDays < 0
	DELETE FROM #VMJobInfo WHERE DataStatus >0
UPDATE #VMJobInfo
SET		appId = B.appId
FROM #VMJobInfo V INNER JOIN
	JMBkpStats B WITH (NOLOCK) ON
	v.LastSuccessfulBackupJobId = 0
	AND B.jobId = v.LastBackupJobId
UPDATE	#VMJobInfo
SET		SubClientName = A.subclientName,
		BackupSetName = BS.name,
		InstanceName = I.name
FROM	#VMJobInfo vmJobInfo
		INNER JOIN APP_Application A WITH (NOLOCK) ON
			vmJobInfo.appId = A.id
			INNER JOIN APP_BackupSetName BS WITH (NOLOCK) ON
			BS.id = A.backupSet
		INNER JOIN APP_InstanceName I ON
			I.id = A.instance
if @nLastDays >=0
	UPDATE #VMJobInfo
	SET BackupStatus = ( SELECT CASE WHEN LastBackupTime < @StartTime THEN 1
									ELSE 0
									END )
else
	UPDATE #VMJobInfo SET BackupStatus = 0 where LastBackupTime >0
UPDATE #VMInfo SET status = 1
FROM #VMInfo vmInfo
	INNER JOIN APP_SubClientProp SCP WITH (NOLOCK)
		ON	vmInfo.VMName = SUBSTRING(SCP.attrVal, 0, CHARINDEX(' ',SCP.attrVal))
		AND	SCP.attrType = 121 AND SCP.modified = 0
	INNER JOIN APP_Application app WITH (NOLOCK)
		ON app.id = SCP.componentNameId
	AND	app.subclientName = 'Do Not Backup' AND app.appTypeId = 106
IF @nLastDays >= 0
BEGIN
	UPDATE #VMJobInfo
	SET VMDataWrittenSize = cast(VMBackedupSize*(cast(vmTotalSize.DataWritten as real)/vmTotalSize.TotalVMBackupSize) as bigint)
	FROM #VMTotalSize vmTotalSize INNER JOIN #VMJobInfo
	ON vmTotalSize.vmJobId = LastSuccessfulBackupJobId
	AND vmTotalSize.TotalVMBackupSize > 0
	AND LastSuccessfulBackupJobId >0
END
DROP TABLE #VMTotalSize
DECLARE @CommCellId INT
DECLARE @aliasName varchar(256)
SELECT @CommCellId = number, @aliasName=aliasName from APP_CommCell WITH (NOLOCK) where clientId =2
--@nLastDays is passed -2 by LicCalusage. If it exists, We can calculate socket
if @nLastDays = -2
BEGIN
	INSERT INTO #tmpSocketDetails
	SELECT t_host AS VMName, t_sockets as SocketCount, t_clientId FROM #tempVMHosts WHERE LEN(t_host) > 0 AND t_sockets > 0
END
DROP TABLE #tempVMHosts
IF @showClientComputerGroup = 0
BEGIN
SELECT  VMName,
        (CASE WHEN BackupStatus IS NULL
            THEN ( CASE vmInfo.status  WHEN 0 THEN 'Discovered, Not protected'
                    ELSE 'Manually Excluded'
                    END
            )
            ELSE ( CASE BackupStatus
                    WHEN 0 THEN 'Currently protected'
                    WHEN 1 THEN 'Not protected in the time range'
                    END
            )
            END ) as BackupStatus,
        InstanceName,
        BackupSetName,
        SubClientName,
        CAST(VMSize/1024.0/1024.0/1024.0 as decimal(10,2)) as VMSizeGB,
        CAST(VMBackedupSize/1024.0/1024/1024 as decimal(10,2)) as VMBackedupSizeGB,
        CAST(VMDataWrittenSize/1024.0/1024/1024 as decimal(10,2) ) as EstimatedVMDataWrittenSizeGB,
        LastSuccessfulBackupJobId,
        dbo.GetDateTime(LastBackupTime) as LastBackupTime,
        CASE LastBackupType
            WHEN 1 THEN 'Full'
            WHEN 2 THEN 'Incremental'
            WHEN 4 THEN 'Differential'
            WHEN 64 THEN 'SyntheticFull'
            ELSE null
            END as LastBackupType,
        --TotalTimeForLastBackup,
        VMBackupEndTime - VMBackupStartTime as TotalTimeForLastBackup,
        vmInfo.clientId,
        @CommCellId as CommCellId,
        @aliasName  as CommCellName,
		IsVMArchived
FROM    #VMInfo vmInfo
LEFT OUTER JOIN #VMJobInfo vmJobInfo
ON vmInfo.clientId = vmJobInfo.clientId
ORDER BY VMName
END
ELSE
BEGIN
IF object_id('tempdb.dbo.#ClientGroupsString')  IS NOT null DROP TABLE #ClientGroupsString
CREATE TABLE #ClientGroupsString (clientId INT, clientGroups NVARCHAR(MAX))
exec GetClientGroupsString 0
SELECT  VMName,
        (CASE WHEN BackupStatus IS NULL
            THEN ( CASE vmInfo.status  WHEN 0 THEN 'Discovered, Not protected'
                    ELSE 'Manually Excluded'
                    END
            )
            ELSE ( CASE BackupStatus
                    WHEN 0 THEN 'Currently protected'
                    WHEN 1 THEN 'Not protected in the time range'
                    END
            )
            END ) as BackupStatus,
        InstanceName,
        BackupSetName,
        SubClientName,
        CAST(VMSize/1024.0/1024.0/1024.0 as decimal(10,2)) as VMSizeGB,
        CAST(VMBackedupSize/1024.0/1024/1024 as decimal(10,2)) as VMBackedupSizeGB,
        CAST(VMDataWrittenSize/1024.0/1024/1024 as decimal(10,2) ) as EstimatedVMDataWrittenSizeGB,
        LastSuccessfulBackupJobId,
        dbo.GetDateTime(LastBackupTime) as LastBackupTime,
        CASE LastBackupType
            WHEN 1 THEN 'Full'
            WHEN 2 THEN 'Incremental'
            WHEN 4 THEN 'Differential'
            WHEN 64 THEN 'SyntheticFull'
            ELSE null
            END as LastBackupType,
        --TotalTimeForLastBackup,
        VMBackupEndTime - VMBackupStartTime as TotalTimeForLastBackup,
        vmInfo.clientId,
        @CommCellId as CommCellId,
        @aliasName  as CommCellName,
		IsVMArchived,
		CG.ClientGroups AS ClientComputerGroup
FROM    #VMInfo vmInfo
LEFT OUTER JOIN #VMJobInfo vmJobInfo
ON vmInfo.clientId = vmJobInfo.clientId
LEFT OUTER JOIN #ClientGroupsString CG ON CG.ClientId = vmInfo.clientId
ORDER BY VMName
DROP TABLE #ClientGroupsString
END
DROP TABLE #VMJobInfo
DROP TABLE #VMInfo
GO

IF EXISTS (select * from GxQscripts where name = 'VMProtectionCoverageProc')
	delete from GxQscripts where name = 'VMProtectionCoverageProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMProtectionCoverageProc')
	delete from GXDBVersions where aliasname = 'VMProtectionCoverageProc'
GO

insert into GXDBVersions values(2, 'VMProtectionCoverageProc',  'v1.2.32.29.8.1', 'VMProtectionCoverageProc', 'v1.2.32.29.8.1')
GO

