

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_ValidateVMJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Ashish Gupta
--	Date:   04/29/2011
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_ValidateVMJob.sp,v $ $Id: VMP_ValidateVMJob.sp,v 1.17.12.31 2020/04/22 16:21:07 pktr Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='VMP_ValidateVMJob')
BEGIN
	print '>>> Drop Stored Procedure: VMP_ValidateVMJob <<<'
	drop procedure VMP_ValidateVMJob
END
IF EXISTS (select * from GxQscripts where name='VMP_ValidateVMJob')
	delete from GxQscripts where name = 'VMP_ValidateVMJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_ValidateVMJob')
	delete from GXDBVersions where aliasname = 'VMP_ValidateVMJob'
GO
print '... Creating Procedure: VMP_ValidateVMJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_ValidateVMJob
  @i_userId INT=0,
  @i_localId INT=0,
  @i_xml XML
AS
  DECLARE @o_ErrorCode integer = 0;
  DECLARE @o_ErrorString NVARCHAR(255);
DECLARE @vmAllocPolicyId INT = 0
DECLARE @vmAllocPolicyName NVARCHAR(MAX) = ''
DECLARE @i_vmName	NVARCHAR(MAX) = N''
DECLARE @vmOperationType INT = 0
DECLARE @vmTargetType INT = 0
SELECT @vmOperationType = ref.value('@operationType','INT') FROM @i_xml.nodes('/TMMsg_VMProvisioningOption') R(ref);
DECLARE @virtualizationClientId INT = 0
DECLARE @virtualizationClientName NVARCHAR(1024) = ''
DECLARE @hostName NVARCHAR(1024) = ''
DECLARE @canSkipValidationChecks INT = 0
DECLARE @validationSubclientId int = 0
DECLARE @validationClientId int = 0
-------------Constansts---------
declare @OPTYPE_CREATE_VM int = 0
declare @OPTYPE_CLONE_VM int = 6
declare @OPTYPE_SNAPSHOT_VM int = 3
declare @OPTYPE_EDIT_VM int = 11
declare @OPTYPE_LIVE_MOUNT int = 23
declare @OPTYPE_AUTO_PROXY_MANAGEMENT int = 49
---------------------------------
IF @vmOperationType = @OPTYPE_LIVE_MOUNT
BEGIN
	SELECT  @virtualizationClientId = isnull(ref.value('vmLocation[1]/virtualizationClient[1]/@clientId', 'INT'),0),
			@virtualizationClientName = isnull(ref.value('vmLocation[1]/virtualizationClient[1]/@clientName','NVARCHAR(MAX)'),''),
			@hostName = isnull(ref.value('vmLocation[1]/@hostName','NVARCHAR(MAX)'),''),
			@vmTargetType = isnull(ref.value('../@vmTargetType','INT'),0)
	FROM	@i_xml.nodes ('(/TMMsg_VMProvisioningOption/virtualMachineOption/vmInfo)[1]') R(ref)
	SELECT @validationSubclientId = isnull(ref.value('@subclientId', 'INT'), 0),
			@validationClientId = isnull(ref.value('@clientId', 'INT'), 0)
	FROM @i_xml.nodes('/TMMsg_VMProvisioningOption/validationEntity') R(ref)
	IF @validationClientId > 0
	BEGIN
set @validationSubclientId = ( select top 1 attrval from app_clientprop where attrName = 'VSA Discover Subclient ID' and componentNameId = @validationClientId and modified = 0 order by id desc)
	END
	IF @vmTargetType = 1 AND (@hostName != '' AND (@virtualizationClientName != '' OR @virtualizationClientId > 0))
		SET @canSkipValidationChecks = 1
END
IF @vmOperationType in (@OPTYPE_CREATE_VM, @OPTYPE_CLONE_VM, @OPTYPE_EDIT_VM, @OPTYPE_LIVE_MOUNT)
BEGIN
	DECLARE @vmAllocPolicy XML
	DECLARE @vmAllocPolType INT = 0
	DECLARE @isUserAdmin	INT = 0
	DECLARE @maxVMQuota		INT = 0,
			@maxDiscs INT = 0,
			@maxDiskSpace BIGINT = 0,
			@maxMemory INT = 0,
			@maxCpuCores INT = 0,
			@maxNICs INT = 0
	DECLARE @vmCount		INT = 0,
			@reqDiscCount INT = 0,
			@diskSize BIGINT = 0,
			@reqMemory INT = 0,
			@reqCpuCores INT = 0,
			@reqNICs INT = 0,
			@memoryQuotaUsed BIGINT = 0,
			@maxMemoryQuota INT= 0,
			@cpuQuotaUsed INT = 0,
			@maxCPUQuota INT = 0,
			@quotaType INT = 0
	DECLARE @diffCpu INT = 0,
			@diffMemory INT = 0
	DECLARE @currReqCount	INT =  @i_xml.value('count(/TMMsg_VMProvisioningOption/virtualMachineOption/vmInfo/vm)', 'INT')
	DECLARE @isMember INT  = 0
	DECLARE @i INT = 0
	DECLARE @dataCenterId INT
	DECLARE @vAppId int
	DECLARE @vAppName varchar(256)
	declare @vAppXML xml
	declare @isVirtualLab int
	DECLARE @useSourceESXMount INT = 0
	SET @o_ErrorCode = 0
	SET @o_ErrorString = 'Success'
	SELECT  @vmAllocPolicyId = ref.value('@vmAllocPolicyId', 'INT'),
			@vmAllocPolicyName = ref.value('@vmAllocPolicyName','NVARCHAR(MAX)')
	FROM	@i_xml.nodes ('/TMMsg_VMProvisioningOption/virtualMachineOption/vmAllocPolicy') R(ref)
	IF @validationSubclientId > 0
	BEGIN
IF NOT EXISTS ( select attrval from APP_SubClientProp where attrname = 'VS App Validation' and attrval = '1' and modified =0 and componentNameId = @validationSubclientId)
		BEGIN
SET @o_ErrorCode = (177 | (CAST(POWER(2, 24) AS BIGINT) * 72))
SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, (177 | (CAST(POWER(2, 24) AS BIGINT) * 72)), 0, 2);
	            GOTO EXIT_ERROR
		END
		SET @useSourceESXMount = ISNULL((select attrval from APP_SubClientProp where attrname = 'Use Source ESX Mount' and modified =0 and componentNameId = @validationSubclientId), 0)
		SET @canSkipValidationChecks = CASE WHEN @useSourceESXMount = 1 THEN 1 ELSE 0 END
		IF @useSourceESXMount = 0
		BEGIN
			SELECT @vmAllocPolicyId = vmp.id, @vmAllocPolicyName = vmp.name from app_vmallocationpolicy vmp
			INNER JOIN APP_SubClientProp sp
			on sp.attrName ='Validation Policy Id'
			AND sp.modified =0
			AND vmp.id = sp.attrVal
			AND sp.componentNameId = @validationSubclientId
		END
	END
	SELECT @reqMemory = ref.value('@memory', 'INT'),
		   @reqNICs = ref.value('@numberOfNICs', 'INT'),
		   @reqCpuCores = ref.value('@numberOfCPUs', 'INT')
	FROM @i_xml.nodes ('/TMMsg_VMProvisioningOption/virtualMachineOption/vmInfo') R(ref)
	SELECT @vAppId = ref.value('@vAppId', 'int')
	FROM @i_xml.nodes('TMMsg_VMProvisioningOption/vAppEntity') R(ref)
	If ( isnull(@vAppId,0) > 0)
	BEGIN
		select @vAppXml =vxml
		from App_VirtualApp
		where id = @vAppId
		select @isVirtualLab = isnull(@vAppXml.value('Api_VirtualAppReq[1]/vApp[1]/@isVirtualLab', 'int'),0)
		IF ( @isVirtualLab = 0)
		BEGIN
			select @vmAllocPolicyId = P.value('@vmAllocPolicyId', 'int'),
			   @vmAllocPolicyName = P.value('@vmAllocPolicyName', 'nvarchar(255)')
			FROM @vAppXml.nodes('Api_VirtualAppReq/vApp/policy/entity') V(P)
		END
		ELSE
		BEGIN
			select @vmAllocPolicyId = P.value('vmPolicy[1]/@vmAllocPolicyId', 'int'),
				   @vmAllocPolicyName = P.value('vmPolicy[1]/@vmAllocPolicyName', 'nvarchar(255)')
			FROM @vAppXml.nodes('Api_VirtualAppReq/vApp/config') V(P)
		END
	END
	IF isNull(@vmAllocPolicyId,0) = 0
		set @vmAllocPolicyId = isNull(@i_xml.value('/TMMsg_VMProvisioningOption[1]/virtualMachineOption[1]/vmInfo[1]/@vmAllocPolicyId', 'INT'),0)
	IF @vmOperationType = @OPTYPE_EDIT_VM -- Edit Vm
	BEGIN
		DECLARE @vmGuid nvarchar(256)
		SET @vmGuid = ISNULL(@i_xml.value('/TMMsg_VMProvisioningOption[1]/virtualMachineOption[1]/vmInfo[1]/vm[1]/@vmGUID','NVARCHAR(MAX)'), '')
		IF @vmGuid = ''
		BEGIN
			SET @o_ErrorCode = -1
			SET @o_ErrorString = 'VmGuid is missing in the virtualMachineOptions'
			GOTO EXIT_ERROR
		END
		IF isNull(@vmAllocPolicyId,0) = 0
			SET @vmAllocPolicyId = ISNULL((SELECT vmAllocationPolicyId FROM App_VM WHERE GUID = @vmGuid),0)
		select @diffMemory = @reqMemory - ((ISNULL(vm.vxml.value('(/QSMServer_QVirtualMachineReq/memory[1]/@memorySizeMB)[1]','BIGINT'),0))/1024/1024),
		@diffCpu  = @reqCpuCores - ISNULL(vm.vxml.value('(/QSMServer_QVirtualMachineReq/cpu[1]/@numCpu)[1]','INT'),0)
		from App_VM vm WHERE GUID = @vmGuid
	END
	SELECT @vmAllocPolicy = vxml, @dataCenterId = vDataCenterId, @vmAllocPolicyName = name FROM App_VmAllocationPolicy where id = @vmAllocPolicyId
	IF (@vmAllocPolicyId <= 0 OR @vmAllocPolicyName = '_NO_NAME_') AND @canSkipValidationChecks  = 1
		GOTO EXIT_ERROR
	EXECUTE sec_isUserAdmin   @i_userid, @o_isUserAdmin = @isUserAdmin  OUTPUT
	IF ( @isUserAdmin = 0)
	BEGIN
	   SELECT @isMember = dbo.AppCheckVMPolicySecurityPermissions(@i_userid, @vmAllocPolicyId, 0)
	   IF (  @isMember <>  1)
	   BEGIN
SET @o_ErrorCode = (128 | (CAST(POWER(2, 24) AS BIGINT) * 72))
set @o_ErrorString = (select message from EvLocaleMsgs Where messageId=(128 | (CAST(POWER(2, 24) AS BIGINT) * 72))  AND [localeId] = @i_localId)
	      set @o_ErrorString = replace(@o_errorstring,'^1%s',@vmAllocPolicyName)
		  GOTO EXIT_ERROR
	   END
	END
	SELECT
		   @maxMemory = ref.value('@maxMemory', 'INT'),
		   @maxDiscs = ref.value('@maxDiscs', 'INT'),
		   @maxDiskSpace = ref.value('@maxDiskSpace', 'INT'),
		   @maxVMQuota = ISNULL(ref.value('@maxVMQuota', 'INT'),0),
		   @maxNICs = ref.value('@maxNICs', 'INT'),
		   @maxCpuCores = ISNULL(ref.value('@maxCores', 'INT'), 0),
		   @vmAllocPolType= ISNULL(ref.value('entity[1]/@policyType', 'int'), 0),
		   @maxMemoryQuota = ISNULL(ref.value('@maxMemoryQuotaGB', 'INT'),0),
		   @maxCPUQuota = ISNULL(ref.value('@maxCPUQuota', 'INT'),0),
		   @quotaType = ISNULL(ref.value('@quotaType', 'INT'),0)
		FROM @vmAllocPolicy.nodes ('policy') VMP(ref)
	SET @i_vmName = ISNULL((SELECT ref.value('@vmName', 'NVARCHAR(MAX)')
						FROM @i_xml.nodes('/TMMsg_VMProvisioningOption/virtualMachineOption[1]/vmInfo/vm') R(ref)), 0)
	IF @vmOperationType <> @OPTYPE_EDIT_VM -- no need to throw an error if vm exists for edit vm operation
	BEGIN
	IF EXISTS(
		SELECT *
		FROM App_VM VM
			  JOIN App_VMHost HOST
					on vm.vHostId = HOST.id
			  JOIN App_VMDataCenter DC
					ON HOST.vDataCenterId = DC.id
			  JOIN App_VMAllocationPolicy P
					ON    P.vDataCenterId = DC.id
		WHERE P.id = @vmAllocPolicyId AND VM.name = @i_vmName AND VM.removalTimeStamp IS NULL AND DC.removalTimeStamp IS NULL
	)
	BEGIN
SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, (138 | (CAST(POWER(2, 24) AS BIGINT) * 72)), 0, 2);
SET @o_ErrorCode = (138 | (CAST(POWER(2, 24) AS BIGINT) * 72))
		GOTO EXIT_ERROR
	END
	IF @vmOperationType = @OPTYPE_LIVE_MOUNT
	BEGIN
		IF EXISTS(
				SELECT *
				FROM App_VM VM
				WHERE VM.vmAllocationPolicyId = @vmAllocPolicyId AND VM.name = @i_vmName AND VM.removalTimeStamp IS NULL
			) OR
			(isnull((SELECT COUNT(JI.jobId) FROM JMJobInfo JI INNER JOIN JMAdminJobInfoTable JA ON JI.jobId = JA.jobId AND JI.opType = 85
						CROSS APPLY GetAllJobOptions(JI.jobId) AS T
						WHERE JI.userId = @i_userId AND
						T.optionId = 30050685 AND
						ISNULL((CAST(T.value as xml).value('virtualMachineOption[1]/vmAllocPolicy[1]/@vmAllocPolicyId', 'INT')), 0) = @vmAllocPolicyId
						AND ISNULL((CAST(T.value as xml).value('virtualMachineOption[1]/vmInfo[1]/vm[1]/@vmName', 'NVARCHAR(MAX)')), '') = @i_vmName ), 0)> 0 )
		BEGIN
SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, (138 | (CAST(POWER(2, 24) AS BIGINT) * 72)), 0, 2);
SET @o_ErrorCode = (138 | (CAST(POWER(2, 24) AS BIGINT) * 72))
			GOTO EXIT_ERROR
		END
	END
	END
	DECLARE @maxCharVMName INT = 15
	--vmName should be max  as 15 character for vmware, hyper-v, rhev as we use vm name as hostname here
	--vmName can be relaxed to 255 for live mount operation as special case for any vendor.
	IF(@vmAllocPolType NOT IN (0, 2, 9) OR @vmOperationType = @OPTYPE_LIVE_MOUNT)
		SET @maxCharVMName  = 255
	IF len(@i_vmName) > @maxCharVMName
	BEGIN
SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, (131 | (CAST(POWER(2, 24) AS BIGINT) * 72)), 0, 2);
SET @o_ErrorCode = (131 | (CAST(POWER(2, 24) AS BIGINT) * 72))
		GOTO EXIT_ERROR
	END
	IF @quotaType = 0 and @vmOperationType <> @OPTYPE_EDIT_VM -- if quotaType is based on vmCount and it is not edit vm operation
	BEGIN
		IF(@vmAllocPolType in ( 5,6,12,13))--run this for Virtual Lab(VMware,Hyper-V)
		BEGIN
		   --older versions of lab
		   SET @vmCount = ISNULL((SELECT COUNT(VL.id)
					FROM APP_VirtualLab VL
					INNER JOIN APP_VirtualLabProp VLP
					ON VLP.componentNameId = VL.id
					AND VLP.attrName = 'Virtual Lab Policy Id'
					AND VLP.attrVal = @vmAllocPolicyId
					WHERE VL.ownerId = @i_userId and VL.deleted = 0),0)
		   --new versions of lab
		   SET @vmCount += ISNULL((SELECT COUNT(distinct(CGA.clientGroupId))
					FROM APP_ClientProp ACP
					INNER JOIN  App_VM VM
						ON VM.clientId = ACP.componentNameId AND ACP.attrName = 'Virtual Machine Created by User'
							AND ACP.modified = 0 AND CAST(ACP.attrVal AS INT) = @i_userId
							AND VM.removalTimeStamp IS null
							AND vmAllocationPolicyId = @vmAllocPolicyId
					INNER JOIN APP_ClientGroupAssoc CGA
						ON CGA.clientId = VM.clientId
					INNER JOIN APP_ComponentProp CP
						ON CP.componentId = CGA.clientGroupId AND CP.propertyTypeId = 1032 AND CP.longVal = @vmAllocPolicyId
						), 0)
		END
		ELSE
		BEGIN
			SET @vmCount = ISNULL((SELECT COUNT(C.id)
					FROM App_VM VM INNER JOIN App_Client C ON C.id = VM.clientId
					WHERE VM.removalTimeStamp IS null AND
						vmAllocationPolicyId = @vmAllocPolicyId AND
						C.id in (
							SELECT componentNameId FROM APP_ClientProp
							WHERE attrName = 'Virtual Machine Created by User' AND modified = 0 AND CAST(attrVal AS INT) = @i_userId
						) ), 0)
			SET @vmCount = @vmCount +
					ISNULL((SELECT COUNT(JI.jobId) FROM JMJobInfo JI INNER JOIN JMAdminJobInfoTable JA ON JI.jobId = JA.jobId AND JI.opType = 85
						CROSS APPLY GetAllJobOptions(JI.jobId) AS T
					WHERE JI.userId = @i_userId AND
T.optionId = 30050685 AND
						ISNULL((CAST(T.value as xml).value('virtualMachineOption[1]/vmAllocPolicy[1]/@vmAllocPolicyId', 'INT')), 0) = @vmAllocPolicyId), 0)
    	END
		IF @maxVMQuota >0 and (@vmCount + @currReqCount > @maxVMQuota)
		BEGIN
			IF @vmAllocPolType = 4
			BEGIN
SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, (150 | (CAST(POWER(2, 24) AS BIGINT) * 72)), 0, 2);
SET @o_ErrorCode = (150 | (CAST(POWER(2, 24) AS BIGINT) * 72))
			END
			ELSE
			IF @vmAllocPolType in ( 5,6,12,13)
			BEGIN
SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, (158 | (CAST(POWER(2, 24) AS BIGINT) * 72)), 0, 2);
SET @o_ErrorCode = (158 | (CAST(POWER(2, 24) AS BIGINT) * 72))
			END
			ELSE
			BEGIN
SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, (130 | (CAST(POWER(2, 24) AS BIGINT) * 72)), 0, 2);
SET @o_ErrorCode = (130 | (CAST(POWER(2, 24) AS BIGINT) * 72))
			END
			GOTO EXIT_ERROR
		END
	END
	IF @quotaType = 1 and @vmAllocPolType in (0,2)-- If quota type is based on memory/cpu type and only for hyper-V and VMWare
	BEGIN
			-- Check for Maximum Memory Quota per user vioalation --
			select @memoryQuotaUsed = ISNULL(sum(ISNULL(vm.vxml.value('(/QSMServer_QVirtualMachineReq/memory[1]/@memorySizeMB)[1]','BIGINT'),0)),0) from APP_ClientProp ACP
				INNER JOIN  App_VM VM
					ON VM.clientId = ACP.componentNameId AND ACP.attrName = 'Virtual Machine Created by User'
						AND ACP.modified = 0 AND CAST(ACP.attrVal AS INT) = @i_userId
						AND VM.vmAllocationPolicyId = @vmAllocPolicyId
						AND VM.removalTimeStamp IS null
			SET @memoryQuotaUsed = @memoryQuotaUsed / 1024 /1024 +
			ISNULL((SELECT SUM (CAST(T.value as xml).value('virtualMachineOption[1]/vmInfo[1]/@memory','INT'))
			FROM JMJobInfo JI INNER JOIN JMAdminJobInfoTable JA ON JI.jobId = JA.jobId AND JI.opType = 85
				CROSS APPLY GetAllJobOptions(JI.jobId) AS T
			WHERE JI.userId = @i_userId AND
T.optionId = 30050685 AND
				ISNULL((CAST(T.value as xml).value('virtualMachineOption[1]/vmAllocPolicy[1]/@vmAllocPolicyId', 'INT')), 0) = @vmAllocPolicyId), 0)
		DECLARE @memoryExceeded BIT = 0
		IF @vmOperationType = @OPTYPE_EDIT_VM -- for edit operation check if diffMemory is violating policy quoata
		BEGIN
			IF @diffMemory > 0 and (( @memoryQuotaUsed / 1024 ) + (@diffMemory / 1024) > @maxMemoryQuota)
				SET @memoryExceeded = 1
		END
		ELSE IF ( @memoryQuotaUsed / 1024 ) + ((@reqMemory / 1024) * @currReqCount) > @maxMemoryQuota
			SET @memoryExceeded = 1
		IF @memoryExceeded = 1
			BEGIN
SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, (159 | (CAST(POWER(2, 24) AS BIGINT) * 72)), 0, 2);
SET @o_ErrorCode = (159 | (CAST(POWER(2, 24) AS BIGINT) * 72))
				GOTO EXIT_ERROR
			END
			-- Check for Maximum CPU Quota per user vioalation --
			select @cpuQuotaUsed = ISNULL(sum(ISNULL(vm.vxml.value('(/QSMServer_QVirtualMachineReq/cpu[1]/@numCpu)[1]','INT'),0)),0) from APP_ClientProp ACP
				INNER JOIN  App_VM VM
					ON VM.clientId = ACP.componentNameId AND ACP.attrName = 'Virtual Machine Created by User'
						AND ACP.modified = 0 AND CAST(ACP.attrVal AS INT) = @i_userId
						AND VM.vmAllocationPolicyId = @vmAllocPolicyId
						AND VM.removalTimeStamp IS null
			SET  @cpuQuotaUsed =  @cpuQuotaUsed +
			ISNULL((SELECT SUM (CAST(T.value as xml).value('virtualMachineOption[1]/vmInfo[1]/@numberOfCPUs','INT'))
			FROM JMJobInfo JI INNER JOIN JMAdminJobInfoTable JA ON JI.jobId = JA.jobId AND JI.opType = 85
				CROSS APPLY GetAllJobOptions(JI.jobId) AS T
			WHERE JI.userId = @i_userId AND
T.optionId = 30050685 AND
				ISNULL((CAST(T.value as xml).value('virtualMachineOption[1]/vmAllocPolicy[1]/@vmAllocPolicyId', 'INT')), 0) = @vmAllocPolicyId), 0)
		DECLARE @cpuExceeded BIT = 0
		IF @vmOperationType = @OPTYPE_EDIT_VM -- for edit operation check if diffMemory is violating policy quoata
		BEGIN
			IF @diffCpu > 0 and ( @cpuQuotaUsed + @diffCpu > @maxCPUQuota)
				SET @cpuExceeded = 1
		END
		ELSE IF @cpuQuotaUsed +  (@reqCpuCores * @currReqCount) > @maxCPUQuota
			SET @cpuExceeded = 1
		IF @cpuExceeded = 1
			BEGIN
SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, (160 | (CAST(POWER(2, 24) AS BIGINT) * 72)), 0, 2);
SET @o_ErrorCode = (160 | (CAST(POWER(2, 24) AS BIGINT) * 72))
					GOTO EXIT_ERROR
			END
	END
	SET @reqDiscCount = @i_xml.value('count(/TMMsg_VMProvisioningOption/virtualMachineOption/vmInfo/hardDisks/hardDisk)','int')
	SET @i =1
	WHILE (@i <= @reqDiscCount )
	BEGIN
		SET @diskSize = @diskSize + @i_xml.value('(/TMMsg_VMProvisioningOption/virtualMachineOption/vmInfo/hardDisks/hardDisk[sql:variable("@i")]/@diskSize)[1]', 'bigint')
		SET @i = @i +1
	END
	SET @maxDiskSpace = @maxDiskSpace * 1024	--diskSize is in MB and maxDiskSpace is in GB
	IF(@vmAllocPolType != 12 AND @vmAllocPolType != 13 AND  @vmOperationType <> @OPTYPE_EDIT_VM )--Dont run this for Restore as Lab(VMware,Hyper-V) and edit vm operation
	BEGIN
		IF (  @maxDiskSpace * @currReqCount < @diskSize )
		BEGIN
SET @o_ErrorCode = (122 | (CAST(POWER(2, 24) AS BIGINT) * 72))
			--'Disk space requested for the Virtual Machine exceeds maximum disk space set in the policy'
set @o_ErrorString = (select message from EvLocaleMsgs Where messageId=(122 | (CAST(POWER(2, 24) AS BIGINT) * 72))  AND [localeId] = @i_localId)
	    	set @o_ErrorString = replace(@o_errorstring,'^1%s',@vmAllocPolicyName)
			GOTO EXIT_ERROR
		END
		IF ( @maxDiscs * @currReqCount  < @reqDiscCount )
		BEGIN
SET @o_ErrorCode = (123 | (CAST(POWER(2, 24) AS BIGINT) * 72))
			--'Total disks requested for the Virtual Machine exceeds maximum disks set in the policy'
set @o_ErrorString = (select message from EvLocaleMsgs Where messageId=(123 | (CAST(POWER(2, 24) AS BIGINT) * 72))  AND [localeId] = @i_localId)
	    	set @o_ErrorString = replace(@o_errorstring,'^1%s',@vmAllocPolicyName)
			GOTO EXIT_ERROR
		END
	END
	IF(@vmAllocPolType != 1 AND @vmAllocPolType != 3 AND @vmAllocPolType != 12 AND @vmAllocPolType != 13)--Dont run this for Amazon,Azure,Restore as Lab(VMware,Hyper-V)
	BEGIN
		IF ( @maxNICs  < @reqNICs )
		BEGIN
SET @o_ErrorCode = (124 | (CAST(POWER(2, 24) AS BIGINT) * 72))
			--'Total NICs requested for the Virtual Machine exceeds maximum NICs set in the policy'
set @o_ErrorString = (select message from EvLocaleMsgs Where messageId=(124 | (CAST(POWER(2, 24) AS BIGINT) * 72))  AND [localeId] = @i_localId)
			set @o_ErrorString = replace(@o_errorstring,'^1%s',@vmAllocPolicyName)
			GOTO EXIT_ERROR
		END
		SET @maxMemory = @maxMemory * 1024
		IF ( @maxMemory  < @reqMemory )
		BEGIN
SET @o_ErrorCode = (125 | (CAST(POWER(2, 24) AS BIGINT) * 72))
			--'Total memory requested for the Virtual Machine exceeds maximum memory set in the policy'
			set @o_ErrorString = (select message from EvLocaleMsgs Where messageId=@o_ErrorCode  AND [localeId] = @i_localId)
			set @o_ErrorString = replace(@o_errorstring,'^1%s',@vmAllocPolicyName)
			GOTO EXIT_ERROR
		END
		IF( @maxCpuCores < @reqCpuCores)
		BEGIN
SET @o_ErrorCode = (139 | (CAST(POWER(2, 24) AS BIGINT) * 72))
			--'The number of CPU(s) requested exceeds maximum set in the policy'
			set @o_ErrorString = (select message from EvLocaleMsgs Where messageId=@o_ErrorCode  AND [localeId] = @i_localId)
			set @o_ErrorString = replace(@o_errorstring,'^1%s',@vmAllocPolicyName)
			GOTO EXIT_ERROR
		END
	END
END
IF @vmOperationType = @OPTYPE_SNAPSHOT_VM --TMMsg::VMOperationType_SNAPSHOT_VM
BEGIN
	DECLARE @maxSnapShots	INT	= 0
	DECLARE @snapShotCount	INT = 0
	SET @vmGuid = ISNULL((SELECT ref.value('@vmGUID', 'NVARCHAR(MAX)')
						FROM @i_xml.nodes('/TMMsg_VMProvisioningOption/vmSnapOption[1]/snapshot/virtualMachine') R(ref)), 0)
	SET @vmAllocPolicyId = ISNULL((SELECT vmAllocationPolicyId FROM App_VM WHERE GUID = @vmGuid),0)
	SET @maxSnapShots = ISNULL((SELECT vxml.value('policy[1]/@maxSnapshots', 'int') FROM App_VmAllocationPolicy WHERE id = @vmAllocPolicyId), 4)
	SET @snapShotCount = ISNULL((SELECT	COUNT(*)
								FROM	App_VM V, App_VmSnapShot S
								WHERE	V.id = S.vmId
									AND	V.GUID = @vmGuid
									AND V.vmAllocationPolicyId = @vmAllocPolicyId
									AND S.removalTimeStamp IS NULL), 0)
	IF @snapShotCount >= @maxSnapShots
	BEGIN
SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, (133 | (CAST(POWER(2, 24) AS BIGINT) * 72)), 0, 2);
SET @o_ErrorCode = (133 | (CAST(POWER(2, 24) AS BIGINT) * 72))
	END
END
IF @vmOperationType = @OPTYPE_AUTO_PROXY_MANAGEMENT
BEGIN
	--- Assuming only one region and one proxyrequest will be submitted per job.
	-- If multiple regions and proxies are supported per job, check should be changed.
	DECLARE @instanceId INT
	declare @maxAutoProxyQuota int
	SELECT  @virtualizationClientId = isnull(ref.value('vmLocation[1]/virtualizationClient[1]/@clientId', 'INT'),0)
	FROM	@i_xml.nodes ('(/TMMsg_VMProvisioningOption/virtualMachineOption/vmInfo)[1]') R(ref)
	select TOP 1 @instanceId = instance from APP_Application where clientId = @virtualizationClientId and appTypeId = 106
	--Check Admin account
	declare @adminInstanceId INT = 0
	select @adminInstanceId = cast (attrVal as int) from APP_InstanceProp where componentNameId = @instanceId and attrName = 'Amazon Admin Instance Id' and modified = 0
	if isNull(@adminInstanceId,0) > 0
	begin
		set @instanceId = @adminInstanceId
		SET @virtualizationClientId = (SELECT TOP 1 clientId FROM APP_Application WITH(NOLOCK) WHERE instance = @adminInstanceId AND appTypeId = 106)
	end
	declare @clientGroupId int
	select  @vmAllocPolicyId  = cast (attrVal as int) FROM APP_InstanceProp WHERE componentNameId= @instanceId AND attrName='Auto Scale Policy'
	select @maxAutoProxyQuota =  c.value('(scaleOption/scaleOutParam/@maxVMthreshold)[1]', 'INT'),
	@clientGroupId = ISNULL(c.value('(associatedClientGroup/@clientGroupId)[1]', 'INT'),0)
	from App_VmAllocationPolicy P
	CROSS APPLY P.vxml.nodes ('policy') T(c)
	where P.id = @vmAllocPolicyId and alive = 1
	declare @region nvarchar(1024)
	select @region = @i_xml.value('/TMMsg_VMProvisioningOption[1]/virtualMachineOption[1]/vmInfo[1]/vmLocation[1]/@dataCenterName','nvarchar(1024)')
	declare @osType int
	select @osType = @i_xml.value('/TMMsg_VMProvisioningOption[1]/virtualMachineOption[1]/vmInfo[1]/@osType','int')
	declare @osTypeStr nvarchar(256) = 'Unix' -- default is Linux
	if @osType = 1
		set @osTypeStr = 'Windows'
    -- let us check if the client gorup is still in the access node list
	declare @proxyXML xml
	SELECT TOP 1 @proxyXML =  CAST(attrVal AS XML) FROM APP_InstanceProp where attrName = 'Vs Member Servers'  and  componentNameId  = @instanceId
	if not exists  (SELECT a.b.value('@clientGroupId','INT')
	FROM @proxyXML.nodes('/App_MemberServers/memberServers/client') a(b)
	where a.b.value('@clientGroupId','INT') = @clientGroupId )
	begin
		SET @o_ErrorString = 'Server group assocaited with auto scale settings is not part of the access nodes, please add the server group to the access nodes list and retry the job'
		SET @o_ErrorCode = 200
		GOTO EXIT_ERROR
	end
	declare @autoProxyQuotaUsed INT = 0
	select @autoProxyQuotaUsed = ISNULL((select count(*)
		from APP_ClientProp CP1
		INNER JOIN APP_ClientProp CP2 on CP1.componentNameId = CP2.componentNameId
		INNER JOIN APP_ClientProp CP3 on CP1.componentNameId = CP3.componentNameId
		INNER JOIN APP_Client C on CP1.componentNameId = C.id
		INNER JOIN simOperatingSystem S on C.simOperatingSystemId = S.id and S.Type = @osTypeStr
		and CP1.attrName = 'VSA DataCenter Name' and CP1.attrVal = @region
		and CP2.attrName = 'Auto Proxy Client' and CP2.attrVal = 1
		and CP3.attrName = 'Virtual Machine Instance ID' and CP3.attrVal = @instanceId
		inner join app_clientgroupassoc cga
		on cga.clientGroupId = @clientGroupId
		and cga.clientId = cp1.componentNameId),0)
	--Fetch running autoProxy jobs in the same region, os and virtualization client
	 IF object_id('tempdb.dbo.#runningAutoProxyJobs') IS NOT null DROP TABLE #runningAutoProxyJobs
		create table #runningAutoProxyJobs(
                                jobId		   int,
                                jobOptionsXml  xml,
                                region         nvarchar(256),
                                osType         int,
								virtualizationClientId int
								)
	insert into #runningAutoProxyJobs (jobId,jobOptionsXml)
	select JI.jobId, (CAST(T1.value as xml))
	from JMJobInfo JI INNER JOIN JMAdminJobInfoTable JA ON JI.jobId = JA.jobId AND JI.opType = 85
INNER JOIN TM_JobOptions T1 on T1.jobId = JI.jobId AND T1.optionId = 30050685
INNER JOIN TM_JobOptions T2 on T2.jobId = JI.jobId AND T2.optionId = 1815939405 AND ISNULL(CAST(T2.value as INT),0) = @OPTYPE_AUTO_PROXY_MANAGEMENT
	 update #runningAutoProxyJobs
	 set region = C.value('vmLocation[1]/@dataCenterName', 'nvarchar(1024)'),
	 osType = C.value('@osType','int'),
	 virtualizationClientId = C.value('vmLocation[1]/virtualizationClient[1]/@clientId','int')
	 from #runningAutoProxyJobs A
	 cross apply A.jobOptionsXml.nodes('virtualMachineOption[1]/vmInfo[1]') T(C)
	 --Replace any tenantAdmin clients with admin account
	 update #runningAutoProxyJobs
	 set virtualizationClientId = isNull((SELECT TOP 1 clientId FROM APP_Application WITH(NOLOCK) WHERE instance = cast (IP.attrVal as int) AND appTypeId = 106),J.virtualizationClientId)
	 from #runningAutoProxyJobs J
	 inner join APP_Application A on A.appTypeId = 106 and A.clientId = J.virtualizationClientId and A.subclientName = 'default'
	 inner join APP_InstanceProp IP on IP.componentNameId = A.instance and attrName = 'Amazon Admin Instance Id' and IP.modified = 0
	declare @runningAutoProxyJobCount INT
	set @runningAutoProxyJobCount = ISNULL((SELECT count(*) from #runningAutoProxyJobs A
	where A.region = @region and A.osType = @osType and A.virtualizationClientId = @virtualizationClientId),0)
	IF @autoProxyQuotaUsed + @runningAutoProxyJobCount >= @maxAutoProxyQuota
	BEGIN
SET @o_ErrorString = dbo.fn_EvFormatEventMsgText(0, @i_localId, (130 | (CAST(POWER(2, 24) AS BIGINT) * 72)), 0, 2);
SET @o_ErrorCode = (130 | (CAST(POWER(2, 24) AS BIGINT) * 72))
		GOTO EXIT_ERROR
	END
END
EXIT_ERROR:
SELECT @o_ErrorCode as errorCode, @o_ErrorString as errorString
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VMP_ValidateVMJob')
	delete from GxQscripts where name = 'VMP_ValidateVMJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_ValidateVMJob')
	delete from GXDBVersions where aliasname = 'VMP_ValidateVMJob'
GO

insert into GXDBVersions values(2, 'VMP_ValidateVMJob',  '00010017001200310000', 'VMP_ValidateVMJob', '00010017001200310000')
GO

