

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_SetVMTemplates.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   06/23/2013
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_SetVMTemplates.sp,v $ $Id: VMP_SetVMTemplates.sp,v 1.3.50.1 2018/03/27 08:04:00 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_SetVMTemplates <<<'

IF EXISTS (select * from sysobjects where name='VMP_SetVMTemplates')
	drop procedure VMP_SetVMTemplates
IF EXISTS (select * from GxQscripts where name='VMP_SetVMTemplates')
	delete from GxQscripts where name = 'VMP_SetVMTemplates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_SetVMTemplates')
	delete from GXDBVersions where aliasname = 'VMP_SetVMTemplates'
GO
print '... Creating Procedure: VMP_SetVMTemplates'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_SetVMTemplates
  @i_xmlText XML
AS
  DECLARE @o_errorCode INT
  DECLARE @o_errorStr NVARCHAR(1024)
BEGIN
--<?xml version='1.0' encoding='UTF-8'?><Ida_SetTemplateListReq><clientEntity clientId="2" clientName="HyperVClient" /><vmList vmName="MsDhoni" vmGUID="CB443E92-7D62-4069-9403-8745CB0DE971" /><vmList vmName="testvivek" vmGUID="496048B8-1D06-4FA0-8E65-6EA2F3E05609" /></Ida_SetTemplateListReq>
	--Get selected clients list
	CREATE TABLE #vmListTable
	(
		vmName		nvarchar(64),
		vmGUID		nvarchar(64),
		clientId	int
	)
	DECLARE @i_dataCenterId		INT
	SET	@i_dataCenterId = ISNULL (( SELECT ref.value('@clientId', 'INT')
						FROM  @i_xmlText.nodes ('Ida_SetTemplateListReq/clientEntity') R(ref)), 0)
	INSERT INTO #vmListTable(vmName, vmGUID)
	SELECT  ref.value('@vmName', 'NVARCHAR(64)') AS vmName,
			ref.value('@vmGUID', 'NVARCHAR(64)') AS vmGUID
			FROM    @i_xmlText.nodes('Ida_SetTemplateListReq/vmList') R ( ref )
	UPDATE	#vmListTable
	SET		clientId = VM.clientId
	FROM	#vmListTable T, App_VM VM
	WHERE	T.vmGUID = VM.GUID
	--Mark all as normal VMs
	UPDATE	APP_ClientProp
	SET		attrVal = '1'
	FROM	App_VM, APP_ClientProp, App_VMHost H
	WHERE	clientId = componentNameId
		AND	vHostId = H.id
		AND	attrName = 'Virtual Entity Flags'
		AND	attrVal = '2'
		AND	H.vDataCenterId = @i_dataCenterId
	--Set selected clients as templates
	UPDATE	APP_ClientProp
	SET		attrVal = '2'
	FROM	#vmListTable T, APP_ClientProp C
	WHERE	T.clientId = C.componentNameId
		AND	attrName = 'Virtual Entity Flags'
	SELECT 0, N''
	DROP TABLE #vmListTable
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VMP_SetVMTemplates')
	delete from GxQscripts where name = 'VMP_SetVMTemplates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_SetVMTemplates')
	delete from GXDBVersions where aliasname = 'VMP_SetVMTemplates'
GO

insert into GXDBVersions values(2, 'VMP_SetVMTemplates',  '00010003005000010000', 'VMP_SetVMTemplates', '00010003005000010000')
GO

