

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_PhysicalDeleteEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_PhysicalDeleteEntity.sp,v $ $Id: VMP_PhysicalDeleteEntity.sp,v 1.4.50.1 2017/02/10 20:42:01 sjohnson Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   VMP_PhysicalDeleteEntity   -  delete cliente enries for the vms
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_PhysicalDeleteEntity <<<'

IF EXISTS (select * from sysobjects where name='VMP_PhysicalDeleteEntity')
	drop procedure VMP_PhysicalDeleteEntity
IF EXISTS (select * from GxQscripts where name='VMP_PhysicalDeleteEntity')
	delete from GxQscripts where name = 'VMP_PhysicalDeleteEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_PhysicalDeleteEntity')
	delete from GXDBVersions where aliasname = 'VMP_PhysicalDeleteEntity'
GO
print '... Creating Procedure: VMP_PhysicalDeleteEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_PhysicalDeleteEntity
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @flags INT
AS
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(1024)
BEGIN
SET NOCOUNT ON
BEGIN TRY
	DECLARE @clientId INT
	DECLARE @return_value INT
	IF ( (@flags & 1 ) = 1 )
	BEGIN
		IF object_id('tempdb.dbo.#tmpVMClientList') IS NOT null DROP TABLE #tmpVMClientList
		create table #tmpVMClientList(
					clientId		int NOT NULL
					)
		INSERT INTO #tmpVMClientList SELECT client.id FROM APP_Client client
		INNER JOIN APP_ClientProp clientProp
		ON clientProp.componentNameId = client.id
		AND clientProp.attrName = 'Virtual Machine Name'
		AND clientProp.modified =0
		AND client.specialClientFlags = 11
		INSERT INTO #tmpVMClientList select client.id FROM APP_Client client
		INNER JOIN App_VMHost vHost
		on client.name = vHost.name
		AND vHost.removalTimeStamp IS NULL
		DECLARE  vmClients_cur CURSOR FOR select clientId FROM #tmpVMClientList
		OPEN vmClients_cur
		FETCH NEXT FROM vmClients_cur into @clientId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF db_id('SRM') IS NOT null
			BEGIN
            EXEC  @return_value = SRM.[dbo].[SRMCSStubDeconfiguration]
                  @opType = 1,
                  @idType = 1,
                  @objectId = @clientId,
                  @appTypeId = 0,
                  @printON = 0
			END
			DELETE APP_IDAName where clientId = @clientId
			DELETE APP_ScFilterFile where componentNameId IN
			( SELECT id FROM APP_Application where clientId = @clientId)
			DELETE APP_SubClientProp where componentNameId IN
			( SELECT id FROM APP_Application where clientId = @clientId)
			DELETE APP_Application where clientId = @clientId
			DELETE APP_ClientGroupAssoc where clientId = @clientId
			DELETE FROM  APP_ClientProp where componentNameId = @clientId
			DELETE FROM APP_Platform where clientId = @clientId
			DELETE FROM APP_Client where id = @clientId
			FETCH NEXT FROM vmClients_cur into @clientId
		END
	END
	IF ( (@flags & 2 ) = 2 )
	BEGIN
		DELETE APP_ClientGroupAssoc where clientGroupId in ( SELECT CG.id FROM APP_ClientGroup CG
															  INNER JOIN App_VMHost VHost
															  ON CG.name = VHost.name
															  AND removalTimeStamp IS null )
		DELETE APP_ClientGroupAssoc where clientGroupId in ( SELECT CG.id FROM APP_ClientGroup CG
															  INNER JOIN App_VMDataCenter vDataCenter
															  ON CG.name = vDataCenter.vCenter+'-'+vDataCenter.name
															  AND removalTimeStamp IS NULL )
		DELETE APP_ClientGroup WHERE name in ( SELECT name FROM App_VMHost where  removalTimeStamp IS NULL)
		DELETE APP_ClientGroup WHERE name in ( SELECT vCenter+'-'+name FROM App_VMDataCenter where removalTimeStamp IS NULL)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	EXECUTE dbo.GetError @errorString OUTPUT , @errorString OUTPUT
END CATCH
EXIT_PROC:
	SELECT @errorCode , @errorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'VMP_PhysicalDeleteEntity')
	delete from GxQscripts where name = 'VMP_PhysicalDeleteEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_PhysicalDeleteEntity')
	delete from GXDBVersions where aliasname = 'VMP_PhysicalDeleteEntity'
GO

insert into GXDBVersions values(2, 'VMP_PhysicalDeleteEntity',  '00010004005000010000', 'VMP_PhysicalDeleteEntity', '00010004005000010000')
GO

