

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_ModifyRestoreTaskReq.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_ModifyRestoreTaskReq.sp,v $ $Id: VMP_ModifyRestoreTaskReq.sp,v 1.1.2.21 2020/09/29 14:02:41 pktr Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "GetDataCenterList"
--	|	This Procedure is used to get the list of available data centers
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='VMP_ModifyRestoreTaskReq')
BEGIN
	print '>>> Drop Stored Procedure: VMP_ModifyRestoreTaskReq <<<'
	drop procedure VMP_ModifyRestoreTaskReq
END
IF EXISTS (select * from GxQscripts where name='VMP_ModifyRestoreTaskReq')
	delete from GxQscripts where name = 'VMP_ModifyRestoreTaskReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_ModifyRestoreTaskReq')
	delete from GXDBVersions where aliasname = 'VMP_ModifyRestoreTaskReq'
GO
print '... Creating Procedure: VMP_ModifyRestoreTaskReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_ModifyRestoreTaskReq
-- Input arguments
  @i_userId INT,
  @i_jobId INT
AS
  DECLARE @o_errorCode integer = 0;
  DECLARE @o_errorString NVARCHAR(255);
BEGIN TRY
-- request :<Ida_VMOpReq><vmInfo isPhysical="0" isTemplate="0" memory="2048" numberOfCPUs="2" numberOfNICs="4" operatingSystem="Microsoft Windows Server 2008 (64-bit)" purpose="" vmAllocPolicyId="3" vmState="0"><vm _type_="88" vmName="t.t.ttt.commvault.com"/><vmLocation dataCenterName="Commvault-DC" hostName="" vCenter="usint13"><dcUserInfo password="||#4!MWVodG40dGZhNGY0bnRJdHo0Ym5Zbm4=&#xA;" userName="administrator"/><datastore name=""/></vmLocation><hardDisks><hardDisk diskSize="112640" diskType="2" label="Hard disk 1"/><hardDisk diskSize="61440" diskType="1" label="Hard disk 2"/></hardDisks><expirationTime time="1300766400"/></vmInfo><vmEntity _type_="88" clientId="89" commCellId="0" type="0" vmGUID="421b9c6b-9172-73dc-92a8-f0a631cd7a20" vmName="template-win2k8r2-2"/></Ida_VMOpReq>
	SET NOCOUNT ON
	DECLARE @jobRequestXML			XML
	DECLARE @esxServerCount			INT
	DECLARE @dataStoreCount			INT
	DECLARE @esxServerName			VARCHAR(256)
	DECLARE @dataStoreName			VARCHAR(256)
	DECLARE @diskSize				bigint =0
	DECLARE @totalItems				INT
	DECLARE @i						INT
	DECLARE @cnt					INT
	DECLARE @j						INT
	DECLARE @diskcnt				INT
	DECLARE @esxServerId			INT
	DECLARE @vmAllocPolicyId		INT
	DECLARE @vmAllocPolicyType		INT
	--DECLARE @dataCenterId			INT
	DECLARE @instanceId				INT
	DECLARE @FolderPath				NVARCHAR(255)
	DECLARE @HardDiskFolderPath		NVARCHAR(255)
	DECLARE @DatacenterName			NVARCHAR(255)
	DECLARE @VMName					NVARCHAR(255)
	DECLARE @VMGUID					NVARCHAR(255)
	DECLARE @NewVMName				NVARCHAR(255)
	DECLARE @value   float
	DECLARE @isRestoreLabPolicy		INT = 0
	DECLARE @minDiskSize			BIGINT = 0
	DECLARE @virtualizationClientId INT, @virtualizationClientName nvarchar(255)
	DECLARE @destinationClientId INT, @destinationClientName nvarchar(255) = ''
	DECLARE @createIsolatedNetwork int =0
	DECLARE @networkName	nvarchar(255) = NULL
	DECLARE @niccnt					INT
	DECLARE @k						INT
	DECLARE @generateNewGuid		INT = 1
	DECLARE @tmpXML					xml
	DECLARE @vCenterName			NVARCHAR(255)
	DECLARE	@networkNameLabel		NVARCHAR(255) = 'Network adapter'
	DECLARE @taskId int
    DECLARE @subTaskId int
    DECLARE @useAllocationPolicyForRestore INT = 0
    DECLARE @isVirtualLabRestoreJob INT = 0
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	select top 1 @taskId = taskId,
        @subTaskId = subTaskId
    FROM TM_JobOptions with (nolock)
    where jobid = @i_jobId
    order by taskid desc
	SELECT @jobRequestXML = dbo.GetXMLJobOptions(@i_jobId)
	IF NOT EXISTS (SELECT * FROM TM_JobXMLOptions WHERE jobId = @i_jobId)
	BEGIN
		--inserting new record for jobId
		INSERT INTO TM_JobXMLOptions
			VALUES( @i_jobId, @jobRequestXML, @taskId, @subTaskId, @i_jobId, dbo.getunixtime(GETDATE()), 0)
	END
	SELECT @vmAllocPolicyId = ref.value('@vmAllocPolicyId', 'INT')
		FROM @jobRequestXML.nodes ('/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/virtualLabOption/vmPolicy') R(ref)
	IF (isNull(@vmAllocPolicyId,0) = 0)
	BEGIN
		SELECT @vmAllocPolicyId = ref.value('(virtualServerRstOption/allocationPolicy)[1]/@vmAllocPolicyId', 'INT'),
			   @useAllocationPolicyForRestore = isnull(ref.value('@useAllocationPolicyForRestore','INT'),0)
			FROM @jobRequestXML.nodes ('/TMMsg_JobOption/restoreOptions') R(ref)
	END
	ELSE
	BEGIN
	     --if vmAllocPolicyId is valid from virtualLabOption, it is eligible retore as lab job
		 SET @isVirtualLabRestoreJob = 1
	END
	SELECT @DatacenterName = vxml.value('(/policy/dataCenter)[1]/@dataCenterName','nvarchar(255)'),
		   @vmAllocPolicyType = vxml.value('(/policy/entity)[1]/@policyType','INT'),
		    @virtualizationClientId = isnull(vxml.value('(/policy/dataCenter/instanceEntity)[1]/@clientId','INT'), vxml.value('(/policy/destinationHyperV)[1]/@clientId','INT')),
		   @virtualizationClientName = isnull(vxml.value('(/policy/dataCenter/instanceEntity)[1]/@clientName','nvarchar(255)'), vxml.value('(/policy/destinationHyperV)[1]/@clientName','nvarchar(255)')),
		   @instanceId = vxml.value('(/policy/dataCenter/instanceEntity)[1]/@instanceId','INT'),
		   @createIsolatedNetwork = ISNULL(vxml.value('(/policy)[1]/@createIsolatedNetwork', 'INT'),0),
		   @networkName = CASE WHEN (@useAllocationPolicyForRestore = 1) THEN  ISNULL(vxml.value('(/policy/networkList)[1]/@destinationNetwork','nvarchar(255)'),'') ELSE ISNULL(vxml.value('(/policy/networkNames)[1]/@val','nvarchar(255)'),'') END,
		   @vCenterName =  isnull(vxml.value('(/policy/dataCenter)[1]/@vCenterName','nvarchar(255)'),'')
		FROM App_VMAllocationPolicy WHERE id = @vmAllocPolicyId
	--if instanceId is null fetch from App_application table from @virtualizationClientId
	if @instanceId is null
	BEGIN
		SELECT @instanceId = instance FROM APP_Application WHERE appTypeId = 106 AND clientId = @virtualizationClientId
	END
	DECLARE @bestLocationServers TABLE (
                        o_rank           float,
						errorCode		 INT,
						errorMessage	 NVARCHAR(512),
						esxServerName	 VARCHAR(256),
						dataStoreName	 VARCHAR(256),
						VMCount			 INT,
						TotalMemory		 INT,
						freememoryPct    INT,
						totalSpaceGB	 INT,
						freeSpacePct     INT,
						esxtimeStamp	 VARCHAR(20),
						dstimeStamp		 VARCHAR(20)
					)
	INSERT INTO @bestLocationServers
	EXEC VMP_BestLocation @i_userId, @jobRequestXML, 0
	SELECT TOP 1 @o_errorCode = errorCode, @o_errorString = errorMessage, @esxServerName = esxServerName, @dataStoreName = dataStoreName  FROM @bestLocationServers
	IF @o_errorCode <> 0
		GOTO ERROR_EXIT
	IF @jobRequestXML.exist('(TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/@generateNewGuid)[1]') = 1
	SET @jobRequestXML.modify('replace value of (TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/@generateNewGuid)[1] with (sql:variable("@generateNewGuid"))')
	ELSE
	SET @jobRequestXML.modify('
		  insert(
				attribute generateNewGuid {sql:variable("@generateNewGuid")}
			    )
		  into ((/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption)[1])')
	SET @i = 1
	SELECT @cnt = @jobRequestXML.value('count(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions)','INT')
	WHILE @i <= @cnt
	BEGIN
		SELECT @VMName = @jobRequestXML.value('((TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions/@name)[sql:variable("@i")])[1]','nvarchar(255)')
		SELECT @VMGUID = @jobRequestXML.value('((TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions/@guid)[sql:variable("@i")])[1]','nvarchar(255)')
		SET @NewVMName = @VMName+'_'+CAST(@i_jobId AS VARCHAR(31))
		IF isnull(@useAllocationPolicyForRestore,0) = 1
		BEGIN
			SELECT @NewVMName = @jobRequestXML.value('((TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions/@newName)[sql:variable("@i")])[1]','nvarchar(255)')
		END
		IF @vmAllocPolicyType = 13 -- VMWare Restore Lab Template
			SET @FolderPath = '/'+@DatacenterName+'/'+@NewVMName
		ELSE IF @vmAllocPolicyType = 12 -- Hyper-V Restore Lab Template
			SET @FolderPath = REPLACE(@dataStoreName+'\'+@NewVMName, '\\','\')
		--Replacing double slash with single slash from the harddiskfolder path
		SET @HardDiskFolderPath = REPLACE(@dataStoreName+'\'+@NewVMName +'\Hard Disks', '\\','\')
		SET @jobRequestXML.modify('delete ((TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions/@esxHost)[sql:variable("@i")])[1] ')
		SET @jobRequestXML.modify('delete ((TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions/@Datastore)[sql:variable("@i")])[1] ')
		SET @jobRequestXML.modify('delete ((TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions/@FolderPath)[sql:variable("@i")])[1] ')
		SET @jobRequestXML.modify('delete ((TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions/@newName)[sql:variable("@i")])[1] ')
		SET @jobRequestXML.modify('
		  insert(
				attribute esxHost {sql:variable("@esxServerName")},
				attribute Datastore {sql:variable("@dataStoreName")},
				attribute newName {sql:variable("@NewVMName")}
			    )
		  into ((/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions)[sql:variable("@i")])[1]')
		IF @vmAllocPolicyType = 13 -- VMWare Restore Lab Template
			SET @jobRequestXML.modify('
		  insert(
				attribute FolderPath {sql:variable("@FolderPath")}
			    )
		  into ((/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions)[sql:variable("@i")])[1]')
		ELSE IF @vmAllocPolicyType = 12 -- Hyper-V Restore Lab Template
		BEGIN
			SET @jobRequestXML.modify('delete ((TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions/@DestinationPath)[sql:variable("@i")])[1] ')
			SET @jobRequestXML.modify('
		  insert(
				attribute DestinationPath {sql:variable("@FolderPath")}
			    )
		  into ((/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions)[sql:variable("@i")])[1]')
		END
		SET @jobRequestXML.modify('replace value of (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/virtualLabOption/vmGroups/vmSequence/vmInfo[@vmGUID=sql:variable("@VMGUID")]/@vmName)[1]
					with (sql:variable("@NewVMName"))')
		SET @j = 1
		SET @diskCnt = 0
		SELECT @diskCnt = @jobRequestXML.value('count(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/disks)','INT')
		WHILE @j <= @diskCnt
		BEGIN
			IF @vmAllocPolicyType = 12 -- Hyper-V Restore Lab Template
			BEGIN
				SET @jobRequestXML.modify('replace value of (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/disks[sql:variable("@j")]/@Datastore)[1]
					with ""')
				IF @jobRequestXML.exist('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/disks[sql:variable("@j")]/@DestinationPath)[1]') = 1
					SET @jobRequestXML.modify('replace value of (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/disks[sql:variable("@j")]/@DestinationPath)[1]
					with (sql:variable("@HardDiskFolderPath"))')
				ELSE
					SET @jobRequestXML.modify('
						insert(
							attribute DestinationPath {sql:variable("@HardDiskFolderPath")}
							 )
						 into (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/disks[sql:variable("@j")])[1]')
			END
			ELSE -- VMWare Restore Lab or Regular Restore
				IF @jobRequestXML.exist('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/disks[sql:variable("@j")]/@Datastore)[1]')=1
					SET @jobRequestXML.modify('replace value of (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/disks[sql:variable("@j")]/@Datastore)[1]
						with (sql:variable("@dataStoreName"))')
				ELSE
					SET @jobRequestXML.modify('
						insert(
							attribute Datastore {sql:variable("@dataStoreName")}
							 )
						 into (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/disks[sql:variable("@j")])[1]')
			SET @j += 1
		END
		DECLARE @tempNetworkLabel NVARCHAR(255)
		SET @k = 1
		SET @nicCnt = 0
		SELECT @nicCnt = @jobRequestXML.value('count(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/nics)','INT')
		WHILE @k <= @nicCnt
		BEGIN
			IF @vmAllocPolicyType = 12 -- Hyper-V Restore Lab Template
			BEGIN
				SET @tempNetworkLabel = @networkNameLabel + ' ' + CAST(@k as nvarchar(10))
				IF @jobRequestXML.exist('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/nics[sql:variable("@k")]/@name)[1]') = 1
					SET @jobRequestXML.modify('replace value of (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/nics[sql:variable("@k")]/@name)[1]
							with (sql:variable("@tempNetworkLabel"))')
				ELSE
					SET @jobRequestXML.modify('
						insert(
								attribute name {sql:variable("@tempNetworkLabel")}
							)
						into (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/nics[sql:variable("@k")])[1]')
			END
			--useAllocationPolicyForRestore set to 1, then replace the destinationNetwork with networkName
			IF (@createIsolatedNetwork = 0 OR @useAllocationPolicyForRestore = 1)
			BEGIN
				SET @jobRequestXML.modify('delete (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/nics[sql:variable("@k")])[1]/@destinationNetwork' )
				SET @jobRequestXML.modify('insert ( attribute destinationNetwork {sql:variable("@networkName")}) into  (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/nics[sql:variable("@k")])[1]' )
				SET @jobRequestXML.modify('replace value of (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions[sql:variable("@i")]/nics[sql:variable("@k")]/@networkName)[1] with (sql:variable("@networkName"))')
			END
			SET @k += 1
		END
		SET @i += 1
	END
	DECLARE @tbl TABLE (vmGUID varchar(255), XMLSTr XML)
	INSERT INTO @tbl
	SELECT D.n.value('@guid','varchar(255)'), D.n.query('.') FROM @jobRequestXML.nodes('/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions') D(n)
	UPDATE J
	SET value = CAST(XMLSTr AS NVARCHAR(MAX))
	FROM TM_JobOptions J INNER JOIN @tbl T
		ON optionId = 1003858335 AND jobId = @i_jobId AND (CAST(J.value AS XML)).value('(advancedRestoreOptions/@guid)[1]','varchar(255)') = T.vmGUID
	IF @vmAllocPolicyType = 12 -- Hyper-V Restore Lab Template
	BEGIN
		--fetching member servers from the both client/client group level.
		CREATE TABLE #tmpTable
	    (
	        OutputValue XML
		)
		DECLARE @destinationVendor INT
		DECLARE @inXML xml
		DECLARE @VsMemberServersXML XML
		SET @inXML = (
						SELECT '1' as '@expandClientGroup',
						(
							SELECT @instanceId as '@instanceId',
								'5' as '@_type_'
								FOR XML PATH ('entity'), TYPE
						)
						FOR XML PATH ('App_GetVSMemberServersRequest')
					)
		--SET @esxServerName = (SELECT attrVal FROM App_InstanceProp WHERE componentNameId = @instanceId AND attrName =  'Virtual Server Host')
		INSERT INTO #tmpTable
			exec AppGetVSMemberServers @inXML
		SELECT @VsMemberServersXML = OutputValue FROM #tmpTable
		DROP TABLE #tmpTable
			SET @destinationVendor = 2
			SET @vCenterName = ''
			SELECT @destinationClientName = V.n.value('(client/@clientName)[1]','nvarchar(255)'), @destinationClientId = V.n.value('(client)[1]/@clientId','nvarchar(255)')
			FROM APP_Client C
			INNER JOIN @VsMemberServersXML.nodes('App_GetVSMemberServersResponse/associatedClients/memberServers') V(n)
			ON V.n.value('(client)[1]/@clientId','nvarchar(255)') = c.id
			WHERE (V.n.value('(client/@clientName)[1]','nvarchar(255)') =  @esxServerName
				 or @esxServerName = (CASE When CHARINDEX('.', C.net_hostname) > 0 THEN SUBSTRING(C.net_hostname, 1, CHARINDEX('.',C.net_hostname)-1) ELSE net_hostname END))
	END
	ELSE
	BEGIN
		SET @destinationVendor = 1
		IF @isVirtualLabRestoreJob = 1 AND  isnull(@jobRequestXML.value('(/TMMsg_JobOption/restoreOptions/destination/destClient/@clientId)[1]','int'),0) > 0
		BEGIN
			--if the destinationClient picked in the GUI for vmware restore as lab job, then we should use that proxy for restore.
			SET @destinationClientName = @jobRequestXML.value('(/TMMsg_JobOption/restoreOptions/destination/destClient/@clientName)[1]','nvarchar(255)')
			SET @destinationClientId = @jobRequestXML.value('(/TMMsg_JobOption/restoreOptions/destination/destClient/@clientId)[1]','int')
		END
		ELSE
		BEGIN
			SET @destinationClientName = @virtualizationClientName
			SET @destinationClientId = @virtualizationClientId
		END
	END
	IF ISNULL(@destinationClientName,'') = '' AND ISNULL(@destinationClientId,0) <= 0
	BEGIN
		-- Handle this case as current selected host is not available in VS Members
		SELECT @o_errorCode = 1, @o_errorString = 'Error: Selected host is not available in Proxy list'
		GOTO ERROR_EXIT
	END
	--adding cross restore support by adding proper vendor type
	IF @jobRequestXML.exist('(TMMsg_JobOption/restoreOptions/volumeRstOption/@destinationVendor)[1]') = 1
		SET @jobRequestXML.modify('replace value of (TMMsg_JobOption/restoreOptions/volumeRstOption/@destinationVendor)[1] with (sql:variable("@destinationVendor"))')
	ELSE
		SET @jobRequestXML.modify('
			 insert(
					attribute destinationVendor {sql:variable("@destinationVendor")}
			    )
			 into ((/TMMsg_JobOption/restoreOptions/volumeRstOption)[1])')
	--destination esxservername should be vcenter name in case of vmware.
	IF @jobRequestXML.exist('(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/@esxServerName)[1]') = 1
	SET @jobRequestXML.modify('replace value of (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/@esxServerName)[1]
					with (sql:variable("@vCenterName"))')
	ELSE
		SET @jobRequestXML.modify('
                        insert(
                            attribute esxServerName {sql:variable("@vCenterName")}
                             )
                         into (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption)[1]')
	SET @jobRequestXML.modify('delete (/TMMsg_JobOption/restoreOptions/virtualServerRstOption/vCenterInstance)[1]')
	IF @jobRequestXML.exist('/TMMsg_JobOption/restoreOptions/virtualServerRstOption/vCenterInstance') = 0
	BEGIN
		DECLARE @vcenterInstanceXML XML = (SELECT @virtualizationClientName AS '@clientName',
			@virtualizationClientId AS '@clientId',
			@instanceId AS '@instanceId'
		FOR XML PATH('vCenterInstance'))
		SET @jobRequestXML.modify('insert (sql:variable("@vcenterInstanceXML")) into (/TMMsg_JobOption/restoreOptions/virtualServerRstOption)[1]')
	END
	SET @jobRequestXML.modify('delete (/TMMsg_JobOption/restoreOptions/destination)[1]')
	IF @jobRequestXML.exist('/TMMsg_JobOption/restoreOptions/destination') = 0
	BEGIN
		DECLARE @destinationCLientXML XML = (SELECT 0 AS '@inPlace',
			(SELECT @destinationClientId AS '@clientId',
					@destinationClientName AS '@clientName'
			FOR XML PATH('destClient'), TYPE)
		FOR XML PATH('destination'))
		SET @jobRequestXML.modify('insert (sql:variable("@destinationCLientXML")) into (/TMMsg_JobOption/restoreOptions)[1]')
	END
	IF NOT EXISTS (SELECT * FROM TM_JobOptions WHERE optionId = 293753447 AND jobId = @i_jobId)
	BEGIN
		INSERT INTO TM_JobOptions
		VALUES(@i_jobId, 293753447, 7, CAST(@destinationClientId AS VARCHAR(1024)), @taskId, @subTaskId, 0, dbo.getunixtime(GETDATE()), 0)
	END
	ELSE
	BEGIN
		UPDATE TM_JobOptions
			SET value =  CAST(@destinationClientId AS VARCHAR(1024))
			WHERE optionId = 293753447 AND jobId = @i_jobId
	END
	IF NOT EXISTS (SELECT * FROM TM_JobOptions WHERE optionId = 1170928521 AND jobId = @i_jobId)
	BEGIN
		INSERT INTO TM_JobOptions
		VALUES (@i_jobId, 1170928521, 1, @destinationClientName, @taskId, @subTaskId, 0, dbo.getunixtime(GETDATE()), 0)
	END
	ELSE
	BEGIN
		UPDATE TM_JobOptions
			SET value =  @destinationClientName
			WHERE optionId = 1170928521 AND jobId = @i_jobId
	END
	--set destination vendor to job options table
	IF NOT EXISTS (SELECT * FROM TM_JobOptions WHERE optionId = 1419848658 AND jobId = @i_jobId)
	BEGIN
		INSERT INTO TM_JobOptions
		VALUES(@i_jobId, 1419848658, 7, CAST(@destinationVendor AS VARCHAR(1024)), @taskId, @subTaskId, 0, dbo.getunixtime(GETDATE()), 0)
	END
	ELSE
	BEGIN
		UPDATE TM_JobOptions
			SET value =  CAST(@destinationVendor AS VARCHAR(1024))
			WHERE optionId = 1419848658 AND jobId = @i_jobId
	END
	UPDATE TM_JobXMLOptions
	SET xmlValue = @jobRequestXML
	WHERE jobId = @i_jobId and taskId = @taskId AND subTaskId = @subTaskId AND modified = 0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @o_errorCode = ERROR_NUMBER()
SET @o_errorString = ERROR_MESSAGE()
END CATCH
ERROR_EXIT:
	SELECT @o_errorCode as errorCode, @o_errorString as errorString
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'VMP_ModifyRestoreTaskReq')
	delete from GxQscripts where name = 'VMP_ModifyRestoreTaskReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_ModifyRestoreTaskReq')
	delete from GXDBVersions where aliasname = 'VMP_ModifyRestoreTaskReq'
GO

insert into GXDBVersions values(2, 'VMP_ModifyRestoreTaskReq',  '00010001000200210000', 'VMP_ModifyRestoreTaskReq', '00010001000200210000')
GO

