

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_MigrateVM.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_MigrateVM.sp,v $ $Id: VMP_MigrateVM.sp,v 1.1.2.10 2018/07/23 18:37:24 pktr Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "GetDataCenterList"
--	|	This Procedure is used to get the list of available data centers
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_MigrateVM <<<'

IF EXISTS (select * from sysobjects where name='VMP_MigrateVM')
	drop procedure VMP_MigrateVM
IF EXISTS (select * from GxQscripts where name='VMP_MigrateVM')
	delete from GxQscripts where name = 'VMP_MigrateVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_MigrateVM')
	delete from GXDBVersions where aliasname = 'VMP_MigrateVM'
GO
print '... Creating Procedure: VMP_MigrateVM'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_MigrateVM
-- Input arguments
  @i_userId INT,
  @i_VMGUID varchar(1024),
  @i_vmAllocPolicyId INT,
  @i_forceMigrate INT = 0
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @o_errorCode INT 
  DECLARE @o_errorString NVARCHAR(1024) 
  DECLARE @o_srcEsxServerName NVARCHAR(512)  
  DECLARE @o_VMId INT
  DECLARE @o_VMGUID VARCHAR(256)
  DECLARE @o_VMName NVARCHAR(1024)
  DECLARE @o_destEsxServerName NVARCHAR(512)
  DECLARE @o_dataStoreName NVARCHAR(512)
  DECLARE @o_vmCount INT
  DECLARE @o_totalMemoryGB INT
  DECLARE @o_freememoryPct INT
  DECLARE @o_totalSpaceGB INT
  DECLARE @o_freeSpacePct INT
  DECLARE @o_esxtimeStamp VARCHAR(20)
  DECLARE @o_dstimeStamp VARCHAR(20)
BEGIN TRY
-- request :<Ida_VMOpReq><vmInfo isPhysical="0" isTemplate="0" memory="2048" numberOfCPUs="2" numberOfNICs="4" operatingSystem="Microsoft Windows Server 2008 (64-bit)" purpose="" vmAllocPolicyId="3" vmState="0"><vm _type_="88" vmName="t.t.ttt.commvault.com"/><vmLocation dataCenterName="Commvault-DC" hostName="" vCenter="usint13"><dcUserInfo password="||#4!MWVodG40dGZhNGY0bnRJdHo0Ym5Zbm4=&#xA;" userName="administrator"/><datastore name=""/></vmLocation><hardDisks><hardDisk diskSize="112640" diskType="2" label="Hard disk 1"/><hardDisk diskSize="61440" diskType="1" label="Hard disk 2"/></hardDisks><expirationTime time="1300766400"/></vmInfo><vmEntity _type_="88" clientId="89" commCellId="0" type="0" vmGUID="421b9c6b-9172-73dc-92a8-f0a631cd7a20" vmName="template-win2k8r2-2"/></Ida_VMOpReq>
	SET NOCOUNT ON
	DECLARE @VMClientId				INT = 0
	DECLARE @VMGUID					VARCHAR(256)
	DECLARE @vmName					VARCHAR(512)
	DECLARE @vendorType				INT
	DECLARE @vmAllocPolicy			XML
	DECLARE @esxServerCount			INT
	DECLARE @dataStoreCount			INT
	DECLARE @esxServerName			VARCHAR(256)
	DECLARE @dataStoreName			VARCHAR(256)
	DECLARE @diskSize				bigint =0
	DECLARE @esxServerId			INT
	DECLARE @dataStoreId			INT
	DECLARE @dataCenterId			INT
	DECLARE @value					float
	DECLARE @isLiveMountPolicy		INT = 0
	DECLARE @policyType				INT = 0
	DECLARE @isRestoreLabPolicy		INT = 0
	DECLARE @minDiskSize			BIGINT = 0
	DECLARE @dsFreePerc				INT=0
	DECLARE @counter				INT = 0
	DECLARE @isAutoMigrationEnabled INT = 0
	DECLARE @policyName				VARCHAR(256)
	DECLARE @vmMemory				BIGINT
	--Check if any tmp table is existing before then drop it
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @o_errorCode = 0
    SET @o_errorString = 'Success'
	SELECT @VMClientId = clientId,
		   @vmName = name
	FROM App_VM WHERE GUID = @i_VMGUID
	IF LEN(@i_VMGUID) > 0  AND @VMClientId = 0
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'Invalid VM GUID supplied to the stored procedure.'
		GOTO ERROR_EXIT
	END
	IF OBJECT_ID('tempdb..#Output') IS NOT NULL DROP TABLE #Output
	CREATE TABLE #Output
	(
		id INT, errorCode INT, errorString varchar(1024), srcHostId INT, VMId INT, VMName VARCHAR(256),
		HostId INT, HostName VARCHAR(256), TotalMemory BIGINT, freememoryPct DECIMAL(20,2), VMCount INT,
		DataStoreId INT, DataStoreName VARCHAR(256), CapacityMB BIGINT, FreePerc DECIMAL(20,2)
	)
	IF @VMClientId > 0
	BEGIN
		SELECT @isAutoMigrationEnabled = ISNULL(P.vxml.value('(policy/@performAutoMigration)[1]','INT'), 0),
			   @policyName = P.name
			FROM App_VMAllocationPolicy P
				INNER JOIN App_VM VM
					ON P.id = VM.vmAllocationPolicyId
						AND VM.clientId = @VMClientId
		IF @isAutoMigrationEnabled = 0 AND @i_forceMigrate = 0
		BEGIN
			SET @o_errorCode = 1
			SET @o_errorString = 'Auto VM Migration is not enabled for policy ['+@policyName+']. So, skipping migration check for VM ['+@vmName+'].'
			GOTO ERROR_EXIT
		END
		-- For now, migration is supported only acorss hosts with shared datastore (hyper-v cluster)
		-- Once we start supporting migration across datastore, uncomment the code below with -%%- in the comment line
		DECLARE @esxTotalCapacity BIGINT = 0, @esxUsedCapacity BIGINT = 0, @dsTotalCapacity BIGINT = 0, @dsFreeSpace BIGINT = 0
		DECLARE @vmXML XML, @isClustered INT = 0, @clusterName NVARCHAR(512) = ''
		SELECT TOP 1
			   @vmName = VM.name,
			   @VMGUID = VM.GUID,
			   @esxServerId = VM.vHostId,
			   @esxServerName = H.name,
			   @i_vmAllocPolicyId = VM.vmAllocationPolicyId,
			   @dataCenterId = H.vDatacenterId,
			   @dataStoreId = ISNULL(DS.id, -1),		-- This may not be present for Hyper-V
			   @dataStoreName = DS.name,	-- This may not be present for Hyper-V
			   @vmXML = VM.vxml,
			   @vendorType = VM.vxml.value('(/QSMServer_QVirtualMachineReq/@vendorType)[1]','INT'),
			   @vmMemory = VM.vxml.value('(QSMServer_QVirtualMachineReq/memory)[1]/@memorySizeMB', 'bigint')/1024/1024/1024,
			   -- Following property is set as 1 when it's not present coz there is some issue with collecting this property. Set it to 0 once that property collection works fine
			   @isClustered = ISNULL(H.vxml.value('(/QSMServer_QVirtualHostReq/@bClustered)[1]','INT'), 1),
			   @clusterName = ISNULL(H.vxml.value('(/QSMServer_QVirtualHostReq/@clusterName)[1]','NVARCHAR(512)'), '')
		FROM app_VM VM
			INNER JOIN App_VMHost H
				ON VM.vHostId = H.id AND VM.clientId = @VMClientId
			LEFT JOIN APP_VMDataStore DS
				ON ISNULL(VM.vxml.value('(/QSMServer_QVirtualMachineReq/storage/machineFileInfo/machineFiles/@dataStore)[1]','nvarchar(256)'), '') = DS.name
					AND DS.vDataCenterId = H.vDataCenterId
		WHERE VM.removalTimeStamp IS NULL AND DS.removalTimeStamp IS NULL
		IF @vendorType = 102 AND @isClustered = 0
		BEGIN
			SET @o_errorCode = 1
			SET @o_errorString = 'For Hyper-V VMs, Live migration is not supported on non-clustered hosts'
			GOTO ERROR_EXIT
		END
		SELECT
			@esxTotalCapacity = (mem.value('@MemoryTotalCapacity','bigint'))/(1024*1024),
			@esxUsedCapacity  = (mem.value('@MemoryReservedCapacity','bigint'))/(1024*1024)
		FROM App_VMHost AS vh
			CROSS APPLY vh.vxml.nodes('QSMServer_QVirtualHostReq') AS Hosts(h)
			CROSS APPLY  h.nodes('./cpuInfo') AS CPU(cpu)
			CROSS APPLY h.nodes('./memInfo') AS Memory(mem)
		WHERE vh.id = @esxServerId
		-- Check for datastore capacity limit only for VMWare as for Hyper-V datastore migration is not supported yet. SO, the VM has to be moved to a host which has same dataStore.
		IF @vendorType = 101
		BEGIN
			SELECT
				@dsTotalCapacity = d.value('@capacity', 'bigint'),
				@dsFreeSpace = d.value('@freeSpace', 'bigint')
			FROM App_VMDataStore AS ds
				CROSS APPLY ds.vxml.nodes('datastores') AS DataStore(d)
			WHERE ds.id = @dataStoreId AND ds.removalTimeStamp IS null
			-- 30% allowance should be considered for DataStore
			IF @vmAllocPolicy.exist('(policy/serverFreePercentage/@isEnabled)[1]') = 1 AND @vmAllocPolicy.value('(policy/serverFreePercentage/@isEnabled)[1]','int') = 1
			BEGIN
				SET @dsFreePerc  = ISNULL(@vmAllocPolicy.value('(policy/serverFreePercentage/@datastorePercentage)[1]','int'),0)
			END
			ELSE
			BEGIN
				SELECT @dsFreePerc = CAST(ISNULL(VALUE,0) AS INT) FROM GXGLOBALPARAM WHERE NAME = 'DataStoreFreeSpacePercentage'
			END
			IF @dsFreePerc = 0
				SET @dsFreePerc = 10
		END
		-- 10% allowance should be considered for EsxServer
		DECLARE @esxMemFreePerc INT=0;
		IF @vmAllocPolicy.exist('(policy/serverFreePercentage/@isEnabled)[1]') = 1 AND @vmAllocPolicy.value('(policy/serverFreePercentage/@isEnabled)[1]','int') = 1
		BEGIN
			SET @esxMemFreePerc = ISNULL(@vmAllocPolicy.value('(policy/serverFreePercentage/@memoryPercentage)[1]','int'),0)
		END
		ELSE
		BEGIN
			SELECT @esxMemFreePerc = CAST(ISNULL(VALUE,0) AS INT) FROM GXGLOBALPARAM WHERE NAME = 'ProvisioningServerMemoryFreePercentage'
		END
		IF @esxMemFreePerc = 0
			SET @esxMemFreePerc = 10
		-- Check for critical state
		IF (((@esxTotalCapacity - @esxUsedCapacity - @vmMemory)*1.0/@esxTotalCapacity*1.0 ) *100 < @esxMemFreePerc) OR (@vendorType = 101 AND @dsFreeSpace <= (@dsTotalCapacity*1.0*((@dsFreePerc*1.0)/100.0)))
		BEGIN
			-- Try to find out better host on cluster as per calculated by best location SP
			DECLARE @formRequest XML = (SELECT @i_vmAllocPolicyId AS 'vmInfo/@vmAllocPolicyId',
				  (SELECT SUM(H.n.value('@capacityInKb', 'bigint'))
						 FROM @vmXML.nodes('QSMServer_QVirtualMachineReq/hardDisks/hardDisk') H(n))/1024/1024/1024 AS 'vmInfo/hardDisks/hardDisk/@diskSize'
			FOR XML PATH('Ida_VMOpReq'))
			DECLARE @bestLocationServers TABLE (
						o_rank			 float,
                        errorCode        INT,
                        errorMessage     NVARCHAR(512),
                        esxServerName    VARCHAR(256),
                        dataStoreName    VARCHAR(256),
                        VMCount          INT,
                        TotalMemory      INT,
                        freememoryPct    INT,
                        totalSpaceGB     INT,
                        freeSpacePct     INT,
                        esxtimeStamp     VARCHAR(20),
                        dstimeStamp      VARCHAR(20)
                    )
			INSERT INTO @bestLocationServers
			EXEC VMP_BestLocation @i_userId, @formRequest, 1
			SELECT TOP 1 @o_errorCode = errorCode FROM @bestLocationServers
			IF @o_errorCode <> 0
			BEGIN
				SELECT TOP 1 errorCode, errorMessage, @esxServerName, @VMClientId, @VMGUID, @vmName, '', '', 0, 0, 0, 0, 0, '', ''
				FROM @bestLocationServers
			END
			ELSE
			BEGIN
				DECLARE @prospectiveHosts TABLE (hostName VARCHAR(256))
				IF @vendorType = 102 --AND ISNULL(@clusterName,'') <> ''
				BEGIN
					INSERT INTO @prospectiveHosts(hostName)
					SELECT H.name
					FROM App_VMHost H
					WHERE removalTimeSTamp IS NULL AND H.vxml.value('(/QSMServer_QVirtualHostReq/@vendorType)[1]','INT') = 102
						  AND ISNULL(H.vxml.value('(/QSMServer_QVirtualHostReq/@clusterName)[1]','NVARCHAR(512)'), '') = @clusterName
				END
				SELECT TOP 1 errorCode, errorMessage,
					--(SELECT DC.name from App_VMHost H INNER JOIN App_VMDataCenter DC ON H.vdatacenterId = DC.id AND H.name = esxServerName) AS vCenter,
					@esxServerName, @VMClientId, @VMGUID, @vmName, esxServerName, dataStoreName, VMCount, TotalMemory, freememoryPct, totalSpaceGB, freeSpacePct, esxtimeStamp, dstimeStamp
				FROM @bestLocationServers
				WHERE @vendorType = 101 OR ( @vendorType = 102 AND dataStoreName = ISNULL(@dataStoreName, dataStoreName) AND esxServerName IN (SELECT hostName FROM @prospectiveHosts))
				ORDER BY o_rank desc
			END
		END
	END
	ELSE IF @i_vmAllocPolicyId > 0
	BEGIN
		DECLARE @instanceId INT = (SELECT TOP 1 instanceId FROM App_VMAllocationPolicy P
									INNER JOIN App_VMDataCenterMap M
										ON P.vDataCenterId = M.vDataCenterId AND P.id = @i_vmAllocPolicyId)
		SET @vendorType = (SELECT CAST(attrVal AS INT) FROM App_InstanceProp IP
							WHERE IP.componentNameId = @instanceId AND IP.attrName = 'Virtual Server Instance Type')
		DECLARE @vmPolicyType INT = (SELECT vxml.value('(policy/entity/@policyType)[1]','int') FROM App_VMAllocationPolicy WHERE id = @i_vmAllocPolicyId)
		--Check if any tmp table is existing before then drop it
 		IF object_id('tempdb.dbo.#hostInfo') is not null
			DROP TABLE #hostInfo
		--Check if any tmp table is existing before then drop it
		IF object_id('tempdb.dbo.#dataStores') is not null
			DROP TABLE #dataStores
		IF object_id('tempdb.dbo.#VMProgressDetails') is not null
			DROP TABLE #VMProgressDetails
		--Create the tmp table
		CREATE TABLE #hostInfo (
									   HostId	integer,
									   HostTotalMemMB	bigint,
									   HostFreeMemMB	bigint,
									   vmCount		integer,
									   totalCPU		integer,
									   rank			decimal(10,2) DEFAULT(0),
									   status  INT,
									   isDiscarded int default 0
										)
		CREATE TABLE #dataStores (
										dataStoreId	integer,
										dataStoreName nvarchar(256),
										 DSCapacityMB bigint,
										 DSFreeSapceMB bigint,
										 status INT,
										 isDiscarded int default 0
										 )
		CREATE TABLE #VMProgressDetails
		(
			hostName  varchar(256),
			volumeName varchar(256),
			memory    bigint,
			size      bigint
		)
		INSERT INTO #hostInfo ( HostId)
			SELECT vmProp.attrVal FROM APP_VMAllocationPolicyProp vmProp  WITH(NOLOCK)
				INNER JOIN APP_VMHost vHost WITH(NOLOCK)
					ON vmProp.attrName ='esxserver'
						AND vHost.removalTimeStamp IS NULL
						AND vHost.id = vmProp.attrVal
				INNER JOIN APP_VMAllocationPolicy vmPolicy
					on vmPolicy.id = vmProp.componentNameId
						AND vmPolicy.id = @i_vmAllocPolicyId
						AND alive=1
		INSERT INTO #hostInfo ( HostId)
			SELECT vHost.id FROM
				APP_VMHost vHost  WITH(NOLOCK)
				INNER JOIN APP_VMAllocationPolicy vmPolicy  WITH(NOLOCK)
					on vmPolicy.vDataCenterId = vHost.VDataCenterId
						AND vmPolicy.id = @i_vmAllocPolicyId
						AND vmPolicy.vxml.value('(policy/@allESXServersSelected)[1]','int') = '1'
						AND vHost.removalTimeStamp IS NULL
		update #hostInfo set status = 2 -- GOOD
		INSERT INTO #dataStores (dataStoreId, dataStoreName)
			SELECT vmProp.attrVal, vDS.name FROM APP_VMAllocationPolicyProp vmProp  WITH(NOLOCK)
				INNER JOIN APP_VMDataStore vDS  WITH(NOLOCK)
					ON vmProp.attrName ='datastore'
						AND vDS.removalTimeStamp IS NULL
				INNER JOIN APP_VMAllocationPolicy vmPolicy
					on vmPolicy.id = vmProp.componentNameId
						AND vmPolicy.id = @i_vmAllocPolicyId
						AND vDS.id = vmProp.attrVal
		INSERT INTO #dataStores ( dataStoreId, dataStoreName)
			SELECT vDS.id, vDS.name
				FROM APP_VMDataStore vDS  WITH(NOLOCK)
				INNER JOIN APP_VMAllocationPolicy vmPolicy   WITH(NOLOCK)
					on vmPolicy.vDataCenterId = vDS.VDataCenterId
						AND vmPolicy.id = @i_vmAllocPolicyId
						AND vmPolicy.vxml.value('(policy/@allDataStoresSelected)[1]','int') = '1'
						AND vDS.removalTimeStamp IS NULL
		update #dataStores set status =2 --'Good'
		UPDATE #dataStores
			SET DSCapacityMB = dsTotalCapacity,
			DSFreeSapceMB = dsFreeSapce
			FROM #dataStores
			INNER JOIN ( SELECT ds.id,
								d.value('@capacity', 'bigint')/1024 AS dsTotalCapacity,
								d.value('@freeSpace', 'bigint')/1024 AS dsFreeSapce
						 FROM APP_VMDataStore AS ds  WITH(NOLOCK)
						 CROSS APPLY ds.vxml.nodes('datastores') AS DataStore(d)
						 WHERE ds.id in ( SELECT dataStoreId FROM #dataStores)
						 AND ds.removalTimeStamp IS null )	AS dataStores ON
			dataStores.id = dataStoreId
		IF @vmAllocPolicy.exist('(policy/serverFreePercentage/@isEnabled)[1]') = 1 AND @vmAllocPolicy.value('(policy/serverFreePercentage/@isEnabled)[1]','int') = 1
		BEGIN
			SET @dsFreePerc = ISNULL(@vmAllocPolicy.value('(policy/serverFreePercentage/@datastorePercentage)[1]','int'),0)
		END
		ELSE
		BEGIN
			SELECT @dsFreePerc = CAST(ISNULL(VALUE,0) AS INT) FROM GXGLOBALPARAM WHERE NAME = 'DataStoreFreeSpacePercentage'
		END
		IF @dsFreePerc = 0
			SET @dsFreePerc = 10
		UPDATE #dataStores set isDiscarded =1, status = 0 --'Free Space < ' + CAST(@dsFreePerc as varchar(5))
		WHERE (DSFreeSapceMB - 100*1024) < DSCapacityMB * (@dsFreePerc/100.0)
		UPDATE  #hostInfo
			SET vmCount = host.vsHostVMCount,
			HostTotalMemMB = CASE WHEN @vmPolicyType = 2 THEN host.vsMemoryTotalCapacity * 1024 ELSE host.vsMemoryTotalCapacity END,
			HostFreeMemMB = CASE WHEN @vmPolicyType = 2 THEN (host.vsMemoryTotalCapacity - host.vsMemoryUsed) * 1024 ELSE (host.vsMemoryTotalCapacity - host.vsMemoryUsed) END,
			totalCPU = host.vsCPUTotalCapacity
		FROM #hostInfo
		INNER JOIN (
			SELECT
				vh.id,
				h.value('@numVMsAndTemplates','integer') AS vsHostVMCount,
				h.value('@numCpuCores','integer') AS vsCPUCores,
				(mem.value('@MemoryTotalCapacity','bigint'))/(1024*1024) AS vsMemoryTotalCapacity,
				(mem.value('@MemoryReservedCapacity','bigint'))/(1024*1024) AS vsMemoryUsed,
				cpu.value('@CPUTotalCapacity','integer') AS vsCPUTotalCapacity,
				cpu.value('@overallCpuUsage','integer') AS vsCPUUsed
			FROM APP_VMHost AS vh  WITH(NOLOCK)
			CROSS APPLY vh.vxml.nodes('QSMServer_QVirtualHostReq') AS Hosts(h)
			CROSS APPLY  h.nodes('./cpuInfo') AS CPU(cpu)
			CROSS APPLY h.nodes('./memInfo') AS Memory(mem)
			WHERE vh.id in ( SELECT HostId FROM #hostInfo)
		) AS host ON
		host.id = #hostInfo.HostId
		;with cte
		as
		(
		SELECT cast(T.value as xml) as val FROM JMJobInfo JI
		INNER JOIN JMAdminJobInfoTable JA ON JI.jobId = JA.jobId
		AND JI.opType = 85
		CROSS APPLY GetAllJobOptions(JI.jobId) AS T
		WHERE  T.optionId = 30050685
		AND ISNULL((CAST(T.value as xml).value('virtualMachineOption[1]/vmAllocPolicy[1]/@vmAllocPolicyId', 'INT')), 0) = 14
		)
		, cte2
		as
		(
			select cte.val.value('(virtualMachineOption/vmInfo/vmLocation)[1]/@hostName', 'nvarchar(256)') as hostName,
					cte.val.value('(virtualMachineOption/vmInfo/vmLocation/datastore)[1]/@name', 'nvarchar(256)') as dataStore,
					cte.val.value('(virtualMachineOption/vmInfo)[1]/@memory', 'bigint')/2048 as memory,
					(select
					sum(d.value('@diskSize', 'bigint'))/2
					from cte
					CROSS APPLY cte.val.nodes('virtualMachineOption/vmInfo/hardDisks/hardDisk') AS DataStore(d))  as size
			from cte
		)
		insert into #VMProgressDetails
		select hostName, dataStore, memory*1024,  size  from cte2
		UPDATE HI
		SET HostFreeMemMB -= memory
		FROM #hostInfo HI
			INNER JOIN App_VMHost H
				ON HI.HostId = H.id
			INNER JOIN (SELECT hostName, SUM(memory) AS memory FROM #VMProgressDetails GROUP BY hostName) V
				ON H.Name = V.hostName
		UPDATE HI
		SET vmCount += t.vmcount
		from #hostInfo HI
			INNER JOIN App_VMHost H
				ON HI.HostId = H.id
			INNER JOIN ( select count(*) as vmcount, hostname from #VMProgressDetails group by hostname) t
				ON H.Name = t.hostName
		UPDATE DS
		SET DSFreeSapceMB -= size
		FROM #dataStores DS
			INNER JOIN APP_VMDataStore D
				ON DS.dataStoreId = D.id
			INNER JOIN (SELECT volumeName, SUM(size) AS size FROM #VMProgressDetails GROUP BY volumeName) V
				ON D.Name = V.volumeName
		UPDATE #hostInfo set vmCount =1 WHERE vmCount=0
		UPDATE #hostInfo set HostTotalMemMB =1 WHERE HostTotalMemMB =0
		UPDATE #hostInfo set totalCPU =1 WHERE totalCPU=0
		-- 10% allowance should be considered
		DECLARE @memFreePerc INT=0;
		IF @vmAllocPolicy.exist('(policy/serverFreePercentage/@isEnabled)[1]') = 1 AND @vmAllocPolicy.value('(policy/serverFreePercentage/@isEnabled)[1]','int') = 1
		BEGIN
			SET @memFreePerc = ISNULL(@vmAllocPolicy.value('(policy/serverFreePercentage/@memoryPercentage)[1]','int'),0)
		END
		ELSE
		BEGIN
			SELECT @memFreePerc = CAST(ISNULL(VALUE,0) AS INT) FROM GXGLOBALPARAM  WITH(NOLOCK) WHERE NAME = 'ProvisioningServerMemoryFreePercentage'
		END
		IF @memFreePerc = 0
			SET @memFreePerc = 10
		UPDATE #hostInfo  set isDiscarded =1,
		status = 0 --'Memory Free Space < ' + CAST(@memFreePerc as varchar(5))
		WHERE (HostFreeMemMB*1.0/HostTotalMemMB*1.0 ) *100 < @memFreePerc
		UPDATE #hostInfo  set isDiscarded =1,
		status =1 --'Memory Free Space < 20'
			WHERE (HostFreeMemMB*1.0/HostTotalMemMB*1.0 ) *100 < 20
			and (HostFreeMemMB*1.0/HostTotalMemMB*1.0 ) *100 > @memFreePerc
		--SELECT --policyId, policyName as 'VM Policy',
		--	   HostId,
		--	   H.name AS HostName,
		--	   HostTotalMemMB as 'Total Memory(MB)',
		--	   HostFreeMemMB as 'Free Memory(MB)',
		--	   --case when policyType =2 then cast(((HostFreeMemMB)*100.0/HostTotalMemMB*1.0) as int) ELSE cast (((HostFreeMemMB)*100.0/(1024.0*HostTotalMemMB)) as int) end as 'Free Memory (%)',
		--	   vmCount  as 'No. of VMs',
		--	   --t_suspendedVMCount as 'Suspended VMs',
		--	   --t_poweredOffVMCount as 'Powered Off VMs',
		--	   totalCPU as 'totalCPU',
		--	   rank as 'Rank',
		--	   --vmsIn24hrs as 'VMs Created (24 hrs)',
		--	   --vmsIn1hr as 'VMs Created (1 hrs)',
		--	   --deletedvmsIn24hrs as 'VMs Deleted (24 hrs)',
		--	   status as 'Status'
		--FROM #hostInfo T
		--	INNER JOIN App_VMHost H
		--		ON T.hostId = H.id
		--ORDER BY T.hostId
		IF OBJECT_ID('tempdb..#OverLoadedHostVMMap') IS NOT NULL DROP TABLE #OverLoadedHostVMMap
		IF OBJECT_ID('tempdb..#ProspectiveVMs') IS NOT NULL DROP TABLE #ProspectiveVMs
		CREATE TABLE #OverLoadedHostVMMap
		(
			VMId INT, VMDiskSizeMB BIGINT, VMMemorySizeMB BIGINT,
			HostId INT, HostTotalMemMB BIGINT, HostFreeMemMB BIGINT,
			DataStoreName nvarchar(256)
		)
		CREATE TABLE #ProspectiveVMs
		(
			VMid INT, VMDiskSizeMB BIGINT, VMMemorySizeMB BIGINT,
			SrcHostTotalMemMB BIGINT, SrcHostFreeMemMB BIGINT, SrcHostFreePerc DECIMAL(20,2),
			hostId INT, HostTotalMemMB BIGINT, HostFreeMemMB BIGINT, HostFreePerc DECIMAL(20,2), HostVMCount INT, totalCPU INT, Hostrank DECIMAL(20,2),
			DataStoreId INT, DSCapacityMB BIGINT, DSFreeSapceMB BIGINT, DSFreePerc DECIMAL(20,2)
		)
		INSERT INTO #OverLoadedHostVMMap
		SELECT VMId,
			   CASE WHEN HardiskSizeMB = 0 THEN 200*1024 ELSE HardiskSizeMB END, -- Take dummy value as 200GB
			   CASE WHEN VMMemoryMB = 0 THEN 8*1024 ELSE VMMemoryMB END,	-- Take dummy memory as 8 GB
			   HostId,
			   HostTotalMemMB,
			   HostFreeMemMB,
			   DataStoreName
		FROM
		(
			SELECT VM.id AS VMId,
			   (SELECT SUM(H.n.value('@capacityInKb', 'bigint'))
								 FROM VM.vxml.nodes('QSMServer_QVirtualMachineReq/hardDisks/hardDisk') H(n))/1024/1024 AS HardiskSizeMB,
			   VM.vxml.value('(QSMServer_QVirtualMachineReq/memory/@memorySizeMB)[1]', 'bigint')/1024/1024 AS VMMemoryMB,
			   OVH.*,
			   coalesce(VM.vxml.value('(QSMServer_QVirtualMachineReq/storage/dataStoreInfo/datastores/@name)[1]','varchar(256)') ,
					VM.vxml.value('(QSMServer_QVirtualMachineReq/storage/machineFileInfo/machineFiles/@dataStore)[1]','varchar(256)') ) AS DataStoreName
			FROM App_VM VM
				INNER JOIN #hostInfo OVH
					ON	OVH.HostId = VM.vHostId AND OVH.status = 0 AND VM.removalTimeSTamp IS NULL AND VM.vmallocationPolicyId = @i_vmAllocPolicyId
						AND VM.vxml.value('/QSMServer_QVirtualMachineReq[1]/@powerState', 'int') IN (1) --Running ; (0, 2) -- Stopped OR Suspended
						AND VM.vxml.value('/QSMServer_QVirtualMachineReq[1]/@isTemplate', 'int') = 0
		) A
		DECLARE  overloadedeHosts cursor for
		select hostId FROM #hostInfo WHERE status = 0 -- status = 0 means overloaded hosts
		ORDER BY (HostFreeMemMB*1.0/HostTotalMemMB*1.0 ) *100 desc
		DECLARE @hostIdItr int
		DECLARE @VMId INT, @VMMemorySizeMB BIGINT, @VMDiskSizeMB BIGINT, @SrcHostId INT, @srcHostFreePerc DECIMAL(20,2), @DestHostId INT
		OPEN overloadedeHosts
		FETCH NEXT FROM overloadedeHosts into @hostIdItr
		WHILE @@FETCH_STATUS = 0
		BEGIN
			TRUNCATE TABLE #ProspectiveVMs
			SET @o_errorCode = 0
			SET @o_errorString = 'Success'
			SET @VMId = -1
			SET @isClustered = 0
			SET @clusterName  = ''
			SELECT @isClustered = ISNULL(vxml.value('(/QSMServer_QVirtualHostReq/@bClustered)[1]','INT'), 1),
				   @clusterName = vxml.value('(/QSMServer_QVirtualHostReq/@clusterName)[1]','NVARCHAR(512)')
			FROM App_VMHost WHERE id = @hostIdItr
			IF @vendorType = 102 AND @isClustered = 0
			BEGIN
				SET @counter += 1
				SET @o_errorCode = -1
				SET @o_errorString = 'VM Migration cannot be performed between non-clustered hosts.'
				INSERT INTO #Output(id, errorCode, errorString, srcHostId, VMId, VMName, HostId, HostName, TotalMemory, freememoryPct, VMCount, DataStoreId, DataStoreName, CapacityMB, FreePerc)
				SELECT -1, @o_errorCode, @o_errorString, @hostIdItr, 0, '', 0, '', 0, 0, 0, 0, '', 0, 0
				GOTO ERROR_EXIT_ITERATOR
			END
			INSERT INTO #ProspectiveVMs(VMid, VMDiskSizeMB, VMMemorySizeMB, SrcHostTotalMemMB, SrcHostFreeMemMB, SrcHostFreePerc,
						hostId, HostTotalMemMB, HostFreeMemMB, HostFreePerc, HostVMCount, totalCPU, Hostrank,
						DataStoreId, DSCapacityMB, DSFreeSapceMB, DSFreePerc)
			SELECT VMid, VMDiskSizeMB, VMMemorySizeMB, SrcHostTotalMemMB, SrcHostFreeMemMB, CAST(((SrcHostFreeMemMB*100.0) / SrcHostTotalMemMB ) AS DECIMAL(20,2)) AS SrcHostFreePerc,
					hostId, HostTotalMemMB, HostFreeMemMB, CAST(((HostFreeMemMB*100.0) / HostTotalMemMB ) AS DECIMAL(20,2)) AS DestHostFreePerc, HostVMCount, totalCPU, 0 AS Hostrank,
					DataStoreId , DSCapacityMB, DSFreeSapceMB, CAST(((DSFreeSapceMB*100.0)/DSCapacityMB) AS DECIMAL(20,2)) AS DSFreePerc
			FROM
			(
				SELECT src.VMid, src.VMDiskSizeMB, src.VMMemorySizeMB,
					   src.HostTotalMemMB AS srcHostTotalMemMB, src.HostFreeMemMB + VMMemorySizeMB AS SrcHostFreeMemMB,
					   H.hostId, H.HostTotalMemMB, (H.HostFreeMemMB - VMMemorySizeMB) AS HostFreeMemMB, H.vmCount + 1 AS HostVMCount, H.totalCPU, H.rank AS Hostrank,
					   DS.DataStoreId, DS.DSCapacityMB, (DS.DSFreeSapceMB - src.VMDiskSizeMB) AS DSFreeSapceMB
				FROM #OverLoadedHostVMMap src
					JOIN #hostInfo H
						ON H.status IN (1, 2) AND src.HostId = @hostIdItr		-- status: 1, 2 : not critically loaded hosts (free hosts).
					INNER JOIN VMHostToDataStores Map
						ON H.hostId = Map.vHostId
					INNER JOIN #dataStores DS
						ON DS.DataStoreId = Map.vDataStoreId
				WHERE @vendorType = 102 OR (@vendorType = 101 AND src.DataStoreName = DS.DataStoreName)
			) A
			WHERE 	((HostFreeMemMB*100.0) / HostTotalMemMB ) > @memFreePerc AND ((DSFreeSapceMB*100.0)/DSCapacityMB) > @dsFreePerc
			ORDER BY SrcHostFreePerc DESC, DSFreePerc DESC
			-- Get the VM that will reduce the burden on Host ot the most extent
			SELECT TOP 1 @VMId = VMID, @VMDiskSizeMB = VMDiskSizeMB, @VMMemorySizeMB = VMMemorySizeMB
			FROM #ProspectiveVMs ORDER BY SrcHostFreePerc DESC
			IF @VMid = -1
			BEGIN
				SET @counter += 1
				SET @o_errorCode = -1
				SET @o_errorString = 'No free hosts were found to move VMs from this host.'
				INSERT INTO #Output(id, errorCode, errorString, srcHostId, VMId, VMName, HostId, HostName, TotalMemory, freememoryPct, VMCount, DataStoreId, DataStoreName, CapacityMB, FreePerc)
				SELECT -1, @o_errorCode, @o_errorString, @hostIdItr, 0, '', 0, '', 0, 0, 0, 0, '', 0, 0
				GOTO ERROR_EXIT_ITERATOR
			END
			--For the above VM rank the hosts and then select the one with highest rank (most suitable one)
			-- weight is given for each parameter
			Select TOP 1 @esxServerId = hostId , @value = (HostTotalMemMB/HostVMCount) FROM #ProspectiveVMs WHERE VMId = @VMId
			ORDER BY (HostTotalMemMB/HostVMCount) DESC
			UPDATE #ProspectiveVMs	SET HostRank += 3
			WHERE VMId = @VMId AND hostId = @esxServerId
			-- normalization for other esx servers
			IF ( @value <> 0 )
			UPDATE #ProspectiveVMs SET HostRank += 3*((HostTotalMemMB/HostVMCount)/@value) WHERE hostId != @esxServerId and VMId = @VMId
			Select TOP 1 @esxServerId = hostId, @value = (cast (totalCPU as float)/ISNULL(HostVMCount,1))
			FROM #ProspectiveVMs where VMId = @VMId
			ORDER BY (totalCPU/ISNULL(HostVMCount,1)) DESC
			UPDATE #ProspectiveVMs	SET HostRank += 1
			WHERE hostId = @esxServerId and VMId = @VMId
			IF ( @value <> 0 )
			UPDATE #ProspectiveVMs SET HostRank += (totalCPU/HostVMCount)/@value WHERE HostId != @esxServerId and VMId = @VMId
			-- Now get the host with maximum rank
			SELECT TOP 1 @srcHostFreePerc = SrcHostFreePerc, @DestHostId = HostId ,@DataStoreId = DataStoreId
			FROM #ProspectiveVMs
			WHERE VMId= @VMId
			ORDER BY SrcHostFreePerc DESC, HostRank DESC, DSFreePerc DESC
			SET @counter += 1
			-- Return the above selected host to the output table with this VM mapping.
			INSERT INTO #Output(id, errorCode, errorString, srcHostId, VMId, VMName, HostId, HostName, TotalMemory, freememoryPct, VMCount, DataStoreId, DataStoreName, CapacityMB, FreePerc)
			SELECT @counter, 0, 'Success', @hostIdItr, VMid, VM.name, HostId, H.name, P.HostTotalMemMB, P.HostFreePerc, P.HostVMCount, P.dataStoreId, DS.name, P.DSCapacityMB, P.DSFreePerc
			FROM #ProspectiveVMs P
				INNER JOIN App_VM VM
					ON P.VMId = @VMId AND P.VMId = VM.id
				INNER JOIN App_VMHost H
					ON P.HostId = @DestHostId AND P.HostId = H.id
				INNER JOIN App_VMDataStore DS
					ON P.DataStoreId = @DataStoreId AND P.DataStoreId = DS.id
			-- If the source host is still overloaded above threshold, we need to find another most suitable VM to mograte to less loaded host
			IF @srcHostFreePerc < @memFreePerc
			BEGIN
				DELETE FROM #ProspectiveVMs WHERE VMId = @VMId
				SET @VMId = -1
				-- For the host and datastore selected above, recompute the free memory and disk size as the first VM has occupied that
				-- host and datastore and rest computation will be done on top of that.
				UPDATE #ProspectiveVMs
				SET HostFreeMemMB -= @VMMemorySizeMB,
					HostFreePerc = CAST((((HostFreeMemMB - @VMMemorySizeMB)*100.0) / HostTotalMemMB ) AS DECIMAL(20,2)),
					HostVMCount += 1
				WHERE HostId = @DestHostId
				UPDATE #ProspectiveVMs
				SET DSFreeSapceMB -= @VMDiskSizeMB,
					DSFreePerc = CAST((((DSFreeSapceMB - @VMDiskSizeMB)*100.0)/DSCapacityMB) AS DECIMAL(20,2))
				WHERE DataStoreId = @DataStoreId
				UPDATE #ProspectiveVMs
				SET HostRank = 0
				SELECT TOP 1 @VMId = VMID, @VMDiskSizeMB = VMDiskSizeMB, @VMMemorySizeMB = VMMemorySizeMB
				FROM #ProspectiveVMs ORDER BY SrcHostFreePerc DESC
				IF @VMid = -1
				BEGIN
					GOTO ERROR_EXIT_ITERATOR
				END
				--For the above VM rank the hosts and then select the one with highest rank (most suitable one)
				-- weight is given for each parameter
				Select TOP 1 @esxServerId = hostId , @value = (HostTotalMemMB/HostVMCount) FROM #ProspectiveVMs WHERE VMId = @VMId
				ORDER BY (HostTotalMemMB/HostVMCount) DESC
				UPDATE #ProspectiveVMs	SET HostRank += 3
				WHERE VMId = @VMId AND hostId = @esxServerId
				-- normalization for other esx servers
				IF ( @value <> 0 )
				UPDATE #ProspectiveVMs SET HostRank += 3*((HostTotalMemMB/HostVMCount)/@value) WHERE hostId != @esxServerId and VMId = @VMId
				Select TOP 1 @esxServerId = hostId, @value = (cast (totalCPU as float)/ISNULL(HostVMCount,1))
				FROM #ProspectiveVMs where VMId = @VMId
				ORDER BY (totalCPU/ISNULL(HostVMCount,1)) DESC
				UPDATE #ProspectiveVMs	SET HostRank += 1
				WHERE hostId = @esxServerId and VMId = @VMId
				IF ( @value <> 0 )
				UPDATE #ProspectiveVMs SET HostRank += (totalCPU/HostVMCount)/@value WHERE HostId != @esxServerId and VMId = @VMId
				-- Now get the host with maximum rank
				SELECT TOP 1 @srcHostFreePerc = SrcHostFreePerc, @DestHostId = HostId ,@DataStoreId = DataStoreId
				FROM #ProspectiveVMs
				WHERE VMId= @VMId
				ORDER BY SrcHostFreePerc DESC, HostRank DESC, DSFreePerc DESC
				SET @counter += 1
				-- Return the above selected host to the output table with this VM mapping.
				INSERT INTO #Output
				SELECT @counter, 0, 'Success', @hostIdItr, VMid, VM.name, HostId, H.name, P.HostTotalMemMB, P.HostFreePerc, P.HostVMCount, P.dataStoreId, DS.name, P.DSCapacityMB, P.DSFreePerc
				FROM #ProspectiveVMs P
					INNER JOIN App_VM VM
						ON P.VMId = @VMId AND P.VMId = VM.id
					INNER JOIN App_VMHost H
						ON P.HostId = @DestHostId AND P.HostId = H.id
					INNER JOIN App_VMDataStore DS
						ON P.DataStoreId = @DataStoreId AND P.DataStoreId = DS.id
			END
			ERROR_EXIT_ITERATOR:
			IF @o_errorCode = 0
			BEGIN
				UPDATE H
				SET HostFreeMemMB = CAST((O.freememoryPct * O.TotalMemory)/100 AS BIGINT),
					vmCount = O.VMCount
				FROM #hostInfo H
					INNER JOIN #Output O
						ON O.srcHostId = @hostIdItr AND H.hostId = O.hostId AND id = @counter
				UPDATE DS
				SET DSFreeSapceMB = CAST((O.FreePerc * O.CapacityMB)/100 AS BIGINT)
				FROM #dataStores DS
					INNER JOIN #Output O
						ON O.srcHostId = @hostIdItr AND DS.DataStoreId = O.dataStoreId AND id = @counter
			END
			FETCH NEXT FROM overloadedeHosts into @hostIdItr
		END
		CLOSE overloadedeHosts
		DEALLOCATE overloadedeHosts
		SELECT errorCode, errorString, srcHost.name AS srcHostName, VMId, ISNULL(VM.GUID, ''), VMName, HostName, DataStoreName, VMCount, TotalMemory, freememoryPct, CapacityMB, FreePerc
		FROM #Output O
			INNER JOIN App_VMHost srcHost
				ON O.srcHostId = srcHost.id
			LEFT JOIN App_VM VM
				ON VM.id = O.VMId
		ORDER BY hostId, freeMemoryPct DESC
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @o_errorCode = ERROR_NUMBER()
SET @o_errorString = ERROR_MESSAGE()
END CATCH
ERROR_EXIT:
IF @o_errorCode <> 0 AND NOT EXISTS(SELECT * FROM #Output)
BEGIN
		select  @o_errorCode,
		        @o_errorString,
				'',
				0,
				'',
				CASE WHEN LEN(@i_VMGUID) > 0  AND @VMClientId = 0 THEN @i_VMGUID
					 WHEN @VMClientId > 0 THEN @vmName
					 ELSE '' END,
				'',
				'',
		        0,
				0,
				0,
				0,
				0,
				'',
				''
END
IF object_id('tempdb.dbo.#hostInfo') is not null
	DROP TABLE #hostInfo
IF object_id('tempdb.dbo.#dataStores') is not null
	DROP TABLE #dataStores
IF object_id('tempdb.dbo.#VMProgressDetails') is not null
	DROP TABLE #VMProgressDetails
IF OBJECT_ID('tempdb..#OverLoadedHostVMMap') IS NOT NULL
	DROP TABLE #OverLoadedHostVMMap
IF OBJECT_ID('tempdb..#ProspectiveVMs') IS NOT NULL
	DROP TABLE #ProspectiveVMs
IF OBJECT_ID('tempdb..#Output') IS NOT NULL
	DROP TABLE #Output
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'VMP_MigrateVM')
	delete from GxQscripts where name = 'VMP_MigrateVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_MigrateVM')
	delete from GXDBVersions where aliasname = 'VMP_MigrateVM'
GO

insert into GXDBVersions values(2, 'VMP_MigrateVM',  '00010001000200100000', 'VMP_MigrateVM', '00010001000200100000')
GO

