

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_ManageVirtualAppJobStats.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_ManageVirtualAppJobStats.sp,v $ $Id: VMP_ManageVirtualAppJobStats.sp,v 1.1.2.5 2018/12/08 01:33:24 rpolimera Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='VMP_ManageVirtualAppJobStats')
BEGIN
	print '>>> Drop Stored Procedure: VMP_ManageVirtualAppJobStats <<<'
	drop procedure VMP_ManageVirtualAppJobStats
END
IF EXISTS (select * from GxQscripts where name='VMP_ManageVirtualAppJobStats')
	delete from GxQscripts where name = 'VMP_ManageVirtualAppJobStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_ManageVirtualAppJobStats')
	delete from GXDBVersions where aliasname = 'VMP_ManageVirtualAppJobStats'
GO
print '... Creating Procedure: VMP_ManageVirtualAppJobStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_ManageVirtualAppJobStats
  @userId INT=0,
  @i_xmlText XML,
  @flags INT=0,
  @errorCode INT=0	OUTPUT,
  @errorMessage NVARCHAR(MAX)	OUTPUT
AS
DECLARE @i_client			INT
DECLARE @i_replicationId	INT
DECLARE @i_vAppId			INT
DECLARE @i_jobId			INT
DECLARE @i_jobType			NVARCHAR(1024)
DECLARE @i_state			NVARCHAR(1024)
DECLARE @i_type				NVARCHAR(1024)
DECLARE @i_details			XML
DECLARE @failureReason            INT = 0
DECLARE @commCellId			INT = 2
DECLARE @stateId			INT = -1
DECLARE @typeId				INT = -1
--<VirtualAppJobDetails jobType="REPLICATION" jobId="196" replicationId="4" xmlDetails=""><phase type="REBOOT" state="RUNNING" /> <entity vAppId="0"/><client clientId="2" /> <phaseDetails failureMessageId="" failureMessage="" /></VirtualAppJobDetails>
BEGIN TRY
SELECT @i_client = isnull(ref.value('client[1]/@clientId', 'int'),0),
	   @i_replicationId = isnull(ref.value('@replicationId', 'int'),0),
	   @i_vAppId = isnull(ref.value('entity[1]/@vAppId', 'int'),''),
	   @i_jobId  = isnull(ref.value('@jobId', 'int'),0),
	   @i_jobType = ref.value('@jobType', 'NVARCHAR(1024)'),
	   @i_state = ref.value('phase[1]/@state', 'NVARCHAR(1024)'),
	   @i_type = ref.value('phase[1]/@type', 'NVARCHAR(1024)'),
	   @stateid = isnull(ref.value('phase[1]/@stateId', 'int'),-1),
	   @typeId = ref.value('phase[1]/@typeId', 'int'),
	   @failureReason  = isnull(ref.value('phaseDetails[1]/@failureMessageId', 'int'),0),
	   @i_details = isnull(ref.value('@xmlDetails', 'NVARCHAR(MAX)') ,'')
FROM @i_xmlText.nodes ('VirtualAppJobDetails') R(ref)
IF @i_jobType IS NOT NULL
BEGIN
	IF @stateId IS NULL OR @stateId = -1 OR @typeId IS NULL OR @typeId= -1
	BEGIN
		SET @errorCode = -1
		SET @errorMessage = 'Invalid State/Phase for the request'
	END
	IF @i_jobType = 'REPLICATION' -- REPLICATION, LIVEMOUNT_VIRTUALAPP, LIVEMOUNT_VIRTUALLAB,VIRTUALLAB
	BEGIN
		IF @i_replicationId IS NULL OR @i_replicationId < 1 OR @i_jobId IS NULL OR @i_jobId < 0
		BEGIN
			SET @errorCode = -1
			SET @errorMessage = 'Invalid Phase Request for Replication Job Status'
			GOTO ERROR_EXIT
		END
	END
	ELSE IF @i_jobType = 'VIRTUALLAB'
	BEGIN
		IF @i_jobId IS NULL OR @i_jobId < 1
		BEGIN
			SET @errorCode = -1
			SET @errorMessage = 'Invalid Phase Request for Virtual Lab Job Status'
			GOTO ERROR_EXIT
		END
	END
	ELSE IF @i_jobType = 'LIVEMOUNT_VIRTUALAPP' OR @i_jobType = 'LIVEMOUNT_VIRTUALLAB'
	BEGIN
		IF @i_jobId IS NULL OR @i_jobId < 1 OR  @i_vAppId IS NULL OR @i_vAppId < 1
		BEGIN
			SET @errorCode = -1
			SET @errorMessage = 'Invalid Phase Request for Virtual App Job Status'
			GOTO ERROR_EXIT
		END
	END
	IF  NOT EXISTS (SELECT * FROM App_VirtualAppJobStats WHERE jobId = @i_jobId AND phaseName = @i_type AND clientId = @i_client AND vappId = @i_vAppId AND replicationId = @i_replicationId)
	BEGIN
		INSERT INTO App_VirtualAppJobStats(jobId, commCellId, vappId, clientId, replicationId, phase, phaseName, status, startTime, endTime, details, failureReason, appTypeId)
			VALUES(@i_jobId, @commCellId, @i_vAppId, @i_client, @i_replicationId, @typeId, @i_type, @stateId, dbo.getunixTime(GETUTCDATE()), '', @i_details, @failureReason, 106)
	END
	ELSE
	BEGIN
		IF @stateId = 2
		BEGIN
			UPDATE App_VirtualAppJobStats SET
				status = @stateId,
				startTime = dbo.getunixTime(GETUTCDATE()),
				endTime = 0,
				details = @i_details,
				failureReason = @failureReason
			WHERE jobId = @i_jobId AND phaseName = @i_type AND clientId = @i_client AND vappId = @i_vAppId AND 	replicationId = @i_replicationId
		END
		ELSE
		BEGIN
			UPDATE App_VirtualAppJobStats SET
				status = @stateId,
				endTime = dbo.getunixTime(GETUTCDATE()),
				details = @i_details,
				failureReason = @failureReason
			WHERE jobId = @i_jobId AND phaseName = @i_type AND clientId = @i_client AND vappId = @i_vAppId AND 	replicationId = @i_replicationId
		END
	END
END
ELSE
BEGIN
	SET @errorCode = -1
	SET @errorMessage = 'Invalid Request for DR Plan Job Status Phase'
	GOTO ERROR_EXIT
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @errorCode = error_number();
	set @errorMessage = error_message();
END CATCH
--end of actual store proc
ERROR_EXIT:
IF @errorCode <> 0
BEGIN
	SELECT	@errorCode 'errorCode',	@errorMessage as 'errorMessage'
END
ELSE
	SELECT	0 'errorCode',	'' as 'errorMessage'
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VMP_ManageVirtualAppJobStats')
	delete from GxQscripts where name = 'VMP_ManageVirtualAppJobStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_ManageVirtualAppJobStats')
	delete from GXDBVersions where aliasname = 'VMP_ManageVirtualAppJobStats'
GO

insert into GXDBVersions values(2, 'VMP_ManageVirtualAppJobStats',  '00010001000200050000', 'VMP_ManageVirtualAppJobStats', '00010001000200050000')
GO

