

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_LogicalDeleteEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2010  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_LogicalDeleteEntity.sp,v $ $Id: VMP_LogicalDeleteEntity.sp,v 1.15.50.11 2018/04/24 19:37:40 pktr Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   VMP_LogicalDeleteEntity   - logically delete all virtual server entities in the SRMV* tables by time
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_LogicalDeleteEntity <<<'

IF EXISTS (select * from sysobjects where name='VMP_LogicalDeleteEntity')
	drop procedure VMP_LogicalDeleteEntity
IF EXISTS (select * from GxQscripts where name='VMP_LogicalDeleteEntity')
	delete from GxQscripts where name = 'VMP_LogicalDeleteEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_LogicalDeleteEntity')
	delete from GXDBVersions where aliasname = 'VMP_LogicalDeleteEntity'
GO
print '... Creating Procedure: VMP_LogicalDeleteEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_LogicalDeleteEntity
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @beginTimeStampInt INT,
  @appId INT,
  @instanceId INT,
  @jobId INT,
  @vmGUID NVARCHAR(1024),
  @flags INT
AS
  DECLARE @o_errorString NVARCHAR(1024)
BEGIN
	SET NOCOUNT ON
BEGIN TRY
	DECLARE @beginTimeStamp datetime = dbo.GetDateTime(@beginTimeStampInt)
	DECLARE @endTimeStamp datetime = GETUTCDATE()
	DECLARE @instanceType INT = 101
	SELECT @instanceType = attrVal FROM APP_InstanceProp WHERE componentNameId = @instanceId AND attrName = 'Virtual Server Instance Type' AND modified = 0
	if @appId=0
	BEGIN
		UPDATE	App_VM
		SET		removalTimeStamp=@endTimeStamp
		FROM	App_VM V, App_VMHost H
				CROSS APPLY H.vxml.nodes('QSMServer_QVirtualHostReq') M(t)
		WHERE	V.vHostId = H.id
			AND	V.GUID=@vmGUID
			AND	t.value('@connectionState', 'INT') = 0
		UPDATE	App_VmVolumes
		SET		removalTimeStamp = VM.removalTimeStamp
		FROM	App_VM VM
				JOIN App_VmVolumes VOL
					ON VM.GUID = VOL.instanceId
		WHERE	VM.removalTimeStamp IS NOT NULL
			AND	VOL.removalTimeStamp IS NULL
			AND VM.GUID = @vmGUID
		UPDATE	App_VmSnapShot
		SET		removalTimeStamp = VM.removalTimeStamp
		FROM	App_VM VM
				JOIN App_VmSnapShot SNAP
					ON VM.ID = SNAP.vmId
		WHERE	VM.removalTimeStamp IS NOT NULL
			AND	SNAP.removalTimeStamp IS NULL
			AND	VM.GUID = @vmGUID
	END
	ELSE
	BEGIN
if ((@flags&1)>0)
		BEGIN
			UPDATE	App_VM
			SET		removalTimeStamp=@endTimeStamp
			FROM	App_VM vm, App_VMDataCenterMap dcm, App_VMHost h
					CROSS APPLY
					h.vxml.nodes ('QSMServer_QVirtualHostReq') M(t)
			WHERE	vm.removalTimeStamp IS NULL
				AND	vm.timeStamp < @beginTimeStamp
				AND vm.vHostId=h.id
				AND	h.vDataCenterId=dcm.vDataCenterId
				AND	dcm.instanceId=@instanceId
				AND	(t.value('@connectionState', 'INT') = 0 OR @instanceType IN (301, 401, 402,403))
				AND datediff(hour, vm.timestamp, @beginTimeStamp) >= 6
			IF ( @instanceType = 1001 )
			BEGIN
				DECLARE @VClientId int
				SELECT @VClientId = C.id
				from APP_Client C
				INNER JOIN APP_Application A
				on C.id = A.clientId
				and A.instance = @instanceId
				UPDATE App_container
				set deleted = dbo.getunixtime(@endTimeSTamp)
				where isnull(deleted,0) =0
				and modified < dbo.getunixtime(@beginTimeStamp)
				and vcClientId = @VClientId
			END
			UPDATE	App_VM
			SET		vxml.modify('replace value of (/QSMServer_QVirtualMachineReq/@powerState)[1] with 6')
			FROM	App_VM vm, App_VMDataCenterMap dcm, App_VMHost h
					CROSS APPLY
					h.vxml.nodes ('QSMServer_QVirtualHostReq') M(t)
			WHERE	vm.removalTimeStamp IS NULL
				AND vm.vHostId=h.id
				AND	h.vDataCenterId=dcm.vDataCenterId
				AND	dcm.instanceId=@instanceId
				AND	(t.value('@connectionState', 'INT') != 0 AND @instanceType NOT IN (301, 401, 402,403))
			UPDATE	App_VmVolumes
			SET		removalTimeStamp = VM.removalTimeStamp
			FROM	App_VM VM
					JOIN App_VmVolumes VOL
						ON VM.GUID = VOL.instanceId
			WHERE	VM.removalTimeStamp IS NOT NULL
				AND	VOL.removalTimeStamp IS NULL
				AND datediff(hour, VM.timestamp, @beginTimeStamp) >= 6
			UPDATE	App_VmSnapShot
			SET		removalTimeStamp = VM.removalTimeStamp
			FROM	App_VM VM
					JOIN App_VmSnapShot SNAP
						ON VM.ID = SNAP.vmId
			WHERE	VM.removalTimeStamp IS NOT NULL
				AND	SNAP.removalTimeStamp IS NULL
				AND datediff(hour, VM.timestamp, @beginTimeStamp) >= 6
		END
if ((@flags&2)>0)
			update App_VMHost
				set
					removalTimeStamp=@endTimeStamp
				FROM
					App_VMDataCenterMap dcm
				where
					App_VMHost.removalTimeStamp IS NULL AND
					App_VMHost.timeStamp<@beginTimeStamp AND
					App_VMHost.vDataCenterId =dcm.vDataCenterId AND
					dcm.instanceId=@instanceId
if ((@flags&4)>0 AND @instanceType NOT IN (102, 401, 402, 403))
		begin
			delete VDM
			from APP_VMDataCenterMap VDM
			inner join APP_VMDataCenter DC
			on DC.removalTimeStamp IS NULL AND
					DC.timeStamp<@beginTimeStamp AND
					DC.id=VDM.vDataCenterId AND
					VDM.instanceId=@instanceId
			update App_VMDataCenter
				set
					removalTimeStamp=@endTimeStamp
				where id not in ( select distinct vDataCenterId from App_VMDataCenterMap)
				and removalTimeStamp IS NULL
				and name != '_NO_NAME_'
		end
if ((@flags&32)>0)
			update App_VMKeyPairs
				set
					removalTimeStamp=@endTimeStamp
				FROM
					App_VMDataCenterMap dcm
				where
					App_VMKeyPairs.removalTimeStamp IS NULL AND
					App_VMKeyPairs.vDataCenterId=dcm.vDataCenterId AND
					dcm.instanceId=@instanceId
if ((@flags&32)>0)
			update App_VMSecurityGroups
				set
					removalTimeStamp=@endTimeStamp
				FROM
					App_VMDataCenterMap dcm
				where
					App_VMSecurityGroups.removalTimeStamp IS NULL AND
					App_VMSecurityGroups.vDataCenterId=dcm.vDataCenterId AND
					dcm.instanceId=@instanceId
if ((@flags&8)>0)
			update App_VMDataStore
				set
					removalTimeStamp=@endTimeStamp
				FROM
					App_VMDataCenterMap dcm
				where
					App_VMDataStore.removalTimeStamp IS NULL AND
					App_VMDataStore.timeStamp<@beginTimeStamp AND
					App_VMDataStore.vDataCenterId=dcm.vDataCenterId AND
					dcm.instanceId=@instanceId
if ((@flags&16)>0)
			update App_VM
				set
					removalTimeStamp=@endTimeStamp
				FROM
					App_VMHost h,
					App_VMDataCenterMap dcm,
					App_VM vm CROSS APPLY
					vm.vxml.nodes ('QSMServer_QVirtualMachineReq') M(t)
				where
					vm.removalTimeStamp IS NULL AND
					vm.timeStamp<@beginTimeStamp AND
					vm.vHostId=h.id AND
					h.vDataCenterId=dcm.vDataCenterId AND
					dcm.instanceId=@instanceId AND
					t.value('@isTemplate', 'varchar(8)') = '1'
	END
	SET @o_errorString = 'Success'
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	EXECUTE dbo.GetError @o_errorString OUTPUT
END CATCH
EXIT_PROC:
		SELECT @o_errorString AS errorString
END
GO


IF EXISTS (select * from GxQscripts where name = 'VMP_LogicalDeleteEntity')
	delete from GxQscripts where name = 'VMP_LogicalDeleteEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_LogicalDeleteEntity')
	delete from GXDBVersions where aliasname = 'VMP_LogicalDeleteEntity'
GO

insert into GXDBVersions values(2, 'VMP_LogicalDeleteEntity',  '00010015005000110000', 'VMP_LogicalDeleteEntity', '00010015005000110000')
GO

