

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_HandleOrphanVMs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Ashish Gupta
--	Date:   04/29/2011
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_HandleOrphanVMs.sp,v $ $Id: VMP_HandleOrphanVMs.sp,v 1.2.50.2 2018/03/27 09:12:43 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_HandleOrphanVMs <<<'

IF EXISTS (select * from sysobjects where name='VMP_HandleOrphanVMs')
	drop procedure VMP_HandleOrphanVMs
IF EXISTS (select * from GxQscripts where name='VMP_HandleOrphanVMs')
	delete from GxQscripts where name = 'VMP_HandleOrphanVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_HandleOrphanVMs')
	delete from GXDBVersions where aliasname = 'VMP_HandleOrphanVMs'
GO
print '... Creating Procedure: VMP_HandleOrphanVMs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_HandleOrphanVMs
AS
  DECLARE @o_errorCode INTEGER
	DECLARE @unixTime int
	SET @unixTime = dbo.GetUnixTime(GetUTCDate()+7)
	DECLARE @sysCreatedPolicyId	INTEGER = 1
	UPDATE	App_VM
	SET		vmAllocationPolicyId = @sysCreatedPolicyId
	WHERE	vmAllocationPolicyId = 0
	OR	vmAllocationPolicyId IN (SELECT id FROM App_VmAllocationPolicy WHERE alive = 0)
    declare @childTemplates table
	(
		vmClientId int,
		vmName     nvarchar(256),
		vmGUID     varchar(256),
		maxClones  int
	)
	insert into @childTemplates
	select c.id , c.name, cp1.attrval, 0
	from app_client c
	inner join app_clientprop cp with (nolock)
	on cp.attrName ='Virtual Machine Parent Template GUID'
	and cp.modified =0
	and cp.componentNameId = c.id
	inner join app_clientprop cp1 with (nolock)
	on cp1.attrName ='Virtual Machine Instance UUID'
	and cp1.componentNameId = cp.componentNameId
	and cp1.modified =0
	inner join app_vm vm with (nolock)
	on vm.clientid = c.id
	and vm.removalTimeStamp is null
	and datediff(day,vm.addTimestamp, getutcdate()) >1
	update @childTemplates
	set maxClones = T.clones
	from ( select cp.attrval as guid, count(*) as clones
	       from app_clientprop cp with (nolock)
		   inner join app_vm vm with (nolock)
		   on vm.removalTimeStamp is null
	   	   and cp.attrName ='Virtual Machine Clone Template GUID'
		   and cp.modified =0
		   and vm.clientId = cp.componentNameId
		   group by cp.attrval) T
	inner join @childTemplates temp
	on T.guid = temp.vmGUID
	delete from @childTemplates
	where maxClones >0
	-- upsert expiration time
	MERGE  App_ClientProp as Dest
	USING (select * from @childTemplates ) as Src
	on  Dest.componentNameId = Src.vmclientid
	AND Dest.attrName = 'Virtual Machine Reserved Until'
	AND Dest.modified = 0
	WHEN MATCHED
	THEN UPDATE SET attrVal = @unixTime
	WHEN NOT MATCHED THEN
	INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
	Values( Src.vmclientid, 'Virtual Machine Reserved Until', 7, @unixTime, @unixTime, 0, 0);
	SET @o_errorCode = @@ERROR
EXIT_ERROR:
SELECT @o_ErrorCode as errorCode
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VMP_HandleOrphanVMs')
	delete from GxQscripts where name = 'VMP_HandleOrphanVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_HandleOrphanVMs')
	delete from GXDBVersions where aliasname = 'VMP_HandleOrphanVMs'
GO

insert into GXDBVersions values(2, 'VMP_HandleOrphanVMs',  '00010002005000020000', 'VMP_HandleOrphanVMs', '00010002005000020000')
GO

