

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_GetVMOpXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_GetVMOpXML.sp,v $ $Id: VMP_GetVMOpXML.sp,v 1.4.2.11 2018/03/27 08:06:12 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_GetVMOpXML <<<'

IF EXISTS (select * from sysobjects where name='VMP_GetVMOpXML')
	drop procedure VMP_GetVMOpXML
IF EXISTS (select * from GxQscripts where name='VMP_GetVMOpXML')
	delete from GxQscripts where name = 'VMP_GetVMOpXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetVMOpXML')
	delete from GXDBVersions where aliasname = 'VMP_GetVMOpXML'
GO
print '... Creating Procedure: VMP_GetVMOpXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_GetVMOpXML
  @i_xmlText XML,
  @i_userId INT=0,
  @i_localId INT=0,
  @o_xmlText XML	OUTPUT
AS
	DECLARE	@o_ErrorCode		INT=0
	DECLARE	@o_ErrorString		NVARCHAR(1024)
BEGIN
	DECLARE @i_capability		INT=31
    DECLARE @outXML  XML
    DECLARE @labId   INT
    DECLARE @labOpType INT
	DECLARE @expDate  INT =0
	DECLARE @labVersionType  INT = 0
	DECLARE @labName NVARCHAR(512)
    SET @labId = (SELECT @i_xmlText.value('Ida_ManageVMProvLabReq[1]/lab[1]/lab[1]/@labId', 'INT'))
    SET @labName = (SELECT @i_xmlText.value('Ida_ManageVMProvLabReq[1]/lab[1]/lab[1]/@labName', 'NVARCHAR(512)'))
    SET @labOpType = (SELECT @i_xmlText.value('Ida_ManageVMProvLabReq[1]/@operationType', 'INT'))
	-- delete sample xml
    -- <?xml version="1.0" encoding="utf-8"?><TMMsg_VMProvisioningOption operationType="5"><virtualMachineOption><vmInfo vmAllocPolicyId="0"><vm vmName="EAASLabVM0-25" vmGUID="1AA9AB58-EC4F-4CA9-B9EA-76D66F4B7F21"></vm><vmLocation vCenter="HyperV"></vmLocation><entity instanceId="0"></entity></vmInfo></virtualMachineOption></TMMsg_VMProvisioningOption>
    declare @opType int
    set @opType = ( select case when @labOpType = 1 then 1
                                when @labOpType = 2 then 2
                                when @labOpType = 3 then 10
                                when @labOpType = 4 then 5
                                when @labOpType = 5 then 17
                                else -1
                            end
                  )
	IF ( @labOpType = 5)
		SET @expDate = (SELECT @i_xmlText.value('Ida_ManageVMProvLabReq[1]/expirationDate[1]/@time', 'INT'))
   -- <expirationTime time="1437278400"></expirationTime>
   IF EXISTS (SELECT cp.componentId FROM APP_ComponentProp CP WITH (nolock)
							INNER JOIN APP_ClientGroup CG WITH (nolock)
							on CG.id = CP.componentId  AND CG.name = @labName
                          AND cp.propertyTypeId = 1032
		                  and cp.componentType =8
                          and cp.modified =0
                          and cp.componentId = @labId)
   BEGIN
		SET @labVersionType = 1
   END
   ELSE
   BEGIN
		SET @labVersionType = 2
   END
   CREATE TABLE #vmDetails
	(
		vmGUID NVARCHAR(1024), policyId INT
	)
   IF @labVersionType = 1
   BEGIN
        INSERT INTO #vmDetails
		SELECT VM.GUID, cp.longVal
			FROM  APP_ComponentProp CP WITH (nolock)
                  JOIN  APP_ClientGroupAssoc CGA with (nolock)
                  ON  CGA.clientGroupId = @labId
				  JOIN APP_VM VM
				  ON  VM.clientId = CGA.clientId
					  and VM.removalTimestamp is null
			WHERE cp.propertyTypeId = 1032
		          and cp.componentType =8
                  and cp.modified =0
                  and cp.componentId = @labId
   END
   ELSE
   BEGIN
		INSERT INTO #vmDetails
		SELECT n.value('@vmGUID','nvarchar(max)'), VLP.attrVal
			FROM  APP_VirtualLabProp VLP WITH (nolock)
                  JOIN (
						  SELECT CAST(VLP.attrVal as XML) vmList,
						  VLP.componentNameId labId
						  FROM APP_VirtualLabProp VLP WITH (nolock)
                          WHERE VLP.componentNameId = @labId
						  and VLP.attrName = 'Virtual Lab Machine List'
                          and VLP.modified =0
				       ) t
				  on t.labId = @labId
			CROSS APPLY t.vmList.nodes('/vmList/vm') n(n)
			WHERE  VLP.componentNameId = @labId
						  and VLP.attrName = 'Virtual Lab Policy Id'
                          and VLP.modified =0
   END
   set @o_xmlText = ( select @opType as '@operationType',
						( select 1 as '@jobId',
                           (select P.id as '@vmAllocPolicyId',
                              (select v.name as '@vmName',
                                      v.GUID as '@vmGUID',
				      				  c.name as '@clientName',
									  c.id as '@clientId'
                               FROM APP_VM v with (nolock)
			       			   JOIN APP_Client c with (nolock) ON c.id= v.clientId
                               WHERE v.GUID = vmD.vmGUID
                               FOR XML PATH('vm'), TYPE
                               ),
                               (select D.vCenter as '@vCenter',
								isnull(P.vxml.value('(policy/esxServers/@esxServerName)[1]', 'nvarchar(max)'),'')as '@hostName'
                                FOR XML PATH('vmLocation'), TYPE
                               ),
							   (
							    select @expDate as '@time'
								FOR XML PATH('expirationTime'), TYPE
							   )
                               FOR XML PATH('vmInfo'), TYPE
                           )
						  FROM #vmDetails vmD
						  join app_vm vm on vm.guid =vmD.vmGUID
						   and vm.removalTimeStamp is null
						  JOIN APP_VMAllocationPolicy P ON P.id = vmD.policyId
						  JOIN APP_VMHost vh ON vh.id = vm.vHostId
						  left outer join APP_VMDataCenter D on D.id = vh.vDataCenterId
                          FOR XML PATH('virtualMachineOption'), TYPE
                          )
                        FOR XML PATH ('TMMsg_VMProvisioningOption')
                      )
EXIT_PROC:
	SELECT @o_xmlText
	IF object_id('tempdb.dbo.#vmLabs') IS NOT null DROP TABLE #vmLabs
	IF object_id('tempdb.dbo.#vmDetails') IS NOT NULL DROP TABLE #vmDetails
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VMP_GetVMOpXML')
	delete from GxQscripts where name = 'VMP_GetVMOpXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetVMOpXML')
	delete from GXDBVersions where aliasname = 'VMP_GetVMOpXML'
GO

insert into GXDBVersions values(2, 'VMP_GetVMOpXML',  '00010004000200110000', 'VMP_GetVMOpXML', '00010004000200110000')
GO

