

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_GetVMLabs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_GetVMLabs.sp,v $ $Id: VMP_GetVMLabs.sp,v 1.4.2.8 2018/03/27 08:10:21 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_GetVMLabs <<<'

IF EXISTS (select * from sysobjects where name='VMP_GetVMLabs')
	drop procedure VMP_GetVMLabs
IF EXISTS (select * from GxQscripts where name='VMP_GetVMLabs')
	delete from GxQscripts where name = 'VMP_GetVMLabs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetVMLabs')
	delete from GXDBVersions where aliasname = 'VMP_GetVMLabs'
GO
print '... Creating Procedure: VMP_GetVMLabs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_GetVMLabs
  @i_xmlText XML,
  @i_userId INT=0,
  @i_localId INT=0,
  @o_xmlText XML	OUTPUT
AS
	DECLARE	@o_ErrorCode		INT=0
	DECLARE	@o_ErrorString		NVARCHAR(1024)
BEGIN
DECLARE @i_capability		INT=31
	IF object_id('tempdb.dbo.#vmLabs') IS NOT null DROP TABLE #vmLabs
	CREATE TABLE #vmLabs
	(
				labId int,
				labName nvarchar(2048),
                status int,
                labTemplatePolicyId  int,
                labTemplatePolicyName nvarchar(2048),
				labTemplatePolicyType  int,
                expirationTime int,
                totalVMCount int,
				vmList xml,
				labVersionType int
	)
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @isUserAdmin 		INT = 0
	-- Check if user is admin
    EXECUTE sec_isUserAdmin   @i_userid = @i_userId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
    INSERT INTO #vmLabs (labId, labName, status,
	labTemplatePolicyId, labTemplatePolicyName, labTemplatePolicyType, expirationTime, totalVMCount, vmList, labVersionType)
    SELECT  vl.id, vl.name,0,0,'',-1,0,0,'',2
    FROM  APP_VirtualLab vl
    WHERE vl.deleted = 0 and (vl.ownerId = @i_userId OR @isUserAdmin = 1) -- verify user visibility
	UNION
    SELECT  cg.id, cg.name,0,0,'' ,-1,0,0,'',1
    FROM  APP_ClientGroup cg
    WHERE cg.flag & 0x20000 != 0
    update #vmLabs
    set labTemplatePolicyId = t.id
    , labTemplatePolicyName = t.name
	, labTemplatePolicyType  = t.policyType
    from #vmLabs lab
    join ( select vlp.componentNameId, p.id, p.name, isnull(p.vxml.value('policy[1]/entity[1]/@policyType','int'),-1) as policyType from App_VirtualLabProp vlp
           join app_vmallocationpolicy p
           on p.id = vlp.attrVal
		   and vlp.attrName = 'Virtual Lab Policy Id'
           and vlp.modified =0
           ) t
    on t.componentNameId = lab.labId
	--older lab version details to collect
	update #vmLabs
    set labTemplatePolicyId = t.id
    , labTemplatePolicyName = t.name
    from #vmLabs lab
    join ( select cp.componentId, p.id, p.name from APP_ComponentProp cp
           join app_vmallocationpolicy p
           on cp.propertyTypeId = 1032
		   and cp.componentType =8
           and p.id = cp.longVal
           and cp.modified =0
           ) t
    on t.componentId = lab.labId
	-- Delete All VMlabs which are not visible to current user this is only for older labs.
	DELETE FROM #vmLabs
	WHERE labVersionType = 1 and  (@isUserAdmin <> 1 AND labId NOT IN
		(SELECT componentId FROM APP_ComponentProp cp
			WHERE cp.longVal = @i_userId
            AND cp.propertyTypeId = 1033
            AND cp.modified =0
				 )
		)
	update #vmLabs
    set expirationTime = t.exptime,
        totalVMCount = t.totalVMs
    from #vmLabs vmLabs
    join ( select max(cast(isnull(cp.attrVal,0) as int)) as expTime, cga.clientGroupId, count(c.id) as totalVMs
           from app_clientgroupassoc cga
           join app_client c
           on cga.clientId = c.id
		   join app_vm vm
		   on vm.clientId = c.id and vm.removalTimestamp is null
           join #vmLabs labs
           on labs.labId = cga.clientGroupId
           left join app_clientprop cp
           on cp.attrName = 'Virtual Machine Reserved Until'
		   and cp.componentNameId = c.id
           and cp.modified =0
           group by cga.clientGroupId
           ) t
    on vmLabs.labId = t.clientGroupId and vmLabs.labVersionType = 1
   UPDATE #vmLabs
   set status =  res.status
   FROM #vmLabs vmLabs
   join (
          select max(status) as status, clientGroupId
          from(
          select vm.vxml.value('/QSMServer_QVirtualMachineReq[1]/@powerState', 'int') as status, cga.clientGroupId
          from APP_ClientGroupAssoc cga
          join #vmLabs lab
          on lab.labId = cga.clientGroupId
          join APP_VM vm
          on vm.clientId = cga.clientId
		  and vm.removalTimestamp is null
          ) t
          group by clientGroupId
    ) res
    on vmLabs.labId = res.clientGroupId and vmLabs.labVersionType = 1
	--new  versionof lab creation changes
	update #vmLabs
    set vmList = cast(vlp.attrVal as xml)
    from #vmLabs vmLabs
	join App_VirtualLabProp vlp
	on vmLabs.labId = vlp.componentNameId
		   and vlp.attrName = 'Virtual Lab Machine List'
		   and vlp.modified = 0  and vmLabs.labVersionType = 2
	update #vmLabs
	set expirationTime = (select min(isnull(t.expTime,0))
           from(
           select cast(isnull(cp.attrVal,0) as int) as expTime
		   from app_vm vm
           left join app_clientprop cp
           on cp.attrName = 'Virtual Machine Reserved Until'
		   and cp.componentNameId = vm.clientId
           and cp.modified =0
		   cross apply vmLabs.vmList.nodes('/vmList/vm') v(v)
		    WHERE vm.GUID = v.value('@vmGUID', 'nvarchar(max)') and vm.removalTimeStamp is null
		   ) t),
    status = ( select case when min(t.status) = 0 THEN min(t.status) ELSE max(t.status) end as status
          from(
           select vm.vxml.value('/QSMServer_QVirtualMachineReq[1]/@powerState', 'int') as status
		    from app_vm vm
			cross apply vmLabs.vmList.nodes('/vmList/vm') v1(v1)
		   WHERE vm.GUID = v1.value('@vmGUID', 'nvarchar(max)') and vm.removalTimeStamp is null
          ) t),
	totalVMCount =  (select count(*)
		    from app_vm vm
			cross apply vmLabs.vmList.nodes('/vmList/vm') v1(v1)
		   WHERE vm.GUID = v1.value('@vmGUID', 'nvarchar(max)') and vm.removalTimeStamp is null)
	from #vmLabs vmLabs
	WHERE vmLabs.labId = vmLabs.labid and vmLabs.labVersionType = 2
	--don't show the lab entries which doesn't have any VMs associated.
	DELETE #vmLabs WHERE totalVMCount = 0
    IF EXISTS ( SELECT top 1 labId from #vmLabs )
    BEGIN
		SET @o_xmlText = ( SELECT
				 (SELECT vmList.status '@status', vmList.totalVMCount as '@vmCount',
					(SELECT ISNULL(vmList.expirationTime, 0) '@time', 55 '@_type_'
						FOR XML PATH ('expirationTime'), TYPE),
					(SELECT
							vmList.labId '@labId',
							vmList.labName '@labName'
						FOR XML PATH ('lab'), TYPE),
					(SELECT
							vmList.labTemplatePolicyId '@vmAllocPolicyId',
							vmList.labTemplatePolicyName '@vmAllocPolicyName',
							(CASE WHEN vmList.labTemplatePolicyType > -1 THEN vmList.labTemplatePolicyType ELSE '' END)  '@policyType'
						FOR XML PATH ('labPolicy'), TYPE)
				FOR XML PATH('labMachine'), TYPE)
		FROM #vmLabs vmList
		FOR XML PATH(''),
		ROOT('Ida_GetVMProvLabResp'))
	END
	ELSE
		SET @o_xmlText = cast('<Ida_GetVMProvLabResp/>' as XML)
EXIT_PROC:
	SELECT @o_xmlText
	IF object_id('tempdb.dbo.#vmLabs') IS NOT null DROP TABLE #vmLabs
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VMP_GetVMLabs')
	delete from GxQscripts where name = 'VMP_GetVMLabs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetVMLabs')
	delete from GXDBVersions where aliasname = 'VMP_GetVMLabs'
GO

insert into GXDBVersions values(2, 'VMP_GetVMLabs',  '00010004000200080000', 'VMP_GetVMLabs', '00010004000200080000')
GO

