

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_GetVMBounds.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   10/04/2010
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_GetVMBounds.sp,v $ $Id: VMP_GetVMBounds.sp,v 1.2.50.1 2018/03/27 08:04:51 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_GetVMBounds <<<'

IF EXISTS (select * from sysobjects where name='VMP_GetVMBounds')
	drop procedure VMP_GetVMBounds
IF EXISTS (select * from GxQscripts where name='VMP_GetVMBounds')
	delete from GxQscripts where name = 'VMP_GetVMBounds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetVMBounds')
	delete from GXDBVersions where aliasname = 'VMP_GetVMBounds'
GO
print '... Creating Procedure: VMP_GetVMBounds'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_GetVMBounds
  @o_xmlText XML	OUTPUT
AS
	DECLARE	@o_ErrorCode		INT=0
	DECLARE	@o_ErrorString		NVARCHAR(1024)
BEGIN
	SET @o_xmlText = ( SELECT
				max(vm.value('memory[1]/@memorySizeMB', 'bigint')) '@maxMemory',
				min(vm.value('memory[1]/@memorySizeMB', 'bigint')) '@minMemory',
				max(vh.value('@numNICs', 'int')) '@maxNICs',
				min(vh.value('@numNICs', 'int')) '@minNICs',
				max(vm.value('cpu[1]/@numCpu', 'nvarchar(1024)')) '@maxCores',
				min(vm.value('cpu[1]/@numCpu', 'nvarchar(1024)')) '@minCores',
				max(vm.value('diskUsage[1]/@provisionedStorage', 'nvarchar(1024)')) '@maxDiskSpace',
				min(vm.value('diskUsage[1]/@provisionedStorage', 'nvarchar(1024)')) '@minDiskSpace'
			FROM  App_VM VM
			LEFT OUTER JOIN App_VMHost VH ON VH.id = VM.vHostId
			LEFT OUTER JOIN App_VMDataCenter DC ON DC.id = VH.vDataCenterId
			CROSS APPLY VM.vxml.nodes ('QSMServer_QVirtualMachineReq') M(vm)
			CROSS APPLY VH.vxml.nodes ('QSMServer_QVirtualHostReq') H(vh)
	FOR XML PATH('Ida_GetVMBoundsResp'))
EXIT_PROC:
	SELECT @o_xmlText
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VMP_GetVMBounds')
	delete from GxQscripts where name = 'VMP_GetVMBounds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetVMBounds')
	delete from GXDBVersions where aliasname = 'VMP_GetVMBounds'
GO

insert into GXDBVersions values(2, 'VMP_GetVMBounds',  '00010002005000010000', 'VMP_GetVMBounds', '00010002005000010000')
GO

