

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_GetSnapShots.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   10/04/2010
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_GetSnapShots.sp,v $ $Id: VMP_GetSnapShots.sp,v 1.15.50.3 2018/03/27 08:18:42 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_GetSnapShots <<<'

IF EXISTS (select * from sysobjects where name='VMP_GetSnapShots')
	drop procedure VMP_GetSnapShots
IF EXISTS (select * from GxQscripts where name='VMP_GetSnapShots')
	delete from GxQscripts where name = 'VMP_GetSnapShots'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetSnapShots')
	delete from GXDBVersions where aliasname = 'VMP_GetSnapShots'
GO
print '... Creating Procedure: VMP_GetSnapShots'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_GetSnapShots
  @i_xmlText XML,
  @i_userId INT=0,
  @i_localId INT=0,
  @o_xmlText XML	OUTPUT
AS
	DECLARE	@o_ErrorCode		INT=0
	DECLARE	@o_ErrorString		NVARCHAR(1024)
BEGIN
	DECLARE @vmGUID NVARCHAR(256) = NULL
	DECLARE @vmName NVARCHAR(256)
	DECLARE @amazonInstanceId nvarchar(256)
	DECLARE @isUserAdmin 		INT = 0
	SET @vmGUID = @i_xmlText.value('/Ida_GetVMSnapshotReq[1]/vm[1]/@vmGUID', 'nvarchar(256)')
	set @amazonInstanceId = @i_xmlText.value('/Ida_GetVMSnapshotReq[1]/vm[1]/@amazonInstanceId', 'nvarchar(256)')
	if (@amazonInstanceId is not null)
	begin
		EXECUTE sec_isUserAdmin   @i_userid = @i_userId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
		IF object_id('tempdb.dbo.#vmListTable') IS NOT null DROP TABLE #vmListTable
		CREATE TABLE #vmListTable (vmClientId INT)
		IF @isUserAdmin <> 1
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#clientLst') IS NOT NULL
			DROP TABLE #clientLst
			CREATE TABLE #clientLst
			(
				clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT
			)
EXEC sec_getIdaObjectsForUser @i_userId, 3 , 1 , 0, '#clientLst'
			INSERT INTO #vmListTable
			SELECT DISTINCT VM.clientId
			FROM App_VM VM
				INNER JOIN #clientLst CL
					ON VM.clientId = CL.clientId
			IF OBJECT_ID('tempdb.dbo.#clientLst') IS NOT NULL
				DROP TABLE #clientLst
		END
		SET @o_xmlText = (
							select	data.snapShotName '@snapShotName',
									data.snapShotDesc '@snapShotDesc',
									( SELECT 'VirtualMachineSnapshot'	  '@type',
										data.moref '@value' FOR XML PATH ('moRef'), TYPE),
									(SELECT dbo.GetUnixTime(data.createTimeStamp) '@time', 55 '@_type_' FOR XML PATH ('createTime'), TYPE),
									(SELECT data.srcHdType as '@srcHdType' FOR XML PATH ('sourceVolume'), TYPE)
							from
							(
								SELECT	VmSnap.name		as snapShotName,
										VmSnap.description			as snapShotDesc,
										VmSnap.createTimeStamp,
										VmSnap.moref,
										3 as srcHdType
								FROM  APP_VmSnapShot VmSnap
										JOIN App_VM VM
											on VmSnap.vmId = VM.id
												and VM.removalTimeStamp is null
										JOIN APP_VMVolumes VOL
										on VmSnap.vmDataStoreId = VOL.id
										LEFT OUTER JOIN #vmListTable VL
											ON VL.vmClientId = VM.clientId
								where VM.GUID = @vmGUID or ( @vmGUID is null AND ((VmSnap.userId = @i_userId and VOL.userId= @i_userId ) OR VL.vmClientId IS NOT NULL OR @isUserAdmin = 1))
								union
								SELECT	CASE WHEN VOL.name ='' or VOL.name is NULL then VOL.volumeId ELSE VOL.name END as snapShotName ,
										'' as snapShotDesc,
										VOL.createTimeStamp,
										VOL.volumeId as moref,
										2 as srcHdType
								FROM APP_VMVolumes VOL
										JOIN App_VM VM
											ON VM.GUID = VOL.instanceId
												and VM.removalTimeStamp is null
								where VM.GUID = @vmGUID
							) data
							FOR XML PATH ('snapshots'),
							ROOT('Ida_GetVMSnapshotResp')
						)
	END
	ELSE
	BEGIN
		SET @o_xmlText = ( SELECT
				VmSnap.name '@snapShotName',
				VmSnap.description '@snapShotDesc',
(SELECT dbo.GetUnixTime(VmSnap.createTimeStamp) '@time', 55 '@_type_'
							FOR XML PATH ('createTime'), TYPE),
				( SELECT 'VirtualMachineSnapshot'	  '@type',
						 VmSnap.moref '@value' FOR XML PATH ('moRef'), TYPE),
				( SELECT 'VirtualMachineSnapshot'	  '@type',
						 VmSnap.parentMoref '@value' FOR XML PATH ('parentMoRef'), TYPE)
			FROM  APP_VmSnapShot VmSnap
			INNER JOIN App_VM vm
			ON vm.GUID = @vmGUID
			AND vm.id = VmSnap.vmId
			WHERE	VmSnap.name <> '_GX_BASE_SNAP_'
			FOR XML PATH ('snapshots'),
			ROOT('Ida_GetVMSnapshotResp'))
	END
	IF @o_xmlText IS NULL
		SET @o_xmlText = N'<Ida_GetVMSnapshotResp/>'
EXIT_PROC:
	SELECT @o_xmlText
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VMP_GetSnapShots')
	delete from GxQscripts where name = 'VMP_GetSnapShots'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetSnapShots')
	delete from GXDBVersions where aliasname = 'VMP_GetSnapShots'
GO

insert into GXDBVersions values(2, 'VMP_GetSnapShots',  '00010015005000030000', 'VMP_GetSnapShots', '00010015005000030000')
GO

