

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_GetLocalVolumeTemplate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   10/04/2010
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_GetLocalVolumeTemplate.sp,v $ $Id: VMP_GetLocalVolumeTemplate.sp,v 1.3.12.6 2018/03/27 08:07:46 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_GetLocalVolumeTemplate <<<'

IF EXISTS (select * from sysobjects where name='VMP_GetLocalVolumeTemplate')
	drop procedure VMP_GetLocalVolumeTemplate
IF EXISTS (select * from GxQscripts where name='VMP_GetLocalVolumeTemplate')
	delete from GxQscripts where name = 'VMP_GetLocalVolumeTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetLocalVolumeTemplate')
	delete from GXDBVersions where aliasname = 'VMP_GetLocalVolumeTemplate'
GO
print '... Creating Procedure: VMP_GetLocalVolumeTemplate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_GetLocalVolumeTemplate
  @i_templateName VARCHAR(1024),
  @i_templateGUID VARCHAR(256),
  @i_virtualizationClient VARCHAR(1024),
  @i_host VARCHAR(1024),
  @i_volume VARCHAR(1024),
  @i_maxLinkedCloneVMs int
AS
  DECLARE @o_templateName VARCHAR(1024)
  DECLARE @o_templateGUID VARCHAR(256)
  DECLARE @o_bExists int
BEGIN
DECLARE  @dataCenterId  INT
DECLARE  @hostId	INT
DECLARE  @volumeType	varchar(256)
SET @dataCenterId = (SELECT TOP(1) id FROM APP_VMDataCenter WHERE vCenter = @i_virtualizationClient)
SET @hostId = ( SELECT id FROM APP_VMHost where name = @i_host and vDataCenterId= @dataCenterId and removalTimeStamp is null)
SET @volumeType = ( SELECT vmd.vxml.value('datastores[1]/@fileSystemType', 'varchar(256)') from APP_VMDataStore vmd
                  inner join  VMHostToDataStores vhd
				  on vmd.id = vhd.vDataStoreId
				  and vmd.name = @i_volume
				  and removalTimeStamp is null
				  and vhd.vHostId = @hostId
				  )
BEGIN
	IF object_id('tempdb.dbo.#childTemplates') IS NOT null DROP TABLE #childTemplates
    create table #childTemplates
	(
		vmClientId int,
		vmName     nvarchar(256),
		vmGUID     varchar(256),
		maxClones  int
	)
	IF ( @volumeType = 'CSVFS')
	BEGIN
		insert into #childTemplates
		select distinct c.id , c.name, cp1.attrval, 0
		from app_client c
		inner join app_clientprop cp with (nolock)
		on cp.attrName ='Virtual Machine Parent Template GUID'
		and cp.attrval = @i_templateGUID
		and cp.modified =0
		and cp.componentNameId = c.id
		inner join app_clientprop cp1 with (nolock)
		on cp1.attrName ='Virtual Machine Instance UUID'
		and cp1.componentNameId = cp.componentNameId
		and cp1.modified =0
		inner join app_vm vm with (nolock)
		on vm.clientid = c.id
		and vm.removalTimeStamp is null
	END
	ELSE
	BEGIN
		insert into #childTemplates
		select distinct c.id , c.name, cp1.attrval, 0
		from app_client c
		inner join app_clientprop cp with (nolock)
		on cp.attrName ='Virtual Machine Parent Template GUID'
		and cp.attrval = @i_templateGUID
		and cp.modified =0
		and cp.componentNameId = c.id
		inner join app_clientprop cp1 with (nolock)
		on cp1.attrName ='Virtual Machine Instance UUID'
		and cp1.componentNameId = cp.componentNameId
		and cp1.modified =0
		inner join app_vm vm with (nolock)
		on vm.clientid = c.id
		and vm.removalTimeStamp is null
		inner join app_vmhost host with (nolock)
		on vm.vhostid = host.id
		and host.removalTimeStamp is null
		and host.id = @hostId
		and host.removalTimeStamp is null
	END
	update #childTemplates
	set maxClones = T.clones
	from ( select cp.attrval as guid, count(*) as clones
	       from app_clientprop cp with (nolock)
		   inner join app_vm vm with (nolock)
		   on vm.removalTimeStamp is null
	   	   and cp.attrName ='Virtual Machine Clone Template GUID'
		   and cp.modified =0
		   and vm.clientId = cp.componentNameId
		   group by cp.attrval) T
	inner join #childTemplates temp
	on T.guid = temp.vmGUID
	--in case expiration time is set for the clone template , let us reset it as we have some clones
	update app_clientprop
	set attrval = 0
	from app_clientprop cp with (nolock)
	inner join #childTemplates ct
	on cp.componentnameid = ct.vmClientid
	and cp.attrName ='Virtual Machine Reserved Until'
	delete from #childTemplates where maxClones >= @i_maxLinkedCloneVMs
	if exists ( select * from #childTemplates )
	begin
		set @o_templateName = (select top 1 vmName from #childTemplates order by maxClones  )
		set @o_templateGUID = ( select top 1 vmGUID from #childTemplates where vmName = @o_templateName)
		set @o_bExists = 1
	end
	else
	begin
		SET @o_templateName = @i_templateName + '_Clone'
		declare @lastnumber varchar(64) = newid()
		SET @o_templateName = @o_templateName + '_'+  @lastnumber
		set @o_bExists = 0
	END
END
SELECT @o_templateName, @o_templateGUID, @o_bExists
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VMP_GetLocalVolumeTemplate')
	delete from GxQscripts where name = 'VMP_GetLocalVolumeTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetLocalVolumeTemplate')
	delete from GXDBVersions where aliasname = 'VMP_GetLocalVolumeTemplate'
GO

insert into GXDBVersions values(2, 'VMP_GetLocalVolumeTemplate',  '00010003001200060000', 'VMP_GetLocalVolumeTemplate', '00010003001200060000')
GO

