

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_GetLabTemplate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   10/04/2010
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_GetLabTemplate.sp,v $ $Id: VMP_GetLabTemplate.sp,v 1.3.2.4 2020/02/06 21:57:17 pktr Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='VMP_GetLabTemplate')
BEGIN
	print '>>> Drop Stored Procedure: VMP_GetLabTemplate <<<'
	drop procedure VMP_GetLabTemplate
END
IF EXISTS (select * from GxQscripts where name='VMP_GetLabTemplate')
	delete from GxQscripts where name = 'VMP_GetLabTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetLabTemplate')
	delete from GXDBVersions where aliasname = 'VMP_GetLabTemplate'
GO
print '... Creating Procedure: VMP_GetLabTemplate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_GetLabTemplate
  @i_clientId INT,
  @i_labId INT
AS
  DECLARE @o_labId INT
  DECLARE @o_labName NVARCHAR(1024)
  DECLARE @o_totalVMCount INT
BEGIN
if object_id('tempdb.dbo.#vmList') is not null drop table #vmList
create table #vmList
 (
	vmGUID   nvarchar(256),
	labId	 int
)
IF ( isnull(@i_labId,0) = 0)
BEGIN
declare @currentLabId int = 0
declare @currentVMGUID nvarchar(256)
 if object_id('tempdb.dbo.#labList') is not null drop table #labList
 create table #labList
 (
	labId	 int,
	vmCount  int
 )
insert into #vmList
 select n.value('@vmGUID','nvarchar(256)'),
		t.componentNameId
 FROM
 (
 select componentnameid, cast(attrval as xml) as vmList FROM
 App_VirtualLabProp LabProp with (nolock)
 where LabProp.attrName ='Virtual Lab Machine List'
 and LabProp.modified =0) t
 CROSS APPLY t.vmList.nodes('/vmList/vm') n(n)
 delete vmList
 from #vmList vmList
 inner join app_vm vm
 on vmList.vmGUID = vm.guid
 and vm.removalTimeStamp is not null
  insert into #labList
 select labId, count(*)
 from #vmList
 group by labId
 select @currentVMGUID = GUID from APP_VM where clientId = @i_clientId
 select @currentLabId = labid
 from #vmList
 where vmguid = @currentVMGUID
 select @o_labId = @currentlabId, @o_labName =lab.name, @o_totalVMCount = vmCount
 from App_VirtualLab lab
 inner join #labList labList
 on lab.id = @currentLabId
 and labList.labId = @currentLabId
END
ELSE
BEGIN
insert into #vmList
 select n.value('@vmGUID','nvarchar(256)'),
		t.componentNameId
 FROM
 (
 select componentnameid, cast(attrval as xml) as vmList FROM
 App_VirtualLabProp LabProp with (nolock)
 where LabProp.attrName ='Virtual Lab Machine List'
 and LabProp.modified =0 and LabProp.componentNameId = @i_labId) t
 CROSS APPLY t.vmList.nodes('/vmList/vm') n(n)
 delete vmList
 from #vmList vmList
 inner join app_vm vm
 on vmList.vmGUID = vm.guid
 and (vm.guid is null or vm.removalTimeStamp is not null)
 select @o_totalVMCount = count(*) from #vmList
 select @o_labId = @i_labId, @o_labName =lab.name
 from App_VirtualLab lab
 where lab.id = @i_labId
END
IF @o_labId is not null  and @o_labName is not null and @o_totalVMCount is not null
	SELECT @o_labId, @o_labName, @o_totalVMCount
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VMP_GetLabTemplate')
	delete from GxQscripts where name = 'VMP_GetLabTemplate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetLabTemplate')
	delete from GXDBVersions where aliasname = 'VMP_GetLabTemplate'
GO

insert into GXDBVersions values(2, 'VMP_GetLabTemplate',  '00010003000200040000', 'VMP_GetLabTemplate', '00010003000200040000')
GO

