

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_GetKeyPairandSecurityGroup.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_GetKeyPairandSecurityGroup.sp,v $ $Id: VMP_GetKeyPairandSecurityGroup.sp,v 1.7.50.9 2020/06/25 03:21:11 ishaarora Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "GetDataCenterList"
--	|	This Procedure is used to get the list of available data centers
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='VMP_GetKeyPairandSecurityGroup')
BEGIN
	print '>>> Drop Stored Procedure: VMP_GetKeyPairandSecurityGroup <<<'
	drop procedure VMP_GetKeyPairandSecurityGroup
END
IF EXISTS (select * from GxQscripts where name='VMP_GetKeyPairandSecurityGroup')
	delete from GxQscripts where name = 'VMP_GetKeyPairandSecurityGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetKeyPairandSecurityGroup')
	delete from GXDBVersions where aliasname = 'VMP_GetKeyPairandSecurityGroup'
GO
print '... Creating Procedure: VMP_GetKeyPairandSecurityGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_GetKeyPairandSecurityGroup
-- Input arguments
  @userId INT,
  @request XML,
  @flags INT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @result XML
BEGIN TRY
-- request :<Ida_VMOpReq><vmInfo isPhysical="0" isTemplate="0" memory="2048" numberOfCPUs="2" numberOfNICs="4" operatingSystem="Microsoft Windows Server 2008 (64-bit)" purpose="" vmAllocPolicyId="3" vmState="0"><vm _type_="88" vmName="t.t.ttt.commvault.com"/><vmLocation dataCenterName="Commvault-DC" hostName="" vCenter="usint13"><dcUserInfo password="||#4!MWVodG40dGZhNGY0bnRJdHo0Ym5Zbm4=&#xA;" userName="administrator"/><datastore name=""/></vmLocation><hardDisks><hardDisk diskSize="112640" diskType="2" label="Hard disk 1"/><hardDisk diskSize="61440" diskType="1" label="Hard disk 2"/></hardDisks><expirationTime time="1300766400"/></vmInfo><vmEntity _type_="88" clientId="89" commCellId="0" type="0" vmGUID="421b9c6b-9172-73dc-92a8-f0a631cd7a20" vmName="template-win2k8r2-2"/></Ida_VMOpReq>
	SET NOCOUNT ON
	DECLARE @vmAllocPolicy XML
	DECLARE @keyPair nvarchar(255)
	DECLARE @rsaKey nvarchar(max)
	DECLARE @securityGroupName nvarchar(255)
	DECLARE @securityGroupsCount INT
	DECLARE @i INT
	DECLARE @tempXML XML
	DECLARE @errorCode INT =0
	DECLARE @errorString VARCHAR(1024) = 'Success'
	DECLARE @vmAllocPolicyId INT
	DECLARE @dataCenterId INT
	DECLARE @policyType				INT = 0
	DECLARE @hostName				nvarchar(1024)
	DECLARE @vmInstanceTypeName		nvarchar(256)
	DECLARE @shape					nvarchar(256) = NULL
    DECLARE @rootDiskName			nvarchar(256) = NULL
	DECLARE @vmPolicyAppType		int =0
	DECLARE @virtualizationClientId	int =0
	declare @virtualizationClientName  nvarchar(256)
	declare @osName  nvarchar(256) = NULL
	declare @osType   int =0
	declare @template	nvarchar(256)
	declare @cloudTemplatesXML xml
	declare @region  nvarchar(256)
	declare @templateXML xml
	declare @vmName nvarchar(256)
	declare @jobId int
	declare @roleName nvarchar(256) = NULL
	--Check if any tmp table is existing before then drop it
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @result = @request
	SELECT @vmAllocPolicyId = isnull(ref.value('@vmAllocPolicyId', 'INT'),0),
	       @virtualizationClientId = isnull(ref.value('vmLocation[1]/virtualizationClient[1]/@clientId', 'INT'),0),
		   @osName = ref.value('@operatingSystem', 'nvarchar(256)'),
		   @region = ref.value('vmLocation[1]/@dataCenterName', 'nvarchar(256)'),
		   @jobid = ref.value('../@jobId', 'int')
						FROM @request.nodes ('Ida_VMOpReq/vmInfo') R(ref)
	if ( @vmAllocPolicyId =0 and @virtualizationClientId !=0)
	begin
		select @vmAllocPolicyId = p.id from App_VmAllocationPolicy P
			 inner join App_VMAllocationPolicyProp prop
			 on p.id = prop.componentNameId
			 and prop.modified =0
			 and prop.attrName ='destinationHyperV'
			 and prop.attrval = @virtualizationClientId
			 and P.alive =1
			 and isnull(P.vxml.value('(policy[1]/@vmPolicyAppType)[1]','int'),0) =3
			 select @virtualizationClientName = name from app_client where id = @virtualizationClientId
	end
	SELECT @vmAllocPolicy = vxml, @dataCenterId = vDataCenterId FROM App_VmAllocationPolicy where id = @vmAllocPolicyId
	SELECT @keyPair = ref.value('@keyPairName', 'NVARCHAR(255)')
		FROM @vmAllocPolicy.nodes ('policy/amazonPolicy/keyPair') VMP(ref)
	SET @policyType = @vmAllocPolicy.value('(policy/entity[1]/@policyType)[1]','int')
	SET @vmPolicyAppType = isnull(@vmAllocPolicy.value('(policy[1]/@vmPolicyAppType)[1]','int'),0)
	IF ( @policyType = 11 )
	BEGIN
		set @hostName = (select top 1 attrVal from app_instanceprop ip
		inner join app_vmdatacentermap dcmap
		on ip.componentNameId = dcmap.instanceId
		and dcmap.vDataCenterId = @dataCenterId
		and ip.attrName ='Virtual Server Host'
		and ip.modified =0 )
		set @result.modify('replace value of (/Ida_VMOpReq/vmInfo/vmLocation/@hostName)[1] with sql:variable("@hostName")')
		set @vmInstanceTypeName = @result.value('(/Ida_VMOpReq/vmInfo/instanceTypeEntity/@vmInstanceTypeName)[1]', 'nvarchar(256)')
		select @shape = instanceType
		from app_vminstanceTypes where flags =2
		and cast(cpuCores as varchar(50)) +' core(s) ' + cast(memory as varchar(50)) + ' GB memory' = @vmInstanceTypeName
        if @shape is not null
			set @result.modify('replace value of (/Ida_VMOpReq/vmInfo/instanceTypeEntity/@vmInstanceTypeName)[1] with sql:variable("@shape")')
	END
	IF(@keyPair IS not null)
	BEGIN
	  Select @rsaKey = rsaPrivateKey FROM App_VMKeyPairs where name = @keyPair AND vDataCenterId = @dataCenterId
	  IF (  @rsaKey IS null and @vmPolicyAppType !=2 )
	  BEGIN
	     SET @errorCode = (128 | (CAST(POWER(2, 24) AS BIGINT) * 72))
		 SET @errorString = 'Failed to find RSA Key for keyPair name provided in Allocation Policy'
		 GOTO ERROR_EXIT
		END
	END
	ELSE IF ( @vmPolicyAppType !=2 )
	BEGIN
		SET @errorCode = (128 | (CAST(POWER(2, 24) AS BIGINT) * 72))
		SET @errorString = 'Key Pair is not a member of the Allocation Policy'
		GOTO ERROR_EXIT
	END
	DECLARE @SecurityGroupsTbl TABLE (
		id				INT,
		dataCenterId	INT,
		securityGroupName	NVARCHAR(255),
		PRIMARY KEY (dataCenterId, securityGroupName)
	)
	INSERT INTO
		@SecurityGroupsTbl
	SELECT
		ref.value('@securityGroupId', 'int'),
		@dataCenterId,
		ref.value('@securityGroupName', 'NVARCHAR(255)')
	FROM
		@vmAllocPolicy.nodes ('policy/amazonPolicy/securityGroups') S(ref)
	INSERT INTO
		@SecurityGroupsTbl
	SELECT
		0,
		@dataCenterId,
		ref.value('@name', 'NVARCHAR(255)')
	FROM
		@vmAllocPolicy.nodes ('policy/securityGroups') S(ref)
	SELECT @securityGroupsCount = COUNT(*) FROM @SecurityGroupsTbl
	IF(@securityGroupsCount < 1 and @vmPolicyAppType !=2 )
	BEGIN
		SET @errorCode = (128 | (CAST(POWER(2, 24) AS BIGINT) * 72))
		SET @errorString = 'Security Group is not a member of the Allocation Policy'
		GOTO ERROR_EXIT
	END
	IF(@keyPair is not null)
	BEGIN
		IF( @request.exist('/Ida_VMOpReq/vmInfo/@keyPairName') = 1)
		BEGIN
			set @result.modify('replace value of (/Ida_VMOpReq/vmInfo/@keyPairName)[1] with sql:variable("@keyPair")')
		END
		ELSE
		BEGIN
			set @result.modify('insert attribute keyPairName {sql:variable("@keyPair")} into (/Ida_VMOpReq/vmInfo)[1]')
		END
	END
	if ( @rsaKey is not null)
	BEGIN
		IF(@request.exist('/Ida_VMOpReq/vmInfo/@rsaPrivateKey') = 1)
		BEGIN
			set @result.modify('replace value of (/Ida_VMOpReq/vmInfo/@rsaPrivateKey)[1] with sql:variable("@rsaKey")')
		END
		ELSE
		BEGIN
			set @result.modify('insert attribute rsaPrivateKey {sql:variable("@rsaKey")} into (/Ida_VMOpReq/vmInfo)[1]')
		END
	END
	SET @i =1
	WHILE (@i <= @securityGroupsCount )
	BEGIN
		SELECT TOP (@i)  @securityGroupName = securityGroupName FROM @SecurityGroupsTbl
		IF ( @request.exist('/Ida_VMOpReq/vmInfo/securityGroups') = 1)
		BEGIN
			set @result.modify('replace value of (/Ida_VMOpReq/vmInfo/securityGroups/@strName)[1] with sql:variable("@securityGroupName")')
		END
		ELSE
		BEGIN
			set @result.modify('insert <securityGroups/> as last into (/Ida_VMOpReq/vmInfo)[1]')
			set @result.modify('insert (attribute name {sql:variable("@securityGroupName")}) into ((/Ida_VMOpReq/vmInfo/securityGroups)[sql:variable("@i")])[1]')
			SET @i = @i +1
		END
	END
	SET @roleName = @vmAllocPolicy.value('(/policy/roleInfo/@name)[1]','nvarchar(256)')
	if ( @roleName is not null)
	begin
			set @result.modify('insert <roleInfo/> as last into (/Ida_VMOpReq/vmInfo)[1]')
			set @result.modify('insert attribute name {sql:variable("@roleName")} into (/Ida_VMOpReq/vmInfo/roleInfo)[1]')
	end
    IF ISNULL(@request.value('(/Ida_VMOpReq/vmInfo/hardDisks/hardDisk[1]/@srcHdType)[1]','int'),'0') = 4
	BEGIN
		-- if root hard disk name is empty , we need to get it from the template and update it.
		IF ISNULL(@request.value('(/Ida_VMOpReq/vmInfo/hardDisks/hardDisk[1]/@label)[1]','nvarchar(1024)'),'') = '' OR
		   ISNULL(@request.value('(/Ida_VMOpReq/vmInfo/hardDisks/hardDisk[1]/@label)[1]','nvarchar(1024)'),'') = 'Hard disk 1'
		BEGIN
			IF (@request.exist('(/Ida_VMOpReq/vmInfo/hardDisks/hardDisk[1]/@label)[1]')=1)
			BEGIN
				select @rootDiskName = ISNULL(hd.value('@summary', 'nvarchar(1024)'),'')
				FROM  APP_VM VM
				CROSS APPLY VM.vxml.nodes ('QSMServer_QVirtualMachineReq') M(vm)
				CROSS APPLY vm.nodes ('./hardDisks[1]') D(hds)
				CROSS APPLY hds.nodes('*') O(hd)
				where GUID = @request.value('(/Ida_VMOpReq/vmEntity)[1]/@vmGUID','nvarchar(1024)')
				IF @rootDiskName is not null
                	set @result.modify('replace value of (/Ida_VMOpReq/vmInfo/hardDisks/hardDisk[1]/@label)[1] with sql:variable("@rootDiskName")')
			END
		END
	END
	-- fill out missing infomration
	IF ( @vmPolicyAppType = 2)
	BEGIN
			if ( @osName = 'Windows_64bit')
				set @osType =0
			else
				set @osType =1
			 select @cloudTemplatesXML = cast(value as XML)  from GXGlobalParam where name = 'CVCloudVMTemplates' and modified =0
			 select @template = TS.template
			 FROM  (
			 select CV.T.value('@id', 'nvarchar(256)') as template,
			        CV.T.value('@region', 'nvarchar(256)') as region,
					CV.T.value('@os', 'int') as OS,
					CV.T.value('@sequence', 'int') as sequence
			        from @cloudTemplatesXML.nodes('CloudVMTemplates/Amazon/Template') as CV(T)
			 ) TS
			 where TS.OS = @osType and TS.region = @region and TS.sequence =1
			set @vmName = 'cvautoproxy' +  cast(isnull(@jobId,@virtualizationClientId) as nvarchar(256))
			select @shape = vxml.value('(policy/amazonPolicy/instanceType/instanceType/@vmInstanceTypeName)[1]', 'nvarchar(256)')
			from app_vmallocationpolicy
			where id = @vmAllocPolicyId
		    set @result.modify('insert attribute vCenter {sql:variable("@virtualizationClientName")} into (/Ida_VMOpReq/vmInfo/vmLocation)[1]')
			set @result.modify('insert <proxyClient/> as last into (/Ida_VMOpReq/vmInfo)[1]')
			set @result.modify('insert attribute clientId {sql:variable("@virtualizationClientId")} into (/Ida_VMOpReq/vmInfo/proxyClient)[1]')
			set @result.modify('insert <vmEntity/> as last into (/Ida_VMOpReq)[1]')
			set @result.modify('insert attribute vmGUID {sql:variable("@template")} into (/Ida_VMOpReq/vmEntity)[1]')
			--set @result.modify('insert <vm/> as last into (/Ida_VMOpReq/vmInfo)[1]')
			--set @result.modify('insert attribute vmName {sql:variable("@vmName")} into (/Ida_VMOpReq/vmInfo/vm)[1]')
			set @result.modify('insert <instanceTypeEntity/> as last into (/Ida_VMOpReq/vmInfo)[1]')
			set @result.modify('insert attribute vmInstanceTypeName {sql:variable("@shape")} into (/Ida_VMOpReq/vmInfo/instanceTypeEntity)[1]')
	END
	SELECT @result
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @errorCode = ERROR_NUMBER()
SET @errorString = ERROR_MESSAGE()
END CATCH
ERROR_EXIT:
IF @errorCode <> 0
BEGIN
		--set @message = ' Error occured while selecting key pair and security groups information for VM Creation , Error message: ' + @errorString
		--EXEC DBLog_Write 0, 'VMP_GetKeyPairandSecurityGroup', @message
		SELECT	1					as TAG,
			0					as Parent,
			@errorCode			as [Ida_GenericResp!1!errorCode],
			@errorString			as [Ida_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
END
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'VMP_GetKeyPairandSecurityGroup')
	delete from GxQscripts where name = 'VMP_GetKeyPairandSecurityGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetKeyPairandSecurityGroup')
	delete from GXDBVersions where aliasname = 'VMP_GetKeyPairandSecurityGroup'
GO

insert into GXDBVersions values(2, 'VMP_GetKeyPairandSecurityGroup',  '00010007005000090000', 'VMP_GetKeyPairandSecurityGroup', '00010007005000090000')
GO

