

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_GetDiskConfiguration.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   10/04/2010
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_GetDiskConfiguration.sp,v $ $Id: VMP_GetDiskConfiguration.sp,v 1.1.2.3 2018/03/27 08:03:22 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_GetDiskConfiguration <<<'

IF EXISTS (select * from sysobjects where name='VMP_GetDiskConfiguration')
	drop procedure VMP_GetDiskConfiguration
IF EXISTS (select * from GxQscripts where name='VMP_GetDiskConfiguration')
	delete from GxQscripts where name = 'VMP_GetDiskConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetDiskConfiguration')
	delete from GXDBVersions where aliasname = 'VMP_GetDiskConfiguration'
GO
print '... Creating Procedure: VMP_GetDiskConfiguration'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_GetDiskConfiguration
  @i_xmlText XML,
  @i_userId INT=0,
  @i_localId INT=0,
  @o_xmlText XML	OUTPUT
AS
	DECLARE	@o_ErrorCode		INT=0
	DECLARE	@o_ErrorString		NVARCHAR(1024)
BEGIN
DECLARE @vendor INT = ISNULL((SELECT I.n.value('@vendor','INT') FROM @i_xmlText.nodes('/Ida_GetVMDiskConfigReq') I(n)),1)
DECLARE @policyId INT = ISNULL((SELECT I.n.value('@policyId','INT') FROM @i_xmlText.nodes('/Ida_GetVMDiskConfigReq') I(n)),1)
DECLARE @azureSizeId INT = ISNULL((SELECT I.n.value('@azureSizeId','INT') FROM @i_xmlText.nodes('/Ida_GetVMDiskConfigReq') I(n)),1)
-- This templateId is not used now but vendor side changes are required to collect min/max OS diskc size information
DECLARE @templateId INT = ISNULL((SELECT I.n.value('@templateId','INT') FROM @i_xmlText.nodes('/Ida_GetVMDiskConfigReq') I(n)),1)
IF @vendor = 1
BEGIN
	SET @o_xmlText = (SELECT @vendor AS '@vendor',
							 (SELECT 1 AS '@expanableOSDisk',
									 1 AS '@expanableDataDisk',
									 0 AS '@amzLinuxVolumeLimit',
									 (SELECT 60		AS '@maxDataDiskCount',
											 -1		AS '@minOSDiskSize',
											 2047	AS '@maxOSDiskSize',
											 1		AS '@minDataDiskSize',
											 2047	AS '@maxDataDiskSize'
									  FOR XML PATH('diskLimits'), TYPE
									 )
							  FOR XML PATH('config'), TYPE
							 )
					 FOR XML PATH('GetVMDiskConfigResp')
		)
END
ELSE IF @vendor = 2
BEGIN
	SET @o_xmlText = (SELECT @vendor AS '@vendor',
							 (SELECT 1 AS '@expanableOSDisk',
									 1 AS '@expanableDataDisk',
									 0 AS '@amzLinuxVolumeLimit',
									 (SELECT 63		AS '@maxDataDiskCount',
											 -1		AS '@minOSDiskSize',
											 2040	AS '@maxOSDiskSize',
											 1		AS '@minDataDiskSize',
											 2040	AS '@maxDataDiskSize'
									  FOR XML PATH('diskLimits'), TYPE
									 )
							  FOR XML PATH('config'), TYPE
							 )
					 FOR XML PATH('GetVMDiskConfigResp')
		)
END
ELSE IF @vendor = 4	-- Amazon
BEGIN
	DECLARE @volumeType INT = ISNULL((SELECT vxml.value('(/policy/amazonPolicy/volumeConfig/@volumeType)[1]','INT') FROM App_VMAllocationPolicy WHERE id = @policyId), 0)
	-- Data disk Volume Size depends on Type of Volume
	--Characteristic:	 General Purpose (SSD)		Provisioned IOPS(SSD)		Magnetic
	--Volume size:			1 GiB - 16 TiB				4 GiB - 16 TiB			1 GiB - 1 TiB
	DECLARE @minDataDiskSize INT, @maxDataDiskSize INT
	DECLARE @maxDataDiskCount INT = (SELECT ( CASE WHEN OS.Type = 'Windows' THEN 17 -- For windows, right now fixed to AWS_PV (later needed to be collected from vendor)
												   WHEN OS.Type = 'Unix' THEN 40
												   ELSE 40
											 END )
									 FROM APP_Client C INNER JOIN simOperatingSystem OS ON C.id = @templateId AND OS.id = C.simOperatingSystemId )
	SELECT @minDataDiskSize = CASE @volumeType WHEN 0 THEN 1 ELSE 4 END,
		   @maxDataDiskSize = CASE @volumeType WHEN 0 THEN 16*1024 ELSE 16*1024 END  -- Send size in GBs
	SET @o_xmlText = (SELECT @vendor AS '@vendor',
							 (SELECT 0 AS '@expanableOSDisk',
									 1 AS '@expanableDataDisk',
									 (SELECT @maxDataDiskCount		AS '@maxDataDiskCount',
											 40		AS '@minOSDiskSize', -- Need to collect this from templates
											 40	AS '@maxOSDiskSize', -- Need to collect this from templates
											 @minDataDiskSize		AS '@minDataDiskSize',--
											 @maxDataDiskSize	AS '@maxDataDiskSize'
									  FOR XML PATH('diskLimits'), TYPE
									 )
							  FOR XML PATH('config'), TYPE
							 )
					 FOR XML PATH('GetVMDiskConfigResp')
		)
END
ELSE IF @vendor = 5	--Azure
BEGIN
	DECLARE @maxOSDiskSize INT
	SELECT @maxOSDiskSize = vxml.value('(/Properties/constraints/@maxOSDiskSize)[1]','INT'),
		   @maxDataDiskCount = vxml.value('(/Properties/constraints/@maxDataDiskCount)[1]','INT'),
		   @maxDataDiskSize = vxml.value('(/Properties/constraints/@maxDataDiskSize)[1]','INT')
	FROM App_VMInstanceTypes WHERE id = @azureSizeId
	SET @o_xmlText = (SELECT @vendor AS '@vendor',
							 (SELECT 0 AS '@expanableOSDisk',
									 0 AS '@expanableDataDisk',
									 0 AS '@amzLinuxVolumeLimit',
									 (SELECT @maxDataDiskCount		AS '@maxDataDiskCount',
											 127					AS '@minOSDiskSize',
											 @maxOSDiskSize			AS '@maxOSDiskSize',
											 1						AS '@minDataDiskSize',
											 @maxDataDiskSize		AS '@maxDataDiskSize'
									  FOR XML PATH('diskLimits'), TYPE
									 )
							  FOR XML PATH('config'), TYPE
							 )
					 FOR XML PATH('GetVMDiskConfigResp')
		)
END
IF @o_ErrorCode <> 0
	BEGIN
		SET @o_xmlText = ( SELECT
				( SELECT @o_ErrorCode '@errorCode', @o_ErrorString '@errorString'
					FOR XML PATH('error'), TYPE
				)
		FOR XML PATH(''),
		ROOT('Ida_GetVirtualMachinesResp'))
	END
EXIT_PROC:
	SELECT @o_xmlText
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VMP_GetDiskConfiguration')
	delete from GxQscripts where name = 'VMP_GetDiskConfiguration'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetDiskConfiguration')
	delete from GXDBVersions where aliasname = 'VMP_GetDiskConfiguration'
GO

insert into GXDBVersions values(2, 'VMP_GetDiskConfiguration',  '00010001000200030000', 'VMP_GetDiskConfiguration', '00010001000200030000')
GO

