

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_GetAvailableVmInPool.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   10/04/2010
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_GetAvailableVmInPool.sp,v $ $Id: VMP_GetAvailableVmInPool.sp,v 1.4.50.1 2018/03/27 08:11:55 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_GetAvailableVmInPool <<<'

IF EXISTS (select * from sysobjects where name='VMP_GetAvailableVmInPool')
	drop procedure VMP_GetAvailableVmInPool
IF EXISTS (select * from GxQscripts where name='VMP_GetAvailableVmInPool')
	delete from GxQscripts where name = 'VMP_GetAvailableVmInPool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetAvailableVmInPool')
	delete from GXDBVersions where aliasname = 'VMP_GetAvailableVmInPool'
GO
print '... Creating Procedure: VMP_GetAvailableVmInPool'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_GetAvailableVmInPool
  @i_policyId INT,
  @i_allocate INT,
  @i_tmplGUID VARCHAR(1024)
AS
  DECLARE @o_clientId INT
BEGIN
IF @i_allocate = 1 --Reserve the VM
BEGIN
	SET @o_clientId = (
		SELECT	TOP (1) V.clientId
		FROM	App_VM V
				INNER JOIN APP_ClientProp CP
					ON V.clientId = CP.componentNameId AND CP.attrName = N'Virtual Machine Availability to VM Pool' AND CP.modified = 0 AND CP.attrVal = N'1' --VmAvailabilityStatus::AvailableToUse
				INNER JOIN APP_ClientProp CP2
					ON V.clientId = CP2.componentNameId AND CP2.attrName = N'Virtual Machine Source Template GUID' AND CP2.modified = 0 AND CP2.attrVal = @i_tmplGUID
		WHERE	V.vmAllocationPolicyId = @i_policyId
			AND	V.removalTimeStamp IS NULL
		)
	IF @o_clientId IS NULL
		SET @o_clientId = 0
	ELSE
		UPDATE APP_ClientProp SET attrVal = 3 WHERE componentNameId = @o_clientId AND attrName = N'Virtual Machine Availability to VM Pool' AND attrVal = N'1' AND modified = 0
END
ELSE
BEGIN
	SET @o_clientId = (
		SELECT	COUNT(*)
		FROM	App_VM V
				INNER JOIN APP_ClientProp CP
					ON V.clientId = CP.componentNameId AND CP.attrName = N'Virtual Machine Availability to VM Pool' AND CP.modified = 0 AND CP.attrVal = N'1' --VmAvailabilityStatus::AvailableToUse
				INNER JOIN APP_ClientProp CP2
					ON V.clientId = CP2.componentNameId AND CP2.attrName = N'Virtual Machine Source Template GUID' AND CP2.modified = 0 AND CP2.attrVal = @i_tmplGUID
		WHERE	V.vmAllocationPolicyId = @i_policyId
			AND	V.removalTimeStamp IS NULL
		)
	IF @o_clientId IS NULL
		SET @o_clientId = 0
END
	SELECT @o_clientId
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VMP_GetAvailableVmInPool')
	delete from GxQscripts where name = 'VMP_GetAvailableVmInPool'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetAvailableVmInPool')
	delete from GXDBVersions where aliasname = 'VMP_GetAvailableVmInPool'
GO

insert into GXDBVersions values(2, 'VMP_GetAvailableVmInPool',  '00010004005000010000', 'VMP_GetAvailableVmInPool', '00010004005000010000')
GO

