

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_GetAvailableVMs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary sourcae code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   10/04/2010
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_GetAvailableVMs.sp,v $ $Id: VMP_GetAvailableVMs.sp,v 1.97.12.52 2020/09/01 21:27:05 pktr Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='VMP_GetAvailableVMs')
BEGIN
	print '>>> Drop Stored Procedure: VMP_GetAvailableVMs <<<'
	drop procedure VMP_GetAvailableVMs
END
IF EXISTS (select * from GxQscripts where name='VMP_GetAvailableVMs')
	delete from GxQscripts where name = 'VMP_GetAvailableVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetAvailableVMs')
	delete from GXDBVersions where aliasname = 'VMP_GetAvailableVMs'
GO
print '... Creating Procedure: VMP_GetAvailableVMs'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_GetAvailableVMs
  @i_xmlText XML,
  @i_userId INT=0,
  @i_localId INT=0,
  @o_xmlText XML	OUTPUT
AS
	DECLARE	@o_ErrorCode		INT=0
	DECLARE	@o_ErrorString		NVARCHAR(1024)
BEGIN
DECLARE @i_capability		INT=31
	DECLARE @i_isTemplate		INT=0
	DECLARE @pos				INT=0
DECLARE @i_UserInfo			NVARCHAR(255)
DECLARE @i_UserName			NVARCHAR(255)
DECLARE @i_domainName		NVARCHAR(255)
	DECLARE @i_OS				NVARCHAR(1024)
	DECLARE @i_location			NVARCHAR(1024)
	DECLARE @isUserAdmin 		INT = 0
	DECLARE @i_modSince		DATETIME
	DECLARE @i_modSinceChar		NVARCHAR(1024)
	DECLARE @i_specialVMFlag INT
	DECLARE @i_policyId INT
    DECLARE	@i_labId         INT =0
	DECLARE @i_isDocker		INT =0
	declare @policyType     INT =1
	DECLARE @i_vendor       int
	DECLARE @systemPolicyId INT
	DECLARE @i_labName NVARCHAR(1024)
	DECLARE @i_instanceId int = 0
	DECLARE @i_isLiveMount int = 0
	DECLARE @i_isTestFailover int =0
	DECLARE @i_replicationId INT =0
	DECLARE @i_vAppId INT =0
	SET @systemPolicyId = ISNULL((SELECT id from App_VmAllocationPolicy WHERE name = '_NO_NAME_'),1)
	IF object_id('tempdb.dbo.#vmListTable') IS NOT null DROP TABLE #vmListTable
	CREATE TABLE #vmListTable
	(
				vmGUID VARCHAR(255),
				vmName NVARCHAR(1024),
				clientId int,
				clientName nvarchar(2048),
				isArchived int,
				creationTime int,
				expirationTime	int,
				updateTimeStamp		dateTime,
				creator varchar(1024),
				osType  int,
				purpose varchar(1024),
				powerState int,
				instanceType varchar(1024),
				policyId int,
				guestOS varchar(1024),
				noNICS int,
				noCPU  int,
				numberOfDisks int,
				memory  int,
				isTemplate int,
				ipAddress varchar(1024),
				toolsVersion int,
				vHostId int,
				dataCenterId int,
				vcenterName varchar(1024),
				userCapabilities bigint DEFAULT 0,
				vsInstanceType INT,
				dnsHostName varchar(256),
				snapshotCount INT,
				connectionString	NVARCHAR(1024),
				hostName NVARCHAR(256),
				instanceId int default 0,
				proxyClientId int default 0,
				loginUserName varchar(256),
				canBeRenewed INT,	-- 1 : Yes, 0 : No
				backupVM    int default 0,
				vendor		int,
				isRenewalsinPolicyAllowed int default 1,
				labName varchar(1024),
				lastPoweredOnTime int,
				labJobId bigint,
				labId int,
				isVirtualLabGateway int default 0,
				replicationId int default 0
	)
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	set @i_specialVMFlag =ISNULL( @i_xmlText.value('/Ida_GetVirtualMachinesReq[1]/@flags','INT'),0)
	set @i_userId = ISNULL( @i_xmlText.value('/Ida_GetVirtualMachinesReq[1]/user[1]/@userId','NVARCHAR(36)'),@i_userId)
	select
	@i_isTemplate = ISNULL( ref.value('@isTemplate','INT'),@i_isTemplate),
	@i_OS = ISNULL( ref.value('@operatingSystem','NVARCHAR(1024)'),''),
	@i_location = ISNULL( ref.value('vmLocation[1]/@location','NVARCHAR(1024)'),''),
	@i_policyId = ISNULL( ref.value('allocationPolicy[1]/@vmAllocPolicyId','INT'),0),
	@i_labId = ISNULL( ref.value('lab[1]/@labId','INT'),@i_labId),
	@i_labName = ISNULL( ref.value('lab[1]/@labName','NVARCHAR(MAX)'),''),
	@i_isDocker = ISNULL( ref.value('@isDocker','INT'),@i_isDocker),
	@i_vendor = ISNULL( ref.value('@vendor','INT'),0),
	@i_instanceId = ISNULL (ref.value('@instanceId', 'INT'),@i_instanceId),
	@i_isLiveMount = ISNULL (ref.value('@isLiveMount', 'INT'),@i_isLiveMount),
	@i_isTestFailover = ISNULL (ref.value('@isTestFailOver', 'INT'),@i_isTestFailover),
	@i_replicationId = ISNULL (ref.value('@replicationId', 'INT'),@i_replicationId),
	@i_vAppId = ISNULL (ref.value('vappEntity[1]/@vAppId', 'INT'),@i_vAppId)
	FROM @i_xmlText.nodes ('Ida_GetVirtualMachinesReq/filter') R(ref)
	IF (@i_vendor =11 ) set @i_isDocker =1
	ELSE IF @i_policyId >0
	BEGIN
		select @policyType = vxml.value('policy[1]/entity[1]/@policyType','int')
		from App_VmAllocationPolicy
		where id = @i_policyId
		if (@policytype =8) set @i_isDocker =1
	END
	-- Check if user is admin
    EXECUTE sec_isUserAdmin   @i_userid = @i_userId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
	IF OBJECT_ID('tempdb.dbo.#clientLst') IS NOT NULL
		DROP TABLE #clientLst
	CREATE TABLE #clientLst (clientId INT, permissionList varchar(max))
	IF @isUserAdmin <> 1
	BEGIN
EXEC sec_getObjectsWithPermissions @i_userId,3,'#clientLst'
		--also include vm clients if user is owner of the vm policy.
		insert into #clientLst(clientId)
		select vm.clientId
		from app_vm vm inner join app_vmallocationpolicy p
		on p.id = vm.vmAllocationPolicyId
		and p.alive =1
		and p.ownerId = @i_userId
		left join #clientLst CL
		ON CL.clientId = vm.clientId
		WHERE CL.clientId is null
	END
	ELSE
	BEGIN
		insert into #clientLst (clientId)
		select clientId from App_VM where removalTimeStamp is Null
	END
	INSERT  INTO #vmListTable  ( clientName)
		SELECT   ref.value('@clientName', 'NVARCHAR(1024)') AS vmName
		FROM    @i_xmlText.nodes('Ida_GetVirtualMachinesReq/filter/entities') R ( ref )
	    WHERE  ref.value('@clientName', 'NVARCHAR(1024)') IS NOT NULL
	    AND ref.value('@vmGUID','nvarchar(255)') IS NULL
	DECLARE @sourceLMGUID NVARCHAR(1024)
	IF @i_isLiveMount = 0
	BEGIN
		INSERT  INTO #vmListTable  ( vmGUID, vmName)
			SELECT  ref.value('@vmGUID', 'NVARCHAR(255)') AS vmGUID, ref.value('@vmName', 'NVARCHAR(1024)') AS vmName
			FROM    @i_xmlText.nodes('Ida_GetVirtualMachinesReq/filter/entities') R ( ref )
			WHERE	ref.value('@vmGUID', 'NVARCHAR(255)') IS NOT NULL
	END
	ELSE
	BEGIN
			SELECT top 1 @sourceLMGUID = ref.value('@vmGUID', 'NVARCHAR(255)')
			FROM    @i_xmlText.nodes('Ida_GetVirtualMachinesReq/filter/entities') R ( ref )
			WHERE	ref.value('@vmGUID', 'NVARCHAR(255)') IS NOT NULL
			INSERT  INTO #vmListTable  ( vmGUID, vmName , clientId)
				SELECT GUID as vmGUID, name as vmName, clientId FROM APP_VM vm
				INNER JOIN (
							  SELECT CAST(CAST(acp.attrVal as varchar(max)) as XML) lmProp,
							  acp.componentNameId vmClientId
							  FROM APP_ClientProp acp WITH (nolock)
							  WHERE acp.attrName = 'Virtual Machine Live Mount Property'
							  and acp.modified =0
				) t1
				on t1.vmClientId =  vm.clientId
				and vm.removalTimeStamp is null
				and t1.lmProp.value('Ida_LiveMountResp[1]/@srcVMGUID','varchar(1024)')  = @sourceLMGUID
			--for sourceVMGUID with liveMount=1, we need to filter only the VMs visible to the user.
			DELETE #vmListTable
			FROM #vmListTable vmList
			LEFT JOIN #clientLst cl
			on cl.clientid = vmList.clientId
			where cl.clientId is null
	END
	DECLARE @isDeep INT = ( select COUNT(*) FROM #vmListTable)
	IF ( @isDeep = 1 and exists ( select top 1 id from app_container inner join #vmListTable on containerId = vmGUID))
	BEGIN
		SET @i_isDocker =1
	END
	IF ( @i_isDocker = 1 )
	BEGIN
		IF object_id('tempdb.dbo.#containerList') IS NOT null DROP TABLE #containerList
		CREATE TABLE #containerList
		(
		    id           int,
			containerId  nvarchar(256),
			name         nvarchar(256),
			operatingSystem  nvarchar(256),
			powerState   int,
			vcClientId   int,
			vcClientName  nvarchar(256),
			vcHostName		nvarchar(256),
			flags		int,
			vmpolicyId   int,
			expiratonTime int,
			containerProp xml,
		)
		IF ( @isDeep = 0 )
		BEGIN
			insert into #containerList
			select id, containerId, name,  operatingSystem, powerState, vcClientId, '','', flags, 0, 0,cast(attrVal as xml)
			FROM APP_Container C
			INNER JOIN APP_ContainerProp CP
			on C.id = CP.componentNameId
			and cp.attrName ='Container Attributes'
			AND ( @isUserAdmin =1 OR C.ownerId = @i_userId )
			AND @i_isTemplate = flags
			where isnull(deleted, 0) =0
		END
		ELSE
		BEGIN
			insert into #containerList
				select id, containerId, C.name,  C.operatingSystem, C.powerState, vcClientId, '','', flags,0,0,cast(CP.attrVal as xml)
			FROM APP_Container C
			INNER JOIN APP_ContainerProp CP
			on C.id = CP.componentNameId
			and cp.attrName ='Container Attributes'
			INNER JOIN #vmListTable LT
			on LT.vmGUID = C.containerId
			AND ( @isUserAdmin =1 OR C.ownerId = @i_userId )
			AND @i_isTemplate = flags
			where isnull(deleted, 0) =0
		END
		update CL
		set vmpolicyId = cp.attrval
		from #containerList CL
		INNER JOIN APP_ContainerProp cp
		on cl.id = cp.componentNameId
		and cp.attrName ='Container Policy'
		and cp.modified =0
		update CL
		set expiratonTime = cp.attrval
		from #containerList CL
		INNER JOIN APP_ContainerProp cp
		on cl.id = cp.componentNameId
		and cp.attrName ='Expiration Time'
		and cp.modified =0
		update CL
		set operatingSystem = C.name
		from #containerList CL
		inner join APP_Container C
		on CL.containerProp.value('/virtualMachine[1]/dockerProperties[1]/@templateId', 'nvarchar(256)') =
		   C.containerId
		UPDATE CL
		set  vcClientName = C.net_hostname
		from #containerList CL
		inner join app_client C
		on CL.vcClientId = C.id
		UPDATE CL
		set vcHostName = prop.attrVal
		from #containerList CL
		inner join APP_Application A
		on CL.vcClientId = A.clientId
		inner join APP_InstanceProp prop
		on prop.componentNameId = A.instance
		and prop.attrName ='Virtual Server Host'
		and prop.modified =0
		SET @o_xmlText = ( SELECT
					 (SELECT
					    operatingSystem as '@operatingSystem',
						flags as '@isTemplate',
						vmpolicyId  '@vmAllocPolicyId',
						powerState as '@vmState' ,
						(SELECT ISNULL(expiratonTime, 0) '@time', 55 '@_type_'
								FOR XML PATH ('expirationTime'), TYPE),
						(SELECT
							name '@vmName', containerId '@vmGUID'
							FOR XML PATH ('vm'), TYPE),
						(SELECT
							vcClientName '@vCenter', vcHostName '@dataCenterName', vcHostName '@hostName'
							FOR XML PATH ('vmLocation'), TYPE),
						(SELECT
							(SELECT ref.value('@capacityInKb', 'bigint')/(1024*1024) 'hardDisk/@diskSize',
							        ref.value('@pathInContainer', 'nvarchar(256)') 'hardDisk/@pathInContainer',
								    ref.value('@pathInHost', 'nvarchar(256)') 'hardDisk/@pathInHost'
								FROM containerProp.nodes('hardDisk') O(ref)
							FOR XML PATH (''), TYPE)
						FOR XML PATH ('hardDisks'), TYPE),
						containerProp.query('/virtualMachine[1]/dockerProperties'),
						containerProp.query('/virtualMachine[1]/advancedProperties')
					FROM  #containerList
					FOR XML PATH('virtualMachines'), TYPE)
				FOR XML PATH(''),
				ROOT('Ida_GetVirtualMachinesResp'))
		goto EXIT_PROC
	END
	IF ( @isDeep = 0 and @i_isLiveMount = 0)
	BEGIN
		INSERT	INTO #vmListTable ( clientId, clientName, creationTime, vmGUID, dataCenterId, vcenterName, policyId, powerState, guestOS, ipaddress, isTemplate, instanceType, updateTimeStamp, vsInstanceType,
		dnsHostName,hostName,memory,noCPU,numberOfDisks,connectionString)
		SELECT	C.id, C.name,ISNULL(dbo.GetUnixTime(VM.addTimeStamp),0) , VM.GUID, DC.id, DC.vCenter, VM.vmAllocationPolicyId,
				vmx.value('@powerState', 'int'), vmx.value('@guestOS', 'nvarchar(1024)'), vmx.value('@ipAddress', 'nvarchar(1024)'), ISNULL(vmx.value('@isTemplate', 'INT'),0),
				instanceType = dbo.GetVMInstanceTypeDesc(vmx.value('instancedetails[1]/instance[1]/@instanceType', 'varchar(1024)')), VM.timeStamp, 0,
				(CASE WHEN ISNULL(vmx.value('@DNSHostName', 'nvarchar(256)'), '') = '' THEN vmx.value('@ipAddress', 'nvarchar(1024)') ELSE vmx.value('@DNSHostName', 'nvarchar(256)') END),
				 vmx.value('@Hostname', 'NVARCHAR(255)'), vmx.value('memory[1]/@memorySizeMB', 'bigint')/(1024*1024), vmx.value('cpu[1]/@numCpu', 'nvarchar(1024)'),vmx.value('count(hardDisks/hardDisk)', 'int'),
				(CASE WHEN ISNULL(vmx.value('@rdpConnection', 'NVARCHAR(255)'), '') <> '' THEN vmx.value('@rdpConnection', 'NVARCHAR(255)') ELSE ISNULL(vmx.value('@sshConnection', 'NVARCHAR(255)'), '') END)
		FROM	#clientLst TmpCl
			INNER JOIN APP_Client C on C.id = TmpCl.clientId
			INNER JOIN App_VM VM
				ON VM.clientId = C.id
			INNER JOIN App_VMHost H
				ON VM.vHostId = H.id
			INNER JOIN App_VMDataCenter DC
				ON H.vDataCenterId = DC.id
			CROSS APPLY VM.vxml.nodes ('QSMServer_QVirtualMachineReq') M(vmx)
		WHERE	VM.removalTimeStamp IS NULL
			AND	ISNULL(vmx.value('@isTemplate', 'INT'), 0) = @i_isTemplate
			AND	(VM.vmAllocationPolicyId = @i_policyId OR @i_policyId = 0 OR @i_policyId IS NULL)
		UPDATE	#vmListTable
		SET		vsInstanceType = IP.attrVal,
				instanceId = IP.componentNameId
		FROM	#vmListTable VM
			LEFT OUTER JOIN App_VMDataCenterMap DCM ON DCM.vDataCenterId = VM.dataCenterId
			LEFT OUTER JOIN APP_InstanceProp IP ON DCM.instanceId = IP.componentNameId AND IP.attrName = 'Virtual Server Instance Type' AND IP.modified = 0
		IF @i_isTestFailover > 0 AND (@i_replicationId > 0 OR @i_vAppId >0)
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#testFailoverMachines') IS NOT NULL DROP TABLE #testFailoverMachines
			CREATE TABLE #testFailoverMachines (clientId INT, replicationId	INT)
			if @i_vAppId >0
			BEGIN
				INSERT INTO #testFailoverMachines
				select apps.clientId,
				      R.replicationId
				from
				(select M.vmx.value('@clientId', 'INT') as clientId,
						M.vmx.value('@clientName', 'nvarchar(max)') as clientName
					from App_VirtualApp vApp
					cross apply vApp.vxml.nodes('Api_VirtualAppReq/vApp/clientList') M(vmx)
					where vApp.id = @i_vAppId and vApp.deleted = 0) as apps
				inner join APP_VSAReplication R
				on apps.clientName = R.sourceName
			END
			ELSE
			BEGIN
				INSERT INTO #testFailoverMachines
				select C.id,
					   R.replicationId
				from APP_VSAReplication R
				inner join APP_Client C
				on R.sourceName = C.name
				and R.replicationId = @i_replicationId
			END
			UPDATE #vmListTable
			SET replicationId = t.replicationId
			FROM
			(select P.clientId, R.replicationId
				 from
				 (select componentNameId as clientId,
							 [Source VM Client Id] as sourceClientId,
							 [Is Test DR Machine] as IsTestDRMAchine
								FROM ( SELECT componentNameId, attrName, attrVal
									   FROM APP_ClientProp  cProp
									   INNER JOIN #vmListTable vmList
									   ON cProp.componentNameId = vmList.clientId
									   AND cProp.modified = 0
									   ) as clients
								PIVOT ( MAX(attrVal) FOR attrName IN ( [Source VM Client Id], [Is Test DR Machine])
									   ) AS PV
				  ) as P
				  inner join App_client C
				  on C.id = P.sourceClientId
				  and P.IsTestDRMAchine = 1
				  inner join APP_VSAReplication R
				  on R.sourceName = C.name
				  inner join #testFailoverMachines tM
				  on tM.clientId = P.sourceClientId
				 and R.replicationId = tM.replicationId) t
				 inner join #vmListTable VM
				 on t.clientId = VM.clientId
			DELETE From #vmListTable where replicationId = 0
			IF object_id('tempdb.dbo.#testFailoverMachines') IS NOT null DROP TABLE #testFailoverMachines
		END
	END
	ELSE
	BEGIN
		UPDATE #vmListTable
		SET clientId = C.id,
			clientName = C.name
		FROM #vmListTable vmList
		INNER JOIN APP_Client C
		ON vmList.clientName is NOT NULL
		and vmList.clientName = C.name
		UPDATE #vmListTable
		SET clientId = C.id,
			clientName = C.name
		FROM #vmListTable vmList
		INNER JOIN APP_ClientProp cProp ON
		cProp.attrName ='Virtual Machine Instance UUID'
		AND cProp.attrVal = vmList.vmGUID
		AND cProp.modified =0
		INNER JOIN APP_Client C on
		C.id = cProp.componentNameId
		AND vmList.clientName IS NULL
		INNER JOIN App_VM VM
			ON VM.clientId = C.id AND VM.removalTimeStamp IS NULL
		UPDATE #vmListTable
		SET clientId = C.id,
			clientName = C.name
		FROM #vmListTable vmList
		INNER JOIN APP_ClientProp cProp ON
		cProp.attrName ='Virtual Machine GUID'
		AND cProp.attrVal = vmList.vmGUID
		AND cProp.modified =0
		INNER JOIN APP_Client C on
		C.id = cProp.componentNameId
		AND vmList.clientName IS NULL
		UPDATE #vmListTable
		SET vmGUID = ISNULL(vmList.vmGUID,vm.GUID)
		FROM App_VM vm
		INNER JOIN #vmListTable vmList
		on vm.clientId = vmList.clientId
		AND vmList.vmGUID IS NULL AND vm.removalTimeStamp IS NULL
	END
	-- update capabilities of vm for the user
	IF @isUserAdmin <> 1
	BEGIN
		UPDATE VM
SET userCapabilities = (CASE WHEN CHARINDEX(',1,',','+permissionList+',') <> 0 THEN 1 ELSE 0 END |						-- 'EV_SCHEDULE_ADMIN'
CASE WHEN CHARINDEX(',2,',','+permissionList+',') <> 0 THEN 2 ELSE 0 END |					-- 'EV_MANAGE_APPLICATION'
CASE WHEN CHARINDEX(',160,',','+permissionList+',') <> 0 THEN 4 ELSE 0 END |					-- 'CAT_VM_SNAPSHOT_CREATE'
CASE WHEN CHARINDEX(',161,',','+permissionList+',') <> 0 THEN 8 ELSE 0 END |					-- 'CAT_VM_SNAPSHOT_DELETE'
CASE WHEN CHARINDEX(',162,',','+permissionList+',') <> 0 THEN 16 ELSE 0 END |				-- 'CAT_VM_SNAPSHOT_REVERT'
CASE WHEN CHARINDEX(',167,',','+permissionList+',') <> 0 THEN 32 ELSE 0 END |						-- 'CAT_VM_POWER_ON'
CASE WHEN CHARINDEX(',168,',','+permissionList+',') <> 0 THEN 64 ELSE 0 END |						-- 'CAT_VM_POWER_OFF'
CASE WHEN CHARINDEX(',169,',','+permissionList+',') <> 0 THEN 128 ELSE 0 END |						-- 'CAT_VM_REFRESH'
CASE WHEN CHARINDEX(',163,',','+permissionList+',') <> 0 THEN 256 ELSE 0 END |							-- 'CAT_VM_EDIT'
CASE WHEN CHARINDEX(',164,',','+permissionList+',') <> 0 THEN 512 ELSE 0 END |						-- 'CAT_VM_DELETE'
CASE WHEN CHARINDEX(',165,',','+permissionList+',') <> 0 THEN 1024 ELSE 0 END |					-- 'CAT_VM_EXPIRATION'
CASE WHEN CHARINDEX(',166,',','+permissionList+',') <> 0 THEN 2048 ELSE 0 END |						-- 'CAT_VM_CLONE'
CASE WHEN CHARINDEX(',101,',','+permissionList+',') <> 0 THEN 12288 ELSE 0 END 	-- 'CAT_USER_MANAGMENT_USER_MANAGEMENT'
								)
		FROM #vmListTable VM
			INNER JOIN #clientLst CL
				ON VM.clientId = CL.clientId
	END
	ELSE
	BEGIN
		UPDATE #vmListTable
		SET userCapabilities = 0xFFFF
	END
	IF @i_specialVMFlag & 4 = 4
	BEGIN
		IF @i_specialVMFlag & 2 = 2
		BEGIN
			-- Delete all policy vms except live mount policy and Amazon Lab policy which has autoshutdown option set and lab migration VMs
			DELETE VM FROM #vmListTable VM INNER JOIN App_VmAllocationPolicy APPV ON VM.policyId = APPV.id AND (APPV.flags & 8 <> 8) AND (APPV.flags & 2 <> 2) AND (APPV.flags & 16 <> 16) AND (APPV.flags & 32 <> 32)
		END
		ELSE
		BEGIN
			DELETE VM FROM #vmListTable VM INNER JOIN App_VmAllocationPolicy APPV ON VM.policyId = APPV.id AND APPV.flags & 2 = 2 -- special VM policy flag has 2nd bit set as 1
		END
	END
   IF (@i_instanceId > 0)
   BEGIN
		-- delete all the vms which do not correspond to the given instanceId
		DELETE FROM #vmListTable where instanceId is null or instanceId != @i_instanceId
	END
   IF ( @i_labId > 0)
   BEGIN
    IF EXISTS (SELECT * FROM App_VirtualLab WHERE  name = @i_labName AND deleted = 0)
    BEGIN
			DELETE #vmListTable
			FROM #vmListTable vmList
			LEFT JOIN (  SELECT clientId FROM APP_VM
			INNER JOIN (
						  SELECT CAST(VLP.attrVal as XML) vmList,
						  VLP.componentNameId labId
						  FROM APP_VirtualLabProp VLP WITH (nolock)
                          WHERE VLP.componentNameId = @i_labId
						  and VLP.attrName = 'Virtual Lab Machine List'
                          and VLP.modified =0
			) t1
			on t1.labId =  @i_labId
			CROSS APPLY t1.vmList.nodes('/vmList/vm') n(n)
			WHERE GUID = n.value('@vmGUID','nvarchar(max)')
			)
			t
			on vmList.clientId = t.clientId
			WHERE t.clientId is  null
	END
	ELSE
	BEGIN
			DELETE  #vmListTable
			FROM #vmListTable vmList
			LEFT JOIN ( Select clientId from APP_ClientGroupAssoc cga
					inner join APP_ClientGroup cg
					on cg.flag = 0x20000 and cg.id = @i_labId
			and cga.clientGroupId = cg.id) t
			on vmList.clientId = t.clientId
			WHERE t.clientId is null
	END
   END
	IF (@isDeep <> 0)
	BEGIN
		UPDATE #vmListTable
		 SET policyId = svm.vmAllocationPolicyId,
			powerState =vm.value('@powerState', 'int'),
			guestOS  = vm.value('@guestOS', 'nvarchar(1024)'),
			ipaddress = vm.value('@ipAddress', 'nvarchar(1024)'),
			isTemplate = ISNULL(vm.value('@isTemplate', 'INT'),0),
			memory = vm.value('memory[1]/@memorySizeMB', 'bigint')/(1024*1024),
			noCPU  =  vm.value('cpu[1]/@numCpu', 'nvarchar(1024)'),
			noNICS = vm.value('count(adapter/NetworkAdapter)', 'int'),
			vHostId = svm.vHostId,
			instanceType = dbo.GetVMInstanceTypeDesc(vm.value('instancedetails[1]/instance[1]/@instanceType', 'varchar(1024)')),
			dnsHostName = CASE WHEN ISNULL(vm.value('@DNSHostName', 'nvarchar(256)'), '') = '' THEN vm.value('@ipAddress', 'nvarchar(1024)') ELSE vm.value('@DNSHostName', 'nvarchar(256)') END,
			hostName = vm.value('@Hostname', 'NVARCHAR(255)'),
			connectionString = CASE WHEN ISNULL(vm.value('@rdpConnection', 'NVARCHAR(255)'), '') <> '' THEN vm.value('@rdpConnection', 'NVARCHAR(255)')
                                ELSE ISNULL(vm.value('@sshConnection', 'NVARCHAR(255)'), '')
                            END,
			numberOfDisks = vm.value('count(hardDisks/hardDisk)', 'int'),
			vmName = svm.name
		 FROM #vmListTable vmList
		 INNER JOIN App_VM svm
		 CROSS APPLY svm.vxml.nodes ('QSMServer_QVirtualMachineReq') M(vm)
		 ON svm.clientId = vmList.clientId
		 AND svm.removalTimeStamp IS null
		 UPDATE	#vmListTable
		 SET	isTemplate = CASE WHEN cast(attrVal as int) & 2 >0  THEN 1 ELSE 0 END
		 FROM	#vmListTable, APP_ClientProp
		 WHERE	clientId = componentNameId
			AND	attrName = 'Virtual Entity Flags'
		UPDATE #vmListTable
		SET		snapshotCount = O.snapsCount
		FROM
			(SELECT T.clientID, COUNT(*) AS snapsCount
			FROM	#vmListTable T
					INNER JOIN App_VM V
						ON T.clientId = V.clientId
					INNER JOIN App_VmSnapShot S
						ON V.id = S.vmId AND S.removalTimeStamp IS NULL
                                                AND S.name <> '_GX_BASE_SNAP_'
			GROUP BY T.clientID) O, #vmListTable tmp
		WHERE O.clientId = tmp.clientId
		update #vmListTable
		set backupVM = 1
		from ( SELECT SCP.componentNameId, T.c.value('@displayName', 'NVARCHAR(256)') AS VMName
			   FROM   (SELECT componentNameId, CAST(CAST(attrVal AS VARCHAR(MAX)) AS XML) AS attrVal
                    FROM    APP_SubClientProp WITH (NOLOCK)
                    WHERE   attrName = 'Virtual Server Dyanimc Content' AND modified = 0
                    ) SCP
					CROSS APPLY SCP.attrVal.nodes('/VirtualServer_VMSubClientEntity/children') AS T(c)
			) T
		inner join #vmListTable vmList
		on vmList.vmName = T.VMName
		inner join app_vmallocationpolicy p
		on vmList.policyId = p.id
		and p.vxml.value('/policy[1]/@enableBackup', 'int') = 1
		and p.vxml.value('/policy[1]/subClientEntity[1]/@subclientId', 'int') = T.componentNameId
	END
	--updating lab name for version one virtual lab vms.
	UPDATE vmList
	SET vmList.labName = cg.name
	FROM #vmListTable as vmList
	INNER JOIN APP_ClientGroupAssoc cga WITH (nolock)
	on vmList.clientId = cga.clientId
	INNER JOIN APP_ClientGroup cg WITH (nolock)
    ON cg.id = cga.clientGroupId  AND cg.flag & 0x20000 != 0
	--updating lab name for version two virtual lab vms.
	UPDATE vmList
	SET vmList.labName = t1.labName,
	 vmList.labId = t1.labId,
	 vmList.labJobId = (CASE WHEN (isnull(t1.labJobId,0) != 0) THEN t1.labJobId ELSE '' END)
	FROM #vmListTable vmList inner join
	(select vl.id as 'labId', vl.name as 'labName',vlp2.attrVal as 'labJobId',I.I.value('@vmGUID','nvarchar(max)')  as 'vmGuid'
	from APP_VirtualLab vl inner join App_VirtualLabProp vlp1 on vl.id = vlp1.componentNameId and vlp1.attrName = 'Virtual Lab Machine List' and vlp1.modified = 0 and vl.deleted = 0
	left join  App_VirtualLabProp vlp2 on vl.id = vlp2.componentNameId and vlp2.attrName = 'Virtual Lab Parent Job Id' and vlp2.modified = 0
	cross apply (select cast(vlp1.attrVal as xml)) as V(V)
	cross apply V.V.nodes('/vmList/vm') as I(I) ) t1
	on t1.vmGuid = vmList.vmGUID
	UPDATE	#vmListTable
	SET		connectionString = CP.attrVal
	FROM	#vmListTable V
			INNER JOIN APP_ClientProp CP
				ON	V.clientId = CP.componentNameId
				AND	CP.attrName = 'RDP Connection String'
	WHERE	ISNULL(connectionString, '') = ''
	update #vmListTable
	set isRenewalsinPolicyAllowed = 0
	from #vmListTable vmList
	inner join app_vmallocationpolicy p
	on vmList.policyId = p.id
	and ISNULL(p.vxml.value('/policy[1]/@allowRenewals', 'int') ,'1')= 0
	UPDATE #vmListTable
	SET
		vmName = P.vmName,
		creator = P.creator,
		expirationTime = CASE WHEN vmList.policyId <> @systemPolicyId THEN ISNULL(P.expirationTime, 0)
							WHEN vmList.policyId = @systemPolicyId AND (ISNULL(P.isVirtualizeMeVM,0) = 1 OR ISNULL(P.cloneCopy,'') != '' OR ISNULL(P.isLiveMountedVM,'') != '') THEN ISNULL(P.expirationTime, 0)
							ELSE 0
					   END,
		isArchived = P.isArchived,
		canBeRenewed = CASE WHEN vmList.policyId <> @systemPolicyId AND isRenewalsinPolicyAllowed=1 THEN 1
							WHEN vmList.policyId = @systemPolicyId AND (ISNULL(P.isVirtualizeMeVM,0) = 1 OR ISNULL(P.cloneCopy,'') != '') AND ISNULL(P.expirationTime, 0) > 0 THEN 1
							ELSE 0
					   END,
		lastPoweredOnTime = P.lastPowerOnTime,
		loginUserName = P.loginUserName,
		isVirtualLabGateway = isnull(P.isVirtualLabGateway,0)
	FROM #vmListTable vmList
	INNER JOIN
	( select componentNameId as clientId,
			 [Virtual Machine Name] as vmName,
			 [Virtual Machine Created by User] as creator,
			 [Virtual Machine Reserved Until] as expirationTime,
			 [Is Client Archived] as isArchived,
			 [VirtualizeMe VM] as isVirtualizeMeVM,
             [Virtual Machine Parent Template GUID] as cloneCopy,
			 [Virtual Machine Last Powered On Time] as lastPowerOnTime,
			 [Virtual Machine Live Mount Property] as isLiveMountedVM,
             [Virtual Machine Login Username] as loginUserName,
			 [IsVirtualLabGateway] as isVirtualLabGateway
		FROM ( SELECT componentNameId, attrName, attrVal
			   FROM APP_ClientProp  cProp
			   INNER JOIN #vmListTable vmList
			   ON cProp.componentNameId = vmList.clientId
			   AND cProp.modified = 0
			   ) as clients
		PIVOT ( MAX(attrVal) FOR attrName IN ( [Virtual Machine Name], [Virtual Machine Created by User],
		                                      [Virtual Machine Reserved Until],[Is Client Archived], [VirtualizeMe VM],[Virtual Machine Parent Template GUID],
											  [Virtual Machine Last Powered On Time], [Virtual Machine Live Mount Property],
                                              [Virtual Machine Login Username], [IsVirtualLabGateway]
											 )
			   ) AS PV
     ) AS P ON P.clientId = vmList.clientId
    UPDATE  #vmListTable
    set proxyClientId = S.clientId
    FROM
    (
    select instance, MAX(A.clientId) as clientId
    FROM APP_Application A
    inner join #vmListTable vmList
    on A.instance = vmList.instanceId
    GROUP by instance
    ) S
    INNER JOIN #vmListTable vmList
    on vmList.instanceId = S.instance
	IF @isDeep <> 0
	BEGIN
		UPDATE #vmListTable
		SET guestOS = Prop.attrVal
			FROM #vmListTable vmList
		INNER JOIN APP_ClientProp Prop
			ON	vmList.clientId = Prop.componentNameId
		WHERE	guestOS IS NOT NULL AND guestOS <> ''
			AND	Prop.attrName = 'Operating System Name'
			AND Prop.modified = 0
			AND Prop.attrVal <> N''   -- attrVal cannot be set to NULL
 		UPDATE #vmListTable
 		SET		purpose =  C.clientDescription,
 				osType = ( CASE WHEN OS.Type = 'Windows' THEN 1
						 WHEN OS.Type = 'Unix' THEN 2
						 ELSE 0 END )
		FROM #vmListTable vmList
		INNER JOIN APP_Client C ON
		C.id = vmList.clientId
		LEFT OUTER JOIN simOperatingSystem OS ON OS.id = C.simOperatingSystemId
    END
	-- Update Guest OS
    UPDATE	#vmListTable
    SET		guestOS = SUBSTRING(CP.attrVal, 0, CHARINDEX(':-', CP.attrVal))
    FROM	#vmListTable V
			INNER JOIN	App_ClientProp CP
			ON V.clientID = CP.componentNameID
	WHERE	CP.attrName = 'Sim OS Info'
		AND	ISNULL(guestOS, '') = ''
	IF ( ISNULL(@i_vendor,0) >0 )
	BEGIN
	    update #vmListTable
	    set vendor = ( case when vsInstanceType = 101 then 1
	                    when vsInstanceType = 102 then 2
						when vsInstanceType = 301 then 4
						when vsInstanceType = 401 then 5
						when vsInstanceType = 402 then 7
						when vsInstanceType =1101 then 13
						when vsInstanceType = 1001 then 11
						when vsInstanceType = 1102 then 19
					end
				)
		DELETE FROM #vmListTable
		WHERE  vendor != @i_vendor
	END
	IF @o_ErrorCode = 0
	BEGIN
		IF @i_isTemplate = 0
		BEGIN
			IF ( @isDeep = 0 )
			BEGIN
				SET @o_xmlText = ( SELECT
						(SELECT vmList.guestOS '@operatingSystem',
							vmList.powerState '@vmState',
							vmList.policyId  '@vmAllocPolicyId',
							vmList.isArchived '@isArchived'	,
							vmList.userCapabilities '@userCapabilities',
							vmList.isVirtualLabGateway as '@isVirtualLabGateway',
							vsInstanceType as '@flags',
							vmList.memory '@memory',
							vmList.noCPU '@numberOfCPUs',
							vmList.numberOfDisks '@numberOfDisks',
							vmList.instanceId as 'entity/@instanceId',
							vmList.proxyClientId as 'proxyClient/@clientId',
							(SELECT ISNULL(vmList.creationTime, 0) '@time', 55 '@_type_'
							FOR XML PATH ('creationTime'), TYPE),
(SELECT ISNULL(vmList.expirationTime, 0) '@time', 55 '@_type_'
								FOR XML PATH ('expirationTime'), TYPE),
							(SELECT ISNULL(vmList.lastPoweredOnTime, 0) '@time'
								FOR XML PATH ('lastPowerOnTime'), TYPE),
                            (SELECT dbo.GetUnixTime(vmlist.updateTimeStamp) '@time' , 55 '@_type_'
								FOR XML PATH('modifiedTime'), TYPE),
							(SELECT
								vmList.vmName  '@vmName', vmList.vmGUID '@vmGUID', vmList.clientId '@clientId', vmList.clientName '@clientName', vmList.dnsHostName '@hostName'
								FOR XML PATH ('vm'), TYPE),
							(
								SELECT vmList.ipAddress '@address' , 32 as '@family', 0 as '@subnet'
								FOR XML PATH ('ipAddress'), TYPE),
															(SELECT U.id '@userId', U.login '@userName', U.userGuid '@userGUID'
									FROM UMUsers U
								 WHERE U.id = CAST(vmList.creator AS INT)
								FOR XML PATH('creator'), TYPE),
							(select vmList.instanceType '@vmInstanceTypeName' FOR XML PATH('instanceTypeEntity'), TYPE),
							(SELECT
								 vmList.vcenterName '@vCenter',
								 DC.name '@dataCenterName',
								 vmList.hostName '@hostName'
								FOR XML PATH ('vmLocation'), TYPE),
							(SELECT
								(P.flags & 2) | ISNULL(vmList.canBeRenewed,0) AS '@additionalFlags', -- I bit: is live mount or not, II bit: it can be renewed or not
								vmList.connectionString AS '@connectionString',
								loginUserName AS '@userName',
								vmList.labName AS '@labName',
								vmList.labId AS '@labId',
								vmList.labJobId AS '@labJobId'
								FROM App_VmAllocationPolicy P
								WHERE P.id = vmList.policyId
								FOR XML PATH('advancedProperties'), TYPE)
						 FROM  #vmListTable vmList
							LEFT OUTER JOIN APP_VMDataCenter DC ON DC.id = vmList.dataCenterId
						 WHERE (vmList.isTemplate = @i_isTemplate)
						ORDER BY vmList.vcenterName
						FOR XML PATH('virtualMachines'), TYPE)
				FOR XML PATH(''),
				ROOT('Ida_GetVirtualMachinesResp'))
			END
			ELSE
			BEGIN
    			SET @o_xmlText = ( SELECT
					(SELECT
						vmList.memory '@memory', vmList.purpose '@purpose',
						CASE WHEN vm.value('@DNSHostName', 'nvarchar(1024)') <> '' THEN vm.value('@DNSHostName', 'nvarchar(1024)')
                        ELSE vm.value('@ipAddress', 'nvarchar(1024)')
                        END  '@vmHost',
 						vmList.osType '@osType',
						vmList.guestOS '@operatingSystem', vmList.noCPU '@numberOfCPUs', vmList.isTemplate '@isTemplate',
						vmList.powerState '@vmState', vmList.noNICS '@numberOfNICs',
						vmList.numberOfDisks '@numberOfDisks',
						vmList.policyId  '@vmAllocPolicyId',
						vmList.toolsVersion '@toolsVersion',
						vmList.isArchived '@isArchived',
						vmList.backupVM as  '@backupVM',
						vmList.userCapabilities '@userCapabilities',
						vmList.isVirtualLabGateway as '@isVirtualLabGateway',
						-- when there are multiple hypervisor client for same vcenter, it has multiple instance due to that it happen to return same vm details multiple times, to avoid this returning instancetype/instanceid by latest hypervisor
						(SELECT top 1 IP.attrVal FROM APP_InstanceProp IP LEFT OUTER JOIN App_VMDataCenterMap DCM ON DCM.vDataCenterId = DC.id AND IP.componentNameId =  DCM.instanceId AND IP.attrName = 'Virtual Server Instance Type' AND IP.modified = 0 AND IP.attrVal is not null  order by  DCM.instanceId desc ) as '@flags', --Using flags attribute in VirtualMachine Message for instanceType
						(SELECT top 1 DCM.instanceId FROM App_VMDataCenterMap DCM WHERE DCM.vDataCenterId = DC.id order by  DCM.instanceId desc )as 'entity/@instanceId',
						vmList.proxyClientId  as 'proxyClient/@clientId',
						(SELECT ISNULL(dbo.GetUnixTime(VM.addTimeStamp), 0) '@time', 55 '@_type_'
							FOR XML PATH ('creationTime'), TYPE),
(SELECT ISNULL(vmList.expirationTime, 0) '@time', 55 '@_type_'
							FOR XML PATH ('expirationTime'), TYPE),
						(SELECT ISNULL(vmList.lastPoweredOnTime, 0) '@time'
								FOR XML PATH ('lastPowerOnTime'), TYPE),
						(SELECT
								ISNULL(vmList.vmName,vm.value('@name', 'nvarchar(1024)'))  '@vmName', vmList.vmGUID '@vmGUID', vmList.clientId '@clientId', vmList.clientName '@clientName', vmList.dnsHostName '@hostName'
							FOR XML PATH ('vm'), TYPE),
						(
							SELECT vmList.ipAddress '@address' , 32 as '@family', 0 as '@subnet'
							FOR XML PATH ('ipAddress'), TYPE),
						(select vmList.instanceType '@vmInstanceTypeName' FOR XML PATH('instanceTypeEntity'), TYPE),
						(SELECT
							ISNULL(DC.vCenter, vmList.vcenterName) '@vCenter', DC.name '@dataCenterName', VH.name '@hostName'
							FOR XML PATH ('vmLocation'), TYPE),
						(SELECT
							(SELECT CASE WHEN ISNULL(ref.value('@label', 'nvarchar(1024)'), '') <> '' THEN ref.value('@label', 'nvarchar(1024)')
									WHEN (vmList.isTemplate = 1) and ISNULL(ref.value('@summary', 'nvarchar(1024)'), '') <> '' THEN ref.value('@summary', 'nvarchar(1024)')
									ELSE ISNULL(ref.value('@volumeId', 'nvarchar(1024)'), '') END 'hardDisk/@label',
									CASE WHEN ISNULL(ref.value('@volumeId', 'nvarchar(1024)'),'') <> '' and vsInstanceType not in ( 401,402,403)
									THEN ref.value('@volumeId', 'nvarchar(1024)')
									ELSE cast(row_number() over (order by (select 1)) as nvarchar(1024)) END   'hardDisk/@diskUniqueID',
									ref.value('@capacityInKb', 'bigint')/(1024*1024) 'hardDisk/@diskSize',
									CASE
									WHEN ref.value('@thinProvisioned', 'int')=1 THEN 1
									ELSE 2 END 'hardDisk/@diskType',
									CASE WHEN ref.value('@status', 'varchar(30)') = 'root' THEN 4
									ELSE 2 END 'hardDisk/@srcHdType',
									ISNULL(ref.value('@diskFileName','nvarchar(1024)'),'') 'hardDisk/@uniqueDiskName'
								FROM hd.nodes('*') O(ref)
							FOR XML PATH (''), TYPE)
						FOR XML PATH ('hardDisks'), TYPE),
						(SELECT U.id '@userId', U.login '@userName', U.userGuid '@userGUID'
									FROM UMUsers U
								 WHERE U.id = CAST(vmList.creator AS INT)
							 FOR XML PATH('creator'), TYPE),
						(SELECT
								(P.flags & 2) | ISNULL(vmList.canBeRenewed,0) AS '@additionalFlags', -- I bit: is live mount or not, II bit: it can be renewed or not
								vmList.snapshotCount AS '@snapshotCount',
								vmList.connectionString AS '@connectionString',
								loginUserName AS '@userName',
								vmList.labName AS '@labName',
								vmList.labId AS '@labId',
								vmList.labJobId AS '@labJobId',
								(SELECT a.n.value('@summary','nvarchar(255)') AS '@networkName',
										a.n.value('@label','nvarchar(255)') AS '@label',
										a.n.value('@macAddress','nvarchar(255)') AS '@macAddress',
										a.n.value('@subnetId','nvarchar(255)') AS 'subnetNames/@name'
									FROM vm.nodes('./adapter/NetworkAdapter') a(n)
									FOR XML PATH('networkCards'), TYPE)
								FROM App_VmAllocationPolicy P
								WHERE P.id = vmList.policyId
								FOR XML PATH('advancedProperties'), TYPE)
					FROM  #vmListTable vmList
					LEFT OUTER JOIN App_VM VM ON VM.clientId = vmList.clientId
					LEFT OUTER JOIN App_VMHost VH ON VH.id = VM.vHostId
					LEFT OUTER JOIN App_VMDataCenter DC ON DC.id = VH.vDataCenterId
					-- when there are multiple hypervisor client for same vcenter, it has multiple instance due to that it happen to return same vm details multiple times
					--LEFT OUTER JOIN App_VMDataCenterMap DCM ON DCM.vDataCenterId = DC.id
					--LEFT OUTER JOIN APP_InstanceProp IP ON DCM.instanceId = IP.componentNameId AND IP.attrName = 'Virtual Server Instance Type' AND IP.modified = 0
					CROSS APPLY VM.vxml.nodes ('QSMServer_QVirtualMachineReq') M(vm)
					CROSS APPLY VH.vxml.nodes ('QSMServer_QVirtualHostReq') H(vh)
					CROSS APPLY vm.nodes ('./hardDisks') D(hd)
					WHERE
						(vmList.guestOS = @i_OS OR @i_OS = '' OR @i_OS IS null)
						--AND VM.clientId = vmList.clientId
						AND VM.removalTimeStamp IS null
					FOR XML PATH('virtualMachines'), TYPE)
		      	FOR XML PATH(''),
			    ROOT('Ida_GetVirtualMachinesResp'))
	       	END
		END
		ELSE
		BEGIN
		    DECLARE @i_instanceType INT
			if (@isDeep <> 0)
			BEGIN
				SET @i_instanceType = 101
				SELECT  @i_instanceType =  CAST(I.attrVal AS INT) FROM
					APP_InstanceProp  I WITH(NOLOCK) INNER JOIN App_VMDataCenterMap D WITH(NOLOCK)
						ON I.componentNameId = D.instanceId
						AND I.attrName = 'Virtual Server Instance Type'
						AND I.modified = 0
					INNER JOIN APP_VMHost VH WITH(NOLOCK)
						ON D.vDataCenterId =VH.vDataCenterId
					INNER JOIN APP_VM  VM WITH(NOLOCK)
						ON VH.id = VM.vhostId
						AND VM.GUID IN (SELECT TOP 1 vmGUID FROM #vmListTable)
			END
			IF @i_policyId >0 and @i_instanceType is null and @i_vendor is null
			BEGIN
			   SELECT @i_instanceType =  CAST(I.attrVal AS INT) FROM
					APP_InstanceProp I WITH(NOLOCK) INNER JOIN App_VMDataCenterMap D WITH(NOLOCK)
						ON I.componentNameId = D.instanceId
						AND I.attrName = 'Virtual Server Instance Type'
						AND I.modified = 0
					INNER JOIN App_VmAllocationPolicy P WITH(NOLOCK)
						ON P.vDataCenterId = D.vDataCenterId
						AND P.id = @i_policyId
			END
			 if @i_instanceType = 101
					SET @i_vendor = 0
				else if @i_instanceType = 102
					SET @i_vendor = 2
				else if @i_instanceType = 301
					SET @i_vendor = 4
				else if @i_instanceType = 401
					SET @i_vendor = 5
				else if @i_instanceType = 402
					SET @i_vendor = 7
				else if @i_instanceType = 1101
					SET @i_vendor = 13
			 	else if @i_instanceType = 1001
					SET @i_vendor = 11
				else
				    SET @i_vendor = 1
			-- FOR ALL VM VARE
			IF(@i_vendor <> 4 AND @i_vendor <> 5 AND  @i_vendor <>  7 AND @i_vendor <> 13 AND @i_vendor <> 11 AND @i_vendor<> 17)
			BEGIN
				SET @o_xmlText = ( SELECT
					(SELECT
						vm.value('memory[1]/@memorySizeMB', 'bigint')/(1024*1024) '@memory', CL.clientDescription '@purpose',
						vmList.isVirtualLabGateway as '@isVirtualLabGateway',
						CASE WHEN OS.Type = 'Windows' THEN 1
						WHEN OS.Type = 'Unix' THEN 2
						ELSE 0 END '@osType',
						vmList.guestOs '@operatingSystem', vm.value('cpu[1]/@numCpu', 'nvarchar(1024)') '@numberOfCPUs', vm.value('@isTemplate', 'int') '@isTemplate',
						vm.value('@powerState', 'int') '@vmState', vm.value('count(adapter/NetworkAdapter)', 'int') '@numberOfNICs',
						ISNULL(vm.value('@toolsVersion', 'int'), 0) '@toolsVersion',
						(SELECT
							vm.value('@name', 'nvarchar(1024)') '@vmName', vm.value('@guid', 'nvarchar(1024)') '@vmGUID', VM.clientId '@clientId', CL.name '@clientName', vmList.dnsHostName '@hostName'
							FOR XML PATH ('vm'), TYPE),
						(SELECT
							DC.vCenter '@vCenter', DC.name '@dataCenterName', VH.name '@hostName'
							FOR XML PATH ('vmLocation'), TYPE),
						(SELECT
							(SELECT CASE WHEN ISNULL(ref.value('@label', 'nvarchar(1024)'), '') <> '' THEN ref.value('@label', 'nvarchar(1024)')
									ELSE ISNULL(ref.value('@volumeId', 'nvarchar(1024)'), '') END 'hardDisk/@label',
									ref.value('@capacityInKb', 'bigint')/(1024*1024) 'hardDisk/@diskSize',
									CASE
									WHEN ref.value('@thinProvisioned', 'int')=1 THEN 1
									ELSE 2 END 'hardDisk/@diskType',
									ISNULL(ref.value('@diskFileName','nvarchar(1024)'),'') 'hardDisk/@uniqueDiskName',
									cast(row_number() over (order by (select 1)) as nvarchar(1024))  'hardDisk/@diskUniqueID'
								FROM hd.nodes('*') O(ref)
							FOR XML PATH (''), TYPE)
						FOR XML PATH ('hardDisks'), TYPE),
						(SELECT
								(P.flags & 2) AS '@additionalFlags', -- I bit: it can be renewed or not, II bit: is live mount or not
								loginUserName AS '@userName',
								vmList.labName AS '@labName',
								vmList.labId AS '@labId',
								vmList.labJobId AS '@labJobId'
								FROM App_VmAllocationPolicy P
								WHERE P.id = vmList.policyId
								FOR XML PATH('advancedProperties'), TYPE)
					FROM  #vmListTable vmList
					INNER JOIN App_VM VM ON VM.clientId = vmList.clientId
					LEFT OUTER JOIN App_VMHost VH ON VH.id = VM.vHostId
					LEFT OUTER JOIN App_VMDataCenter DC ON DC.id = VH.vDataCenterId
					LEFT OUTER JOIN APP_Client CL ON CL.id = VM.clientId
					LEFT OUTER JOIN simOperatingSystem OS ON OS.id = CL.simOperatingSystemId
					CROSS APPLY VM.vxml.nodes ('QSMServer_QVirtualMachineReq') M(vm)
					CROSS APPLY VH.vxml.nodes ('QSMServer_QVirtualHostReq') H(vh)
					CROSS APPLY vm.nodes ('./hardDisks') D(hd)
					WHERE
						VM.removalTimeStamp IS null
						AND ((vm.value('@isTemplate', 'INT') = @i_isTemplate) OR vmList.isTemplate = @i_isTemplate)
						AND ((( ISNULL(vm.value('@toolsVersion','INT'), 0) > 8288 )
						AND (VM.GUID in (SELECT vmGUID FROM #vmListTable) OR NOT EXISTS (SELECT * FROM #vmListTable))
						--Only following windows versions are supported
						AND ( ISNULL(vm.value('@guestOSVersion','varchar(100)'), '') like 'winVista%' OR
							  ISNULL(vm.value('@guestOSVersion','varchar(100)'), '') like 'winLonghorn%' OR
							  ISNULL(vm.value('@guestOSVersion','varchar(100)'), '') like 'windows7%' OR
							  ISNULL(vm.value('@guestOSVersion','varchar(100)'), '') like 'windows8%' OR
							  ISNULL(vm.value('@guestOSVersion','varchar(100)'), '') like 'windows9%' OR
							  ISNULL(vm.value('@guestOSVersion','varchar(100)'), '') like 'rhel%' OR
							  ISNULL(vm.value('@guestOSVersion','varchar(100)'), '') like 'centos%' OR
							  --ISNULL(ds.value('@guestOSVersion','varchar(30)'), '') like 'freebsd%' OR
							  ISNULL(vm.value('@guestOSVersion','varchar(30)'), '') like 'ubuntu%'
							)) OR @i_vendor = 2) --VSVendor::MICROSOFT
					FOR XML PATH('virtualMachines'), TYPE)
				FOR XML PATH(''),
				ROOT('Ida_GetVirtualMachinesResp'))
			END
			ELSE
			BEGIN
				SET @o_xmlText = ( SELECT
						(SELECT
							vm.value('memory[1]/@memorySizeMB', 'bigint')/(1024*1024) '@memory', CL.clientDescription '@purpose',
							CASE WHEN OS.Type = 'Windows' THEN 1
							WHEN OS.Type = 'Unix' THEN 2
							ELSE 0 END '@osType',
							vm.value('@guestOS', 'nvarchar(1024)') '@operatingSystem', vm.value('cpu[1]/@numCpu', 'nvarchar(1024)') '@numberOfCPUs', vm.value('@isTemplate', 'int') '@isTemplate',
							vm.value('@powerState', 'int') '@vmState', vm.value('count(adapter/NetworkAdapter)', 'int') '@numberOfNICs',
							ISNULL(vm.value('@toolsVersion', 'int'), 0) '@toolsVersion',
(SELECT dbo.GetUnixTime(vm.timeStamp) '@time' , 55 '@_type_'
								FOR XML PATH('modifiedTime'), TYPE),
(SELECT dbo.GetUnixTime(vm.addTimeStamp) '@time' , 55 '@_type_'
								FOR XML PATH('creationTime'), TYPE),
							(SELECT
								CASE WHEN @i_vendor <> 5 THEN vm.value('@name', 'nvarchar(1024)') ELSE CL.net_hostname END AS '@vmName',
								vm.value('@guid', 'nvarchar(1024)') '@vmGUID', VM.clientId '@clientId', CASE WHEN ISNULL(vm.value('@DNSHostName', 'nvarchar(256)'), '') = '' THEN vm.value('@ipAddress', 'nvarchar(1024)') ELSE vm.value('@DNSHostName', 'nvarchar(256)') END as '@hostName'
								FOR XML PATH ('vm'), TYPE),
							(SELECT
								DC.vCenter '@vCenter', DC.name '@dataCenterName', VH.name '@hostName'
								FOR XML PATH ('vmLocation'), TYPE),
							(SELECT
								(SELECT CASE WHEN  isnull(vm.value('@vendorType','int'),0) in (301) and ISNULL(ref.value('@summary', 'nvarchar(1024)'), '') <> '' THEN ref.value('@summary', 'nvarchar(1024)')
									ELSE ref.value('@label', 'nvarchar(1024)') END 'hardDisk/@label',
									CASE WHEN ISNULL(ref.value('@volumeId', 'nvarchar(1024)'),'') <> '' and isnull(vm.value('@vendorType','int'),0) not in ( 401,402,403)
									THEN ref.value('@volumeId', 'nvarchar(1024)')
									ELSE cast(row_number() over (order by (select 1)) as nvarchar(1024)) END  'hardDisk/@diskUniqueID',										ref.value('@capacityInKb', 'bigint')/(1024*1024) 'hardDisk/@diskSize',
										CASE WHEN ref.value('@status', 'varchar(30)') = 'root' THEN 4
										ELSE 2 END 'hardDisk/@srcHdType'
									FROM hd.nodes('*') O(ref)
								FOR XML PATH (''), TYPE)
							FOR XML PATH ('hardDisks'), TYPE),
							(SELECT
								(P.flags & 2) AS '@additionalFlags', -- I bit: it can be renewed or not, II bit: is live mount or not
								(SELECT attrVal FROM App_ClientProp CP WHERE CL.ID = CP.componentNameID AND CP.attrName = 'Virtual Machine Login Username') AS '@userName'
								FROM App_VmAllocationPolicy P
								WHERE P.id = VM.vmAllocationPolicyId
								FOR XML PATH('advancedProperties'), TYPE)
						FROM  App_VM VM
						LEFT OUTER JOIN App_VMHost VH ON VH.id = VM.vHostId
						LEFT OUTER JOIN App_VMDataCenter DC ON DC.id = VH.vDataCenterId
						LEFT OUTER JOIN APP_Client CL ON CL.id = VM.clientId
						LEFT OUTER JOIN simOperatingSystem OS ON OS.id = CL.simOperatingSystemId
						CROSS APPLY VM.vxml.nodes ('QSMServer_QVirtualMachineReq') M(vm)
						CROSS APPLY VH.vxml.nodes ('QSMServer_QVirtualHostReq') H(vh)
						CROSS APPLY vm.nodes ('./hardDisks') D(hd)
						WHERE
							VM.removalTimeStamp IS null
							AND (vm.value('@isTemplate', 'INT') = @i_isTemplate)
							AND (VM.GUID in (SELECT vmGUID FROM #vmListTable) OR NOT EXISTS (SELECT * FROM #vmListTable))
						FOR XML PATH('virtualMachines'), TYPE)
				FOR XML PATH(''),
				ROOT('Ida_GetVirtualMachinesResp'))
			END
		END
	END
	ELSE
	BEGIN
		SET @o_xmlText = ( SELECT
				( SELECT @o_ErrorCode '@errorCode', @o_ErrorString '@errorString'
					FOR XML PATH('error'), TYPE
				)
		FOR XML PATH(''),
		ROOT('Ida_GetVirtualMachinesResp'))
	END
EXIT_PROC:
	SELECT @o_xmlText
	IF object_id('tempdb.dbo.#vmListTable') IS NOT null DROP TABLE #vmListTable
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VMP_GetAvailableVMs')
	delete from GxQscripts where name = 'VMP_GetAvailableVMs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_GetAvailableVMs')
	delete from GXDBVersions where aliasname = 'VMP_GetAvailableVMs'
GO

insert into GXDBVersions values(2, 'VMP_GetAvailableVMs',  '00010097001200520000', 'VMP_GetAvailableVMs', '00010097001200520000')
GO

