

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_CreateJobForVMProvisioning.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   04/04/2008
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_CreateJobForVMProvisioning.sp,v $ $Id: VMP_CreateJobForVMProvisioning.sp,v 1.6.214.1 2018/03/27 08:16:37 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_CreateJobForVMProvisioning <<<'

IF EXISTS (select * from sysobjects where name='VMP_CreateJobForVMProvisioning')
	drop procedure VMP_CreateJobForVMProvisioning
IF EXISTS (select * from GxQscripts where name='VMP_CreateJobForVMProvisioning')
	delete from GxQscripts where name = 'VMP_CreateJobForVMProvisioning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_CreateJobForVMProvisioning')
	delete from GXDBVersions where aliasname = 'VMP_CreateJobForVMProvisioning'
GO
print '... Creating Procedure: VMP_CreateJobForVMProvisioning'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_CreateJobForVMProvisioning
  @i_xmlText XML,
  @i_userId INT=0,
  @i_sequenceNumber varchar(255)='',
  @i_localId INT=0,
  @o_xmlText XML	OUTPUT
AS
	DECLARE	@o_TaskId			INT
	DECLARE	@o_JobId			BIGINT
	DECLARE	@o_ErrorCode		INT=0
	DECLARE	@o_ErrorString		NVARCHAR(1024)
	DECLARE @t_JobId			TABLE( jobId BIGINT )
	DECLARE @i_UserGUID			NVARCHAR(36)=''
	DECLARE @position			INT = 1
	SET @o_JobId = 0
	SET @o_TaskId = 0
	SET @o_ErrorCode = 0
	SET @o_ErrorString = ''
	BEGIN
		SET @o_JobId = ISNULL((SELECT ref.value('@jobId', 'INT')
				FROM  @i_xmlText.nodes ('TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/serverOptions') R(ref)), 0)
		SET @i_userId = ISNULL (( SELECT ref.value('@runUserId', 'NVARCHAR(36)')
						FROM @i_xmlText.nodes ('TMMsg_CreateTaskReq/taskInfo/task') R(ref)), @i_userId)
		SET @i_UserGUID = ISNULL ((SELECT userGuid FROM UMUsers WHERE id = @i_userId), @i_UserGUID)
		IF @i_userId IS NULL OR @i_userId = 0
		BEGIN
			IF (@i_UserGUID <> '')
				SET @i_userId = (SELECT id FROM UMUSERS WHERE userGuid = @i_UserGUID AND enabled=1)
		END
		IF LEN(@i_UserGUID) = 0
		BEGIN
			SET @o_ErrorCode = -1
			SET @o_ErrorString = 'User not found'
			GOTO EXIT_PROC
		END
		IF (@o_JobId = 0)
		BEGIN
			--Insert into temp table to avoid sending it as a response
			INSERT INTO @t_JobId EXEC @o_JobId = TM_GetNextJobId
		END
		IF (@i_xmlText.exist('/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/serverOptions')) <> 1
			SET @i_xmlText.modify('insert <serverOptions /> into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options)[1]')
		SET @i_xmlText.modify('insert (attribute jobId {sql:variable("@o_JobId")}) into (/TMMsg_CreateTaskReq/taskInfo/subTasks[position() = sql:variable("@position")]/options/serverOptions)[1]')
		INSERT INTO TM_CreateTaskRequest VALUES (@i_xmlText, @i_userId, @i_UserGUID, 0, @i_sequenceNumber, 0, dbo.getUnixTime(GetUTCDate()))
	END
EXIT_PROC:
	IF @o_ErrorCode = 0
	BEGIN
		SET @o_xmlText =
				(SELECT
					( SELECT  @o_TaskId '@taskId',
						( SELECT @o_JobId '@val'
							FOR XML PATH('jobIds'), TYPE
						)
						FOR XML PATH('taskResp'), TYPE
					)
					FOR XML PATH(''),
					ROOT('TMMsg_SvcCreateTaskResp')
				)
	END
	ELSE
	BEGIN
		SET @o_xmlText =
				(SELECT
					( SELECT @o_ErrorCode '@errorCode', @o_ErrorString '@errorString'
						FOR XML PATH('error'), TYPE
					)
					FOR XML PATH(''),
					ROOT('TMMsg_SvcCreateTaskResp')
				)
	END
	SELECT @o_xmlText
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'VMP_CreateJobForVMProvisioning')
	delete from GxQscripts where name = 'VMP_CreateJobForVMProvisioning'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_CreateJobForVMProvisioning')
	delete from GXDBVersions where aliasname = 'VMP_CreateJobForVMProvisioning'
GO

insert into GXDBVersions values(2, 'VMP_CreateJobForVMProvisioning',  '00010006021400010000', 'VMP_CreateJobForVMProvisioning', '00010006021400010000')
GO

