

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_CheckVMQuotaForUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_CheckVMQuotaForUser.sp,v $ $Id: VMP_CheckVMQuotaForUser.sp,v 1.1.4.6 2018/03/27 08:15:35 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   VMP_CheckVMQuotaForUser   - Process virtual data center input xml
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_CheckVMQuotaForUser <<<'

IF EXISTS (select * from sysobjects where name='VMP_CheckVMQuotaForUser')
	drop procedure VMP_CheckVMQuotaForUser
IF EXISTS (select * from GxQscripts where name='VMP_CheckVMQuotaForUser')
	delete from GxQscripts where name = 'VMP_CheckVMQuotaForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_CheckVMQuotaForUser')
	delete from GXDBVersions where aliasname = 'VMP_CheckVMQuotaForUser'
GO
print '... Creating Procedure: VMP_CheckVMQuotaForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_CheckVMQuotaForUser
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId INT,  
  @newCreatorUserId INT,
  @vmCLientId INT
AS
  DECLARE @o_errorCode INT
  DECLARE @o_errorMsg NVARCHAR(1024)
BEGIN
SET NOCOUNT ON
	SET @o_errorCode = 0
	SET @o_errorMsg = N'Success'
	DECLARE @currCreatorLoginName NVARCHAR(255) = ISNULL((SELECT login FROM UMUsers WHERE id = @userId),0)
	DECLARE @newCreatorLoginName NVARCHAR(255) = ISNULL((SELECT login FROM UMUsers WHERE id = @newCreatorUserId),0)
	DECLARE @vmPolicyId INT = ISNULL((SELECT vmAllocationPolicyId FROM App_VM WHERE clientId = @vmCLientId),0)
	DECLARE @PolicyName NVARCHAR(255)
	DECLARE @vmQuota INT
	DECLARE @quotaType INT
	DECLARE @maxMemoryQuota BIGINT
	DECLARE @maxCPUQuota INT
	-- Check for Admin (Commcell Level association) and skip quota check if the user has comcmell level association i.e. he can view and edit creator of all VMs.
	IF object_id('tempdb.dbo.#CheckCommCellLevelPermissionsTbl') IS NOT NULL DROP TABLE #CheckCommCellLevelPermissionsTbl
	CREATE TABLE #CheckCommCellLevelPermissionsTbl (permissionId INT)
EXEC sec_getPermissionsOnEntity '#CheckCommCellLevelPermissionsTbl', @userId, 1, 2
	DECLARE @hasCCLevelAssociation INT = 0
IF EXISTS(SELECT * FROM #CheckCommCellLevelPermissionsTbl WHERE permissionId IN (101, 1, 2, 3))
		SET @hasCCLevelAssociation = 1
	IF @hasCCLevelAssociation = 1 AND @userId = @newCreatorUserId
		GOTO PROC_EXIT
	DECLARE @currCreatorId INT = ISNULL((SELECT CAST(attrVal AS INT)  FROM APP_ClientProp WHERE attrName = 'Virtual Machine Created by User' AND componentNameId = @vmCLientId), -1)
	IF @hasCCLevelAssociation = 0 AND @currCreatorId <> @userId
	BEGIN
		SET @o_errorCode = 2
		SET @o_errorMsg = 'User ['+@currCreatorLoginName+'] doesn''t have sufficient privilege to perform this operation.'
		GOTO PROC_EXIT
	END
	SELECT  @quotaType = ISNULL(n.value('@quotaType', 'INT'),0),
	@maxMemoryQuota = ISNULL(n.value('@maxMemoryQuotaGB', 'INT'),0),
	@maxCPUQuota = ISNULL(n.value('@maxCPUQuota', 'INT'),0),
	@vmQuota = p.n.value('@maxVMQuota','INT'), @PolicyName = VP.name
	FROM App_VmAllocationPolicy VP
	CROSS APPLY VP.vxml.nodes('/policy') p(n)
	WHERE VP.id = @vmPolicyId
	IF @quotaType = 0 -- if quotaType is based on vmCount
	BEGIN
	DECLARE @presentlyHoldVMInPolicy INT = (SELECT COUNT(*)
											FROM APP_VM VM
												INNER JOIN App_ClientProp ACP
													ON VM.clientId = ACP.componentNameId
														AND attrName = 'Virtual Machine Created by User'
														AND CAST(attrVal AS INT) = @newCreatorUserId
														AND VM.vmAllocationPolicyId = @vmPolicyId)
		IF @vmQuota <= @presentlyHoldVMInPolicy
		BEGIN
			SET @o_errorCode = 1
			SET @o_errorMsg = 'User exceeding policy VM Quota. To proceed with, clean up old VMs from policy['+@PolicyName+'] for user['+@newCreatorLoginName+']..'
			GOTO PROC_EXIT
		END
	END
	IF @quotaType = 1 -- If quota type is based on memory/cpu type
	BEGIN
		DECLARE @presentlyHoldMemoryInPolicy BIGINT
		DECLARE @reqMemory BIGINT
		DECLARE @presentlyHoldCpuInPolicy INT
		DECLARE @reqCpu INT
		SELECT @reqMemory = ISNULL(vm.vxml.value('(/QSMServer_QVirtualMachineReq/memory[1]/@memorySizeMB)[1]','BIGINT'),0),
		   @reqCpu = ISNULL(vm.vxml.value('(/QSMServer_QVirtualMachineReq/cpu[1]/@numCpu)[1]','INT'),0)
			from App_VM VM INNER JOIN App_Client C on VM.clientId = C.id
				AND C.id = @vmCLientId
				AND VM.removalTimeStamp IS null
		select @presentlyHoldMemoryInPolicy = ISNULL(sum(ISNULL(vm.vxml.value('(/QSMServer_QVirtualMachineReq/memory[1]/@memorySizeMB)[1]','BIGINT'),0)),0) from APP_ClientProp ACP
				INNER JOIN  App_VM VM
					ON VM.clientId = ACP.componentNameId AND ACP.attrName = 'Virtual Machine Created by User'
						AND ACP.modified = 0 AND CAST(ACP.attrVal AS INT) = @newCreatorUserId
						AND VM.vmAllocationPolicyId = @vmPolicyId
						AND VM.removalTimeStamp IS null
		IF  @presentlyHoldMemoryInPolicy+ @reqMemory > @maxMemoryQuota * 1024 * 1024 *1024
		BEGIN
			SET @o_errorCode = 1
			SET @o_errorMsg = 'User exceeding policy Memory Quota. To proceed with, reduce memory from old VMs from policy['+@PolicyName+'] for user['+@newCreatorLoginName+']..'
			GOTO PROC_EXIT
		END
		select @presentlyHoldCpuInPolicy = ISNULL(sum(ISNULL(vm.vxml.value('(/QSMServer_QVirtualMachineReq/cpu[1]/@numCpu)[1]','INT'),0)),0) from APP_ClientProp ACP
				INNER JOIN  App_VM VM
					ON VM.clientId = ACP.componentNameId AND ACP.attrName = 'Virtual Machine Created by User'
						AND ACP.modified = 0 AND CAST(ACP.attrVal AS INT) = @newCreatorUserId
						AND VM.vmAllocationPolicyId = @vmPolicyId
						AND VM.removalTimeStamp IS null
		IF  @presentlyHoldCpuInPolicy+ @reqCpu > @maxCPUQuota
	BEGIN
		SET @o_errorCode = 1
			SET @o_errorMsg = 'User exceeding policy CPU Quota. To proceed with, reduce CPU cores from old VMs from policy['+@PolicyName+'] for user['+@newCreatorLoginName+']..'
			GOTO PROC_EXIT
		END
	END
PROC_EXIT:
	SELECT @o_errorCode AS ErrorCode, @o_errorMsg AS ErrorMsg
END
GO


IF EXISTS (select * from GxQscripts where name = 'VMP_CheckVMQuotaForUser')
	delete from GxQscripts where name = 'VMP_CheckVMQuotaForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_CheckVMQuotaForUser')
	delete from GXDBVersions where aliasname = 'VMP_CheckVMQuotaForUser'
GO

insert into GXDBVersions values(2, 'VMP_CheckVMQuotaForUser',  '00010001000400060000', 'VMP_CheckVMQuotaForUser', '00010001000400060000')
GO

