

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_BestLocation.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_BestLocation.sp,v $ $Id: VMP_BestLocation.sp,v 1.25.12.21 2020/03/26 21:07:05 rpolimera Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "GetDataCenterList"
--	|	This Procedure is used to get the list of available data centers
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='VMP_BestLocation')
BEGIN
	print '>>> Drop Stored Procedure: VMP_BestLocation <<<'
	drop procedure VMP_BestLocation
END
IF EXISTS (select * from GxQscripts where name='VMP_BestLocation')
	delete from GxQscripts where name = 'VMP_BestLocation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_BestLocation')
	delete from GXDBVersions where aliasname = 'VMP_BestLocation'
GO
print '... Creating Procedure: VMP_BestLocation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_BestLocation
-- Input arguments
  @userId INT,
  @request XML,
  @flags INT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @o_rank float
  DECLARE @o_errorCode INT
  DECLARE @o_errorMessage VARCHAR(512)
  DECLARE @o_esxServerName VARCHAR(256)
  DECLARE @o_dataStoreName VARCHAR(256)
  DECLARE @o_vmCount INT
  DECLARE @o_totalMemoryGB INT
  DECLARE @o_freememoryPct INT
  DECLARE @o_totalSpaceGB INT
  DECLARE @o_freeSpacePct INT
  DECLARE @o_esxtimeStamp VARCHAR(20)
  DECLARE @o_dstimeStamp VARCHAR(20)
BEGIN TRY
-- request :<Ida_VMOpReq><vmInfo isPhysical="0" isTemplate="0" memory="2048" numberOfCPUs="2" numberOfNICs="4" operatingSystem="Microsoft Windows Server 2008 (64-bit)" purpose="" vmAllocPolicyId="3" vmState="0"><vm _type_="88" vmName="t.t.ttt.commvault.com"/><vmLocation dataCenterName="Commvault-DC" hostName="" vCenter="usint13"><dcUserInfo password="||#4!MWVodG40dGZhNGY0bnRJdHo0Ym5Zbm4=&#xA;" userName="administrator"/><datastore name=""/></vmLocation><hardDisks><hardDisk diskSize="112640" diskType="2" label="Hard disk 1"/><hardDisk diskSize="61440" diskType="1" label="Hard disk 2"/></hardDisks><expirationTime time="1300766400"/></vmInfo><vmEntity _type_="88" clientId="89" commCellId="0" type="0" vmGUID="421b9c6b-9172-73dc-92a8-f0a631cd7a20" vmName="template-win2k8r2-2"/></Ida_VMOpReq>
	SET NOCOUNT ON
	DECLARE @vmAllocPolicy			XML
	DECLARE @esxServerCount			INT
	DECLARE @dataStoreCount			INT
	DECLARE @esxServerName			VARCHAR(256)
	DECLARE @diskSize				bigint =0
	DECLARE @totalItems				INT
	DECLARE @i						INT
	DECLARE @errorCode				INT =0
	DECLARE @errorString VARCHAR(1024) = 'Success'
	DECLARE @esxServerId			INT
	DECLARE @vmAllocPolicyId		INT
	DECLARE @dataCenterId			INT
	DECLARE @value   float
	DECLARE @isLiveMountPolicy INT = 0
	DECLARE @policyType				INT = 0
	DECLARE @isRestoreLabPolicy		INT = 0
	DECLARE @isRestorePolicy		INT = 0
	DECLARE @minDiskSize			BIGINT = 0
	DECLARE @maxVMQuota				INT = 0
	DECLARE @vmAllocPolType			INT = 0
	DECLARE @labCount				INT = 0
	DECLARE @isResourceGroupPolicy  INT = 0
	DECLARE @isMigrateOptionEnabled	INT = 0
	--Check if any tmp table is existing before then drop it
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF OBJECT_ID('tempdb..#VMInfo') IS NOT NULL
		DROP TABLE #VMInfo
	CREATE TABLE #VMInfo
	(
		clientId INT,
		VMGUID varchar(250),
		diskSize	BIGINT
	)
	IF @request.exist('TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/virtualLabOption/vmPolicy') = 1
	BEGIN
		SET @isRestoreLabPolicy = 1
		SELECT @vmAllocPolicyId = ref.value('@vmAllocPolicyId', 'INT')
		FROM @request.nodes ('TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/virtualLabOption/vmPolicy') R(ref)
	END
	ELSE IF @request.exist('/TMMsg_JobOption/restoreOptions/virtualServerRstOption/allocationPolicy') = 1
	BEGIN
		SET @isRestorePolicy = 1
		SELECT @vmAllocPolicyId = ref.value('@vmAllocPolicyId', 'INT')
		FROM @request.nodes ('/TMMsg_JobOption/restoreOptions/virtualServerRstOption/allocationPolicy') R(ref)
	END
	IF @isRestoreLabPolicy = 1 or @isRestorePolicy = 1
	BEGIN
		INSERT INTO #VMInfo
		select cp.componentNameId, R.ref.value('@guid','VARCHAR(250)'),0
		FROM APP_ClientProp cp
		INNER JOIN @request.nodes ('TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions') R(ref)
		on cp.attrName='Virtual Machine Instance UUID'
		and cp.attrVal = R.ref.value('@guid','VARCHAR(250)')
		update #VMInfo
		set diskSize = attrVal
		from #VMInfo info
		inner join ( select vmclientid, row_number() over (partition by vmclientid order by jobid desc) as rn, attrVal from app_vmprop vmprop
					 inner join #vmInfo
					 on #vmInfo.clientid = vmprop.vmclientid
					 and vmprop.attrName ='vmGuestSize'
					 ) T
		on info.clientid = 	T.vmclientid
		and T.rn =1
		IF EXISTS(SELECT * FROM #VMInfo)
		BEGIN
			SELECT @minDiskSize = MIN(diskSize) FROM #VMInfo
			SELECT @diskSize = SUM(diskSize)/1024/1024 FROM #VMInfo
		END
		ELSE
		BEGIN
			SET @minDiskSize = 100  -- taking dummy value as 100 GB in case the VM is not discovered
			SET @diskSize = @minDiskSize * @request.value('count(/TMMsg_JobOption/restoreOptions/virtualServerRstOption/diskLevelVMRestoreOption/advancedRestoreOptions)','INT')
		END
		--select * from app_vm where id IN (1936, 1937)
		--where vxml.value('(QSMServer_QVirtualMachineReq)[1]/@isTemplate', 'INT') = 1 and removalTimeStamp IS NULL
		--AND vxml.value('(QSMServer_QVirtualMachineReq)[1]/@vendorType', 'INT') IN (101,102)
	END
	ELSE
	BEGIN
		SELECT
			   @vmAllocPolicyId = ref.value('@vmAllocPolicyId', 'INT')
		FROM @request.nodes ('Ida_VMOpReq/vmAllocPolicy') R(ref)
		IF @vmAllocPolicyId IS NULL
			SELECT @vmAllocPolicyId = ref.value('@vmAllocPolicyId', 'INT')
							FROM @request.nodes ('Ida_VMOpReq/vmAllocPolicy') R(ref)
		IF( @vmAllocPolicyId IS NULL)
			SELECT
			   @vmAllocPolicyId = ref.value('@vmAllocPolicyId', 'INT')
			FROM @request.nodes ('Ida_VMOpReq/vmInfo') R(ref)
		SET @totalItems = @request.value('count(Ida_VMOpReq/vmInfo/hardDisks/hardDisk)','int')
		SET @i =1
		WHILE (@i <= @totalItems )
		BEGIN
			SET @diskSize = @diskSize + @request.value('(Ida_VMOpReq/vmInfo/hardDisks/hardDisk[sql:variable("@i")]/@diskSize)[1]', 'bigint')
			SET @i = @i +1
		END
	END
	SELECT @vmAllocPolicy = vxml, @dataCenterId = vDataCenterId FROM App_VmAllocationPolicy where id = @vmAllocPolicyId
	SELECT @isLiveMountPolicy = CASE WHEN flags & 2 = 2 THEN 1 ELSE 0 END FROM APP_VMAllocationPolicy WHERE id = @vmAllocPolicyId
	-- In case requested disk size is zero, no need to check the data store, setting isLiveMountPolicy variable skips data store check
	IF ( @diskSize =0)
	    SET @isLiveMountPolicy =1
	IF (@flags = 1)
	BEGIN
		SET @isMigrateOptionEnabled = ISNULL(@vmAllocPolicy.value('(policy/@migrateVMs)[1]','INT'), 0)
		IF (@isMigrateOptionEnabled = 1)
			SET @isLiveMountPolicy = 0
	END
	SET @policyType = @vmAllocPolicy.value('(policy/entity[1]/@policyType)[1]','int')
	SET @diskSize = @diskSize * 1024 *1024
	-- @request : <Ida_VMOpReq><vmInfo isPhysical="0" isTemplate="0" memory="2048" numberOfCPUs="2" numberOfNICs="4" operatingSystem="Microsoft Windows Server 2008 (64-bit)" purpose="" vmState="0"><vm _type_="88" vmName="c.e.fff.commvault.com"/><vmLocation dataCenterName="Commvault-DC" hostName="172.19.96.103" vCenter="usint13"><dcUserInfo password="||#4!MUdMZVNoZUFLaEFoU2U2ZVloWlNKU1M=&#xA;" userName="administrator"/><datastore name="IMAGESTORE"/></vmLocation><hardDisks><hardDisk diskSize="122880" diskType="1"/></hardDisks><expirationTime time="1300334400"/></vmInfo><vmEntity _type_="88" clientId="102" commCellId="0" type="0" vmGUID="421be93c-b69c-0ce4-3fe9-7c87ec6fcf99" vmName="template-win2k8r2"/></Ida_VMOpReq>
	--Check if any tmp table is existing before then drop it
	IF object_id('tempdb.dbo.#tmpEsxServerTbl') is not null
		DROP TABLE #tmpEsxServerTbl
	--Check if any tmp table is existing before then drop it
	IF object_id('tempdb.dbo.#tmpDataStoresTbl') is not null
		DROP TABLE #tmpDataStoresTbl
	--Create the tmp table
	CREATE TABLE #tmpEsxServerTbl (  t_esxServerId	integer,
								   t_esxServerName varchar(256),
								   t_vmCount		integer,
								   t_cpuCount		integer,
								   t_totalMemory	bigint,
								   t_usedMemory		bigint,
								   t_totalCPU		integer,
								   t_usedCPU		integer,
								   t_avgCPUUtilization	integer,
								   t_avgMemoryUtilization integer,
								   t_rank			float DEFAULT(0),
								   t_timestamp     varchar(20)
									)
	CREATE TABLE #tmpDataStoresTbl (  t_dataStoreId	integer,
									 t_dataStoreName varchar(256),
									 t_totalCapacity bigint default(0),
									 t_freeSpace bigint default(0),
									 t_timestamp     varchar(20)
									)
	--Check if any tmp table is existing before then drop it
	IF object_id('tempdb.dbo.#outEsxServerTbl') is not null
		DROP TABLE #outEsxServerTbl
	--Check if any tmp table is existing before then drop it
	IF object_id('tempdb.dbo.#outDataStoresTbl') is not null
		DROP TABLE #outDataStoresTbl
	--Create the tmp table
	CREATE TABLE #outEsxServerTbl (  t_esxServerId	integer,
								   t_esxServerName varchar(256),
								   t_vmCount		integer,
								   t_cpuCount		integer,
								   t_totalMemory	bigint,
								   t_usedMemory		bigint,
								   t_totalCPU		integer,
								   t_usedCPU		integer,
								   t_avgCPUUtilization	integer,
								   t_avgMemoryUtilization integer,
								   t_rank			float DEFAULT(0),
								   t_timestamp     varchar(20)
									)
	CREATE TABLE #outDataStoresTbl (  t_dataStoreId	integer,
									 t_dataStoreName varchar(256),
									 t_totalCapacity bigint,
									 t_freeSpace bigint,
									 t_timestamp     varchar(20)
									)
	IF object_id('tempdb.dbo.#VMProgressDetails') is not null
		DROP TABLE #VMProgressDetails
	CREATE TABLE #VMProgressDetails
	(
		hostName  varchar(256),
		volumeName varchar(256),
		memory    bigint,
		size      bigint
	)
	--check lab quota for restore lab.
	IF @isRestoreLabPolicy = 1
	BEGIN
		SELECT
		   @maxVMQuota = ref.value('@maxVMQuota', 'INT'),
		   @vmAllocPolType=ISNULL(ref.value('entity[1]/@policyType', 'int'), 0)
		FROM App_VmAllocationPolicy CROSS APPLY vxml.nodes ('policy') VMP(ref) WHERE id = @vmAllocPolicyId  AND alive = 1
		IF(@vmAllocPolType = 12 OR @vmAllocPolType = 13)--run this for Virtual Restore Lab(VMware,Hyper-V)
		BEGIN
		--older versions of lab
		SET @labCount = ISNULL((SELECT COUNT(VL.id)
					FROM APP_VirtualLab VL
					INNER JOIN APP_VirtualLabProp VLP
					ON VLP.componentNameId = VL.id
					AND VLP.attrName = 'Virtual Lab Policy Id'
					AND VLP.attrVal = @vmAllocPolicyId
					WHERE VL.ownerId = @userId and VL.deleted = 0),0)
		--new versions of lab
        SET @labCount += ISNULL((SELECT COUNT(distinct(CGA.clientGroupId))
				FROM APP_ClientProp ACP
				INNER JOIN  App_VM VM
					ON VM.clientId = ACP.componentNameId AND ACP.attrName = 'Virtual Machine Created by User'
						AND ACP.modified = 0 AND CAST(ACP.attrVal AS INT) = @userId
						AND VM.removalTimeStamp IS null
						AND VM.vmAllocationPolicyId = @vmAllocPolicyId
				INNER JOIN APP_ClientGroupAssoc CGA
					ON CGA.clientId = VM.clientId
				INNER JOIN APP_ComponentProp CP
					ON CP.componentId = CGA.clientGroupId AND CP.propertyTypeId = 1032 AND CP.longVal = @vmAllocPolicyId
					), 0)
		END
		IF @labCount >= @maxVMQuota
		BEGIN
			SET @errorString = 'User has exceeded allowed Virtual Lab Quota.'
			SET @errorCode = (158 | (CAST(POWER(2, 24) AS BIGINT) * 72))
			GOTO ERROR_EXIT
		END
	END
	IF @isLiveMountPolicy = 0 AND @policyType <> 3
	BEGIN
		;with cte
		as
		(
		SELECT cast(T.value as xml) as val FROM JMJobInfo JI
		INNER JOIN JMAdminJobInfoTable JA ON JI.jobId = JA.jobId
		AND JI.opType = 85
		CROSS APPLY GetAllJobOptions(JI.jobId) AS T
		WHERE  T.optionId = 30050685
		AND ISNULL((CAST(T.value as xml).value('virtualMachineOption[1]/vmAllocPolicy[1]/@vmAllocPolicyId', 'INT')), 0) = @vmAllocPolicyId
		)
		--we consider the thin provisioning disk space for parallel running jobs which is taken from the template used size
		,sizes
		as (
			select (select sum(d.value('@usedSize', 'bigint'))
			from app_vm TemplateVM
			CROSS APPLY TemplateVM.vxml.nodes('QSMServer_QVirtualMachineReq/hardDisks/hardDisk') AS DataStore(d)
			where guid in ( select cte.val.value('(virtualMachineOption/vmEntity)[1]/@vmGUID','nvarchar(256)') from cte))
			as thinProvisionedSize ,
			 (select sum(d.value('@diskSize', 'bigint'))/2
			  from cte
			  CROSS APPLY cte.val.nodes('virtualMachineOption/vmInfo/hardDisks/hardDisk') AS DataStore(d)) as requestedsize
		 )
		, cte2
		as
		(
			select cte.val.value('(virtualMachineOption/vmInfo/vmLocation)[1]/@hostName', 'nvarchar(256)') as hostName,
					cte.val.value('(virtualMachineOption/vmInfo/vmLocation/datastore)[1]/@name', 'nvarchar(256)') as dataStore,
					cte.val.value('(virtualMachineOption/vmInfo)[1]/@memory', 'bigint')/2048 as memory,
					--if thin provisoned size is not available in the template, then we go by the user requested size
					(select CASE when (ISNULL(thinProvisionedSize,0) = 0) then requestedsize*1024*1024
								 else thinProvisionedSize
								 end
					from sizes
					)  as size
			from cte
		)
		insert into #VMProgressDetails
		select hostName, dataStore, memory,  size from cte2
		IF @isRestoreLabPolicy = 1 or @isRestorePolicy = 1
		BEGIN
			;WITH advanceOptions(vmGUID, esxHost, DataStore)
			AS
			(
				SELECT (CAST(T.value as xml).value('(advancedRestoreOptions)[1]/@guid','varchar(255)')), (CAST(T.value as xml).value('(advancedRestoreOptions)[1]/@esxHost','varchar(255)'))
					   ,(CAST(T.value as xml).value('(advancedRestoreOptions)[1]/@Datastore ','varchar(255)'))
					FROM JMJobInfo JI
					CROSS APPLY GetAllJobOptions(JI.jobId) AS T
					WHERE  JI.opType = 5 AND T.optionId = 1003858335
			)
			, datastoreHostMap(hostName, dataStoreName, memory, size)
			as
			(
				SELECT A.esxHost, DS.name,
					   VM.vxml.value('(QSMServer_QVirtualMachineReq/memory)[1]/@memorySizeMB', 'bigint')/1024/1024/1024,
					   (SELECT SUM(V.n.value('@capacityInKb', 'BIGINT'))/2
							FROM VM.vxml.nodes('QSMServer_QVirtualMachineReq/hardDisks/hardDisk') V(n))
				FROM advanceOptions A
					INNER JOIN App_vmhost VH ON A.esxHost = VH.name
					INNER JOIN App_VM VM ON A.vmGUID = VM.GUID
					INNER JOIN App_VMDataStore DS ON DS.name = A.DataStore
			)
			insert into #VMProgressDetails
			select DISTINCT DHM.* from datastoreHostMap DHM
				INNER JOIN (SELECT P.vxml.value('(policy)[1]/@allDataStoresSelected','INT') isAllDataStoresSelected, vDS.name AS DataStoreName FROM App_VMAllocationPolicy P
										INNER JOIN APP_VMAllocationPolicyProp vmProp
											ON P.id = vmProp.componentNameId AND P.id = @vmAllocPolicyId
										INNER JOIN App_VMDataStore vDS
											ON vmProp.attrName ='datastore'
												AND vDS.removalTimeStamp IS NULL
												AND vDS.id = vmProp.attrVal) DS
					ON isAllDataStoresSelected = 1 OR DS.DataStoreName = DHM.dataStoreName
		END
	END
	set @isResourceGroupPolicy =  ISNULL(@vmAllocPolicy.value('policy[1]/@isResourceGroupPolicy','int'),0)
	IF @isResourceGroupPolicy=1
	BEGIN
		INSERT INTO #tmpESXServerTbl ( t_esxServerId, t_esxServerName, t_timestamp)
		select distinct H.id, H.name,convert(varchar(20), dbo.UTCToClientLocalTime(H.timeStamp,2), 100)
        from APP_VMHost H
        inner join APP_VMDataCenter DC on H.vDataCenterId = DC.id
        inner join APP_Application AP on AP.clientId = @vmAllocPolicy.value('policy[1]/destinationHyperV[1]/@clientId','int') and AP.appTypeId = 106
		inner join APP_VMDataCenterMap DCM ON DCM.instanceId = AP.instance AND DCM.removalTimeStamp is NULL
        CROSS APPLY @vmAllocPolicy.nodes ('policy/esxServers') P(p)
        where  H.name in (P.p.value('@esxServerName','nvarchar(1024)'))
		AND H.removalTimeStamp is NULL
	END
	ELSE IF (  @vmAllocPolicy.value('(policy/@allESXServersSelected)[1]','int') = '1' )
	BEGIN
		INSERT INTO #tmpESXServerTbl ( t_esxServerId, t_esxServerName, t_timestamp)
		SELECT id, name , convert(varchar(20), dbo.UTCToClientLocalTime(timeStamp,2), 100)
			FROM App_VMHost
			WHERE vDataCenterId = @dataCenterId
			AND removalTimeStamp IS null
	END
	ELSE
	BEGIN
	INSERT INTO #tmpESXServerTbl ( t_esxServerId, t_esxServerName, t_timestamp)
		SELECT vmProp.attrVal, vHost.name, convert(varchar(20), dbo.UTCToClientLocalTime(vHost.timeStamp,2), 100) FROM APP_VMAllocationPolicyProp vmProp
			INNER JOIN App_VMHost vHost
			ON vmProp.attrName ='esxserver'
			AND vmProp.componentNameId = @vmAllocPolicyId
			AND vHost.removalTimeStamp IS NULL
			AND vHost.id = vmProp.attrVal
	END
	IF NOT EXISTS ( SELECT t_esxServerId FROM #tmpEsxServerTbl )
	BEGIN
SET @errorCode = (126 | (CAST(POWER(2, 24) AS BIGINT) * 72))
		SET @errorString = 'None of the ESX Servers configured in the Allocation policy  can be selected for creating virtual machine'
		GOTO ERROR_EXIT
	END
	IF @isResourceGroupPolicy=1
	BEGIN
		INSERT INTO #tmpDataStoresTbl ( t_dataStoreId, t_dataStoreName,t_timeStamp)
		select distinct D.id, D.name, convert(varchar(20),dbo.UTCToClientLocalTime(D.timeStamp,2), 100) from APP_VMDataStore D
        inner join APP_VMDataCenter DC on D.vDataCenterId = DC.id
        inner join APP_Application AP on AP.clientId = @vmAllocPolicy.value('policy[1]/destinationHyperV[1]/@clientId','int') and AP.appTypeId = 106
		inner join APP_VMDataCenterMap DCM ON DCM.instanceId = AP.instance AND DCM.removalTimeStamp is NULL
        CROSS APPLY @vmAllocPolicy.nodes ('policy/dataStores') P(p)
        where  D.name in (P.p.value('@dataStoreName','nvarchar(1024)'))
        and D.removalTimeStamp is NULL
	END
	ELSE IF (  @vmAllocPolicy.value('(policy/@allDataStoresSelected)[1]','int') = '1' OR @isLiveMountPolicy = 1 )
	BEGIN
		INSERT INTO #tmpDataStoresTbl ( t_dataStoreId, t_dataStoreName, t_timestamp)
			SELECT id, name, convert(varchar(20), dbo.UTCToClientLocalTime(timeStamp,2), 100)  FROM App_VMDataStore WHERE vDataCenterId = @dataCenterId
			AND removalTimeStamp IS NULL
	END
	ELSE
	BEGIN
	INSERT INTO #tmpDataStoresTbl ( t_dataStoreId, t_dataStoreName,t_timeStamp)
		SELECT distinct vmProp.attrVal, vDS.name,convert(varchar(20), dbo.UTCToClientLocalTime(vDS.timeStamp,2), 100) FROM APP_VMAllocationPolicyProp vmProp
			INNER JOIN App_VMDataStore vDS
			ON vmProp.attrName ='datastore'
			AND vmProp.componentNameId = @vmAllocPolicyId
			AND vDS.removalTimeStamp IS NULL
			AND vDS.id = vmProp.attrVal
	END
	IF @isLiveMountPolicy = 0 AND @policyType <> 3
	BEGIN
		UPDATE #tmpDataStoresTbl
			SET t_totalCapacity = dsTotalCapacity,
			t_freeSpace = dsFreeSapce
			FROM #tmpDataStoresTbl
			INNER JOIN ( SELECT ds.id,
								d.value('@capacity', 'bigint') AS dsTotalCapacity,
								d.value('@freeSpace', 'bigint') AS dsFreeSapce
						 FROM App_VMDataStore AS ds
						 CROSS APPLY ds.vxml.nodes('datastores') AS DataStore(d)
						 WHERE ds.id in ( SELECT t_dataStoreId FROM #tmpDataStoresTbl)
						 AND ds.removalTimeStamp IS null )	AS dataStores ON
			dataStores.id = t_dataStoreId
		UPDATE #tmpDataStoresTbl
		SET t_freeSpace -= vmd.size
		from #tmpDataStoresTbl ds
		join (SELECT volumeName, SUM(size) AS size FROM #VMProgressDetails GROUP BY volumeName) vmd
		on ds.t_dataStoreName = vmd.volumeName
		UPDATE #tmpEsxServerTbl
		SET t_vmCount += t.vmcount
		from ( select count(*) as vmcount, hostname from #VMProgressDetails
		       group by hostname) t
	    where t_esxServerName = t.hostName
		INSERT INTO #outDataStoresTbl
		SELECT * from #tmpDataStoresTbl
		-- 30% allowance should be considered
		DECLARE @dsFreePerc INT=0;
		IF @vmAllocPolicy.exist('(policy/serverFreePercentage/@isEnabled)[1]') = 1 AND @vmAllocPolicy.value('(policy/serverFreePercentage/@isEnabled)[1]','int') = 1
		BEGIN
			SET @dsFreePerc  = ISNULL(@vmAllocPolicy.value('(policy/serverFreePercentage/@datastorePercentage)[1]','int'),0)
		END
		ELSE
		BEGIN
			SELECT @dsFreePerc = CAST(ISNULL(VALUE,0) AS INT) FROM GXGLOBALPARAM WHERE NAME = 'DataStoreFreeSpacePercentage'
		END
		IF @dsFreePerc = 0 AND (@policyType  not in (5,6,12,13)) -- virtual lab (vmware/hyper-v) restore policy types
		BEGIN
				SET @dsFreePerc = 10
		END
		IF @isRestoreLabPolicy != 1
		DELETE  FROM #tmpDataStoresTbl WHERE (t_freeSpace - @diskSize) < t_totalCapacity * (@dsFreePerc/100.0)
		IF NOT EXISTS ( SELECT t_dataStoreId FROM #tmpDataStoresTbl )
		BEGIN
SET @errorCode = (136 | (CAST(POWER(2, 24) AS BIGINT) * 72))
			SET @errorString = 'Requested disk size exceeds available space on all datastores'
			GOTO ERROR_EXIT
		END
		DELETE FROM #tmpEsxServerTbl
			WHERE t_esxServerId NOT IN
			(
			 SELECT vHostId FROM VMHostToDataStores
				INNER JOIN App_VMHost AS VH
				ON VH.removalTimeStamp is null
				INNER JOIN #tmpDataStoresTbl
				ON t_dataStoreId = vDataStoreId
				AND VH.id = vHostId
			)
	END
  	IF NOT EXISTS ( SELECT t_esxServerId FROM #tmpEsxServerTbl )
	BEGIN
SET @errorCode = (126 | (CAST(POWER(2, 24) AS BIGINT) * 72))
		SET @errorString = 'Selected data stores based on disk size are not available to the selected ESX Servers'
		GOTO ERROR_EXIT
	END
    SELECT @esxServerCount = COUNT(*) FROM #tmpESXServerTbl
		UPDATE  #tmpESXServerTbl
			SET t_vmCount = host.vsHostVMCount,
			t_cpuCount = host.vsCPUCores,
			t_totalMemory = host.vsMemoryTotalCapacity,
			t_usedMemory = host.vsMemoryUsed,
			t_totalCPU = host.vsCPUTotalCapacity,
			t_usedCPU = host.vsCPUUsed
		FROM #tmpESXServerTbl
		INNER JOIN (
			SELECT
				vh.id,
				h.value('@numVMsAndTemplates','integer') AS vsHostVMCount,
				h.value('@numCpuCores','integer') AS vsCPUCores,
				(mem.value('@MemoryTotalCapacity','bigint'))/(1024*1024) AS vsMemoryTotalCapacity,
				(mem.value('@MemoryReservedCapacity','bigint'))/(1024*1024) AS vsMemoryUsed,
				cpu.value('@CPUTotalCapacity','integer') AS vsCPUTotalCapacity,
				cpu.value('@overallCpuUsage','integer') AS vsCPUUsed
			FROM App_VMHost AS vh
			CROSS APPLY vh.vxml.nodes('QSMServer_QVirtualHostReq') AS Hosts(h)
			CROSS APPLY  h.nodes('./cpuInfo') AS CPU(cpu)
			CROSS APPLY h.nodes('./memInfo') AS Memory(mem)
			WHERE vh.id in ( SELECT t_esxServerId FROM #tmpESXServerTbl)
		) AS host ON
		host.id = #tmpESXServerTbl.t_esxServerId
				-- discount suspended/stopped vms
		update ESX
		set t_vmCount -= cast( (.90*t.vmcount) as int)
		from	( select esx.t_esxServerId, count(*) as vmcount
					from app_vm vm
					inner join #tmpEsxServerTbl esx
					on vm.vHostId = esx.t_esxServerId
					where vm.vxml.value('/QSMServer_QVirtualMachineReq[1]/@powerState', 'int') = 2
					group by esx.t_esxServerId
		) t
		inner join #tmpEsxServerTbl ESX
		on ESX.t_esxServerId = t.t_esxServerId
		where t_vmcount > 1
		UPDATE #tmpEsxServerTbl set t_vmCount =1 WHERE t_vmCount=0
		UPDATE #tmpEsxServerTbl set t_totalMemory =1 WHERE t_totalMemory =0
		UPDATE #tmpEsxServerTbl set t_totalCPU =1 WHERE t_totalCPU=0
		UPDATE #tmpEsxServerTbl
		SET t_usedMemory += CASE WHEN @policyType = 2 THEN vmd.memory ELSE (vmd.memory * 1024) END
		from #tmpEsxServerTbl h
		join (SELECT hostName, SUM(memory) AS memory FROM #VMProgressDetails GROUP BY hostName) vmd
		on h.t_esxServerName = vmd.hostName
		INSERT INTO #outEsxServerTbl
		SELECT * from #tmpEsxServerTbl
		-- 10% allowance should be considered
		DECLARE @memFreePerc INT=0;
		IF @vmAllocPolicy.exist('(policy/serverFreePercentage/@isEnabled)[1]') = 1 AND @vmAllocPolicy.value('(policy/serverFreePercentage/@isEnabled)[1]','int') = 1
		BEGIN
			SET @memFreePerc = ISNULL(@vmAllocPolicy.value('(policy/serverFreePercentage/@memoryPercentage)[1]','int'),0)
		END
		ELSE
		BEGIN
			SELECT @memFreePerc = CAST(ISNULL(VALUE,0) AS INT) FROM GXGLOBALPARAM WHERE NAME = 'ProvisioningServerMemoryFreePercentage'
		END
		IF @memFreePerc = 0 AND (@policyType  not in (5,6,12,13)) -- virtual lab (vmware/hyper-v) restore policy types
		BEGIN
				SET @memFreePerc = 5
		END
		IF @isLiveMountPolicy =0 AND @isRestoreLabPolicy != 1
			DELETE  FROM #tmpEsxServerTbl WHERE ((t_totalMemory - t_usedMemory)*1.0/t_totalMemory*1.0 ) *100 < @memFreePerc
  		IF NOT EXISTS ( SELECT t_esxServerId FROM #tmpEsxServerTbl )
		BEGIN
SET @errorCode = (140 | (CAST(POWER(2, 24) AS BIGINT) * 72))
			SET @errorString = 'None of the host servers configured in the Allocation policy can be selected for creating virtual machine due to Low memory.'
			GOTO ERROR_EXIT
		END
    IF ( @esxServerCount <> 1 )
    BEGIN
		-- weight is given for each parameter
		Select TOP 1 @esxServerId = t_esxServerId , @value = (t_totalMemory/t_vmCount) FROM #tmpEsxServerTbl
		ORDER BY (t_totalMemory/t_vmCount) DESC
		UPDATE #tmpEsxServerTbl	SET t_rank += 3
		WHERE t_esxServerId = @esxServerId
		-- normalization for other esx servers
		IF ( @value <> 0 )
		UPDATE #tmpEsxServerTbl SET t_rank += 3*((t_totalMemory/t_vmCount)/@value) WHERE t_esxServerId != @esxServerId
		Select TOP 1 @esxServerId = t_esxServerId , @value = ((t_totalMemory-t_usedMemory)/t_vmCount) FROM #tmpEsxServerTbl
		ORDER BY ((t_totalMemory-t_usedMemory)/t_vmCount) DESC
		UPDATE #tmpEsxServerTbl	SET t_rank += 1
		WHERE t_esxServerId = @esxServerId
		-- normalization for other esx servers
		IF ( @value <> 0 )
		UPDATE #tmpEsxServerTbl SET t_rank += 1*(((t_totalMemory-t_usedMemory)/t_vmCount)/@value) WHERE t_esxServerId != @esxServerId
		Select TOP 1 @esxServerId = t_esxServerId, @value = (cast (t_totalCPU as float)/ISNULL(t_vmCount,1))
		FROM #tmpEsxServerTbl
		ORDER BY (t_totalCPU/ISNULL(t_vmCount,1)) DESC
		UPDATE #tmpEsxServerTbl	SET t_rank += 1
		WHERE t_esxServerId = @esxServerId
		IF ( @value <> 0 )
		UPDATE #tmpEsxServerTbl SET t_rank += (t_totalCPU/t_vmCount)/@value WHERE t_esxServerId != @esxServerId
		Select TOP 1 @esxServerId = t_esxServerId,
				@esxServerName = t_esxServerName
				FROM #tmpEsxServerTbl
		ORDER BY t_rank DESC
	END
	SELECT esx.t_rank,
		   0,
	       '',
		   esx.t_esxServerName,
		   ds.t_dataStoreName ,
		   esx.t_vmcount,
		   case when @policyType =2 or @policyType =5
		        then t_totalMemory
				else cast(t_totalMemory/1024.0 as int)
				end,
		   (esx.t_totalMemory-esx.t_usedMemory)*100/nullif(esx.t_totalMemory,0),
		   ds.t_totalCapacity/1024.0/1024.0/1024.0,
		   ds.t_freeSpace*100.0/nullif(ds.t_totalCapacity,0),
		   esx.t_timestamp,
		   ds.t_timestamp
	FROM #tmpEsxServerTbl esx
			JOIN VMHostToDataStores map
				ON esx.t_esxServerId = map.vHostId
			JOIN #tmpDataStoresTbl ds
				ON map.vDataStoreId = ds.t_dataStoreId
	order by esx.t_rank desc, ds.t_freeSpace	desc
	IF OBJECT_ID('tempdb..#VMInfo') IS NOT NULL
		DROP TABLE #VMInfo
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @errorCode = ERROR_NUMBER()
SET @errorString = ERROR_MESSAGE()
END CATCH
ERROR_EXIT:
IF @errorCode <> 0
BEGIN
		SELECT	0.0,@errorCode,	@errorString, '','', 0, 0, 0,0,0,'',''
		UNION ALL
		select  0.0,
				@errorCode,
		        @errorString,
				esx.t_esxServerName,
				'' ,
		        esx.t_vmcount,
				case when @policyType =2 or @policyType =5
				     then t_totalMemory
					 else cast(t_totalMemory/1024.0 as int)
					 end,
			    (esx.t_totalMemory-esx.t_usedMemory)*100.0/nullif(esx.t_totalMemory,0),
				0,
				0,
				esx.t_timeStamp,
				''
		FROM #outEsxServerTbl esx
		UNION ALL
	    SELECT 0.0,
			   @errorCode,
		       @errorString,
			   '' ,
			   ds.t_dataStoreName ,
			   0,
			   0,
			   0,
			   ds.t_totalCapacity/1024.0/1024.0/1024.0,
			   ds.t_freeSpace*100.0/nullif(ds.t_totalCapacity,0),
			   '',
			   ds.t_timeStamp
		FROM #outDataStoresTbl ds
END
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'VMP_BestLocation')
	delete from GxQscripts where name = 'VMP_BestLocation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_BestLocation')
	delete from GXDBVersions where aliasname = 'VMP_BestLocation'
GO

insert into GXDBVersions values(2, 'VMP_BestLocation',  '00010025001200210000', 'VMP_BestLocation', '00010025001200210000')
GO

