

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_AddUpdateVSInstanceTypes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_AddUpdateVSInstanceTypes.sp,v $ $Id: VMP_AddUpdateVSInstanceTypes.sp,v 1.1.2.4 2018/10/08 17:17:11 ssanur Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   VMP_AddUpdateVSHost   - Process virtual Host @input xml
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_AddUpdateVSInstanceTypes <<<'

IF EXISTS (select * from sysobjects where name='VMP_AddUpdateVSInstanceTypes')
	drop procedure VMP_AddUpdateVSInstanceTypes
IF EXISTS (select * from GxQscripts where name='VMP_AddUpdateVSInstanceTypes')
	delete from GxQscripts where name = 'VMP_AddUpdateVSInstanceTypes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_AddUpdateVSInstanceTypes')
	delete from GXDBVersions where aliasname = 'VMP_AddUpdateVSInstanceTypes'
GO
print '... Creating Procedure: VMP_AddUpdateVSInstanceTypes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_AddUpdateVSInstanceTypes
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @input XML,
  @appId INT,
  @instanceId INT,
  @jobId INT
AS
  DECLARE @o_errorCode INT
  DECLARE @o_errorString NVARCHAR(1024)
BEGIN
	SET NOCOUNT ON
	DECLARE @vendorType INT
	DECLARE @flags INT = 0
	DECLARE @AmazonManual INT = 0
	DECLARE @AzureClassicAutoDiscovered INT = 1
	DECLARE @OracleCloudClassicManual INT = 2
	DECLARE @AzureRMandStackAutoDiscovered INT = 3
	DECLARE @AmazonAutoDiscovered INT = 4
	SET @vendorType = (SELECT attrVal FROM APP_InstanceProp WHERE attrName = 'Virtual Server Instance Type' AND componentNameId = @instanceId)
	SET @flags = CASE @vendorType WHEN 401 THEN @AzureClassicAutoDiscovered
								  WHEN 402 THEN @AzureRMandStackAutoDiscovered
								  WHEN 403 THEN @AzureRMandStackAutoDiscovered
								  WHEN 301 THEN @AmazonAutoDiscovered
								  END
	BEGIN TRY
		BEGIN TRAN
		CREATE TABLE #InstanceTypes (
				instanceType nvarchar(64),
				cpuCores	 INT,
				memory		 nvarchar(32),
				dataDisks	 INT
				)
		INSERT INTO #InstanceTypes
		SELECT I.n.value('@instanceTypeName','nvarchar(64)'),
			   I.n.value('@numOfCpu','INT'),
			   CAST(I.n.value('@memoryInMB','INT') AS varchar(32)),
			   I.n.value('@numOfDisks','INT')
		FROM @input.nodes('QSMServer_VSInstanceTypeList/instanceTypeList') I(n)
		MERGE App_VMInstanceTypes AS I
		USING #InstanceTypes T
			ON I.instanceType = T.instanceType AND I.flags = @flags
		WHEN MATCHED THEN
			UPDATE SET cpuCores = T.cpuCores, memory = T.memory
		WHEN NOT MATCHED THEN
			INSERT (instanceType, cpuUnits, cpuCores, memory, architecture, flags)
			VALUES (T.instanceType, N'N/A', cpuCores, memory, N'N/A', @flags);
		SET @o_errorCode = 0
		SET @o_errorString = 'Success'
		COMMIT TRAN
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
		-- Rollback any active or uncommittable transactions before
		-- inserting information in the ErrorLog
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRANSACTION;
		END
	END CATCH
EXIT_PROC:
		SELECT @o_errorCode AS errorCode, @o_errorString AS errorString
END
GO


IF EXISTS (select * from GxQscripts where name = 'VMP_AddUpdateVSInstanceTypes')
	delete from GxQscripts where name = 'VMP_AddUpdateVSInstanceTypes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_AddUpdateVSInstanceTypes')
	delete from GXDBVersions where aliasname = 'VMP_AddUpdateVSInstanceTypes'
GO

insert into GXDBVersions values(2, 'VMP_AddUpdateVSInstanceTypes',  '00010001000200040000', 'VMP_AddUpdateVSInstanceTypes', '00010001000200040000')
GO

