

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_AddUpdateVSHost.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_AddUpdateVSHost.sp,v $ $Id: VMP_AddUpdateVSHost.sp,v 1.33.34.9.4.1 2021/05/13 02:47:05 ssanakkayala Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   VMP_AddUpdateVSHost   - Process virtual Host @input xml
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='VMP_AddUpdateVSHost')
BEGIN
	print '>>> Drop Stored Procedure: VMP_AddUpdateVSHost <<<'
	drop procedure VMP_AddUpdateVSHost
END
IF EXISTS (select * from GxQscripts where name='VMP_AddUpdateVSHost')
	delete from GxQscripts where name = 'VMP_AddUpdateVSHost'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_AddUpdateVSHost')
	delete from GXDBVersions where aliasname = 'VMP_AddUpdateVSHost'
GO
print '... Creating Procedure: VMP_AddUpdateVSHost'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure VMP_AddUpdateVSHost
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @input XML,
  @appId INT,
  @instanceId INT,
  @jobId INT, 
  @selectiveConfig INT = 0
AS
  DECLARE @o_vHostId INT
  DECLARE @o_errorString NVARCHAR(1024)
BEGIN
	SET NOCOUNT ON
	DECLARE @flags int
	DECLARE @vDataCenterId int
	DECLARE @vHostId int
	DECLARE @vHostName nvarchar(256)
	DECLARE @currTimeStamp datetime = getutcdate()
	DECLARE @vDataCenterName nvarchar(256)
	DECLARE @vCenterName nvarchar(256)
	DECLARE @objectId int
	DECLARE @oldParentId int
	DECLARE @totalItems int
	DECLARE @i INT
	SET @i = 1
	DECLARE @tempXML xml
	DECLARE @usage bigint
	DECLARE @cpuCapacity int
	DECLARE @capacity bigint
	DECLARE @freeSpace bigint
	DECLARE @usedSpace bigint
	DECLARE @dsName nvarchar(256)
	DECLARE @i_csHostName nvarchar(255) = (SELECT net_hostname FROM APP_Client WITH(NOLOCK) WHERE id = 2)
	SET @o_vHostId = -1
	SET @o_errorString = ''
	DECLARE @clientId int
	DECLARE @currentTime INT = (SELECT dbo.GetUnixTime(CURRENT_TIMESTAMP) )
	SET @vHostName = @input.value('(/QSMServer_QVirtualHostReq/@Hostname)[1]', 'nvarchar(256)')
	SET @vDataCenterName = @input.value('(/QSMServer_QVirtualHostReq/@vCenter)[1]', 'nvarchar(256)')
	DECLARE @dataStoreTbl TABLE ( id INT )
	DECLARE @totalSpace bigint
	DECLARE @createClGrps int =0
	DECLARE @createClients int =0
	DECLARE @url nvarchar(256) =NULL
	DECLARE @uniqueName nvarchar(256) = NULL
	DECLARE @vendorType INT = 101
	DECLARE @clGUID NVARCHAR(128) = N''
	DECLARE @hostvXML XML
	SET @vendorType = @input.value('(/QSMServer_QVirtualHostReq/@vendorType)[1]', 'INT')
    if ( @vendorType in(1001, 1101, 1102))
	begin
		set @vDataCenterName = ( select distinct c.name
		from app_client c
		inner join app_application app
		on c.id = app.clientId
		inner join APP_InstanceName I
		on app.instance = I.id
		and I.id = @instanceId )
		if not exists ( select * from APP_VMDataCenter where name = @vDataCenterName )
		BEGIN
			insert into APP_VMDataCenter values (@vDataCenterName, @vDataCenterName, NULL, getutcdate(), getutcdate(), NULL, 0, @vDataCenterName)
			SELECT @vDataCenterId = @@IDENTITY
		END
		else
		begin
			select @vDataCenterId = id from APP_VMDataCenter where name = @vDataCenterName
			update APP_VMDataCenter set timeStamp = getutcdate(), removalTimeStamp = NULL
			where id = @vDataCenterId
		end
		IF NOT EXISTS (SELECT * FROM App_VMDataCenterMap M WHERE M.instanceId = @instanceId AND M.vDataCenterId = @vDataCenterId)
			INSERT INTO App_VMDataCenterMap VALUES (@instanceId, @vDataCenterId, GETUTCDATE(), NULL)
		DECLARE @tempDataCenterOrHostName nvarchar(256) = @vDataCenterName
		DECLARE @hostUniqueName nvarchar(256) = @vDataCenterName
		if ( @vendorType in (1102))
		BEGIN
			SET @tempDataCenterOrHostName = @vHostName
			SET @hostUniqueName = isnull(@input.value('(/QSMServer_QVirtualHostReq/@HostProfile)[1]', 'nvarchar(256)'),@vHostName)
		END
		if not exists ( select * from APP_VMHost where name = @tempDataCenterOrHostName and vDataCenterId = @vDataCenterId)
		BEGIN
			insert into APP_VMHost values (@vDataCenterId,@tempDataCenterOrHostName,  @input, getutcdate(), getutcdate(), NULL, 0, @hostUniqueName,NULL)
			select @o_vHostId = @@IDENTITY
		END
		else
		begin
			select @o_vHostId = id from app_vmhost where name = @tempDataCenterOrHostName and vDataCenterId = @vDataCenterId
			update APP_VMHost set timeStamp = getutcdate(),
			removalTimeStamp = NULL,
			uniqueName = @hostUniqueName
			where id = @o_vHostId
		end
		if not exists ( select * from App_VMDataStore where name = @tempDataCenterOrHostName and vDataCenterId = @vDataCenterId)
		BEGIN
			INSERT INTO App_VMDataStore
					VALUES ( @vDataCenterId, @tempDataCenterOrHostName, null, GETUTCDATE(), GETUTCDATE(),NULL,0, @tempDataCenterOrHostName)
			SET @objectId = SCOPE_IDENTITY();
		end
		else
		begin
			select @objectId = id from App_VMDataStore where name = @vDataCenterName and vDataCenterId = @vDataCenterId
			update App_VMDataStore set timeStamp = getutcdate(),
			removalTimeStamp = NULL
			where id = @objectId
		end
		IF NOT EXISTS (SELECT * FROM VMHostToDataStores WHERE vHostId = @o_vHostId AND vDataStoreId = @objectId)
			INSERT INTO VMHostToDataStores VALUES (@o_vHostId, @objectId)
		SET @o_vHostId = @vHostId
		SET @o_errorString = 'Success'
		goto exit_proc
	end
	-- in case of esx host configuration, we are constructing data center name
	-- does vhost xml has vcenter in that case?
	IF ( @appId > 0 )
	BEGIN
		SELECT @instanceId = instance
			FROM APP_Application WITH(NOLOCK)
			WHERE id = @appId
	END
	IF ( @vDataCenterName IS NULL OR @vDataCenterName = '' AND @vendorType = 102)
	BEGIN
		SELECT	TOP 1 @vDataCenterName = name, @clGUID = CAST(C.GUID AS NVARCHAR(128))
		FROM	APP_Client C, APP_Application A
		WHERE	C.id = A.clientID AND A.instance = @instanceId
	END
	IF ( @vCenterName IS NULL OR @vCenterName = '' AND @vendorType in (101,501))
	BEGIN
		SELECT @vCenterName = AIP.attrVal
		FROM	APP_InstanceProp AIP
		WHERE	AIP.componentNameId = @instanceId AND AIP.attrName = 'Virtual Server Host'
	END
	IF (@vDataCenterName IS NULL OR @vDataCenterName = '' AND @vendorType = 401)
	BEGIN
		SET @vDataCenterName = 'East US'
		set @vHostName = 'DummyCloudService'
	END
	DECLARE @vcenters INT = 0
	SELECT @vcenters = COUNT(*) FROM App_VMDataCenter DC, App_VMDataCenterMap M WHERE DC.name = @vDataCenterName and M.instanceId = @instanceId AND DC.id = M.vDataCenterId
	IF (@vcenters = 0 AND @vendorType in (101,102,501))
	BEGIN
		DECLARE @tempVCenter NVARCHAR(256) = (CASE WHEN @vendorType in (101,501) THEN @vCenterName ELSE @vDataCenterName END )
		IF EXISTS (SELECT * FROM App_VMDataCenter WHERE vCenter = @tempVCenter AND name = @vDataCenterName)
		BEGIN
			UPDATE	App_VMDataCenter SET removalTimeStamp = NULL, uniqueName = @clGUID WHERE vCenter = @tempVCenter AND name = @vDataCenterName
			SET @vDataCenterId = (SELECT TOP 1 id FROM App_VMDataCenter WHERE vCenter = @tempVCenter AND name = @vDataCenterName)
		END
		ELSE
		BEGIN
			INSERT INTO App_VMDataCenter VALUES (@tempVCenter, @vDataCenterName, NULL, GETUTCDATE(), GETUTCDATE(), NULL, 0, @clGUID)
			SELECT @vDataCenterId = @@IDENTITY
		END
		IF NOT EXISTS (SELECT * FROM App_VMDataCenterMap M WHERE M.instanceId = @instanceId AND M.vDataCenterId = @vDataCenterId)
			INSERT INTO App_VMDataCenterMap VALUES (@instanceId, @vDataCenterId, GETUTCDATE(), NULL)
	END
	SELECT @vDataCenterId = vDataCenterId, @vCenterName = vCenter
		FROM App_VMDataCenterMap   vdc
		INNER JOIN App_VMDataCenter   ON
			 vdc.instanceId = @instanceId
			 AND  CASE WHEN @vendorType = 301 THEN uniqueName ELSE name END = @vDataCenterName
			 AND vdc.vDataCenterId = id
	SELECT @vHostId = id
		FROM App_VMHost WITH(NOLOCK)
		WHERE vDataCenterId = @vDataCenterId
		AND name = @vHostName
IF @selectiveConfig = 0
BEGIN
	BEGIN TRY
		BEGIN TRAN
		IF ( @vHostId IS NULL )
		BEGIN
		-- Check to see if this Host has been re-located from another Data Center, if it has move it.
			IF EXISTS((SELECT IP.componentNameId FROM APP_InstanceProp AS IP
						WHERE IP.componentNameId = @instanceId
						AND IP.attrName LIKE 'Virtual Server Instance Type'
						AND IP.attrVal = 301))
			BEGIN
				INSERT INTO App_VMHost (vDataCenterId, name, vxml)
						VALUES (@vDataCenterId, @vHostName, @input)
					SET @vHostId = SCOPE_IDENTITY();
			END
			ELSE
			BEGIN
				SELECT TOP 1
						@objectId = h.id,
						@oldParentId = h.vDataCenterId
				FROM
						CommServ..App_VMHost AS h
				INNER JOIN App_VMDataCenterMap vdc  ON
					vdc.instanceId = @instanceId
					AND vdc.vDataCenterId = h.vDataCenterId
					AND h.name = @vHostName
				IF (@objectId IS NOT NULL)
				BEGIN
					UPDATE CommServ..App_VMHost
						SET vDataCenterId = @vDataCenterId
					, vxml = @input
					, timeStamp = getutcdate()
					, removalTimeStamp = null
					WHERE
						id = @objectId
					SET @vHostId = @objectId
				END
				ELSE
				BEGIN
					INSERT INTO App_VMHost (vDataCenterId, name, vxml)
						VALUES (@vDataCenterId, @vHostName, @input)
					SET @vHostId = SCOPE_IDENTITY();
				END
			END
		END
		ELSE
		BEGIN
			UPDATE App_VMHost
				SET vxml = @input
				, timeStamp = getutcdate()
				, removalTimeStamp = NULL
			WHERE id = @vHostId
		END
		IF (@jobId IS NULL )
			SET @flags = 1
		ELSE
			SET @flags = 0
		-- datastores information
		SET @totalItems = @input.value('count(/QSMServer_QVirtualHostReq/hardWareInfo/dataStoreInfo/datastores)','int')
		SET @i =1
		SET @totalSpace = 0
		SET @freeSpace = 0
		WHILE (@i <= @totalItems )
		BEGIN
			SET @objectId = 0
			SET @url = NULL
			SET @uniqueName = NULL
			SET @tempXML  =  @input.query('(/QSMServer_QVirtualHostReq/hardWareInfo/dataStoreInfo/datastores)[sql:variable("@i")]')
			SET @dsName = @tempXML.value('datastores[1]/@name', 'nvarchar(256)')
			SET @url  = @tempXML.value('(datastores[1]/@uuid)[1]','nvarchar(256)')
			IF (@url IS NULL OR @url = '' )
			BEGIN
				SELECT @objectId=id FROM App_VMDataStore
						WHERE  name = @dsName
						AND vDataCenterId = @vDataCenterId
			END
			ELSE
			BEGIN
				SELECT @objectId=id, @uniqueName = name FROM App_VMDataStore
						WHERE  uniqueName = @url
						AND vDataCenterId = @vDataCenterId
				IF ( @uniqueName IS NULL )
				BEGIN
					SELECT @objectId=id FROM App_VMDataStore
							WHERE  name = @dsName
							AND vDataCenterId = @vDataCenterId
							AND @vendorType <> 102
				END
			END
			IF ( @objectId <> 0  )
			BEGIN
				IF ( @uniqueName IS null AND @url is not null )
				BEGIN
				UPDATE App_VMDataStore
					SET vxml = @tempXML,
							uniqueName = @url,
							timeStamp = getutcdate(),
							removalTimeStamp = null
						WHERE id = @objectId
				END
				ELSE
				BEGIN
					UPDATE App_VMDataStore
						SET vxml = @tempXML,
							name = @dsName,
						timeStamp = getutcdate(),
						removalTimeStamp = NULL
					WHERE id = @objectId
				END
			END
			ELSE
			BEGIN
				INSERT INTO App_VMDataStore
					VALUES ( @vDataCenterId, @dsName, @tempXML, GETUTCDATE(), GETUTCDATE(),NULL,0, @url)
				SET @objectId = SCOPE_IDENTITY();
			END
				INSERT INTO @dataStoreTbl values ( @objectId)
			SET @totalSpace = @totalSpace + @tempXML.value('(datastores[1]/@capacity)', 'bigint')
			SET @freeSpace = @freeSpace + @tempXML.value('(datastores[1]/@freeSpace)', 'bigint')
			SET @i = @i + 1
		END
		DELETE FROM VMHostToDataStores WHERE vHostId = @vHostId
		INSERT INTO VMHostToDataStores (vHostId, vDataStoreId )
			SELECT @vHostId, id FROM @dataStoreTbl
		SET @o_vHostId = @vHostId
		SET @o_errorString = 'Success'
		COMMIT TRAN
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		EXECUTE dbo.GetError @o_errorString OUTPUT , @o_vHostId OUTPUT
		-- Rollback any active or uncommittable transactions before
		-- inserting information in the ErrorLog
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRANSACTION;
		END
	END CATCH
END
ELSE IF @vHostId > 0 AND @selectiveConfig = 1
BEGIN
	SELECT @hostvXML = vxml FROM App_VMHost WHERE id= @vHostId
	Set @hostvXML.modify('delete /QSMServer_QVirtualHostReq/networkInfo')
	SET @tempXML  =  @input.query('(/QSMServer_QVirtualHostReq/networkInfo)')
	Set @hostvXML.modify('insert sql:variable("@tempXML") into (/QSMServer_QVirtualHostReq)[1]')
	UPDATE App_VMHost
		SET vxml = @hostvXML
		, timeStamp = getutcdate()
		, removalTimeStamp = NULL
	WHERE id = @vHostId
END
ELSE IF @vHostId > 0 AND @selectiveConfig = 2
BEGIN
	SELECT @hostvXML = vxml FROM App_VMHost WHERE id= @vHostId
	DECLARE @Hostname varchar(256) =''
	DECLARE @connectionState INT = -1
	DECLARE @fromDirectDatabaseAccess varchar(256) =''
	DECLARE @logicalProcessors INT  =-1
	DECLARE @manufacturer varchar(256) = ''
	DECLARE @model varchar(256) = ''
	DECLARE @numVMsAndTemplates INT = -1
	DECLARE @vCenter varchar(256) = ''
	DECLARE @cpuInfo XML, @memInfo XML
	SET @cpuInfo = (SELECT
							Q.n.value('@CPUAvailableCapacity','BIGINT') AS '@CPUAvailableCapacity',
							Q.n.value('@CPUReservedCapacity','BIGINT') AS '@CPUReservedCapacity',
							Q.n.value('@CPUTotalCapacity','BIGINT') AS '@CPUTotalCapacity',
							Q.n.value('@overallCpuUsage','BIGINT') AS '@overallCpuUsage'
					FROM @input.nodes('QSMServer_QVirtualHostReq/cpuInfo') Q(n)
					FOR XML PATH('cpuInfo'))
	select @cpuInfo
	SET @memInfo = (SELECT
							Q.n.value('@MemoryAvailableCapacity','BIGINT') AS '@MemoryAvailableCapacity',
							Q.n.value('@MemoryOverheadReservation','BIGINT') AS '@MemoryOverheadReservation',
							Q.n.value('@MemoryReservedCapacity','BIGINT') AS '@MemoryReservedCapacity',
							Q.n.value('@MemoryTotalCapacity','BIGINT') AS '@MemoryTotalCapacity'
					FROM @input.nodes('QSMServer_QVirtualHostReq/memInfo') Q(n)
					FOR XML PATH('memInfo'))
	select @memInfo
	SELECT @Hostname = ISNULL(Q.n.value('@Hostname','varchar(256)'), ''),
		   @connectionState = ISNULL(Q.n.value('@connectionState','INT'), -1),
		   @fromDirectDatabaseAccess = ISNULL(Q.n.value('@fromDirectDatabaseAccess','varchar(256)'), ''),
		   @jobId = ISNULL(Q.n.value('@jobId','INT'), -1),
		   @logicalProcessors = ISNULL(Q.n.value('@logicalProcessors','INT'), -1),
		   @manufacturer = ISNULL(Q.n.value('@manufacturer','varchar(256)'), ''),
		   @model = ISNULL(Q.n.value('@model','varchar(256)'), ''),
		   @numVMsAndTemplates = ISNULL(Q.n.value('@numVMsAndTemplates','INT'), -1),
		   @vCenter = ISNULL(Q.n.value('@vCenter','varchar(256)'), '')
	FROM @input.nodes('QSMServer_QVirtualHostReq') Q(n)
	IF @Hostname <> ''
		SET @hostvXML.modify('replace value of (/QSMServer_QVirtualHostReq/@Hostname)[1] with (sql:variable("@Hostname"))')
	IF @connectionState <> -1
		SET @hostvXML.modify('replace value of (/QSMServer_QVirtualHostReq/@connectionState)[1] with (sql:variable("@connectionState"))')
	IF @fromDirectDatabaseAccess <> ''
		SET @hostvXML.modify('replace value of (/QSMServer_QVirtualHostReq/@fromDirectDatabaseAccess)[1] with (sql:variable("@fromDirectDatabaseAccess"))')
	IF @jobId <> -1
		SET @hostvXML.modify('replace value of (/QSMServer_QVirtualHostReq/@jobId)[1] with (sql:variable("@jobId"))')
	IF @logicalProcessors <> -1
		SET @hostvXML.modify('replace value of (/QSMServer_QVirtualHostReq/@logicalProcessors)[1] with (sql:variable("@logicalProcessors"))')
	IF @manufacturer <> ''
		SET @hostvXML.modify('replace value of (/QSMServer_QVirtualHostReq/@manufacturer)[1] with (sql:variable("@manufacturer"))')
	IF @model <> ''
		SET @hostvXML.modify('replace value of (/QSMServer_QVirtualHostReq/@model)[1] with (sql:variable("@model"))')
	IF @numVMsAndTemplates <> -1
		SET @hostvXML.modify('replace value of (/QSMServer_QVirtualHostReq/@numVMsAndTemplates)[1] with (sql:variable("@numVMsAndTemplates"))')
	IF @vCenter <> ''
		SET @hostvXML.modify('replace value of (/QSMServer_QVirtualHostReq/@vCenter)[1] with (sql:variable("@vCenter"))')
	IF @cpuInfo.exist('cpuInfo') = 1
	BEGIN
		Set @hostvXML.modify('delete /QSMServer_QVirtualHostReq/cpuInfo')
		Set @hostvXML.modify('insert sql:variable("@cpuInfo") into (/QSMServer_QVirtualHostReq)[1]')
	END
	IF @memInfo.exist('memInfo') = 1
	BEGIN
		Set @hostvXML.modify('delete /QSMServer_QVirtualHostReq/memInfo')
		Set @hostvXML.modify('insert sql:variable("@memInfo") into (/QSMServer_QVirtualHostReq)[1]')
	END
	UPDATE App_VMHost
		SET vxml = @hostvXML
		, timeStamp = getutcdate()
		, removalTimeStamp = NULL
	WHERE id = @vHostId
END
EXIT_PROC:
		SELECT @o_vHostId AS vHostId, @o_errorString AS errorString
END
GO


IF EXISTS (select * from GxQscripts where name = 'VMP_AddUpdateVSHost')
	delete from GxQscripts where name = 'VMP_AddUpdateVSHost'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_AddUpdateVSHost')
	delete from GXDBVersions where aliasname = 'VMP_AddUpdateVSHost'
GO

insert into GXDBVersions values(2, 'VMP_AddUpdateVSHost',  'v1.33.34.9.4.1', 'VMP_AddUpdateVSHost', 'v1.33.34.9.4.1')
GO

