

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_AddUpdateVM.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_AddUpdateVM.sp,v $ $Id: VMP_AddUpdateVM.sp,v 1.49.12.13 2020/08/14 14:35:18 scheppuri Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   VMP_AddUpdateVM   - Process virtual server vm @input xml
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='VMP_AddUpdateVM')
BEGIN
	print '>>> Drop Stored Procedure: VMP_AddUpdateVM <<<'
	drop procedure VMP_AddUpdateVM
END
IF EXISTS (select * from GxQscripts where name='VMP_AddUpdateVM')
	delete from GxQscripts where name = 'VMP_AddUpdateVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_AddUpdateVM')
	delete from GXDBVersions where aliasname = 'VMP_AddUpdateVM'
GO
print '... Creating Procedure: VMP_AddUpdateVM'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_AddUpdateVM
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @input XML,
  @appId INT,
  @instance_Id INT,
  @jobId INT 
AS
  DECLARE @o_vmId INT
  DECLARE @o_errorString NVARCHAR(1024)
BEGIN
	SET NOCOUNT ON
	DECLARE @flags int
	DECLARE @vDataCenterId int
	DECLARE @vHostId int
	DECLARE @vHostName nvarchar(256)
	DECLARE @attrVal nvarchar(256)
	DECLARE @objectId int
	DECLARE @oldParentId int
	DECLARE @totalItems int
	DECLARE @dbItems int
	DECLARE @guestOS nvarchar(256)
	DECLARE @i INT
	SET @i = 1
	DECLARE @idleValue int
	DECLARE @tempXML xml
	DECLARE @usage bigint
	DECLARE @cpuCapacity int
	DECLARE @capacity bigint
	DECLARE @usedSpace bigint
	DECLARE @vmGUID nvarchar(256)
	DECLARE @vmName nvarchar(256)
	DEClARE @vmId int
	DECLARE @clientId int
	DECLARE @guestOSVersion nvarchar(256)
	DECLARE @simOS nvarchar(256)
	DECLARE @platform nvarchar(256)
	DECLARE @freeSpace bigint
	DECLARE @i_csHostName nvarchar(255) = (SELECT net_hostname FROM APP_Client WHERE id = 2)
	DECLARE @isTemplate int
	SET @o_vmId = -1
	SET @o_errorString = ''
	DECLARE @isSRMEnabled int =0
	DECLARE @fullDataCollection int =0
	SET @vHostName = @input.value('/QSMServer_QVirtualMachineReq[1]/@Hostname', 'nvarchar(256)')
	SET @vmName = @input.value('/QSMServer_QVirtualMachineReq[1]/@name', 'nvarchar(256)')
	SET @vmGUID = @input.value('/QSMServer_QVirtualMachineReq[1]/@guid', 'nvarchar(256)')
	SET @isTemplate = @input.value('/QSMServer_QVirtualMachineReq[1]/@isTemplate', 'int')
	SET @fullDataCollection = @input.value('/QSMServer_QVirtualMachineReq[1]/@fullDataCollection', 'int')
	DECLARE @fullInfo int =1
	DECLARE @strVal nvarchar(256)
	DECLARE @dbXML xml
	DECLARE @compId int
	DECLARE @dbClientId int
	DECLARE	@instanceType int = 101
	DECLARE @noNamePolicyId INT = 1
	IF ( @appId > 0 )
	BEGIN
	   SELECT @instance_Id = instance
	   FROM APP_Application WITH(NOLOCK)
	   WHERE id = @appId
    END
	SELECT	@instanceType = attrVal
	FROM	APP_InstanceProp
	WHERE	componentNameId = @instance_Id
		AND	attrName = 'Virtual Server Instance Type'
	IF  (@instanceType = 1101 or @instanceType = 1001)
	BEGIN
		SELECT @vHostName = vh.name
		from APP_VMHost vh
		inner join APP_VMDataCenter dc
		on vh.vDataCenterId = dc.id
		inner join APP_VMDataCenterMap map
		on map.vDataCenterId = dc.id
		and map.instanceId = @instance_Id
	END
	IF ( @instanceType = 1001 )
	BEGIN
		DECLARE @VClientId int
		DECLARE @nethostname nvarchar(256)
		SELECT @VClientId = C.id
		from APP_Client C
		INNER JOIN APP_Application A
		on C.id = A.clientId
		and A.instance = @instance_Id
		select @nethostname = substring(prop.attrVal,0,charindex(':',prop.attrVal,0)) from
		APP_InstanceProp prop
		where prop.componentNameId = @instance_Id
		and prop.attrName ='Virtual Server Host'
		and prop.modified =0
		SELECT @vmId = id from APP_Container where containerId = @vmGUID and vcClientId = @VClientId
		DECLARE @docker XML =
		(
			 select (select @input.query('/QSMServer_QVirtualMachineReq[1]/dockerProperties')),
					( select h.value('@capacityInKb' ,'bigint') as '@diskSize',
					         h.value('@pathInContainer' ,'nvarchar(255)') as '@pathInContainer',
					         h.value('@pathInHost' ,'nvarchar(255)') as '@pathInHost'
						   from @input.nodes('/QSMServer_QVirtualMachineReq[1]/hardDisks[1]/hardDisk') H(h)
						   for xml path ('hardDisk') , TYPE
						),
					( select n.value('@port' ,'int') as '@port',
					         n.value('@privatePort' ,'int') as '@privatePort',
							 n.value('@portProtocol' ,'nvarchar(255)') as '@portProtocol',
					         case when isnull(n.value('@privateIPAddress' ,'nvarchar(255)'),'') ='' then @nethostname
							      else n.value('@privateIPAddress' ,'nvarchar(255)') end
							       as '@privateIPAddress'
						   from @input.nodes('/QSMServer_QVirtualMachineReq[1]/adapter[1]/NetworkAdapter') N(n)
						   for xml path ('networkCards') , TYPE , ROOT('advancedProperties')
						)
						for xml path('') , ROOT('virtualMachine')
		)
		if @vmId is null
		BEGIN
			INSERT INTO APP_Container (containerId, name, description, powerState, ipAddress, templateName
									   , operatingSystem, clientId, vcClientId, ownerId, created, modified, deleted, flags)
			values ( @vmGUID, @vmName, '', isnull(@input.value('/QSMServer_QVirtualMachineReq[1]/@powerState', 'int'),0), '', '', '', 0, @VClientId, 1, dbo.GetUnixTime(getutcdate()), 0, 0, @isTemplate)
			SET @vmId = SCOPE_IDENTITY();
			INSERT INTO APP_ContainerProp ( componentNameId, attrName, attrType,  attrVal, created , modified )
			values ( @vmId, 'Container Attributes', 2, cast(@docker as nvarchar(max)), dbo.GetUnixTime(getutcdate()), 0)
		END
		ELSE
		BEGIN
			UPDATE APP_Container
			SET modified = dbo.GetUnixTime(getutcdate()),
			    powerState = @input.value('/QSMServer_QVirtualMachineReq[1]/@powerState', 'int'),
			    deleted =0
			WHERE id = @vmId
		   UPDATE APP_ContainerProp
		   set attrval = cast(@docker as nvarchar(max))
		   where componentNameId = @vmId
		   and attrName ='Container Attributes'
		END
		SET @o_vmId = @vmId
		SET @o_errorString = 'Success'
		goto EXIT_PROC
	END
	IF (@instanceType = 401 AND ISNULL(@vHostName, '') = '')
		SET @vHostName = 'DummyCloudService'
	SELECT @vHostId = vh.id
	FROM App_VMHost vh WITH(NOLOCK)
	inner join APP_VMDataCenter dc
	on vh.vDataCenterId = dc.id
	inner join APP_VMDataCenterMap map
	on map.vDataCenterId = dc.id
	and map.instanceId = @instance_Id
	and vh.name = @vHostName
	and vh.removalTimeStamp is null
	and dc.removalTimeStamp is null
	--for oracle cloud infrastructure vm hostname will match with uniqueName
	IF ISNULL(@vHostId, 0) = 0 and @instanceType in (1102)
	BEGIN
			SELECT @vHostId = vh.id
			FROM App_VMHost vh WITH(NOLOCK)
			inner join APP_VMDataCenter dc
			on vh.vDataCenterId = dc.id
			inner join APP_VMDataCenterMap map
			on map.vDataCenterId = dc.id
			and map.instanceId = @instance_Id
			and vh.uniqueName = @vHostName
			and vh.uniqueName is not null
			and vh.removalTimeStamp is null
			and dc.removalTimeStamp is null
	END
	SELECT @vmId =id, @clientId = clientId
		FROM App_VM WITH(NOLOCK)
		WHERE vHostId = @vHostId
			AND GUID = @vmGUID
	SELECT @noNamePolicyId = id FROM APP_VMAllocationPolicy WHERE name = '_NO_NAME_'
BEGIN TRY
	IF ( @vmId IS  NULL )
	BEGIN
	-- Check to see if this vm has been re-located to another host, if it has move it.
		IF @instanceType = 401 -- Azure
		BEGIN
			SELECT TOP 1
					@objectId = V.id,
					@oldParentId = V.vHostId
			FROM App_VM V WITH(NOLOCK), APP_ClientProp CP WITH(NOLOCK)
			WHERE V.clientId = CP.componentNameId
				AND CP.attrName = 'Virtual Machine Instance UUID'
				AND CP.attrVal = @vmGUID AND CP.modified =0
		END
		ELSE
		BEGIN
			SELECT TOP 1
					@objectId = vm.id,
					@oldParentId = vm.vHostId
			FROM
					CommServ..App_VM AS vm
			WHERE
					vm.GUID = @vmGUID
		END
		IF (@objectId IS NOT NULL)
		BEGIN
			UPDATE CommServ..App_VM
				SET vHostId = @vHostId
			WHERE
				id = @objectId
			SET @vmId = @objectId
			SELECT @clientId = clientId FROM App_VM WHERE id = @vmId
			--checking if clientId also need to updated
			SET @dbClientId = ISNULL((SELECT top 1 componentNameId
				FROM APP_ClientProp
				WHERE attrName = 'Virtual Machine Instance UUID'
				AND attrVal = @vmGUID
				AND modified =0),0)
			IF ( @dbClientId = 0 )
			BEGIN
					SET @dbClientId = ISNULL((SELECT top 1 componentNameId
					FROM APP_ClientProp
					WHERE attrName = 'Virtual Machine GUID'
					AND attrVal = @vmGUID
					AND modified =0),0)
			END
			IF ( @dbClientId > 0 AND @dbClientId <> @clientId )
					UPDATE App_VM set clientId = @dbClientId where id = @vmId
		END
		ELSE
		BEGIN
			SELECT @clientId = componentNameId
				FROM APP_ClientProp
				WHERE attrName = 'Virtual Machine Instance UUID'
				AND attrVal = @vmGUID
				AND modified =0
			SELECT @objectId = componentNameId
				FROM APP_ClientProp
				WHERE attrName = 'Virtual Machine GUID'
				AND attrVal = @vmGUID
				AND modified =0
			IF ( @clientId is not null )
			BEGIN
				select @vmId = id from APP_VM where clientId = @clientId and removalTimestamp is null
				UPDATE APP_VM set GUID = @vmGUID where id = @vmId
			END
			ELSE IF ( @clientId is NULL )
			BEGIN
				SET @clientId = @objectId
				IF ( @clientId IS null )
				BEGIN
					SET @o_errorString = 'Client entry is not present'
					GOTO EXIT_PROC
				END
			END
			IF (@vmId is NULL )
			BEGIN
				INSERT INTO APP_VM (vHostId, clientId, GUID, name, vxml, timeStamp, addTimeStamp, removalTimeStamp, status, vmAllocationPolicyId)
					VALUES (@vHostId, @clientId, @vmGUID, @vmName, @input
							, GETUTCDATE(), GETUTCDATE(), NULL, 0, @noNamePolicyId)
				SET @vmId = SCOPE_IDENTITY();
			END
		END
	END
	ELSE
	BEGIN
				SET @dbClientId = ISNULL((SELECT top 1 componentNameId
				FROM APP_ClientProp
				WHERE attrName = 'Virtual Machine Instance UUID'
				AND attrVal = @vmGUID
				AND modified =0),0)
				IF ( @dbClientId = 0 )
				BEGIN
					SET @dbClientId = ISNULL((SELECT top 1 componentNameId
					FROM APP_ClientProp
					WHERE attrName = 'Virtual Machine GUID'
					AND attrVal = @vmGUID
					AND modified =0),0)
				END
				IF ( @dbClientId > 0 AND @dbClientId <> @clientId )
					UPDATE App_VM set clientId = @dbClientId where id = @vmId
	END
	BEGIN
		IF ( @fullDataCollection = 1 )
		BEGIN
			SET @tempXML = @input
			SET @tempXML.modify('
			delete (/QSMServer_QVirtualMachineReq/snapShotInfo)
			');
			UPDATE CommServ..App_VM
				SET vxml = @tempXML,
				timeStamp = GETUTCDATE(),
				removalTimeStamp = NULL,
				name = @vmName
			WHERE id = @vmId
		END
		ELSE
		BEGIN
			SELECT @dbXML = vxml
			FROM CommServ..App_VM
			WHERE id = @vmId
			SET @tempXML = @dbXML.query('(/QSMServer_QVirtualMachineReq/hardDisks)')
			SET @input.modify('
			delete (/QSMServer_QVirtualMachineReq/hardDisks[1])
			');
			SET @input.modify('
			insert (
				sql:variable("@tempXML")
				) after (/QSMServer_QVirtualMachineReq/adapter)[1]
			');
			SET @input.modify('
			delete (/QSMServer_QVirtualMachineReq/adapter[1])
			');
			SET @tempXML = @dbXML.query('(/QSMServer_QVirtualMachineReq/adapter)')
			SET @input.modify('
			insert (
				sql:variable("@tempXML")
				) before (/QSMServer_QVirtualMachineReq/hardDisks)[1]
			');
			SET @input.modify('
			delete (/QSMServer_QVirtualMachineReq/storage[1])
			');
			SET @tempXML = @dbXML.query('(/QSMServer_QVirtualMachineReq/storage)')
			SET @input.modify('
			insert (
				sql:variable("@tempXML")
				) after (/QSMServer_QVirtualMachineReq/permission)[1]
			');
			SET @attrVal = @dbXML.value('/QSMServer_QVirtualMachineReq[1]/@VMVersion', 'nvarchar(256)')
			SET @input.modify('
			replace value of /QSMServer_QVirtualMachineReq[1]/@VMVersion with sql:variable("@attrVal")')
			SET @attrVal = @dbXML.value('/QSMServer_QVirtualMachineReq[1]/@toolsVersion', 'nvarchar(256)')
			SET @input.modify('
			replace value of /QSMServer_QVirtualMachineReq[1]/@toolsVersion with sql:variable("@attrVal")')
			SET @attrVal = @dbXML.value('/QSMServer_QVirtualMachineReq[1]/@bootDelay', 'nvarchar(256)')
			SET @input.modify('
			replace value of /QSMServer_QVirtualMachineReq[1]/@bootDelay with sql:variable("@attrVal")')
			SET @attrVal = @dbXML.value('/QSMServer_QVirtualMachineReq[1]/memory[1]/@memorySizeMB', 'nvarchar(256)')
			SET @strVal =  @input.value('/QSMServer_QVirtualMachineReq[1]/memory[1]/@memorySizeMB', 'nvarchar(256)')
			if ( ISNULL(@strVal,'0') = '0' )
				SET @input.modify('
				replace value of /QSMServer_QVirtualMachineReq[1]/memory[1]/@memorySizeMB with sql:variable("@attrVal")')
			SET @attrVal = @dbXML.value('/QSMServer_QVirtualMachineReq[1]/cpu[1]/@numCpu', 'nvarchar(256)')
			SET @strVal =  @input.value('/QSMServer_QVirtualMachineReq[1]/cpu[1]/@numCpu', 'nvarchar(256)')
			if ( ISNULL(@strVal,'0') = '0' )
				SET @input.modify('
				replace value of /QSMServer_QVirtualMachineReq[1]/cpu[1]/@numCpu with sql:variable("@attrVal")')
			SET @attrVal = @dbXML.value('/QSMServer_QVirtualMachineReq[1]/@ipAddress', 'nvarchar(256)')
			SET @strVal =  @input.value('/QSMServer_QVirtualMachineReq[1]/@ipAddress', 'nvarchar(256)')
			if ( ISNULL(@strVal,'') = '' )
				SET @input.modify('
				replace value of /QSMServer_QVirtualMachineReq[1]/@ipAddress with sql:variable("@attrVal")')
			UPDATE CommServ..App_VM
				SET vxml = @input,
				timeStamp = GETUTCDATE(),
				removalTimeStamp = NULL,
                name = @vmName
			WHERE id = @vmId
			SET @fullInfo =0
		END
	END
	SET @guestOS =@input.value('/QSMServer_QVirtualMachineReq[1]/@guestOS', 'nvarchar(256)')
	SET @guestOSVersion = @input.value('/QSMServer_QVirtualMachineReq[1]/@guestOSVersion', 'nvarchar(256)')
	-- default N/A
	SET @platform = 'N/A'
	IF ( CHARINDEX('64-bit',@guestOS) != 0 )
			 SET @platform = 'x64'
	ELSE IF (  CHARINDEX('32-bit',@guestOS) != 0 )
			 SET @platform = 'x86'
	ELSE IF ( CHARINDEX('NetWare',@guestOS) != 0 )
			 SET @platform = 'NetWare'
	SET @simOS = @guestOS + ':-' + @guestOSVersion + ':-N/A:-'+ @platform
	BEGIN
		SELECT @strVal=attrVal, @compId = id FROM APP_ClientProp
			WHERE attrName = 'Sim OS Info'
			AND componentNameId = @clientId
			AND modified =0
		IF ( @compId IS NOT NULL AND @strVal != @simOS AND @guestOS != '')
		BEGIN
		       UPDATE APP_ClientProp
			      SET  attrVal = @simOS
			   WHERE id = @compId
			   AND attrName = 'Sim OS Info'
		END
		ELSE IF ( @compId IS NULL )
		BEGIN
				INSERT INTO APP_ClientProp
				VALUES ( @clientId, 'Sim OS Info', 1, @simOS, dbo.GetUnixTime(getutcdate()), 0, 0)
		END
	END
	SET @compId = 0
	SELECT @strVal=attrVal, @compId = id FROM APP_ClientProp
	WHERE attrName = 'Virtual Entity Flags'
	AND componentNameId = @clientId
	AND modified =0
	IF ( @compId = 0 )
	BEGIN
		IF ( @isTemplate = 1) SET @strVal = '2'
		ELSE SET @strVal = '1'
		INSERT INTO APP_ClientProp
		VALUES ( @clientId, 'Virtual Entity Flags', 2, @strVal, dbo.GetUnixTime(getutcdate()), 0, 0)
	END
	IF ( @compId <> 0 )
	BEGIN
		SET @flags = @strVal
		IF ( @isTemplate = 1 )
			SET @flags |= 2
		ELSE SET @flags |= 1
		if @instanceType <> 102
		BEGIN
			UPDATE APP_ClientProp
				SET attrVal = @flags
			WHERE id  = @compId
		END
	END
	IF (@jobId IS null )
			SET @flags = 1
		ELSE
			SET @flags = 0
    IF (@fullInfo = 1 )
	BEGIN
		DECLARE @vendorType INT= (select v.a.value('@vendorType','INT') from  @input.nodes('/QSMServer_QVirtualMachineReq') v(a) )
		IF @vendorType <> 301
		BEGIN
    		IF object_id('tempdb.dbo.#tmpVMSnapShotList') IS NOT null DROP TABLE #tmpVMSnapShotList
    		create table #tmpVMSnapShotList(
    						id				int IDENTITY(1,1) NOT NULL,
    						name			nvarchar(255),
    						moref			nvarchar(1024),
    						parentMoref		nvarchar(1024),
    						description		nvarchar(1024),
    						createTimeStamp	 datetime,
							flags			INT
    						)
    		INSERT INTO #tmpVMSnapShotList (name, moref,description, createTimeStamp, parentMoref)
    		SELECT S.snap.value('@name', 'nvarchar(255)'),
    			  S.snap.value('@moref', 'nvarchar(1024)'),
    			  S.snap.value('@description', 'nvarchar(1024)'),
    			  dbo.UTCToCellLocalTime(dbo.getdatetime(S.snap.value('@creationTime','bigint')),2),
				  ''
    		FROM @input.nodes('/QSMServer_QVirtualMachineReq/snapShotInfo') AS S(snap)
    		INSERT INTO #tmpVMSnapShotList (name, moref,description, createTimeStamp, parentMoref)
    		SELECT T.ref.value('@name', 'nvarchar(255)'),
    			  T.ref.value('@moref', 'nvarchar(1024)'),
    			  T.ref.value('@description', 'nvarchar(1024)'),
			  dbo.UTCToCellLocalTime(dbo.getdatetime(T.ref.value('@creationTime','bigint')),2),
     			  T.ref.value('../@moref', 'nvarchar(1024)')
    		FROM @input.nodes('/QSMServer_QVirtualMachineReq/snapShotInfo') AS S(snap)
    		CROSS APPLY @input.nodes('//childSnaps') AS T(ref)
    		DELETE FROM #tmpVMSnapShotList where name ='' or moref='empty'
    		UPDATE #tmpVMSnapShotList SET parentMoref ='' WHERE parentMoref ='empty'
			UPDATE T SET flags = S.flags
			FROM #tmpVMSnapShotList T INNER JOIN App_VmSnapShot S
				ON T.name = S.name AND T.moref = S.moref --AND T.createTimeStamp = S.createTimeStamp
    		DELETE FROM App_VmSnapShot WHERE vmId = @vmId
    		INSERT INTO App_VmSnapShot (vmId, vmDataStoreId, filePath, moref,parentMoref, name, description, createTimeStamp, addTimeStamp, removalTimeStamp, flags)
    		SELECT @vmId, 0, '', moref, ISNULL(parentMoref,''), name, description, createTimeStamp, GETUTCDATE(), NULL, ISNULL(flags, 0) FROM #tmpVMSnapShotList
		END
		ELSE
     	BEGIN
     		-- Volume Information
			DECLARE @volumedata TABLE (
									volumeId nvarchar(1024),
									sizeInGB int,
									name nvarchar(512),
									deviceName nvarchar(64),
									snapshotId nvarchar(1024),
									availabilityZone nvarchar(64),
									status nvarchar(64),
									bDeleteOnTermination int,
									creationTime datetime,
									volumeType nvarchar(64),
									iops int
									)
			INSERT INTO @volumedata(name, deviceName, volumeId, status, sizeInGB, snapshotId , availabilityZone, bDeleteOnTermination, creationTime, iops, volumeType)
			SELECT	s.d.value('@label','nvarchar(256)'),
					s.d.value('@summary', 'nvarchar(64)'),
					s.d.value('@volumeId','nvarchar(1024)'),
					s.d.value('@status','nvarchar(64)'),
					ROUND((s.d.value('@capacityInKb','bigint')/(1024.0*1024.0*1024.0)),0),
					s.d.value('@snapshotId','nvarchar(1024)'),
					s.d.value('@availabilityZone','nvarchar(64)'),
					s.d.value('@bDeleteOnTermination','int'),
					dbo.getdatetime(s.d.value('@createTime','BIGINT')),
					s.d.value('@iops','int'),
					s.d.value('@volumeType','nvarchar(64)')
				FROM @input.nodes('/QSMServer_QVirtualMachineReq/hardDisks/hardDisk') s(d)
			DELETE FROM APP_VMVolumes where instanceId = (SELECT GUID FROM App_VM WHERE id = @vmId)
			IF EXISTS (SELECT * FROM @volumedata)
				INSERT INTO APP_VMVolumes(volumeId, instanceId, device, size, name, snapshotId, availabilityZone, status, bDeleteOnTermination, createTimeStamp, volumeType, iops, userId)
				SELECT V.volumeId ,
					   (SELECT GUID FROM App_VM WHERE id = @vmId),
					   deviceName,
					   V.sizeInGB,
					   V.name,
					   V.snapshotId,
					   V.availabilityZone,
					   V.status,
					   V.bDeleteOnTermination,
					   CASE WHEN ISNULL(V.creationTime,'1970/01/01') <= '1970/01/01' THEN GETUTCDATE() ELSE V.creationTime END,
					   V.volumeType,
					   V.iops,
					   ISNULL((SELECT CAST(attrval AS INT) FROM APP_ClientProp ACP
													INNER JOIN App_VM S ON ACP.componentNameId=S.clientId AND ACP.attrName = 'Virtual Machine Created by User' AND S.GUID=	(SELECT GUID FROM App_VM WHERE id = @vmId)
													),1)
				FROM @volumedata V LEFT JOIN APP_VMVolumes A ON V.volumeId=A.volumeId WHERE A.volumeId IS NULL
			-- Snapshot Information
			DECLARE @snapdata TABLE (
									snapshotName nvarchar(256),
									volname nvarchar(512),
									sizeInGB BIGINT,
									description nvarchar(1024),
									moref nvarchar(1024),
									creationTime datetime,
									flags INT
									)
			INSERT INTO @snapdata(snapshotName ,volname , sizeInGB, description , moref , creationTime )
			SELECT s.d.value('@name','nvarchar(256)'),
				   s.d.value('@volumeName','nvarchar(512)'),
				   ISNULL(s.d.value('@sizeInBytes','BIGINT'),0),
				   s.d.value('@description','nvarchar(1024)'),
				   s.d.value('@moref','nvarchar(1024)'),
				   dbo.getdatetime(s.d.value('@creationTime','bigint'))
				FROM @input.nodes('/QSMServer_QVirtualMachineReq/snapShotInfo') s(d)
			UPDATE T SET flags = S.flags
			FROM @snapdata T INNER JOIN App_VmSnapShot S
				ON T.snapshotName = S.name AND T.moref = S.moref --AND T.creationTime = S.createTimeStamp
			DELETE FROM App_VmSnapShot WHERE vmId = @vmId
			IF EXISTS (SELECT * FROM @snapdata)
				INSERT INTO App_VmSnapShot(vmId, parentMoref, filepath, name, size, description, moref, createTimeStamp, vmDataStoreId, userId, flags)
				SELECT ISNULL((SELECT SV.id FROM App_VM SV INNER JOIN APP_VMVolumes V ON V.instanceId=SV.GUID AND V.volumeId = volname),0),
					   '','',
					   S.snapshotName ,
					   sizeInGB,
					   ISNULL(S.description,'') ,
					   ISNULL(S.moref,'') ,
					   CASE WHEN ISNULL(S.creationTime,'1970/01/01') <= '1970/01/01' THEN GETUTCDATE() ELSE S.creationTime END ,
					   (SELECT id from APP_VMVolumes WHERE volumeId = volname),
					   ISNULL((SELECT CAST(attrval AS INT) FROM APP_ClientProp ACP
													INNER JOIN App_VM SV ON ACP.componentNameId=SV.clientId AND ACP.attrName = 'Virtual Machine Created by User'
													INNER JOIN APP_VMVolumes V ON V.instanceId=SV.GUID AND V.volumeId = volname
													),1),
					   ISNULL(S.flags, 0)
				FROM @snapdata S LEFT JOIN App_VmSnapShot A ON S.moref=A.moref WHERE A.moref IS NULL
     	END
     	IF object_id('tempdb.dbo.#tmpVMFileList') IS NOT null DROP TABLE #tmpVMFileList
    	create table #tmpVMFileList(
    					fileType		int,
    					dataStoreName	nvarchar(255),
    					dataStoreId		int,
    					usedSpace		bigint
    					)
    	INSERT INTO #tmpVMFileList (fileType, dataStoreName , usedSpace)
    	SELECT F.machine.value('@fileType', 'int'),
    		  F.machine.value('@dataStore', 'nvarchar(255)'),
    		  F.machine.value('@size', 'bigint')
    	FROM @input.nodes('/QSMServer_QVirtualMachineReq/storage/machineFileInfo/machineFiles') AS F(machine)
    	UPDATE #tmpVMFileList SET dataStoreId = DS.id FROM #tmpVMFileList vmList
    	INNER JOIN App_VMDataStore DS on DS.name = vmList.dataStoreName
     	IF object_id('tempdb.dbo.#tmpVMDSUsage') IS NOT null DROP TABLE #tmpVMDSUsage
    	create table #tmpVMDSUsage(
    					vmId		int,
    					dataStoreId	 int,
    					allotedSpace  bigint,
    					diskFilesUsage bigint,
    					snapShotsUsage bigint,
    					otherFilesUsage bigint
    					)
		INSERT INTO #tmpVMDSUsage
			SELECT DISTINCT @vmId, dataStoreId, 0, 0, 0,0
			FROM #tmpVMFileList
		UPDATE #tmpVMDSUsage SET snapShotsUsage = ( select SUM(usedSpace)
		FROM #tmpVMDSUsage dsUsage
		INNER JOIN #tmpVMFileList fsList ON
		dsUsage.dataStoreId = fsList.dataStoreId
		where fileType = 2)
		UPDATE #tmpVMDSUsage  SET diskFilesUsage = dsTmp.size
		FROM ( select dsUsage.dataStoreId, SUM(usedSpace) as size
		FROM #tmpVMDSUsage dsUsage
		INNER JOIN #tmpVMFileList fsList ON
		dsUsage.dataStoreId = fsList.dataStoreId
		where fileType = 0
		GROUP BY dsUsage.dataStoreId) as dsTmp
		INNER JOIN #tmpVMDSUsage vmUsage
		ON dsTmp.dataStoreId = vmUsage.dataStoreId
		UPDATE #tmpVMDSUsage SET otherFilesUsage = dsTmp.size
		FROM (select dsUsage.dataStoreId, SUM(usedSpace) as size
		FROM #tmpVMDSUsage dsUsage
		INNER JOIN #tmpVMFileList fsList ON
		dsUsage.dataStoreId = fsList.dataStoreId
		where fileType not in (0,2)
		GROUP BY dsUsage.dataStoreId) as dsTmp
		INNER JOIN #tmpVMDSUsage vmUsage
		ON dsTmp.dataStoreId = vmUsage.dataStoreId
		UPDATE #tmpVMDSUsage SET allotedSpace = dsTmp.size
		FROM (select dsUsage.dataStoreId, SUM(usedSpace) as size
		FROM #tmpVMDSUsage dsUsage
		INNER JOIN #tmpVMFileList fsList ON
		dsUsage.dataStoreId = fsList.dataStoreId
		GROUP BY dsUsage.dataStoreId
		) as dsTmp
		INNER JOIN #tmpVMDSUsage vmUsage
		ON dsTmp.dataStoreId = vmUsage.dataStoreId
   		DELETE VDS
		FROM APP_VMToDataStores VDS
		inner join #tmpVMDSUsage ds
		on   VDS.vmId = @vmId
		and ds.dataStoreId = VDS.vDataStoreId
    			INSERT INTO APP_VMToDataStores
    			SELECT @vmId, dataStoreId, ISNULL(allotedSpace/(1024*1024),0),
    			ISNULL(diskFilesUsage/(1024*1024),0), ISNULL(snapShotsUsage/(1024*1024),0), ISNULL(otherFilesUsage/(1024*1024),0) FROM #tmpVMDSUsage
		WHERE ISNULL(dataStoreId, '') !=''
	END
	SET @o_vmId = @vmId
	SET @o_errorString = 'Success'
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_vmId OUTPUT
END CATCH
EXIT_PROC:
		SELECT @o_vmId AS vmId, @o_errorString AS errorString
END
GO


IF EXISTS (select * from GxQscripts where name = 'VMP_AddUpdateVM')
	delete from GxQscripts where name = 'VMP_AddUpdateVM'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_AddUpdateVM')
	delete from GXDBVersions where aliasname = 'VMP_AddUpdateVM'
GO

insert into GXDBVersions values(2, 'VMP_AddUpdateVM',  '00010049001200130000', 'VMP_AddUpdateVM', '00010049001200130000')
GO

