

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMP_AddUpdateDataCenter.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/VMP_AddUpdateDataCenter.sp,v $ $Id: VMP_AddUpdateDataCenter.sp,v 1.23.2.6 2018/02/28 15:06:35 ssanur Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   VMP_AddUpdateDataCenter   - Process virtual data center @input xml
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: VMP_AddUpdateDataCenter <<<'

IF EXISTS (select * from sysobjects where name='VMP_AddUpdateDataCenter')
	drop procedure VMP_AddUpdateDataCenter
IF EXISTS (select * from GxQscripts where name='VMP_AddUpdateDataCenter')
	delete from GxQscripts where name = 'VMP_AddUpdateDataCenter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_AddUpdateDataCenter')
	delete from GXDBVersions where aliasname = 'VMP_AddUpdateDataCenter'
GO
print '... Creating Procedure: VMP_AddUpdateDataCenter'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMP_AddUpdateDataCenter
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @input XML,
  @appId INT,
  @instanceId INT,
  @jobId INT 
AS
  DECLARE @o_vDataCenterId INT
  DECLARE @o_errorString NVARCHAR(1024)
BEGIN
SET NOCOUNT ON
	DECLARE @dataCenterName nvarchar(256)
	DECLARE @currTimeStamp datetime = getutcdate()
	DECLARE @vDataCenterId int =NULL
	DECLARE @vCenterName nvarchar(256)
	DECLARE	@moref nvarchar(256)= NULL
	DECLARE @vdmapId	int
	DECLARE @flags int
	DECLARE @currentTime INT = (SELECT dbo.GetUnixTime(CURRENT_TIMESTAMP) )
	DECLARE @createClGrps INT =0
	DECLARE @uniqueName nvarchar(256) =NULL
	DECLARE @mapInstanceId INT =0
	DECLARE @tempId INT =0
	DECLARE @timeStamp datetime
	DECLARE @instanceType INT = 0  -- 301: Amazon , 401: Azure
	SET @o_vDataCenterId = -1
	SET @o_errorString = ''
	IF (@jobId = -1 )
		SET @flags = 1
	ELSE
		SET @flags = 0
	IF (@appId > 0 )
	BEGIN
		SELECT @instanceId = instance
			FROM APP_Application
			WHERE id = @appId
	END
SELECT @instanceType = CAST(attrVal AS INT)
		FROM APP_InstanceProp
		WHERE componentNameId = @instanceId
			and attrName ='Virtual Server Instance Type'
IF	@input IS NOT NULL AND @instanceType NOT IN (401, 402,403) -- Not Azure
BEGIN
	SET @dataCenterName = @input.value('(/QSMServer_QVirtualDataCenterReq/@name)[1]', 'nvarchar(256)')
	SET @moref  = @input.value('(QSMServer_QVirtualDataCenterReq/@moref)[1]','nvarchar(256)')
	IF (@instanceType  in (301, 1001, 1101, 1102))
		SELECT	@vCenterName = name
		FROM	App_Client AC
			INNER JOIN APP_Application AP
				ON AC.id=AP.clientId
		WHERE	AP.instance = @instanceId
	ELSE
		SELECT @vCenterName = attrVal
			FROM APP_InstanceProp
			WHERE componentNameId = @instanceId
				and attrName ='Virtual Server Host'
	IF (@instanceType  in (1001, 1101, 1102))
		set @dataCenterName = @vCenterName
	-- why are we constructing data center name in case vcenter is not present?
	IF ( @vcenterName IS null )
		SET @dataCenterName = 'ESX Hosts' + '(' + CAST(@instanceId AS NVARCHAR(20)) + ')'
	SELECT @mapInstanceId = @instanceId FROM App_VMDataCenterMap where @instanceId = @instanceId
	IF (@moref IS null )
	BEGIN
		IF ( @mapInstanceId = 0 )
		BEGIN
			SELECT @vDataCenterId = id
				FROM App_VMDataCenter DC
				WHERE name = @dataCenterName
				AND vCenter = @vCenterName
		END
		ELSE
		BEGIN
			SELECT @vDataCenterId = id
				FROM App_VMDataCenter DC
			INNER JOIN App_VMDataCenterMap DCMap
				ON DCMap.instanceId = @instanceId
				AND DC.name = @dataCenterName
				AND DC.id = DCMap.vDataCenterId
		END
	END
	ELSE
	BEGIN
		IF ( @mapInstanceId <> 0 )
		BEGIN
			SELECT @vDataCenterId = id, @uniqueName = uniqueName
				FROM App_VMDataCenter DC
			INNER JOIN App_VMDataCenterMap DCMap
				ON DCMap.instanceId = @instanceId
				AND DC.uniqueName = @moref
				AND DC.id = DCMap.vDataCenterId
			--  check if there exists another datacenter associated with same vcenter
			-- this can happen if one instance is configured with vcenter host name
			-- and another with ip address and later second instance host is also changed from ip to hostname
			SELECT @tempId = id
				FROM App_VMDataCenter DC
				WHERE (uniqueName = @moref OR name = @dataCenterName)
				AND vCenter = @vCenterName
			IF ( @tempId <> 0 )
			BEGIN
				IF ( @vDataCenterId IS NULL )
				BEGIN
					SET @vDataCenterId = @tempId
				END
				ELSE IF ( @tempId <> @vDataCenterId)
				BEGIN
					-- delete mapping entry for this instance to old data center
					-- also logically delete old associated data center and map this instance to same data center of old instance
					DELETE FROM App_VMDataCenterMap where vDataCenterId = @vDataCenterId
					AND @instanceId = @instanceId
					UPDATE App_VMDataCenter set removalTimeStamp = @currTimeStamp where id = @vDataCenterId
					UPDATE App_VMHost set removalTimeStamp = @currTimeStamp where vDataCenterId = @vDataCenterId
					SET @vDataCenterId = @tempId
				END
			END
			IF  (@uniqueName IS null )
			BEGIN
				SELECT @vDataCenterId = id
					FROM App_VMDataCenter DC
				INNER JOIN App_VMDataCenterMap DCMap
					ON DCMap.instanceId = @instanceId
					AND DC.name = @dataCenterName
					AND DC.id = DCMap.vDataCenterId
			END
		END
		ELSE
		BEGIN
			SELECT @vDataCenterId = id, @uniqueName = uniqueName
				FROM App_VMDataCenter DC
				WHERE uniqueName = @moref
				AND vCenter = @vCenterName
			IF  (@uniqueName IS null )
			BEGIN
				SELECT @vDataCenterId = id
					FROM App_VMDataCenter DC
					WHERE name = @dataCenterName
					AND vCenter = @vCenterName
			END
		END
	END
	BEGIN TRY
		BEGIN TRAN
		IF ( @vDataCenterId IS NULL )
		BEGIN
			INSERT INTO
				App_VMDataCenter (vCenter, name, vxml,uniqueName)
				values(@vCenterName
					, @dataCenterName
						, @input
						, @moref
						)
			SET @vDataCenterId = @@IDENTITY;
		END
		ELSE
		BEGIN
			IF (@uniqueName IS null AND @moref IS NOT NULL )
			BEGIN
				UPDATE App_VMDataCenter
					SET vxml = @input,
						vCenter = @vCenterName,
						uniqueName = @moref
						, timeStamp = getutcdate()
						, removalTimeStamp = null
				WHERE id = @vDataCenterId
			END
			ELSE
			BEGIN
				UPDATE App_VMDataCenter
					SET vxml = @input,
						vCenter = @vCenterName,
						name = @dataCenterName
						, timeStamp = getutcdate()
						, removalTimeStamp = null
				WHERE id = @vDataCenterId
			END
		END
		SELECT @vdmapId = vDataCenterId
			FROM App_VMDataCenterMap vdc
			WHERE vdc.instanceId = @instanceId
				AND vDataCenterId = @vDataCenterId
		IF ( @vdmapId IS NULL )
		BEGIN
			INSERT INTO App_VMDataCenterMap values
				( @instanceId , @vDataCenterId, GETUTCDATE(), NULL )
		END
		SET @o_vDataCenterId = @vDataCenterId
		DECLARE @amazonInfo XML
		IF ((SELECT @input.exist('/QSMServer_QVirtualDataCenterReq/amazonInfo')) = 1)
		BEGIN
			SET @amazonInfo = @input.query('/QSMServer_QVirtualDataCenterReq/amazonInfo')
				;WITH CTE
				AS
				(
					SELECT distinct cell.c.value('./@val', 'nvarchar(255)') AS name
					FROM  @input.nodes('/QSMServer_QVirtualDataCenterReq/amazonInfo/KeyPairs') AS cell(c)
					where len(cell.c.value('./@val','nvarchar(max)')) <=255
				)
				INSERT INTO App_VMKeyPairs
					SELECT
						@o_vDataCenterId AS srmVDataCenterId,
						CTE.name,
						NULL AS rsaPrivateKey,
						GETUTCDATE(),
						NULL,
						0
					FROM  CTE LEFT OUTER JOIN
						App_VMKeyPairs as kp ON
						CTE.name = kp.name
						AND
						@o_vDataCenterId  = kp.vDataCenterId
					WHERE kp.name IS NULL
				;WITH CTE
				AS
				(
					SELECT distinct cell.c.value('./@val', 'nvarchar(255)') AS name
					FROM  @input.nodes('/QSMServer_QVirtualDataCenterReq/amazonInfo/SecurityGroups') AS cell(c)
					where len(cell.c.value('./@val','nvarchar(max)')) <=255
				)
				INSERT INTO App_VMSecurityGroups
					SELECT
						@o_vDataCenterId AS vDataCenterId,
						CTE.name,
						GETUTCDATE(),
						NULL,
						0
					FROM
						 CTE LEFT OUTER JOIN
						App_VMSecurityGroups as sg ON
					    CTE.name= sg.name
						AND
						@o_vDataCenterId  = sg.vDataCenterId
					WHERE sg.name IS NULL
		END
		SET @o_errorString = 'Success'
		COMMIT TRAN
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		EXECUTE dbo.GetError @o_errorString OUTPUT , @o_vDataCenterId OUTPUT
		-- Rollback any active or uncommittable transactions before
		-- inserting information in the ErrorLog
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRANSACTION;
		END
	END CATCH
END
ELSE
BEGIN
	DECLARE @dataCenterRegionsXML XML = ''
	SELECT @dataCenterRegionsXML = CAST(value AS XML) from GXGlobalParam where name = 'AzureDataCenterRegionsXML'
	DECLARE @dataRegions Table (regions nvarchar(125))
	IF @instanceType = 403 -- for azure stack there can be only 'local' datacenter
		INSERT INTO @dataRegions SELECT 'local'
	ELSE
	BEGIN
		INSERT INTO @dataRegions
		SELECT d.r.value('.','nvarchar(125)') FROM @dataCenterRegionsXML.nodes('/datacenterregions/regions') d(r)
	END
	IF @vCenterName IS NULL OR @vCenterName = ''
	SET @vCenterName = (SELECT distinct name from App_Client AC INNER JOIN APP_Application AP
						ON AC.id=AP.clientId where AP.instance=@instanceId)
	SELECT @mapInstanceId = @instanceId FROM App_VMDataCenterMap where @instanceId = @instanceId
	DECLARE dataRegion cursor FOR SELECT regions FROM @dataRegions
	OPEN dataRegion
	FETCH NEXT FROM dataRegion INTO @dataCenterName
	WHILE @@FETCH_STATUS <> -1
	BEGIN
		SET @vDataCenterId = NULL
		SET @vdmapId = NULL
		-- In case of ARM, regions names have no space at all. So, to
		IF @instanceType = 402 -- ARM
			SET @dataCenterName = (SELECT REPLACE(@dataCenterName,' ', ''))
		IF ( @mapInstanceId = 0 )
		BEGIN
			SELECT @vDataCenterId = id
				FROM App_VMDataCenter DC
				WHERE name = @dataCenterName
				AND vCenter = @vCenterName
		END
		ELSE
		BEGIN
			SELECT @vDataCenterId = id
				FROM App_VMDataCenter DC
			INNER JOIN App_VMDataCenterMap DCMap
				ON DCMap.instanceId = @instanceId
				AND DC.name = @dataCenterName
				AND DC.id = DCMap.vDataCenterId
		END
		BEGIN TRY
		BEGIN TRAN
		IF ( @vDataCenterId IS NULL )
		BEGIN
			INSERT INTO
				App_VMDataCenter (vCenter, name, vxml,uniqueName)
				values(@vCenterName
						,@dataCenterName
						, @input
						, @moref
						)
			SET @vDataCenterId = @@IDENTITY;
		END
		SELECT @vdmapId = vDataCenterId
			FROM App_VMDataCenterMap vdc
			WHERE vdc.instanceId = @instanceId
				AND vDataCenterId = @vDataCenterId
		IF ( @vdmapId IS NULL )
		BEGIN
			INSERT INTO App_VMDataCenterMap values
				( @instanceId , @vDataCenterId, GETUTCDATE(), NULL )
		END
		SET @o_vDataCenterId = @vDataCenterId
		SET @o_errorString = 'Success'
		COMMIT TRAN
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			EXECUTE dbo.GetError @o_errorString OUTPUT , @o_vDataCenterId OUTPUT
			-- Rollback any active or uncommittable transactions before
			-- inserting information in the ErrorLog
			IF XACT_STATE() <> 0
			BEGIN
				ROLLBACK TRANSACTION;
			END
		END CATCH
		FETCH NEXT FROM dataRegion INTO @dataCenterName
		END
		CLOSE dataRegion
		DEALLOCATE dataRegion
END
	EXIT_PROC:
			SELECT @o_vDataCenterId AS vDataCenterId, @o_errorString AS errorString
END
GO


IF EXISTS (select * from GxQscripts where name = 'VMP_AddUpdateDataCenter')
	delete from GxQscripts where name = 'VMP_AddUpdateDataCenter'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMP_AddUpdateDataCenter')
	delete from GXDBVersions where aliasname = 'VMP_AddUpdateDataCenter'
GO

insert into GXDBVersions values(2, 'VMP_AddUpdateDataCenter',  '00010023000200060000', 'VMP_AddUpdateDataCenter', '00010023000200060000')
GO

