

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/VMBackupSizesProc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 		Cursor: "VMBackupSizesProc"			|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='VMBackupSizesProc')
BEGIN
	print '>>> Drop Stored Procedure: VMBackupSizesProc <<<'
	drop procedure VMBackupSizesProc
END
IF EXISTS (select * from GxQscripts where name='VMBackupSizesProc')
	delete from GxQscripts where name = 'VMBackupSizesProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMBackupSizesProc')
	delete from GXDBVersions where aliasname = 'VMBackupSizesProc'
GO
print '... Creating Procedure: VMBackupSizesProc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure VMBackupSizesProc
  @i_PbackupLevel NVARCHAR(32),
  @i_PsubClientName NVARCHAR(128),
  @i_PstartDate DATETIME,
  @i_PendDate DATETIME,
  @i_PincludeAgedJobs INT,
  @i_PincludeMediaDeleted INT,
  @i_PincludeSnapBkpJobs INT 
AS
  DECLARE @o_VMName NVARCHAR(255)
  DECLARE @o_BackupSetName NVARCHAR(128)
  DECLARE @o_SubClientName NVARCHAR(128)
  DECLARE @o_TotalFullJobs INT
  DECLARE @o_SizeOfVMOnHost FLOAT
  DECLARE @o_LastFullBackupTime NVARCHAR(20)
  DECLARE @o_ApplicationSize_F FLOAT(4)
  DECLARE @o_DataWritten_F FLOAT(4)
  DECLARE @o_DataXferred_F FLOAT(4)
  DECLARE @o_ImpliedCompression_F FLOAT(2)
  DECLARE @o_Deduplication_F FLOAT(2)
  DECLARE @o_TotalIncrJobs INT
  DECLARE @o_LastIncBkpTime NVARCHAR(20)
  DECLARE @o_ApplicationSize_I FLOAT(4)
  DECLARE @o_DataWritten_I FLOAT(4)
  DECLARE @o_DataXferred_I FLOAT(4)
  DECLARE @o_ImpliedCompression_I FLOAT(2)
  DECLARE @o_Deduplication_I FLOAT(2)
  DECLARE @o_GuestOS NVARCHAR(256)
  DECLARE @o_ProvisionedStorage FLOAT(4)
  DECLARE @o_DiskUtilization FLOAT(4)
  DECLARE @o_Memory FLOAT
  DECLARE @o_MemoryUtilization FLOAT(2)
  DECLARE @o_GuestCPUUsage INT
  DECLARE @o_GuestMemoryUsed FLOAT(2)
  DECLARE @o_MemoryUsedonHost FLOAT(2)
-- These lines represent the actual SQL code that will get executed.  Note
-- The "printf" style substitutions.  These should match up exactly with
 SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
DECLARE @bkpLevel      INT;
SELECT @bkpLevel =
		CASE WHEN @i_PbackupLevel Like '%FULL%'
			THEN 1
                  WHEN @i_PbackupLevel Like '%Incr%'
           THEN 2
		ELSE 0
		END
DECLARE @subClient	NVARCHAR(128)	= @i_PsubClientName;			--Assign the subclientName here, IF you want all the subclients leave it blank
DECLARE @startDateVal  datetime = @i_PstartDate;					--modify to specify startDate IN yyyy-mm-dd format, to SELECT last 30 days make it ''
DECLARE @endDateVal	datetime = @i_PendDate;					--modify to specify endDate
DECLARE @includeAgedJobs		INTEGER = @i_PincludeAgedJobs		/* 0 - Do not include aged jobs; 1 - Include aged jobs*/
DECLARE @includeMediaDeleted	INTEGER = @i_PincludeMediaDeleted	/* 0 - Do not include media deleted jobs; 1 - Include media deleted jobs*/
DECLARE @includeSnapBkpJobs		INTEGER = @i_PincludeSnapBkpJobs /* 0 - Do not include snap bkpjobs; 1 = include snap backup jobs*/
DECLARE @csName	 NVARCHAR(256) = '';
DECLARE @csTimeZone NVARCHAR(256) = '';
SELECT	@csName = aliasName, @csTimeZone = timeZone FROM APP_CommCell WHERE id = 2
SELECT	@csTimeZone = TimeZoneStdName
FROM SchedTimeZone
WHERE	TimeZoneName = SUBSTRING(@csTimeZone, CHARINDEX(':', @csTimeZone, CHARINDEX(':', @csTimeZone, 0) + 1) + 1, 255)
DECLARE @startDate INT = 0;
DECLARE @endDate INT = 0;
IF @startDateVal = '' OR @endDateVal = ''  --SET last 30 days data
BEGIN
	SET @startDateVal = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()-30), 0)
	SET @endDateVal = DATEADD(DAY, DATEDIFF(DAY, 0, GETDATE()+1), 0)
END
SET @startDate  = dbo.GetUnixTime( dbo.LocalToUTCDateTimeConversionManaged(@startDateVal, @csTimeZone))
SET @endDate  =  dbo.GetUnixTime(dbo.LocalToUTCDateTimeConversionManaged(@endDateVal, @csTimeZone))
DECLARE @tmpBkpLevelTable TABLE(jobType INTeger);
IF @bkpLevel = 1 or @bkpLevel = 0
	BEGIN
		INSERT INTO @tmpBkpLevelTable values(1);
	END
IF @bkpLevel = 2 or @bkpLevel = 0
	BEGIN
		INSERT INTO @tmpBkpLevelTable values(2);
	END
DECLARE @BkpStatsTempTable Table
(
type INT,
jobId int,
commCellId int,
appId int,
appType int,
bkpLevel int,
status int,
servStartDate int,
servEndDate int,
opType int,
totalCompBytes bigint,
totalUncompBytes bigint,
totalBackupSize bigint,
fromTime int,
toTime int,
nwTransBytes bigint,
DataWritten BIGINT
)
INSERT INTO @BkpStatsTempTable
SELECT CASE
			WHEN (jbs.bkpLevel=1 or jbs.bkpLevel =64 or jbs.bkpLevel = 128)
				then 1
			WHEN jbs.bkpLevel = 2
				then 2
				end
		,jbs.jobId, jbs.commCellId, jbs.appId, jbs.appType, jbs.bkpLevel, jbs.status, jbs.servStartDate, jbs.servEndDate, jbs.opType, jbs.totalCompBytes, jbs.totalUncompBytes, jbs.totalBackupSize, jbs.fromTime, jbs.toTime, jbs.nwTransBytes
		,cast (0 as BIGINT)
FROM CommServ.dbo.jmbkpstats as jbs
WHERE jbs.bkpLevel IN (SELECT* FROM @tmpBkpLevelTable)
	  AND jbs.appType = 106 --CV_APPTYPE_VIRTUAL_SERVER				106
	  AND jbs.status IN (1, 3, 14) --completed, CWE, CWW  jobs only
	  AND jbs.servStartDate >= @startDate
	  AND jbs.servEndDate <= @endDate
	  AND ((@includeAgedJobs = 0 AND jbs.dataStatus <> 1) OR @includeAgedJobs = 1)
	  AND ((@includeMediaDeleted = 0 AND jbs.dataStatus <> 2) OR @includeMediaDeleted = 1)
	  AND ((@includeSnapBkpJobs = 0 AND jbs.opType <> 59) OR @includeSnapBkpJobs = 1)
UPDATE  @BkpStatsTempTable
SET     DataWritten = X.sizeOnMedia
FROM    (SELECT T.jobid XJobId, T.commcellId XCommCellId, MAX(T.sizeOnMedia) AS sizeOnMedia
        FROM    (SELECT S.jobid, S.commcellId, S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
                FROM    JMJobDataStats S WITH (READUNCOMMITTED), @BkpStatsTempTable B
                WHERE   S.commcellId = B.commCellId AND S.jobid = B.jobid AND S.AuxCopyJobId = 0
                GROUP BY S.jobid, S.commcellId, S.archGrpCopyId) AS T
        GROUP BY T.jobid, T.commcellId) AS X
WHERE   jobId = X.XJobId AND commCellId = X.XCommcellId
DECLARE @vminventorydetails TABLE (
		clientId INT
		, clientName NVARCHAR(256)
		, subClientId INT
		, vsVMClientId INT
		, VMRelatedSubClientName NVARCHAR(256)
		, vsVMId INT
		, vsVMName NVARCHAR(256)
		, vsVMOptionsGuestOS NVARCHAR(256)
		, vsVMSummaryMemorySize float
		, vsVMHostName NVARCHAR(256)
		, vsVMSummaryDiskUtilization float
		, vsVMSummaryProvisionedStorage float
		, vsVMSummaryUsedStorage float
		, vsVMResourceAllocMemoryUtilization float
		, vsVMResourceAllocOverallCPUUsageMHz INT
		, vsVMResourceAllocGuestMemoryUsage float
		, vsVMResourceAllocHostMemoryUsage float)
IF DB_ID('SRM') is not null
BEGIN
	INSERT INTO @vminventorydetails
	EXEC sp_executesql N'SELECT DISTINCT
			  v600.clientId
			, v600.clientName
			, v600.subClientId
			, v601.vsVMClientId
			, v600.subClientName as VMRelatedSubClientName
			, v601.vsVMId
			, v601.vsVMName
			, v603.vsVMOptionsGuestOS
			, v603.vsVMSummaryMemorySize
			, v603.vsVMHostName
			, v603.vsVMSummaryDiskUtilization
			, v603.vsVMSummaryProvisionedStorage
			, v603.vsVMSummaryUsedStorage
			, v603.vsVMResourceAllocMemoryUtilization
			, v603.vsVMResourceAllocOverallCPUUsageMHz
			, v603.vsVMResourceAllocGuestMemoryUsage
			, v603.vsVMResourceAllocHostMemoryUsage
		FROM
			  SRM..SRMXMLRepCommServClientInfoView AS v600
			, SRM..SRMXMLRepVSEntitiesView AS v601
			, SRM..SRMXMLRepVSVirtualMachineDetailsView AS v603
		WHERE v600.appTypeGrouping = 9
			AND v601.instanceId = v600.csInstanceId
			AND v603.vsDataCenterId = v601.vsDataCenterId AND v603.vsHostId = v601.vsHostId AND v603.vsVMId = v601.vsVMId'
END
IF NOT EXISTS(SELECT * FROM @vminventorydetails)
BEGIN
INSERT INTO @vminventorydetails
SELECT
		  NULL AS clientId
		, NULL AS clientName
		, NULL AS subClientId
		, NULL AS vsVMClientId
		, NULL as VMRelatedSubClientName
		, NULL AS vsVMId
		, NULL AS vsVMName
		, NULL AS vsVMOptionsGuestOS
		, 0 AS vsVMSummaryMemorySize
		, NULL AS vsVMHostName
		, 0 AS vsVMSummaryDiskUtilization
		, 0 AS vsVMSummaryProvisionedStorage
		, 0 AS vsVMSummaryUsedStorage
		, 0 AS vsVMResourceAllocMemoryUtilization
		, 0 AS vsVMResourceAllocOverallCPUUsageMHz
		, 0 AS vsVMResourceAllocGuestMemoryUsage
		, 0 AS vsVMResourceAllocHostMemoryUsage
END
DECLARE @BkpDataTempTable TABLE(
		NAME VARCHAR(255)
		, bkpSubClientId INT
		, bType INT
		, typeCount INT
		, subClientName NVARCHAR(128)
		, backupSetName NVARCHAR(128)
		, bkpCommCellId INT
		, lastJobTime INT
		, appId INT
		, qType INT
		, qClient INT
		, qClientName NVARCHAR(255)
		, clientId INT
		, clientName NVARCHAR(256)
		, subClientId INT
		, vsVMClientId INT
		, VMRelatedSubClientName NVARCHAR(256)
		, vsVMId INT
		, vsVMName NVARCHAR(256)
		, vsVMOptionsGuestOS NVARCHAR(256)
		, vsVMSummaryMemorySize float
		, vsVMHostName NVARCHAR(256)
		, vsVMSummaryDiskUtilization float
		, vsVMSummaryProvisionedStorage float
		, vsVMSummaryUsedStorage float
		, vsVMResourceAllocMemoryUtilization float
		, vsVMResourceAllocOverallCPUUsageMHz INT
		, vsVMResourceAllocGuestMemoryUsage float
		, vsVMResourceAllocHostMemoryUsage float
)
INSERT INTO @BkpDataTempTable
SELECT *
FROM (
	SELECT *
	FROM
	(
		SELECT
			client.name
			, app.Id as bkpSubClientId
			, jbs.type AS bType
			, COUNT(jbs.type) as typeCount
			, app.subclientName
			, BS.name as backupSetName
			, jbs.commCellId bkpCommcellId
			, max(servStartDate) as lastJobTime
		FROM @BkpStatsTempTable jbs
			JOIN CommServ.dbo.APP_Application app
				ON app.id = jbs.appId
			JOIN CommServ.dbo.APP_Client as client
				ON app.clientId = client.id
			JOIN CommServ.dbo.APP_BackupSetName BS
				ON BS.id = app.backupSet
		WHERE (@subClient = '' or subclientName like @subClient)
		GROUP BY client.name, app.id, app.subclientName, jbs.type, jbs.commCellId, BS.id, BS.name
	) as BkpData
	INNER JOIN
	(
		SELECT	DISTINCT J.appId AS appID, J.type AS qType, Q.clientId AS qClient, Q.clientName AS qClientName
		FROM	@BkpStatsTempTable J
			INNER JOIN CommServ.dbo.JMQinetixUpdateStatus Q
			ON	J.jobid = Q.jobId AND J.commcellId = Q.commCellId
	) AS tempQinetix
	ON	BkpData.bkpSubClientId = tempQinetix.appID AND tempQinetix.qType = BkpData.bType
	LEFT OUTER JOIN @vmInventoryDetails vID
	ON	BkpData.bkpSubClientId = vID.subClientId
		AND vID.vsvmClientId = tempQinetix.qClient
	) as results
UPDATE @BkpDataTempTable
SET vsVMSummaryUsedStorage = 0,vsVMSummaryMemorySize = 0, vsVMSummaryProvisionedStorage=0,vsVMResourceAllocMemoryUtilization=0,vsVMResourceAllocOverallCPUUsageMHz=0,vsVMResourceAllocGuestMemoryUsage=0
WHERE vsVMSummaryUsedStorage is NULL AND vsVMResourceAllocOverallCPUUsageMHz is NULL
DECLARE @vmPropJobData TABLE
(
	jobId			INT,
	vmClientId		INT,
	appId			INT,
	type			INT,
	vmStatus		INT,
	vmUsedSpace		BIGINT,
	vmSize			BIGINT,
	vmBkpEndTime	BIGINT,
	guestOS			NVARCHAR(256)
)
insert INTO @vmPropJobData
SELECT
	vmp.jobId
	, vmp.VMclientId
	, bst.appId
	, bst.Type
	, ISNULL((SELECT (cast(attrVal as BIGINT)) FROM APP_VMProp a WHERE a.attrName = 'vmStatus' AND a.jobId = vmp.jobId AND a.vmClientId = vmp.vmClientId),-1)
	, isnull((SELECT (cast(attrVal as BIGINT)) FROM APP_VMProp a WHERE a.attrName = 'vmUsedSpace' AND a.jobId = vmp.jobId AND a.vmClientId = vmp.vmClientId),0)
	, isnull((SELECT (cast(attrVal as BIGINT)) FROM app_vmprop a WHERE a.attrName = 'vmSize' AND a.jobId = vmp.jobId AND a.vmClientId = vmp.vmClientId),0)
	, 0
	, isnull((SELECT attrVal FROM APP_ClientProp a WHERE a.attrName = 'Operating System Name' AND a.componentNameId = vmp.vmClientId AND a.modified = 0),0)
FROM APP_VMProp vmp
		JOIN @bkpStatsTempTable bSt
			ON vmp.jobId = bSt.jobId
GROUP BY vmp.jobId, vmp.VMclientId, bst.appId, bSt.type
ORDER BY VMclientId, appid
DELETE FROM @vmPropJobData WHERE vmStatus not IN (0,3)
IF EXISTS (SELECT * FROM @vmPropJobData WHERE vmUsedSpace = 0)
UPDATE @vmPropJobData
SET vmUsedSpace = D.vmUsedSpace
FROM @vmPropJobData D JOIN (SELECT MAX(jobId) JbId , appid, vmclientid FROM @vmPropJobData WHERE vmusedspace <> 0 GROUP BY appId, vmClientId ) R
ON D.appId = R.appId AND D.vmClientId = R.vmClientId
WHERE vmUsedSpace = 0 AND D.vmUsedSpace <> 0
IF EXISTS (SELECT * FROM @vmPropJobData WHERE vmUsedSpace = 0)
UPDATE @vmPropJobData
SET vmUsedSpace = cast(SRMInv.vsVMSummaryUsedStorage as BIGINT)
FROM @vmPropJobData D JOIN @BkpDataTempTable SRMInv ON D.vmClientId = SRMInv.vsVMId AND D.appId = SRMInv.subClientId
WHERE vmUsedSpace = 0 AND SRMInv.vsVMSummaryUsedStorage is not null AND SRMInv.vsVMSummaryUsedStorage <> 0
IF EXISTS (SELECT * FROM @vmPropJobData WHERE vmSize = 0)
UPDATE @vmPropJobData
SET vmSize = D.vmSize
FROM @vmPropJobData D JOIN (SELECT MAX(jobId) JbId , appid, vmclientid FROM @vmPropJobData WHERE vmSize <> 0 GROUP BY appId, vmClientId ) R
ON D.appId = R.appId AND D.vmClientId = R.vmClientId
WHERE vmSize = 0 AND D.vmSize <> 0
IF EXISTS (SELECT * FROM @vmPropJobData WHERE vmSize = 0)
UPDATE @vmPropJobData
SET vmSize = cast(SRMInv.vsVMSummaryProvisionedStorage as BIGINT)
FROM @vmPropJobData D JOIN @BkpDataTempTable SRMInv ON D.vmClientId = SRMInv.vsVMId AND D.appId = SRMInv.subClientId
WHERE vmSize = 0 AND SRMInv.vsVMSummaryProvisionedStorage is not null AND SRMInv.vsVMSummaryProvisionedStorage <> 0
DECLARE @vmPropJobDataMid TABLE
(jobId INT, vmClientId INT, appId INT, type INT, vmBkpEndTime BIGINT, vmStatus INT, DataWritten_VM FLOAT(4), DataXered_VM FLOAT(4), AppSize_VM FLOAT(4), TotalCompBytes_VM FLOAT(4), guestOS NVARCHAR(256))
insert INTO @vmPropJobDataMid
SELECT
	VPJD.jobId
	, VPJD.vmClientId
	, VPJD.appId
	, VPJD.type
	, bst.servStartDate
	, vpjd.vmStatus
	, CASE WHEN (results.vmUsedSpace_job <= 0)	then 0 ELSE (VPJD.vmUsedSpace	* ( cast (bst.dataWritten as FLOAT(4))/ results.vmUsedSpace_job)) end
	, CASE WHEN (results.vmUsedSpace_job <= 0)	then 0 ELSE (VPJD.vmUsedSpace	* ( cast (bst.nwTransBytes  as FLOAT(4)) / results.vmUsedSpace_job)) end
	, CASE WHEN (results.vmSize_job <= 0)		then 0 ELSE (VPJD.vmSize		* ( cast (bst.totalUncompBytes as FLOAT(4)) / results.vmSize_job)) end
	, CASE WHEN (results.vmUsedSpace_job <= 0)	then 0 ELSE (VPJD.vmUsedSpace	* ( CAST (bst.TotalCompBytes as FLOAT(4)) / results.vmUsedSpace_job)) end
	, VPJD.guestOS
FROM @vmPropJobData VPJD
	JOIN (SELECT jobid, appid, SUM(vmUsedSpace) vmUsedSpace_job,SUM(vmSize) vmSize_job FROM @vmPropJobData WHERE type = 1 GROUP BY jobId, appId)results
		ON VPJD.jobId = results.jobId AND VPJD. appId = results.appId
	JOIN @bkpStatsTempTable bst
		ON results.jobId = bst.jobid
WHERE VPJD.type = 1
insert INTO @vmPropJobDataMid
SELECT
	VPJD.jobId
	, VPJD.vmClientId
	, VPJD.appId
	, VPJD.type
	, bst.ServStartDate
	, vpjd.vmStatus
	, CASE WHEN (results.vmUsedSpace_job <= 0)	then 0 ELSE (VPJD.vmUsedSpace	* ( cast (bst.dataWritten as FLOAT(4))/ results.vmUsedSpace_job)) end
	, CASE WHEN (results.vmUsedSpace_job <= 0)	then 0 ELSE (VPJD.vmUsedSpace	* ( cast (bst.nwTransBytes  as FLOAT(4)) / results.vmUsedSpace_job)) end
	, CASE WHEN (results.vmSize_job <= 0)		then 0 ELSE (VPJD.vmSize		* ( cast (bst.totalUncompBytes as FLOAT(4)) / results.vmSize_job)) end
	, CASE WHEN (results.vmUsedSpace_job <= 0)	then 0 ELSE (VPJD.vmUsedSpace	* ( CAST (bst.TotalCompBytes as FLOAT(4)) / results.vmUsedSpace_job)) end
	, VPJD.guestOS
FROM @vmPropJobData VPJD
	JOIN (SELECT jobid, appid, SUM(vmUsedSpace) vmUsedSpace_job,SUM(vmSize) vmSize_job FROM @vmPropJobData WHERE type = 2 GROUP BY jobId, appId)results
		ON VPJD.jobId = results.jobId AND VPJD.appId = results.appId
	JOIN @bkpStatsTempTable bst
		ON results.jobId = bst.jobid
WHERE VPJD.type = 2
DECLARE @vmPropJobDataRes  TABLE
(vmClientId INT, applicationId INT, type INT, successCount INT, DataWritten_VM FLOAT(2), DataXered_VM FLOAT(2), AppSize_VM FLOAT(2), TotalCompBytes_VM FLOAT(2), lastJobId INT, lastBkpJobTime BIGINT, guestOS NVARCHAR(256) DEFAULT NULL )
insert INTO @vmPropJobDataRes
SELECT vmClientId
		, appId
		, type
		, 0
		, SUM(DataWritten_VM)/(1024*1024*1024)
		, SUM(DataXered_VM)/(1024*1024*1024)
		, SUM(AppSize_VM)/(1024*1024*1024)
		, SUM(TotalCompBytes_VM)/(1024*1024*1024)
		, 0
		, 0
		, 'N/A'
FROM @vmPropJobDataMid
GROUP BY vmClientId, appid, type
UPDATE @vmPropJobDataRes
SET successCount = tempR.successCount
FROM @vmPropJobDataRes Res JOIN (SELECT COUNT(*) successCount,vmClientId, appId, type FROM @vmPropJobDataMid GROUP BY vmClientId, appId,type) tempR
ON Res.applicationId = tempR.appId AND Res.vmClientId = tempR.vmClientId AND Res.type = tempR.type
UPDATE @vmPropJobDataRes SET guestOS = M.guestOS
FROM @vmPropJobDataMid M
INNER JOIN @vmPropJobDataRes TMP ON M.vmClientId = TMP.vmClientId
UPDATE @vmPropJobDataRes
SET lastJobId = tempRes.jobId
FROM @vmPropJobDataRes R JOIN ((SELECT max( jobid )jobId, vmClientId, appId, type FROM @vmPropJobDataMid M GROUP BY vmClientId, appId, type))tempRes ON R.applicationId = tempRes.appId AND R.vmClientId = tempRes.vmClientId AND R.type = tempRes.type
UPDATE @vmPropJobDataRes
SET lastBkpJobTime = M.vmBkpEndTime
FROM @vmPropJobDataRes R JOIN @vmPropJobDataMid M ON R.lastJobId = M.jobId AND M.vmClientId = R.vmClientId AND M.appId = R.applicationId
DECLARE @tempSizeOfVM TABLE (jobId INT, vmClientId INT, appId INT, SizeOfVMOnHost FLOAT(4), provisionedStorage FLOAT(4), disKUtilization FLOAT(4));
INSERT INTO @tempSizeOfVM
SELECT MAX(BS.jobId), VP.VMclientId, RES.applicationId,0,0,0
FROM JMBkpStats BS
	JOIN APP_VMProp VP
		ON BS.jobId = VP.jobId
	JOIN @vmPropJobDataRes RES
		ON VP.VMclientId = RES.vmClientId
			AND BS.appId = RES.applicationId
	WHERE BS.bkpLevel IN (1, 64, 128) AND BS.status IN (1, 3, 14) GROUP BY vp.VMclientId, RES.applicationId
UPDATE @tempSizeOfVM
SET SizeOfVMOnHost = (cast(P.attrVal as FLOAT(4)) / 1024 / 1024 / 1024)
FROM @tempSizeOfVM T JOIN APP_VMProp P ON T.jobId = P.jobId AND T.vmClientId = P.VMclientId
WHERE P.attrName = 'vmUsedSpace' AND (CAST (P.attrVal as BIGINT) ) <> 0
IF EXISTS (SELECT *FROM @tempSizeOfVM WHERE SizeOfVMOnHost = 0)
UPDATE @tempSizeOfVM
SET SizeOfVMOnHost = cast(SRMInv.vsVMSummaryUsedStorage as FLOAT(4))/1024/1024/1024
FROM @tempSizeOfVM T JOIN @BkpDataTempTable SRMInv ON T.appId = SRMInv.subClientId AND T.vmClientId = SRMInv.vsvmid
WHERE SizeOfVMOnHost = 0 AND SRMInv.vsVMSummaryUsedStorage <> 0 AND SRMInv.vsVMSummaryUsedStorage is not null
UPDATE @tempSizeOfVM
SET provisionedStorage = (cast(P.attrVal as FLOAT(4)) / 1024 / 1024 / 1024)
FROM @tempSizeOfVM T JOIN APP_VMProp P ON T.jobId = P.jobId AND T.vmClientId = P.VMclientId
WHERE P.attrName = 'vmSize' AND (CAST (P.attrVal as BIGINT) ) <> 0
IF EXISTS (SELECT *FROM @tempSizeOfVM WHERE provisionedStorage = 0)
UPDATE @tempSizeOfVM
SET provisionedStorage = cast(SRMInv.vsVMSummaryProvisionedStorage as FLOAT(4))/1024/1024/1024
FROM @tempSizeOfVM T JOIN @BkpDataTempTable SRMInv ON T.appId = SRMInv.subClientId AND T.vmClientId = SRMInv.vsVMId
WHERE provisionedStorage = 0 AND SRMInv.vsVMSummaryProvisionedStorage <> 0 AND SRMInv.vsVMSummaryProvisionedStorage is not null
UPDATE @tempSizeOfVM
SET disKUtilization = CASE WHEN provisionedStorage = 0 then 0 ELSE (SizeOfVMOnHost / provisionedStorage) * 100 end
SELECT
		ISNULL(X.qClientName,I.qClientName) as VMName
		, ISNULL(X.backupSetName, ISNULL(I.backupSetName,'N/A')) as BackupSetName
		, ISNULL(X.subclientName, ISNULL(I.subclientName,'N/A')) as SubClientName
		, ISNULL(X.successcount, 0) as TotalFullJobs
		, ISNULL((SELECT T.SizeOfVMOnHost FROM @tempSizeOfVM T WHERE T.appId = ISNULL(X.applicationId,I.applicationId) AND T.vmClientId = ISNULL(X.vmClientId,I.vmClientId)),0) as SizeOfVMOnHost
		, CASE WHEN X.lastBkpJobTime IS NULL THEN 'N/A' ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(X.lastBkpJobTime), @csTimeZone) END  as LastFullBackupTime
		, ISNULL(X.AppSize_VM,0) as ApplicationSize_F
		, ISNULL(X.DataWritten_VM,0) as DataWritten_F
		, ISNULL(X.DataXered_VM,0) as DataXferred_F
		, cast(ISNULL((CASE WHEN ((X.AppSize_VM - X.TotalCompBytes_VM)<0 OR (X.AppSize_VM =0))  then 0 ELSE ((X.AppSize_VM - X.TotalCompBytes_VM)/cast(X.AppSize_VM as FLOAT(2)))*100 end),0) as FLOAT(2))  as ImpliedCompression_F
		, cast(ISNULL((CASE WHEN ((X.AppSize_VM - X.DataWritten_VM)<0 OR (X.AppSize_VM =0) ) then 0 ELSE ((X.AppSize_VM - X.DataWritten_VM)/cast(X.AppSize_VM as FLOAT(4)))*100 end),0) as FLOAT(2))  as Deduplication_F
		, ISNULL(I.successCount,0) as TotalIncrJobs
		, CASE WHEN I.lastBkpJobTime IS NULL THEN 'N/A' ELSE dbo.UTCToLocalStringTime(dbo.GetDateTime(I.lastBkpJobTime), @csTimeZone) END  as LastIncBkpTime
		, ISNULL(I.AppSize_VM,0) as ApplicationSize_I
		, ISNULL(I.DataWritten_VM,0) as DataWritten_I
		, ISNULL(I.DataXered_VM,0) as DataXferred_I
		, cast(ISNULL((CASE WHEN ((I.AppSize_VM - I.TotalCompBytes_VM)<=0 OR (I.AppSize_VM =0))  then 0 ELSE ((I.AppSize_VM - I.TotalCompBytes_VM)/cast(I.AppSize_VM as FLOAT(2)))*100 end),0)as FLOAT(2))  as ImpliedCompression_I
		, cast(ISNULL((CASE WHEN ((I.AppSize_VM - I.DataWritten_VM)<0 OR (I.AppSize_VM =0) )	then 0 ELSE ((I.AppSize_VM - I.DataWritten_VM)/cast(I.AppSize_VM as FLOAT(4)))*100 end),0) as FLOAT(2)) as Deduplication_I
		, ISNULL(X.guestOS, ISNULL(I.guestOS,'N/A')) as GuestOS
		, ISNULL((SELECT T.provisionedStorage FROM @tempSizeOfVM T WHERE T.appId = ISNULL(X.applicationId,I.applicationId) AND T.vmClientId = ISNULL(X.vmClientId,I.vmClientId)),0) as ProvisionedStorage
		, ISNULL((SELECT T.disKUtilization FROM @tempSizeOfVM T WHERE T.appId = ISNULL(X.applicationId,I.applicationId) AND T.vmClientId = ISNULL(X.vmClientId,I.vmClientId)),0) as DiskUtilization
		, cast(cast(ISNULL(X.vsVMSummaryMemorySize,ISNULL(I.vsVMSummaryMemorySize,0)) as float)/(1024 * 1024 * 1024) as FLOAT(2)) as Memory
		, cast(cast(ISNULL(X.vsVMResourceAllocMemoryUtilization,ISNULL(I.vsVMResourceAllocMemoryUtilization,0))AS float)/(1024.0) as FLOAT(2)) as MemoryUtilization
		, ISNULL(X.vsVMResourceAllocOverallCPUUsageMHz,ISNULL(I.vsVMResourceAllocOverallCPUUsageMHz,0)) as GuestCPUUsage
		, cast(cast(ISNULL(X.vsVMResourceAllocGuestMemoryUsage,ISNULL(I.vsVMResourceAllocGuestMemoryUsage,0)) as float)/(1024 * 1024 * 1024) as FLOAT(2)) as GuestMemoryUsed
		, CAST( cast(ISNULL(X.vsVMResourceAllocHostMemoryUsage,ISNULL(I.vsVMResourceAllocHostMemoryUsage,0)) as float)/(1024 * 1024 * 1024) as FLOAT(2)) as MemoryUsedonHost
FROM (SELECT * FROM @BkpDataTempTable B JOIN @vmPropJobDataRes R ON B.qclient = R.vmClientId AND b.bkpsubclientid = R.applicationId WHERE bType=1 AND R.type = 1) X full outer JOIN (SELECT * FROM @BkpDataTempTable B JOIN @vmPropJobDataRes R ON B.qclient = R.vmClientId AND b.bkpsubclientid = R.applicationId WHERE bType=2 AND R.type =2) I ON X.qClient = I.qClient And X.applicationId = I.applicationId
ORDER BY VMName, X.bkpSubClientId, X.bType
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'VMBackupSizesProc')
	delete from GxQscripts where name = 'VMBackupSizesProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='VMBackupSizesProc')
	delete from GXDBVersions where aliasname = 'VMBackupSizesProc'
GO

insert into GXDBVersions values(2, 'VMBackupSizesProc',  '00000000000000000000', 'VMBackupSizesProc', '00000000000000000000')
GO

