

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateVersionStringProp.sp] ---------- 

--  +========================================================================+
--  | Stored Proc:  UpdateVersionStringProp
--  | SP to update the product version string and version tab string
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='UpdateVersionStringProp')
BEGIN
	print '>>> Drop Stored Procedure: UpdateVersionStringProp <<<'
	drop procedure UpdateVersionStringProp
END
IF EXISTS (select * from GxQscripts where name='UpdateVersionStringProp')
	delete from GxQscripts where name = 'UpdateVersionStringProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateVersionStringProp')
	delete from GXDBVersions where aliasname = 'UpdateVersionStringProp'
GO
print '... Creating Procedure: UpdateVersionStringProp'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure UpdateVersionStringProp
  @inClientID INTEGER
AS
  DECLARE @rcount integer
SET @rcount=0
SET NOCOUNT ON
BEGIN TRY
DECLARE @errorCode		INT		= 0
DECLARE @nowTime		INT		= dbo.GetUnixTime (GetUTCdate())
DECLARE @ProdVerAttrName	nvarchar(64)	= 'SP Version Info'
DECLARE @SPAttrName		nvarchar(64)	= 'SP Version and Patch Info'
IF object_id('tempdb.dbo.#clientList') IS NOT null  DROP TABLE #clientList
      create table #clientList (t_clid INT, t_bVM INT, PRIMARY KEY(t_clid, t_bVM))
IF (@inClientID = 0)
BEGIN
	INSERT INTO #clientList
	SELECT DISTINCT  clientId, 0
	FROM    simInstalledPackages (NOLOCK)
	WHERE @inClientID = 0	-- forces the QA to determine that the NCI scan is better vs CI scan if no conditionals
END
ELSE
BEGIN
	INSERT INTO #clientList
	SELECT  clientId, 0
	FROM    simInstalledPackages (NOLOCK)
	WHERE  clientId = @inClientID
	UNION
	SELECT  clientId, 0
	FROM    simInstalledPackages (NOLOCK)
	WHERE   clientId <> @inClientID AND clientId IN (SELECT DISTINCT PMClientId FROM APP_VMToPMMap (NOLOCK) WHERE VMClientId = @inClientId)
END
IF (@@ROWCOUNT = 0)
BEGIN
	--PRINT 'no rows found, nothing to do'
	GOTO END_OF_PROC
END
INSERT INTO #clientList
SELECT	DISTINCT clientId, 1
FROM	APP_VMToPMMap (NOLOCK) V JOIN simInstalledPackages (NOLOCK) P ON V.VMClientID = P.clientID
WHERE	V.PMClientID IN (SELECT t_clid FROM #clientList)
--This table holds the unique combinations of <package, highestsp, spminorversion, additionalpatches> found in siminstalledpackages table.
--For each row productversion (Ex: SP10+) and servicepack (Servicepack:10,Additional Updates: ,1234,5678) will be updated for each row later during computation
IF object_id('tempdb.dbo.#tempClientPackageList') IS NOT null  DROP TABLE #tempClientPackageList
      create table #tempClientPackageList
      (     [id] [int] IDENTITY(1,1) NOT NULL,
              [Clientid] [int] NOT NULL,
              [simPackageID] [int] NOT NULL,
              [HighestSP] [int] NOT NULL,
              [AdditionalPatches] [nvarchar](max),
              [MissingPatches] [nvarchar](max),
              [SpMinorVersion] [int] NOT NULL,
              [SPVersionID] [int] NOT NULL,
              [UPNumber] [int] NULL,
              [ProductVersion] [nvarchar](max) NULL,
              [ServicePack] [nvarchar](max) NULL
      )
--This table contains, groupdid (from above table) and list of additional patches (after splitting with ,. Each row will have groupid, patchname and completename (combination of alias name and patchid)
IF object_id('tempdb.dbo.#tempPatchesInfo') IS NOT null  DROP TABLE #tempPatchesInfo
      create table #tempPatchesInfo
      (       [cid] [int] NOT NULL,
              [pIdStr] [nvarchar](max) NULL
      )
--Maintains output clientid, productversion and Servicepack
-- productversion  is nothing but SP Version Info
-- Servicepack is nothing but SP Version and Patch Info
IF object_id('tempdb.dbo.#tempClientSummary') IS NOT null  DROP TABLE #tempClientSummary
create table #tempClientSummary
(	[t_Clientid]		[int],
	[t_VMClientid]		[int],
	[releaseid]		[int],
	[spMajor]		[int],
	[spMinor]		[int],
	[SPVersionID]	[int],
	[TransactionID] [int],
	[UPNumber]		[int],
	[UPFriendlyName] [nvarchar](max),
[ClientName]		[nvarchar](255),
	[missingPkg]		[nvarchar](max),
	[additionalPatches]	[nvarchar](max),
	[missingPatches]	[nvarchar](max),
	[ProductVersion]	[nvarchar](max),
	[Servicepack]		[nvarchar](max)
)
IF object_id('tempdb.dbo.#PropToUpdate') IS NOT null  DROP TABLE #PropToUpdate
create table #PropToUpdate
(   [id]			int,
    [attVal]		nvarchar(MAX)
)
--Add Index
CREATE CLUSTERED INDEX IDX_tempClientPackage_ID ON #tempClientPackageList(Clientid)
CREATE CLUSTERED INDEX IDX_tempClientSummary_Clientid ON #tempClientSummary(t_Clientid)
CREATE INDEX IDX_tempClientSummary_Clientid2 ON #tempClientSummary(t_VMClientid)
CREATE CLUSTERED INDEX IDX_tempClientPackage_ID ON #tempPatchesInfo(Cid)
--Get a list of clients with packages
INSERT INTO #tempClientPackageList
SELECT	clientId, simPackageID, HighestSP, CAST(AdditionalPatches as Nvarchar(max)), CAST(MissingPatches as Nvarchar(max)), SpMinorVersion , SPVersionID, UPNumber,
	CASE	WHEN HighestSP > 0 THEN ( 'SP' + cast(HighestSP as varchar) + (case SpMinorVersion when 0 then '' else CHAR(SpMinorVersion+96) end) )
		ELSE ''	END,
	CASE	WHEN HighestSP > 0 THEN ('ServicePack:'+ cast(HighestSP as varchar) + (case SpMinorVersion when 0 then '' else CHAR(SpMinorVersion+96) end) )
		ELSE ''	END
FROM	simInstalledPackages WITH (NOLOCK) JOIN #clientList ON clientID = t_clid
ORDER BY HighestSP DESC, SpMinorVersion DESC
--Update client list
INSERT INTO #tempClientSummary
SELECT	DISTINCT c.id, ISNULL((SELECT TOP 1 VMClientid FROM APP_VMToPMMap (NOLOCK) WHERE PMClientId = c.id), 0),	-- LEFT OUTER JOIN c.id maps to 0 or VMClientIds
	c.releaseId, 0, 0, 0, 0, 0, '', c.name, '', '', '', '', ''
FROM	APP_Client c WITH (NOLOCK) JOIN #clientList cl ON c.id = cl.t_clid AND cl.t_bVM = 0
-- Parse all the clients having at least one entry in the siminstalledpackages table
-- Foreach client, get the group id by mapping it with tempUniqPackageSummary
--  get the grouplist = comma separated list of groups for this client
--  Check if this grouplist is already processed using tempGroupListOutput table. If yes, update the productversion and servicepack directly. If no, we need to compute details using following algorithm.
-- a. get the highest sp for all the packages of the current client. This becomes the product version and servicepack for update information.
-- b. Check if all the packages have this servicepack. If no, then there is at least one package for which servicepack is missing. Get the list of packages for which this servicepack is missing.
-- c. Get the list of unique additional patches. Compute the list
-- d. if missing servicepack, then productversion becomes - Ex: SP10-. Else, if additional patches are present, productversion will be + Ex: Sp10+
-- e. Append the list of additional updates to the Servicepack field.
UPDATE #tempClientSummary
SET	spMajor = P.HighestSP, spMinor = P.SpMinorVersion, ProductVersion = P.ProductVersion, Servicepack = P.ServicePack, UPNumber = P.UPNumber, SPVersionID = P.SPVersionID
FROM	#tempClientPackageList P, (	SELECT clID=P.Clientid, mid=MIN(id) FROM #tempClientPackageList P, #tempClientSummary C
					WHERE	P.clientID IN (C.t_clientID, C.t_VMClientid) GROUP BY P.Clientid) T
WHERE	t_Clientid = T.clID AND T.mid = P.id
UPDATE #tempClientSummary SET ProductVersion = ProductVersion + '.' + CAST(UPNumber as varchar(32)), Servicepack = Servicepack + '.' + CAST(UPNumber as varchar(32)) WHERE UPNumber > 0
UPDATE #tempClientSummary
SET missingPkg = ISNULL((SELECT stuff((SELECT ',' + Name FROM
			(	SELECT	name FROM SimPackage (NOLOCK)
				WHERE	ID in (	SELECT	P.simPackageID FROM #tempClientPackageList P
						WHERE	Clientid IN (t_clientID, t_VMClientid) AND (P.HighestSP <> spMajor OR P.SpMinorVersion <> spMinor))	) T
			 FOR xml path('')),1,1,'') ), '')
UPDATE #tempClientSummary
SET	Servicepack = Servicepack + ',Missing Packages:,'+ missingPkg
WHERE	LEN(missingPkg) > 0
--Split the additionalpatches column from #tempUniqPackageSummary.
INSERT INTO #tempPatchesInfo
SELECT T.Clientid, TEMP.data
FROM	#tempClientPackageList T CROSS APPLY dbo.SplitString(T.additionalPatches, ',') TEMP
WHERE additionalPatches not like 'None'
UPDATE #tempClientSummary
SET additionalPatches = ISNULL((SELECT stuff((SELECT ',' + Name FROM
			(	SELECT DISTINCT name=pIdStr FROM #tempPatchesInfo WHERE Cid IN (t_clientID, t_VMClientid) ) T
			 FOR xml path('')),1,1,'') ), '')
-- add CU pack details
UPDATE TCS SET TCS.TransactionID = P.TransactionID
              from #tempClientSummary TCS inner join PatchSPVersion P WITH(NOLOCK) on TCS.SPVersionID = P.id
UPDATE TCS SET TCS.UPFriendlyName = U.FriendlyName
from #tempClientSummary TCS inner join  PatchSPVersion P WITH(NOLOCK) on (P.TransactionID  = TCS.TransactionID  and P.spMajor = TCS.spMajor and  P.spMinor = TCS.spMinor)
                                                inner join  PatchUPVersion U WITH(NOLOCK) on U.UPNumber = TCS.UPNumber and U.SPVersionID = P.id
where TCS.UPNumber > 0
UPDATE #tempClientSummary
SET	Servicepack = Servicepack + ',Additional Updates:,'+ additionalPatches
WHERE	LEN(additionalPatches) > 0
--truncate it to 1000 characters as App_ClientProp attrVal limit is 1024 characters
UPDATE #tempClientSummary
SET	Servicepack = substring(Servicepack,1,(1000-(CHARINDEX(',',REVERSE(substring(Servicepack,1,1000)))))+1)+'...'
WHERE	LEN(Servicepack) > 1000
--prepend the release number to product version
UPDATE #tempClientSummary
SET	ProductVersion = (case CHARINDEX('.',sim.release,0) when 0 then sim.release else substring(sim.release,1,CHARINDEX('.',sim.release,0) -1) end) +' ' + ProductVersion
FROM	simAllGalaxyRel sim WITH (NOLOCK)
WHERE	sim.id =releaseid
--Do the below if update string is calculated for all the clients or for the CS
--append the servicePack string of all the virtual and physical nodes and save it for the virtual cs node incase of virtual CS
IF EXISTS (SELECT id FROM APP_ClientProp (NOLOCK) JOIN #tempClientSummary ON t_clientid = 2 AND t_clientid = componentNameId AND attrName = 'Virtual Client' AND attrVal = '1' AND modified = 0)
BEGIN
	update #tempClientSummary
	SET ServicePack=(	select 'Node:'+ClientName+','+ServicePack+','
				from #tempClientSummary
				where t_ClientId=2 or t_ClientId in (select distinct PMClientId from APP_VMToPMMap WITH (NOLOCK) where VMClientId=2) for xml path('')	)
	WHERE	t_ClientId=2
	--truncate it to 1000 characters
	UPDATE	#tempClientSummary
	SET ServicePack=substring(ServicePack,1,(1000-(CHARINDEX(',',REVERSE(substring(ServicePack,1,1000)))))+1)+'...'
	Where t_ClientId=2  and LEN(ServicePack) > 1000
END
    --update the property table
	-- Only update the table if there is a value change, avoid unnecessary CCSDb Updates and database transaction log activity!
	INSERT INTO #PropToUpdate
		   SELECT
				  CP.id,
				  (CASE CP.attrname
						 WHEN @ProdVerAttrName THEN T.ProductVersion
						 ELSE T.Servicepack
				  END)
		   FROM APP_ClientProp CP WITH(NOLOCK)
				  INNER JOIN #tempClientSummary T ON
						 CP.componentNameId = T.t_ClientId
						 AND CP.attrname IN (@ProdVerAttrName, @SPAttrName)
		   WHERE
				  CP.attrVal <> (CASE CP.attrname
													WHEN @ProdVerAttrName THEN T.ProductVersion
													ELSE T.Servicepack
											 END)
	UPDATE CP
		   SET attrVal = p.attVal,
				  modified = 0
	FROM #PropToUpdate P
		   INNER JOIN APP_ClientProp CP ON
				  CP.id = P.id
	-- Only do 1 insert operation for missing rows
	INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified)
		SELECT DISTINCT
			T.t_ClientId,
			@ProdVerAttrName,
			1,
			T.ProductVersion,
			@nowTime,
			0
		FROM #tempClientSummary T WITH (NOLOCK)
		WHERE
			NOT EXISTS (
				SELECT
					id
				FROM APP_ClientProp CP WITH (NOLOCK)
				WHERE
					CP.componentNameId = T.t_ClientId
					AND CP.attrname = @ProdVerAttrName
			)
		UNION ALL
		SELECT DISTINCT
			T.t_ClientId,
			@SPAttrName,
			1,
			T.Servicepack,
			@nowTime,
			0
		FROM #tempClientSummary T WITH (NOLOCK)
		WHERE
			NOT EXISTS (
				SELECT
					id
				FROM APP_ClientProp CP WITH (NOLOCK)
				WHERE
					CP.componentNameId = T.t_ClientId
					AND CP.attrname = @SPAttrName
			)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @errorCode	= ERROR_NUMBER()
END CATCH
IF object_id('tempdb.dbo.#tempClientSummary') IS NOT null DROP TABLE #tempClientSummary
IF object_id('tempdb.dbo.#tempClientPackageList') IS NOT null DROP TABLE #tempClientPackageList
IF object_id('tempdb.dbo.#tempPatchesInfo') IS NOT null  DROP TABLE #tempPatchesInfo
END_OF_PROC:
IF @errorCode != 0
	SET @rcount = -1
SELECT @rcount
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateVersionStringProp')
	delete from GxQscripts where name = 'UpdateVersionStringProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateVersionStringProp')
	delete from GXDBVersions where aliasname = 'UpdateVersionStringProp'
GO

insert into GXDBVersions values(2, 'UpdateVersionStringProp',  '00000000000000000000', 'UpdateVersionStringProp', '00000000000000000000')
GO

