

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateUserPropForQuota.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Bhukar
--	Date:   11/14/2017
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UpdateUserPropForQuota.sp,v $ $Id: UpdateUserPropForQuota.sp,v 1.1.2.6 2020/11/20 23:58:58 sbhukar Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='UpdateUserPropForQuota')
BEGIN
	print '>>> Drop Stored Procedure: UpdateUserPropForQuota <<<'
	drop procedure UpdateUserPropForQuota
END
IF EXISTS (select * from GxQscripts where name='UpdateUserPropForQuota')
	delete from GxQscripts where name = 'UpdateUserPropForQuota'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateUserPropForQuota')
	delete from GXDBVersions where aliasname = 'UpdateUserPropForQuota'
GO
print '... Creating Procedure: UpdateUserPropForQuota'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure UpdateUserPropForQuota
  @inputXML XML,
  @recomputeQuota INT = 0 
-- inputXML will be in following format
--'<UserList>
--  <userID id="1" />
--  <userID id="2" />
--</UserList>'
AS
DECLARE @startTime INT = dbo.GetUnixTime(GetUTCDate())
IF object_id('tempdb.dbo.#userlist') IS NOT NULL DROP TABLE #userlist
CREATE TABLE #userlist(t_uid INT)
IF @recomputeQuota = 0
	INSERT INTO #userlist
	SELECT U.id
	FROM UMUsers U WITH(NOLOCK) CROSS APPLY
	@inputXML.nodes (N'UserList/userID') AS T(N)
WHERE U.id = N.value(N'@id', N'INT') AND U.flags & 0x001 <> 0 AND U.flags & 0x004 = 0 AND U.enabled <> 0 AND U.id > 0
	;
ELSE
BEGIN
	DECLARE @distributionFactor INT = 7
	DECLARE @currentDay INT = (SELECT DAY(GETDATE()))%@distributionFactor
	INSERT INTO #userlist
	SELECT U.id
	FROM UMUsers U WITH(NOLOCK)
WHERE U.flags & 0x001 <> 0 AND U.flags & 0x004 = 0 AND U.enabled <> 0 AND U.id > 0 AND U.id%@distributionFactor=@currentDay
	;
END
UPDATE UP SET UP.attrVal = '1', UP.modified = @startTime
FROM UMUsersProp UP
JOIN #userList tmp
ON UP.componentNameId = tmp.t_uid AND attrName = 'ReComputeQuota' AND cs_attrName = CHECKSUM(N'ReComputeQuota')
INSERT INTO UMUsersProp
SELECT t_uid, 'ReComputeQuota', 7, '1', @startTime, @startTime
FROM #userList tmp WHERE NOT EXISTS(SELECT 1 FROM UMUsersProp UP WHERE UP.componentNameId = tmp.t_uid
AND attrName = 'ReComputeQuota' AND cs_attrName = CHECKSUM(N'ReComputeQuota'))
IF EXISTS(SELECT * FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'ReComputeQuota' AND value = 0)
UPDATE GXGlobalParam SET value = 1 WHERE name = 'ReComputeQuota'
ELSE IF NOT EXISTS(SELECT * FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'ReComputeQuota')
INSERT INTO GxGlobalParam VALUES ('ReComputeQuota', 1, @startTime, 0)
IF object_id('tempdb.dbo.#userlist') IS NOT NULL DROP TABLE #userlist
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'UpdateUserPropForQuota')
	delete from GxQscripts where name = 'UpdateUserPropForQuota'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateUserPropForQuota')
	delete from GXDBVersions where aliasname = 'UpdateUserPropForQuota'
GO

insert into GXDBVersions values(2, 'UpdateUserPropForQuota',  '00010001000200060000', 'UpdateUserPropForQuota', '00010001000200060000')
GO

