

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateTopology.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author:
--	Date:
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UpdateTopology.sp,v $ $Id: UpdateTopology.sp,v 1.1.2.23.16.1 2021/01/15 23:39:05 ybaheti Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='updateTopology')
BEGIN
	print '>>> Drop Stored Procedure: updateTopology <<<'
	drop procedure updateTopology
END
IF EXISTS (select * from GxQscripts where name='updateTopology')
	delete from GxQscripts where name = 'updateTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='updateTopology')
	delete from GXDBVersions where aliasname = 'updateTopology'
GO
print '... Creating Procedure: updateTopology'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure updateTopology
  @topologyId int,
  @oldTopologies NWTopoGroupInfoTableType READONLY,
  @newTopologies NWTopoGroupInfoTableType READONLY,
  @oldTopologyType int,
  @newTopologyType int, 
  @oldWildCardOption int,
  @newWildCardOption int,
  @oldExtendedOptions xml,
  @newExtendedOptions xml
AS
DECLARE @oldExternal	int = 0
DECLARE @newExternal	int = 0
DECLARE @oldInternal	int = 0
DECLARE @newInternal	int = 0
DECLARE	@oldProxied		int = 0
DECLARE @newProxied		int = 0
DECLARE @oldPerimeterProxy int = 0
DECLARE @newPerimeterProxy int = 0
DECLARE @fwOutGoingRouteOptions xml
DECLARE @topoFirewall TABLE
(
	clientGroupId INT,
	forClientGroupId INT,
	restrictionType INT
)
DECLARE @topoOutGoingRoutes TABLE
(
	clientGroupId INT,
	forClientGroupId INT,
	proxyClientGroupId INT,
	routeOptions XML
)
DECLARE @forceAllBackupRestoreDataTraffic INT = 1
DECLARE @forceThroughTunnel INT = 0
DECLARE @gatewayHostname varchar(256) = ''
DECLARE @routeType INT = 2
DECLARE @clientGroupName varchar(256) = ''
DECLARE @clientGroupId	INT = 0
DECLARE @clientName varchar(256) = ''
DECLARE @clientId INT = 0
DECLARE @defaultOutgoingProtocol INT = 2
DECLARE @isOldTopoSmart INT = 0
DECLARE @isNewTopoSmart INT = 0
DECLARE @directRouteDefaultOptions XML
DECLARE @flagIndicatingConfigLevel INT = 0
DECLARE @flagIndicatingConfigLevelForOptions INT = 0
DECLARE @oldEncryptTraffic int = ISNULL(@oldExtendedOptions.value('/App_TopologyExtendedProperties[1]/@encryptTraffic', 'int'), 0)
DECLARE @newEncryptTraffic int = ISNULL(@newExtendedOptions.value('/App_TopologyExtendedProperties[1]/@encryptTraffic', 'int'), 0)
DECLARE @numberOfStreams INT = ISNULL(@newExtendedOptions.value('/App_TopologyExtendedProperties[1]/@numberOfStreams', 'int'), 1)
DECLARE @connectionProtocol INT = ISNULL(@newExtendedOptions.value('/App_TopologyExtendedProperties[1]/@connectionProtocol', 'int'), 2)
DECLARE @configureAutomaticallyDefault INT = 1
DECLARE @configureAutomatically INT = @configureAutomaticallyDefault
DECLARE @defaultTunnelConnectionPort INT = 8403
DECLARE @defaultKeepAliveSeconds INT = 180
DECLARE @tunnelConnectionPort INT = @defaultTunnelConnectionPort
DECLARE @keepAliveSeconds INT = @defaultKeepAliveSeconds
DECLARE @firewallExtendedProperties xml = (SELECT @defaultOutgoingProtocol as '@defaultOutgoingProtocol' ,@configureAutomatically as '@configureAutomatically' FOR XML PATH('App_FirewallExtendedProperties'))
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	-- Consolidate all client group options
	-- Note : Topology can be created from multiple end points : Commcell console, Command center, qsdk.
	-- All properties might not be set from all ends. So when a topology has to be updated, if the given xml does not contain required options, use the existing DB values
	DECLARE @fwGroupOptions TABLE (clientGroupId INTEGER, configureAutomatically INTEGER, tunnelconnectionPort INTEGER, keepAliveSeconds INTEGER, useWildcardProxy INTEGER)
	INSERT INTO @fwGroupOptions (clientGroupId
				, configureAutomatically
				, tunnelconnectionPort
				, keepAliveSeconds
				, useWildcardProxy)
	SELECT FO.clientGroupId
			, ISNULL(ExProps.col.value('@configureAutomatically', 'INTEGER'), 1)
			, FO.tunnelconnectionPort
			, FO.keepAliveSeconds
			, ISNULL(ExProps.col.value('@useWildCardProxy', 'INTEGER'), 0)
	FROM APP_FirewallTopologyAssoc FTA WITH(NOLOCK)
	INNER JOIN App_FirewallOptions FO
	ON FTA.groupId=FO.clientGroupId
	CROSS APPLY FO.extendedProperties.nodes('App_FirewallExtendedProperties') ExProps(col)
	WHERE FTA.topologyId = @topologyId
	DECLARE @fwGroupOptionsInputXML TABLE (clientGroupId INTEGER, configureAutomatically INTEGER, tunnelconnectionPort INTEGER, keepAliveSeconds INTEGER, useWildcardProxy INTEGER)
	INSERT INTO @fwGroupOptionsInputXML (clientGroupId
				, configureAutomatically
				, tunnelconnectionPort
				, keepAliveSeconds
				, useWildcardProxy)
	SELECT FG.clientGroupId
			, ISNULL(FO.col.value('@configureAutomatically', 'INTEGER'), 1)
			, ISNULL(FO.col.value('@tunnelConnectionPort', 'INTEGER'), @defaultTunnelConnectionPort)
			, ISNULL(FO.col.value('@keepAliveSeconds', 'INTEGER'), @defaultKeepAliveSeconds)
			, ISNULL(FO.col.value('@useWildcardProxy', 'INTEGER'), 0)
	FROM @newTopologies FG
	CROSS APPLY FG.fwConfig.nodes('options') FO(col)
	-- Update existing options to new ones
	UPDATE FO
	SET   FO.configureAutomatically = IX.configureAutomatically
		, FO.tunnelconnectionPort = IX.tunnelconnectionPort
		, FO.keepAliveSeconds = IX.keepAliveSeconds
		, FO.useWildcardProxy = IX.useWildcardProxy
	FROM @fwGroupOptions FO
	INNER JOIN @fwGroupOptionsInputXML IX
	ON FO.clientGroupId=IX.clientGroupId
	-- Consider new groups added
	INSERT INTO @fwGroupOptions (clientGroupId, configureAutomatically, tunnelconnectionPort, keepAliveSeconds, useWildcardProxy)
	SELECT IX.clientGroupId, IX.configureAutomatically, IX.tunnelconnectionPort, IX.keepAliveSeconds, IX.useWildcardProxy
	FROM @fwGroupOptionsInputXML IX
	LEFT OUTER JOIN @fwGroupOptions FO
	ON IX.clientGroupId = FO.clientGroupId
	WHERE FO.clientGroupId IS NULL
	IF @newEncryptTraffic = 1
		BEGIN
SET @connectionProtocol = 1
			SET @forceThroughTunnel = 1
			SET @defaultOutgoingProtocol = 1
		END
	SET @firewallExtendedProperties = (SELECT @defaultOutgoingProtocol as '@defaultOutgoingProtocol' ,@configureAutomatically as '@configureAutomatically' FOR XML PATH('App_FirewallExtendedProperties'))
	SET @directRouteDefaultOptions = (SELECT @connectionProtocol AS '@connectionProtocol',@forceThroughTunnel AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',0 /* DIRECT */ AS '@routeType',1 AS '@numberOfStreams' FOR XML PATH('App_FireWallOutGoingRouteOptions'))
	SELECT
       @oldInternal = CASE t.fwGroupType
WHEN 1 THEN t.clientGroupId
                                  ELSE @oldInternal
                           END,
       @oldExternal = CASE t.fwGroupType
WHEN 2 THEN t.clientGroupId
                                  ELSE @oldExternal
                           END,
       @oldProxied = CASE t.fwGroupType
WHEN 3 THEN t.clientGroupId
                                  ELSE @oldProxied
                           END,
	   @oldPerimeterProxy = CASE t.fwGroupType
WHEN 4 THEN t.clientGroupId
                                  ELSE @oldPerimeterProxy
                           END
	FROM @oldTopologies t
	SELECT
       @newInternal = CASE t.fwGroupType
WHEN 1 THEN t.clientGroupId
                                  ELSE @newInternal
                           END,
       @newExternal = CASE t.fwGroupType
WHEN 2 THEN t.clientGroupId
                                  ELSE @newExternal
                           END,
       @newProxied = CASE t.fwGroupType
WHEN 3 THEN t.clientGroupId
                                  ELSE @newProxied
                           END,
	   @newPerimeterProxy = CASE t.fwGroupType
WHEN 4 THEN t.clientGroupId
                                  ELSE @newPerimeterProxy
                           END
	FROM @newTopologies t
	SELECT @isOldTopoSmart = 1 FROM @oldTopologies OldFWGroups WHERE OldFWGroups.clientGroupId < 0
	SELECT @isNewTopoSmart = 1 FROM @newTopologies NewFWGroups WHERE NewFWGroups.clientGroupId < 0
SET @flagIndicatingConfigLevel = CASE WHEN @isNewTopoSmart = 1 THEN 4 ELSE 2 END
	/*
		Flags : 0 => Client/Group level, CONFIGURED_AT_TOPOLOGY => Configured via non-smart topology, CONFIGURED_AT_SMART_TOPOLOGY => Configured via smart topology
		Behavior till now (SP23 mid) : A client group with explicit network configuration is not allowed be part of a topology, and doesn't show up in the dropdown
		while creating a topology. Also, firewall options of groups belonging to only smart topologies are not considered.
		Consider a scenario where a client group with no explicit configuration, is part of only a smart topology.
		Now configure some firewall options such as tunnel port for this group.
		Go back to the previous smart topology, and make some update, and let it still be "smart".
		Now we lose the options set on the group. This is because the "flag" column of the App_firewallOptions is updated to indicate "Smart" and these options are ignored.
		To resolve this, start considering options specified on client groups belonging to smart topologies as well.
However, as "0" indicates group level options and 0 | 4 will still be 4, we are choosing to set the flag as 6 which is 4 | 2
		ToDo : Go ahead and fix all codebase to either use flag=1 for group level options or always consider smart topo options.
	*/
SET @flagIndicatingConfigLevelForOptions = CASE WHEN @isNewTopoSmart = 1 THEN (4 | 2) ELSE 2 END
	-- Delete old associations
	-- Identify routes to be deleted
	DECLARE @App_FirewallToBeDeleted TABLE (routeId INT)
	INSERT INTO @App_FirewallToBeDeleted(routeId)
	SELECT routeId
	FROM App_FirewallRoutesTopoAssoc
	WHERE topologyId = @topologyId
	DELETE App_FirewallRoutesTopoAssoc
	WHERE topologyId = @topologyId
	-- Identify routes to be deleted
	DECLARE @App_FwOutGoingRoutesToBeDeleted TABLE (routeId INT)
	INSERT INTO @App_FwOutGoingRoutesToBeDeleted
	SELECT routeId
	FROM App_FWOutGoingRoutesTopoAssoc
	WHERE topologyId = @topologyId
	DELETE App_FWOutGoingRoutesTopoAssoc
	WHERE topologyId = @topologyId
	--Delete old firewall options for client group if there is any changes in client groups of topology
	--Deletion of rows for Smart & Non-Smart has to be handled separately. If old topology is a smart topology, we will have to just delete the old option rows. If the old topology is a non-smart topology, we'll have to check if this group is part of any other topology before deleting the row.--
	--We need to update flag for groups which are part of multiple topologies
	DECLARE @GroupsNeedUpdate TABLE (clientGroupId INT)
	INSERT INTO @GroupsNeedUpdate (clientGroupId)
	VALUES
	(@oldExternal),
	(@oldInternal),
	(@oldProxied),
	(@oldPerimeterProxy)
	IF @oldExternal <> @newExternal
	BEGIN
		IF @oldExternal > 0
		BEGIN
			IF NOT EXISTS (SELECT 1 FROM App_FirewallTopologyAssoc WHERE groupId = @oldExternal)
				DELETE FROM [dbo].[App_FirewallOptions]
				WHERE [clientGroupId] = @oldExternal
			ELSE IF NOT EXISTS (SELECT 1 FROM APP_FirewallTopologyAssoc AFTA inner join APP_FirewallTopology AFT on AFTA.topologyId = AFT.topologyId WHERE AFTA.groupId = @oldExternal AND AFTA.fwGroupType = 2 AND AFTA.topologyId <> @topologyId AND AFT.topologyType = 1)
			BEGIN
				EXEC AppDeleteProxyWildCardOption @oldExternal
			END
		END
	END
	IF @oldInternal <> @newInternal
	BEGIN
		IF @oldInternal > 0
		BEGIN
			IF NOT EXISTS (SELECT 1 FROM App_FirewallTopologyAssoc WHERE groupId = @oldInternal)
				DELETE FROM [dbo].[App_FirewallOptions]
				WHERE [clientGroupId] = @oldInternal
		END
	END
	IF @oldProxied <> @newProxied
	BEGIN
		IF @oldProxied > 0
		BEGIN
			IF NOT EXISTS (SELECT 1 FROM App_FirewallTopologyAssoc WHERE groupId = @oldProxied)
				DELETE FROM [dbo].[App_FirewallOptions]
				WHERE [clientGroupId] = @oldProxied
ELSE IF NOT EXISTS (SELECT 1 FROM App_FirewallTopologyAssoc AFTA inner join APP_FirewallTopology AFT on AFTA.topologyId = AFT.topologyId WHERE AFTA.groupId = @oldProxied AND (AFTA.fwGroupType = 3 OR AFTA.fwGroupType = 4) AND AFTA.topologyId <> @topologyId AND (AFT.topologyType = 1 OR AFT.topologyType = 4))
				UPDATE App_FirewallOptions
				SET isDMZ = 0
				WHERE clientGroupId = @oldProxied
		END
	END
	IF @oldPerimeterProxy <> @newPerimeterProxy
	BEGIN
		IF @oldPerimeterProxy > 0
		BEGIN
			IF NOT EXISTS (SELECT 1 FROM App_FirewallTopologyAssoc WHERE groupId = @oldPerimeterProxy)
				DELETE FROM [dbo].[App_FirewallOptions]
				WHERE [clientGroupId] = @oldPerimeterProxy
ELSE IF NOT EXISTS (SELECT 1 FROM App_FirewallTopologyAssoc AFTA inner join APP_FirewallTopology AFT on AFTA.topologyId = AFT.topologyId WHERE AFTA.groupId = @oldPerimeterProxy AND (AFTA.fwGroupType = 3 OR AFTA.fwGroupType = 4) AND AFTA.topologyId <> @topologyId AND (AFT.topologyType = 1 OR AFT.topologyType = 4))
				UPDATE App_FirewallOptions
				SET isDMZ = 0
				WHERE clientGroupId = @oldPerimeterProxy
		END
	END
	-- Update flag to reflect smart vs non-smart
	IF @isOldTopoSmart<>@isNewTopoSmart
	BEGIN
		IF @isOldTopoSmart=1
		BEGIN
			UPDATE AFO
SET AFO.flag=(AFO.flag & ~4)
			FROM App_FirewallOptions AFO
			INNER JOIN @GroupsNeedUpdate InputT
			ON AFO.clientGroupId = InputT.clientGroupId
			LEFT OUTER JOIN
			(	SELECT groupId
				FROM APP_FirewallTopology AFT
				INNER JOIN APP_FirewallTopologyAssoc AFTA
				ON AFT.topologyId=AFTA.topologyId
				INNER JOIN @GroupsNeedUpdate T
				ON AFTA.groupId=T.clientGroupId
WHERE AFT.flag & 1 = 1 AND AFT.topologyId <> @topologyId
			) Topo
			ON AFO.clientGroupId = Topo.groupId
			WHERE Topo.groupId IS NULL
		END
		ELSE
		BEGIN
			UPDATE AFO
SET AFO.flag=(AFO.flag & ~2)
			FROM App_FirewallOptions AFO
			INNER JOIN @GroupsNeedUpdate InputT
			ON AFO.clientGroupId = InputT.clientGroupId
			LEFT OUTER JOIN
			(	SELECT groupId
				FROM APP_FirewallTopology AFT
				INNER JOIN APP_FirewallTopologyAssoc AFTA
				ON AFT.topologyId=AFTA.topologyId
				INNER JOIN @GroupsNeedUpdate T
				ON AFTA.groupId=T.clientGroupId
WHERE AFT.flag & 1 = 0 AND AFT.topologyId <> @topologyId
			) Topo
			ON AFO.clientGroupId = Topo.groupId
			WHERE Topo.groupId IS NULL
		END
	END
	-- If the old topology is a non-smart topology and the client group is no more part of any topology, set isTrivialConfig = 0 in APP_FWTrivialConfig.
	IF @isOldTopoSmart = 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM App_FirewallTopologyAssoc WHERE groupId = @oldExternal AND topologyId <> @topologyId)
UPDATE [dbo].[App_FWTrivialConfig] SET isTrivialConfig = 0
			WHERE clientGroupId = @oldExternal AND @oldExternal > 0
		IF NOT EXISTS (SELECT 1 FROM App_FirewallTopologyAssoc WHERE groupId = @oldInternal AND topologyId <> @topologyId)
UPDATE [dbo].[App_FWTrivialConfig] SET isTrivialConfig = 0
			WHERE clientGroupId = @oldInternal AND @oldInternal > 0
		IF NOT EXISTS (SELECT 1 FROM App_FirewallTopologyAssoc WHERE groupId = @oldProxied AND topologyId <> @topologyId)
UPDATE [dbo].[App_FWTrivialConfig] SET isTrivialConfig = 0
			WHERE clientGroupId = @oldProxied AND @oldProxied > 0
		IF NOT EXISTS (SELECT 1 FROM App_FirewallTopologyAssoc WHERE groupId = @oldPerimeterProxy AND topologyId <> @topologyId)
UPDATE [dbo].[App_FWTrivialConfig] SET isTrivialConfig = 0
			WHERE clientGroupId = @oldPerimeterProxy AND @oldPerimeterProxy > 0
	END
	-- Delete old topology routes from APP_Firewall and App_FWOutGoingRoutes
	-- If the new topology is a non-smart topology, add an entry for the external group in APP_FWTrivialConfig
	IF @newExternal > 0 AND @isNewTopoSmart = 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM App_FWTrivialConfig WHERE clientGroupId = @newExternal)
			INSERT INTO [dbo].[App_FWTrivialConfig] ([clientId],[clientGroupId],[isTrivialConfig],[networkWithCS],[connectionWithCS],[proxyClientIdCS],[networkWithMA],[connectionWithMA],[proxyClientIdMA])
			VALUES
(0, @newExternal, 2, 0,0,0,0,0,0)
		ELSE
UPDATE App_FWTrivialConfig SET isTrivialConfig = 2
WHERE clientGroupId = @newExternal and isTrivialConfig <> 2
	END
	-- If the new topology is a non-smart topology, add an entry for the internal group in APP_FWTrivialConfig
	IF @newInternal > 0 AND @isNewTopoSmart = 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM App_FWTrivialConfig WHERE clientGroupId = @newInternal)
			INSERT INTO [dbo].[App_FWTrivialConfig] ([clientId],[clientGroupId],[isTrivialConfig],[networkWithCS],[connectionWithCS],[proxyClientIdCS],[networkWithMA],[connectionWithMA],[proxyClientIdMA])
			VALUES
(0, @newInternal, 2, 0,0,0,0,0,0)
		ELSE
UPDATE App_FWTrivialConfig SET isTrivialConfig = 2
WHERE clientGroupId = @newInternal and isTrivialConfig <> 2
	END
	-- If the new topology is a non-smart topology, add an entry for the proxy group in APP_FWTrivialConfig
	IF @newProxied > 0 AND @isNewTopoSmart = 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM App_FWTrivialConfig WHERE clientGroupId = @newProxied)
			INSERT INTO [dbo].[App_FWTrivialConfig] ([clientId],[clientGroupId],[isTrivialConfig],[networkWithCS],[connectionWithCS],[proxyClientIdCS],[networkWithMA],[connectionWithMA],[proxyClientIdMA])
			VALUES
(0, @newProxied, 2, 0,0,0,0,0,0)
		ELSE
UPDATE App_FWTrivialConfig SET isTrivialConfig = 2
WHERE clientGroupId = @newProxied and isTrivialConfig <> 2
	END
	-- If the new topology is a non-smart topology, add an entry for the proxy group in APP_FWTrivialConfig
	IF @newPerimeterProxy > 0 AND @isNewTopoSmart = 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM App_FWTrivialConfig WHERE clientGroupId = @newPerimeterProxy)
			INSERT INTO [dbo].[App_FWTrivialConfig] ([clientId],[clientGroupId],[isTrivialConfig],[networkWithCS],[connectionWithCS],[proxyClientIdCS],[networkWithMA],[connectionWithMA],[proxyClientIdMA])
			VALUES
(0, @newPerimeterProxy, 2, 0,0,0,0,0,0)
		ELSE
UPDATE App_FWTrivialConfig SET isTrivialConfig = 2
WHERE clientGroupId = @newPerimeterProxy and isTrivialConfig <> 2
	END
	IF @newExternal > 0
	BEGIN
		-- Reset to defaults
		SET @configureAutomatically = @configureAutomaticallyDefault
		SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @keepAliveSeconds = @defaultKeepAliveSeconds
		-- Update as per user configuration
		SELECT @configureAutomatically = configureAutomatically, @tunnelConnectionPort = tunnelconnectionPort, @keepAliveSeconds = keepAliveSeconds
		FROM @fwGroupOptions
		WHERE clientGroupId=@newExternal
		-- Sanity checks and further initialization
		IF @configureAutomatically = 1 OR @tunnelConnectionPort = 0 OR @tunnelConnectionPort IS NULL
			SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @firewallExtendedProperties = (SELECT @defaultOutgoingProtocol as '@defaultOutgoingProtocol',@configureAutomatically as '@configureAutomatically' FOR XML PATH('App_FirewallExtendedProperties'))
		UPDATE [dbo].[App_FirewallOptions]
		SET flag = flag | @flagIndicatingConfigLevelForOptions
			, tunnelconnectionPort = @tunnelConnectionPort
			, keepAliveSeconds = @keepAliveSeconds
			, extendedProperties = @firewallExtendedProperties
		WHERE clientGroupId = @newExternal
		IF @@ROWCOUNT = 0
			INSERT INTO [dbo].[App_FirewallOptions] ([clientId],[clientGroupId],[isDMZ],[tunnelconnectionPort],[keepAliveSeconds],[tunnelInitSeconds],[foreceSSL],[lockDown],[bindOpenPortsOnly],[isRoamingClient],[extendedProperties],[flag])
			VALUES
(0, @newExternal, 0, @tunnelConnectionPort, @keepAliveSeconds,30,0,0,0,0,@firewallExtendedProperties, @flagIndicatingConfigLevelForOptions)
	END
IF @newTopologyType = 1 AND @newExternal > 0
		EXEC AppSetProxyWildCardOption @newExternal, @newWildCardOption
	IF @newInternal > 0
	BEGIN
		-- Reset to defaults
		SET @configureAutomatically = @configureAutomaticallyDefault
		SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @keepAliveSeconds = @defaultKeepAliveSeconds
		-- Update as per user configuration
		SELECT @configureAutomatically = configureAutomatically, @tunnelConnectionPort = tunnelconnectionPort, @keepAliveSeconds = keepAliveSeconds
		FROM @fwGroupOptions
		WHERE clientGroupId=@newInternal
		-- Sanity checks and further initialization
		IF @configureAutomatically = 1 OR @tunnelConnectionPort = 0 OR @tunnelConnectionPort IS NULL
			SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @firewallExtendedProperties = (SELECT @defaultOutgoingProtocol as '@defaultOutgoingProtocol',@configureAutomatically as '@configureAutomatically' FOR XML PATH('App_FirewallExtendedProperties'))
		UPDATE [dbo].[App_FirewallOptions]
		SET flag = flag | @flagIndicatingConfigLevelForOptions
			, tunnelconnectionPort = @tunnelConnectionPort
			, keepAliveSeconds = @keepAliveSeconds
			, extendedProperties = @firewallExtendedProperties
		WHERE clientGroupId = @newInternal
		IF @@ROWCOUNT = 0
			INSERT INTO [dbo].[App_FirewallOptions] ([clientId],[clientGroupId],[isDMZ],[tunnelconnectionPort],[keepAliveSeconds],[tunnelInitSeconds],[foreceSSL],[lockDown],[bindOpenPortsOnly],[isRoamingClient],[extendedProperties],[flag])
			VALUES
(0, @newInternal, 0, @tunnelConnectionPort, @keepAliveSeconds,30,0,0,0,0,@firewallExtendedProperties, @flagIndicatingConfigLevelForOptions)
	END
IF @newProxied > 0 AND (@newTopologyType = 1 OR @newTopologyType = 4)
	BEGIN
		-- Reset to defaults
		SET @configureAutomatically = @configureAutomaticallyDefault
		SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @keepAliveSeconds = @defaultKeepAliveSeconds
		-- Update as per user configuration
		SELECT @configureAutomatically = configureAutomatically, @tunnelConnectionPort = tunnelconnectionPort, @keepAliveSeconds = keepAliveSeconds
		FROM @fwGroupOptions
		WHERE clientGroupId=@newProxied
		-- Sanity checks and further initialization
		IF @configureAutomatically = 1 OR @tunnelConnectionPort = 0 OR @tunnelConnectionPort IS NULL
			SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @firewallExtendedProperties = (SELECT @defaultOutgoingProtocol as '@defaultOutgoingProtocol',@configureAutomatically as '@configureAutomatically' FOR XML PATH('App_FirewallExtendedProperties'))
		IF NOT EXISTS (SELECT 1 FROM App_FirewallOptions WHERE clientGroupId =  @newProxied)
			INSERT INTO [dbo].[App_FirewallOptions] ([clientId],[clientGroupId],[isDMZ],[tunnelconnectionPort],[keepAliveSeconds],[tunnelInitSeconds],[foreceSSL],[lockDown],[bindOpenPortsOnly],[isRoamingClient],[extendedProperties],[flag])
			VALUES
(0, @newProxied, 1, @tunnelConnectionPort, @keepAliveSeconds,30,0,0,0,0,@firewallExtendedProperties, @flagIndicatingConfigLevelForOptions)
		ELSE
			UPDATE [dbo].[App_FirewallOptions]
			SET [isDMZ] = 1
				, [flag] = [flag] | @flagIndicatingConfigLevelForOptions
				, tunnelconnectionPort = @tunnelConnectionPort
				, keepAliveSeconds = @keepAliveSeconds
				, extendedProperties = @firewallExtendedProperties
			WHERE [clientGroupId] = @newProxied
	END
IF @newPerimeterProxy > 0 AND @newTopologyType = 4
	BEGIN
		-- Reset to defaults
		SET @configureAutomatically = @configureAutomaticallyDefault
		SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @keepAliveSeconds = @defaultKeepAliveSeconds
		-- Update as per user configuration
		SELECT @configureAutomatically = configureAutomatically, @tunnelConnectionPort = tunnelconnectionPort, @keepAliveSeconds = keepAliveSeconds
		FROM @fwGroupOptions
		WHERE clientGroupId=@newPerimeterProxy
		-- Sanity checks and further initialization
		IF @configureAutomatically = 1 OR @tunnelConnectionPort = 0 OR @tunnelConnectionPort IS NULL
			SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @firewallExtendedProperties = (SELECT @defaultOutgoingProtocol as '@defaultOutgoingProtocol',@configureAutomatically as '@configureAutomatically' FOR XML PATH('App_FirewallExtendedProperties'))
		IF NOT EXISTS (SELECT 1 FROM App_FirewallOptions WHERE clientGroupId =  @newPerimeterProxy)
			INSERT INTO [dbo].[App_FirewallOptions] ([clientId],[clientGroupId],[isDMZ],[tunnelconnectionPort],[keepAliveSeconds],[tunnelInitSeconds],[foreceSSL],[lockDown],[bindOpenPortsOnly],[isRoamingClient],[extendedProperties],[flag])
			VALUES
(0, @newPerimeterProxy, 1, @tunnelConnectionPort, @keepAliveSeconds,30,0,0,0,0,@firewallExtendedProperties, @flagIndicatingConfigLevelForOptions)
		ELSE
			UPDATE [dbo].[App_FirewallOptions]
			SET [isDMZ] = 1
				, [flag] = [flag] | @flagIndicatingConfigLevelForOptions
				, tunnelconnectionPort = @tunnelConnectionPort
				, keepAliveSeconds = @keepAliveSeconds
				, extendedProperties = @firewallExtendedProperties
			WHERE [clientGroupId] = @newPerimeterProxy
	END
	--Populate new topology routes
IF @newTopologyType = 1
	BEGIN
	--proxied
		--insert new topology
		INSERT INTO @topoFirewall
SELECT @newExternal, @newProxied, 1
		UNION ALL
SELECT @newInternal, @newProxied, 1
		UNION ALL
SELECT @newProxied, @newExternal, 0
		UNION ALL
SELECT @newProxied, @newInternal, 0
		UNION ALL
SELECT @newExternal, @newInternal, 1 WHERE @newWildCardOption > 0
		SELECT @clientGroupName = name
		FROM APP_ClientGroup
		WHERE id = @newProxied
		SET @fwOutGoingRouteOptions =(SELECT @connectionProtocol AS '@connectionProtocol',
				@forceAllBackupRestoreDataTraffic AS '@forceAllBackupRestoreDataTraffic',
				@gatewayHostname AS '@gatewayHostname',
				@routeType AS '@routeType',
				(SELECT @clientGroupName AS '@clientGroupName',
						@newProxied AS '@clientGroupId',
						@clientName AS '@clientName',
						@clientId AS '@clientId'
						FOR XML PATH('remoteProxy'), TYPE)
					FOR XML PATH('App_FireWallOutGoingRouteOptions'))
		INSERT INTO @topoOutGoingRoutes
		VALUES
		(@newExternal, @newInternal, @newProxied, @fwOutGoingRouteOptions),
		(@newInternal, @newExternal, @newProxied, @fwOutGoingRouteOptions),
		(@newInternal, @newProxied, 0, @directRouteDefaultOptions),
		(@newExternal, @newProxied, 0, @directRouteDefaultOptions)
	END
ELSE IF @newTopologyType = 2
	BEGIN
	--oneway
	--insert new topology
		INSERT INTO @topoFirewall
		VALUES
(@newExternal, @newInternal, 1),
(@newInternal, @newExternal, 0)
		INSERT INTO @topoOutGoingRoutes
		VALUES
		(@newExternal, @newInternal, 0, @directRouteDefaultOptions)
	END
ELSE IF @newTopologyType = 3
	BEGIN
	--twoway
	--insert new topology
		INSERT INTO @topoFirewall
		VALUES
(@newExternal, @newInternal, 0),
(@newInternal, @newExternal, 0)
		INSERT INTO @topoOutGoingRoutes
		VALUES
		(@newExternal, @newInternal, 0, @directRouteDefaultOptions),
		(@newInternal, @newExternal, 0, @directRouteDefaultOptions)
	END
ELSE IF @newTopologyType = 4
	BEGIN
	--insert into new topology
		INSERT INTO @topoFirewall
		VALUES
(@newExternal, @newProxied, 1),
(@newPerimeterProxy, @newProxied, 0),
(@newProxied, @newExternal, 0),
(@newProxied, @newPerimeterProxy, 1),
(@newInternal, @newPerimeterProxy, 1),
(@newPerimeterProxy, @newInternal, 0),
(@newProxied, @newInternal, 1),
(@newInternal, @newProxied, 1),
(@newExternal, @newInternal, 1),
(@newInternal, @newExternal, 1)
		SELECT @clientGroupName = name
		FROM APP_ClientGroup
		WHERE id = @newProxied
		SET @fwOutGoingRouteOptions =(SELECT @connectionProtocol AS '@connectionProtocol',
				@forceAllBackupRestoreDataTraffic AS '@forceAllBackupRestoreDataTraffic',
				@gatewayHostname AS '@gatewayHostname',
				@routeType AS '@routeType',
				(SELECT @clientGroupName AS '@clientGroupName',
						@newProxied AS '@clientGroupId',
						@clientName AS '@clientName',
						@clientId AS '@clientId'
						FOR XML PATH('remoteProxy'), TYPE)
					FOR XML PATH('App_FireWallOutGoingRouteOptions'))
		INSERT INTO @topoOutGoingRoutes
		VALUES
		(@newPerimeterProxy, @newExternal, @newProxied, @fwOutGoingRouteOptions),
		(@newExternal, @newPerimeterProxy, @newProxied, @fwOutGoingRouteOptions),
		(@newExternal, @newProxied, 0, @directRouteDefaultOptions),
		(@newProxied, @newPerimeterProxy, 0, @directRouteDefaultOptions),
		(@newExternal, @newInternal, @newProxied, @fwOutGoingRouteOptions)
		SELECT @clientGroupName = name
		FROM APP_ClientGroup
		WHERE id = @newPerimeterProxy
		SET @fwOutGoingRouteOptions =(SELECT @connectionProtocol AS '@connectionProtocol',
				@forceAllBackupRestoreDataTraffic AS '@forceAllBackupRestoreDataTraffic',
				@gatewayHostname AS '@gatewayHostname',
				@routeType AS '@routeType',
				(SELECT @clientGroupName AS '@clientGroupName',
						@newPerimeterProxy AS '@clientGroupId',
						@clientName AS '@clientName',
						@clientId AS '@clientId'
						FOR XML PATH('remoteProxy'), TYPE)
					FOR XML PATH('App_FireWallOutGoingRouteOptions'))
		INSERT INTO @topoOutGoingRoutes
		VALUES
		(@newInternal, @newExternal, @newPerimeterProxy, @fwOutGoingRouteOptions),
		(@newInternal, @newProxied, @newPerimeterProxy, @fwOutGoingRouteOptions),
		(@newProxied, @newInternal, @newPerimeterProxy, @fwOutGoingRouteOptions),
		(@newInternal, @newPerimeterProxy, 0, @directRouteDefaultOptions)
	END
	-- Update flag column based on smart vs non-smart topology
	IF @isOldTopoSmart<>@isNewTopoSmart
	BEGIN
		-- We need to update smart vs non-smart flag in App_Firewall and App_FWOutGoingRoutes
		IF @isOldTopoSmart=1
		BEGIN
			-- The topology is no longer smart, so remove smart flag if the route does not participate in any other smart topo
			UPDATE AF
SET AF.flag=((AF.flag & ~4) | 2)
			FROM APP_Firewall AF
			INNER JOIN @topoFirewall TF
			ON AF.clientGroupId=TF.clientGroupId AND AF.forClientGroupId=TF.forClientGroupId AND AF.restrictionType=TF.restrictionType
			LEFT OUTER JOIN
			(	SELECT RTA.routeId
				FROM  App_FirewallRoutesTopoAssoc RTA
				INNER JOIN APP_FirewallTopology AFT
				ON RTA.topologyId=AFT.topologyId
WHERE AFT.flag & 1 <> 1
			) Rout
			ON AF.id=Rout.routeId
			WHERE Rout.routeId IS NULL
		END
		ELSE
		BEGIN
			UPDATE AF
SET AF.flag=((AF.flag & ~2) | 4)
			FROM APP_Firewall AF
			INNER JOIN @topoFirewall TF
			ON AF.clientGroupId=TF.clientGroupId AND AF.forClientGroupId=TF.forClientGroupId AND AF.restrictionType=TF.restrictionType
			LEFT OUTER JOIN
			(	SELECT RTA.routeId
				FROM  App_FirewallRoutesTopoAssoc RTA
				INNER JOIN APP_FirewallTopology AFT
				ON RTA.topologyId=AFT.topologyId
WHERE AFT.flag & 1 = 0
			) Rout
			ON AF.id=Rout.routeId
			WHERE Rout.routeId IS NULL
		END
	END
	INSERT INTO APP_Firewall
	SELECT 0, TF.clientGroupId, 0, TF.forClientGroupId, TF.restrictionType, @flagIndicatingConfigLevel
	FROM @topoFirewall TF
	LEFT JOIN APP_Firewall AF
	ON AF.clientGroupId = TF.clientGroupId AND AF.forClientGroupId = TF.forClientGroupId AND AF.restrictionType = TF.restrictionType
	WHERE AF.id IS NULL
	IF @isOldTopoSmart<>@isNewTopoSmart
	BEGIN
		-- We need to update smart vs non-smart flag in App_Firewall and App_FWOutGoingRoutes
		IF @isOldTopoSmart=1
		BEGIN
			-- The topology is no longer smart, so remove smart flag if the route does not participate in any other smart topo and add non-smart flag
			UPDATE FWOR
SET FWOR.flag=((FWOR.flag & ~4) | 2)
			FROM App_FWOutGoingRoutes FWOR
			CROSS APPLY fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions') OutRoute(routeOptions)
			INNER JOIN @topoOutGoingRoutes TFO
			ON FWOR.clientGroupId=TFO.clientGroupId AND FWOR.forClientGroupId=TFO.forClientGroupId AND
			CASE WHEN OutRoute.routeOptions.exist('./remoteProxy[1]/@clientGroupId') = 1 THEN ISNULL(OutRoute.routeOptions.value('./remoteProxy[1]/@clientGroupId','int'),0) ELSE 0 END = TFO.proxyClientGroupId
			LEFT OUTER JOIN
			(
				SELECT RTA.routeId
				FROM  App_FWOutGoingRoutesTopoAssoc RTA
				INNER JOIN APP_FirewallTopology AFT
				ON RTA.topologyId=AFT.topologyId
WHERE AFT.flag & 1 <> 1
			) Rout
			ON FWOR.id=Rout.routeId
			WHERE Rout.routeId IS NULL
		END
		ELSE
		BEGIN
			UPDATE FWOR
SET FWOR.flag=((FWOR.flag & ~2) | 4)
			FROM App_FWOutGoingRoutes FWOR
			CROSS APPLY fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions') OutRoute(routeOptions)
			INNER JOIN @topoOutGoingRoutes TFO
			ON FWOR.clientGroupId=TFO.clientGroupId AND FWOR.forClientGroupId=TFO.forClientGroupId AND
			CASE WHEN OutRoute.routeOptions.exist('./remoteProxy[1]/@clientGroupId') = 1 THEN ISNULL(OutRoute.routeOptions.value('./remoteProxy[1]/@clientGroupId','int'),0) ELSE 0 END = TFO.proxyClientGroupId
			LEFT OUTER JOIN
			(
				SELECT RTA.routeId
				FROM  App_FWOutGoingRoutesTopoAssoc RTA
				INNER JOIN APP_FirewallTopology AFT
				ON RTA.topologyId=AFT.topologyId
WHERE AFT.flag & 1 = 0
			) Rout
			ON FWOR.id=Rout.routeId
			WHERE Rout.routeId IS NULL
		END
	END
	INSERT INTO APP_FWOutGoingRoutes
	SELECT 0, TFO.clientGroupId, 0, TFO.forClientGroupId, TFO.routeOptions, @flagIndicatingConfigLevel
	FROM @topoOutGoingRoutes TFO
	LEFT JOIN
	(
		SELECT id, clientGroupId, forClientGroupId, CASE WHEN routeOptions.exist('./remoteProxy[1]/@clientGroupId') = 1 THEN ISNULL(routeOptions.value('./remoteProxy[1]/@clientGroupId','int'),0) ELSE 0 END proxyClientGroupId FROM APP_FWOutGoingRoutes
		CROSS APPLY fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions') OutRoute(routeOptions)
	) AFO (id, clientGroupId, forClientGroupId, proxyClientGroupId)
	ON AFO.clientGroupId = TFO.clientGroupId AND AFO.forClientGroupId = TFO.forClientGroupId AND AFO.proxyClientGroupId = TFO.proxyClientGroupId
	WHERE AFO.id IS NULL
	-- Update routes "connectionProtocol" as per topology extended property "encryptTraffic"
	IF @oldEncryptTraffic=1
	BEGIN
		UPDATE FO
		SET fwOutGoingRouteOptions.modify('
					replace value of (/App_FireWallOutGoingRouteOptions/@connectionProtocol)[1]
with "2"
		')
		FROM App_FWOutGoingRoutes FO
		INNER JOIN @App_FwOutGoingRoutesToBeDeleted TD
		ON FO.id=TD.routeId
		WHERE @oldEncryptTraffic NOT IN (
			SELECT ISNULL(Props.p.value('@encryptTraffic', 'int'), 0)
			FROM App_FWOutGoingRoutes AFOR
			INNER JOIN App_FWOutGoingRoutesTopoAssoc Assoc
			ON AFOR.id=Assoc.routeId
			INNER JOIN @App_FwOutGoingRoutesToBeDeleted TD
			ON AFOR.id=TD.routeId
			INNER JOIN APP_FirewallTopology AFT
			ON Assoc.topologyId=AFT.topologyId
			CROSS APPLY AFT.extendedProperties.nodes('/App_TopologyExtendedProperties') Props(p)
			WHERE AFT.topologyId<>@topologyId)
		UPDATE FO
		SET fwOutGoingRouteOptions.modify('
					replace value of (/App_FireWallOutGoingRouteOptions/@forceAllBackupRestoreDataTraffic)[1]
					with "0"
		')
		FROM App_FWOutGoingRoutes FO
		INNER JOIN @App_FwOutGoingRoutesToBeDeleted TD
		ON FO.id=TD.routeId
		WHERE @oldEncryptTraffic NOT IN (
			SELECT ISNULL(Props.p.value('@encryptTraffic', 'int'), 0)
			FROM App_FWOutGoingRoutes AFOR
			INNER JOIN App_FWOutGoingRoutesTopoAssoc Assoc
			ON AFOR.id=Assoc.routeId
			INNER JOIN @App_FwOutGoingRoutesToBeDeleted TD
			ON AFOR.id=TD.routeId
			INNER JOIN APP_FirewallTopology AFT
			ON Assoc.topologyId=AFT.topologyId
			CROSS APPLY AFT.extendedProperties.nodes('/App_TopologyExtendedProperties') Props(p)
			WHERE AFT.topologyId<>@topologyId)
		Update FO
		SET extendedProperties.modify('
			replace value of (/App_FirewallExtendedProperties/@defaultOutgoingProtocol)[1]
			with "0"
		')
		from App_FirewallOptions FO
		inner join APP_FirewallTopologyAssoc FTA1
		on FO.clientGroupId=FTA1.groupId
		where FTA1.topologyId=@topologyId and  FO.clientGroupId not in
		(
		select FTA.groupId
		from APP_FirewallTopology FT
		inner join APP_FirewallTopologyAssoc FTA
		on FT.topologyId=FTA.topologyId
		where FTA.groupId in ( select groupid from APP_FirewallTopologyAssoc where topologyId=@topologyId)
		and FT.topologyId<>@topologyId -- current topology id
		and FT.extendedProperties.value('(/App_TopologyExtendedProperties/@encryptTraffic)[1]','int') = 1
		)
	END
	-- Update "connectionProtocol" based on "@encryptTraffic" from App_FirewallTopology.extendedOptions
	IF @newEncryptTraffic = 1
	BEGIN
		UPDATE FO
		SET fwOutGoingRouteOptions.modify('
			replace value of (/App_FireWallOutGoingRouteOptions/@connectionProtocol)[1]
with "1"
		')
		FROM App_FWOutGoingRoutes FO
		CROSS APPLY fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions') OutRoute(routeOptions)
		INNER JOIN @topoOutGoingRoutes TFO
		ON FO.clientGroupId=TFO.clientGroupId AND FO.forClientGroupId=TFO.forClientGroupId AND
		CASE WHEN OutRoute.routeOptions.exist('./remoteProxy[1]/@clientGroupId') = 1 THEN ISNULL(OutRoute.routeOptions.value('./remoteProxy[1]/@clientGroupId','int'),0) ELSE 0 END = TFO.proxyClientGroupId
		UPDATE FO
		SET fwOutGoingRouteOptions.modify('
			replace value of (/App_FireWallOutGoingRouteOptions/@forceAllBackupRestoreDataTraffic)[1]
			with "1"
		')
		FROM App_FWOutGoingRoutes FO
		CROSS APPLY fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions') OutRoute(routeOptions)
		INNER JOIN @topoOutGoingRoutes TFO
		ON FO.clientGroupId=TFO.clientGroupId AND FO.forClientGroupId=TFO.forClientGroupId AND
		CASE WHEN OutRoute.routeOptions.exist('./remoteProxy[1]/@clientGroupId') = 1 THEN ISNULL(OutRoute.routeOptions.value('./remoteProxy[1]/@clientGroupId','int'),0) ELSE 0 END = TFO.proxyClientGroupId
		Update FO
		set extendedProperties.modify('
			replace value of (/App_FirewallExtendedProperties/@defaultOutgoingProtocol)[1]
			with "1"
		')
		from App_FirewallOptions FO
		inner join APP_FirewallTopologyAssoc FTA
		on FTA.groupId=FO.clientGroupId where FTA.topologyId=@topologyId;
	END
	INSERT INTO App_FirewallRoutesTopoAssoc
	SELECT AF.id, @topologyId
	FROM @topoFirewall TF
	INNER JOIN APP_Firewall AF
	ON AF.clientGroupId = TF.clientGroupId AND AF.forClientGroupId = TF.forClientGroupId AND AF.restrictionType = TF.restrictionType
	INSERT INTO App_FWOutGoingRoutesTopoAssoc
	SELECT AFO.id, @topologyId
	FROM @topoOutGoingRoutes TFO
	INNER JOIN
	(
		SELECT id, clientGroupId, forClientGroupId, CASE WHEN routeOptions.exist('./remoteProxy[1]/@clientGroupId') = 1 THEN ISNULL(routeOptions.value('./remoteProxy[1]/@clientGroupId','int'),0) ELSE 0 END proxyClientGroupId FROM APP_FWOutGoingRoutes
		CROSS APPLY fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions') OutRoute(routeOptions)
	) AFO (id, clientGroupId, forClientGroupId, proxyClientGroupId)
	ON AFO.clientGroupId = TFO.clientGroupId AND AFO.forClientGroupId = TFO.forClientGroupId AND AFO.proxyClientGroupId = TFO.proxyClientGroupId
	-- Delete Routes only if they are not part of any other topology
	DELETE AF
	FROM APP_Firewall AF
	INNER JOIN @App_FirewallToBeDeleted Del
	ON AF.id = Del.routeId
	LEFT JOIN App_FirewallRoutesTopoAssoc AFRTA
	ON AF.id = AFRTA.routeId
	WHERE AFRTA.routeId IS NULL
	-- Delete Routes only if they are not part of any other topology
	DELETE FWOR
	FROM APP_FWOutGoingRoutes FWOR
	INNER JOIN @App_FwOutGoingRoutesToBeDeleted Del
	ON FWOR.id = Del.routeId
	LEFT JOIN App_FWOutGoingRoutesTopoAssoc AFOTA
	ON FWOR.id = AFOTA.routeId
	WHERE AFOTA.routeId IS NULL
	-- We need to update route specific properties (set at the topology level) if the route is part of multiple topologies
	-- Find out if the route is part of multiple topologies
	DECLARE @RoutePartOfMultipleTopologies TABLE (routeId INTEGER, topologyId INTEGER, connectionProtocol INTEGER, numberOfStreams INTEGER, connectionProtocolRank INTEGER)
	-- Old topologies created before SP21 or via commcell console do not have the connectionProtocol set. They only have encryptTraffic attribute.
	INSERT INTO @RoutePartOfMultipleTopologies (routeId, topologyId, connectionProtocol, numberOfStreams)
	SELECT FWORA2.routeId, FWORA2.topologyId,  CASE ISNULL(Props.col.value('/App_TopologyExtendedProperties[1]/@encryptTraffic', 'INTEGER'), 0)
WHEN 1 THEN 1
ELSE ISNULL(Props.col.value('/App_TopologyExtendedProperties[1]/@connectionProtocol', 'INTEGER'), 2) END, ISNULL(Props.col.value('/App_TopologyExtendedProperties[1]/@numberOfStreams', 'INTEGER'), 1)
	FROM App_FWOutGoingRoutesTopoAssoc FWORA1
	INNER JOIN App_FWOutGoingRoutesTopoAssoc FWORA2
	ON FWORA1.routeId=FWORA2.routeId
	INNER JOIN APP_FirewallTopology FT
	ON FWORA2.topologyId=FT.topologyId
	CROSS APPLY FT.extendedProperties.nodes('/App_TopologyExtendedProperties') Props(col)
	WHERE FWORA1.topologyId = @topologyId
-- Start of UpdateTopologySpecificOptions
	-- Now update Topology specific options
	-- We need to consider MAX of numberOfStreams
	DECLARE @RouteStreams TABLE(routeId INTEGER, numberOfStreams INTEGER)
	INSERT INTO @RouteStreams
	SELECT routeId, MAX(numberOfStreams)
	FROM @RoutePartOfMultipleTopologies
	GROUP BY routeId
	-- Update App_FWOutGoingRoutes accordingly
	UPDATE FWOR
	SET fwOutGoingRouteOptions.modify(' replace value of (/App_FireWallOutGoingRouteOptions/@numberOfStreams)[1]
            with sql:column("RS.numberOfStreams")')
	FROM App_FWOutGoingRoutes FWOR
	INNER JOIN @RouteStreams RS
	ON FWOR.id=RS.routeId
	-- For connectionProtocol, we have the following priority order : https (1) > httpsa (2) > http (0) > raw  (3)
	-- For ease of enforcing this priority, let us map connection protocols to the following ranks
	-- Rank 1 => HTTPS	(enum value 1)
	-- Rank 2 => HTTPSA (enum value 2)
	-- Rank 3 => HTTP	(enum value 0)
	-- Rank 4 => RAW	(enum value 3)
	UPDATE @RoutePartOfMultipleTopologies
SET connectionProtocolRank = CASE connectionProtocol WHEN 1 THEN 1
WHEN 2	THEN 2
WHEN 0 THEN 3
WHEN 3 THEN 4
														 END
	DECLARE @RouteProtocol TABLE(routeId INTEGER, connectionProtocolRank INTEGER, connectionProtocol INTEGER)
	INSERT INTO @RouteProtocol (routeId, connectionProtocolRank)
	SELECT routeId, MIN(connectionProtocolRank)
	FROM @RoutePartOfMultipleTopologies
	GROUP BY routeId
	-- Reverse mapping rank to protocol (as we cannot use rank directly in xml.modify(replace value of) with a case statement)
	UPDATE @RouteProtocol
SET connectionProtocol = CASE connectionProtocolRank WHEN 1 THEN 1
WHEN 2	THEN 2
WHEN 3 THEN 0
WHEN 4 THEN 3
														 END
	-- Update App_FWOutGoingRoutes accordingly
	UPDATE FWOR
	SET fwOutGoingRouteOptions.modify(' replace value of (/App_FireWallOutGoingRouteOptions/@connectionProtocol)[1]
            with sql:column("RP.connectionProtocol")')
	FROM App_FWOutGoingRoutes FWOR
	INNER JOIN @RouteProtocol RP
	ON FWOR.id=RP.routeId
-- End of UpdateTopologySpecificOptions
END
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateTopology')
	delete from GxQscripts where name = 'UpdateTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateTopology')
	delete from GXDBVersions where aliasname = 'UpdateTopology'
GO

insert into GXDBVersions values(2, 'UpdateTopology',  'v1.1.2.23.16.1', 'UpdateTopology', 'v1.1.2.23.16.1')
GO

