

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateToBeCopiedJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Jun Lu
--	Date:   01/30/2003
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/UpdateToBeCopiedJobs.sp,v $ $Id: UpdateToBeCopiedJobs.sp,v 1.114.12.39 2020/12/17 12:13:15 pkrishnan Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='UpdateToBeCopiedJobs')
BEGIN
	print '>>> Drop Stored Procedure: UpdateToBeCopiedJobs <<<'
	drop procedure UpdateToBeCopiedJobs
END
IF EXISTS (select * from GxQscripts where name='UpdateToBeCopiedJobs')
	delete from GxQscripts where name = 'UpdateToBeCopiedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateToBeCopiedJobs')
	delete from GXDBVersions where aliasname = 'UpdateToBeCopiedJobs'
GO
print '... Creating Procedure: UpdateToBeCopiedJobs'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure UpdateToBeCopiedJobs
  @i_archGroupId integer,
  @i_copyId integer,
  @i_today integer,
  @i_order integer,
  @i_modifyTime integer
AS
  DECLARE @r_defaultCopy integer;
  DECLARE @r_appId integer;
  DECLARE @r_jobId integer;
  DECLARE @r_commCellId integer;
  DECLARE @r_startDate integer;
  DECLARE @r_selected integer;
  DECLARE @r_rowsInserted integer;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE	@ORACLE_RMAN_CUSTOMSCRIPT_BKP	BIGINT
SET		@ORACLE_RMAN_CUSTOMSCRIPT_BKP = 0x2000000000000
DECLARE @EX_FULL_JOB_IN_CYCLE		BIGINT											-- JMBKP_EX_FULL_JOB_IN_CYCLE
SET			@EX_FULL_JOB_IN_CYCLE   = 0x10000000000000
DECLARE @EX_APPAWARE_CHILD_JOB	 BIGINT											-- JMBKP_EX_APPAWARE_CHILD_JOB
SET			@EX_APPAWARE_CHILD_JOB   = 0x20000000000000
DECLARE @effDate    INTEGER
DECLARE @endDate    INTEGER
DECLARE @copyType   INTEGER
DECLARE @agroupId   INTEGER
DECLARE @agroupType	INTEGER
DECLARE @agroupFlags INTEGER
DECLARE @defCopyId  INTEGER
DECLARE @srcCopyId  INTEGER
DECLARE @copyActive INTEGER
DECLARE @copyFlags  INTEGER
DECLARE @bSnapCopy  INTEGER
DECLARE @bMirrorCopy  INTEGER
DECLARE @spTZType	INTEGER
DECLARE @csTimeZone VARCHAR(255)
DECLARE @NonFullBkpTypes INTEGER = 0
DECLARE @rowsInserted INTEGER = 0
DECLARE @t_extendedFlags	INTEGER
DECLARE @SkipTransactionalLogs INT = 0
SET @SkipTransactionalLogs = ISNULL((SELECT VALUE FROM MMConfigs WHERE name = 'MMCONFIG_SKIP_AUXCOPY_TRANSACTIONAL_LOGS'),0)
if (OBJECT_ID('tempdb.dbo.#latestJobForAppSrcCopy') IS NOT NULL) DROP TABLE #latestJobForAppSrcCopy
if (OBJECT_ID('tempdb.dbo.#latestJobForAppAuxCopy') IS NOT NULL) DROP TABLE #latestJobForAppAuxCopy
if (OBJECT_ID('tempdb.dbo.#tempFullJobData') IS NOT NULL) DROP TABLE #tempFullJobData
CREATE TABLE #tempFullJobData (
		appId INT, clientId INT, jobId INT, commCellId INT, startDate INT, selected INT, TimeZone VARCHAR(255))
if (OBJECT_ID('tempdb.dbo.#tblSelectedJobs') IS NOT NULL) DROP TABLE #tblSelectedJobs
	CREATE TABLE #tblSelectedJobs (jobId INTEGER, commcellId INTEGER, copyId INTEGER, dataType INTEGER)
CREATE INDEX Idx_tmptblSelectedJobs_1 ON #tblSelectedJobs (jobId, commcellId, copyId)
IF OBJECT_ID('tempdb..#tmpAppIdList') IS NOT NULL	DROP TABLE #tmpAppIdList
CREATE TABLE #tmpAppIdList(appId int, unSupportedAlways int, unSupportedOnSelAlways int, unSupportedDB int, isCWEjobValid int, Primary Key(appId))
IF OBJECT_ID('tempdb.dbo.#archCopyToAppId') IS NOT NULL DROP TABLE #archCopyToAppId
CREATE TABLE #archCopyToAppId (
copyId			INTEGER,
AppId				INTEGER
)
CREATE CLUSTERED INDEX idx_archCopyToAppId ON #archCopyToAppId (copyId,AppId)
DECLARE @CountPartialDRSuccess INT
SELECT	@CountPartialDRSuccess = isCWEjobValid
FROM	APP_iDAType WITH (NOLOCK)
WHERE	type = 1000
DECLARE @l_SelectDDBBackupJobForAuxCopy INTEGER = 0
IF EXISTS (SELECT * from MMConfigs  WITH (NOLOCK) WHERE name = 'MMS2_CONFIG_SELECT_DDB_BACKUP_JOB_FOR_AUXCOPY' AND value > 0)
	SET @l_SelectDDBBackupJobForAuxCopy = 1
SELECT	@agroupId = archGroupId, @copyFlags = flags, @t_extendedFlags = extendedFlags, @copyActive = isActive, @copyType = type,
		@effDate = startTime, @srcCopyId = sourceCopyId, @bSnapCopy = isSnapCopy, @bMirrorCopy = isMirrorCopy, @endDate = endTime
FROM	archGroupCopy WITH (NOLOCK)
WHERE	id = @i_copyId
IF @copyActive = 0 OR @effDate > @i_today OR @copyType = 5
   GOTO OUTPUT_EXIT
DECLARE @l_AllowOracleSAPRegularFull INT = 0
SELECT @l_AllowOracleSAPRegularFull = isnull(value, 1)
FROM MMConfigs WITH(NOLOCK)
WHERE name = 'DA_CONFIG_HONOR_EXTENDED_RETENTION_FOR_ORACLE_SAP_REGULAR_FULL_JOBS'
SELECT	@defCopyId = case when @bSnapCopy = 0 then defaultCopy else defaultSnapCopy end,
		@agroupType = type, @agroupFlags = flags, @spTZType = TimeZoneType
FROM	archGroup WITH (NOLOCK)
WHERE	id = @agroupId
IF @i_copyId = @defCopyId
   GOTO OUTPUT_EXIT
IF @srcCopyId = 0
   SET @srcCopyId = @defCopyId
--This is a new change. JobSelectionType property should be set in the MMEntityProp table and value should correspond to the backuplevel
--FULL = 0x1,INCR = 0x2,DIFFERENTIAL = 0x4,ANYLEVEL = 0x8,SYNTHETIC_FULL = 0x40,INCR_NOTRUNC = 0x100,SYNTHETIC_FULL_AND_INCR = 0x80,ASR = 0x200,SEL_OFFLINE_FULL = 0x400,
--SNAPSHOTBKP = 0x800, CREATEREPLICABKP = 0x1000,SYNTHETIC_FULL_AND_INCR_BEFORE = 0x4000,SEL_ONLINE_FULL = 0x8000
SELECT @NonFullBkpTypes = ISNULL(intVal, 0) FROM MMEntityProp WHERE propertyName = 'JobSelectionType' AND EntityId = @i_copyId and EntityType = 2 AND propDataType = 1
/*
IF @agroupType = 2
BEGIN
	-- For DR storage policy --
	INSERT	INTO JMJobDataStats
	SELECT	A.jobId, A.archGrpId, @i_copyId, A.dataType, 13, 0, 101, 0, A.appId, A.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
	FROM	JMJobDataStats A, JMAdminJobStatsTable B WITH (NOLOCK)
	WHERE	A.jobId = B.jobId AND A.archGrpCopyId = @srcCopyId AND A.commCellId = B.commCellId
		AND (A.status = 100 OR A.status IN (101, 102, 103) AND @srcCopyId <> @defCopyId)
AND (A.disabled & (1 + 256)) = 0
		AND B.status IN (1, 3, 14) AND B.servStart >= @effDate AND B.servStart < @endDate
	SELECT @rowsInserted = @rowsInserted + @@ROWCOUNT
	GOTO OUTPUT_EXIT
END
*/
--Pick erase data jobs if any available for the copy
IF EXISTS (SELECT 1 FROM JMAdminJobStatsTable WITH(NOLOCK) WHERE archGrpID = @i_archGroupId AND opType = 44) -- BROWSEANDDELETE = 44
BEGIN
	INSERT INTO JMJobDataStats
	OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
	INTO #tblSelectedJobs
	SELECT	A.jobId, A.archGrpId, @i_copyId, A.dataType, 13, 0, 101, 0, A.appId, A.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
	FROM	JMJobDataStats A WITH(NOLOCK) INNER JOIN JMAdminJobStatsTable B WITH (NOLOCK) ON A.jobId = B.jobId AND A.commCellId = B.commCellId AND A.archGrpCopyId = @srcCopyId
			LEFT OUTER JOIN JMJobDataStats C WITH(NOLOCK) ON A.jobId = C.jobId AND A.commcellId = C.commcellId AND A.dataType = C.dataType AND C.archGrpCopyId = @i_copyId
	WHERE	B.opType = 44 /* BROWSEANDDELETE = 44  */ AND (A.status = 100 OR A.status IN (101, 102, 103) AND @srcCopyId <> @defCopyId)
AND (A.disabled & (1 + 256)) = 0
		AND B.status IN (1, 3, 14) AND B.servStart >= @effDate AND B.servStart < @endDate
		AND C.jobId is null
	SELECT @rowsInserted = @rowsInserted + @@ROWCOUNT
END
					-- For synchronous copies --
-- To fix the following issue
-- If the date was moved backward on the copy policy tab
-- We were not selecting jobs for subclients if the latest jobs selected start time is greater than
-- the new time selected
-- get jobs on default copies
/*
SELECT B.jobId, B.commCellId, B.appId, B.appType, B.bkpLevel, B.servStartDate
INTO   #tempBkp
FROM   #latestJobForApp A, JMBkpStats B WITH (NOLOCK), APP_iDAType I WITH (NOLOCK)
WHERE  I.type = B.appType AND B.appId = A.appId AND B.status IN (1, 3, 14)
	AND B.bkpLevel <> 512 AND B.servStartDate > A.servStartDate
*/
IF OBJECT_ID('tempdb..#tempBkp') IS NOT NULL
	DROP TABLE #tempBkp
CREATE TABLE #tempBkp(jobId int, commcellId int, appId int, bkpLevel int, servStartDate int)
IF @copyType = 2 --If this copy is selective copy process only index backups with synchronous rules
BEGIN
	DECLARE @selType INTEGER
	DECLARE @nPeriod INTEGER
	DECLARE @dayNum  INTEGER
	DECLARE @nEvent  INTEGER
	DECLARE @l_startPeriod		INTEGER
	DECLARE @l_nextPeriod		INTEGER
	DECLARE @l_prevPeriodBegin	INTEGER
	DECLARE @l_nextPeriodEnd	INTEGER
	SELECT	@selType = type, @nPeriod = numPeriod, @dayNum = dayNumber, @nEvent = startPeriod,
			@l_startPeriod = startPeriod, @l_nextPeriod = nextPeriod, @l_prevPeriodBegin = prevPeriodBegin, @l_nextPeriodEnd = nextPeriodEnd
	FROM	archSelectiveCopy WHERE copyId = @i_copyId
	--Manual selective still stays as manual selective copy for index backups, unless a config param is set
	DECLARE @pickIndexBackupToManualSelectiveCopy INT = 0
	SELECT @pickIndexBackupToManualSelectiveCopy = value FROM MMConfigs WITH(NOLOCK) WHERE name = 'AUXCOPY_AUTOPICK_INDEXBACKUPS_ON_MANUAL_SELECTION_COPIES'
IF (@selType NOT IN (9, 8)) OR (@pickIndexBackupToManualSelectiveCopy = 1)
	BEGIN
		DECLARE @l_checkSumIndexSubclient INT = CHECKSUM(N'Index SubClient')
		DECLARE @indexAppIdList table(appId int)
		INSERT INTO @indexAppIdList
		SELECT distinct componentNameId
		FROM App_SubclientProp WITH(NOLOCK)
		WHERE cs_attrName = @l_checkSumIndexSubclient
		AND attrName = 'Index SubClient' AND attrVal = N'1' AND modified = 0
		INSERT INTO #tempBkp
		SELECT B.jobId, B.commCellId, B.appId, /*B.appType,*/ B.bkpLevel, B.servStartDate
		FROM   APP_iDAType I WITH (NOLOCK), JMBkpStats B WITH (NOLOCK) LEFT OUTER JOIN JMJobDataStats A WITH (NOLOCK) ON B.JobID = A.JobID AND B.CommCellID = A.CommCellID  AND A.archGrpCopyId = @i_copyId
		WHERE  I.type = B.appType AND B.status IN (1, 3, 14)
			AND B.bkpLevel <> 512 AND B.servStartDate >= @effDate AND B.servStartDate < @endDate
			AND A.JobID IS NULL
			AND B.appId IN(SELECT appId FROM @indexAppIdList)
	END
	IF NOT EXISTS(SELECT 1 FROM #tempBkp)
		GOTO SPARSE
END
ELSE
BEGIN
	INSERT INTO #tempBkp
	SELECT B.jobId, B.commCellId, B.appId, /*B.appType,*/ B.bkpLevel, B.servStartDate
	FROM   APP_iDAType I WITH (NOLOCK), JMBkpStats B WITH (NOLOCK) LEFT OUTER JOIN JMJobDataStats A WITH (NOLOCK) ON B.JobID = A.JobID AND B.CommCellID = A.CommCellID  AND A.archGrpCopyId = @i_copyId
	WHERE  I.type = B.appType AND B.status IN (1, 3, 14)
		AND B.bkpLevel <> 512 AND B.servStartDate >= @effDate AND B.servStartDate < @endDate
		AND A.JobID IS NULL
	INSERT INTO #tempBkp
	SELECT B.jobId, B.commCellId, B.appID, /*1000,*/ B.ER_BkpLevel, B.servStart
	FROM   JMAdminJobStatsTable B WITH (NOLOCK)  LEFT OUTER JOIN JMJobDataStats A WITH (NOLOCK) ON B.JobID = A.JobID AND B.CommCellID = A.CommCellID AND A.archGrpCopyId = @i_copyId
	WHERE  /*A.appId = B.appID AND*/ B.status IN (1, 3, 14) AND B.servStart >= @effDate AND B.servStart < @endDate
		AND B.opType IN (11, 64) AND B.archGrpID = @agroupId -- enum CVOpType{ INFOMGMT = 64 CSDRBKP = 11
	    AND A.jobId is null
END
IF	@bSnapCopy <> 0
BEGIN
	DELETE	#tempBkp
	FROM	SMVolume V WITH (READUNCOMMITTED), SMVolSnapMap VS WITH (READUNCOMMITTED), SMSnap S WITH (READUNCOMMITTED), SMSnapShotEngine E WITH (READUNCOMMITTED)
	WHERE	#tempBkp.jobId = V.jobId AND #tempBkp.commCellId = V.commCellId
		AND VS.SMVolumeId = V.SMVolumeId AND S.SMSnapId = VS.SMSnapId
		AND S.SnapShotEngineId = E.SnapShotEngineId
AND ((( @t_extendedFlags & (256 | 512)) = (256 | 512) AND (E.Capabilities & 268435456) = 0)
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND @bMirrorCopy = 1 AND (E.Capabilities & 1073741824) = 0)
OR (( @t_extendedFlags & (256 | 512 | 524288)) = (256 | 512) AND (E.Capabilities & CAST(4294967296 AS BIGINT)) = 0)
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND @srcCopyId != @defCopyId AND (E.Capabilities & CAST(34359738368 AS BIGINT)) = 0)
OR (( @t_extendedFlags & (256 | 512)) = 256)
OR (( @t_extendedFlags &  (256 | 512)) = 0 AND (S.SnapShotEngineId NOT IN (3, 48))))
	DELETE	#tempBkp
	FROM	#tempBkp T, JMVSAAppJobLink J WITH (READUNCOMMITTED)
				LEFT OUTER JOIN  SMVolume V WITH (READUNCOMMITTED)
					ON V.jobId = J.parentJobId AND V.commCellId = J.CommCellId
				LEFT OUTER JOIN SMVolSnapMap VS WITH (READUNCOMMITTED)
					ON VS.SMVolumeId = V.SMVolumeId
				LEFT OUTER JOIN SMSnap S WITH (READUNCOMMITTED)
					ON S.SMSnapId = VS.SMSnapId
				LEFT OUTER JOIN SMSnapShotEngine E WITH (READUNCOMMITTED)
					ON S.SnapShotEngineId = E.SnapShotEngineId
	WHERE	J.childJobId = T.JobId AND J.commCellId = T.CommCellId
			AND NOT EXISTS (SELECT * FROM JMJobDataStats JDS WHERE JDS.JobId =  J.ParentJobId AND JDS.CommCellId = J.CommCellId AND JDS.archGrpCopyId = @i_copyId AND JDS.dataType != 6 AND JDS.Status != 100)
			-- AND NOT EXISTS (SELECT TOP 1 SMVolumeID FROM SMVolume V2 WITH (READUNCOMMITTED) WHERE V2.jobId = J.parentJobId AND V2.commCellId = J.CommCellId AND V2.CopyId = @i_copyId)
			AND (V.SMVolumeId IS NULL
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND (E.Capabilities & 268435456) = 0)
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND @bMirrorCopy = 1 AND (E.Capabilities & 1073741824) = 0)
OR (( @t_extendedFlags & (256 | 512 | 524288)) = (256 | 512) AND (E.Capabilities & CAST(4294967296 AS BIGINT)) = 0)
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND @srcCopyId != @defCopyId AND (E.Capabilities & CAST(34359738368 AS BIGINT)) = 0)
OR (( @t_extendedFlags & (256 | 512)) = 256)
OR (( @t_extendedFlags &  (256 | 512)) = 0 AND (S.SnapShotEngineId NOT IN (3))))
END
IF	EXISTS (SELECT 1 FROM archCopyToApp WITH (NOLOCK) WHERE copyId = @i_copyId AND assocType <> 2)
BEGIN
	INSERT INTO #archCopyToAppId
	SELECT DISTINCT @i_copyId , appId
	FROM #tempBkp
	EXEC archGetArchCopyToAppAssociations @i_copyId
	DELETE	#tempBkp
	FROM	#tempBkp LF LEFT JOIN #archCopyToAppId t ON t.appId = LF.appId AND t.copyID = @i_copyID
	WHERE	t.appId IS NULL
END
/* Instead of deleting jobs that have a datatype that is not copyable, pick the jobs that have at lease one datatype copyable
DELETE #tempBkp
FROM   #tempBkp B, JMJobDataStats J WITH (NOLOCK)
WHERE  (J.status NOT IN (100, 101, 102, 103)
		OR @srcCopyId = @defCopyId AND J.status <> 100
OR (J.disabled & (1 + 256)) <> 0)
   AND J.jobId = B.jobId
   AND J.archGrpCopyId = @srcCopyId
   AND J.commCellId = B.commCellId
*/
DELETE #tempBkp
FROM #tempBkp B LEFT OUTER JOIN JMJobDataStats J WITH (NOLOCK)
ON J.jobId = B.jobId
   AND J.commCellId = B.commCellId
   AND J.archGrpCopyId = @srcCopyId
   AND J.status IN (100, 101, 102, 103)
   AND (@srcCopyId <> @defCopyId OR J.status = 100)
AND (J.disabled & (1 + 256)) = 0
WHERE J.jobId IS NULL
-- For DDB Backups do not insert into any destination copy for auxcopy
INSERT INTO #tmpAppIdList
SELECT distinct appId, 0, 0, 0, 0
FROM #tempBkp
--Set unsupported flag
EXEC ArchIsAuxiliaryCopySupportedForSubclient 0
DELETE #tempBkp
FROM   #tempBkp B, #tmpAppIdList T WITH (NOLOCK)
WHERE	T.AppId = B.AppId
		AND T.unSupportedAlways = 1
/*
SELECT B.jobId, B.commCellId, B.appType
INTO   #tempJob
FROM   #latestJobForApp A, #tempBkp B
WHERE  B.appId = A.appId AND B.servStartDate > A.servStartDate
INSERT INTO JMJobDataStats
OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
INTO #tblSelectedJobs
SELECT J.jobId, J.archGrpId, @i_copyId, J.dataType, 13, 0, 101, 0, J.appId, J.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
FROM   JMJobDataStats J, #tempJob T
WHERE  J.jobId = T.jobId AND J.archGrpCopyId = @srcCopyId AND J.commCellId = T.commCellId
AND (J.dataType = 2 OR @copyType <> 4)
*/
INSERT INTO JMJobDataStats
OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
INTO #tblSelectedJobs
SELECT J.jobId, J.archGrpId, @i_copyId, J.dataType, 13, 0, 101, 0, J.appId, J.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
FROM   JMJobDataStats J, #tempBkp T, APP_Application A WITH (READUNCOMMITTED)
WHERE  J.jobId = T.jobId AND J.archGrpCopyId = @srcCopyId AND J.commCellId = T.commCellId
AND (J.dataType = 2 OR @copyType <> 4) AND J.status IN (100, 101, 102, 103)
	AND J.appId = A.id
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR A.appTypeId != 81)
SELECT @rowsInserted = @rowsInserted + @@ROWCOUNT
IF @copyType = 1 AND EXISTS (SELECT VALUE FROM MMConfigs WITH (READUNCOMMITTED) WHERE name = 'MMCONFIG_PICK_ALL_JOBS_IN_CYCLE_TO_SYNC_COPY' AND Value = 1)
BEGIN
	IF (OBJECT_ID('tempdb.dbo.#tblAppIdFullCycle') IS NOT NULL) DROP TABLE #tblAppIdFullCycle
	CREATE TABLE #tblAppIdFullCycle (appId INT, fullCycleNum INT, destCopyId INT, srcCopyId INT)
	INSERT INTO #tblAppIdFullCycle (appId, fullCycleNum, destCopyId, srcCopyId)
	SELECT	DISTINCT JBS.AppId, JBS.fullCycleNum, TJ.copyId, (CASE WHEN AGC.sourceCopyId > 0 THEN AGC.sourceCopyId WHEN AGC.isSnapCopy > 0 THEN AG.defaultSnapCopy ELSE AG.defaultCopy END)
	FROM	#tblSelectedJobs TJ
			INNER JOIN JMBkpStats JBS WITH (READUNCOMMITTED) ON TJ.JobId = JBS.JobID AND TJ.CommCellId = JBS.CommCellId
			INNER JOIN archGroupCopy AGC WITH (READUNCOMMITTED) ON TJ.copyId = AGC.id
			INNER JOIN archGroup AG WITH (READUNCOMMITTED) ON AGC.archGroupId = AG.id
WHERE	AGC.type = 1
			AND AGC.isSnapCopy = 0
	IF OBJECT_ID('tempdb.dbo.#subclientDaysRetention') IS NOT NULL DROP TABLE #subclientDaysRetention
	CREATE TABLE #subclientDaysRetention (
							appId INT PRIMARY KEY,
							daysOnlyRetention INT NULL
							)
	INSERT INTO #subclientDaysRetention
	SELECT	DISTINCT AppId, 0
	FROM	#tblAppIdFullCycle
	EXEC getDaysOnlyRetentionSubclient
	UPDATE	S
	SET		daysOnlyRetention = 1
	FROM	#subclientDaysRetention S, APP_Application App WITH (READUNCOMMITTED), APP_IDATypeHandlingInfo H WITH (READUNCOMMITTED)
	WHERE	S.AppId = APP.id
			AND S.daysOnlyRetention = 0
			AND APP.AppTypeId = H.AppTypeId
			AND H.IsDMAppType = 1
	DELETE	A
	FROM	#tblAppIdFullCycle A, #subclientDaysRetention S
	WHERE	A.AppId = S.AppId
			AND S.daysOnlyRetention = 1
	INSERT INTO JMJobDataStats
	OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
	INTO #tblSelectedJobs
	SELECT	DISTINCT JDS.jobId, JDS.archGrpId, A.destCopyId, JDS.dataType, 13, 0, 101, 0, JDS.appId,
			JDS.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
	FROM	#tblAppIdFullCycle A
			INNER JOIN JMBkpStats JBS WITH (READUNCOMMITTED) ON A.AppId = JBS.AppId AND A.fullCycleNum = JBS.fullCycleNum
			INNER JOIN JMJobDataStats JDS WITH (READUNCOMMITTED) ON JBS.JobID = JDS.jobId AND JBS.commCellId = JDS.commCellId AND A.srcCopyId = JDS.archGrpCopyId
			LEFT OUTER JOIN JMJobDataStats JDSD WITH (READUNCOMMITTED) ON JDS.JobID = JDSD.jobId AND JDS.commCellId = JDSD.commCellId AND A.destCopyId = JDSD.archGrpCopyId AND JDS.dataType = JDSD.dataType
	WHERE	JDS.status IN (100, 101, 102, 103)
			AND (JDS.disabled & 257) = 0
			AND JDSD.JobId IS NULL
	IF (OBJECT_ID('tempdb.dbo.#tblAppIdFullCycle') IS NOT NULL) DROP TABLE #tblAppIdFullCycle
	IF OBJECT_ID('tempdb.dbo.#subclientDaysRetention') IS NOT NULL DROP TABLE #subclientDaysRetention
END
--If this is a synchronous copy we have nothing more to do. Exit.
IF @copyType <> 2
	GOTO OUTPUT_EXIT
SPARSE:
-- For selective copies
SELECT	appId, MAX(jobId) AS jobId
INTO	#latestJobForAppSrcCopy
FROM	JMJobDataStats WITH (NOLOCK)
WHERE	archGrpCopyId = @srcCopyId
	AND (status = 100 OR status IN (101, 102, 103) AND @srcCopyId <> @defCopyId)
AND (disabled & (1 + 256)) = 0
GROUP BY appId
IF	EXISTS (SELECT 1 FROM archCopyToApp WITH (NOLOCK) WHERE copyId = @i_copyId AND assocType <> 2)
BEGIN
	DELETE #archCopyToAppId
	INSERT INTO #archCopyToAppId
	SELECT DISTINCT @i_copyId , appId
	FROM #latestJobForAppSrcCopy
	EXEC archGetArchCopyToAppAssociations @i_copyId  -- We need to call this again
	DELETE	#latestJobForAppSrcCopy
	FROM	#latestJobForAppSrcCopy LF LEFT JOIN #archCopyToAppId t ON t.appId = LF.appId AND t.copyID = @i_copyID
	WHERE	t.appId IS NULL
END
SELECT appId, MAX(jobId) AS jobId
INTO   #latestJobForAppAuxCopy
FROM   JMJobDataStats WITH (NOLOCK)
WHERE  archGrpCopyId = @i_copyId
AND dataType = 1
GROUP BY appId
/*
Idea is to process only the subclients which has newer jobs in source copy than the jobs already in the auxcopy for the particular subclient
So for all the subclients in source copy get the AppId and get the max jobId(or 0 when no job is copied into auxcopy yet),
if the jobId in auxcopy is older than those in source copy
*/
SELECT A.appId, ISNULL((SELECT jobId FROM #latestJobForAppAuxCopy WHERE appId = A.appId), 0) AS jobId,
	   @effDate AS servStartDate, 0 AS fullCycleNum
INTO   #latestJobForApp
FROM   #latestJobForAppSrcCopy A
WHERE  NOT EXISTS (SELECT * FROM #latestJobForAppAuxCopy WHERE appId = A.appId AND jobId >= A.jobId)
if (OBJECT_ID('tempdb.dbo.#latestJobForAppSrcCopy') IS NOT NULL) DROP TABLE #latestJobForAppSrcCopy
if (OBJECT_ID('tempdb.dbo.#latestJobForAppAuxCopy') IS NOT NULL) DROP TABLE #latestJobForAppAuxCopy
UPDATE #latestJobForApp SET servStartDate = B.servStartDate, fullCycleNum = B.fullCycleNum
FROM   #latestJobForApp A, JMBkpStats B WITH (NOLOCK)
WHERE  A.jobId = B.jobId AND A.appId = B.appId AND B.servStartDate >= @effDate AND B.servStartDate < @endDate
UPDATE #latestJobForApp SET servStartDate = B.servStart, fullCycleNum = B.fullCycleNum
FROM   #latestJobForApp A, JMAdminJobStatsTable B WITH (NOLOCK)
WHERE  A.jobId = B.jobId AND A.appId = B.appID AND B.servStart >= @effDate AND B.servStart < @endDate
IF @selType IN (8, 9)
   GOTO OUTPUT_EXIT
TRUNCATE TABLE #tmpAppIdList
INSERT INTO #tmpAppIdList
SELECT distinct appId, 0, 0, 0, 0
FROM #latestJobForApp
--Set unsupported flag
EXEC ArchIsAuxiliaryCopySupportedForSubclient 0
--Do not process DDB subclient, index subclients etc for selective copy
DELETE #latestJobForApp
FROM   #latestJobForApp J INNER JOIN #tmpAppIdList T ON J.appId = T.appId AND (T.unSupportedAlways > 0 OR T.unSupportedOnSelAlways > 0)
--Index appIds are processed as part of synchronous copy logic so skip them here
DELETE #tmpAppIdList WHERE unSupportedAlways > 0 OR unSupportedOnSelAlways > 0 OR appId IN (SELECT appId FROM @indexAppIdList)
-- Update with latest last full backup job on subclient
UPDATE	#latestJobForApp
SET		JobID = J.jobId,
		servStartDate = J.servStartDate
FROM	#latestJobForApp A, JMBkpStats J
WHERE	A.appId = J.appId
		AND A.fullCycleNum = J.fullCycleNum
		AND J.JobId <> A.JobId
		AND J.cycleSequence = 1
		AND J.status IN (1,3,14)
		AND J.bkpLevel IN (1, 64, 128, 16384, 1024, 32768)
		AND (@bSnapCopy = 0 OR NOT EXISTS (SELECT 1 FROM JMBkpStats B WHERE B.JobID = A.JobID AND B.AppId = A.AppId AND B.bkpLevel NOT IN (1, 64, 128, 16384, 1024, 32768)
										AND dbo.GetBkpLevelOfSnapJobs(B.JobId, B.CommCellId, @i_copyId) = 1))
/*
Populate the latest full job already picked in the aux copy and also the newer full jobs for the subclient which are eligible candidates for auxcopy into #tempFullBkp
*/
SELECT B.jobId, B.commCellId, B.appId, /*B.appType,*/ B.bkpLevel, B.servStartDate, B.fullCycleNum, 0 AS selected
INTO   #tempFullBkp
FROM   #tmpAppIdList T
	   INNER JOIN #latestJobForApp A ON A.appId = T.appId
	   INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.appId = A.appId AND B.servStartDate >= A.servStartDate AND B.servStartDate < @endDate
WHERE  (B.status IN (1, 14) OR (B.status = 3 AND T.isCWEjobValid = 1))
	AND (B.bkpLevel IN (1, 64, 128, 16384, 1024, 32768) OR (@bSnapCopy = 1 AND dbo.GetBkpLevelOfSnapJobs(B.JobId, B.CommCellId, @i_copyId) = 1) )
	-- Only take SEL_OFFLINE_FULL and SEL_ONLINE_FULL for Oracle
	AND (
B.appType NOT IN (2, 22, 23, 80,
61, 79)
		OR B.bkpLevel IN (1024, 32768)
OR (B.openChain = 0 AND (B.bkpAttributes & 0x1000) <> 0 AND @l_AllowOracleSAPRegularFull = 1 AND T.unSupportedDB = 0 /*AND B.bkpAttributes & @ORACLE_RMAN_CUSTOMSCRIPT_BKP = 0*/)
		)
	-- Only take FULL with data for SAP, Informix and DB2
AND (B.appType NOT IN (3, 5, 37, 62, 103, 128, 135) OR
B.openChain = 0 AND ((B.bkpAttributes & 0x1000) <> 0 OR B.appType IN (5, 135)))
	-- Index copy jobs do not insert into any destination copy for auxcopy
	AND (B.bkpAttributesEx & CAST(0x1000000000000 AS BIGINT)) = 0 --JMBKP_EX_BLR_INDEX_COPY_JOB
	-- Only take FULL with Attribute [JMBKP_EX_FULL_JOB_IN_CYCLE] for app aware app backups
	AND (
				(B.bkpAttributesEx & @EX_APPAWARE_CHILD_JOB = 0)
				OR
				(B.bkpAttributesEx & @EX_FULL_JOB_IN_CYCLE > 0)
			)
INSERT INTO #tempFullBkp
SELECT jobId, commCellId, appID, /*1000,*/ ER_BkpLevel, servStart, fullCycleNum, 0
FROM   JMAdminJobStatsTable WITH (NOLOCK)
WHERE  archGrpID = @agroupId AND opType IN (11,64) AND (status IN (1, 14) OR status = 3 AND @CountPartialDRSuccess = 1) AND ER_BkpLevel = 1 -- enum CVOpType{ INFOMGMT = 64 CSDRBKP = 11
   AND servStart >= (SELECT servStartDate FROM #latestJobForApp WHERE appId = JMAdminJobStatsTable.appID)
   AND servStart < @endDate
UPDATE #tempFullBkp SET selected = 1
FROM   #tempFullBkp A, #latestJobForApp B
WHERE  A.jobId = B.jobId AND A.appId = B.appId
/* Instead of deleting jobs that have a datatype that is not copyable, pick the jobs that have at lease one datatype copyable
DELETE #tempFullBkp
FROM   #tempFullBkp B, JMJobDataStats J WITH (NOLOCK)
WHERE  (J.status NOT IN (100, 101, 102, 103)
		OR @srcCopyId = @defCopyId AND J.status <> 100
OR (J.disabled & (1 + 256)) <> 0)
   AND J.jobId = B.jobId
   AND J.archGrpCopyId = @srcCopyId
   AND J.commCellId = B.commCellId
*/
DELETE #tempFullBkp
FROM #tempFullBkp B LEFT OUTER JOIN JMJobDataStats J WITH (NOLOCK)
ON J.jobId = B.jobId
   AND J.commCellId = B.commCellId
   AND J.archGrpCopyId = @srcCopyId
   AND J.status IN (100, 101, 102, 103)
   AND (@srcCopyId <> @defCopyId OR J.status = 100)
AND (J.disabled & (1 + 256)) = 0
WHERE J.jobId IS NULL AND B.selected = 0 /*For the jobs that are already selected don't check the status in source copy here*/
IF	@bSnapCopy <> 0
BEGIN
	DELETE	#tempFullBkp
	FROM	SMVolume V WITH (NOLOCK), SMVolSnapMap VS WITH (NOLOCK), SMSnap S WITH (NOLOCK), SMSnapShotEngine E WITH (READUNCOMMITTED)
	WHERE	#tempFullBkp.jobId = V.jobId AND #tempFullBkp.commCellId = V.commCellId
		AND VS.SMVolumeId = V.SMVolumeId AND S.SMSnapId = VS.SMSnapId
		AND S.SnapShotEngineId = E.SnapShotEngineId
AND ((( @t_extendedFlags & (256 | 512)) = (256 | 512) AND (E.Capabilities & 268435456) = 0)
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND @bMirrorCopy = 1 AND (E.Capabilities & 1073741824) = 0)
OR (( @t_extendedFlags & (256 | 512 | 524288)) = (256 | 512) AND (E.Capabilities & CAST(4294967296 AS BIGINT)) = 0)
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND @srcCopyId != @defCopyId AND (E.Capabilities & CAST(34359738368 AS BIGINT)) = 0)
OR (( @t_extendedFlags & (256 | 512)) = 256)
OR (( @t_extendedFlags &  (256 | 512)) = 0 AND (S.SnapShotEngineId NOT IN (3, 48))))
	DELETE	#tempFullBkp
	FROM	#tempFullBkp T, JMVSAAppJobLink J WITH (READUNCOMMITTED)
				LEFT OUTER JOIN  SMVolume V WITH (READUNCOMMITTED)
					ON V.jobId = J.parentJobId AND V.commCellId = J.CommCellId
				LEFT OUTER JOIN SMVolSnapMap VS WITH (READUNCOMMITTED)
					ON VS.SMVolumeId = V.SMVolumeId
				LEFT OUTER JOIN SMSnap S WITH (READUNCOMMITTED)
					ON S.SMSnapId = VS.SMSnapId
				LEFT OUTER JOIN SMSnapShotEngine E WITH (READUNCOMMITTED)
					ON S.SnapShotEngineId = E.SnapShotEngineId
	WHERE	J.childJobId = T.JobId AND J.commCellId = T.CommCellId
			AND NOT EXISTS (SELECT * FROM JMJobDataStats JDS WHERE JDS.JobId =  J.ParentJobId AND JDS.CommCellId = J.CommCellId AND JDS.archGrpCopyId = @i_copyId AND JDS.dataType != 6 AND JDS.Status != 100)
			-- AND NOT EXISTS (SELECT TOP 1 SMVolumeID FROM SMVolume V2 WITH (READUNCOMMITTED) WHERE V2.jobId = J.parentJobId AND V2.commCellId = J.CommCellId AND V2.CopyId = @i_copyId)
			AND (V.SMVolumeId IS NULL
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND (E.Capabilities & 268435456) = 0)
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND @bMirrorCopy = 1 AND (E.Capabilities & 1073741824) = 0)
OR (( @t_extendedFlags & (256 | 512 | 524288)) = (256 | 512) AND (E.Capabilities & CAST(4294967296 AS BIGINT)) = 0)
OR (( @t_extendedFlags & (256 | 512)) = (256 | 512) AND @srcCopyId != @defCopyId AND (E.Capabilities & CAST(34359738368 AS BIGINT)) = 0)
OR (( @t_extendedFlags & (256 | 512)) = 256)
OR (( @t_extendedFlags & (256 | 512)) = 0 AND (S.SnapShotEngineId NOT IN (3))))
END
IF @selType <> 1
   GOTO TIME_SPARSE
-- For cycle-based selective copies
--UPDATE #latestJobForApp SET fullCycleNum = (B.fullCycleNum + @nPeriod)
--FROM   #latestJobForApp A, #tempFullBkp B
--WHERE  A.jobId = B.jobId AND A.appId = B.appId
DECLARE getFullJobsForAppCopy CURSOR FOR
SELECT B.appId, B.jobId, B.commCellId, B.bkpLevel, B.fullCycleNum
FROM   #latestJobForApp A, #tempFullBkp B, JMJobDataStats J WITH (NOLOCK)
WHERE  B.selected = 0 AND B.appId = A.appId AND B.fullCycleNum >= A.fullCycleNum AND J.archGrpCopyId = @srcCopyId
   AND J.jobId = B.jobId AND J.commCellId = B.commCellId
   AND (J.status = 100 OR J.status IN (101, 102, 103) AND @srcCopyId <> @defCopyId)
AND (J.disabled & (1 + 256)) = 0
   AND NOT EXISTS (SELECT 1 FROM JMJobDataStats WHERE archGrpCopyId = @i_copyId AND commcellId = B.commCellId AND jobid = B.jobId)
GROUP BY B.appId, B.jobId, B.commCellId, B.bkpLevel, B.fullCycleNum
ORDER BY B.appId, B.fullCycleNum
DECLARE @t_appId		INTEGER
DECLARE @t_jobId		INTEGER
DECLARE @t_commCellId	INTEGER
DECLARE @t_bkpLevel		INTEGER
DECLARE @t_startDate	INTEGER
DECLARE @t_fullCycleNum	INTEGER
DECLARE @currAppId		INTEGER
DECLARE @currCycleNum	INTEGER
DECLARE @t_TimeZone		VARCHAR(255)
SET @currAppId       = 0
SET @currCycleNum    = 0
OPEN  getFullJobsForAppCopy
FETCH NEXT FROM getFullJobsForAppCopy
INTO  @t_appId, @t_jobId, @t_commCellId, @t_bkpLevel, @t_fullCycleNum
WHILE @@FETCH_STATUS = 0
BEGIN
      IF @t_appId <> @currAppId
      BEGIN
         SET @currAppId    = @t_appId
      END
IF ( (@nPeriod = 1) OR ((@copyFlags & 4096 ) = 0 AND (@t_fullCycleNum % @nPeriod) = 1) OR ((@copyFlags & 4096) <> 0 AND (@t_fullCycleNum % @nPeriod) = 0))
      BEGIN
       INSERT INTO JMJobDataStats
       OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
			 INTO #tblSelectedJobs
			 SELECT jobId, archGrpId, @i_copyId, dataType, 13, 0, 101, 0, appId, commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
			 FROM   JMJobDataStats JDS1 WITH (NOLOCK), APP_Application A WITH (READUNCOMMITTED)
			 WHERE  JDS1.jobId = @t_jobId AND JDS1.archGrpCopyId = @srcCopyId AND JDS1.commCellId = @t_commCellId
			 AND NOT EXISTS (SELECT 1 FROM JMJobDataStats JDS2 WITH(NOLOCK) WHERE JDS2.archGrpCopyId = @i_copyId AND JDS2.commcellId = JDS1.commCellId AND JDS2.jobid = JDS1.jobId)
			 AND JDS1.status IN (100, 101, 102, 103)
			AND JDS1.appId = A.id
AND (@SkipTransactionalLogs = 0 OR JDS1.dataType != 4 OR A.appTypeId != 81)
		 	 SELECT @rowsInserted = @rowsInserted + @@ROWCOUNT
			INSERT INTO JMJobDataStats
			OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
			INTO #tblSelectedJobs
			SELECT J.jobId, J.archGrpId, @i_copyId, J.dataType, 13, 0, 101, 0, J.appId, J.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
			FROM   JMJobDataStats J WITH (NOLOCK), JMJobDataLinkViewForDA A WITH (NOLOCK), APP_Application APP WITH (READUNCOMMITTED)
			WHERE  A.childJobId <> A.parentJobId
			   AND A.parentJobId = @t_jobId AND A.commCellId = @t_commCellId
			   AND J.jobId = A.childJobId
			   AND J.archGrpCopyId = @srcCopyId
			   AND J.commCellId = @t_commCellId
AND J.status IN (100, 101, 102, 103) AND (J.disabled & (1+256)) = 0
                           AND NOT EXISTS (SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK) WHERE JDS.archGrpCopyId = @i_copyId AND JDS.commcellId = J.commCellId AND JDS.jobid = J.jobId)
			   AND J.appId = APP.id
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR APP.appTypeId != 81)
			SELECT @rowsInserted = @rowsInserted + @@ROWCOUNT
			INSERT INTO JMJobDataStats
			OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
			INTO #tblSelectedJobs
			SELECT J.jobId, J.archGrpId, @i_copyId, J.dataType, 13, 0, 101, 0, J.appId, J.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
			FROM   JMJobDataStats J WITH (NOLOCK), JMVSAAppJobLink A WITH (NOLOCK), APP_Application APP WITH (READUNCOMMITTED)
			WHERE  A.childJobId <> A.parentJobId
			   AND A.childJobId = @t_jobId AND A.commCellId = @t_commCellId
			   AND J.jobId = A.parentJobId
			   AND J.archGrpCopyId = @srcCopyId
			   AND J.commCellId = @t_commCellId
AND J.status IN (100, 101, 102, 103) AND (J.disabled & (1+256)) = 0
                           AND NOT EXISTS (SELECT 1 FROM JMJobDataStats JDS WITH(NOLOCK) WHERE JDS.archGrpCopyId = @i_copyId AND JDS.commcellId = J.commCellId AND JDS.jobid = J.jobId)
			  AND J.appId = APP.id
AND (@SkipTransactionalLogs = 0 OR J.dataType != 4 OR APP.appTypeId != 81)
		SELECT @rowsInserted = @rowsInserted + @@ROWCOUNT
		IF @NonFullBkpTypes <> 0
		BEGIN
			--we can consider creating only once and just deleting the table for each db
			IF OBJECT_ID('tempdb.dbo.#tempNonFullBkp') IS NOT NULL DROP TABLE #tempNonFullBkp
			CREATE TABLE #tempNonFullBkp(jobId int, commcellId int, Primary Key(jobId, commcellId))
			INSERT #tempNonFullBkp
			SELECT JBS.jobId, JBS.commCellId
			FROM   JMBkpStats JBS WITH (NOLOCK)
			WHERE
			JBS.appId = @t_appId AND
			( (@NonFullBkpTypes = 1 AND ((JBS.bkpLevel & 4) <> 0 )) OR (@NonFullBkpTypes = 2 and (JBS.bkpLevel not in (1, 64, 128, 16384, 1024, 32768)))) AND
			JBS.commCellId = @t_commCellId AND
			JBS.fullCycleNum = @t_fullCycleNum
IF @@ROWCOUNT = 0 AND @agroupType = 2
			BEGIN
				INSERT #tempNonFullBkp
				SELECT JBS.jobId, JBS.commCellId
				FROM   JMAdminJobStatsTable JBS WITH (NOLOCK)
				WHERE
				JBS.appId = @t_appId AND
				( (@NonFullBkpTypes = 1 AND ((JBS.ER_BkpLevel & 4) <> 0 )) OR (@NonFullBkpTypes = 2 and (JBS.ER_BkpLevel not in (1, 64, 128, 16384, 1024, 32768)))) AND
				JBS.commCellId = @t_commCellId AND
				JBS.fullCycleNum = @t_fullCycleNum AND
				JBS.opType = 11 -- enum CVOpType{ CSDRBKP = 11
			END
			INSERT INTO JMJobDataStats
			OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
			INTO #tblSelectedJobs
			SELECT JDS.jobId, JDS.archGrpId, @i_copyId, JDS.dataType, 13, 0, 101, 0, JDS.appId, JDS.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
			FROM   JMJobDataStats JDS WITH (NOLOCK), #tempNonFullBkp NFBJ, APP_Application A WITH (READUNCOMMITTED)
			WHERE  NFBJ.jobId = JDS.jobId
				   AND NFBJ.commCellId = JDS.commcellId
				   AND JDS.archGrpCopyId = @srcCopyId
				   AND JDS.commCellId = @t_commCellId
AND JDS.status IN (100, 101, 102, 103) AND (JDS.disabled & (1+256)) = 0
				   AND NOT EXISTS (SELECT 1 FROM JMJobDataStats WHERE archGrpCopyId = @i_copyId AND commcellId = @t_commCellId AND jobid = NFBJ.jobId)
				   AND JDS.appId = A.id
AND (@SkipTransactionalLogs = 0 OR JDS.dataType != 4 OR A.appTypeId != 81)
			SELECT @rowsInserted = @rowsInserted + @@ROWCOUNT
		END
      END
	FETCH NEXT FROM getFullJobsForAppCopy
      INTO  @t_appId, @t_jobId, @t_commCellId, @t_bkpLevel, @t_fullCycleNum
END
CLOSE getFullJobsForAppCopy
DEALLOCATE getFullJobsForAppCopy
if (OBJECT_ID('tempdb.dbo.#latestJobForApp') IS NOT NULL) DROP TABLE #latestJobForApp
if (OBJECT_ID('tempdb.dbo.#tempFullBkp') IS NOT NULL) DROP TABLE #tempFullBkp
IF OBJECT_ID('tempdb.dbo.#tempNonFullBkp') IS NOT NULL DROP TABLE #tempNonFullBkp
GOTO OUTPUT_EXIT
TIME_SPARSE:
-- For time-based selective copies
/*
INSERT INTO #tempFullJobData
SELECT B.appId, 0, B.jobId, B.commCellId, B.servStartDate, B.selected, ''
FROM   #tempFullBkp B, JMJobDataStats J WITH (NOLOCK)
WHERE  B.servStartDate >= @effDate
		AND B.servStartDate < @endDate
		AND J.jobId = B.jobId
		AND J.archGrpCopyId = @srcCopyId
		AND J.commCellId = B.commCellId
AND @selType IN (10, 3, 2, 4, 6)
		AND (J.status = 100 OR J.status IN (101, 102, 103) AND @srcCopyId <> @defCopyId)
AND (J.disabled & (1 + 256)) = 0
GROUP BY B.appId, B.jobId, B.commCellId, B.servStartDate, B.selected
*/
INSERT INTO #tempFullJobData
SELECT B.appId, 0, B.jobId, B.commCellId, B.servStartDate, B.selected, ''
FROM #tempFullBkp B
LEFT OUTER JOIN JMJobDataStats JS WITH (NOLOCK) ON JS.jobId = B.jobId
	AND JS.archGrpCopyId = @srcCopyId
	AND JS.commCellId = B.commCellId
LEFT OUTER JOIN JMJobDataStats JD WITH (NOLOCK) ON JD.jobId = B.jobId
	AND JD.archGrpCopyId = @i_copyId
	AND JD.commCellId = B.commCellId
	AND B.selected = 1
	AND JD.status = 100
AND (JD.disabled & 256) = 0
WHERE @selType IN (10, 3, 2, 4, 6)
GROUP BY B.appId, B.jobId, B.commCellId, B.servStartDate, B.selected
HAVING MIN(
		CASE WHEN (
				b.servstartdate >= @effdate
				AND b.servStartDate < @endDate
				AND
				(JD.jobid is not null or
(JS.jobId is not null AND (JS.status = 100 or JS.status in (101, 102, 103) and @srccopyid <> @defcopyid) and (JS.disabled & (1 + 256)) = 0)
				))
				THEN 1
				ELSE 0
				END
		) = 1
SET @csTimeZone = dbo.GetClientTimeZone(2)
IF @spTZType = 1
BEGIN
	UPDATE	#tempFullJobData SET clientId = A.clientId
	FROM	APP_Application A WITH (NOLOCK)
	WHERE	appId = A.id
	if (OBJECT_ID('tempdb.dbo.#tempClient') IS NOT NULL) DROP TABLE #tempClient
	CREATE TABLE #tempClient (clientId int, TimeZone varchar(255))
	INSERT	INTO #tempClient
	SELECT	T.clientId, dbo.ArchGroupTimeZone(@i_archGroupId, T.clientId)
	FROM	(SELECT DISTINCT clientId FROM #tempFullJobData) T
	UPDATE	#tempFullJobData SET TimeZone = C.TimeZone
	FROM	#tempClient C
	WHERE	#tempFullJobData.clientId = C.clientId AND C.TimeZone <> @csTimeZone
	if (OBJECT_ID('tempdb.dbo.#tempClient') IS NOT NULL) DROP TABLE #tempClient
END
ELSE
IF @spTZType = 2
BEGIN
	SET	@t_TimeZone = dbo.ArchGroupTimeZone(@i_archGroupId, 0)
	IF	@t_TimeZone <> @csTimeZone
		UPDATE	#tempFullJobData SET TimeZone = @t_TimeZone
END
IF @spTZType <> 0
BEGIN
	UPDATE	#tempFullJobData
	SET		startDate = startDate + dbo.GetDiffFromCSTimeZone(startDate, TimeZone, @csTimeZone)
	WHERE	TimeZone <> ''
END
IF (@copyFlags & 4096) = 4096
BEGIN
	DECLARE	@now INT
	SET		@now = dbo.GetUnixTime(GETUTCDATE())
IF (@copyFlags & 8192) = 0
	BEGIN
		DECLARE	@nextFullTime INT
		SET @currAppId		= 0
		SET @t_startDate	= 0
		DECLARE getLastFullJobsForApp CURSOR FOR
		SELECT	appId, MAX(startDate), TimeZone
		FROM	#tempFullJobData
		WHERE	selected = 0
		GROUP BY appId, TimeZone
		OPEN  getLastFullJobsForApp
		FETCH NEXT FROM getLastFullJobsForApp INTO @t_appId, @t_startDate, @t_TimeZone
		WHILE @@FETCH_STATUS = 0
		BEGIN
			DECLARE @l_runningJobId integer
			SET @l_runningJobId = 0
			SELECT  @l_runningJobId = RJ.jobId
			FROM    JMJobInfo RJ WITH (NOLOCK) INNER JOIN JMBkpJobInfo JInfo WITH (NOLOCK)
			ON 	 	RJ.jobId = JInfo.jobId AND RJ.commcellId = JInfo.commcellId
AND     JInfo.applicationId = @t_appId AND (JInfo.bkpLevel & 2) <> 0
      		IF (@l_runningJobId > 0)
      		BEGIN
				DECLARE @bkpLevelInJobOption int
				SET @bkpLevelInJobOption = 0
SELECT @bkpLevelInJobOption = dbo.GetJobOption(@l_runningJobId, 458405394 )
				/*
				If the backup level in JMBkpJobInfo is incremental and backup level in job option is synthetic full this is
				an incremental backup who is going to submit a synth full at its end
				*/
IF(@bkpLevelInJobOption =  4)
				BEGIN
						/*
							Postpone selection decision for current period until this current running incremental job is completed
							as there is a possibility he is going to submit a synth full for current period
						*/
						DELETE FROM #tempFullJobData
						WHERE appId = @t_appId AND startDate >= @l_startPeriod
						/*
							Need not do anything for this iteration if the above delete statement removed all the rows for this appId
						*/
						IF NOT EXISTS (SELECT 1 FROM #tempFullJobData WHERE appId = @t_appId)
							GOTO FETCH_NEXT
				END
	    	END
			DECLARE	@tblNextFullTime TABLE (nextFullTime int)
			INSERT	INTO @tblNextFullTime
			EXEC	@nextFullTime = TM_GetNextScheduleRunTime @t_appId, 1/*BkpLevel Full*/, 1/*counDisabled*/, 1/*countRunnigJob*/
			IF	@nextFullTime > 0 AND @t_TimeZone <> ''
				SET	@nextFullTime = @nextFullTime + dbo.GetDiffFromCSTimeZone(@nextFullTime, @t_TimeZone, @csTimeZone)
			IF (dbo.GetBkpLevelForSnapCopy(@t_appId, 2, @i_copyId) = 1)
			BEGIN
				DECLARE	@l_nextFullTimeForSnap INTEGER
				INSERT	INTO @tblNextFullTime
				EXEC @l_nextFullTimeForSnap = TM_GetNextScheduleRunTime @t_appId, 2/*BkpLevel Incr*/, 1/*counDisabled*/, 1/*countRunnigJob*/
				IF	@l_nextFullTimeForSnap > 0
					SET @l_nextFullTimeForSnap = @l_nextFullTimeForSnap + dbo.GetDiffFromCSTimeZone(@l_nextFullTimeForSnap, @t_TimeZone, @csTimeZone)
				IF (@l_nextFullTimeForSnap <> 0 AND (@l_nextFullTimeForSnap < @nextFullTime OR @nextFullTime = 0))
					SET @nextFullTime = @l_nextFullTimeForSnap
			END
			IF	@nextFullTime > 0 AND @nextFullTime < @l_prevPeriodBegin
			AND @t_startDate  < @l_prevPeriodBegin
				DELETE	FROM #tempFullJobData
				WHERE	appId = @t_appId
			ELSE
			IF	@nextFullTime >= @l_prevPeriodBegin AND @nextFullTime < @l_startPeriod
			AND @t_startDate  >= @l_prevPeriodBegin AND @t_startDate  < @l_startPeriod
				DELETE	FROM #tempFullJobData
				WHERE	appId = @t_appId AND startDate >= @l_prevPeriodBegin
			ELSE
			IF	@nextFullTime >= @l_startPeriod AND @nextFullTime < @l_nextPeriod
			AND @t_startDate  >= @l_startPeriod AND @t_startDate  < @l_nextPeriod
				DELETE	FROM #tempFullJobData
				WHERE	appId = @t_appId AND startDate >= @l_startPeriod
			ELSE
			IF	@nextFullTime >= @l_nextPeriod AND @nextFullTime < @l_nextPeriodEnd
			AND @t_startDate  >= @l_nextPeriod AND @t_startDate  < @l_nextPeriodEnd
				DELETE	FROM #tempFullJobData
				WHERE	appId = @t_appId AND startDate >= @l_nextPeriod
			ELSE
			IF	@nextFullTime >= @l_nextPeriodEnd
			AND @t_startDate  >= @l_nextPeriodEnd
				DELETE	FROM #tempFullJobData
				WHERE	appId = @t_appId AND startDate >= @l_nextPeriodEnd
			FETCH_NEXT:
			FETCH NEXT FROM getLastFullJobsForApp INTO @t_appId, @t_startDate, @t_TimeZone
		END
		CLOSE getLastFullJobsForApp
		DEALLOCATE getLastFullJobsForApp
	END
	ELSE
	BEGIN
		if (OBJECT_ID('tempdb.dbo.#ActiveFullStartDate') IS NOT NULL) DROP TABLE #ActiveFullStartDate
		CREATE	TABLE #ActiveFullStartDate (appId INT, startDate INT)
		INSERT	INTO #ActiveFullStartDate
		EXEC	MMS2startDateOfActiveBackupForApp @i_archGroupId
		UPDATE	#ActiveFullStartDate
		SET		startDate = A.startDate + dbo.GetDiffFromCSTimeZone(A.startDate, T.TimeZone, @csTimeZone)
		FROM	#ActiveFullStartDate A, (SELECT DISTINCT appId, TimeZone FROM #tempFullJobData WHERE TimeZone <> '') T
		WHERE	A.appId = T.appId
		DELETE	#tempFullJobData
		FROM	#tempFullJobData J, #ActiveFullStartDate A
		WHERE	J.appId = A.appId
			AND (	A.startDate <  @l_prevPeriodBegin AND J.startDate <  @l_prevPeriodBegin
				 OR	A.startDate >= @l_prevPeriodBegin AND J.startDate >= @l_prevPeriodBegin AND
					A.startDate <  @l_startPeriod     AND J.startDate <  @l_startPeriod
				 OR A.startDate >= @l_startPeriod     AND J.startDate >= @l_startPeriod     AND
					A.startDate <  @l_nextPeriod      AND J.startDate <  @l_nextPeriod
				 OR A.startDate >= @l_nextPeriod      AND J.startDate >= @l_nextPeriod      AND
					A.startDate <  @l_nextPeriodEnd   AND J.startDate <  @l_nextPeriodEnd
				 OR A.startDate >= @l_nextPeriodEnd   AND J.startDate >= @l_nextPeriodEnd	)
		if (OBJECT_ID('tempdb.dbo.#ActiveFullStartDate') IS NOT NULL) DROP TABLE #ActiveFullStartDate
		DELETE	#tempFullJobData
		WHERE	startDate >= @l_prevPeriodBegin AND (@now + dbo.GetDiffFromCSTimeZone(@now, TimeZone, @csTimeZone)) < @l_startPeriod
			OR	startDate >= @l_startPeriod     AND (@now + dbo.GetDiffFromCSTimeZone(@now, TimeZone, @csTimeZone)) < @l_nextPeriod
			OR	startDate >= @l_nextPeriod      AND (@now + dbo.GetDiffFromCSTimeZone(@now, TimeZone, @csTimeZone)) < @l_nextPeriodEnd
			OR	startDate >= @l_nextPeriodEnd
	END
END
ELSE
BEGIN
	IF EXISTS ( SELECT	1
				FROM	MMConfigs WITH (READUNCOMMITTED)
				WHERE	name = 'DA_CONFIG_EXTEND_RETAIN_LAST_FULL_JOB_OF_DECONFIGURED_CLIENT'
						AND Value = 1)
	BEGIN
		--Deconfigured Subclients, pick last job of appid on first full configured selective copies
		UPDATE	FJD
		SET		selected = 2
		FROM	#tempFullJobData FJD,
				(SELECT	FJ.appId, MAX(StartDate) MaxStartDate
				FROM	#tempFullJobData FJ,
						(SELECT	LA.AppId
						FROM	#latestJobForApp LA INNER JOIN APP_Application A WITH (READUNCOMMITTED) ON LA.AppId = A.Id
WHERE	(A.SubClientStatus & 0x00002) > 0) DA
				WHERE	FJ.appId = DA.appId
				GROUP BY FJ.appId) T
		WHERE	FJD.AppId = T.AppId
				AND FJD.startDate = T.MaxStartDate
				AND FJD.selected = 0
	END
END
if (OBJECT_ID('tempdb.dbo.#latestJobForApp') IS NOT NULL) DROP TABLE #latestJobForApp
if (OBJECT_ID('tempdb.dbo.#tempFullBkp') IS NOT NULL) DROP TABLE #tempFullBkp
OUTPUT_EXIT:
--Pick VSA parent job based on selected VM jobs
INSERT INTO JMJobDataStats
OUTPUT INSERTED.jobId, INSERTED.commcellId, INSERTED.archGrpCopyId, INSERTED.dataType
INTO #tblSelectedJobs
SELECT DISTINCT J.jobId, J.archGrpId, @i_copyId, J.dataType, 13, 0, 101, 0, J.appId, J.commCellId, 0, 0, 0, 0, 0, 0, 0, @i_modifyTime, 0, 0, 0, @i_modifyTime, 101, -1
FROM   JMJobDataStats J WITH (NOLOCK), JMJobDataLink A WITH (NOLOCK), #tblSelectedJobs T
WHERE  A.childJobId = T.JobId
AND 	 A.commCellId = T.commCellId
AND		 A.linkType IN (7, 8)
AND 	 J.jobId = A.parentJobId
AND 	 J.commCellId = A.commCellId
AND 	 J.archGrpCopyId = @srcCopyId
AND 	 J.status IN (100, 101, 102, 103)
AND 	 (J.disabled & (1+256)) = 0
AND 	 NOT EXISTS (SELECT 1 FROM JMJobDataStats JDS WITH (NOLOCK) WHERE JDS.archGrpCopyId = @i_copyId AND JDS.commcellId = J.commCellId AND JDS.jobid = J.jobId)
SELECT @rowsInserted = @rowsInserted + @@ROWCOUNT
--Apply job retention option (if applicable)
EXEC archPinJobsBasedOnJobOption 0
-- Output for selective copies
IF @i_order = 0
SELECT @srcCopyId, appId, jobId, commCellId, startDate, selected, 0
FROM   #tempFullJobData
ORDER BY appId ASC, jobId ASC
IF @i_order <> 0
SELECT @srcCopyId, appId, jobId, commCellId, startDate, selected, 0
FROM   #tempFullJobData
ORDER BY appId ASC, selected DESC, jobId DESC
IF @rowsInserted > 0
SELECT	0, 0, 0, 0, 0, 0, @rowsInserted
if (OBJECT_ID('tempdb.dbo.#tempFullJobData') IS NOT NULL) DROP TABLE #tempFullJobData
if (OBJECT_ID('tempdb.dbo.#tblSelectedJobs') IS NOT NULL) DROP TABLE #tblSelectedJobs
IF (OBJECT_ID('tempdb..#tmpAppIdList') IS NOT NULL) DROP TABLE #tmpAppIdList
if (OBJECT_ID('tempdb.dbo.#latestJobForAppSrcCopy') IS NOT NULL) DROP TABLE #latestJobForAppSrcCopy
if (OBJECT_ID('tempdb.dbo.#latestJobForAppAuxCopy') IS NOT NULL) DROP TABLE #latestJobForAppAuxCopy
if (OBJECT_ID('tempdb.dbo.#tempBkp') IS NOT NULL) DROP TABLE #tempBkp
if (OBJECT_ID('tempdb.dbo.#tempJob') IS NOT NULL) DROP TABLE #tempJob
IF OBJECT_ID('tempdb.dbo.#archCopyToAppId') IS NOT NULL DROP TABLE #archCopyToAppId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateToBeCopiedJobs')
	delete from GxQscripts where name = 'UpdateToBeCopiedJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateToBeCopiedJobs')
	delete from GXDBVersions where aliasname = 'UpdateToBeCopiedJobs'
GO

insert into GXDBVersions values(2, 'UpdateToBeCopiedJobs',  '00010114001200390000', 'UpdateToBeCopiedJobs', '00010114001200390000')
GO

