

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/UpdateSQLLoginCredentials.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: UpdateSQLLoginCredentials <<<'

IF EXISTS (select * from sysobjects where name='UpdateSQLLoginCredentials')
	drop procedure UpdateSQLLoginCredentials
IF EXISTS (select * from GxQscripts where name='UpdateSQLLoginCredentials')
	delete from GxQscripts where name = 'UpdateSQLLoginCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateSQLLoginCredentials')
	delete from GXDBVersions where aliasname = 'UpdateSQLLoginCredentials'
GO
print '... Creating Procedure: UpdateSQLLoginCredentials'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure UpdateSQLLoginCredentials
  @SQLAccessKeyEncr NVARCHAR(MAX)
AS
DECLARE @SQLAccessKey NVARCHAR(MAX)
EXEC miscProc2 @SQLAccessKeyEncr, @SQLAccessKey output
IF @SQLAccessKey IS NULL OR LEN (@SQLAccessKey) < 3
BEGIN
	RAISERROR ('Invalid SQL access key', 15, 1)
	RETURN
END
DECLARE @SQLUserNameLen INT = CONVERT (INT, SUBSTRING (@SQLAccessKey, 1, 2))
IF @SQLUserNameLen IS NULL OR @SQLUserNameLen = 0
BEGIN
	RAISERROR ('Invalid SQL access key. User name is malformed.', 15, 1)
	RETURN
END
DECLARE @SQLUserName NVARCHAR(MAX) = SUBSTRING (@SQLAccessKey, 3, @SQLUserNameLen)
IF @SQLUserName <> 'sqladmin_cv' AND @SQLUserName <> 'sqlexec_cv'
BEGIN
	RAISERROR ('Invalid SQL user', 15, 1)
	RETURN
END
DECLARE @SQLPass NVARCHAR(MAX) = SUBSTRING (@SQLAccessKey, 2 + @SQLUserNameLen + 1, LEN (@SQLAccessKey))
-- Executing the query directly gives out "Invalid syntax near @SQLPass"
-- Hence building the query as a string.
DECLARE @Query NVARCHAR(MAX)
SET @Query = 'ALTER LOGIN ' + @SQLUserName + ' WITH PASSWORD = ''' + @SQLPass + ''''
EXEC sp_executesql @Query
GO

IF EXISTS (select * from GxQscripts where name = 'UpdateSQLLoginCredentials')
	delete from GxQscripts where name = 'UpdateSQLLoginCredentials'
GO

IF EXISTS (select * from GXDBVersions where aliasname='UpdateSQLLoginCredentials')
	delete from GXDBVersions where aliasname = 'UpdateSQLLoginCredentials'
GO

insert into GXDBVersions values(2, 'UpdateSQLLoginCredentials',  '00000000000000000000', 'UpdateSQLLoginCredentials', '00000000000000000000')
GO

